/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import org.mozilla.classfile.DefiningClassLoader;
import org.mozilla.javascript.BinaryDigitReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.DToA;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdEnumeration;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

public class ScriptRuntime {
    public static final Class UndefinedClass = class$org$mozilla$javascript$Undefined != null ? class$org$mozilla$javascript$Undefined : (class$org$mozilla$javascript$Undefined = ScriptRuntime.class$("org.mozilla.javascript.Undefined"));
    public static final Class ScriptableClass = class$org$mozilla$javascript$Scriptable != null ? class$org$mozilla$javascript$Scriptable : (class$org$mozilla$javascript$Scriptable = ScriptRuntime.class$("org.mozilla.javascript.Scriptable"));
    public static final Class StringClass = class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ScriptRuntime.class$("java.lang.String"));
    public static final Class NumberClass = class$java$lang$Number != null ? class$java$lang$Number : (class$java$lang$Number = ScriptRuntime.class$("java.lang.Number"));
    public static final Class BooleanClass = class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ScriptRuntime.class$("java.lang.Boolean"));
    public static final Class ByteClass = class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = ScriptRuntime.class$("java.lang.Byte"));
    public static final Class ShortClass = class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = ScriptRuntime.class$("java.lang.Short"));
    public static final Class IntegerClass = class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = ScriptRuntime.class$("java.lang.Integer"));
    public static final Class LongClass = class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = ScriptRuntime.class$("java.lang.Long"));
    public static final Class FloatClass = class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = ScriptRuntime.class$("java.lang.Float"));
    public static final Class DoubleClass = class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = ScriptRuntime.class$("java.lang.Double"));
    public static final Class CharacterClass = class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = ScriptRuntime.class$("java.lang.Character"));
    public static final Class ObjectClass = class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ScriptRuntime.class$("java.lang.Object"));
    public static final Class FunctionClass = class$org$mozilla$javascript$Function != null ? class$org$mozilla$javascript$Function : (class$org$mozilla$javascript$Function = ScriptRuntime.class$("org.mozilla.javascript.Function"));
    public static final Class ClassClass = class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = ScriptRuntime.class$("java.lang.Class"));
    public static double NaN = Double.NaN;
    public static Double NaNobj = new Double(Double.NaN);
    public static double negativeZero = -0.0;
    private static final boolean MSJVM_BUG_WORKAROUNDS = true;
    private static final String GLOBAL_CLASS = "org.mozilla.javascript.tools.shell.Global";
    public static final Object[] emptyArgs = new Object[0];
    static /* synthetic */ Class class$org$mozilla$javascript$Undefined;
    static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$mozilla$javascript$Function;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$mozilla$javascript$NativeGlobal;
    static /* synthetic */ Class class$org$mozilla$javascript$NativeWith;
    static /* synthetic */ Class class$org$mozilla$javascript$NativeScript;
    static /* synthetic */ Class class$org$mozilla$javascript$Context;

    protected ScriptRuntime() {
    }

    public static Object add(Object object, Object object2) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(null);
        }
        if (object2 instanceof Scriptable) {
            object2 = ((Scriptable)object2).getDefaultValue(null);
        }
        if (!(object instanceof String) && !(object2 instanceof String)) {
            if (object instanceof Number && object2 instanceof Number) {
                return new Double(((Number)object).doubleValue() + ((Number)object2).doubleValue());
            }
            return new Double(ScriptRuntime.toNumber(object) + ScriptRuntime.toNumber(object2));
        }
        return String.valueOf(ScriptRuntime.toString(object)) + ScriptRuntime.toString(object2);
    }

    public static Scriptable bind(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        while (scriptable2 != null) {
            Scriptable scriptable3 = scriptable2;
            do {
                if (!scriptable3.has(string, scriptable2)) continue;
                return scriptable2;
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
            scriptable2 = scriptable2.getParentScope();
        }
        return null;
    }

    public static Object call(Context context, Object object, Object object2, Object[] objectArray) throws JavaScriptException {
        Scriptable scriptable = null;
        if (object instanceof Scriptable) {
            scriptable = ((Scriptable)object).getParentScope();
        }
        return ScriptRuntime.call(context, object, object2, objectArray, scriptable);
    }

    public static Object call(Context context, Object object, Object object2, Object[] objectArray, Scriptable scriptable) throws JavaScriptException {
        Function function;
        try {
            function = (Function)object;
        }
        catch (ClassCastException classCastException) {
            throw NativeGlobal.typeError1("msg.isnt.function", ScriptRuntime.toString(object), scriptable);
        }
        Scriptable scriptable2 = object2 instanceof Scriptable || object2 == null ? (Scriptable)object2 : ScriptRuntime.toObject(scriptable, object2);
        return function.call(context, scriptable, scriptable2, objectArray);
    }

    private static Object callOrNewSpecial(Context context, Scriptable scriptable, Object object, Object object2, Object object3, Object[] objectArray, boolean bl, String string, int n) throws JavaScriptException {
        if (object instanceof IdFunction) {
            IdFunction idFunction = (IdFunction)object;
            String string2 = idFunction.getFunctionName();
            if (string2.length() == 4) {
                if (string2.equals("eval")) {
                    if (idFunction.master.getClass() == (class$org$mozilla$javascript$NativeGlobal != null ? class$org$mozilla$javascript$NativeGlobal : (class$org$mozilla$javascript$NativeGlobal = ScriptRuntime.class$("org.mozilla.javascript.NativeGlobal")))) {
                        return NativeGlobal.evalSpecial(context, scriptable, object3, objectArray, string, n);
                    }
                } else if (string2.equals("With")) {
                    if (idFunction.master.getClass() == (class$org$mozilla$javascript$NativeWith != null ? class$org$mozilla$javascript$NativeWith : (class$org$mozilla$javascript$NativeWith = ScriptRuntime.class$("org.mozilla.javascript.NativeWith")))) {
                        return NativeWith.newWithSpecial(context, objectArray, idFunction, bl ^ true);
                    }
                } else if (string2.equals("exec")) {
                    if (idFunction.master.getClass() == (class$org$mozilla$javascript$NativeScript != null ? class$org$mozilla$javascript$NativeScript : (class$org$mozilla$javascript$NativeScript = ScriptRuntime.class$("org.mozilla.javascript.NativeScript")))) {
                        return ((NativeScript)object2).exec(context, ScriptableObject.getTopLevelScope(scriptable));
                    }
                    RegExpProxy regExpProxy = context.getRegExpProxy();
                    if (regExpProxy != null && regExpProxy.isRegExp(object2)) {
                        return ScriptRuntime.call(context, object, object2, objectArray, scriptable);
                    }
                }
            }
        } else if (object instanceof NativeJavaMethod) {
            return ScriptRuntime.call(context, object, object2, objectArray, scriptable);
        }
        if (bl) {
            return ScriptRuntime.call(context, object, object3, objectArray, scriptable);
        }
        return ScriptRuntime.newObject(context, object, objectArray, scriptable);
    }

    public static Object callSpecial(Context context, Object object, Object object2, Object[] objectArray, Scriptable scriptable, Scriptable scriptable2, String string, int n) throws JavaScriptException {
        return ScriptRuntime.callOrNewSpecial(context, scriptable2, object, object2, scriptable, objectArray, true, string, n);
    }

    static void checkDeprecated(Context context, String string) {
        int n = context.getLanguageVersion();
        if (n >= 140 || n == 0) {
            String string2 = ScriptRuntime.getMessage1("msg.deprec.ctor", string);
            if (n == 0) {
                Context.reportWarning(string2);
            } else {
                throw Context.reportRuntimeError(string2);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static int cmp_LE(Object object, Object object2) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (object2 instanceof Scriptable) {
            object2 = ((Scriptable)object2).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String) || !(object2 instanceof String)) {
            double d = ScriptRuntime.toNumber(object);
            if (d != d) {
                return 0;
            }
            double d2 = ScriptRuntime.toNumber(object2);
            if (d2 != d2) {
                return 0;
            }
            return d <= d2 ? 1 : 0;
        }
        return ScriptRuntime.toString(object).compareTo(ScriptRuntime.toString(object2)) <= 0 ? 1 : 0;
    }

    public static Boolean cmp_LEB(Object object, Object object2) {
        if (ScriptRuntime.cmp_LE(object, object2) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LT(Object object, Object object2) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (object2 instanceof Scriptable) {
            object2 = ((Scriptable)object2).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String) || !(object2 instanceof String)) {
            double d = ScriptRuntime.toNumber(object);
            if (d != d) {
                return 0;
            }
            double d2 = ScriptRuntime.toNumber(object2);
            if (d2 != d2) {
                return 0;
            }
            return d < d2 ? 1 : 0;
        }
        return ScriptRuntime.toString(object).compareTo(ScriptRuntime.toString(object2)) < 0 ? 1 : 0;
    }

    public static Boolean cmp_LTB(Object object, Object object2) {
        if (ScriptRuntime.cmp_LT(object, object2) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static NativeFunction createFunctionObject(Scriptable scriptable, Class clazz, Context context, boolean bl) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        NativeFunction nativeFunction = null;
        Object[] objectArray = new Object[]{scriptable, context};
        try {
            nativeFunction = (NativeFunction)constructorArray[0].newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw WrappedException.wrapException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrappedException.wrapException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WrappedException.wrapException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw WrappedException.wrapException(invocationTargetException);
        }
        nativeFunction.setPrototype(ScriptableObject.getClassPrototype(scriptable, "Function"));
        nativeFunction.setParentScope(scriptable);
        String string = nativeFunction.getFunctionName();
        if (bl && string != null && string.length() != 0 && !string.equals("anonymous")) {
            ScriptRuntime.setProp(scriptable, string, nativeFunction, scriptable);
        }
        return nativeFunction;
    }

    public static Object delete(Object object, Object object2) {
        String string = ScriptRuntime.getStringId(object2);
        boolean bl = string != null ? ScriptableObject.deleteProperty((Scriptable)object, string) : ScriptableObject.deleteProperty((Scriptable)object, ScriptRuntime.getIntId(object2));
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Scriptable enterWith(Object object, Scriptable scriptable) {
        return new NativeWith(scriptable, ScriptRuntime.toObject(scriptable, object));
    }

    public static boolean eq(Object object, Object object2) {
        Object object3 = object;
        Object object4 = object2;
        while (true) {
            Class clazz;
            Class clazz2;
            if ((clazz2 = ScriptRuntime.getTypeOfValue(object)) == (clazz = ScriptRuntime.getTypeOfValue(object2))) {
                if (clazz2 == UndefinedClass) {
                    return true;
                }
                if (clazz2 == NumberClass) {
                    return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
                }
                if (clazz2 == StringClass || clazz2 == BooleanClass) {
                    return object3.equals(object4);
                }
                if (clazz2 == ScriptableClass) {
                    if (object == object2) {
                        return true;
                    }
                    if (object instanceof Wrapper && object2 instanceof Wrapper) {
                        return ((Wrapper)object).unwrap() == ((Wrapper)object2).unwrap();
                    }
                    return false;
                }
                throw new RuntimeException();
            }
            if (object == null && object2 == Undefined.instance) {
                return true;
            }
            if (object == Undefined.instance && object2 == null) {
                return true;
            }
            if (clazz2 == NumberClass && clazz == StringClass) {
                return ((Number)object).doubleValue() == ScriptRuntime.toNumber(object2);
            }
            if (clazz2 == StringClass && clazz == NumberClass) {
                return ScriptRuntime.toNumber(object) == ((Number)object2).doubleValue();
            }
            if (clazz2 == BooleanClass) {
                object3 = object = new Double(ScriptRuntime.toNumber(object));
                continue;
            }
            if (clazz == BooleanClass) {
                object4 = object2 = new Double(ScriptRuntime.toNumber(object2));
                continue;
            }
            if ((clazz2 == StringClass || clazz2 == NumberClass) && clazz == ScriptableClass && object2 != null) {
                object4 = object2 = ScriptRuntime.toPrimitive(object2);
                continue;
            }
            if (clazz2 != ScriptableClass || object == null || clazz != StringClass && clazz != NumberClass) break;
            object3 = object = ScriptRuntime.toPrimitive(object);
        }
        return false;
    }

    public static Boolean eqB(Object object, Object object2) {
        if (ScriptRuntime.eq(object, object2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static RuntimeException errorWithClassName(String string, Object object) {
        return Context.reportRuntimeError1(string, object.getClass().getName());
    }

    public static String escapeString(String string) {
        String string2 = "\bb\ff\nn\rr\tt\u000bv\"\"''";
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= ' ' && c <= '~' && c != '\"') {
                stringBuffer.append(c);
            } else {
                String string3;
                int n2 = string2.indexOf(c);
                if (n2 >= 0) {
                    stringBuffer.append("\\");
                    stringBuffer.append(string2.charAt(n2 + 1));
                } else if (c < '\u0100') {
                    string3 = Integer.toHexString(c);
                    if (string3.length() == 1) {
                        stringBuffer.append("\\x0");
                        stringBuffer.append(string3);
                    } else {
                        stringBuffer.append("\\x");
                        stringBuffer.append(string3);
                    }
                } else {
                    string3 = Integer.toHexString(c);
                    stringBuffer.append("\\u");
                    int n3 = string3.length();
                    while (n3 < 4) {
                        stringBuffer.append('0');
                        ++n3;
                    }
                    stringBuffer.append(string3);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Scriptable getBase(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        while (scriptable2 != null) {
            Scriptable scriptable3 = scriptable2;
            do {
                if (scriptable3.get(string, scriptable2) == Scriptable.NOT_FOUND) continue;
                return scriptable2;
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
            scriptable2 = scriptable2.getParentScope();
        }
        throw NativeGlobal.constructError(Context.getContext(), "ReferenceError", ScriptRuntime.getMessage1("msg.is.not.defined", string), scriptable);
    }

    public static NativeCall getCurrentActivation(Context context) {
        return context.currentActivation;
    }

    /*
     * Unable to fully structure code
     */
    public static Object getElem(Object var0, Object var1_1, Scriptable var2_2) {
        if (var1_1 instanceof Number) {
            var5_3 = ((Number)var1_1).doubleValue();
            var3_6 = (int)var5_3;
            var4_7 = (double)var3_6 == var5_3 ? null : ScriptRuntime.toString(var1_1);
        } else {
            var4_7 = ScriptRuntime.toString(var1_1);
            var5_4 = ScriptRuntime.indexFromString(var4_7);
            if (var5_4 >= 0L) {
                var3_6 = (int)var5_4;
                var4_7 = null;
            } else {
                var3_6 = 0;
            }
        }
        var6_8 = var5_5 = var0 instanceof Scriptable != false ? (Scriptable)var0 : ScriptRuntime.toObject(var2_2, var0);
        if (var4_7 == null) ** GOTO lbl29
        if (var4_7.equals("__proto__")) {
            return var5_5.getPrototype();
        }
        if (!var4_7.equals("__parent__")) ** GOTO lbl23
        return var5_5.getParentScope();
lbl-1000:
        // 1 sources

        {
            var7_9 = var6_8.get(var4_7, var5_5);
            if (var7_9 != Scriptable.NOT_FOUND) {
                return var7_9;
            }
            var6_8 = var6_8.getPrototype();
lbl23:
            // 2 sources

            ** while (var6_8 != null)
        }
lbl24:
        // 1 sources

        return Undefined.instance;
lbl-1000:
        // 1 sources

        {
            var7_10 = var6_8.get(var3_6, var5_5);
            if (var7_10 != Scriptable.NOT_FOUND) {
                return var7_10;
            }
            var6_8 = var6_8.getPrototype();
lbl29:
            // 2 sources

            ** while (var6_8 != null)
        }
lbl30:
        // 1 sources

        return Undefined.instance;
    }

    public static Object getElem(Scriptable scriptable, int n) {
        Scriptable scriptable2 = scriptable;
        while (scriptable2 != null) {
            Object object = scriptable2.get(n, scriptable);
            if (object != Scriptable.NOT_FOUND) {
                return object;
            }
            scriptable2 = scriptable2.getPrototype();
        }
        return Undefined.instance;
    }

    private static ScriptableObject getGlobal(Context context) {
        try {
            Class clazz = ScriptRuntime.loadClassName(GLOBAL_CLASS);
            Class[] classArray = new Class[]{class$org$mozilla$javascript$Context != null ? class$org$mozilla$javascript$Context : (class$org$mozilla$javascript$Context = ScriptRuntime.class$("org.mozilla.javascript.Context"))};
            Constructor constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{context};
            return (ScriptableObject)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {}
        return new ImporterTopLevel(context);
    }

    static int getIntId(Object object) {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            int n = (int)d;
            if ((double)n == d) {
                return n;
            }
            return 0;
        }
        String string = ScriptRuntime.toString(object);
        long l = ScriptRuntime.indexFromString(string);
        if (l >= 0L) {
            return (int)l;
        }
        return 0;
    }

    public static String getMessage(String string, Object[] objectArray) {
        return Context.getMessage(string, objectArray);
    }

    public static String getMessage0(String string) {
        return Context.getMessage0(string);
    }

    public static String getMessage1(String string, Object object) {
        return Context.getMessage1(string, object);
    }

    public static String getMessage2(String string, Object object, Object object2) {
        return Context.getMessage2(string, object, object2);
    }

    public static Scriptable getParent(Object object) {
        Scriptable scriptable;
        try {
            scriptable = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        if (scriptable == null) {
            return null;
        }
        return ScriptRuntime.getThis(scriptable.getParentScope());
    }

    public static Scriptable getParent(Object object, Scriptable scriptable) {
        Scriptable scriptable2 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        if (scriptable2 == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scriptable);
        }
        return scriptable2.getParentScope();
    }

    public static Object getProp(Object object, String string, Scriptable scriptable) {
        Scriptable scriptable2 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        if (scriptable2 == null || scriptable2 == Undefined.instance) {
            String string2 = scriptable2 == null ? "msg.null.to.object" : "msg.undefined";
            throw NativeGlobal.constructError(Context.getContext(), "ConversionError", ScriptRuntime.getMessage0(string2), scriptable);
        }
        Scriptable scriptable3 = scriptable2;
        do {
            Object object2;
            if ((object2 = scriptable3.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
            return object2;
        } while ((scriptable3 = scriptable3.getPrototype()) != null);
        return Undefined.instance;
    }

    public static Scriptable getProto(Object object, Scriptable scriptable) {
        Scriptable scriptable2 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        if (scriptable2 == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scriptable);
        }
        return scriptable2.getPrototype();
    }

    public static RegExpProxy getRegExpProxy(Context context) {
        return context.getRegExpProxy();
    }

    static String getStringId(Object object) {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            int n = (int)d;
            if ((double)n == d) {
                return null;
            }
            return ScriptRuntime.toString(object);
        }
        String string = ScriptRuntime.toString(object);
        long l = ScriptRuntime.indexFromString(string);
        if (l >= 0L) {
            return null;
        }
        return string;
    }

    public static Scriptable getThis(Scriptable scriptable) {
        while (scriptable instanceof NativeWith) {
            scriptable = scriptable.getPrototype();
        }
        if (scriptable instanceof NativeCall) {
            scriptable = ScriptableObject.getTopLevelScope(scriptable);
        }
        return scriptable;
    }

    public static Object getTopLevelProp(Scriptable scriptable, String string) {
        Object object;
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        do {
            if ((object = scriptable2.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
            return object;
        } while ((scriptable2 = scriptable2.getPrototype()) != null);
        return object;
    }

    private static Class getTypeOfValue(Object object) {
        if (object == null) {
            return ScriptableClass;
        }
        if (object == Undefined.instance) {
            return UndefinedClass;
        }
        if (object instanceof Scriptable) {
            return ScriptableClass;
        }
        if (object instanceof Number) {
            return NumberClass;
        }
        return object.getClass();
    }

    static boolean hasProp(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        do {
            if (!scriptable2.has(string, scriptable)) continue;
            return true;
        } while ((scriptable2 = scriptable2.getPrototype()) != null);
        return false;
    }

    public static boolean in(Object object, Object object2, Scriptable scriptable) {
        if (!(object2 instanceof Scriptable)) {
            throw NativeGlobal.typeError0("msg.instanceof.not.object", scriptable);
        }
        String string = ScriptRuntime.getStringId(object);
        return string != null ? ScriptableObject.hasProperty((Scriptable)object2, string) : ScriptableObject.hasProperty((Scriptable)object2, ScriptRuntime.getIntId(object));
    }

    private static long indexFromString(String string) {
        int n = 10;
        int n2 = string.length();
        if (n2 > 0) {
            int n3 = 0;
            boolean bl = false;
            int n4 = string.charAt(0);
            if (n4 == 45 && n2 > 1) {
                n4 = string.charAt(1);
                n3 = 1;
                bl = true;
            }
            if ((n4 -= 48) >= 0 && n4 <= 9 && n2 <= (bl ? 11 : 10)) {
                int n5 = -n4;
                int n6 = 0;
                ++n3;
                if (n5 != 0) {
                    while (n3 != n2 && (n4 = string.charAt(n3) - 48) >= 0 && n4 <= 9) {
                        n6 = n5;
                        n5 = 10 * n5 - n4;
                        ++n3;
                    }
                }
                if (n3 == n2 && (n6 > -214748364 || n6 == -214748364 && n4 <= (bl ? 8 : 7))) {
                    return 0xFFFFFFFFL & (long)(bl ? n5 : -n5);
                }
            }
        }
        return -1L;
    }

    public static Enumeration initEnum(Object object, Scriptable scriptable) {
        Scriptable scriptable2 = ScriptRuntime.toObject(scriptable, object);
        return new IdEnumeration(scriptable2);
    }

    public static NativeFunction initFunction(NativeFunction nativeFunction, Scriptable scriptable, String string, Context context, boolean bl) {
        nativeFunction.setPrototype(ScriptableObject.getClassPrototype(scriptable, "Function"));
        nativeFunction.setParentScope(scriptable);
        if (bl) {
            ScriptRuntime.setName(scriptable, nativeFunction, scriptable, string);
        }
        return nativeFunction;
    }

    public static Scriptable initScript(Context context, Scriptable scriptable, NativeFunction nativeFunction, Scriptable scriptable2, boolean bl) {
        String[] stringArray = nativeFunction.argNames;
        if (stringArray != null) {
            ScriptableObject scriptableObject;
            try {
                scriptableObject = (ScriptableObject)scriptable;
            }
            catch (ClassCastException classCastException) {
                scriptableObject = null;
            }
            Scriptable scriptable3 = scriptable;
            if (bl) {
                scriptable3 = scriptable;
                while (scriptable3 instanceof NativeWith) {
                    scriptable3 = scriptable3.getParentScope();
                }
            }
            int n = stringArray.length;
            while (n-- != 0) {
                String string = stringArray[n];
                if (ScriptRuntime.hasProp(scriptable, string)) continue;
                if (scriptableObject != null && !bl) {
                    scriptableObject.defineProperty(string, Undefined.instance, 4);
                    continue;
                }
                scriptable3.put(string, scriptable3, (Object)Undefined.instance);
            }
        }
        return scriptable;
    }

    public static Scriptable initVarObj(Context context, Scriptable scriptable, NativeFunction nativeFunction, Scriptable scriptable2, Object[] objectArray) {
        NativeCall nativeCall = new NativeCall(context, scriptable, nativeFunction, scriptable2, objectArray);
        String[] stringArray = nativeFunction.argNames;
        if (stringArray != null) {
            int n = nativeFunction.argCount;
            while (n != stringArray.length) {
                String string = stringArray[n];
                nativeCall.put(string, (Scriptable)nativeCall, (Object)Undefined.instance);
                ++n;
            }
        }
        return nativeCall;
    }

    public static boolean instanceOf(Scriptable scriptable, Object object, Object object2) {
        if (!(object2 instanceof Scriptable)) {
            throw NativeGlobal.typeError0("msg.instanceof.not.object", scriptable);
        }
        if (!(object instanceof Scriptable)) {
            return false;
        }
        return ((Scriptable)object2).hasInstance((Scriptable)object);
    }

    protected static boolean jsDelegatesTo(Scriptable scriptable, Scriptable scriptable2) {
        Scriptable scriptable3 = scriptable.getPrototype();
        while (scriptable3 != null) {
            if (scriptable3.equals(scriptable2)) {
                return true;
            }
            scriptable3 = scriptable3.getPrototype();
        }
        return false;
    }

    public static Scriptable leaveWith(Scriptable scriptable) {
        return scriptable.getParentScope();
    }

    public static Class loadClassName(String string) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = DefiningClassLoader.getContextClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return Class.forName(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String string, String[] stringArray) throws JavaScriptException {
        block7: {
            Context context = Context.enter();
            ScriptableObject scriptableObject = ScriptRuntime.getGlobal(context);
            Scriptable scriptable = context.newArray((Scriptable)scriptableObject, stringArray);
            scriptableObject.defineProperty("arguments", scriptable, 2);
            try {
                try {
                    Class clazz = ScriptRuntime.loadClassName(string);
                    Script script = (Script)clazz.newInstance();
                    script.exec(context, scriptableObject);
                    Object var6_7 = null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    break block7;
                }
                catch (InstantiationException instantiationException) {
                    break block7;
                }
                catch (IllegalAccessException illegalAccessException) {
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                Context.exit();
                throw throwable;
            }
            Context.exit();
            return;
        }
        Object var6_8 = null;
        Context.exit();
        throw new RuntimeException("Error creating script object");
    }

    public static Object name(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        while (scriptable2 != null) {
            Scriptable scriptable3 = scriptable2;
            do {
                Object object;
                if ((object = scriptable3.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
                return object;
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
            scriptable2 = scriptable2.getParentScope();
        }
        throw NativeGlobal.constructError(Context.getContext(), "ReferenceError", ScriptRuntime.getMessage1("msg.is.not.defined", string.toString()), scriptable);
    }

    public static Boolean neB(Object object, Object object2) {
        if (ScriptRuntime.eq(object, object2)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Scriptable newObject(Context context, Object object, Object[] objectArray, Scriptable scriptable) throws JavaScriptException {
        try {
            Function function = (Function)object;
            if (function != null) {
                return function.construct(context, scriptable, objectArray);
            }
        }
        catch (ClassCastException classCastException) {}
        throw NativeGlobal.typeError1("msg.isnt.function", ScriptRuntime.toString(object), scriptable);
    }

    public static Scriptable newObject(Context context, Scriptable scriptable, String string, Object[] objectArray) {
        Exception exception = null;
        try {
            return context.newObject(scriptable, string, objectArray);
        }
        catch (NotAFunctionException notAFunctionException) {
            exception = notAFunctionException;
        }
        catch (PropertyException propertyException) {
            exception = propertyException;
        }
        catch (JavaScriptException javaScriptException) {
            exception = javaScriptException;
        }
        throw Context.reportRuntimeError(exception.getMessage());
    }

    public static Scriptable newObjectSpecial(Context context, Object object, Object[] objectArray, Scriptable scriptable) throws JavaScriptException {
        return (Scriptable)ScriptRuntime.callOrNewSpecial(context, scriptable, object, null, null, objectArray, false, null, -1);
    }

    public static Scriptable newScope() {
        return new NativeObject();
    }

    public static Object nextEnum(Enumeration enumeration) {
        if (!enumeration.hasMoreElements()) {
            return null;
        }
        return enumeration.nextElement();
    }

    public static String numberToString(double d, int n) {
        if (d != d) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (d == 0.0) {
            return "0";
        }
        if (n < 2 || n > 36) {
            throw Context.reportRuntimeError1("msg.bad.radix", Integer.toString(n));
        }
        if (n != 10) {
            return DToA.JS_dtobasestr(n, d);
        }
        StringBuffer stringBuffer = new StringBuffer();
        DToA.JS_dtostr(stringBuffer, 0, 0, d);
        return stringBuffer.toString();
    }

    public static Object[] padArguments(Object[] objectArray, int n) {
        if (n < objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        while (n2 < objectArray.length) {
            objectArray2[n2] = objectArray[n2];
            ++n2;
        }
        while (n2 < n) {
            objectArray2[n2] = Undefined.instance;
            ++n2;
        }
        return objectArray2;
    }

    public static void popActivation(Context context) {
        NativeCall nativeCall = context.currentActivation;
        if (nativeCall != null) {
            context.currentActivation = nativeCall.caller;
            nativeCall.caller = null;
        }
    }

    public static Object postDecrement(Object object) {
        object = object instanceof Number ? new Double(((Number)object).doubleValue() - 1.0) : new Double(ScriptRuntime.toNumber(object) - 1.0);
        return object;
    }

    public static Object postDecrement(Object object, String string, Scriptable scriptable) {
        Scriptable scriptable2 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        if (scriptable2 == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scriptable);
        }
        Scriptable scriptable3 = scriptable2;
        do {
            Object object2;
            if ((object2 = scriptable3.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
            Object object3 = object2;
            if (object3 instanceof Number) {
                object3 = new Double(((Number)object3).doubleValue() - 1.0);
                scriptable3.put(string, scriptable2, object3);
                return object2;
            }
            object3 = new Double(ScriptRuntime.toNumber(object3) - 1.0);
            scriptable3.put(string, scriptable2, object3);
            return new Double(ScriptRuntime.toNumber(object2));
        } while ((scriptable3 = scriptable3.getPrototype()) != null);
        return Undefined.instance;
    }

    public static Object postDecrement(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        while (scriptable2 != null) {
            Scriptable scriptable3 = scriptable2;
            do {
                Object object;
                if ((object = scriptable3.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
                Object object2 = object;
                if (object2 instanceof Number) {
                    object2 = new Double(((Number)object2).doubleValue() - 1.0);
                    scriptable3.put(string, scriptable2, object2);
                    return object;
                }
                object2 = new Double(ScriptRuntime.toNumber(object2) - 1.0);
                scriptable3.put(string, scriptable2, object2);
                return new Double(ScriptRuntime.toNumber(object));
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
            scriptable2 = scriptable2.getParentScope();
        }
        throw NativeGlobal.constructError(Context.getContext(), "ReferenceError", ScriptRuntime.getMessage1("msg.is.not.defined", string), scriptable);
    }

    public static Object postDecrementElem(Object object, Object object2, Scriptable scriptable) {
        Object object3 = ScriptRuntime.getElem(object, object2, scriptable);
        if (object3 == Undefined.instance) {
            return Undefined.instance;
        }
        double d = ScriptRuntime.toNumber(object3);
        Double d2 = new Double(d - 1.0);
        ScriptRuntime.setElem(object, object2, d2, scriptable);
        return new Double(d);
    }

    public static Object postIncrement(Object object) {
        object = object instanceof Number ? new Double(((Number)object).doubleValue() + 1.0) : new Double(ScriptRuntime.toNumber(object) + 1.0);
        return object;
    }

    public static Object postIncrement(Object object, String string, Scriptable scriptable) {
        Scriptable scriptable2 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        if (scriptable2 == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scriptable);
        }
        Scriptable scriptable3 = scriptable2;
        do {
            Object object2;
            if ((object2 = scriptable3.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
            Object object3 = object2;
            if (object3 instanceof Number) {
                object3 = new Double(((Number)object3).doubleValue() + 1.0);
                scriptable3.put(string, scriptable2, object3);
                return object2;
            }
            object3 = new Double(ScriptRuntime.toNumber(object3) + 1.0);
            scriptable3.put(string, scriptable2, object3);
            return new Double(ScriptRuntime.toNumber(object2));
        } while ((scriptable3 = scriptable3.getPrototype()) != null);
        return Undefined.instance;
    }

    public static Object postIncrement(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        while (scriptable2 != null) {
            Scriptable scriptable3 = scriptable2;
            do {
                Object object;
                if ((object = scriptable3.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
                Object object2 = object;
                if (object2 instanceof Number) {
                    object2 = new Double(((Number)object2).doubleValue() + 1.0);
                    scriptable3.put(string, scriptable2, object2);
                    return object;
                }
                object2 = new Double(ScriptRuntime.toNumber(object2) + 1.0);
                scriptable3.put(string, scriptable2, object2);
                return new Double(ScriptRuntime.toNumber(object));
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
            scriptable2 = scriptable2.getParentScope();
        }
        throw NativeGlobal.constructError(Context.getContext(), "ReferenceError", ScriptRuntime.getMessage1("msg.is.not.defined", string), scriptable);
    }

    public static Object postIncrementElem(Object object, Object object2, Scriptable scriptable) {
        Object object3 = ScriptRuntime.getElem(object, object2, scriptable);
        if (object3 == Undefined.instance) {
            return Undefined.instance;
        }
        double d = ScriptRuntime.toNumber(object3);
        Double d2 = new Double(d + 1.0);
        ScriptRuntime.setElem(object, object2, d2, scriptable);
        return new Double(d);
    }

    public static Scriptable runScript(Script script) {
        Context context = Context.enter();
        ScriptableObject scriptableObject = ScriptRuntime.getGlobal(context);
        try {
            try {
                script.exec(context, scriptableObject);
            }
            catch (JavaScriptException javaScriptException) {
                throw new Error(javaScriptException.toString());
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return scriptableObject;
    }

    public static Boolean seqB(Object object, Object object2) {
        if (ScriptRuntime.shallowEq(object, object2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void setCurrentActivation(Context context, NativeCall nativeCall) {
        context.currentActivation = nativeCall;
    }

    public static Object setElem(Object object, Object object2, Object object3, Scriptable scriptable) {
        Scriptable scriptable2;
        String string;
        int n;
        if (object2 instanceof Number) {
            double d = ((Number)object2).doubleValue();
            n = (int)d;
            string = (double)n == d ? null : ScriptRuntime.toString(object2);
        } else {
            string = ScriptRuntime.toString(object2);
            long l = ScriptRuntime.indexFromString(string);
            if (l >= 0L) {
                n = (int)l;
                string = null;
            } else {
                n = 0;
            }
        }
        Scriptable scriptable3 = scriptable2 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        if (string != null) {
            if (string.equals("__proto__")) {
                return ScriptRuntime.setProto(object, object3, scriptable);
            }
            if (string.equals("__parent__")) {
                return ScriptRuntime.setParent(object, object3, scriptable);
            }
            do {
                if (!scriptable3.has(string, scriptable2)) continue;
                scriptable3.put(string, scriptable2, object3);
                return object3;
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
            scriptable2.put(string, scriptable2, object3);
            return object3;
        }
        do {
            if (!scriptable3.has(n, scriptable2)) continue;
            scriptable3.put(n, scriptable2, object3);
            return object3;
        } while ((scriptable3 = scriptable3.getPrototype()) != null);
        scriptable2.put(n, scriptable2, object3);
        return object3;
    }

    public static Object setElem(Scriptable scriptable, int n, Object object) {
        Scriptable scriptable2 = scriptable;
        do {
            if (!scriptable2.has(n, scriptable)) continue;
            scriptable2.put(n, scriptable, object);
            return object;
        } while ((scriptable2 = scriptable2.getPrototype()) != null);
        scriptable.put(n, scriptable, object);
        return object;
    }

    public static Object setName(Scriptable scriptable, Object object, Scriptable scriptable2, String string) {
        if (scriptable == null) {
            Scriptable scriptable3 = scriptable2;
            while ((scriptable3 = (scriptable = scriptable3).getParentScope()) != null) {
            }
            scriptable.put(string, scriptable, object);
            return object;
        }
        return ScriptRuntime.setProp(scriptable, string, object, scriptable2);
    }

    public static Object setParent(Object object, Object object2, Scriptable scriptable) {
        Scriptable scriptable2;
        Scriptable scriptable3 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        Scriptable scriptable4 = scriptable2 = object2 == null ? null : ScriptRuntime.toObject(scriptable, object2);
        while (scriptable4 != null) {
            if (scriptable4 == scriptable3) {
                throw Context.reportRuntimeError1("msg.cyclic.value", "__parent__");
            }
            scriptable4 = scriptable4.getParentScope();
        }
        if (scriptable3 == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scriptable);
        }
        scriptable3.setParentScope(scriptable2);
        return scriptable2;
    }

    public static Object setProp(Object object, String string, Object object2, Scriptable scriptable) {
        Scriptable scriptable2 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        if (scriptable2 == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scriptable);
        }
        Scriptable scriptable3 = scriptable2;
        do {
            if (!scriptable3.has(string, scriptable2)) continue;
            scriptable3.put(string, scriptable2, object2);
            return object2;
        } while ((scriptable3 = scriptable3.getPrototype()) != null);
        scriptable2.put(string, scriptable2, object2);
        return object2;
    }

    public static Object setProto(Object object, Object object2, Scriptable scriptable) {
        Scriptable scriptable2;
        Scriptable scriptable3 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        Scriptable scriptable4 = scriptable2 = object2 == null ? null : ScriptRuntime.toObject(scriptable, object2);
        while (scriptable4 != null) {
            if (scriptable4 == scriptable3) {
                throw Context.reportRuntimeError1("msg.cyclic.value", "__proto__");
            }
            scriptable4 = scriptable4.getPrototype();
        }
        if (scriptable3 == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scriptable);
        }
        scriptable3.setPrototype(scriptable2);
        return scriptable2;
    }

    public static boolean shallowEq(Object object, Object object2) {
        Class clazz = ScriptRuntime.getTypeOfValue(object);
        if (clazz != ScriptRuntime.getTypeOfValue(object2)) {
            return false;
        }
        if (clazz == StringClass || clazz == BooleanClass) {
            return object.equals(object2);
        }
        if (clazz == NumberClass) {
            return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
        }
        if (clazz == ScriptableClass) {
            if (object == object2) {
                return true;
            }
            if (object instanceof Wrapper && object2 instanceof Wrapper) {
                return ((Wrapper)object).unwrap() == ((Wrapper)object2).unwrap();
            }
            return false;
        }
        return clazz == UndefinedClass;
    }

    public static Boolean sneB(Object object, Object object2) {
        if (ScriptRuntime.shallowEq(object, object2)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    static double stringToNumber(String string, int n, int n2) {
        int n3;
        char c = '9';
        char c2 = 'a';
        char c3 = 'A';
        int n4 = string.length();
        if (n2 < 10) {
            c = (char)(48 + n2 - 1);
        }
        if (n2 > 10) {
            c2 = (char)(97 + n2 - 10);
            c3 = (char)(65 + n2 - 10);
        }
        double d = 0.0;
        int n5 = n;
        while (n5 < n4) {
            char c4 = string.charAt(n5);
            if (c4 >= '0' && c4 <= c) {
                n3 = c4 - 48;
            } else if (c4 >= 'a' && c4 < c2) {
                n3 = c4 - 97 + 10;
            } else {
                if (c4 < 'A' || c4 >= c3) break;
                n3 = c4 - 65 + 10;
            }
            d = d * (double)n2 + (double)n3;
            ++n5;
        }
        if (n == n5) {
            return NaN;
        }
        if (d >= 9.007199254740992E15) {
            if (n2 == 10) {
                try {
                    return Double.valueOf(string.substring(n, n5));
                }
                catch (NumberFormatException numberFormatException) {
                    return NaN;
                }
            }
            if (n2 == 2 || n2 == 4 || n2 == 8 || n2 == 16 || n2 == 32) {
                BinaryDigitReader binaryDigitReader = new BinaryDigitReader(n2, string, n, n5);
                d = 0.0;
                while ((n3 = binaryDigitReader.getNextBinaryDigit()) == 0) {
                }
                if (n3 == 1) {
                    d = 1.0;
                    int n6 = 52;
                    while (n6 != 0) {
                        n3 = binaryDigitReader.getNextBinaryDigit();
                        if (n3 < 0) {
                            return d;
                        }
                        d = d * 2.0 + (double)n3;
                        --n6;
                    }
                    int n7 = binaryDigitReader.getNextBinaryDigit();
                    if (n7 >= 0) {
                        int n8;
                        double d2 = 2.0;
                        int n9 = 0;
                        while ((n8 = binaryDigitReader.getNextBinaryDigit()) >= 0) {
                            n9 |= n8;
                            d2 *= 2.0;
                        }
                        d += (double)(n7 & (n3 | n9));
                        d *= d2;
                    }
                }
            }
        }
        return d;
    }

    public static boolean toBoolean(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Scriptable) {
            if (Context.getContext().isVersionECMA1()) {
                return object != Undefined.instance;
            }
            if ((object = ((Scriptable)object).getDefaultValue(BooleanClass)) instanceof Scriptable) {
                throw ScriptRuntime.errorWithClassName("msg.primitive.expected", object);
            }
        }
        if (object instanceof String) {
            return ((String)object).length() != 0;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return d == d && d != 0.0;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", object);
    }

    public static boolean toBoolean(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toBoolean(objectArray[n]) : false;
    }

    public static int toInt32(double d) {
        double d2 = 4.294967296E9;
        double d3 = 2.147483648E9;
        if (d != d || d == 0.0 || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        double d4 = d = (d = Math.IEEEremainder(d, d2)) >= 0.0 ? d : d + d2;
        if (d >= d3) {
            return (int)(d - d2);
        }
        return (int)d;
    }

    public static int toInt32(Object object) {
        double d = 4.294967296E9;
        double d2 = 2.147483648E9;
        if (object instanceof Byte) {
            return ((Number)object).intValue();
        }
        double d3 = ScriptRuntime.toNumber(object);
        if (d3 != d3 || d3 == 0.0 || d3 == Double.POSITIVE_INFINITY || d3 == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        double d4 = d3 = (d3 = Math.IEEEremainder(d3, d)) >= 0.0 ? d3 : d3 + d;
        if (d3 >= d2) {
            return (int)(d3 - d);
        }
        return (int)d3;
    }

    public static int toInt32(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toInt32(objectArray[n]) : 0;
    }

    public static double toInteger(double d) {
        if (d != d) {
            return 0.0;
        }
        if (d == 0.0 || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        if (d > 0.0) {
            return Math.floor(d);
        }
        return Math.ceil(d);
    }

    public static double toInteger(Object object) {
        return ScriptRuntime.toInteger(ScriptRuntime.toNumber(object));
    }

    public static double toInteger(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toInteger(objectArray[n]) : 0.0;
    }

    public static double toNumber(Object object) {
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Scriptable && (object = ((Scriptable)object).getDefaultValue(NumberClass)) != null && object instanceof Scriptable) {
            throw ScriptRuntime.errorWithClassName("msg.primitive.expected", object);
        }
        if (object instanceof String) {
            return ScriptRuntime.toNumber((String)object);
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", object);
    }

    public static double toNumber(String string) {
        char c;
        char c2;
        int n = string.length();
        int n2 = 0;
        while (true) {
            if (n2 == n) {
                return 0.0;
            }
            c2 = string.charAt(n2);
            if (!Character.isWhitespace(c2)) break;
            ++n2;
        }
        if (c2 == '0' && n2 + 2 < n && Character.toLowerCase(string.charAt(n2 + 1)) == 'x') {
            return ScriptRuntime.stringToNumber(string, n2 + 2, 16);
        }
        if ((c2 == '+' || c2 == '-') && n2 + 3 < n && string.charAt(n2 + 1) == '0' && Character.toLowerCase(string.charAt(n2 + 2)) == 'x') {
            double d = ScriptRuntime.stringToNumber(string, n2 + 3, 16);
            return c2 == '-' ? -d : d;
        }
        int n3 = n - 1;
        while (Character.isWhitespace(c = string.charAt(n3))) {
            --n3;
        }
        if (c == 'y') {
            if (c2 == '+' || c2 == '-') {
                ++n2;
            }
            if (n2 + 7 == n3 && string.regionMatches(n2, "Infinity", 0, 8)) {
                return c2 == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return NaN;
        }
        String string2 = string.substring(n2, n3 + 1);
        int n4 = string2.length() - 1;
        while (n4 >= 0) {
            char c3 = string2.charAt(n4);
            if ((c3 < '0' || c3 > '9') && c3 != '.' && c3 != 'e' && c3 != 'E' && c3 != '+' && c3 != '-') {
                return NaN;
            }
            --n4;
        }
        try {
            return Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return NaN;
        }
    }

    public static double toNumber(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toNumber(objectArray[n]) : NaN;
    }

    public static Scriptable toObject(Scriptable scriptable, Object object) {
        return ScriptRuntime.toObject(scriptable, object, null);
    }

    public static Scriptable toObject(Scriptable scriptable, Object object, Class clazz) {
        String string;
        if (object == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scriptable);
        }
        if (object instanceof Scriptable) {
            if (object == Undefined.instance) {
                throw NativeGlobal.typeError0("msg.undef.to.object", scriptable);
            }
            return (Scriptable)object;
        }
        String string2 = object instanceof String ? "String" : (object instanceof Number ? "Number" : (string = object instanceof Boolean ? "Boolean" : null));
        if (string == null) {
            Object object2 = NativeJavaObject.wrap(scriptable, object, clazz);
            if (object2 instanceof Scriptable) {
                return (Scriptable)object2;
            }
            throw ScriptRuntime.errorWithClassName("msg.invalid.type", object);
        }
        Object[] objectArray = new Object[]{object};
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Scriptable scriptable2 = ScriptRuntime.newObject(Context.getContext(), scriptable, string, objectArray);
        return scriptable2;
    }

    public static Object toPrimitive(Object object) {
        if (object == null || !(object instanceof Scriptable)) {
            return object;
        }
        Object object2 = ((Scriptable)object).getDefaultValue(null);
        if (object2 != null && object2 instanceof Scriptable) {
            throw NativeGlobal.typeError0("msg.bad.default.value", object);
        }
        return object2;
    }

    public static String toString(double d) {
        return ScriptRuntime.numberToString(d, 10);
    }

    public static String toString(Object object) {
        block3: {
            do {
                if (object == null) {
                    return "null";
                }
                if (!(object instanceof Scriptable)) break block3;
            } while ((object = ((Scriptable)object).getDefaultValue(StringClass)) == Undefined.instance || !(object instanceof Scriptable));
            throw ScriptRuntime.errorWithClassName("msg.primitive.expected", object);
        }
        if (object instanceof Number) {
            return ScriptRuntime.numberToString(((Number)object).doubleValue(), 10);
        }
        return object.toString();
    }

    public static String toString(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toString(objectArray[n]) : "undefined";
    }

    public static char toUint16(Object object) {
        long l = 65536L;
        double d = ScriptRuntime.toNumber(object);
        if (d != d || d == 0.0 || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return '\u0000';
        }
        d = (d = Math.IEEEremainder(d, l)) >= 0.0 ? d : d + (double)l;
        return (char)Math.floor(d);
    }

    public static long toUint32(double d) {
        double d2 = 4.294967296E9;
        if (d != d || d == 0.0 || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return 0L;
        }
        d = d > 0.0 ? Math.floor(d) : Math.ceil(d);
        d = Math.IEEEremainder(d, d2);
        d = d >= 0.0 ? d : d + d2;
        return (long)Math.floor(d);
    }

    public static long toUint32(Object object) {
        return ScriptRuntime.toUint32(ScriptRuntime.toNumber(object));
    }

    public static String typeof(Object object) {
        if (object == Undefined.instance) {
            return "undefined";
        }
        if (object == null) {
            return "object";
        }
        if (object instanceof Scriptable) {
            return object instanceof Function ? "function" : "object";
        }
        if (object instanceof String) {
            return "string";
        }
        if (object instanceof Number) {
            return "number";
        }
        if (object instanceof Boolean) {
            return "boolean";
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", object);
    }

    public static String typeofName(Scriptable scriptable, String string) {
        Scriptable scriptable2 = ScriptRuntime.bind(scriptable, string);
        if (scriptable2 == null) {
            return "undefined";
        }
        return ScriptRuntime.typeof(ScriptRuntime.getProp(scriptable2, string, scriptable));
    }

    public static Object unwrapJavaScriptException(JavaScriptException javaScriptException) {
        return javaScriptException.value;
    }

    public static Object unwrapWrappedException(WrappedException wrappedException) {
        Throwable throwable = wrappedException.getWrappedException();
        if (throwable instanceof JavaScriptException) {
            return ((JavaScriptException)throwable).value;
        }
        throw wrappedException;
    }
}

