/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Global;

public class Main {
    protected static ToolErrorReporter errorReporter;
    protected static Global global;
    protected static int exitCode;
    private static final int EXITCODE_RUNTIME_ERROR = 3;
    private static final int EXITCODE_FILE_NOT_FOUND = 4;
    static boolean processStdin;
    static Vector fileList;

    static {
        exitCode = 0;
        processStdin = true;
        fileList = new Vector(5);
    }

    public static Object evaluateReader(Context context, Scriptable scriptable, Reader reader, String string, int n) {
        Object object = Context.getUndefinedValue();
        try {
            try {
                object = context.evaluateReader(scriptable, reader, string, n, null);
            }
            catch (WrappedException wrappedException) {
                global.getErr().println(wrappedException.getWrappedException().toString());
                wrappedException.printStackTrace();
            }
            catch (EcmaError ecmaError) {
                String string2 = ToolErrorReporter.getMessage("msg.uncaughtJSException", ecmaError.toString());
                exitCode = 3;
                if (ecmaError.getSourceName() != null) {
                    Context.reportError(string2, ecmaError.getSourceName(), ecmaError.getLineNumber(), ecmaError.getLineSource(), ecmaError.getColumnNumber());
                } else {
                    Context.reportError(string2);
                }
            }
            catch (EvaluatorException evaluatorException) {
                exitCode = 3;
            }
            catch (JavaScriptException javaScriptException) {
                Object object2 = javaScriptException.getValue();
                if (object2 instanceof ThreadDeath) {
                    throw (ThreadDeath)object2;
                }
                exitCode = 3;
                Context.reportError(ToolErrorReporter.getMessage("msg.uncaughtJSException", javaScriptException.getMessage()));
            }
            catch (IOException iOException) {
                global.getErr().println(iOException.toString());
            }
            Object var7_14 = null;
        }
        catch (Throwable throwable) {
            Object var7_15 = null;
            try {
                reader.close();
            }
            catch (IOException iOException) {
                global.getErr().println(iOException.toString());
            }
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            global.getErr().println(iOException.toString());
        }
        return object;
    }

    public static int exec(String[] stringArray) {
        Context context = Context.enter();
        global = new Global(context);
        errorReporter = new ToolErrorReporter(false, global.getErr());
        context.setErrorReporter(errorReporter);
        stringArray = Main.processOptions(context, stringArray);
        int n = 0;
        if (fileList.size() == 0 && stringArray.length > 0) {
            n = 1;
            fileList.addElement(stringArray[0]);
        }
        if (processStdin) {
            fileList.addElement(null);
        }
        Object[] objectArray = stringArray;
        if (stringArray.length > 0) {
            int n2 = stringArray.length - n;
            objectArray = new Object[n2];
            System.arraycopy(stringArray, n, objectArray, 0, n2);
        }
        Scriptable scriptable = context.newArray((Scriptable)global, objectArray);
        global.defineProperty("arguments", scriptable, 2);
        int n3 = 0;
        while (n3 < fileList.size()) {
            Main.processSource(context, (String)fileList.get(n3));
            ++n3;
        }
        Context.exit();
        return exitCode;
    }

    public static PrintStream getErr() {
        return Global.getInstance(global).getErr();
    }

    public static InputStream getIn() {
        return Global.getInstance(global).getIn();
    }

    public static PrintStream getOut() {
        return Global.getInstance(global).getOut();
    }

    public static ScriptableObject getScope() {
        return global;
    }

    public static void main(String[] stringArray) {
        int n = Main.exec(stringArray);
        if (n != 0) {
            System.exit(n);
        }
    }

    private static void p(String string) {
        global.getOut().println(string);
    }

    public static void processFile(Context context, Scriptable scriptable, String string) {
        Reader reader = null;
        try {
            reader = new PushbackReader(new FileReader(string));
            int n = reader.read();
            if (n == 35) {
                while ((n = reader.read()) != -1) {
                    if (n == 10 || n == 13) break;
                }
                ((PushbackReader)reader).unread(n);
            } else {
                reader.close();
                reader = new FileReader(string);
            }
            string = new File(string).getCanonicalPath();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open", string));
            exitCode = 4;
            return;
        }
        catch (IOException iOException) {
            global.getErr().println(iOException.toString());
        }
        Main.evaluateReader(context, scriptable, reader, string, 1);
    }

    public static String[] processOptions(Context context, String[] stringArray) {
        context.setTargetPackage("");
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (!string.startsWith("-")) {
                processStdin = false;
                String[] stringArray2 = new String[stringArray.length - n];
                System.arraycopy(stringArray, n, stringArray2, 0, stringArray.length - n);
                return stringArray2;
            }
            if (string.equals("-version")) {
                double d;
                if (++n == stringArray.length) {
                    Main.usage(string);
                }
                if ((d = Context.toNumber(stringArray[n])) != d) {
                    Main.usage(string);
                }
                context.setLanguageVersion((int)d);
            } else if (string.equals("-opt") || string.equals("-O")) {
                double d;
                if (++n == stringArray.length) {
                    Main.usage(string);
                }
                if ((d = Context.toNumber(stringArray[n])) != d) {
                    Main.usage(string);
                }
                context.setOptimizationLevel((int)d);
            } else if (string.equals("-e")) {
                processStdin = false;
                if (++n == stringArray.length) {
                    Main.usage(string);
                }
                StringReader stringReader = new StringReader(stringArray[n]);
                Main.evaluateReader(context, global, stringReader, "<command>", 1);
            } else if (string.equals("-w")) {
                errorReporter.setIsReportingWarnings(true);
            } else if (string.equals("-f")) {
                processStdin = false;
                if (++n == stringArray.length) {
                    Main.usage(string);
                }
                fileList.addElement(stringArray[n].equals("-") ? null : stringArray[n]);
            } else {
                Main.usage(string);
            }
            ++n;
        }
        return new String[0];
    }

    public static void processSource(Context context, String string) {
        if (string == null || string.equals("-")) {
            context.setOptimizationLevel(-1);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(global.getIn()));
            int n = 1;
            boolean bl = false;
            while (!bl) {
                Object object;
                int n2 = n;
                if (string == null) {
                    global.getErr().print("js> ");
                }
                global.getErr().flush();
                String string2 = "";
                do {
                    try {
                        object = bufferedReader.readLine();
                    }
                    catch (IOException iOException) {
                        global.getErr().println(iOException.toString());
                        break;
                    }
                    if (object == null) {
                        bl = true;
                        break;
                    }
                    string2 = String.valueOf(string2) + (String)object + "\n";
                    ++n;
                } while (!context.stringIsCompilableUnit(string2));
                object = new StringReader(string2);
                Object object2 = Main.evaluateReader(context, global, (Reader)object, "<stdin>", n2);
                if (object2 != Context.getUndefinedValue()) {
                    try {
                        global.getErr().println(Context.toString(object2));
                    }
                    catch (EcmaError ecmaError) {
                        String string3 = ToolErrorReporter.getMessage("msg.uncaughtJSException", ecmaError.toString());
                        exitCode = 3;
                        if (ecmaError.getSourceName() != null) {
                            Context.reportError(string3, ecmaError.getSourceName(), ecmaError.getLineNumber(), ecmaError.getLineSource(), ecmaError.getColumnNumber());
                        }
                        Context.reportError(string3);
                    }
                }
                NativeArray nativeArray = Main.global.history;
                nativeArray.put((int)nativeArray.jsGet_length(), (Scriptable)nativeArray, (Object)string2);
            }
            global.getErr().println();
        } else {
            Main.processFile(context, global, string);
        }
        System.gc();
    }

    public static void setErr(PrintStream printStream) {
        Global.getInstance(global).setErr(printStream);
    }

    public static void setIn(InputStream inputStream) {
        Global.getInstance(global).setIn(inputStream);
    }

    public static void setOut(PrintStream printStream) {
        Global.getInstance(global).setOut(printStream);
    }

    public static void usage(String string) {
        Main.p(ToolErrorReporter.getMessage("msg.shell.usage", string));
        System.exit(1);
    }
}

