/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

public class NativeBoolean
extends IdScriptable {
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_valueOf = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    private boolean booleanValue;
    private boolean prototypeFlag;

    public NativeBoolean() {
    }

    public NativeBoolean(boolean bl) {
        this.booleanValue = bl;
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            if (n == 1) {
                return this.jsConstructor(objectArray, scriptable2 == null);
            }
            if (n == 2) {
                return this.realThis(scriptable2, idFunction).jsFunction_toString();
            }
            if (n == 3) {
                return this.wrap_boolean(this.realThis(scriptable2, idFunction).jsFunction_valueOf());
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    public String getClassName() {
        return "Boolean";
    }

    public Object getDefaultValue(Class clazz) {
        if (clazz == ScriptRuntime.BooleanClass) {
            return this.wrap_boolean(this.booleanValue);
        }
        return super.getDefaultValue(clazz);
    }

    protected String getIdName(int n) {
        if (this.prototypeFlag) {
            if (n == 1) {
                return "constructor";
            }
            if (n == 2) {
                return "toString";
            }
            if (n == 3) {
                return "valueOf";
            }
        }
        return null;
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeBoolean nativeBoolean = new NativeBoolean();
        nativeBoolean.prototypeFlag = true;
        nativeBoolean.addAsPrototype(3, context, scriptable, bl);
    }

    private Object jsConstructor(Object[] objectArray, boolean bl) {
        boolean bl2 = ScriptRuntime.toBoolean(objectArray, 0);
        if (bl) {
            return new NativeBoolean(bl2);
        }
        return this.wrap_boolean(bl2);
    }

    private String jsFunction_toString() {
        return this.booleanValue ? "true" : "false";
    }

    private boolean jsFunction_valueOf() {
        return this.booleanValue;
    }

    protected int mapNameToId(String string) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int n = 0;
        String string2 = null;
        int n2 = string.length();
        if (n2 == 7) {
            string2 = "valueOf";
            n = 3;
        } else if (n2 == 8) {
            string2 = "toString";
            n = 2;
        } else if (n2 == 11) {
            string2 = "constructor";
            n = 1;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }

    public int methodArity(int n) {
        if (this.prototypeFlag) {
            if (n == 1) {
                return 1;
            }
            if (n == 2) {
                return 0;
            }
            if (n == 3) {
                return 0;
            }
        }
        return super.methodArity(n);
    }

    private NativeBoolean realThis(Scriptable scriptable, IdFunction idFunction) {
        while (!(scriptable instanceof NativeBoolean)) {
            scriptable = this.nextInstanceCheck(scriptable, idFunction, true);
        }
        return (NativeBoolean)scriptable;
    }
}

