/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class NativeJavaClass
extends NativeJavaObject
implements Function {
    private Hashtable fieldAndMethods;
    private Scriptable parent;

    public NativeJavaClass(Scriptable scriptable, Class clazz) {
        super(scriptable, (Object)clazz, JavaMembers.lookupClass(scriptable, clazz, clazz));
        this.fieldAndMethods = this.members.getFieldAndMethodsObjects(this, this.javaObject, true);
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (objectArray.length == 1 && objectArray[0] instanceof Scriptable) {
            Class clazz = this.getClassObject();
            Scriptable scriptable3 = (Scriptable)objectArray[0];
            do {
                Object object;
                if (!(scriptable3 instanceof Wrapper) || !clazz.isInstance(object = ((Wrapper)((Object)scriptable3)).unwrap())) continue;
                return scriptable3;
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
        }
        return this.construct(context, scriptable, objectArray);
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        String string;
        Class clazz;
        block5: {
            clazz = this.getClassObject();
            int n = clazz.getModifiers();
            if (!Modifier.isInterface(n) && !Modifier.isAbstract(n)) {
                Member[] memberArray = this.members.getConstructors();
                Member member = NativeJavaMethod.findFunction(memberArray, objectArray);
                Constructor constructor = (Constructor)member;
                if (constructor == null) {
                    String string2 = NativeJavaMethod.scriptSignature(objectArray);
                    throw Context.reportRuntimeError2("msg.no.java.ctor", clazz.getName(), string2);
                }
                return NativeJavaClass.constructSpecific(context, scriptable, this, constructor, objectArray);
            }
            Scriptable scriptable2 = ScriptableObject.getTopLevelScope(this);
            string = "";
            try {
                Object object = scriptable2.get("JavaAdapter", scriptable2);
                if (object != Scriptable.NOT_FOUND) {
                    Function function = (Function)object;
                    Object[] objectArray2 = new Object[]{this, objectArray[0]};
                    return function.construct(context, scriptable2, objectArray2);
                }
            }
            catch (Exception exception) {
                String string3 = exception.getMessage();
                if (string3 == null) break block5;
                string = string3;
            }
        }
        throw Context.reportRuntimeError2("msg.cant.instantiate", string, clazz.getName());
    }

    public static Scriptable constructSpecific(Context context, Scriptable scriptable, Scriptable scriptable2, Constructor constructor, Object[] objectArray) throws JavaScriptException {
        Scriptable scriptable3 = ScriptableObject.getTopLevelScope(scriptable2);
        Class clazz = constructor.getDeclaringClass();
        Class<?>[] classArray = constructor.getParameterTypes();
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = NativeJavaObject.coerceType(classArray[n], objectArray[n]);
            ++n;
        }
        try {
            return (Scriptable)NativeJavaObject.wrap(scriptable3, constructor.newInstance(objectArray), clazz);
        }
        catch (InstantiationException instantiationException) {
            throw Context.reportRuntimeError2("msg.cant.instantiate", instantiationException.getMessage(), clazz.getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = NativeJavaMethod.scriptSignature(objectArray);
            String string2 = constructor.toString();
            throw Context.reportRuntimeError3("msg.bad.ctor.sig", illegalArgumentException.getMessage(), string2, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JavaScriptException.wrapException(scriptable, invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Context.reportRuntimeError1("msg.java.internal.private", illegalAccessException.getMessage());
        }
    }

    public Object get(String string, Scriptable scriptable) {
        if (string.equals("prototype")) {
            return null;
        }
        Object object = Scriptable.NOT_FOUND;
        if (this.fieldAndMethods != null && (object = this.fieldAndMethods.get(string)) != null) {
            return object;
        }
        if (this.members.has(string, true)) {
            object = this.members.get(this, string, this.javaObject, true);
        } else {
            try {
                String string2 = String.valueOf(this.getClassObject().getName()) + '$' + string;
                Class clazz = ScriptRuntime.loadClassName(string2);
                NativeJavaClass nativeJavaClass = NativeJavaClass.wrap(ScriptableObject.getTopLevelScope(this), clazz);
                nativeJavaClass.setParentScope(this);
                object = nativeJavaClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw this.members.reportMemberNotFound(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this.members.reportMemberNotFound(string);
            }
        }
        return object;
    }

    public String getClassName() {
        return "JavaClass";
    }

    public Class getClassObject() {
        return (Class)super.unwrap();
    }

    public Object getDefaultValue(Class clazz) {
        if (clazz == null || clazz == ScriptRuntime.StringClass) {
            return this.toString();
        }
        if (clazz == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (clazz == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    public Object[] getIds() {
        return this.members.getIds(true);
    }

    public boolean has(String string, Scriptable scriptable) {
        return this.members.has(string, true);
    }

    public boolean hasInstance(Scriptable scriptable) {
        if (scriptable instanceof Wrapper && !(scriptable instanceof NativeJavaClass)) {
            Object object = ((Wrapper)((Object)scriptable)).unwrap();
            return this.getClassObject().isInstance(object);
        }
        return false;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        this.members.put(this, string, this.javaObject, object, true);
    }

    public String toString() {
        return "[JavaClass " + this.getClassObject().getName() + "]";
    }

    public static NativeJavaClass wrap(Scriptable scriptable, Class clazz) {
        return new NativeJavaClass(scriptable, clazz);
    }
}

