/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeString
extends IdScriptable {
    private static final int ConstructorId_fromCharCode = -1;
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int Id_constructor = 2;
    private static final int Id_toString = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_charAt = 5;
    private static final int Id_charCodeAt = 6;
    private static final int Id_indexOf = 7;
    private static final int Id_lastIndexOf = 8;
    private static final int Id_split = 9;
    private static final int Id_substring = 10;
    private static final int Id_toLowerCase = 11;
    private static final int Id_toUpperCase = 12;
    private static final int Id_substr = 13;
    private static final int Id_concat = 14;
    private static final int Id_slice = 15;
    private static final int Id_bold = 16;
    private static final int Id_italics = 17;
    private static final int Id_fixed = 18;
    private static final int Id_strike = 19;
    private static final int Id_small = 20;
    private static final int Id_big = 21;
    private static final int Id_blink = 22;
    private static final int Id_sup = 23;
    private static final int Id_sub = 24;
    private static final int Id_fontsize = 25;
    private static final int Id_fontcolor = 26;
    private static final int Id_link = 27;
    private static final int Id_anchor = 28;
    private static final int Id_equals = 29;
    private static final int Id_equalsIgnoreCase = 30;
    private static final int Id_match = 31;
    private static final int Id_search = 32;
    private static final int Id_replace = 33;
    private static final int MAX_PROTOTYPE_ID = 33;
    private static final String defaultValue = "";
    private String string;
    private boolean prototypeFlag;

    public NativeString() {
        this.string = defaultValue;
    }

    public NativeString(String string) {
        this.string = string;
    }

    private static RegExpProxy checkReProxy(Context context) {
        RegExpProxy regExpProxy = context.getRegExpProxy();
        if (regExpProxy == null) {
            throw Context.reportRuntimeError0("msg.no.regexp");
        }
        return regExpProxy;
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (n) {
                case -1: {
                    return NativeString.jsStaticFunction_fromCharCode(objectArray);
                }
                case 2: {
                    return NativeString.jsConstructor(objectArray, scriptable2 == null);
                }
                case 3: {
                    return this.realThis(scriptable2, idFunction).jsFunction_toString();
                }
                case 4: {
                    return this.realThis(scriptable2, idFunction).jsFunction_valueOf();
                }
                case 5: {
                    return NativeString.jsFunction_charAt(ScriptRuntime.toString(scriptable2), objectArray);
                }
                case 6: {
                    return this.wrap_double(NativeString.jsFunction_charCodeAt(ScriptRuntime.toString(scriptable2), objectArray));
                }
                case 7: {
                    return this.wrap_int(NativeString.jsFunction_indexOf(ScriptRuntime.toString(scriptable2), objectArray));
                }
                case 8: {
                    return this.wrap_int(NativeString.jsFunction_lastIndexOf(ScriptRuntime.toString(scriptable2), objectArray));
                }
                case 9: {
                    return NativeString.jsFunction_split(context, scriptable, ScriptRuntime.toString(scriptable2), objectArray);
                }
                case 10: {
                    return NativeString.jsFunction_substring(context, ScriptRuntime.toString(scriptable2), objectArray);
                }
                case 11: {
                    return NativeString.jsFunction_toLowerCase(ScriptRuntime.toString(scriptable2));
                }
                case 12: {
                    return NativeString.jsFunction_toUpperCase(ScriptRuntime.toString(scriptable2));
                }
                case 13: {
                    return NativeString.jsFunction_substr(ScriptRuntime.toString(scriptable2), objectArray);
                }
                case 14: {
                    return NativeString.jsFunction_concat(ScriptRuntime.toString(scriptable2), objectArray);
                }
                case 15: {
                    return NativeString.jsFunction_slice(ScriptRuntime.toString(scriptable2), objectArray);
                }
                case 16: {
                    return this.realThis(scriptable2, idFunction).tagify("b", null, null);
                }
                case 17: {
                    return this.realThis(scriptable2, idFunction).tagify("i", null, null);
                }
                case 18: {
                    return this.realThis(scriptable2, idFunction).tagify("tt", null, null);
                }
                case 19: {
                    return this.realThis(scriptable2, idFunction).tagify("strike", null, null);
                }
                case 20: {
                    return this.realThis(scriptable2, idFunction).tagify("small", null, null);
                }
                case 21: {
                    return this.realThis(scriptable2, idFunction).tagify("big", null, null);
                }
                case 22: {
                    return this.realThis(scriptable2, idFunction).tagify("blink", null, null);
                }
                case 23: {
                    return this.realThis(scriptable2, idFunction).tagify("sup", null, null);
                }
                case 24: {
                    return this.realThis(scriptable2, idFunction).tagify("sub", null, null);
                }
                case 25: {
                    return this.realThis(scriptable2, idFunction).tagify("font size", "font", ScriptRuntime.toString(objectArray, 0));
                }
                case 26: {
                    return this.realThis(scriptable2, idFunction).tagify("font color", "font", ScriptRuntime.toString(objectArray, 0));
                }
                case 27: {
                    return this.realThis(scriptable2, idFunction).tagify("a href", "a", ScriptRuntime.toString(objectArray, 0));
                }
                case 28: {
                    return this.realThis(scriptable2, idFunction).tagify("a name", "a", ScriptRuntime.toString(objectArray, 0));
                }
                case 29: {
                    return this.wrap_boolean(NativeString.jsFunction_equals(ScriptRuntime.toString(scriptable2), ScriptRuntime.toString(objectArray, 0)));
                }
                case 30: {
                    return this.wrap_boolean(NativeString.jsFunction_equalsIgnoreCase(ScriptRuntime.toString(scriptable2), ScriptRuntime.toString(objectArray, 0)));
                }
                case 31: {
                    return NativeString.checkReProxy(context).match(context, scriptable, scriptable2, objectArray);
                }
                case 32: {
                    return NativeString.checkReProxy(context).search(context, scriptable, scriptable2, objectArray);
                }
                case 33: {
                    return NativeString.checkReProxy(context).replace(context, scriptable, scriptable2, objectArray);
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    protected void fillConstructorProperties(Context context, IdFunction idFunction, boolean bl) {
        this.addIdFunctionProperty(idFunction, -1, bl);
        super.fillConstructorProperties(context, idFunction, bl);
    }

    /*
     * Unable to fully structure code
     */
    private static int find_split(Scriptable var0, String var1_1, String var2_2, Object var3_3, int[] var4_4, int[] var5_5, boolean[] var6_6, String[][] var7_7) {
        block11: {
            var8_8 = var4_4[0];
            var9_9 = var1_1.length();
            var10_10 = Context.getContext();
            var11_11 = var10_10.getLanguageVersion();
            if (var11_11 != 120 || var3_3 != null || var2_2.length() != 1 || var2_2.charAt(0) != ' ') break block11;
            if (var8_8 == 0) {
                while (var8_8 < var9_9 && Character.isWhitespace(var1_1.charAt(var8_8))) {
                    ++var8_8;
                }
                var4_4[0] = var8_8;
            }
            if (var8_8 != var9_9) ** GOTO lbl14
            return -1;
lbl-1000:
            // 1 sources

            {
                ++var8_8;
lbl14:
                // 2 sources

                ** while (var8_8 < var9_9 && !Character.isWhitespace((char)var1_1.charAt((int)var8_8)))
            }
lbl15:
            // 1 sources

            var12_12 = var8_8;
            while (var12_12 < var9_9 && Character.isWhitespace(var1_1.charAt(var12_12))) {
                ++var12_12;
            }
            var5_5[0] = var12_12 - var8_8;
            return var8_8;
        }
        if (var8_8 > var9_9) {
            return -1;
        }
        if (var3_3 != null) {
            return var10_10.getRegExpProxy().find_split(var0, var1_1, var2_2, var3_3, var4_4, var5_5, var6_6, var7_7);
        }
        if (var11_11 != 0 && var11_11 < 130 && var9_9 == 0) {
            return -1;
        }
        if (var2_2.length() == 0) {
            if (var11_11 == 120) {
                if (var8_8 == var9_9) {
                    var5_5[0] = 1;
                    return var8_8;
                }
                return var8_8 + 1;
            }
            return var8_8 == var9_9 ? -1 : var8_8 + 1;
        }
        if (var4_4[0] >= var9_9) {
            return var9_9;
        }
        var8_8 = var1_1.indexOf(var2_2, var4_4[0]);
        return var8_8 != -1 ? var8_8 : var9_9;
    }

    public Object get(int n, Scriptable scriptable) {
        if (n >= 0 && n < this.string.length()) {
            return this.string.substring(n, n + 1);
        }
        return super.get(n, scriptable);
    }

    public String getClassName() {
        return "String";
    }

    protected int getIdDefaultAttributes(int n) {
        if (n == 1) {
            return 7;
        }
        return super.getIdDefaultAttributes(n);
    }

    protected String getIdName(int n) {
        if (n == 1) {
            return "length";
        }
        if (this.prototypeFlag) {
            switch (n) {
                case -1: {
                    return "fromCharCode";
                }
                case 2: {
                    return "constructor";
                }
                case 3: {
                    return "toString";
                }
                case 4: {
                    return "valueOf";
                }
                case 5: {
                    return "charAt";
                }
                case 6: {
                    return "charCodeAt";
                }
                case 7: {
                    return "indexOf";
                }
                case 8: {
                    return "lastIndexOf";
                }
                case 9: {
                    return "split";
                }
                case 10: {
                    return "substring";
                }
                case 11: {
                    return "toLowerCase";
                }
                case 12: {
                    return "toUpperCase";
                }
                case 13: {
                    return "substr";
                }
                case 14: {
                    return "concat";
                }
                case 15: {
                    return "slice";
                }
                case 16: {
                    return "bold";
                }
                case 17: {
                    return "italics";
                }
                case 18: {
                    return "fixed";
                }
                case 19: {
                    return "strike";
                }
                case 20: {
                    return "small";
                }
                case 21: {
                    return "big";
                }
                case 22: {
                    return "blink";
                }
                case 23: {
                    return "sup";
                }
                case 24: {
                    return "sub";
                }
                case 25: {
                    return "fontsize";
                }
                case 26: {
                    return "fontcolor";
                }
                case 27: {
                    return "link";
                }
                case 28: {
                    return "anchor";
                }
                case 29: {
                    return "equals";
                }
                case 30: {
                    return "equalsIgnoreCase";
                }
                case 31: {
                    return "match";
                }
                case 32: {
                    return "search";
                }
                case 33: {
                    return "replace";
                }
            }
        }
        return null;
    }

    protected Object getIdValue(int n) {
        if (n == 1) {
            return this.wrap_int(this.string.length());
        }
        return super.getIdValue(n);
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeString nativeString = new NativeString();
        nativeString.prototypeFlag = true;
        nativeString.addAsPrototype(33, context, scriptable, bl);
    }

    private static Object jsConstructor(Object[] objectArray, boolean bl) {
        String string;
        String string2 = string = objectArray.length >= 1 ? ScriptRuntime.toString(objectArray[0]) : defaultValue;
        if (bl) {
            return new NativeString(string);
        }
        return string;
    }

    private static String jsFunction_charAt(String string, Object[] objectArray) {
        double d = ScriptRuntime.toInteger(objectArray, 0);
        if (d < 0.0 || d >= (double)string.length()) {
            return defaultValue;
        }
        return string.substring((int)d, (int)d + 1);
    }

    private static double jsFunction_charCodeAt(String string, Object[] objectArray) {
        double d = ScriptRuntime.toInteger(objectArray, 0);
        if (d < 0.0 || d >= (double)string.length()) {
            return ScriptRuntime.NaN;
        }
        return string.charAt((int)d);
    }

    private static String jsFunction_concat(String string, Object[] objectArray) {
        int n = objectArray.length;
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(ScriptRuntime.toString(objectArray[n2]));
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static boolean jsFunction_equals(String string, String string2) {
        return string.equals(string2);
    }

    private static boolean jsFunction_equalsIgnoreCase(String string, String string2) {
        return string.equalsIgnoreCase(string2);
    }

    private static int jsFunction_indexOf(String string, Object[] objectArray) {
        String string2 = ScriptRuntime.toString(objectArray, 0);
        double d = ScriptRuntime.toInteger(objectArray, 1);
        if (d > (double)string.length()) {
            return -1;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        return string.indexOf(string2, (int)d);
    }

    private static int jsFunction_lastIndexOf(String string, Object[] objectArray) {
        String string2 = ScriptRuntime.toString(objectArray, 0);
        double d = ScriptRuntime.toNumber(objectArray, 1);
        if (d != d || d > (double)string.length()) {
            d = string.length();
        } else if (d < 0.0) {
            d = 0.0;
        }
        return string.lastIndexOf(string2, (int)d);
    }

    private static String jsFunction_slice(String string, Object[] objectArray) {
        if (objectArray.length != 0) {
            double d;
            double d2 = ScriptRuntime.toInteger(objectArray[0]);
            int n = string.length();
            if (d2 < 0.0) {
                if ((d2 += (double)n) < 0.0) {
                    d2 = 0.0;
                }
            } else if (d2 > (double)n) {
                d2 = n;
            }
            if (objectArray.length == 1) {
                d = n;
            } else {
                d = ScriptRuntime.toInteger(objectArray[1]);
                if (d < 0.0) {
                    if ((d += (double)n) < 0.0) {
                        d = 0.0;
                    }
                } else if (d > (double)n) {
                    d = n;
                }
                if (d < d2) {
                    d = d2;
                }
            }
            return string.substring((int)d2, (int)d);
        }
        return string;
    }

    private static Object jsFunction_split(Context context, Scriptable scriptable, String string, Object[] objectArray) {
        int n;
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        Scriptable scriptable3 = ScriptRuntime.newObject(context, scriptable2, "Array", null);
        if (objectArray.length < 1) {
            scriptable3.put(0, scriptable3, (Object)string);
            return scriptable3;
        }
        boolean bl = objectArray.length > 1 && objectArray[1] != Undefined.instance;
        long l = 0L;
        if (bl && (l = ScriptRuntime.toUint32(objectArray[1])) > (long)string.length()) {
            l = 1 + string.length();
        }
        String string2 = null;
        int[] nArray = new int[1];
        Object object = null;
        RegExpProxy regExpProxy = context.getRegExpProxy();
        if (regExpProxy != null && regExpProxy.isRegExp(objectArray[0])) {
            object = objectArray[0];
        } else {
            string2 = ScriptRuntime.toString(objectArray[0]);
            nArray[0] = string2.length();
        }
        int[] nArray2 = new int[1];
        int n2 = 0;
        boolean[] blArray = new boolean[1];
        String[][] stringArray = new String[][]{null};
        while ((n = NativeString.find_split(scriptable, string, string2, object, nArray2, nArray, blArray, stringArray)) >= 0) {
            if (bl && (long)n2 >= l || n > string.length()) break;
            String string3 = string.length() == 0 ? string : string.substring(nArray2[0], n);
            scriptable3.put(n2, scriptable3, (Object)string3);
            ++n2;
            if (object != null && blArray[0]) {
                int n3 = stringArray[0].length;
                int n4 = 0;
                while (n4 < n3) {
                    if (bl && (long)n2 >= l) break;
                    scriptable3.put(n2, scriptable3, (Object)stringArray[0][n4]);
                    ++n2;
                    ++n4;
                }
                blArray[0] = false;
            }
            nArray2[0] = n + nArray[0];
            if (context.getLanguageVersion() < 130 && context.getLanguageVersion() != 0 && !bl && nArray2[0] == string.length()) break;
        }
        return scriptable3;
    }

    private static String jsFunction_substr(String string, Object[] objectArray) {
        double d;
        if (objectArray.length < 1) {
            return string;
        }
        double d2 = ScriptRuntime.toInteger(objectArray[0]);
        int n = string.length();
        if (d2 < 0.0) {
            if ((d2 += (double)n) < 0.0) {
                d2 = 0.0;
            }
        } else if (d2 > (double)n) {
            d2 = n;
        }
        if (objectArray.length == 1) {
            d = n;
        } else {
            d = ScriptRuntime.toInteger(objectArray[1]);
            if (d < 0.0) {
                d = 0.0;
            }
            if ((d += d2) > (double)n) {
                d = n;
            }
        }
        return string.substring((int)d2, (int)d);
    }

    private static String jsFunction_substring(Context context, String string, Object[] objectArray) {
        double d;
        int n = string.length();
        double d2 = ScriptRuntime.toInteger(objectArray, 0);
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > (double)n) {
            d2 = n;
        }
        if (objectArray.length <= 1 || objectArray[1] == Undefined.instance) {
            d = n;
        } else {
            d = ScriptRuntime.toInteger(objectArray[1]);
            if (d < 0.0) {
                d = 0.0;
            } else if (d > (double)n) {
                d = n;
            }
            if (d < d2) {
                if (context.getLanguageVersion() != 120) {
                    double d3 = d2;
                    d2 = d;
                    d = d3;
                } else {
                    d = d2;
                }
            }
        }
        return string.substring((int)d2, (int)d);
    }

    private static String jsFunction_toLowerCase(String string) {
        return string.toLowerCase();
    }

    private String jsFunction_toString() {
        return this.string;
    }

    private static String jsFunction_toUpperCase(String string) {
        return string.toUpperCase();
    }

    private String jsFunction_valueOf() {
        return this.string;
    }

    public double jsGet_length() {
        return this.string.length();
    }

    private static String jsStaticFunction_fromCharCode(Object[] objectArray) {
        int n = objectArray.length;
        if (n < 1) {
            return defaultValue;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(ScriptRuntime.toUint16(objectArray[n2]));
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected int mapNameToId(String string) {
        if (string.equals("length")) {
            return 1;
        }
        if (this.prototypeFlag) {
            return NativeString.toPrototypeId(string);
        }
        return 0;
    }

    protected int maxInstanceId() {
        return 1;
    }

    public int methodArity(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case -1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 1;
                }
                case 7: {
                    return 2;
                }
                case 8: {
                    return 2;
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 2;
                }
                case 11: {
                    return 0;
                }
                case 12: {
                    return 0;
                }
                case 13: {
                    return 2;
                }
                case 14: {
                    return 1;
                }
                case 15: {
                    return 2;
                }
                case 16: {
                    return 0;
                }
                case 17: {
                    return 0;
                }
                case 18: {
                    return 0;
                }
                case 19: {
                    return 0;
                }
                case 20: {
                    return 0;
                }
                case 21: {
                    return 0;
                }
                case 22: {
                    return 0;
                }
                case 23: {
                    return 0;
                }
                case 24: {
                    return 0;
                }
                case 25: {
                    return 0;
                }
                case 26: {
                    return 0;
                }
                case 27: {
                    return 0;
                }
                case 28: {
                    return 0;
                }
                case 29: {
                    return 1;
                }
                case 30: {
                    return 1;
                }
                case 31: {
                    return 1;
                }
                case 32: {
                    return 1;
                }
                case 33: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (n >= 0 && n < this.string.length()) {
            return;
        }
        super.put(n, scriptable, object);
    }

    private NativeString realThis(Scriptable scriptable, IdFunction idFunction) {
        while (!(scriptable instanceof NativeString)) {
            scriptable = this.nextInstanceCheck(scriptable, idFunction, true);
        }
        return (NativeString)scriptable;
    }

    private String tagify(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        stringBuffer.append(string);
        if (string3 != null) {
            stringBuffer.append("=\"");
            stringBuffer.append(string3);
            stringBuffer.append('\"');
        }
        stringBuffer.append('>');
        stringBuffer.append(this.string);
        stringBuffer.append("</");
        stringBuffer.append(string2 == null ? string : string2);
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    /*
     * Exception decompiling
     */
    private static int toPrototypeId(String var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return this.string;
    }
}

