/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.PreorderNodeIterator;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ShallowNodeIterator;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.VariableTable;

public class NodeTransformer {
    protected Stack loops;
    protected Stack loopEnds;
    protected boolean inFunction;
    protected IRFactory irFactory;

    protected void addParameters(FunctionNode functionNode) {
        VariableTable variableTable = functionNode.getVariableTable();
        Node node = functionNode.getFirstChild();
        if (node.getType() == 94 && variableTable.getParameterCount() == 0) {
            ShallowNodeIterator shallowNodeIterator = node.getChildIterator();
            while (shallowNodeIterator.hasMoreElements()) {
                Node node2 = shallowNodeIterator.nextNode();
                String string = node2.getString();
                variableTable.addParameter(string);
            }
        }
    }

    protected void addVariables(Node node, VariableTable variableTable) {
        Node node2;
        Object object;
        Node node3;
        boolean bl = node.getType() == 110;
        PreorderNodeIterator preorderNodeIterator = node.getPreorderIterator();
        Hashtable<Object, Boolean> hashtable = null;
        while ((node3 = preorderNodeIterator.nextNode()) != null) {
            int n = node3.getType();
            if (bl && n == 110 && node3 != node && ((FunctionNode)node3.getProp(5)).getFunctionType() == 3) {
                object = node3.getString();
                if (object == null) continue;
                variableTable.removeLocal((String)object);
                if (hashtable == null) {
                    hashtable = new Hashtable<Object, Boolean>();
                }
                hashtable.put(object, Boolean.TRUE);
            }
            if (n != 123) continue;
            object = node3.getChildIterator();
            while (((ShallowNodeIterator)object).hasMoreElements()) {
                node2 = ((ShallowNodeIterator)object).nextNode();
                if (hashtable != null && hashtable.get(node2.getString()) != null) continue;
                variableTable.addLocal(node2.getString());
            }
        }
        String string = (String)node.getDatum();
        if (bl && ((FunctionNode)node).getFunctionType() == 2 && string != null && string.length() > 0 && variableTable.getVariable(string) == null) {
            variableTable.addLocal(string);
            object = node.getLastChild();
            node2 = new Node(57, new Node(73, new Node(46, string), new Node(109, new Integer(87))));
            ((Node)object).addChildrenToFront(node2);
        }
    }

    public IRFactory createIRFactory(TokenStream tokenStream, Scriptable scriptable) {
        return new IRFactory(tokenStream, scriptable);
    }

    protected VariableTable createVariableTable() {
        return new VariableTable();
    }

    protected VariableTable getVariableTable(Node node) {
        if (this.inFunction) {
            return ((FunctionNode)node).getVariableTable();
        }
        VariableTable variableTable = (VariableTable)node.getProp(10);
        if (variableTable == null) {
            variableTable = this.createVariableTable();
            node.putProp(10, variableTable);
        }
        return variableTable;
    }

    protected boolean inWithStatement() {
        int n = this.loops.size() - 1;
        while (n >= 0) {
            Node node = (Node)this.loops.elementAt(n);
            if (node.getType() == 124) {
                return true;
            }
            --n;
        }
        return false;
    }

    private boolean isSpecialCallName(Node node, Node node2) {
        Node node3 = node2.getFirstChild();
        boolean bl = false;
        if (node3.getType() == 44) {
            String string = node3.getString();
            bl = string.equals("eval") || string.equals("With");
        } else if (node3.getType() == 39) {
            String string = node3.getLastChild().getString();
            bl = string.equals("exec");
        }
        if (bl) {
            if (this.inFunction) {
                ((FunctionNode)node).setRequiresActivation(true);
            }
            return true;
        }
        return false;
    }

    public NodeTransformer newInstance() {
        return new NodeTransformer();
    }

    protected void reportMessage(Context context, String string, Node node, Node node2, boolean bl, Scriptable scriptable) {
        Object object;
        Object object2 = node.getDatum();
        int n = 0;
        if (object2 != null && object2 instanceof Integer) {
            n = (Integer)object2;
        }
        Object object3 = object = node2 == null ? null : node2.getProp(16);
        if (bl) {
            if (scriptable != null) {
                throw NativeGlobal.constructError(context, "SyntaxError", string, scriptable, (String)object, n, 0, null);
            }
            Context.reportError(string, (String)object, n, null, 0);
        } else {
            Context.reportWarning(string, (String)object, n, null, 0);
        }
    }

    public Node transform(Node node, Node node2, TokenStream tokenStream, Scriptable scriptable) {
        Node node3;
        this.loops = new Stack();
        this.loopEnds = new Stack();
        boolean bl = this.inFunction = node.getType() == 110;
        if (!this.inFunction) {
            this.addVariables(node, this.getVariableTable(node));
        }
        this.irFactory = this.createIRFactory(tokenStream, scriptable);
        boolean bl2 = false;
        PreorderNodeIterator preorderNodeIterator = node.getPreorderIterator();
        block22: while ((node3 = preorderNodeIterator.nextNode()) != null) {
            int n = node3.getType();
            block0 : switch (n) {
                case 110: {
                    Cloneable cloneable;
                    if (node3 == node) {
                        cloneable = this.getVariableTable(node);
                        this.addVariables(node, (VariableTable)((Object)cloneable));
                        Node node4 = node3.getLastChild();
                        Node node5 = node4.getLastChild();
                        if (node5 != null && node5.getType() == 5) continue block22;
                        node4.addChildToBack(new Node(5));
                        break;
                    }
                    cloneable = (FunctionNode)node3.getProp(5);
                    if (this.inFunction) {
                        ((FunctionNode)node).setRequiresActivation(true);
                        ((FunctionNode)cloneable).setCheckThis(true);
                    }
                    this.addParameters((FunctionNode)cloneable);
                    NodeTransformer nodeTransformer = this.newInstance();
                    cloneable = (FunctionNode)nodeTransformer.transform((Node)cloneable, node, tokenStream, scriptable);
                    node3.putProp(5, cloneable);
                    Vector<Cloneable> vector = (Vector<Cloneable>)node.getProp(5);
                    if (vector == null) {
                        vector = new Vector<Cloneable>(7);
                        node.putProp(5, vector);
                    }
                    vector.addElement(cloneable);
                    break;
                }
                case 136: {
                    Object object4;
                    Node node6;
                    Cloneable cloneable = node3.getFirstChild();
                    node3.removeChild((Node)cloneable);
                    String string = ((Node)cloneable).getString();
                    int n2 = this.loops.size() - 1;
                    while (n2 >= 0) {
                        node6 = (Node)this.loops.elementAt(n2);
                        if (node6.getType() == 136 && string.equals(object4 = (String)node6.getProp(20))) {
                            String string2 = Context.getMessage1("msg.dup.label", string);
                            this.reportMessage(Context.getContext(), string2, node3, node, true, scriptable);
                            break block0;
                        }
                        --n2;
                    }
                    node3.putProp(20, string);
                    node6 = new Node(137);
                    object4 = preorderNodeIterator.getCurrentParent();
                    Node node7 = node3.getNextSibling();
                    while (node7 != null && (node7.getType() == 136 || node7.getType() == 137)) {
                        node7 = node7.getNextSibling();
                    }
                    if (node7 == null) break;
                    ((Node)object4).addChildAfter(node6, node7);
                    node3.putProp(2, node6);
                    if (node7.getType() == 138) {
                        node3.putProp(3, node7.getProp(3));
                    }
                    this.loops.push(node3);
                    this.loopEnds.push(node6);
                    break;
                }
                case 115: {
                    Object object4;
                    Cloneable cloneable = new Node(137);
                    Node node8 = preorderNodeIterator.getCurrentParent();
                    node8.addChildAfter((Node)cloneable, node3);
                    Node node9 = node3;
                    Object object2 = node3.getFirstChild().next;
                    while (object2 != null) {
                        object4 = ((Node)object2).next;
                        node3.removeChild((Node)object2);
                        node8.addChildAfter((Node)object2, node9);
                        node9 = object2;
                        object2 = object4;
                    }
                    node3.putProp(2, cloneable);
                    this.loops.push(node3);
                    this.loopEnds.push(cloneable);
                    node3.putProp(13, new Vector(13));
                    break;
                }
                case 116: 
                case 117: {
                    Cloneable cloneable = (Node)this.loops.peek();
                    if (n == 116) {
                        Vector vector = (Vector)((Node)cloneable).getProp(13);
                        vector.addElement(node3);
                        break;
                    }
                    ((Node)cloneable).putProp(14, node3);
                    break;
                }
                case 144: {
                    Cloneable cloneable = (Integer)node.getProp(22);
                    if (cloneable == null) {
                        node.putProp(22, new Integer(1));
                        break;
                    }
                    node.putProp(22, new Integer((Integer)((Object)cloneable) + 1));
                    break;
                }
                case 138: {
                    this.loops.push(node3);
                    this.loopEnds.push(node3.getProp(2));
                    break;
                }
                case 124: {
                    if (this.inFunction) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    this.loops.push(node3);
                    Cloneable cloneable = node3.getNextSibling();
                    if (((Node)cloneable).getType() != 4) {
                        throw new RuntimeException("Unexpected tree");
                    }
                    this.loopEnds.push(cloneable);
                    break;
                }
                case 75: {
                    Integer n3;
                    Cloneable cloneable = (Node)node3.getProp(21);
                    if (cloneable != null) {
                        bl2 = true;
                        this.loops.push(node3);
                        this.loopEnds.push(cloneable);
                    }
                    if ((n3 = (Integer)node.getProp(22)) == null) {
                        node.putProp(22, new Integer(1));
                        break;
                    }
                    node.putProp(22, new Integer(n3 + 1));
                    break;
                }
                case 4: 
                case 137: {
                    if (this.loopEnds.empty() || this.loopEnds.peek() != node3) continue block22;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 5: {
                    Object object4;
                    if (!bl2) break;
                    Cloneable cloneable = preorderNodeIterator.getCurrentParent();
                    int n4 = this.loops.size() - 1;
                    while (n4 >= 0) {
                        Node node10 = (Node)this.loops.elementAt(n4);
                        int n5 = node10.getType();
                        if (n5 == 75) {
                            object4 = new Node(143);
                            Object object3 = node10.getProp(21);
                            ((Node)object4).putProp(1, object3);
                            ((Node)cloneable).addChildBefore((Node)object4, node3);
                        } else if (n5 == 124) {
                            ((Node)cloneable).addChildBefore(new Node(4), node3);
                        }
                        --n4;
                    }
                    continue block22;
                }
                case 121: 
                case 122: {
                    Node node11;
                    Object[] objectArray;
                    Object object;
                    Cloneable cloneable = null;
                    boolean bl3 = node3.hasChildren();
                    String string = null;
                    if (bl3) {
                        Node node12 = node3.getFirstChild();
                        string = node12.getString();
                        node3.removeChild(node12);
                    }
                    Object object4 = preorderNodeIterator.getCurrentParent();
                    int n6 = this.loops.size() - 1;
                    while (n6 >= 0) {
                        Node node13 = (Node)this.loops.elementAt(n6);
                        int n7 = node13.getType();
                        if (n7 == 124) {
                            ((Node)object4).addChildBefore(new Node(4), node3);
                        } else if (n7 == 75) {
                            object = new Node(143);
                            objectArray = node13.getProp(21);
                            ((Node)object).putProp(1, objectArray);
                            ((Node)object4).addChildBefore((Node)object, node3);
                        } else {
                            if (!bl3 && (n7 == 138 || n7 == 115 && n == 121)) {
                                cloneable = node13;
                                break;
                            }
                            if (bl3 && n7 == 136 && string.equals((String)node13.getProp(20))) {
                                cloneable = node13;
                                break;
                            }
                        }
                        --n6;
                    }
                    int n8 = n == 121 ? 2 : 3;
                    Node node14 = node11 = cloneable == null ? null : (Node)((Node)cloneable).getProp(n8);
                    if (cloneable == null || node11 == null) {
                        if (!bl3) {
                            object = n == 122 ? Context.getMessage("msg.continue.outside", null) : Context.getMessage("msg.bad.break", null);
                        } else if (cloneable != null) {
                            object = Context.getMessage0("msg.continue.nonloop");
                        } else {
                            objectArray = new Object[]{string};
                            object = Context.getMessage("msg.undef.label", objectArray);
                        }
                        this.reportMessage(Context.getContext(), (String)object, node3, node, true, scriptable);
                        node3.setType(128);
                        break;
                    }
                    node3.setType(6);
                    node3.putProp(1, node11);
                    break;
                }
                case 43: {
                    if (this.isSpecialCallName(node, node3)) {
                        node3.putProp(30, Boolean.TRUE);
                    }
                    this.visitCall(node3, node);
                    break;
                }
                case 30: {
                    if (this.isSpecialCallName(node, node3)) {
                        node3.putProp(30, Boolean.TRUE);
                    }
                    this.visitNew(node3, node);
                    break;
                }
                case 108: {
                    Cloneable cloneable = node3.getLastChild();
                    ((Node)cloneable).setType(46);
                    break;
                }
                case 140: {
                    node3.setType(this.inFunction ? 57 : 2);
                    break;
                }
                case 56: {
                    Cloneable cloneable = (Vector)node.getProp(12);
                    if (cloneable == null) {
                        cloneable = new Vector<Node>(3);
                        node.putProp(12, cloneable);
                    }
                    ((Vector)cloneable).addElement(node3);
                    Node node15 = new Node(56);
                    preorderNodeIterator.replaceCurrent(node15);
                    node15.putProp(12, node3);
                    break;
                }
                case 123: {
                    Object object4;
                    Cloneable cloneable = node3.getChildIterator();
                    Node node16 = new Node(133);
                    while (((ShallowNodeIterator)((Object)cloneable)).hasMoreElements()) {
                        Node node17 = ((ShallowNodeIterator)((Object)cloneable)).nextNode();
                        if (!node17.hasChildren()) continue;
                        Node node18 = node17.getFirstChild();
                        node17.removeChild(node18);
                        object4 = (Node)this.irFactory.createAssignment(128, node17, node18, null, false);
                        Node node19 = new Node(57, (Node)object4, node3.getDatum());
                        node16.addChildToBack(node19);
                    }
                    preorderNodeIterator.replaceCurrent(node16);
                    break;
                }
                case 10: 
                case 31: {
                    VariableTable variableTable;
                    Cloneable cloneable;
                    if (!this.inFunction || this.inWithStatement() || (cloneable = node3.getFirstChild()) == null || ((Node)cloneable).getType() != 61) continue block22;
                    String string = ((Node)cloneable).getString();
                    Context context = Context.getCurrentContext();
                    if (context != null && context.isActivationNeeded(string)) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    if ((variableTable = this.getVariableTable(node)).getVariable(string) == null) break;
                    if (n == 10) {
                        node3.setType(73);
                        ((Node)cloneable).setType(46);
                        break;
                    }
                    Object object4 = new Node(109, new Integer(51));
                    preorderNodeIterator.replaceCurrent((Node)object4);
                    break;
                }
                case 39: {
                    if (!this.inFunction) break;
                    Cloneable cloneable = node3.getFirstChild().getNextSibling();
                    String string = cloneable == null ? "" : ((Node)cloneable).getString();
                    Context context = Context.getCurrentContext();
                    if ((context == null || !context.isActivationNeeded(string)) && (!string.equals("length") || Context.getContext().getLanguageVersion() != 120)) continue block22;
                    ((FunctionNode)node).setRequiresActivation(true);
                    break;
                }
                case 44: {
                    VariableTable variableTable;
                    if (!this.inFunction || this.inWithStatement()) continue block22;
                    Cloneable cloneable = node3.getString();
                    Context context = Context.getCurrentContext();
                    if (context != null && context.isActivationNeeded((String)((Object)cloneable))) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    if ((variableTable = this.getVariableTable(node)).getVariable((String)((Object)cloneable)) == null) break;
                    node3.setType(72);
                    break;
                }
            }
        }
        return node;
    }

    protected void visitCall(Node node, Node node2) {
        Node node3;
        Object object;
        Object object2;
        Node node4 = node.getFirstChild();
        int n = 0;
        Node node5 = node4.getNextSibling();
        while (node5 != null) {
            node5 = node5.getNextSibling();
            ++n;
        }
        boolean bl = false;
        if (node4.getType() == 44) {
            object2 = this.getVariableTable(node2);
            object = node4.getString();
            if (this.inFunction && ((VariableTable)object2).getVariable((String)object) != null && !this.inWithStatement()) {
                node4.setType(72);
            } else {
                node.removeChild(node4);
                node4.setType(71);
                node3 = node4.cloneNode();
                node3.setType(46);
                Node node6 = new Node(39, node4, node3);
                node.addChildToFront(node6);
                node4 = node6;
                boolean bl2 = bl = this.inWithStatement() || !this.inFunction;
            }
        }
        if (node4.getType() != 39 && node4.getType() != 41) {
            node.removeChild(node4);
            object2 = this.irFactory.createNewTemp(node4);
            object = this.irFactory.createUseTemp((Node)object2);
            ((Node)object).putProp(6, object2);
            node3 = new Node(141, (Node)object);
            node.addChildToFront(node3);
            node.addChildToFront((Node)object2);
            return;
        }
        object2 = node4.getFirstChild();
        node4.removeChild((Node)object2);
        object = this.irFactory.createNewTemp((Node)object2);
        node4.addChildToFront((Node)object);
        node3 = this.irFactory.createUseTemp((Node)object);
        node3.putProp(6, object);
        if (bl) {
            node3 = new Node(68, node3);
        }
        node.addChildAfter(node3, node4);
    }

    protected void visitNew(Node node, Node node2) {
    }
}

