/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

public abstract class ScriptableObject
implements Scriptable {
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    protected Scriptable prototype;
    protected Scriptable parent;
    private static final Object HAS_STATIC_ACCESSORS = Void.TYPE;
    private static final Slot REMOVED = new Slot();
    private static Hashtable exclusionList = null;
    private Slot[] slots;
    private int count;
    private Slot lastAccess = REMOVED;
    private static final Class ContextClass = class$org$mozilla$javascript$Context != null ? class$org$mozilla$javascript$Context : (class$org$mozilla$javascript$Context = ScriptableObject.class$("org.mozilla.javascript.Context"));
    static /* synthetic */ Class class$org$mozilla$javascript$Context;
    static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;
    static /* synthetic */ Class class$org$mozilla$javascript$Function;
    static /* synthetic */ Class class$org$mozilla$javascript$FunctionObject;
    static /* synthetic */ Class class$org$mozilla$javascript$ScriptableObject;

    synchronized void addPropertyAttribute(int n) {
        if (this.slots == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.slots.length) {
            Slot slot = this.slots[n2];
            if (slot != null && slot != REMOVED && ((slot.flags & 2) == 0 || n != 1)) {
                slot.attributes = (short)(slot.attributes | n);
            }
            ++n2;
        }
    }

    private synchronized Slot addSlot(String string, int n, boolean bl) {
        int n2;
        if (this.count == -1) {
            throw Context.reportRuntimeError0("msg.add.sealed");
        }
        int n3 = n2 = (n & Integer.MAX_VALUE) % this.slots.length;
        do {
            Slot slot;
            if ((slot = this.slots[n3]) == null || slot == REMOVED) {
                if (4 * (this.count + 1) > 3 * this.slots.length) {
                    this.grow();
                    return this.getSlotToSet(string, n, bl);
                }
                slot = bl ? new GetterSlot() : new Slot();
                slot.stringKey = string;
                slot.intKey = n;
                this.slots[n3] = slot;
                ++this.count;
                return slot;
            }
            if (slot.intKey == n && (slot.stringKey == string || string != null && string.equals(slot.stringKey))) {
                return slot;
            }
            if (++n3 != this.slots.length) continue;
            n3 = 0;
        } while (n3 != n2);
        throw new RuntimeException("Hashtable internal error");
    }

    public static Object callMethod(Scriptable scriptable, String string, Object[] objectArray) throws JavaScriptException {
        Object object;
        Context context = Context.enter();
        try {
            Object object2 = ScriptableObject.getProperty(scriptable, string);
            if (object2 == Scriptable.NOT_FOUND) {
                object2 = Undefined.instance;
            }
            object = ScriptRuntime.call(context, object2, scriptable, objectArray, ScriptableObject.getTopLevelScope(scriptable));
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static void defineClass(Scriptable scriptable, Class clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        ScriptableObject.defineClass(scriptable, clazz, false);
    }

    public static void defineClass(Scriptable scriptable, Class clazz, boolean bl) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        Object object;
        Object object2;
        Object object3;
        GenericDeclaration[] genericDeclarationArray;
        Object object4;
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        int n = 0;
        while (n < methodArray.length) {
            object4 = methodArray[n];
            if (((Method)object4).getName().equals("init")) {
                genericDeclarationArray = ((Method)object4).getParameterTypes();
                if (genericDeclarationArray.length == 3 && genericDeclarationArray[0] == ContextClass && genericDeclarationArray[1] == ScriptRuntime.ScriptableClass && genericDeclarationArray[2] == Boolean.TYPE && Modifier.isStatic(((Method)object4).getModifiers())) {
                    Object[] objectArray = new Object[]{Context.getContext(), scriptable, bl ? Boolean.TRUE : Boolean.FALSE};
                    ((Method)object4).invoke(null, objectArray);
                    return;
                }
                if (genericDeclarationArray.length == 1 && genericDeclarationArray[0] == ScriptRuntime.ScriptableClass && Modifier.isStatic(((Method)object4).getModifiers())) {
                    Object[] objectArray = new Object[]{scriptable};
                    ((Method)object4).invoke(null, objectArray);
                    return;
                }
            }
            ++n;
        }
        object4 = ScriptableObject.getExclusionList();
        genericDeclarationArray = clazz.getConstructors();
        GenericDeclaration genericDeclaration = null;
        int n2 = 0;
        while (n2 < genericDeclarationArray.length) {
            if (((Constructor)genericDeclarationArray[n2]).getParameterTypes().length == 0) {
                genericDeclaration = genericDeclarationArray[n2];
                break;
            }
            ++n2;
        }
        if (genericDeclaration == null) {
            throw new ClassDefinitionException(Context.getMessage1("msg.zero.arg.ctor", clazz.getName()));
        }
        Scriptable scriptable2 = (Scriptable)genericDeclaration.newInstance(ScriptRuntime.emptyArgs);
        scriptable2.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        String string = scriptable2.getClassName();
        String string2 = "js_";
        String string3 = "jsFunction_";
        String string4 = "jsStaticFunction_";
        String string5 = "jsProperty_";
        String string6 = "jsGet_";
        String string7 = "jsSet_";
        String string8 = "jsConstructor";
        boolean bl2 = false;
        Method[] methodArray2 = FunctionObject.findMethods(clazz, "jsConstructor");
        GenericDeclaration genericDeclaration2 = null;
        if (methodArray2 != null) {
            if (methodArray2.length > 1) {
                throw new ClassDefinitionException(Context.getMessage2("msg.multiple.ctors", methodArray2[0], methodArray2[1]));
            }
            genericDeclaration2 = methodArray2[0];
            bl2 = true;
        }
        int n3 = 0;
        while (n3 < methodArray.length) {
            object3 = methodArray[n3].getName();
            object2 = null;
            if (!((String)object3).startsWith("js")) {
                object2 = null;
            } else if (((String)object3).startsWith("js_")) {
                object2 = "js_";
            } else if (((String)object3).startsWith("jsFunction_")) {
                object2 = "jsFunction_";
            } else if (((String)object3).startsWith("jsStaticFunction_")) {
                object2 = "jsStaticFunction_";
            } else if (((String)object3).startsWith("jsProperty_")) {
                object2 = "jsProperty_";
            } else if (((String)object3).startsWith("jsGet_")) {
                object2 = "jsGet_";
            } else if (((String)object3).startsWith("jsSet_")) {
                object2 = "jsSet_";
            }
            if (object2 != null) {
                bl2 = true;
                object3 = ((String)object3).substring(((String)object2).length());
            }
            if (((String)object3).equals(string)) {
                if (genericDeclaration2 != null) {
                    throw new ClassDefinitionException(Context.getMessage2("msg.multiple.ctors", genericDeclaration2, methodArray[n3]));
                }
                genericDeclaration2 = methodArray[n3];
            }
            ++n3;
        }
        if (genericDeclaration2 == null) {
            if (genericDeclarationArray.length == 1) {
                genericDeclaration2 = genericDeclarationArray[0];
            } else if (genericDeclarationArray.length == 2) {
                if (((Constructor)genericDeclarationArray[0]).getParameterTypes().length == 0) {
                    genericDeclaration2 = genericDeclarationArray[1];
                } else if (((Constructor)genericDeclarationArray[1]).getParameterTypes().length == 0) {
                    genericDeclaration2 = genericDeclarationArray[0];
                }
            }
            if (genericDeclaration2 == null) {
                throw new ClassDefinitionException(Context.getMessage1("msg.ctor.multiple.parms", clazz.getName()));
            }
        }
        if (((FunctionObject)(object3 = new FunctionObject(string, (Member)((Object)genericDeclaration2), scriptable))).isVarArgsMethod()) {
            throw Context.reportRuntimeError1("msg.varargs.ctor", genericDeclaration2.getName());
        }
        ((FunctionObject)object3).addAsConstructor(scriptable, scriptable2);
        if (!bl2 && object4 == null) {
            object4 = ScriptableObject.getExclusionList();
        }
        object2 = null;
        int n4 = 0;
        while (n4 < methodArray.length) {
            block58: {
                Object object5;
                block67: {
                    block60: {
                        block62: {
                            block66: {
                                block65: {
                                    block64: {
                                        block63: {
                                            block61: {
                                                block59: {
                                                    if (!bl2 && methodArray[n4].getDeclaringClass() != clazz) break block58;
                                                    object = methodArray[n4].getName();
                                                    if (!((String)object).equals("finishInit") || ((Class<?>[])(object5 = methodArray[n4].getParameterTypes())).length != 3 || object5[0] != ScriptRuntime.ScriptableClass || object5[1] != (class$org$mozilla$javascript$FunctionObject != null ? class$org$mozilla$javascript$FunctionObject : ScriptableObject.class$("org.mozilla.javascript.FunctionObject")) || object5[2] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(methodArray[n4].getModifiers())) break block59;
                                                    object2 = methodArray[n4];
                                                    break block58;
                                                }
                                                if (((String)object).indexOf(36) != -1 || ((String)object).equals("jsConstructor")) break block58;
                                                object5 = null;
                                                if (!bl2) break block60;
                                                if (!((String)object).startsWith("js_")) break block61;
                                                object5 = "js_";
                                                break block62;
                                            }
                                            if (!((String)object).startsWith("jsFunction_")) break block63;
                                            object5 = "jsFunction_";
                                            break block62;
                                        }
                                        if (!((String)object).startsWith("jsStaticFunction_")) break block64;
                                        object5 = "jsStaticFunction_";
                                        if (!Modifier.isStatic(methodArray[n4].getModifiers())) {
                                            throw new ClassDefinitionException("jsStaticFunction must be used with static method.");
                                        }
                                        break block62;
                                    }
                                    if (!((String)object).startsWith("jsProperty_")) break block65;
                                    object5 = "jsProperty_";
                                    break block62;
                                }
                                if (!((String)object).startsWith("jsGet_")) break block66;
                                object5 = "jsGet_";
                                break block62;
                            }
                            if (!((String)object).startsWith("jsSet_")) break block58;
                            object5 = "jsSet_";
                        }
                        object = ((String)object).substring(((String)object5).length());
                        break block67;
                    }
                    if (((Hashtable)object4).get(object) != null) break block58;
                }
                if (!(methodArray[n4] == genericDeclaration2 || object5 != null && ((String)object5).equals("jsSet_"))) {
                    Object object6;
                    Object object7;
                    if (object5 != null && ((String)object5).equals("jsGet_")) {
                        if (!(scriptable2 instanceof ScriptableObject)) {
                            throw PropertyException.withMessage2("msg.extend.scriptable", scriptable2.getClass().toString(), object);
                        }
                        object7 = FunctionObject.findMethods(clazz, "jsSet_" + (String)object);
                        if (object7 != null && ((Object)object7).length != 1) {
                            throw PropertyException.withMessage2("msg.no.overload", object, clazz.getName());
                        }
                        int n5 = 6 | (object7 != null ? 0 : 1);
                        object6 = object7 == null ? null : object7[0];
                        ((ScriptableObject)scriptable2).defineProperty((String)object, null, methodArray[n4], (Method)object6, n5);
                    } else if (!(!((String)object).startsWith("get") && !((String)object).startsWith("set") || ((String)object).length() <= 3 || bl2 && (((String)object5).equals("jsFunction_") || ((String)object5).equals("jsStaticFunction_")))) {
                        if (!(scriptable2 instanceof ScriptableObject)) {
                            throw PropertyException.withMessage2("msg.extend.scriptable", scriptable2.getClass().toString(), object);
                        }
                        if (!((String)object).startsWith("set")) {
                            object7 = new StringBuffer();
                            char c = ((String)object).charAt(3);
                            ((StringBuffer)object7).append(Character.toLowerCase(c));
                            if (((String)object).length() > 4) {
                                ((StringBuffer)object7).append(((String)object).substring(4));
                            }
                            object6 = ((StringBuffer)object7).toString();
                            ((StringBuffer)object7).setCharAt(0, c);
                            ((StringBuffer)object7).insert(0, "set");
                            String string9 = ((StringBuffer)object7).toString();
                            Method[] methodArray3 = FunctionObject.findMethods(clazz, bl2 ? "js_" + string9 : string9);
                            if (methodArray3 != null && methodArray3.length != 1) {
                                throw PropertyException.withMessage2("msg.no.overload", object, clazz.getName());
                            }
                            if (methodArray3 == null && bl2) {
                                methodArray3 = FunctionObject.findMethods(clazz, "jsProperty_" + string9);
                            }
                            int n6 = 6 | (methodArray3 != null ? 0 : 1);
                            Method method = methodArray3 == null ? null : methodArray3[0];
                            ((ScriptableObject)scriptable2).defineProperty((String)object6, null, methodArray[n4], method, n6);
                        }
                    } else {
                        object7 = new FunctionObject((String)object, methodArray[n4], scriptable2);
                        if (((FunctionObject)object7).isVarArgsConstructor()) {
                            throw Context.reportRuntimeError1("msg.varargs.fun", genericDeclaration2.getName());
                        }
                        Object object8 = object5 == "jsStaticFunction_" ? object3 : scriptable2;
                        ScriptableObject.defineProperty((Scriptable)object8, (String)object, object7, 2);
                        if (bl) {
                            ((ScriptableObject)object7).sealObject();
                            ((IdScriptable)object7).addPropertyAttribute(1);
                        }
                    }
                }
            }
            ++n4;
        }
        if (object2 != null) {
            object = new Object[]{scriptable, object3, scriptable2};
            ((Method)object2).invoke(null, (Object[])object);
        }
        if (bl) {
            ((ScriptableObject)object3).sealObject();
            ((IdScriptable)object3).addPropertyAttribute(1);
            if (scriptable2 instanceof ScriptableObject) {
                ((ScriptableObject)scriptable2).sealObject();
                ((ScriptableObject)scriptable2).addPropertyAttribute(1);
            }
        }
    }

    public void defineFunctionProperties(String[] stringArray, Class clazz, int n) throws PropertyException {
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            Method[] methodArray = FunctionObject.findMethods(clazz, string);
            if (methodArray == null) {
                throw PropertyException.withMessage2("msg.method.not.found", string, clazz.getName());
            }
            if (methodArray.length > 1) {
                throw PropertyException.withMessage2("msg.no.overload", string, clazz.getName());
            }
            FunctionObject functionObject = new FunctionObject(string, methodArray[0], this);
            this.defineProperty(string, functionObject, n);
            ++n2;
        }
    }

    public void defineProperty(String string, Class clazz, int n) throws PropertyException {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(0, Character.toUpperCase(string.charAt(0)));
        String string2 = stringBuffer.toString();
        Method[] methodArray = FunctionObject.findMethods(clazz, "get" + string2);
        Method[] methodArray2 = FunctionObject.findMethods(clazz, "set" + string2);
        if (methodArray2 == null) {
            n |= 1;
        }
        if (methodArray.length != 1 || methodArray2 != null && methodArray2.length != 1) {
            throw PropertyException.withMessage2("msg.no.overload", string, clazz.getName());
        }
        this.defineProperty(string, null, methodArray[0], methodArray2 == null ? null : methodArray2[0], n);
    }

    public void defineProperty(String string, Object object, int n) {
        this.put(string, (Scriptable)this, object);
        try {
            this.setAttributes(string, (Scriptable)this, n);
        }
        catch (PropertyException propertyException) {
            throw new RuntimeException("Cannot create property");
        }
    }

    public void defineProperty(String string, Object object, Method method, Method method2, int n) throws PropertyException {
        Class<?>[] classArray;
        int n2 = 1;
        if (object == null && Modifier.isStatic(method.getModifiers())) {
            object = HAS_STATIC_ACCESSORS;
        }
        if ((classArray = method.getParameterTypes()).length != 0) {
            if (classArray.length != 1 || classArray[0] != (class$org$mozilla$javascript$ScriptableObject != null ? class$org$mozilla$javascript$ScriptableObject : (class$org$mozilla$javascript$ScriptableObject = ScriptableObject.class$("org.mozilla.javascript.ScriptableObject")))) {
                throw PropertyException.withMessage1("msg.bad.getter.parms", method.toString());
            }
        } else if (object != null) {
            throw PropertyException.withMessage1("msg.obj.getter.parms", method.toString());
        }
        if (method2 != null) {
            n2 |= 2;
            if (object == HAS_STATIC_ACCESSORS != Modifier.isStatic(method2.getModifiers())) {
                throw PropertyException.withMessage0("msg.getter.static");
            }
            classArray = method2.getParameterTypes();
            if (classArray.length == 2) {
                if (classArray[0] != (class$org$mozilla$javascript$ScriptableObject != null ? class$org$mozilla$javascript$ScriptableObject : (class$org$mozilla$javascript$ScriptableObject = ScriptableObject.class$("org.mozilla.javascript.ScriptableObject")))) {
                    throw PropertyException.withMessage0("msg.setter2.parms");
                }
                if (object == null) {
                    throw PropertyException.withMessage1("msg.setter1.parms", method2.toString());
                }
            } else if (classArray.length == 1) {
                if (object != null) {
                    throw PropertyException.withMessage1("msg.setter2.expected", method2.toString());
                }
            } else {
                throw PropertyException.withMessage0("msg.setter.parms");
            }
        }
        GetterSlot getterSlot = (GetterSlot)this.getSlotToSet(string, string.hashCode(), true);
        getterSlot.delegateTo = object;
        getterSlot.getter = method;
        getterSlot.setter = method2;
        getterSlot.setterReturnsValue = method2 != null && method2.getReturnType() != Void.TYPE;
        getterSlot.value = null;
        getterSlot.attributes = (short)n;
        getterSlot.flags = (byte)n2;
    }

    public static void defineProperty(Scriptable scriptable, String string, Object object, int n) {
        if (scriptable instanceof ScriptableObject) {
            ScriptableObject scriptableObject = (ScriptableObject)scriptable;
            scriptableObject.defineProperty(string, object, n);
        } else {
            scriptable.put(string, scriptable, object);
        }
    }

    public void delete(int n) {
        this.removeSlot(null, n);
    }

    public void delete(String string) {
        this.removeSlot(string, string.hashCode());
    }

    public static boolean deleteProperty(Scriptable scriptable, int n) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, n);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(n);
        return scriptable2.get(n, scriptable) == Scriptable.NOT_FOUND;
    }

    public static boolean deleteProperty(Scriptable scriptable, String string) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(string);
        return scriptable2.get(string, scriptable) == Scriptable.NOT_FOUND;
    }

    public Object get(int n, Scriptable scriptable) {
        Slot slot = this.getSlot(null, n, false);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.value;
    }

    public Object get(String string, Scriptable scriptable) {
        Slot slot = this.lastAccess;
        if (string == slot.stringKey && slot.wasDeleted == 0) {
            return slot.value;
        }
        int n = string.hashCode();
        slot = this.getSlot(string, n, false);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        if ((slot.flags & 1) != 0) {
            GetterSlot getterSlot = (GetterSlot)slot;
            try {
                if (getterSlot.delegateTo == null) {
                    Class<?> clazz = getterSlot.getter.getDeclaringClass();
                    while (!clazz.isInstance(scriptable)) {
                        if ((scriptable = scriptable.getPrototype()) != null) continue;
                        scriptable = this;
                        break;
                    }
                    return getterSlot.getter.invoke((Object)scriptable, ScriptRuntime.emptyArgs);
                }
                Object[] objectArray = new Object[]{this};
                return getterSlot.getter.invoke(getterSlot.delegateTo, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw WrappedException.wrapException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw WrappedException.wrapException(illegalAccessException);
            }
        }
        slot.stringKey = string;
        this.lastAccess = slot;
        return slot.value;
    }

    public Object[] getAllIds() {
        return this.getIds(true);
    }

    public int getAttributes(int n, Scriptable scriptable) throws PropertyException {
        Slot slot = this.getSlot(null, n, false);
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        return slot.attributes;
    }

    public int getAttributes(String string, Scriptable scriptable) throws PropertyException {
        Slot slot = this.getSlot(string, string.hashCode(), false);
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        return slot.attributes;
    }

    private static Scriptable getBase(Scriptable scriptable, int n) {
        Scriptable scriptable2 = scriptable;
        while (scriptable2 != null) {
            if (scriptable2.has(n, scriptable)) {
                return scriptable2;
            }
            scriptable2 = scriptable2.getPrototype();
        }
        return null;
    }

    private static Scriptable getBase(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        while (scriptable2 != null) {
            if (scriptable2.has(string, scriptable)) {
                return scriptable2;
            }
            scriptable2 = scriptable2.getPrototype();
        }
        return null;
    }

    public abstract String getClassName();

    public static Scriptable getClassPrototype(Scriptable scriptable, String string) {
        Object object = ScriptRuntime.getTopLevelProp(scriptable = ScriptableObject.getTopLevelScope(scriptable), string);
        if (object == Scriptable.NOT_FOUND || !(object instanceof Scriptable)) {
            return null;
        }
        Scriptable scriptable2 = (Scriptable)object;
        if (!scriptable2.has("prototype", scriptable2)) {
            return null;
        }
        Object object2 = scriptable2.get("prototype", scriptable2);
        if (!(object2 instanceof Scriptable)) {
            return null;
        }
        return (Scriptable)object2;
    }

    public Object getDefaultValue(Class clazz) {
        Context context = null;
        try {
            int n = 0;
            while (n < 2) {
                block26: {
                    Object object;
                    Object object2;
                    block27: {
                        Object object3;
                        block25: {
                            block23: {
                                boolean bl;
                                block24: {
                                    block22: {
                                        if (clazz != ScriptRuntime.StringClass) break block22;
                                        if (n == 0) break block23;
                                        bl = false;
                                        break block24;
                                    }
                                    if (n == 1) break block23;
                                    bl = false;
                                }
                                if (!bl) break block25;
                            }
                            if (!((object2 = ScriptableObject.getProperty((Scriptable)this, "toString")) instanceof Function)) break block26;
                            object3 = (Function)object2;
                            if (context == null) {
                                context = Context.getContext();
                            }
                            object = object3.call(context, object3.getParentScope(), this, ScriptRuntime.emptyArgs);
                            break block27;
                        }
                        if (clazz == null) {
                            object2 = "undefined";
                        } else if (clazz == ScriptRuntime.StringClass) {
                            object2 = "string";
                        } else if (clazz == ScriptRuntime.ScriptableClass) {
                            object2 = "object";
                        } else if (clazz == ScriptRuntime.FunctionClass) {
                            object2 = "function";
                        } else if (clazz == ScriptRuntime.BooleanClass || clazz == Boolean.TYPE) {
                            object2 = "boolean";
                        } else if (clazz == ScriptRuntime.NumberClass || clazz == ScriptRuntime.ByteClass || clazz == Byte.TYPE || clazz == ScriptRuntime.ShortClass || clazz == Short.TYPE || clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE || clazz == ScriptRuntime.FloatClass || clazz == Float.TYPE || clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
                            object2 = "number";
                        } else {
                            throw Context.reportRuntimeError1("msg.invalid.type", clazz.toString());
                        }
                        object3 = ScriptableObject.getProperty((Scriptable)this, "valueOf");
                        if (!(object3 instanceof Function)) break block26;
                        Function function = (Function)object3;
                        Object[] objectArray = new Object[]{object2};
                        if (context == null) {
                            context = Context.getContext();
                        }
                        object = function.call(context, function.getParentScope(), this, objectArray);
                    }
                    if (!(object == null || object != Undefined.instance && object instanceof Scriptable && clazz != (class$org$mozilla$javascript$Scriptable != null ? class$org$mozilla$javascript$Scriptable : ScriptableObject.class$("org.mozilla.javascript.Scriptable")) && clazz != (class$org$mozilla$javascript$Function != null ? class$org$mozilla$javascript$Function : ScriptableObject.class$("org.mozilla.javascript.Function")))) {
                        return object;
                    }
                    if (object instanceof NativeJavaObject && (object2 = ((Wrapper)object).unwrap()) instanceof String) {
                        return object2;
                    }
                }
                ++n;
            }
        }
        catch (JavaScriptException javaScriptException) {}
        String string = clazz == null ? "undefined" : clazz.toString();
        throw NativeGlobal.typeError1("msg.default.value", string, this);
    }

    private static Hashtable getExclusionList() {
        if (exclusionList != null) {
            return exclusionList;
        }
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>(17);
        Method[] methodArray = ScriptRuntime.FunctionClass.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            hashtable.put(methodArray[n].getName(), Boolean.TRUE);
            ++n;
        }
        exclusionList = hashtable;
        return hashtable;
    }

    public static Scriptable getFunctionPrototype(Scriptable scriptable) {
        return ScriptableObject.getClassPrototype(scriptable, "Function");
    }

    public Object[] getIds() {
        return this.getIds(false);
    }

    Object[] getIds(boolean bl) {
        Object[] objectArray;
        Slot[] slotArray = this.slots;
        Object[] objectArray2 = ScriptRuntime.emptyArgs;
        if (slotArray == null) {
            return objectArray2;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < slotArray.length) {
            objectArray = slotArray[n2];
            if (objectArray != null && objectArray != REMOVED && (bl || (objectArray.attributes & 2) == 0)) {
                if (n == 0) {
                    objectArray2 = new Object[slotArray.length - n2];
                }
                objectArray2[n++] = objectArray.stringKey != null ? objectArray.stringKey : new Integer(objectArray.intKey);
            }
            ++n2;
        }
        if (n == objectArray2.length) {
            return objectArray2;
        }
        objectArray = new Object[n];
        System.arraycopy(objectArray2, 0, objectArray, 0, n);
        return objectArray;
    }

    public static Scriptable getObjectPrototype(Scriptable scriptable) {
        return ScriptableObject.getClassPrototype(scriptable, "Object");
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public static Object getProperty(Scriptable scriptable, int n) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable.get(n, scriptable2)) == Scriptable.NOT_FOUND && (scriptable = scriptable.getPrototype()) != null) {
        }
        return object;
    }

    public static Object getProperty(Scriptable scriptable, String string) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable.get(string, scriptable2)) == Scriptable.NOT_FOUND && (scriptable = scriptable.getPrototype()) != null) {
        }
        return object;
    }

    public static Object[] getPropertyIds(Scriptable scriptable) {
        Object[] objectArray;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        while (scriptable != null) {
            objectArray = scriptable.getIds();
            int n = 0;
            while (n < objectArray.length) {
                hashtable.put(objectArray[n], objectArray[n]);
                ++n;
            }
            scriptable = scriptable.getPrototype();
        }
        objectArray = new Object[hashtable.size()];
        Enumeration enumeration = hashtable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            objectArray[n++] = enumeration.nextElement();
        }
        return objectArray;
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    private Slot getSlot(String string, int n, boolean bl) {
        int n2;
        Slot[] slotArray = this.slots;
        if (slotArray == null) {
            return null;
        }
        int n3 = n2 = (n & Integer.MAX_VALUE) % slotArray.length;
        do {
            Slot slot;
            if ((slot = slotArray[n3]) == null) {
                return null;
            }
            if (slot != REMOVED && slot.intKey == n && (slot.stringKey == string || string != null && string.equals(slot.stringKey))) {
                if (bl && (slot.attributes & 4) == 0) {
                    slot.wasDeleted = 1;
                    slotArray[n3] = REMOVED;
                    --this.count;
                    if (slot == this.lastAccess) {
                        this.lastAccess = REMOVED;
                    }
                }
                return slot;
            }
            if (++n3 != slotArray.length) continue;
            n3 = 0;
        } while (n3 != n2);
        return null;
    }

    private Slot getSlotToSet(String string, int n, boolean bl) {
        if (this.slots == null) {
            this.slots = new Slot[5];
        }
        int n2 = (n & Integer.MAX_VALUE) % this.slots.length;
        boolean bl2 = false;
        int n3 = n2;
        do {
            Slot slot;
            if ((slot = this.slots[n3]) == null) {
                return this.addSlot(string, n, bl);
            }
            if (slot == REMOVED) {
                bl2 = true;
            } else if (slot.intKey == n && (slot.stringKey == string || string != null && string.equals(slot.stringKey))) {
                return slot;
            }
            if (++n3 != this.slots.length) continue;
            n3 = 0;
        } while (n3 != n2);
        if (bl2) {
            return this.addSlot(string, n, bl);
        }
        throw new RuntimeException("Hashtable internal error");
    }

    public static Scriptable getTopLevelScope(Scriptable scriptable) {
        Scriptable scriptable2 = scriptable;
        while ((scriptable2 = (scriptable = scriptable2).getParentScope()) != null) {
        }
        return scriptable;
    }

    private synchronized void grow() {
        Slot[] slotArray = new Slot[this.slots.length * 2 + 1];
        int n = this.slots.length - 1;
        while (n >= 0) {
            Slot slot = this.slots[n];
            if (slot != null && slot != REMOVED) {
                int n2 = (slot.intKey & Integer.MAX_VALUE) % slotArray.length;
                while (slotArray[n2] != null) {
                    if (++n2 != slotArray.length) continue;
                    n2 = 0;
                }
                slotArray[n2] = slot;
            }
            --n;
        }
        this.slots = slotArray;
    }

    public boolean has(int n, Scriptable scriptable) {
        return this.getSlot(null, n, false) != null;
    }

    public boolean has(String string, Scriptable scriptable) {
        return this.getSlot(string, string.hashCode(), false) != null;
    }

    public boolean hasInstance(Scriptable scriptable) {
        return ScriptRuntime.jsDelegatesTo(scriptable, this);
    }

    public static boolean hasProperty(Scriptable scriptable, int n) {
        Scriptable scriptable2 = scriptable;
        do {
            if (!scriptable.has(n, scriptable2)) continue;
            return true;
        } while ((scriptable = scriptable.getPrototype()) != null);
        return false;
    }

    public static boolean hasProperty(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        do {
            if (!scriptable.has(string, scriptable2)) continue;
            return true;
        } while ((scriptable = scriptable.getPrototype()) != null);
        return false;
    }

    public boolean isSealed() {
        return this.count == -1;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        Slot slot = this.getSlot(null, n, false);
        if (slot == null) {
            if (scriptable != this) {
                scriptable.put(n, scriptable, object);
                return;
            }
            slot = this.getSlotToSet(null, n, false);
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if (this == scriptable) {
            slot.value = object;
        } else {
            scriptable.put(n, scriptable, object);
        }
    }

    public void put(String string, Scriptable scriptable, Object object) {
        int n = string.hashCode();
        Slot slot = this.getSlot(string, n, false);
        if (slot == null) {
            if (scriptable != this) {
                scriptable.put(string, scriptable, object);
                return;
            }
            slot = this.getSlotToSet(string, n, false);
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if ((slot.flags & 2) != 0) {
            GetterSlot getterSlot = (GetterSlot)slot;
            try {
                Class<?>[] classArray = getterSlot.setter.getParameterTypes();
                Class<?> clazz = classArray[classArray.length - 1];
                Object object2 = FunctionObject.convertArg(scriptable, object, clazz);
                if (getterSlot.delegateTo == null) {
                    Object[] objectArray = new Object[]{object2};
                    Class<?> clazz2 = getterSlot.setter.getDeclaringClass();
                    while (!clazz2.isInstance(scriptable)) {
                        if ((scriptable = scriptable.getPrototype()) != null) continue;
                        scriptable = this;
                        break;
                    }
                    Object object3 = getterSlot.setter.invoke((Object)scriptable, objectArray);
                    if (getterSlot.setterReturnsValue) {
                        slot.value = object3;
                        if (!(object3 instanceof Method)) {
                            slot.flags = 0;
                        }
                    }
                    return;
                }
                Object[] objectArray = new Object[]{this, object2};
                Object object4 = getterSlot.setter.invoke(getterSlot.delegateTo, objectArray);
                if (getterSlot.setterReturnsValue) {
                    slot.value = object4;
                    if (!(object4 instanceof Method)) {
                        slot.flags = 0;
                    }
                }
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw WrappedException.wrapException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw WrappedException.wrapException(illegalAccessException);
            }
        }
        if (this == scriptable) {
            slot.value = object;
            slot.stringKey = string;
            this.lastAccess = slot;
        } else {
            scriptable.put(string, scriptable, object);
        }
    }

    public static void putProperty(Scriptable scriptable, int n, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, n);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        scriptable2.put(n, scriptable, object);
    }

    public static void putProperty(Scriptable scriptable, String string, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        scriptable2.put(string, scriptable, object);
    }

    private synchronized void removeSlot(String string, int n) {
        if (this.count == -1) {
            throw Context.reportRuntimeError0("msg.remove.sealed");
        }
        this.getSlot(string, n, true);
    }

    public void sealObject() {
        this.count = -1;
    }

    public void setAttributes(int n, Scriptable scriptable, int n2) throws PropertyException {
        Slot slot = this.getSlot(null, n, false);
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        slot.attributes = (short)n2;
    }

    public void setAttributes(String string, Scriptable scriptable, int n) throws PropertyException {
        int n2 = 7;
        n &= 7;
        Slot slot = this.getSlot(string, string.hashCode(), false);
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        slot.attributes = (short)n;
    }

    public void setParentScope(Scriptable scriptable) {
        this.parent = scriptable;
    }

    public void setPrototype(Scriptable scriptable) {
        this.prototype = scriptable;
    }

    private static class Slot {
        static final int HAS_GETTER = 1;
        static final int HAS_SETTER = 2;
        int intKey;
        String stringKey;
        Object value;
        short attributes;
        byte flags;
        byte wasDeleted;

        Slot() {
        }
    }

    private static class GetterSlot
    extends Slot {
        Object delegateTo;
        Method getter;
        Method setter;
        boolean setterReturnsValue;

        GetterSlot() {
        }
    }
}

