/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.CompilerState;
import org.mozilla.javascript.regexp.GreedyState;
import org.mozilla.javascript.regexp.MatchState;
import org.mozilla.javascript.regexp.NativeRegExpCtor;
import org.mozilla.javascript.regexp.RENode;
import org.mozilla.javascript.regexp.RegExpImpl;
import org.mozilla.javascript.regexp.SubString;

public class NativeRegExp
extends IdScriptable
implements Function {
    public static final int GLOB = 1;
    public static final int FOLD = 2;
    public static final int MULTILINE = 4;
    public static final int TEST = 0;
    public static final int MATCH = 1;
    public static final int PREFIX = 2;
    private static final boolean debug = false;
    static final int JS_BITS_PER_BYTE = 8;
    private static final byte REOP_EMPTY = 0;
    private static final byte REOP_ALT = 1;
    private static final byte REOP_BOL = 2;
    private static final byte REOP_EOL = 3;
    private static final byte REOP_WBDRY = 4;
    private static final byte REOP_WNONBDRY = 5;
    private static final byte REOP_QUANT = 6;
    private static final byte REOP_STAR = 7;
    private static final byte REOP_PLUS = 8;
    private static final byte REOP_OPT = 9;
    private static final byte REOP_LPAREN = 10;
    private static final byte REOP_RPAREN = 11;
    private static final byte REOP_DOT = 12;
    private static final byte REOP_CCLASS = 13;
    private static final byte REOP_DIGIT = 14;
    private static final byte REOP_NONDIGIT = 15;
    private static final byte REOP_ALNUM = 16;
    private static final byte REOP_NONALNUM = 17;
    private static final byte REOP_SPACE = 18;
    private static final byte REOP_NONSPACE = 19;
    private static final byte REOP_BACKREF = 20;
    private static final byte REOP_FLAT = 21;
    private static final byte REOP_FLAT1 = 22;
    private static final byte REOP_JUMP = 23;
    private static final byte REOP_DOTSTAR = 24;
    private static final byte REOP_ANCHOR = 25;
    private static final byte REOP_EOLONLY = 26;
    private static final byte REOP_UCFLAT = 27;
    private static final byte REOP_UCFLAT1 = 28;
    private static final byte REOP_UCCLASS = 29;
    private static final byte REOP_NUCCLASS = 30;
    private static final byte REOP_BACKREFi = 31;
    private static final byte REOP_FLATi = 32;
    private static final byte REOP_FLAT1i = 33;
    private static final byte REOP_UCFLATi = 34;
    private static final byte REOP_UCFLAT1i = 35;
    private static final byte REOP_ANCHOR1 = 36;
    private static final byte REOP_NCCLASS = 37;
    private static final byte REOP_DOTSTARMIN = 38;
    private static final byte REOP_LPARENNON = 39;
    private static final byte REOP_RPARENNON = 40;
    private static final byte REOP_ASSERT = 41;
    private static final byte REOP_ASSERT_NOT = 42;
    private static final byte REOP_END = 43;
    private static final int REOP_FLATLEN_MAX = 255;
    private static int level;
    private static String[] reopname;
    static final String metachars = "|^${*+?().[\\";
    static final String closurechars = "{*+?";
    private static final int Id_lastIndex = 1;
    private static final int Id_source = 2;
    private static final int Id_global = 3;
    private static final int Id_ignoreCase = 4;
    private static final int Id_multiline = 5;
    private static final int MAX_INSTANCE_ID = 5;
    private static final int Id_compile = 6;
    private static final int Id_toString = 7;
    private static final int Id_exec = 8;
    private static final int Id_test = 9;
    private static final int Id_prefix = 10;
    private static final int MAX_PROTOTYPE_ID = 10;
    private boolean prototypeFlag;
    private String source;
    private int lastIndex;
    private int parenCount;
    private byte flags;
    private byte[] program;
    RENode ren;

    static {
        reopname = null;
    }

    public NativeRegExp() {
    }

    public NativeRegExp(Context context, Scriptable scriptable, String string, String string2, boolean bl) {
        this.init(context, scriptable, string, string2, bl);
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return this.execSub(context, scriptable, objectArray, 1);
    }

    Scriptable compile(Context context, Scriptable scriptable, Object[] objectArray) {
        if (objectArray.length > 0 && objectArray[0] instanceof NativeRegExp) {
            if (objectArray.length > 1 && objectArray[1] != Undefined.instance) {
                throw NativeGlobal.constructError(context, "TypeError", "only one argument may be specified if the first argument is a RegExp object", scriptable);
            }
            NativeRegExp nativeRegExp = (NativeRegExp)objectArray[0];
            this.source = nativeRegExp.source;
            this.lastIndex = nativeRegExp.lastIndex;
            this.parenCount = nativeRegExp.parenCount;
            this.flags = nativeRegExp.flags;
            this.program = nativeRegExp.program;
            this.ren = nativeRegExp.ren;
            return this;
        }
        String string = objectArray.length == 0 ? "" : ScriptRuntime.toString(objectArray[0]);
        String string2 = objectArray.length > 1 && objectArray[1] != Undefined.instance ? ScriptRuntime.toString(objectArray[1]) : null;
        this.init(context, scriptable, string, string2, false);
        return this;
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        return (Scriptable)this.call(context, scriptable, null, objectArray);
    }

    private int doOctal(CompilerState compilerState) {
        char c;
        char[] cArray = compilerState.source;
        int n = compilerState.index;
        int n2 = 0;
        while (++n < cArray.length && (c = cArray[n]) >= '0' && c <= '7') {
            int n3 = 8 * n2 + (c - 48);
            if (n3 > 255) break;
            n2 = n3;
        }
        compilerState.index = --n;
        return n2;
    }

    private void dumpRegExp(CompilerState compilerState, RENode rENode) {
    }

    private Object exec(Context context, Scriptable scriptable, Object[] objectArray) {
        return this.execSub(context, scriptable, objectArray, 1);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (n) {
                case 6: {
                    return this.realThis(scriptable2, idFunction, false).compile(context, scriptable, objectArray);
                }
                case 7: {
                    return this.realThis(scriptable2, idFunction, true).toString();
                }
                case 8: {
                    return this.realThis(scriptable2, idFunction, false).exec(context, scriptable, objectArray);
                }
                case 9: {
                    return this.realThis(scriptable2, idFunction, false).test(context, scriptable, objectArray);
                }
                case 10: {
                    return this.realThis(scriptable2, idFunction, false).prefix(context, scriptable, objectArray);
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private Object execSub(Context context, Scriptable scriptable, Object[] objectArray, int n) {
        String string;
        RegExpImpl regExpImpl = NativeRegExp.getImpl(context);
        if (objectArray.length == 0) {
            string = regExpImpl.input;
            if (string == null) {
                Object[] objectArray2 = new Object[]{this.toString()};
                throw NativeGlobal.constructError(context, "SyntaxError", ScriptRuntime.getMessage("msg.no.re.input.for", objectArray2), scriptable);
            }
        } else {
            string = ScriptRuntime.toString(objectArray[0]);
        }
        int n2 = (this.flags & 1) != 0 ? this.lastIndex : 0;
        int[] nArray = new int[]{n2};
        Object object = this.executeRegExp(context, scriptable, regExpImpl, string, nArray, n);
        if ((this.flags & 1) != 0) {
            this.lastIndex = object == null || object == Undefined.instance ? 0 : nArray[0];
        }
        return object;
    }

    Object executeRegExp(Context context, Scriptable scriptable, RegExpImpl regExpImpl, String string, int[] nArray, int n) {
        Object object;
        Scriptable scriptable2;
        Object object2;
        int n2;
        NativeRegExp nativeRegExp = this;
        MatchState matchState = new MatchState();
        matchState.inputExhausted = false;
        matchState.anchoring = false;
        matchState.flags = nativeRegExp.flags;
        matchState.scope = scriptable;
        int n3 = nArray[0];
        char[] cArray = string.toCharArray();
        if (n3 > cArray.length) {
            n3 = cArray.length;
        }
        int n4 = n3;
        matchState.cpbegin = 0;
        matchState.cpend = cArray.length;
        matchState.start = n3;
        matchState.skipped = 0;
        matchState.input = cArray;
        matchState.parenCount = 0;
        matchState.maybeParens = new SubString[nativeRegExp.parenCount];
        matchState.parens = new SubString[nativeRegExp.parenCount];
        if ((n4 = this.matchRegExp(matchState, this.ren, n4)) == -1) {
            if (n != 2 || !matchState.inputExhausted) {
                return null;
            }
            return Undefined.instance;
        }
        nArray[0] = n2 = n4 - matchState.cpbegin;
        int n5 = n2 - (n3 + matchState.skipped);
        int n6 = n4;
        n4 -= n5;
        if (n == 0) {
            object2 = Boolean.TRUE;
            scriptable2 = null;
        } else {
            object = ScriptableObject.getTopLevelScope(scriptable);
            object2 = ScriptRuntime.newObject(context, (Scriptable)object, "Array", null);
            scriptable2 = (Scriptable)object2;
            String string2 = new String(cArray, n4, n5);
            scriptable2.put(0, scriptable2, (Object)string2);
        }
        if (matchState.parenCount > nativeRegExp.parenCount) {
            throw new RuntimeException();
        }
        if (matchState.parenCount == 0) {
            regExpImpl.parens.setSize(0);
            regExpImpl.lastParen = SubString.emptySubString;
        } else {
            object = null;
            regExpImpl.parens.setSize(matchState.parenCount);
            int n7 = 0;
            while (n7 < matchState.parenCount) {
                object = matchState.parens[n7];
                regExpImpl.parens.setElementAt(object, n7);
                if (n != 0) {
                    String string3 = object == null ? "" : ((SubString)object).toString();
                    scriptable2.put(n7 + 1, scriptable2, (Object)string3);
                }
                ++n7;
            }
            regExpImpl.lastParen = object;
        }
        if (n != 0) {
            scriptable2.put("index", scriptable2, (Object)new Integer(n3 + matchState.skipped));
            scriptable2.put("input", scriptable2, (Object)string);
        }
        if (regExpImpl.lastMatch == null) {
            regExpImpl.lastMatch = new SubString();
            regExpImpl.leftContext = new SubString();
            regExpImpl.rightContext = new SubString();
        }
        regExpImpl.lastMatch.charArray = cArray;
        regExpImpl.lastMatch.index = n4;
        regExpImpl.lastMatch.length = n5;
        regExpImpl.leftContext.charArray = cArray;
        if (context.getLanguageVersion() == 120) {
            regExpImpl.leftContext.index = n3;
            regExpImpl.leftContext.length = matchState.skipped;
        } else {
            regExpImpl.leftContext.index = 0;
            regExpImpl.leftContext.length = n3 + matchState.skipped;
        }
        regExpImpl.rightContext.charArray = cArray;
        regExpImpl.rightContext.index = n6;
        regExpImpl.rightContext.length = matchState.cpend - n6;
        return object2;
    }

    private void fixNext(CompilerState compilerState, RENode rENode, RENode rENode2, RENode rENode3) {
        RENode rENode4;
        boolean bl = rENode2 != null && (rENode2.flags & 8) == 0;
        while ((rENode4 = rENode.next) != null && rENode4 != rENode3) {
            if (rENode.op == 1) {
                RENode rENode5 = (RENode)rENode.kid;
                if (rENode5.op != 23) {
                    RENode rENode6 = rENode5;
                    while (rENode6.next != null) {
                        if (rENode6.op == 1) {
                            throw new RuntimeException("REOP_ALT not expected");
                        }
                        rENode6 = rENode6.next;
                    }
                    rENode6.next = new RENode(compilerState, 23, null);
                    rENode6.next.flags = (byte)(rENode6.next.flags | 8);
                    rENode6.flags = (byte)(rENode6.flags | 0x10);
                    this.fixNext(compilerState, rENode5, rENode2, rENode3);
                }
            }
            rENode = rENode4;
        }
        if (rENode2 != null) {
            rENode2.flags = (rENode2.flags & 8) == 0 ? (byte)(rENode2.flags | 8) : (byte)(rENode2.flags | 0x20);
        }
        rENode.next = rENode2;
        if (bl) {
            rENode.flags = (byte)(rENode.flags | 0x10);
        }
        switch (rENode.op) {
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 39: 
            case 41: 
            case 42: {
                this.fixNext(compilerState, (RENode)rENode.kid, rENode2, rENode3);
                break;
            }
        }
    }

    public String getClassName() {
        return "RegExp";
    }

    static char getEscape(char c) {
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'v': {
                return '\u000b';
            }
        }
        throw new RuntimeException();
    }

    public byte getFlags() {
        return this.flags;
    }

    protected int getIdDefaultAttributes(int n) {
        switch (n) {
            case 1: {
                return 4;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 5;
            }
        }
        return super.getIdDefaultAttributes(n);
    }

    protected String getIdName(int n) {
        switch (n) {
            case 1: {
                return "lastIndex";
            }
            case 2: {
                return "source";
            }
            case 3: {
                return "global";
            }
            case 4: {
                return "ignoreCase";
            }
            case 5: {
                return "multiline";
            }
        }
        if (this.prototypeFlag) {
            switch (n) {
                case 6: {
                    return "compile";
                }
                case 7: {
                    return "toString";
                }
                case 8: {
                    return "exec";
                }
                case 9: {
                    return "test";
                }
                case 10: {
                    return "prefix";
                }
            }
        }
        return null;
    }

    protected Object getIdValue(int n) {
        switch (n) {
            case 1: {
                return this.wrap_long(0xFFFFFFFFL & (long)this.lastIndex);
            }
            case 2: {
                return this.source;
            }
            case 3: {
                return this.wrap_boolean((this.flags & 1) != 0);
            }
            case 4: {
                return this.wrap_boolean((this.flags & 2) != 0);
            }
            case 5: {
                return this.wrap_boolean((this.flags & 4) != 0);
            }
        }
        return super.getIdValue(n);
    }

    private static RegExpImpl getImpl(Context context) {
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(context);
    }

    private String getPrintableString(String string) {
        return "";
    }

    int greedyRecurse(GreedyState greedyState, int n, int n2) {
        int n3;
        int n4 = greedyState.state.parenCount;
        int n5 = this.matchRENodes(greedyState.state, greedyState.kid, greedyState.next, n);
        if (n5 == -1) {
            int n6 = this.matchRENodes(greedyState.state, greedyState.next, greedyState.stop, n);
            if (n6 != -1) {
                greedyState.state.parenCount = n4;
                if (n2 != -1) {
                    this.matchRENodes(greedyState.state, greedyState.kid, greedyState.next, n2);
                }
                return n;
            }
            return -1;
        }
        if (n5 == n) {
            if (n2 != -1) {
                this.matchRENodes(greedyState.state, greedyState.kid, greedyState.next, n2);
            }
            return n5;
        }
        if (greedyState.maxKid == 0 || ++greedyState.kidCount < greedyState.maxKid) {
            n3 = this.greedyRecurse(greedyState, n5, n);
            if (n3 != -1) {
                return n3;
            }
            if (greedyState.maxKid != 0) {
                --greedyState.kidCount;
            }
        }
        greedyState.state.parenCount = n4;
        n3 = this.matchRENodes(greedyState.state, greedyState.next, greedyState.stop, n5);
        if (n3 != -1) {
            this.matchRENodes(greedyState.state, greedyState.kid, greedyState.next, n);
            return n5;
        }
        return -1;
    }

    public void init(Context context, Scriptable scriptable, String string, String string2, boolean bl) {
        int n;
        this.source = string;
        this.flags = 0;
        if (string2 != null) {
            int n2 = 0;
            while (n2 < string2.length()) {
                n = string2.charAt(n2);
                if (n == 103) {
                    this.flags = (byte)(this.flags | 1);
                } else if (n == 105) {
                    this.flags = (byte)(this.flags | 2);
                } else if (n == 109) {
                    this.flags = (byte)(this.flags | 4);
                } else {
                    Object[] objectArray = new Object[]{new Character((char)n)};
                    throw NativeGlobal.constructError(context, "SyntaxError", ScriptRuntime.getMessage("msg.invalid.re.flag", objectArray), scriptable);
                }
                ++n2;
            }
        }
        CompilerState compilerState = new CompilerState(string, this.flags, context, scriptable);
        if (bl) {
            this.ren = null;
            n = string.length();
            int n3 = 0;
            while (n > 0) {
                int n4 = n;
                if (n4 > 255) {
                    n4 = 255;
                }
                RENode rENode = new RENode(compilerState, n4 == 1 ? (byte)22 : 21, new Integer(n3));
                rENode.flags = (byte)4;
                if (n4 > 1) {
                    rENode.kid2 = n3 + n4;
                } else {
                    rENode.flags = (byte)(rENode.flags | 2);
                    rENode.chr = compilerState.source[n3];
                }
                n3 += n4;
                n -= n4;
                if (this.ren == null) {
                    this.ren = rENode;
                    continue;
                }
                this.setNext(compilerState, this.ren, rENode);
            }
        } else {
            this.ren = this.parseRegExp(compilerState);
        }
        if (this.ren == null) {
            return;
        }
        RENode rENode = new RENode(compilerState, 43, null);
        this.setNext(compilerState, this.ren, rENode);
        this.lastIndex = 0;
        this.parenCount = compilerState.parenCount;
        this.flags = this.flags;
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        this.setPrototype(ScriptableObject.getClassPrototype(scriptable, "RegExp"));
        this.setParentScope(scriptable);
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeRegExp nativeRegExp = new NativeRegExp();
        nativeRegExp.prototypeFlag = true;
        nativeRegExp.activateIdMap(10);
        nativeRegExp.setSealFunctionsFlag(bl);
        nativeRegExp.setFunctionParametrs(context);
        nativeRegExp.setParentScope(scriptable);
        nativeRegExp.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        NativeRegExpCtor nativeRegExpCtor = new NativeRegExpCtor();
        nativeRegExpCtor.setPrototype(ScriptableObject.getClassPrototype(scriptable, "Function"));
        nativeRegExpCtor.setParentScope(scriptable);
        nativeRegExpCtor.setImmunePrototypeProperty(nativeRegExp);
        if (bl) {
            nativeRegExp.sealObject();
            nativeRegExpCtor.sealObject();
        }
        ScriptableObject.defineProperty(scriptable, "RegExp", nativeRegExpCtor, 2);
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    static boolean isWord(char c) {
        return Character.isLetter(c) || NativeRegExp.isDigit(c) || c == '_';
    }

    protected int mapNameToId(String string) {
        char c;
        int n = 0;
        String string2 = null;
        int n2 = string.length();
        if (n2 == 6) {
            c = string.charAt(0);
            if (c == 'g') {
                string2 = "global";
                n = 3;
            } else if (c == 's') {
                string2 = "source";
                n = 2;
            }
        } else if (n2 == 9) {
            c = string.charAt(0);
            if (c == 'l') {
                string2 = "lastIndex";
                n = 1;
            } else if (c == 'm') {
                string2 = "multiline";
                n = 5;
            }
        } else if (n2 == 10) {
            string2 = "ignoreCase";
            n = 4;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        if (n != 0 || !this.prototypeFlag) {
            return n;
        }
        n = 0;
        string2 = null;
        switch (string.length()) {
            case 4: {
                c = string.charAt(0);
                if (c == 'e') {
                    string2 = "exec";
                    n = 8;
                    break;
                }
                if (c != 't') break;
                string2 = "test";
                n = 9;
                break;
            }
            case 6: {
                string2 = "prefix";
                n = 10;
                break;
            }
            case 7: {
                string2 = "compile";
                n = 6;
                break;
            }
            case 8: {
                string2 = "toString";
                n = 7;
                break;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }

    private static boolean matchChar(int n, char c, char c2) {
        if (c == c2) {
            return true;
        }
        if ((n & 2) != 0) {
            return (c = Character.toUpperCase(c)) == (c2 = Character.toUpperCase(c2)) || Character.toLowerCase(c) == Character.toLowerCase(c2);
        }
        return false;
    }

    int matchGreedyKid(MatchState matchState, RENode rENode, RENode rENode2, int n, int n2, int n3) {
        GreedyState greedyState = new GreedyState();
        greedyState.state = matchState;
        greedyState.kid = (RENode)rENode.kid;
        greedyState.next = rENode.next;
        greedyState.maxKid = rENode.op == 6 ? rENode.max : (short)0;
        greedyState.stop = null;
        greedyState.kidCount = n;
        int n4 = this.greedyRecurse(greedyState, n2, n3);
        if (n4 != -1 || rENode2 == null) {
            return n4;
        }
        greedyState.kidCount = n;
        greedyState.stop = rENode2;
        return this.greedyRecurse(greedyState, n2, n3);
    }

    int matchNonGreedyKid(MatchState matchState, RENode rENode, int n, int n2, int n3) {
        int n4 = this.matchRENodes(matchState, rENode.next, null, n3);
        if (n4 != -1) {
            return n3;
        }
        int n5 = this.matchRENodes(matchState, (RENode)rENode.kid, rENode.next, n3);
        if (n5 == -1) {
            return -1;
        }
        if (n5 == n3) {
            return n5;
        }
        return this.matchNonGreedyKid(matchState, rENode, n, n2, n5);
    }

    /*
     * Unable to fully structure code
     */
    int matchRENodes(MatchState var1_1, RENode var2_2, RENode var3_3, int var4_4) {
        var6_5 = var1_1.input;
        block30: while (var2_2 != var3_3 && var2_2 != null) {
            switch (var2_2.op) {
                case 1: {
                    if (var2_2.next.op != 1) {
                        var2_2 = (RENode)var2_2.kid;
                        break;
                    }
                    var5_6 = var1_1.parenCount;
                    var7_7 = this.matchRENodes(var1_1, (RENode)var2_2.kid, var3_3, var4_4);
                    if (var7_7 != -1) {
                        return var7_7;
                    }
                    var8_19 = var5_6;
                    while (var8_19 < var1_1.parenCount) {
                        var1_1.parens[var8_19] = null;
                        ++var8_19;
                    }
                    var1_1.parenCount = var5_6;
                    ** GOTO lbl268
                }
                case 6: {
                    var7_8 = -1;
                    var5_6 = 0;
                    while (var5_6 < var2_2.min) {
                        var8_19 = this.matchRENodes(var1_1, (RENode)var2_2.kid, var2_2.next, var4_4);
                        if (var8_19 == -1) {
                            return -1;
                        }
                        var7_8 = var4_4;
                        var4_4 = var8_19;
                        ++var5_6;
                    }
                    if (var5_6 != var2_2.max) {
                        var4_4 = (var2_2.flags & 128) == 0 ? ((var8_19 = this.matchGreedyKid(var1_1, var2_2, var3_3, var5_6, var4_4, var7_8)) == -1 ? this.matchRENodes(var1_1, (RENode)var2_2.kid, var2_2.next, var4_4) : var8_19) : this.matchNonGreedyKid(var1_1, var2_2, var5_6, var2_2.max, var4_4);
                        if (var4_4 == -1) {
                            return -1;
                        }
                    }
                    ** GOTO lbl268
                }
                case 8: {
                    var7_9 = this.matchRENodes(var1_1, (RENode)var2_2.kid, var2_2.next, var4_4);
                    if (var7_9 == -1) {
                        return -1;
                    }
                    var4_4 = (var2_2.flags & 128) == 0 ? ((var7_9 = this.matchGreedyKid(var1_1, var2_2, var3_3, 1, var7_9, var4_4)) == -1 ? this.matchRENodes(var1_1, (RENode)var2_2.kid, var2_2.next, var4_4) : var7_9) : this.matchNonGreedyKid(var1_1, var2_2, 1, 0, var7_9);
                    if (var4_4 == -1) {
                        return -1;
                    }
                    ** GOTO lbl268
                }
                case 7: {
                    if ((var2_2.flags & 128) == 0) {
                        var7_10 = this.matchGreedyKid(var1_1, var2_2, var3_3, 0, var4_4, -1);
                        if (var7_10 != -1) {
                            var4_4 = var7_10;
                        }
                    } else if ((var4_4 = this.matchNonGreedyKid(var1_1, var2_2, 0, 0, var4_4)) == -1) {
                        return -1;
                    }
                    ** GOTO lbl268
                }
                case 9: {
                    var7_11 = var1_1.parenCount;
                    if ((var2_2.flags & 128) != 0 && (var8_19 = this.matchRENodes(var1_1, var2_2.next, var3_3, var4_4)) != -1) {
                        return var8_19;
                    }
                    var8_19 = this.matchRENodes(var1_1, (RENode)var2_2.kid, var2_2.next, var4_4);
                    if (var8_19 != -1) ** GOTO lbl60
                    var1_1.parenCount = var7_11;
                    ** GOTO lbl268
lbl60:
                    // 1 sources

                    var9_20 = this.matchRENodes(var1_1, var2_2.next, var3_3, var8_19);
                    if (var9_20 != -1) ** GOTO lbl64
                    var1_1.parenCount = var7_11;
                    ** GOTO lbl268
lbl64:
                    // 1 sources

                    return var9_20;
                }
                case 39: {
                    var2_2 = (RENode)var2_2.kid;
                    break;
                }
                case 10: {
                    var5_6 = var2_2.num;
                    var2_2 = (RENode)var2_2.kid;
                    var7_12 = var1_1.parens[var5_6];
                    if (var7_12 == null) {
                        var7_12 = var1_1.parens[var5_6] = new SubString();
                        var7_12.charArray = var6_5;
                    }
                    var7_12.index = var4_4;
                    var7_12.length = 0;
                    if (var5_6 < var1_1.parenCount) continue block30;
                    var1_1.parenCount = var5_6 + 1;
                    break;
                }
                case 11: {
                    var5_6 = var2_2.num;
                    var7_13 = var1_1.parens[var5_6];
                    if (var7_13 == null) {
                        throw new RuntimeException("Paren problem");
                    }
                    var7_13.length = var4_4 - var7_13.index;
                    ** GOTO lbl268
                }
                case 41: {
                    var7_14 = this.matchRENodes(var1_1, (RENode)var2_2.kid, var2_2.next, var4_4);
                    if (var7_14 == -1) {
                        return -1;
                    }
                    ** GOTO lbl268
                }
                case 42: {
                    var7_15 = this.matchRENodes(var1_1, (RENode)var2_2.kid, var2_2.next, var4_4);
                    if (var7_15 != -1) {
                        return -1;
                    }
                    ** GOTO lbl268
                }
                case 20: {
                    var5_6 = var2_2.num;
                    if (var5_6 >= var1_1.parens.length) {
                        Context.reportError(ScriptRuntime.getMessage("msg.bad.backref", null));
                        return -1;
                    }
                    var7_16 = var1_1.parens[var5_6];
                    if (var7_16 == null) {
                        var7_16 = var1_1.parens[var5_6] = new SubString();
                    }
                    var8_19 = var7_16.length;
                    var9_21 = 0;
                    while (var9_21 < var8_19) {
                        if (var4_4 >= var6_5.length) {
                            return var1_1.noMoreInput();
                        }
                        if (!NativeRegExp.matchChar(var1_1.flags, var6_5[var4_4], var7_16.charArray[var7_16.index + var9_21])) {
                            return -1;
                        }
                        ++var9_21;
                        ++var4_4;
                    }
                    ** GOTO lbl268
                }
                case 13: {
                    if (var4_4 >= var6_5.length) {
                        return var1_1.noMoreInput();
                    }
                    if (var2_2.bitmap == null) {
                        var7_17 = var2_2.s != null ? var2_2.s : this.source.toCharArray();
                        var2_2.buildBitmap(var1_1, var7_17, (var1_1.flags & 2) != 0);
                    }
                    if ((var8_19 = (var7_18 = var6_5[var4_4]) >>> 3) < var2_2.bmsize) ** GOTO lbl127
                    if (var2_2.kid2 != -1) ** GOTO lbl126
                    ++var4_4;
                    ** GOTO lbl268
lbl126:
                    // 1 sources

                    return -1;
lbl127:
                    // 1 sources

                    var9_22 = var7_18 & 7;
                    if ((var2_2.bitmap[var8_19] & (var9_22 = 1 << var9_22)) == 0) ** GOTO lbl131
                    ++var4_4;
                    ** GOTO lbl268
lbl131:
                    // 1 sources

                    return -1;
                }
                case 12: {
                    if (var4_4 >= var6_5.length) {
                        return var1_1.noMoreInput();
                    }
                    if (var6_5[var4_4] == '\n') ** GOTO lbl138
                    ++var4_4;
                    ** GOTO lbl268
lbl138:
                    // 1 sources

                    return -1;
                }
                case 38: {
                    var9_23 = var4_4;
                    while (var9_23 < var6_5.length) {
                        var10_28 = this.matchRENodes(var1_1, var2_2.next, var3_3, var9_23);
                        if (var10_28 != -1) {
                            return var10_28;
                        }
                        if (var6_5[var9_23] == '\n') {
                            return -1;
                        }
                        ++var9_23;
                    }
                    return var1_1.noMoreInput();
                }
                case 24: {
                    var9_24 = var4_4;
                    while (var9_24 < var6_5.length) {
                        if (var6_5[var9_24] == '\n') break;
                        ++var9_24;
                    }
                    while (var9_24 >= var4_4) {
                        var10_29 = this.matchRENodes(var1_1, var2_2.next, var3_3, var9_24);
                        if (var10_29 == -1) ** GOTO lbl161
                        var4_4 = var9_24;
                        ** GOTO lbl268
lbl161:
                        // 1 sources

                        --var9_24;
                    }
                    ** GOTO lbl268
                }
                case 4: {
                    if (var4_4 == 0 || !NativeRegExp.isWord(var6_5[var4_4 - 1])) {
                        if (var4_4 >= var6_5.length) {
                            return var1_1.noMoreInput();
                        }
                        if (!NativeRegExp.isWord(var6_5[var4_4])) {
                            return -1;
                        }
                    } else if (var4_4 < var6_5.length && NativeRegExp.isWord(var6_5[var4_4])) {
                        return -1;
                    }
                    ** GOTO lbl268
                }
                case 5: {
                    if (var4_4 == 0 || !NativeRegExp.isWord(var6_5[var4_4 - 1])) {
                        if (var4_4 < var6_5.length && NativeRegExp.isWord(var6_5[var4_4])) {
                            return -1;
                        }
                    } else {
                        if (var4_4 >= var6_5.length) {
                            return var1_1.noMoreInput();
                        }
                        if (!NativeRegExp.isWord(var6_5[var4_4])) {
                            return -1;
                        }
                    }
                    ** GOTO lbl268
                }
                case 3: 
                case 26: {
                    if (var4_4 == var6_5.length) ** GOTO lbl268
                    var9_25 = Context.getCurrentContext();
                    var10_30 = NativeRegExp.getImpl(var9_25);
                    if (!var10_30.multiline && (var1_1.flags & 4) == 0) ** GOTO lbl192
                    if (var6_5[var4_4] != '\n') {
                        return -1;
                    }
                    ** GOTO lbl268
lbl192:
                    // 1 sources

                    return -1;
                }
                case 2: {
                    var9_26 = Context.getCurrentContext();
                    var10_31 = NativeRegExp.getImpl(var9_26);
                    if (var4_4 == 0) ** GOTO lbl268
                    if (!var10_31.multiline && (var1_1.flags & 4) == 0) ** GOTO lbl201
                    if (var4_4 >= var6_5.length) {
                        return var1_1.noMoreInput();
                    }
                    if (var6_5[var4_4 - 1] == '\n') ** GOTO lbl268
lbl201:
                    // 2 sources

                    return -1;
                }
                case 14: {
                    if (var4_4 >= var6_5.length) {
                        return var1_1.noMoreInput();
                    }
                    if (!NativeRegExp.isDigit(var6_5[var4_4])) {
                        return -1;
                    }
                    ++var4_4;
                    ** GOTO lbl268
                }
                case 15: {
                    if (var4_4 >= var6_5.length) {
                        return var1_1.noMoreInput();
                    }
                    if (NativeRegExp.isDigit(var6_5[var4_4])) {
                        return -1;
                    }
                    ++var4_4;
                    ** GOTO lbl268
                }
                case 16: {
                    if (var4_4 >= var6_5.length) {
                        return var1_1.noMoreInput();
                    }
                    if (!NativeRegExp.isWord(var6_5[var4_4])) {
                        return -1;
                    }
                    ++var4_4;
                    ** GOTO lbl268
                }
                case 17: {
                    if (var4_4 >= var6_5.length) {
                        return var1_1.noMoreInput();
                    }
                    if (NativeRegExp.isWord(var6_5[var4_4])) {
                        return -1;
                    }
                    ++var4_4;
                    ** GOTO lbl268
                }
                case 18: {
                    if (var4_4 >= var6_5.length) {
                        return var1_1.noMoreInput();
                    }
                    if (!TokenStream.isJSSpace(var6_5[var4_4]) && !TokenStream.isJSLineTerminator(var6_5[var4_4])) {
                        return -1;
                    }
                    ++var4_4;
                    ** GOTO lbl268
                }
                case 19: {
                    if (var4_4 >= var6_5.length) {
                        return var1_1.noMoreInput();
                    }
                    if (TokenStream.isJSSpace(var6_5[var4_4]) || TokenStream.isJSLineTerminator(var6_5[var4_4])) {
                        return -1;
                    }
                    ++var4_4;
                    ** GOTO lbl268
                }
                case 22: {
                    if (var4_4 >= var6_5.length) {
                        return var1_1.noMoreInput();
                    }
                    if (!NativeRegExp.matchChar(var1_1.flags, var2_2.chr, var6_5[var4_4])) {
                        return -1;
                    }
                    ++var4_4;
                    ** GOTO lbl268
                }
                case 21: {
                    var9_27 = var2_2.s != null ? var2_2.s : this.source.toCharArray();
                    var10_32 = (Integer)var2_2.kid;
                    var11_33 = var2_2.kid2 - var10_32;
                    var12_34 = 0;
                    while (var12_34 < var11_33) {
                        if (var4_4 >= var6_5.length) {
                            return var1_1.noMoreInput();
                        }
                        if (!NativeRegExp.matchChar(var1_1.flags, var6_5[var4_4], var9_27[var10_32 + var12_34])) {
                            return -1;
                        }
                        ++var12_34;
                        ++var4_4;
                    }
                    ** GOTO lbl268
                }
                default: {
                    throw new RuntimeException("Unsupported by node matcher");
                }
lbl268:
                // 33 sources

                case 0: 
                case 23: 
                case 40: 
                case 43: {
                    var2_2 = var2_2.next;
                }
            }
        }
        return var4_4;
    }

    int matchRegExp(MatchState matchState, RENode rENode, int n) {
        int n2 = n;
        while (n2 <= matchState.input.length) {
            matchState.skipped = n2 - n;
            matchState.parenCount = 0;
            int n3 = this.matchRENodes(matchState, rENode, null, n2);
            if (n3 != -1) {
                return n3;
            }
            ++n2;
        }
        return -1;
    }

    protected int maxInstanceId() {
        return 5;
    }

    public int methodArity(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case 6: {
                    return 1;
                }
                case 7: {
                    return 0;
                }
                case 8: {
                    return 1;
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    private RENode parseAltern(CompilerState compilerState) {
        char c;
        RENode rENode = this.parseItem(compilerState);
        if (rENode == null) {
            return null;
        }
        RENode rENode2 = rENode;
        int n = 0;
        char[] cArray = compilerState.source;
        int n2 = compilerState.index;
        while (n2 != cArray.length && (c = cArray[n2]) != '|' && c != ')') {
            RENode rENode3 = this.parseItem(compilerState);
            if (rENode3 == null) {
                return null;
            }
            this.setNext(compilerState, rENode2, rENode3);
            n |= rENode3.flags;
            rENode2 = rENode3;
            n2 = compilerState.index;
        }
        rENode.flags = (byte)(rENode.flags | n & 4);
        return rENode;
    }

    /*
     * Unable to fully structure code
     */
    RENode parseAtom(CompilerState var1_1) {
        var2_2 = 0;
        var4_3 = null;
        var8_4 = false;
        var9_5 = false;
        var10_6 = var1_1.source;
        var12_8 = var11_7 = var1_1.index;
        if (var11_7 == var10_6.length) {
            var1_1.index = var11_7;
            return new RENode(var1_1, 0, null);
        }
        switch (var10_6[var11_7]) {
            case '|': {
                return new RENode(var1_1, 0, null);
            }
            case '(': {
                var7_9 = 43;
                if (var10_6[var11_7 + 1] == '?') {
                    switch (var10_6[var11_7 + 2]) {
                        case ':': {
                            var7_9 = 39;
                            break;
                        }
                        case '=': {
                            var7_9 = 41;
                            break;
                        }
                        case '!': {
                            var7_9 = 42;
                            break;
                        }
                    }
                }
                if (var7_9 == 43) {
                    var7_9 = 10;
                    var2_2 = var1_1.parenCount++;
                    ++var11_7;
                } else {
                    var11_7 += 3;
                }
                var1_1.index = var11_7;
                if (var10_6[var11_7] == ')') {
                    var5_11 = new RENode(var1_1, 0, null);
                } else {
                    var5_11 = this.parseRegExp(var1_1);
                    if (var5_11 == null) {
                        return null;
                    }
                    var11_7 = var1_1.index;
                    if (var11_7 >= var10_6.length || var10_6[var11_7] != ')') {
                        this.reportError("msg.unterm.paren", this.tail(var10_6, var12_8), var1_1);
                        return null;
                    }
                }
                ++var11_7;
                var4_3 = new RENode(var1_1, var7_9, var5_11);
                var4_3.flags = (byte)(var5_11.flags & 5);
                var4_3.num = var2_2;
                if (var7_9 != 10 && var7_9 != 39) break;
                var5_11 = new RENode(var1_1, (byte)(var7_9 + 1), null);
                this.setNext(var1_1, var4_3, var5_11);
                var5_11.num = var2_2;
                break;
            }
            case '.': {
                var7_10 = 12;
                if (++var11_7 < var10_6.length && var10_6[var11_7] == '*') {
                    var7_10 = 24;
                    if (++var11_7 < var10_6.length && var10_6[var11_7] == '?') {
                        ++var11_7;
                        var7_10 = 38;
                    }
                }
                var4_3 = new RENode(var1_1, (byte)var7_10, null);
                if (var4_3.op != 12) break;
                var4_3.flags = (byte)6;
                break;
            }
            case '[': {
                if (++var11_7 == var10_6.length) {
                    this.reportError("msg.unterm.class", this.tail(var10_6, var12_8), var1_1);
                    return null;
                }
                var6_12 = var10_6[var11_7];
                var4_3 = new RENode(var1_1, 13, new Integer(var11_7));
                if (var6_12 == '^' && ++var11_7 == var10_6.length) {
                    this.reportError("msg.unterm.class", this.tail(var10_6, var12_8), var1_1);
                    return null;
                }
                while (true) {
                    if (++var11_7 == var10_6.length) {
                        this.reportError("msg.unterm.paren", this.tail(var10_6, var12_8), var1_1);
                        return null;
                    }
                    var6_12 = var10_6[var11_7];
                    if (var6_12 == ']') break;
                    if (var6_12 != '\\' || var11_7 + 1 == var10_6.length) continue;
                    ++var11_7;
                }
                var4_3.kid2 = var11_7++;
                var4_3.flags = (byte)6;
                break;
            }
            case '\\': {
                if (++var11_7 == var10_6.length) {
                    Context.reportError(ScriptRuntime.getMessage("msg.trail.backslash", null));
                    return null;
                }
                var6_13 = var10_6[var11_7];
                switch (var6_13) {
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': 
                    case 'v': {
                        var6_13 = NativeRegExp.getEscape(var6_13);
                        var4_3 = new RENode(var1_1, 22, null);
                        break;
                    }
                    case 'd': {
                        var4_3 = new RENode(var1_1, 14, null);
                        break;
                    }
                    case 'D': {
                        var4_3 = new RENode(var1_1, 15, null);
                        break;
                    }
                    case 'w': {
                        var4_3 = new RENode(var1_1, 16, null);
                        break;
                    }
                    case 'W': {
                        var4_3 = new RENode(var1_1, 17, null);
                        break;
                    }
                    case 's': {
                        var4_3 = new RENode(var1_1, 18, null);
                        break;
                    }
                    case 'S': {
                        var4_3 = new RENode(var1_1, 19, null);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (var1_1.cx.getLanguageVersion() == 0 || var1_1.cx.getLanguageVersion() > 140) ** GOTO lbl149
                        switch (var6_13) {
                            case '0': {
                                var1_1.index = var11_7;
                                var2_2 = this.doOctal(var1_1);
                                var11_7 = var1_1.index;
                                var4_3 = new RENode(var1_1, 22, null);
                                var6_13 = (char)var2_2;
                                ** break;
                            }
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                var2_2 = NativeRegExp.unDigit(var6_13);
                                var3_14 = 1;
                                while (++var11_7 < var10_6.length && NativeRegExp.isDigit(var6_13 = var10_6[var11_7])) {
                                    var2_2 = 10 * var2_2 + NativeRegExp.unDigit(var6_13);
                                    ++var3_14;
                                }
                                if ((var2_2 == 8 || var2_2 == 9) && var2_2 > var1_1.parenCount) {
                                    var12_8 = --var11_7;
                                    var9_5 = true;
                                    var8_4 = true;
                                    ** break;
                                }
                                if (var3_14 > 1 || var2_2 > var1_1.parenCount) {
                                    var1_1.index = var12_8;
                                    var2_2 = this.doOctal(var1_1);
                                    var11_7 = var1_1.index;
                                    var4_3 = new RENode(var1_1, 22, null);
                                    var6_13 = (char)var2_2;
                                    ** break;
                                }
                                --var11_7;
                                var4_3 = new RENode(var1_1, 20, null);
                                var4_3.num = var2_2 - 1;
                                var4_3.flags = (byte)4;
                                var8_4 = true;
                                ** break;
                            }
                            default: {
                                if (var4_3 == null) ** GOTO lbl214
                            }
                        }
lbl149:
                        // 1 sources

                        if (var6_13 == '0') {
                            var4_3 = new RENode(var1_1, 22, null);
                            var6_13 = '\u0000';
                            ** break;
                        }
                        var2_2 = NativeRegExp.unDigit(var6_13);
                        var3_14 = 1;
                        while (++var11_7 < var10_6.length && NativeRegExp.isDigit(var6_13 = var10_6[var11_7])) {
                            var2_2 = 10 * var2_2 + NativeRegExp.unDigit(var6_13);
                            ++var3_14;
                        }
                        --var11_7;
                        var4_3 = new RENode(var1_1, 20, null);
                        var4_3.num = var2_2 - 1;
                        var4_3.flags = (byte)4;
                        var8_4 = true;
                        ** break;
                    }
                    case 'x': {
                        var12_8 = var11_7++;
                        if (var11_7 < var10_6.length && NativeRegExp.isHex(var6_13 = var10_6[var11_7])) {
                            var2_2 = NativeRegExp.unHex(var6_13);
                            if (++var11_7 < var10_6.length && NativeRegExp.isHex(var6_13 = var10_6[var11_7])) {
                                var2_2 <<= 4;
                                var2_2 += NativeRegExp.unHex(var6_13);
                            } else if (var1_1.cx.getLanguageVersion() != 0 && var1_1.cx.getLanguageVersion() <= 140) {
                                --var11_7;
                            } else {
                                var11_7 = var12_8;
                                var2_2 = 120;
                            }
                        } else {
                            var11_7 = var12_8;
                            var2_2 = 120;
                        }
                        var4_3 = new RENode(var1_1, 22, null);
                        var6_13 = (char)var2_2;
                        ** break;
                    }
                    case 'c': {
                        var6_13 = var10_6[++var11_7];
                        if (!(var6_13 >= 'A' && var6_13 <= 'Z' || var6_13 >= 'a' && var6_13 <= 'z')) {
                            var12_8 = var11_7 -= 2;
                            var9_5 = true;
                            var8_4 = true;
                            ** break;
                        }
                        var6_13 = Character.toUpperCase(var6_13);
                        var6_13 = (char)(var6_13 ^ 64);
                        var4_3 = new RENode(var1_1, 22, null);
                        ** break;
                    }
                    case 'u': {
                        if (var11_7 + 4 < var10_6.length && NativeRegExp.isHex(var10_6[var11_7 + 1]) && NativeRegExp.isHex(var10_6[var11_7 + 2]) && NativeRegExp.isHex(var10_6[var11_7 + 3]) && NativeRegExp.isHex(var10_6[var11_7 + 4])) {
                            var2_2 = (((NativeRegExp.unHex(var10_6[var11_7 + 1]) << 4) + NativeRegExp.unHex(var10_6[var11_7 + 2]) << 4) + NativeRegExp.unHex(var10_6[var11_7 + 3]) << 4) + NativeRegExp.unHex(var10_6[var11_7 + 4]);
                            var6_13 = (char)var2_2;
                            var11_7 += 4;
                            var4_3 = new RENode(var1_1, 22, null);
                            ** break;
                        }
                        var12_8 = var11_7;
                        var9_5 = true;
                        var8_4 = true;
                        ** break;
                    }
                    default: {
                        var12_8 = var11_7;
                        var9_5 = true;
                        var8_4 = true;
                    }
                }
lbl210:
                // 19 sources

                if (var4_3 == null) ** GOTO lbl214
                if (!var8_4) {
                    var4_3.chr = var6_13;
                    var4_3.flags = (byte)6;
                }
lbl214:
                // 5 sources

                var8_4 = false;
                if (!var9_5) {
                    ++var11_7;
                    break;
                }
                var9_5 = false;
            }
            default: {
                while (++var11_7 != var10_6.length && "|^${*+?().[\\".indexOf(var10_6[var11_7]) == -1) {
                }
                var3_14 = var11_7 - var12_8;
                if (var11_7 != var10_6.length && var3_14 > 1 && "{*+?".indexOf(var10_6[var11_7]) != -1) {
                    --var11_7;
                    --var3_14;
                }
                if (var3_14 > 255) {
                    var3_14 = 255;
                    var11_7 = var12_8 + var3_14;
                }
                var4_3 = new RENode(var1_1, var3_14 == 1 ? 22 : 21, new Integer(var12_8));
                var4_3.flags = (byte)4;
                if (var3_14 > 1) {
                    var4_3.kid2 = var11_7;
                    break;
                }
                var4_3.flags = (byte)(var4_3.flags | 2);
                var4_3.chr = var10_6[var12_8];
            }
        }
        var1_1.index = var11_7;
        return var4_3;
    }

    RENode parseItem(CompilerState compilerState) {
        int n = compilerState.index;
        char[] cArray = compilerState.source;
        switch (n < cArray.length ? cArray[n] : 0) {
            case 94: {
                compilerState.index = n + 1;
                RENode rENode = new RENode(compilerState, 2, null);
                rENode.flags = (byte)(rENode.flags | 1);
                return rENode;
            }
            case 36: {
                compilerState.index = n + 1;
                return new RENode(compilerState, (byte)(n == compilerState.indexBegin || (cArray[n - 1] == '(' || cArray[n - 1] == '|') && (n - 1 == compilerState.indexBegin || cArray[n - 2] != '\\') ? 26 : 3), null);
            }
            case 92: {
                byte by;
                switch (++n < cArray.length ? cArray[n] : 0) {
                    case 98: {
                        by = 4;
                        break;
                    }
                    case 66: {
                        by = 5;
                        break;
                    }
                    default: {
                        return this.parseQuantAtom(compilerState);
                    }
                }
                compilerState.index = n + 1;
                RENode rENode = new RENode(compilerState, by, null);
                rENode.flags = (byte)(rENode.flags | 4);
                return rENode;
            }
        }
        return this.parseQuantAtom(compilerState);
    }

    /*
     * Unable to fully structure code
     */
    RENode parseQuantAtom(CompilerState var1_1) {
        var2_2 = this.parseAtom(var1_1);
        if (var2_2 == null) {
            return null;
        }
        var8_3 = var1_1.source;
        var9_4 = var1_1.index;
        block6: while (var9_4 < var8_3.length) {
            switch (var8_3[var9_4]) {
                case '{': {
                    if (++var9_4 == var8_3.length || !NativeRegExp.isDigit(var4_6 = var8_3[var9_4])) {
                        this.reportError("msg.bad.quant", String.valueOf(var8_3[var1_1.index]), var1_1);
                        return null;
                    }
                    var6_8 = NativeRegExp.unDigit(var4_6);
                    while (++var9_4 < var8_3.length && NativeRegExp.isDigit(var4_6 = var8_3[var9_4])) {
                        if ((var6_8 = 10 * var6_8 + NativeRegExp.unDigit(var4_6)) >> 16 == 0) continue;
                        this.reportError("msg.overlarge.max", this.tail(var8_3, var9_4), var1_1);
                        return null;
                    }
                    if (var8_3[var9_4] == ',') {
                        var3_5 = ++var9_4;
                        if (NativeRegExp.isDigit(var8_3[var9_4])) {
                            var7_9 = NativeRegExp.unDigit(var8_3[var9_4]);
                            while (NativeRegExp.isDigit(var4_6 = var8_3[++var9_4])) {
                                if ((var7_9 = 10 * var7_9 + NativeRegExp.unDigit(var4_6)) >> 16 == 0) continue;
                                this.reportError("msg.overlarge.max", String.valueOf(var8_3[var3_5]), var1_1);
                                return null;
                            }
                            if (var7_9 == 0) {
                                this.reportError("msg.zero.quant", this.tail(var8_3, var1_1.index), var1_1);
                                return null;
                            }
                            if (var6_8 > var7_9) {
                                this.reportError("msg.max.lt.min", this.tail(var8_3, var3_5), var1_1);
                                return null;
                            }
                        } else {
                            var7_9 = 0;
                        }
                    } else {
                        if (var6_8 == 0) {
                            this.reportError("msg.zero.quant", this.tail(var8_3, var1_1.index), var1_1);
                            return null;
                        }
                        var7_9 = var6_8;
                    }
                    if (var8_3[var9_4] != '}') {
                        this.reportError("msg.unterm.quant", String.valueOf(var8_3[var1_1.index]), var1_1);
                        return null;
                    }
                    ++var9_4;
                    var5_7 = new RENode(var1_1, 6, var2_2);
                    if (var6_8 > 0 && (var2_2.flags & 4) != 0) {
                        var5_7.flags = (byte)(var5_7.flags | 4);
                    }
                    var5_7.min = (short)var6_8;
                    var5_7.max = (short)var7_9;
                    var2_2 = var5_7;
                    ** GOTO lbl63
                }
                case '*': {
                    ++var9_4;
                    var2_2 = new RENode(var1_1, 7, var2_2);
                    ** GOTO lbl63
                }
                case '+': {
                    ++var9_4;
                    var5_7 = new RENode(var1_1, 8, var2_2);
                    if ((var2_2.flags & 4) != 0) {
                        var5_7.flags = (byte)(var5_7.flags | 4);
                    }
                    var2_2 = var5_7;
                    ** GOTO lbl63
                }
                case '?': {
                    ++var9_4;
                    var2_2 = new RENode(var1_1, 9, var2_2);
lbl63:
                    // 4 sources

                    if (var9_4 >= var8_3.length || var8_3[var9_4] != '?') continue block6;
                    var2_2.flags = (byte)(var2_2.flags | 128);
                    ++var9_4;
                    continue block6;
                }
            }
        }
        var1_1.index = var9_4;
        return var2_2;
    }

    private RENode parseRegExp(CompilerState compilerState) {
        RENode rENode = this.parseAltern(compilerState);
        if (rENode == null) {
            return null;
        }
        int n = compilerState.index;
        char[] cArray = compilerState.source;
        if (n < cArray.length && cArray[n] == '|') {
            RENode rENode2 = rENode;
            if ((rENode = new RENode(compilerState, 1, rENode2)) == null) {
                return null;
            }
            rENode.flags = (byte)(rENode2.flags & 5);
            RENode rENode3 = rENode;
            do {
                compilerState.index = ++n;
                if (n < cArray.length && (cArray[n] == '|' || cArray[n] == ')')) {
                    rENode2 = new RENode(compilerState, 0, null);
                } else {
                    rENode2 = this.parseAltern(compilerState);
                    n = compilerState.index;
                }
                if (rENode2 == null) {
                    return null;
                }
                RENode rENode4 = new RENode(compilerState, 1, rENode2);
                if (rENode4 == null) {
                    return null;
                }
                rENode3.next = rENode4;
                rENode3.flags = (byte)(rENode3.flags | 0x10);
                rENode4.flags = (byte)(rENode2.flags & 5 | 8);
                rENode3 = rENode4;
            } while (n < cArray.length && cArray[n] == '|');
        }
        return rENode;
    }

    private Object prefix(Context context, Scriptable scriptable, Object[] objectArray) {
        return this.execSub(context, scriptable, objectArray, 2);
    }

    private NativeRegExp realThis(Scriptable scriptable, IdFunction idFunction, boolean bl) {
        while (!(scriptable instanceof NativeRegExp)) {
            scriptable = this.nextInstanceCheck(scriptable, idFunction, bl);
        }
        return (NativeRegExp)scriptable;
    }

    private void reportError(String string, String string2, CompilerState compilerState) {
        Object[] objectArray = new Object[]{string2};
        throw NativeGlobal.constructError(compilerState.cx, "SyntaxError", ScriptRuntime.getMessage(string, objectArray), compilerState.scope);
    }

    protected void setIdValue(int n, Object object) {
        if (n == 1) {
            this.setLastIndex(ScriptRuntime.toInt32(object));
            return;
        }
        super.setIdValue(n, object);
    }

    void setLastIndex(int n) {
        this.lastIndex = n;
    }

    private void setNext(CompilerState compilerState, RENode rENode, RENode rENode2) {
        this.fixNext(compilerState, rENode, rENode2, null);
    }

    private String tail(char[] cArray, int n) {
        return new String(cArray, n, cArray.length - n);
    }

    private Object test(Context context, Scriptable scriptable, Object[] objectArray) {
        Object object = this.execSub(context, scriptable, objectArray, 0);
        if (object == null || !object.equals(Boolean.TRUE)) {
            object = Boolean.FALSE;
        }
        return object;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('/');
        stringBuffer.append(this.source);
        stringBuffer.append('/');
        if ((this.flags & 1) != 0) {
            stringBuffer.append('g');
        }
        if ((this.flags & 2) != 0) {
            stringBuffer.append('i');
        }
        if ((this.flags & 4) != 0) {
            stringBuffer.append('m');
        }
        return stringBuffer.toString();
    }

    static int unDigit(char c) {
        return c - 48;
    }

    static int unHex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        return 10 + Character.toLowerCase(c) - 97;
    }
}

