/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.io.FileReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebuggableEngine;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;

class OpenFile
implements Runnable {
    Scriptable scope;
    String fileName;
    Main db;

    OpenFile(Main main, Scriptable scriptable, String string) {
        this.scope = scriptable;
        this.fileName = string;
        this.db = main;
    }

    public void run() {
        Context context = Context.enter();
        DebuggableEngine debuggableEngine = context.getDebuggableEngine();
        debuggableEngine.setBreakNextLine(true);
        try {
            try {
                context.compileReader(this.scope, new FileReader(this.fileName), this.fileName, 1, null);
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                if (exception instanceof EcmaError) {
                    EcmaError ecmaError = (EcmaError)exception;
                    string = String.valueOf(ecmaError.getSourceName()) + ", line " + ecmaError.getLineNumber() + ": " + string;
                }
                MessageDialogWrapper.showMessageDialog(this.db, string, "Error Compiling File", 0);
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }
}

