/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

class VariableNode {
    Scriptable scope;
    String name;
    int index;
    Object[] children;
    static final Object[] empty = new Object[0];
    static Scriptable[] builtin;

    public VariableNode(Scriptable scriptable, int n) {
        this.scope = scriptable;
        this.name = null;
        this.index = n;
    }

    public VariableNode(Scriptable scriptable, String string) {
        this.scope = scriptable;
        this.name = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object[] getChildren() {
        Object[] objectArray;
        block34: {
            Object[] objectArray2;
            block33: {
                if (this.children != null) {
                    return this.children;
                }
                Context context = Context.enter();
                try {
                    block35: {
                        try {
                            int n;
                            int n2;
                            Object object = this.getObject();
                            if (object == null) {
                                this.children = empty;
                                objectArray2 = empty;
                                Object var4_6 = null;
                                break block33;
                            }
                            if (object == Scriptable.NOT_FOUND || object == Undefined.instance) {
                                this.children = empty;
                                objectArray = empty;
                                break block34;
                            }
                            if (!(object instanceof Scriptable)) break block35;
                            Scriptable scriptable = (Scriptable)object;
                            Scriptable scriptable2 = scriptable.getPrototype();
                            Scriptable scriptable3 = scriptable.getParentScope();
                            if (object instanceof NativeCall) {
                                if (this.name != null && this.name.equals("this")) {
                                    scriptable3 = null;
                                } else if (!(scriptable3 instanceof NativeCall)) {
                                    scriptable3 = null;
                                }
                            }
                            if (scriptable2 != null) {
                                if (builtin == null) {
                                    builtin = new Scriptable[6];
                                    VariableNode.builtin[0] = ScriptableObject.getObjectPrototype(scriptable);
                                    VariableNode.builtin[1] = ScriptableObject.getFunctionPrototype(scriptable);
                                    VariableNode.builtin[2] = ScriptableObject.getClassPrototype(scriptable, "String");
                                    VariableNode.builtin[3] = ScriptableObject.getClassPrototype(scriptable, "Boolean");
                                    VariableNode.builtin[4] = ScriptableObject.getClassPrototype(scriptable, "Array");
                                    VariableNode.builtin[5] = ScriptableObject.getClassPrototype(scriptable, "Number");
                                }
                                n2 = 0;
                                while (n2 < builtin.length) {
                                    if (scriptable2 == builtin[n2]) {
                                        scriptable2 = null;
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            if (scriptable.has(0, scriptable)) {
                                n2 = 0;
                                try {
                                    Scriptable scriptable4;
                                    Scriptable scriptable5 = scriptable4 = scriptable;
                                    Object object2 = Undefined.instance;
                                    while (!(scriptable5.has("length", scriptable4) && (object2 = scriptable5.get("length", scriptable4)) != Scriptable.NOT_FOUND || (scriptable5 = scriptable5.getPrototype()) == null)) {
                                    }
                                    if (object2 instanceof Number) {
                                        n2 = ((Number)object2).intValue();
                                    }
                                }
                                catch (Exception exception) {}
                                if (scriptable3 != null) {
                                    ++n2;
                                }
                                if (scriptable2 != null) {
                                    ++n2;
                                }
                                this.children = new VariableNode[n2];
                                int n3 = 0;
                                int n4 = 0;
                                if (scriptable2 != null) {
                                    this.children[n3++] = new VariableNode(scriptable, "__proto__");
                                    ++n4;
                                }
                                if (scriptable3 != null) {
                                    this.children[n3++] = new VariableNode(scriptable, "__parent__");
                                    ++n4;
                                }
                                while (n3 < n2) {
                                    this.children[n3] = new VariableNode(scriptable, n3 - n4);
                                    ++n3;
                                }
                                break block35;
                            }
                            n2 = 0;
                            Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
                            Object[] objectArray3 = scriptable.getIds();
                            if (scriptable2 != null) {
                                hashtable.put("__proto__", "__proto__");
                            }
                            if (scriptable3 != null) {
                                hashtable.put("__parent__", "__parent__");
                            }
                            if (objectArray3.length > 0) {
                                int n5 = 0;
                                while (n5 < objectArray3.length) {
                                    hashtable.put(objectArray3[n5], objectArray3[n5]);
                                    ++n5;
                                }
                            }
                            objectArray3 = new Object[hashtable.size()];
                            Enumeration enumeration = hashtable.keys();
                            int n6 = 0;
                            while (true) {
                                if (!enumeration.hasMoreElements()) {
                                    if (objectArray3 != null && objectArray3.length > 0) {
                                        Arrays.sort(objectArray3, new Comparator(){

                                            public int compare(Object object, Object object2) {
                                                return object.toString().compareToIgnoreCase(object2.toString());
                                            }
                                        });
                                        n2 = objectArray3.length;
                                    }
                                    this.children = new VariableNode[n2];
                                    n = 0;
                                    break;
                                }
                                objectArray3[n6++] = enumeration.nextElement().toString();
                            }
                            while (n < n2) {
                                Object object3 = objectArray3[n];
                                this.children[n] = new VariableNode(scriptable, object3.toString());
                                ++n;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    Object var4_8 = null;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    Context.exit();
                    throw throwable;
                }
                Context.exit();
                return this.children;
            }
            Context.exit();
            return objectArray2;
        }
        Object var4_7 = null;
        Context.exit();
        return objectArray;
    }

    public Object getObject() {
        try {
            if (this.scope == null) {
                return null;
            }
            if (this.name != null) {
                if (this.name.equals("this")) {
                    return this.scope;
                }
                Object object = this.name.equals("__proto__") ? this.scope.getPrototype() : (this.name.equals("__parent__") ? this.scope.getParentScope() : this.scope.get(this.name, this.scope));
                if (object == Scriptable.NOT_FOUND) {
                    object = Undefined.instance;
                }
                return object;
            }
            Object object = this.scope.get(this.index, this.scope);
            if (object == Scriptable.NOT_FOUND) {
                object = Undefined.instance;
            }
            return object;
        }
        catch (Exception exception) {
            return "undefined";
        }
    }

    public String toString() {
        return this.name != null ? this.name : "[" + this.index + "]";
    }
}

