/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.mozilla.javascript.tools.shell.ConsoleTextArea;
import org.mozilla.javascript.tools.shell.Main;

public class JSConsole
extends JFrame
implements ActionListener {
    private File CWD;
    private JFileChooser dlg;
    private ConsoleTextArea consoleTextArea;

    public JSConsole(String[] stringArray) {
        super("Rhino JavaScript Console");
        JComponent jComponent;
        Serializable serializable;
        JMenuBar jMenuBar = new JMenuBar();
        this.createFileChooser();
        String[] stringArray2 = new String[]{"Load...", "Exit"};
        String[] stringArray3 = new String[]{"Load", "Exit"};
        char[] cArray = new char[]{'L', 'X'};
        String[] stringArray4 = new String[]{"Cut", "Copy", "Paste"};
        char[] cArray2 = new char[]{'T', 'C', 'P'};
        String[] stringArray5 = new String[]{"Metal", "Windows", "Motif"};
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        boolean[] blArray2 = blArray;
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic('E');
        JMenu jMenu3 = new JMenu("Platform");
        jMenu3.setMnemonic('P');
        int n = 0;
        while (n < stringArray2.length) {
            JMenuItem jMenuItem = new JMenuItem(stringArray2[n], cArray[n]);
            jMenuItem.setActionCommand(stringArray3[n]);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray4.length) {
            serializable = new JMenuItem(stringArray4[n2], cArray2[n2]);
            ((AbstractButton)serializable).addActionListener(this);
            jMenu2.add((JMenuItem)serializable);
            ++n2;
        }
        serializable = new ButtonGroup();
        int n3 = 0;
        while (n3 < stringArray5.length) {
            jComponent = new JRadioButtonMenuItem(stringArray5[n3], blArray2[n3]);
            ((ButtonGroup)serializable).add((AbstractButton)jComponent);
            jComponent.addActionListener(this);
            jMenu3.add((JMenuItem)jComponent);
            ++n3;
        }
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
        this.consoleTextArea = new ConsoleTextArea(stringArray);
        jComponent = new JScrollPane(this.consoleTextArea);
        this.setContentPane(jComponent);
        this.consoleTextArea.setRows(24);
        this.consoleTextArea.setColumns(80);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.pack();
        ((Component)this).setVisible(true);
        System.setIn(this.consoleTextArea.getIn());
        System.setOut(this.consoleTextArea.getOut());
        System.setErr(this.consoleTextArea.getErr());
        Main.exec(stringArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block8: {
            String string;
            String string2;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block7: {
                                string2 = actionEvent.getActionCommand();
                                string = null;
                                if (!string2.equals("Load")) break block7;
                                String string3 = this.chooseFile();
                                if (string3 == null) break block8;
                                string3 = string3.replace('\\', '/');
                                this.consoleTextArea.eval("load(\"" + string3 + "\");");
                                break block8;
                            }
                            if (!string2.equals("Exit")) break block9;
                            System.exit(0);
                            break block8;
                        }
                        if (!string2.equals("Cut")) break block10;
                        this.consoleTextArea.cut();
                        break block8;
                    }
                    if (!string2.equals("Copy")) break block11;
                    this.consoleTextArea.copy();
                    break block8;
                }
                if (!string2.equals("Paste")) break block12;
                this.consoleTextArea.paste();
                break block8;
            }
            if (string2.equals("Metal")) {
                string = "javax.swing.plaf.metal.MetalLookAndFeel";
            } else if (string2.equals("Windows")) {
                string = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
            } else if (string2.equals("Motif")) {
                string = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            }
            if (string == null) break block8;
            try {
                UIManager.setLookAndFeel(string);
                SwingUtilities.updateComponentTreeUI(this);
                this.consoleTextArea.postUpdateUI();
                this.createFileChooser();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage(), "Platform", 0);
            }
        }
    }

    public String chooseFile() {
        String string;
        if (this.CWD == null && (string = System.getProperty("user.dir")) != null) {
            this.CWD = new File(string);
        }
        if (this.CWD != null) {
            this.dlg.setCurrentDirectory(this.CWD);
        }
        this.dlg.setDialogTitle("Select a file to load");
        int n = this.dlg.showOpenDialog(this);
        if (n == 0) {
            String string2 = this.dlg.getSelectedFile().getPath();
            this.CWD = new File(this.dlg.getSelectedFile().getParent());
            return string2;
        }
        return null;
    }

    public void createFileChooser() {
        this.dlg = new JFileChooser();
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                String string;
                if (file.isDirectory()) {
                    return true;
                }
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                return n > 0 && n < string2.length() - 1 && (string = string2.substring(n + 1).toLowerCase()).equals("js");
            }

            public String getDescription() {
                return "JavaScript Files (*.js)";
            }
        };
        this.dlg.addChoosableFileFilter(fileFilter);
    }

    public static void main(String[] stringArray) {
        JSConsole jSConsole = new JSConsole(stringArray);
    }
}

