/*
 * Decompiled with CFR 0.152.
 */
package com.hatop.filters;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;

public final class DocFilter
implements Filter {
    private FilterConfig filterConfig = null;
    static HashMap cache = new HashMap(5);
    private static final String myself = "DocFilter";
    static boolean doCache = true;

    public void destroy() {
        this.filterConfig = null;
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        if ("off".equals(filterConfig.getInitParameter("cache"))) {
            doCache = false;
        }
        this.filterConfig.getServletContext().log("DocFilter: initialized");
    }

    public String toString() {
        if (this.filterConfig == null) {
            return myself;
        }
        StringBuffer stringBuffer = new StringBuffer("DocFilter(");
        stringBuffer.append(this.filterConfig);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private Document getDocument(HttpServletRequest httpServletRequest, String string) {
        String string2 = (String)httpServletRequest.getAttribute("docbase");
        DocumentBuilder documentBuilder = (DocumentBuilder)httpServletRequest.getSession().getAttribute("dBuilder");
        if (documentBuilder == null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                this.filterConfig.getServletContext().log(myself + parserConfigurationException.toString());
            }
            httpServletRequest.getSession().setAttribute("dBuilder", (Object)documentBuilder);
            this.filterConfig.getServletContext().log("DocFilter: created session attribute dBuilder");
        }
        return this.getDocument(string2, string, documentBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getDocument(String string, String string2, DocumentBuilder documentBuilder) {
        Document document;
        block11: {
            if (string2 == null) {
                return null;
            }
            document = null;
            if (doCache) {
                document = (Document)cache.get(string2);
            }
            this.filterConfig.getServletContext().log("DocFilter: load " + string + string2);
            if (document == null) {
                try {
                    if (new File(string + string2).exists()) {
                        this.filterConfig.getServletContext().log("DocFilter:parsing " + string + string2);
                        document = documentBuilder.parse(string + string2);
                        if (document == null) {
                            this.filterConfig.getServletContext().log("DocFilter:parsing failed.");
                            break block11;
                        }
                        HashMap hashMap = cache;
                        synchronized (hashMap) {
                            cache.put(string2, document);
                            break block11;
                        }
                    }
                    return null;
                }
                catch (Exception exception) {
                    this.filterConfig.getServletContext().log(myself + exception.toString());
                    return null;
                }
            }
        }
        if (document == null) {
            this.filterConfig.getServletContext().log("DocFilter: warning: getDocument:: null document");
            return null;
        }
        return (Document)document.cloneNode(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytes(String string) {
        block7: {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                File file = new File(string);
                if (!file.exists()) break block7;
                byte[] byArray = (byte[])cache.get(string);
                if (byArray == null) {
                    int n;
                    FileReader fileReader = new FileReader(file);
                    while ((n = fileReader.read()) != -1) {
                        byteArrayOutputStream.write(n);
                    }
                    fileReader.close();
                    byteArrayOutputStream.close();
                    byArray = byteArrayOutputStream.toByteArray();
                    HashMap hashMap = cache;
                    synchronized (hashMap) {
                        cache.put(string, byArray);
                    }
                }
                return byArray;
            }
            catch (IOException iOException) {
                this.filterConfig.getServletContext().log("DocFilter: can't handle this: " + iOException.toString());
            }
        }
        return null;
    }

    private String getContentType(String string) {
        if (string.endsWith(".html")) {
            return "text/html";
        }
        if (string.endsWith(".pdf")) {
            return "application/pdf";
        }
        return "text/html";
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.filterConfig == null) {
            return;
        }
        long l = System.currentTimeMillis();
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        this.transform(httpServletRequest);
        if ("xml".equals(httpServletRequest.getAttribute("doctype"))) {
            filterChain.doFilter((ServletRequest)httpServletRequest, servletResponse);
        }
        servletResponse.setContentType("text/html");
        if ("html".equals(httpServletRequest.getAttribute("doctype"))) {
            try {
                byte[] byArray = (byte[])httpServletRequest.getAttribute("document");
                servletResponse.getOutputStream().write(byArray);
                servletResponse.getOutputStream().close();
            }
            catch (IOException iOException) {
                this.filterConfig.getServletContext().log(myself + iOException.toString());
            }
        }
        long l2 = System.currentTimeMillis();
        this.filterConfig.getServletContext().log("DocFilter: " + (l2 - l) + " milliseconds");
    }

    private void transform(HttpServletRequest httpServletRequest) throws IOException {
        Document document;
        Object object;
        String string = httpServletRequest.getPathInfo();
        String string2 = this.filterConfig.getServletContext().getRealPath("") + httpServletRequest.getServletPath();
        httpServletRequest.setAttribute("docbase", (Object)string2);
        if (string.endsWith(".html") && (object = (Object)this.getBytes(string2 + string)) != null) {
            httpServletRequest.setAttribute("document", object);
            httpServletRequest.setAttribute("doctype", (Object)"html");
            return;
        }
        object = string;
        if (!((String)object).endsWith(".xml")) {
            object = string.substring(0, string.lastIndexOf(46)) + ".xml";
        }
        if ((document = this.getDocument(httpServletRequest, (String)object)) != null) {
            httpServletRequest.setAttribute("document", (Object)document);
            httpServletRequest.setAttribute("doctype", (Object)"xml");
            return;
        }
        String string3 = "<html><title>Error</title>\n<body> 404 - Document not found </body>\n</html>";
        httpServletRequest.setAttribute("document", (Object)string3.getBytes());
        httpServletRequest.setAttribute("doctype", (Object)"html");
    }
}

