/*
 * Decompiled with CFR 0.152.
 */
package com.hatop.sxql;

import com.hatop.sxql.Logger;
import com.hatop.sxql.database.DataAccessor;
import com.hatop.sxql.transformer.SQLtransformer;
import com.hatop.sxql.transformer.SXsubst;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class SXtractDB {
    private static String myself = "SXtractDB";
    private String fileSep = System.getProperty("file.separator");
    private SQLtransformer sqlTransformer = null;
    private Connection connection = null;
    private DataAccessor dba = null;

    public static SXtractDB getInstance(Connection connection) {
        SXtractDB sXtractDB = new SXtractDB();
        sXtractDB.sqlTransformer = new SQLtransformer(connection, "sql");
        sXtractDB.connection = connection;
        return sXtractDB;
    }

    public static SXtractDB getInstance(String string, String string2, String string3, String string4) throws SQLException {
        Logger.log(3, myself, "::init");
        Logger.log(3, myself, "dbuser=" + string3 + " dbpasswd=" + string4);
        Logger.log(3, myself, " dburl=" + string);
        SXtractDB sXtractDB = new SXtractDB();
        try {
            Class.forName(string2).newInstance();
            Connection connection = DriverManager.getConnection(string, string3, string4);
            sXtractDB.sqlTransformer = new SQLtransformer(connection, "sql");
            sXtractDB.connection = connection;
            return sXtractDB;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace(System.err);
            return null;
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace(System.err);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace(System.err);
            return null;
        }
    }

    public static SXtractDB getInstance(String string) throws SQLException {
        Logger.log(3, myself, "loading properties:" + string);
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(new File(string)));
        }
        catch (IOException iOException) {
            Logger.log(3, iOException.toString());
        }
        String string2 = properties.getProperty("db.dburl");
        String string3 = properties.getProperty("db.dbdriver");
        String string4 = properties.getProperty("db.dbuser");
        String string5 = properties.getProperty("db.dbpasswd");
        return SXtractDB.getInstance(string2, string3, string4, string5);
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Document getDocument(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            return document;
        }
        catch (Exception exception) {
            Logger.log(3, exception);
            return null;
        }
    }

    public void transform(Document document) {
        this.sqlTransformer.transform(document);
    }

    public void transform(Document document, Hashtable hashtable) {
        SXsubst sXsubst = new SXsubst("sql");
        Logger.log(5, myself, hashtable);
        sXsubst.setQuery(document, hashtable);
    }

    public void transform(Document document, PrintWriter printWriter) {
        this.sqlTransformer.transform(document, printWriter);
    }

    public void transform(Document document, String string) {
        Logger.log(3, myself, "writing doc to file " + string);
        PrintWriter printWriter = null;
        try {
            if (string == null) {
                printWriter = new PrintWriter(System.out);
            } else {
                FileWriter fileWriter = new FileWriter(string);
                printWriter = new PrintWriter(fileWriter);
            }
        }
        catch (IOException iOException) {
            Logger.log(3, myself, iOException.toString());
        }
        this.sqlTransformer.transform(document, printWriter);
    }

    public void serialOut(Document document, String string) {
        this.transform(document, string);
    }

    private void doMain(Document document, String string) {
        if (string == null) {
            this.transform(document, new PrintWriter(System.out));
        } else {
            this.transform(document, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Object object3 = null;
        Object object4 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(12);
        String string5 = null;
        if (stringArray.length == 0) {
            SXtractDB.printUsage();
            System.exit(1);
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < stringArray.length) {
            object2 = stringArray[n2];
            if (((String)object2).equals("-h")) {
                SXtractDB.printUsage();
                System.exit(1);
            }
            if (((String)object2).equals("-u")) {
                if (n2 < n - 1) {
                    string = stringArray[++n2];
                }
            } else if (((String)object2).equals("-p")) {
                if (n2 < n - 1) {
                    string2 = stringArray[++n2];
                }
            } else if (((String)object2).equals("-d")) {
                if (n2 < n - 1) {
                    string3 = stringArray[++n2];
                }
            } else if (((String)object2).equals("-debug")) {
                if (n2 < n - 1) {
                    Logger.setLevel(stringArray[++n2]);
                }
            } else if (((String)object2).equals("-j")) {
                if (n2 < n - 1) {
                    string4 = stringArray[++n2];
                }
            } else if (((String)object2).equals("-param")) {
                if (n2 < n - 1) {
                    object = stringArray[++n2];
                    int n3 = ((String)object).lastIndexOf(61);
                    String string6 = ((String)object).substring(0, n3);
                    String string7 = ((String)object).substring(n3 + 1, ((String)object).length());
                    hashtable.put(string6, string7);
                    Logger.log(5, myself, "hashing <" + string6 + "> <" + string7 + ">");
                }
            } else if (((String)object2).equals("-prop")) {
                if (n2 < n - 1) {
                    string5 = stringArray[++n2];
                }
            } else if (object3 == null) {
                object3 = object2;
            } else if (object4 == null) {
                object4 = object2;
            }
            ++n2;
        }
        object2 = null;
        try {
            try {
                if (string5 != null) {
                    object2 = SXtractDB.getInstance(string5);
                } else if (string3 != null) {
                    object2 = SXtractDB.getInstance(string3, string4, string, string2);
                } else {
                    string5 = "Database.properties";
                    object2 = SXtractDB.getInstance(string5);
                }
                object = ((SXtractDB)object2).getDocument((String)object3);
                ((SXtractDB)object2).transform((Document)object, hashtable);
                super.doMain((Document)object, (String)object4);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                Object var17_18 = null;
                if (object2 != null) {
                    ((SXtractDB)object2).close();
                }
            }
            Object var17_17 = null;
            if (object2 != null) {
                ((SXtractDB)object2).close();
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            if (object2 != null) {
                ((SXtractDB)object2).close();
            }
            throw throwable;
        }
    }

    private static void printUsage() {
        System.err.print("usage: java XtractDB -u dbuser");
        System.err.print(" -p dbpasswd -d databse_url ");
        System.err.print(" -j jdbcdriver ");
        System.err.print(" -debug level");
        System.err.print(" -prop properties ");
        System.err.print(" -param name=value");
        System.err.println("infile outfile");
    }
}

