/*
 * Decompiled with CFR 0.152.
 */
package com.hatop.sxql.transformer;

import com.hatop.sxql.Logger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class FormTransformer {
    private static String myself = "FormTransformer";
    private Connection connection = null;
    private String tagname = "sql";

    public FormTransformer(Connection connection) {
        this.connection = connection;
    }

    public FormTransformer(Connection connection, String string) {
        this.connection = connection;
        this.tagname = string;
    }

    public static void transform(Document document, Map map) {
        Object object;
        Logger.log(4, myself, "transforming form against parameter hash");
        if (map == null) {
            Logger.log(1, myself, "null hash");
            return;
        }
        NodeList nodeList = document.getElementsByTagName("input");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            object = (Element)nodeList.item(n2);
            String string = object.getAttribute("name");
            if (map.containsKey(string)) {
                String string2 = object.getAttribute("type");
                if ("text".equalsIgnoreCase(string2) || "hidden".equalsIgnoreCase(string2) || "password".equalsIgnoreCase(string2)) {
                    object.setAttribute("value", map.get(string).toString());
                } else if ("radio".equalsIgnoreCase(string2) || "checkbox".equalsIgnoreCase(string2)) {
                    if (object.getAttribute("value").equalsIgnoreCase(map.get(string).toString())) {
                        object.setAttribute("checked", "checked");
                    } else {
                        object.removeAttribute("checked");
                    }
                }
            }
            ++n2;
        }
        object = document.getElementsByTagName("textarea");
        int n3 = object.getLength();
        int n4 = 0;
        while (n4 < n3) {
            Element element = (Element)object.item(n4);
            String string = element.getAttribute("name");
            if (map.containsKey(string)) {
                NodeList nodeList2 = element.getChildNodes();
                int n5 = nodeList2.getLength();
                int n6 = 0;
                while (n4 < n5) {
                    element.removeChild(nodeList2.item(n6));
                    ++n4;
                }
                element.appendChild(document.createTextNode(map.get(string).toString()));
            }
            ++n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int docRetrieve(Document document, Element element) {
        Object object;
        if (document == null) {
            return -1;
        }
        int n = 0;
        String string = element.getAttribute("query");
        if (string == null || string.trim().equals("")) {
            return 0;
        }
        Logger.log(2, myself, string);
        Element element2 = null;
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        int n3 = 0;
        while (n3 < n2) {
            object = nodeList.item(n3);
            if (object.getNodeType() == 1) {
                element2 = (Element)object;
                break;
            }
            ++n3;
        }
        object = null;
        ResultSet resultSet = null;
        object = this.connection.createStatement();
        resultSet = object.executeQuery(string);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n4 = resultSetMetaData.getColumnCount();
        ResultSetMetaData resultSetMetaData2 = resultSet.getMetaData();
        while (resultSet.next()) {
            ++n;
            int n5 = 1;
            while (n5 <= n4) {
                String string2 = resultSetMetaData.getColumnLabel(n5);
                String string3 = resultSet.getString(n5);
                if (string3 != null && element2 != null) {
                    this.replaceValues(element2, string2, string3);
                }
                ++n5;
            }
        }
        Object var18_18 = null;
        try {
            resultSet.close();
            object.close();
        }
        catch (SQLException sQLException) {
            Logger.log(3, myself, sQLException.toString());
        }
        return n;
        {
            catch (SQLException sQLException) {
                Logger.log(3, myself, sQLException.toString());
                Object var18_19 = null;
                try {
                    resultSet.close();
                    object.close();
                }
                catch (SQLException sQLException2) {
                    Logger.log(3, myself, sQLException2.toString());
                }
                return n;
            }
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            try {
                resultSet.close();
                object.close();
            }
            catch (SQLException sQLException) {
                Logger.log(3, myself, sQLException.toString());
            }
            return n;
        }
    }

    private void replaceValues(Element element, String string, String string2) {
        Object object;
        if (element.getNodeName().equalsIgnoreCase("input") && element.getAttribute("name").equalsIgnoreCase(string)) {
            object = element.getAttribute("type");
            if ("text".equalsIgnoreCase((String)object) || "hidden".equalsIgnoreCase((String)object)) {
                element.setAttribute("value", string2);
            } else if ("radio".equalsIgnoreCase((String)object) || "checkbox".equalsIgnoreCase((String)object)) {
                if (element.getAttribute("value").equalsIgnoreCase(string2)) {
                    element.setAttribute("checked", "checked");
                } else {
                    element.removeAttribute("checked");
                }
            }
        }
        object = element.getChildNodes();
        int n = object.getLength();
        int n2 = 0;
        while (n2 < n) {
            if (object.item(n2).getNodeType() == 1) {
                Element element2 = (Element)object.item(n2);
                this.replaceValues(element2, string, string2);
            }
            ++n2;
        }
    }

    public void transform(Document document) throws SQLException {
        if (this.connection == null) {
            return;
        }
        NodeList nodeList = document.getElementsByTagName(this.tagname);
        int n = nodeList.getLength();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            int n3 = this.docRetrieve(document, element);
            ++n2;
        }
    }
}

