/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveDriverRegistry;
import de.schlichtherle.io.File;
import de.schlichtherle.io.util.SuffixSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

final class GlobalArchiveDriverRegistry
extends ArchiveDriverRegistry {
    private static final long serialVersionUID = 1579600190374703884L;
    private static final String CLASS_NAME;
    private static final Logger logger;
    private static final String KWD_NULL = "NULL";
    private static final String KWD_ALL = "ALL";
    private static final String PROP_KEY_DEFAULT_SUFFIXES = "de.schlichtherle.io.default";
    private static final String PROP_KEY_REGISTRY = "de.schlichtherle.io.registry";
    public static final GlobalArchiveDriverRegistry INSTANCE;
    public final String defaultSuffixes;
    public final String allSuffixes;
    static final /* synthetic */ boolean $assertionsDisabled;

    private GlobalArchiveDriverRegistry() {
        this.registerArchiveDrivers();
        this.defaultSuffixes = this.defaultSuffixes().toString();
        this.allSuffixes = this.suffixes().toString();
        this.logConfiguration();
    }

    private static final String[] getServices() {
        return System.getProperty(PROP_KEY_REGISTRY, "META-INF/services/de.schlichtherle.io.registry.properties" + File.pathSeparator + "META-INF/services/" + CLASS_NAME + ".properties" + File.pathSeparator + "META-INF/services/de.schlichtherle.io.archive.spi.ArchiveDriver.properties").split("\\" + File.pathSeparator);
    }

    private void registerArchiveDrivers() {
        ArchiveDriverRegistry clientRegistry = new ArchiveDriverRegistry();
        String[] services = GlobalArchiveDriverRegistry.getServices();
        int i = services.length;
        while (--i >= 0) {
            GlobalArchiveDriverRegistry.registerArchiveDrivers(services[i], (ArchiveDriverRegistry)this, clientRegistry);
        }
        this.putAll(clientRegistry);
    }

    private static void registerArchiveDrivers(String service, ArchiveDriverRegistry driverRegistry, ArchiveDriverRegistry clientRegistry) {
        Enumeration<URL> urls;
        if (!$assertionsDisabled && service == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && driverRegistry == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && clientRegistry == null) {
            throw new AssertionError();
        }
        try {
            ClassLoader l = Thread.currentThread().getContextClassLoader();
            if (l == null) {
                l = ClassLoader.getSystemClassLoader();
            }
            urls = l.getResources(service);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "lookup.ex", ex);
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            GlobalArchiveDriverRegistry.registerArchiveDrivers(url, driverRegistry, clientRegistry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerArchiveDrivers(URL url, ArchiveDriverRegistry driverRegistry, ArchiveDriverRegistry clientRegistry) {
        if (!$assertionsDisabled && url == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && driverRegistry == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && clientRegistry == null) {
            throw new AssertionError();
        }
        logger.log(Level.CONFIG, "loading", url);
        Properties config = new Properties();
        try {
            InputStream in = url.openStream();
            try {
                config.load(in);
                GlobalArchiveDriverRegistry.registerArchiveDrivers(config, driverRegistry, clientRegistry);
            }
            finally {
                in.close();
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "loading.ex", ex);
        }
    }

    private static void registerArchiveDrivers(Map config, ArchiveDriverRegistry driverRegistry, ArchiveDriverRegistry clientRegistry) {
        if (!$assertionsDisabled && config == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && driverRegistry == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && clientRegistry == null) {
            throw new AssertionError();
        }
        String driver = (String)config.remove("DRIVER");
        boolean isDriver = Boolean.TRUE.equals(Boolean.valueOf(driver));
        (isDriver ? driverRegistry : clientRegistry).registerArchiveDrivers(config, false);
    }

    private SuffixSet defaultSuffixes() {
        SuffixSet set;
        String defaultSuffixesProperty = System.getProperty(PROP_KEY_DEFAULT_SUFFIXES);
        if (defaultSuffixesProperty != null) {
            set = new SuffixSet(defaultSuffixesProperty);
        } else {
            set = (SuffixSet)this.remove("DEFAULT");
            if (set == null) {
                return new SuffixSet();
            }
        }
        SuffixSet all = this.suffixes();
        boolean clear = false;
        boolean addAll = false;
        Iterator i = set.originalIterator();
        while (i.hasNext()) {
            String suffix = (String)i.next();
            if (KWD_NULL.equals(suffix)) {
                i.remove();
                clear = true;
                continue;
            }
            if (KWD_ALL.equals(suffix)) {
                i.remove();
                addAll = true;
                continue;
            }
            if (all.contains(suffix)) continue;
            i.remove();
            logger.log(Level.WARNING, "unknownSuffix", suffix);
        }
        if (clear) {
            set.clear();
        } else if (addAll) {
            set.addAll(all);
        }
        return set;
    }

    private void logConfiguration() {
        Iterator i = this.entrySet().iterator();
        if (i.hasNext()) {
            do {
                Map.Entry entry = i.next();
                logger.log(Level.CONFIG, "driverRegistered", new Object[]{entry.getKey(), entry.getValue()});
            } while (i.hasNext());
            logger.log(Level.CONFIG, "allSuffixList", this.allSuffixes);
            if (this.defaultSuffixes.length() > 0) {
                logger.log(Level.CONFIG, "defaultSuffixList", this.defaultSuffixes);
            } else {
                logger.config("noDefaultSuffixes");
            }
        } else {
            logger.warning("noDriversRegistered");
        }
    }

    static {
        $assertionsDisabled = !GlobalArchiveDriverRegistry.class.desiredAssertionStatus();
        CLASS_NAME = "de/schlichtherle/io/GlobalArchiveDriverRegistry".replace('/', '.');
        logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
        INSTANCE = new GlobalArchiveDriverRegistry();
        logger.config("banner");
    }
}

