/*
 * Decompiled with CFR 0.152.
 */
package ai.FilePack;

import ai.FilePack.MyDir;
import ai.FilePack.MyFile;
import com.epaperarchives.batchxslt.mainXSLTFrame;
import java.io.File;
import java.util.ArrayList;

public class MyFileStructure {
    private String dirname = "";
    private MyDir mdir = null;
    String result;
    ArrayList<MyFile> myfilelist = null;

    public void setDirname(String dirname) {
        this.dirname = dirname;
    }

    public String getDirname() {
        return this.dirname;
    }

    public String getResult() {
        return this.result;
    }

    public void build() {
        File f = new File(this.dirname);
        this.mdir = this.build(f);
    }

    private MyDir build(File f) {
        if (!f.exists()) {
            return null;
        }
        if (!f.isDirectory()) {
            return null;
        }
        String path = f.getPath();
        String name = f.getName();
        MyDir thedir = new MyDir(path, name);
        String[] files = f.list();
        for (int i = 0; i < files.length; ++i) {
            File f3;
            MyDir m;
            File f2 = new File(path, files[i]);
            if (f2.isFile() || f2.getName().toUpperCase().startsWith("ICO") && (f2.getName().length() == 5 || f2.getName().length() == 4) && (f2.getName().endsWith("\r") || f2.getName().endsWith("?"))) {
                thedir.addFile(new MyFile(path, files[i]));
                continue;
            }
            if (!f2.isDirectory() || (m = this.build(f3 = new File(path, files[i]))) == null) continue;
            thedir.addDir(m);
        }
        return thedir;
    }

    protected void outFile(MyFile f, int level) {
        String name = f.getName();
        this.result = this.result + this.repeat(" ", 2 * level) + "File: " + name + "\n";
    }

    protected void outDir(MyDir d, int level) {
        String name = d.getName();
        this.result = this.result + this.repeat(" ", 2 * level) + "Dir: " + name + "\n";
    }

    protected void outEndDir() {
    }

    public void list() {
        if (this.mdir == null) {
            System.out.println("Not a valid directory");
            return;
        }
        this.result = "";
        this.outDir(this.mdir, 0);
        this.list(this.mdir, 0);
        this.outEndDir();
    }

    private void list(MyDir m, int level) {
        ++level;
        ArrayList<MyDir> md = m.getDirs();
        for (int i = 0; i < md.size(); ++i) {
            MyDir d = md.get(i);
            this.outDir(d, level);
            this.list(d, level);
            this.outEndDir();
        }
        ArrayList<MyFile> mf = m.getFiles();
        for (int i = 0; i < mf.size(); ++i) {
            MyFile f = mf.get(i);
            this.outFile(f, level);
        }
    }

    private String repeat(String c, int n) {
        StringBuilder s = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            s.append(c);
        }
        return s.toString();
    }

    public void build_file_list() {
        if (this.mdir == null) {
            return;
        }
        if (this.myfilelist == null) {
            this.myfilelist = new ArrayList();
        } else {
            this.myfilelist.clear();
        }
        this.build_file_list(this.mdir, 0);
    }

    private void build_file_list(MyDir m, int level) {
        ++level;
        ArrayList<MyFile> mf = m.getFiles();
        for (int i = 0; i < mf.size(); ++i) {
            if (mainXSLTFrame.general_abort) {
                this.myfilelist = null;
                return;
            }
            this.myfilelist.add(mf.get(i));
        }
        ArrayList<MyDir> md = m.getDirs();
        for (int i = 0; i < md.size(); ++i) {
            if (mainXSLTFrame.general_abort) {
                this.myfilelist = null;
                return;
            }
            MyDir d = md.get(i);
            MyFile f = new MyFile(d.getPath(), d.getName(), 2);
            this.myfilelist.add(f);
            this.build_file_list(d, level);
        }
    }

    public void insertFile(String path, String name, int idx) {
        MyFile f = new MyFile(path, name, 1);
        this.myfilelist.add(idx, f);
    }

    public int file_list_size() {
        if (this.mdir == null) {
            return 0;
        }
        if (this.myfilelist == null) {
            return 0;
        }
        if (this.myfilelist.size() <= 0) {
            return 0;
        }
        return this.myfilelist.size();
    }

    public boolean is_locked_folder(int idx) {
        if (this.myfilelist == null) {
            return false;
        }
        if (idx >= this.myfilelist.size()) {
            return false;
        }
        MyFile f = this.myfilelist.get(idx);
        return f.is_locked_folder();
    }

    public boolean is_empty_folder(int idx) {
        if (this.myfilelist == null) {
            return false;
        }
        if (idx >= this.myfilelist.size()) {
            return false;
        }
        MyFile f = this.myfilelist.get(idx);
        if (f.getType() != 2) {
            return false;
        }
        if (idx == this.myfilelist.size() - 1) {
            return true;
        }
        MyFile f2 = this.myfilelist.get(idx + 1);
        if (f.getType() == 1 && f.getPath().equals(f2.getPath())) {
            return false;
        }
        return f.getType() != 2 || !f2.getPath().startsWith(f.getPath());
    }

    public int get_file_type(int idx) {
        if (this.myfilelist == null) {
            return -1;
        }
        if (idx >= this.myfilelist.size()) {
            return -1;
        }
        MyFile f = this.myfilelist.get(idx);
        return f.getType();
    }

    public String get_file_path(int idx) {
        if (this.myfilelist == null) {
            return "";
        }
        if (idx >= this.myfilelist.size()) {
            return "";
        }
        MyFile f = this.myfilelist.get(idx);
        return f.getPath();
    }

    public String get_file_name(int idx) {
        if (this.myfilelist == null) {
            return "";
        }
        if (idx >= this.myfilelist.size()) {
            return "";
        }
        MyFile f = this.myfilelist.get(idx);
        return f.getName();
    }

    public boolean is_folder_empty(String dirpath, boolean delete_it) {
        File mytmpFile;
        String root_path = "";
        if (dirpath == null) {
            return false;
        }
        if (dirpath.equals("")) {
            return false;
        }
        if (delete_it && (root_path = this.getDirname()).endsWith(File.separator)) {
            root_path = root_path.substring(0, root_path.length() - 1);
        }
        if ((mytmpFile = new File(dirpath)).isDirectory()) {
            String[] flist = mytmpFile.list();
            if (flist.length > 0) {
                return false;
            }
            if (delete_it) {
                int pos;
                boolean retflag;
                int retry_cnt;
                if (!dirpath.startsWith(root_path)) {
                    return true;
                }
                String my_dirpath = dirpath;
                if (my_dirpath.endsWith(File.separator)) {
                    my_dirpath = my_dirpath.substring(0, my_dirpath.length() - 1);
                }
                if (root_path.equals(my_dirpath)) {
                    return true;
                }
                for (retry_cnt = 0; retry_cnt < 5 && !(retflag = mytmpFile.delete()); ++retry_cnt) {
                }
                while (!root_path.equals("") && (pos = my_dirpath.lastIndexOf(File.separator)) > -1 && !root_path.equals(my_dirpath = my_dirpath.substring(0, pos)) && (mytmpFile = new File(my_dirpath)).isDirectory()) {
                    for (retry_cnt = 0; retry_cnt < 5 && !(retflag = mytmpFile.delete()); ++retry_cnt) {
                    }
                }
            }
            return true;
        }
        return false;
    }
}

