/*
 * Decompiled with CFR 0.152.
 */
package com.epaperarchives.batchxslt;

import com.epaperarchives.batchxslt.BatchXSLT;
import com.epaperarchives.batchxslt.BatchXSLTGhostScript;
import com.epaperarchives.batchxslt.BatchXSLTImageMagick;
import com.epaperarchives.batchxslt.BatchXSLTransform;
import com.epaperarchives.batchxslt.JpgImage;
import com.epaperarchives.batchxslt.NullOutputStream;
import com.epaperarchives.batchxslt.StreamGobbler;
import com.epaperarchives.batchxslt.mainXSLTFrame;
import com.ibm.icu.text.Normalizer;
import de.schlichtherle.NZip;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.apache.pdfbox.util.PDFMergerUtility;
import org.apache.pdfbox.util.PDFTextStripper;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.tika.cli.TikaCLI;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class utils {
    private static final String PACKAGE_NAME = "com.epaperarchives.batchxslt.utils";
    private static String errorResponse = "";
    private static String stdoutResponse = "";
    private static String lastFileExceptionMessage = "";
    private static int lastFileExceptionError = 0;
    private static String last_fileBynaryReplace_file = "";
    static Iterator<File> directoryListIterator = null;
    static String directoryListRootPath = "";
    private static String PDFmergeError = "";
    private static String metaExtractError = "";
    private static String metaExtractData = "";
    private static String NZIPexpandError = "";
    private static String IDMLexpandError = "";
    private static int IDMLexpandErrorNum = 0;
    private static String IDMLexpandParentFolder = "";
    private static String IDMLexpandFolderName = "";
    private static String IDMLmergedPath = "";
    private static String IDMLmergedXMLName = "";
    public static ArrayList publicStorageArray = new ArrayList();

    public static int getLastFileExceptionError() {
        return lastFileExceptionError;
    }

    public static String getLastFileExceptionMessage() {
        return lastFileExceptionMessage;
    }

    public static String composeUnicodeNFC(String decomposedStr) {
        Normalizer normalizer = new Normalizer(decomposedStr, Normalizer.NFC, 32);
        String composedString = Normalizer.compose((String)decomposedStr, (boolean)false);
        return composedString;
    }

    public static String composeUnicodeNFKC(String decomposedStr) {
        Normalizer normalizer = new Normalizer(decomposedStr, Normalizer.NFKC, 32);
        String composedString = Normalizer.compose((String)decomposedStr, (boolean)true);
        return composedString;
    }

    public static String decomposeUnicodeNFD(String composedStr) {
        Normalizer normalizer = new Normalizer(composedStr, Normalizer.NFD, 32);
        String decomposedString = Normalizer.decompose((String)composedStr, (boolean)false);
        return decomposedString;
    }

    public static int callMethod(String methodString) {
        int err;
        block15: {
            if (methodString == null || methodString.equals("")) {
                return -11;
            }
            String[] methodArr = methodString.split(",");
            String classname = "";
            String methodname = "";
            String[] arguments = new String[methodArr.length - 2];
            err = 0;
            if (methodArr.length < 2) {
                err = -101;
            } else {
                Method methodToExecute;
                Class<?> classToCall;
                classname = methodArr[0];
                methodname = methodArr[1];
                int i = 2;
                int j = 0;
                while (i < methodArr.length) {
                    arguments[j] = methodArr[i];
                    ++i;
                    ++j;
                }
                try {
                    classToCall = Class.forName(classname);
                }
                catch (ClassNotFoundException ex) {
                    err = -102;
                    break block15;
                }
                try {
                    methodToExecute = classToCall.getDeclaredMethod(methodname, String[].class);
                }
                catch (NoSuchMethodException ex) {
                    err = -103;
                    break block15;
                }
                catch (SecurityException ex) {
                    err = -104;
                    break block15;
                }
                try {
                    methodToExecute.invoke(classToCall.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), new Object[]{arguments});
                }
                catch (IllegalAccessException ex) {
                    err = -105;
                }
                catch (IllegalArgumentException ex) {
                    err = -106;
                }
                catch (InvocationTargetException ex) {
                    err = -107;
                }
                catch (InstantiationException ex) {
                    err = -108;
                }
                catch (NoSuchMethodException ex) {
                    err = -109;
                }
            }
        }
        return err;
    }

    public static String callExternalAppGetErrorResponse() {
        return errorResponse;
    }

    public static String callExternalAppGetStdinResponse() {
        return stdoutResponse;
    }

    public static String callExternalAppGetStdoutResponse() {
        return stdoutResponse;
    }

    public static int callExternalApplication(String applString) {
        if (applString == null || applString.equals("")) {
            return -11;
        }
        String app_path = null;
        String params = null;
        String envir = null;
        String workdir = null;
        String convertParamsToNativeCharset = null;
        String waitComplete = null;
        String timeout = null;
        int err = 0;
        String[] theApplicationsArr = applString.split("/#/");
        for (int i = 0; i < theApplicationsArr.length; ++i) {
            String[] myApplicationArr = theApplicationsArr[i].split(",");
            if (myApplicationArr[0].equals("")) {
                return -12;
            }
            app_path = myApplicationArr[0];
            if (myApplicationArr.length >= 2 && !myApplicationArr[1].equals("")) {
                params = myApplicationArr[1];
            }
            if (myApplicationArr.length >= 3 && !myApplicationArr[2].equals("")) {
                envir = myApplicationArr[2];
            }
            if (myApplicationArr.length >= 4 && !myApplicationArr[3].equals("")) {
                workdir = myApplicationArr[3];
            }
            if (myApplicationArr.length >= 5 && !myApplicationArr[4].equals("")) {
                convertParamsToNativeCharset = myApplicationArr[4];
            }
            if (myApplicationArr.length >= 6 && !myApplicationArr[5].equals("")) {
                waitComplete = myApplicationArr[5];
            }
            if (myApplicationArr.length >= 7 && !myApplicationArr[6].equals("")) {
                timeout = myApplicationArr[6];
            }
            err = utils.callExternalApp(app_path, params, envir, workdir, convertParamsToNativeCharset, waitComplete, timeout);
        }
        return err;
    }

    public static int callExternalApp(String app_path) {
        return utils.callExternalApp(app_path, null, null, null, null, "1", "-1");
    }

    public static int callExternalApp(String app_path, String params) {
        return utils.callExternalApp(app_path, params, null, null, null, "1", "-1");
    }

    public static int callExternalApp(String app_path, String params, String envir) {
        return utils.callExternalApp(app_path, params, envir, null, null, "1", "-1");
    }

    public static int callExternalApp(String app_path, String params, String envir, String workdir) {
        return utils.callExternalApp(app_path, params, envir, workdir, null, "1", "-1");
    }

    public static int callExternalApp(String app_path, String params, String envir, String workdir, String convertParamsToNativeCharset) {
        return utils.callExternalApp(app_path, params, envir, workdir, convertParamsToNativeCharset, "1", "-1");
    }

    public static int callExternalApp(String app_path, String params, String envir, String workdir, String convertParamsToNativeCharset, String waitComplete, String timeout) {
        Object home;
        File myworkdir;
        String[] myenvir;
        int myparams_length;
        Object[] myparams;
        int exitVal;
        block56: {
            block57: {
                int i;
                block71: {
                    block70: {
                        block67: {
                            block69: {
                                block68: {
                                    block64: {
                                        block66: {
                                            block65: {
                                                block61: {
                                                    block63: {
                                                        block62: {
                                                            block58: {
                                                                block60: {
                                                                    block59: {
                                                                        String myparamsstr;
                                                                        if (app_path == null || app_path.equals("")) {
                                                                            return -2;
                                                                        }
                                                                        exitVal = -1;
                                                                        myparams = null;
                                                                        myparams_length = 0;
                                                                        myenvir = null;
                                                                        myworkdir = null;
                                                                        home = System.getProperty("user.home");
                                                                        if (!((String)home).endsWith(File.separator)) {
                                                                            home = (String)home + File.separator;
                                                                        }
                                                                        if (mainXSLTFrame.im_debug > 0) {
                                                                            System.out.println("***********************");
                                                                            System.out.println("*** Default Charset=" + Charset.defaultCharset());
                                                                            System.out.println("*** Default file Charset=" + mainXSLTFrame.systemDefaultCharset);
                                                                            System.out.println("*** callExternalApp app_path: '" + app_path + "'");
                                                                            System.out.println("*** callExternalApp params: '" + params + "'");
                                                                            System.out.println("*** callExternalApp envir: '" + envir + "'");
                                                                            System.out.println("*** callExternalApp workdir: '" + workdir + "'");
                                                                            System.out.println("*** callExternalApp convertParamsToNativeCharset: '" + convertParamsToNativeCharset + "'");
                                                                            System.out.println("*** callExternalApp params HEX: '" + BatchXSLTransform.stringUTF8_2hex(params) + "'");
                                                                        }
                                                                        if ((myparamsstr = params) != null && !myparamsstr.equals("")) {
                                                                            while (myparamsstr.indexOf("  ") > 0) {
                                                                                myparamsstr = myparamsstr.replaceAll("  ", " ");
                                                                            }
                                                                            if ((myparamsstr = myparamsstr.trim()).equals("")) {
                                                                                myparamsstr = null;
                                                                            }
                                                                        }
                                                                        if (myparamsstr == null || myparamsstr.equals("")) break block56;
                                                                        myparams = myparamsstr.split(" ");
                                                                        if (mainXSLTFrame.im_debug > 0) {
                                                                            System.out.println("*** callExternalApp myparams arr: '" + Arrays.toString(myparams) + "'");
                                                                        }
                                                                        for (i = 0; i < myparams.length; ++i) {
                                                                            myparams[i] = ((String)myparams[i]).replaceAll("~blnk~", " ");
                                                                            if (!((String)myparams[i]).startsWith("~")) continue;
                                                                            myparams[i] = (String)home + ((String)myparams[i]).substring(2);
                                                                        }
                                                                        if (mainXSLTFrame.im_debug > 0) {
                                                                            System.out.println("*** callExternalApp myparams cleaned arr: '" + Arrays.toString(myparams) + "'");
                                                                        }
                                                                        if (convertParamsToNativeCharset == null || convertParamsToNativeCharset.length() <= 0) break block57;
                                                                        if (convertParamsToNativeCharset.indexOf("1") < 0) break block58;
                                                                        if (convertParamsToNativeCharset.indexOf("1-w") < 0) break block59;
                                                                        if (mainXSLTFrame.systemOSname.indexOf("Wind") >= 0) break block58;
                                                                    }
                                                                    if (convertParamsToNativeCharset.indexOf("1-x") < 0) break block60;
                                                                    if (mainXSLTFrame.systemOSname.indexOf("Wind") < 0) break block58;
                                                                }
                                                                for (i = 0; i < myparams.length; ++i) {
                                                                    myparams[i] = utils.composeUnicodeNFC((String)myparams[i]);
                                                                }
                                                            }
                                                            if (convertParamsToNativeCharset.indexOf("3") < 0) break block61;
                                                            if (convertParamsToNativeCharset.indexOf("3-w") < 0) break block62;
                                                            if (mainXSLTFrame.systemOSname.indexOf("Wind") >= 0) break block61;
                                                        }
                                                        if (convertParamsToNativeCharset.indexOf("3-x") < 0) break block63;
                                                        if (mainXSLTFrame.systemOSname.indexOf("Wind") < 0) break block61;
                                                    }
                                                    for (i = 0; i < myparams.length; ++i) {
                                                        myparams[i] = utils.decomposeUnicodeNFD((String)myparams[i]);
                                                    }
                                                }
                                                if (convertParamsToNativeCharset.indexOf("2") < 0) break block64;
                                                if (convertParamsToNativeCharset.indexOf("2-w") < 0) break block65;
                                                if (mainXSLTFrame.systemOSname.indexOf("Wind") >= 0) break block64;
                                            }
                                            if (convertParamsToNativeCharset.indexOf("2-x") < 0) break block66;
                                            if (mainXSLTFrame.systemOSname.indexOf("Wind") < 0) break block64;
                                        }
                                        for (i = 0; i < myparams.length; ++i) {
                                            myparams[i] = utils.convertStringFromUTF8toSystemNative((String)myparams[i]);
                                        }
                                    }
                                    if (convertParamsToNativeCharset.indexOf("4") < 0) break block67;
                                    if (convertParamsToNativeCharset.indexOf("4-w") < 0) break block68;
                                    if (mainXSLTFrame.systemOSname.indexOf("Wind") >= 0) break block67;
                                }
                                if (convertParamsToNativeCharset.indexOf("4-x") < 0) break block69;
                                if (mainXSLTFrame.systemOSname.indexOf("Wind") < 0) break block67;
                            }
                            for (i = 0; i < myparams.length; ++i) {
                                myparams[i] = utils.convertStringFromUTF8toUTF16LE((String)myparams[i]);
                            }
                        }
                        if (convertParamsToNativeCharset.indexOf("5") < 0) break block57;
                        if (convertParamsToNativeCharset.indexOf("5-w") < 0) break block70;
                        if (mainXSLTFrame.systemOSname.indexOf("Wind") >= 0) break block57;
                    }
                    if (convertParamsToNativeCharset.indexOf("5-x") < 0) break block71;
                    if (mainXSLTFrame.systemOSname.indexOf("Wind") < 0) break block57;
                }
                for (i = 0; i < myparams.length; ++i) {
                    myparams[i] = utils.convertStringFromUTF16toSystemNative((String)myparams[i]);
                }
            }
            myparams_length = myparams.length;
        }
        if (envir != null && !envir.equals("")) {
            myenvir = envir.split("\\+\\+\\+");
        }
        if (workdir != null && !workdir.equals("")) {
            Object strworkdir = workdir.replaceAll("~blnk~", " ");
            if (((String)strworkdir).startsWith("~")) {
                strworkdir = (String)home + ((String)strworkdir).substring(2);
            }
            myworkdir = new File((String)strworkdir);
        }
        Object[] cmd = new String[myparams_length + 1];
        cmd[0] = app_path;
        cmd[0] = cmd[0].replaceAll("~blnk~", " ");
        if (cmd[0].startsWith("~")) {
            cmd[0] = (String)home + cmd[0].substring(2);
        }
        for (int i = 0; i < myparams_length; ++i) {
            cmd[i + 1] = myparams[i];
        }
        try {
            Runtime rt = Runtime.getRuntime();
            if (mainXSLTFrame.im_debug > 0) {
                System.out.println("---------------------------------------------");
                System.out.println("Program call: '" + Arrays.toString(cmd));
            }
            ProcessBuilder pb = new ProcessBuilder((String[])cmd);
            if (envir != null) {
                if (mainXSLTFrame.im_debug > 0) {
                    System.out.println("IMAGE MAGICK environment variables:");
                }
                Map<String, String> environment = pb.environment();
                for (int i = 0; i < myenvir.length; ++i) {
                    String[] key_val = myenvir[i].split("=");
                    environment.put(key_val[0], key_val[1]);
                    if (mainXSLTFrame.im_debug <= 0) continue;
                    System.out.println(key_val[0] + "=" + key_val[1] + "'");
                }
            }
            pb.directory(myworkdir);
            pb.redirectErrorStream(true);
            final Process proc = pb.start();
            StreamGobbler inGobbler = new StreamGobbler(proc.getInputStream(), "STDOUT", false);
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR", false);
            inGobbler.start();
            errorGobbler.start();
            Timer killtimer = null;
            Long the_timeout = mainXSLTFrame.externalProcessTimeout;
            if (!timeout.equals("-1") && !timeout.equals("")) {
                the_timeout = Integer.valueOf(timeout).longValue();
            }
            if (the_timeout > 0L) {
                killtimer = new Timer();
                killtimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        proc.destroy();
                        System.out.println("### External application destroyed after timeout!");
                    }
                }, the_timeout);
            }
            if (waitComplete == null || waitComplete.equals("") || waitComplete.indexOf("0") < 0) {
                exitVal = proc.waitFor();
            }
            if (killtimer != null) {
                killtimer.cancel();
            }
            stdoutResponse = inGobbler.getResponse();
            errorResponse = errorGobbler.getResponse();
            if (mainXSLTFrame.im_debug > 0) {
                System.out.println("*** ExternalApp response: " + stdoutResponse);
            }
            if (exitVal != 0) {
                System.out.println("### External application ERROR " + exitVal + " in command:\n" + pb.command() + "\n   " + errorResponse);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return -3;
        }
        return exitVal;
    }

    public static String getname_last_fileBynaryReplace_file() {
        return last_fileBynaryReplace_file;
    }

    public static boolean delete_last_fileBynaryReplace_file() {
        if (last_fileBynaryReplace_file.equals("")) {
            return false;
        }
        boolean deleted = utils.deleteFile(last_fileBynaryReplace_file);
        last_fileBynaryReplace_file = "";
        return deleted;
    }

    public static void clear_last_fileBynaryReplace_file() {
        last_fileBynaryReplace_file = "";
    }

    public static int fileBynaryReplace(String infilepath, String outfilepath, String find, String replace) {
        last_fileBynaryReplace_file = "";
        if (infilepath == null || infilepath.equals("")) {
            return -1;
        }
        if (find == null || find.equals("")) {
            return -2;
        }
        String my_infilepath = infilepath;
        Object my_outfilepath = outfilepath;
        if (((String)my_outfilepath).equals("")) {
            String splitter = File.separator;
            if (splitter.equals("\\")) {
                splitter = "\\\\";
            }
            String[] mypaths = null;
            try {
                mypaths = my_infilepath.split(splitter);
            }
            catch (Exception e) {
                System.out.println("## ERREOR splitting file path in 'fileBynaryReplace': " + my_infilepath);
                return -3;
            }
            mypaths[mypaths.length - 1] = "zz_" + mypaths[mypaths.length - 1];
            for (int i = 0; i < mypaths.length - 1; ++i) {
                my_outfilepath = (String)my_outfilepath + mypaths[i] + File.separator;
            }
            my_outfilepath = (String)my_outfilepath + mypaths[mypaths.length - 1];
        }
        byte[] find_bytes = null;
        byte[] replace_bytes = null;
        try {
            find_bytes = find.getBytes("UTF-8");
            replace_bytes = replace.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return -3;
        }
        File infile = new File(my_infilepath);
        if (!infile.exists()) {
            return -4;
        }
        byte[] inbytes = null;
        FileInputStream is = null;
        FileOutputStream fos = null;
        int infile_size = 0;
        try {
            is = new FileInputStream(my_infilepath);
        }
        catch (FileNotFoundException fnfex) {
            return -5;
        }
        try {
            infile_size = ((InputStream)is).available();
            if (infile_size <= 0) {
                ((InputStream)is).close();
                return -6;
            }
            inbytes = new byte[infile_size];
            int num_read = ((InputStream)is).read(inbytes, 0, infile_size);
            ((InputStream)is).close();
            if (num_read <= 0) {
                return -7;
            }
        }
        catch (IOException ioex) {
            return -8;
        }
        boolean found = false;
        int i = 0;
        int f = 0;
        int serach_length = infile_size - find_bytes.length + 1;
        for (i = 0; i < serach_length; ++i) {
            for (f = 0; f < find_bytes.length && i + f <= serach_length && inbytes[i + f] == find_bytes[f]; ++f) {
            }
            if (f >= find_bytes.length) {
                found = true;
            }
            if (found) break;
        }
        if (!found) {
            return -9;
        }
        try {
            fos = new FileOutputStream((String)my_outfilepath);
        }
        catch (FileNotFoundException fnfex) {
            return -10;
        }
        try {
            fos.write(inbytes, 0, i);
            fos.write(replace_bytes);
            fos.write(inbytes, i + find_bytes.length, inbytes.length - i - find_bytes.length);
        }
        catch (IOException ioex) {
            try {
                fos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return -12;
        }
        try {
            fos.close();
        }
        catch (IOException ioex) {
            return -13;
        }
        last_fileBynaryReplace_file = my_outfilepath;
        return 0;
    }

    public static String setJobTicketVariable(String varname, String valuestr) {
        if (varname.equals("")) {
            return "";
        }
        try {
            if (varname.equals("mode")) {
                mainXSLTFrame.mode = Integer.valueOf(valuestr);
                return varname;
            }
            if (varname.equals("loopDelay")) {
                mainXSLTFrame.loopDelay = Integer.valueOf(valuestr);
                return varname;
            }
            if (varname.equals("debug")) {
                int myDEBUG = Integer.valueOf(valuestr);
                mainXSLTFrame.DEBUG = myDEBUG > 0;
                return varname;
            }
            if (varname.equals("im_debug")) {
                mainXSLTFrame.im_debug = Integer.valueOf(valuestr);
                return varname;
            }
            if (varname.equals("excludeSourceProcessingRunFileNameExts")) {
                mainXSLTFrame.excludeSourceProcessingRunFileNameExts = valuestr;
                return varname;
            }
            if (varname.equals("excludeCleanupRunFileNameExts")) {
                mainXSLTFrame.excludeCleanupRunFileNameExts = valuestr;
                return varname;
            }
            if (varname.equals("sourceFileAction")) {
                mainXSLTFrame.sourceFileAction = valuestr;
                return varname;
            }
            if (varname.equals("deleteSourceDirs")) {
                mainXSLTFrame.deleteSourceDirs = Integer.valueOf(valuestr);
                return varname;
            }
            if (varname.equals("runBeforeJobApp")) {
                mainXSLTFrame.runBeforeJobApp = valuestr;
                return varname;
            }
            if (varname.equals("runAfterJobApp")) {
                mainXSLTFrame.runAfterJobApp = valuestr;
                return varname;
            }
            if (varname.equals("runBeforeTransformApp")) {
                mainXSLTFrame.runBeforeTransformApp = valuestr;
                return varname;
            }
            if (varname.equals("runAfterTransformApp")) {
                mainXSLTFrame.runAfterTransformApp = valuestr;
                return varname;
            }
            if (varname.equals("mainJobTicketPath")) {
                mainXSLTFrame.mainJobTicketPath = valuestr;
                return varname;
            }
            if (varname.equals("nextJobTicketPath")) {
                mainXSLTFrame.nextJobTicketPath = valuestr;
                return varname;
            }
            if (varname.equals("nextJobTicketFileName")) {
                mainXSLTFrame.nextJobTicketFileName = valuestr;
                return varname;
            }
            if (varname.equals("JobTicketOverrideQueuePath")) {
                mainXSLTFrame.jtoverrideQueuePath = valuestr;
                return varname;
            }
        }
        catch (NumberFormatException ex) {
            return "";
        }
        return "";
    }

    public static void showMess(String mess) {
        BatchXSLT.g_mainXSLTFrame.showMess(mess);
    }

    public static void showMess(String mess, String writelog) {
        BatchXSLT.g_mainXSLTFrame.showMess(mess, !writelog.equals("0"));
    }

    public static String serializeDOMls(Node theDOMsource, String indent, String omit_xml_declaration) {
        if (theDOMsource == null) {
            return "";
        }
        DOMImplementationLS impl = null;
        LSSerializer writer = null;
        try {
            impl = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
        }
        catch (Exception e1) {
            System.out.println("EXCEPTION in serializeDOMls when creating instance: " + e1);
            return "";
        }
        try {
            writer = impl.createLSSerializer();
        }
        catch (Exception e2) {
            System.out.println("EXCEPTION in serializeDOMls when creating serializer: " + e2);
            return "";
        }
        try {
            DOMConfiguration config = writer.getDomConfig();
            if (indent.equals("0")) {
                config.setParameter("format-pretty-print", Boolean.FALSE);
            }
            if (omit_xml_declaration.equals("yes")) {
                config.setParameter("xml-declaration", Boolean.FALSE);
            }
        }
        catch (Exception e3) {
            System.out.println("EXCEPTION in serializeDOMls when setting config: " + e3);
            return "";
        }
        try {
            String serializedXML = writer.writeToString(theDOMsource);
            return serializedXML;
        }
        catch (Exception e4) {
            System.out.println("EXCEPTION in serializeDOMls while serializing: " + e4);
            return "";
        }
    }

    public static String serializeDOM(Node theDOMsource1, String indent, String omit_xml_declaration) {
        Transformer serializer = null;
        String styleSheet = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">\n<xsl:output method=\"xml\" media-type=\"text/xml\" indent=\"yes\" />\n<xsl:output encoding=\"UTF-8\" />\n<xsl:template match=\"*|@*|comment()|processing-instruction()|text()\">\n<xsl:copy>\n<xsl:apply-templates select=\"*|@*|comment()|processing-instruction()|text()\" />\n</xsl:copy>\n</xsl:template>\n</xsl:stylesheet>\n";
        if (theDOMsource1 == null) {
            return "";
        }
        TransformerFactory tfactory = TransformerFactory.newInstance();
        StringReader reader = new StringReader(styleSheet);
        StreamSource src = new StreamSource(reader);
        try {
            serializer = tfactory.newTransformer(src);
        }
        catch (TransformerConfigurationException e) {
            return "";
        }
        Properties oprops = new Properties();
        if (indent != null) {
            oprops.setProperty("{http://xml.apache.org/xslt}indent-amount", indent);
        }
        if (omit_xml_declaration != null) {
            oprops.setProperty("omit-xml-declaration", omit_xml_declaration);
        }
        serializer.setOutputProperties(oprops);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        String XMLText = "";
        if (theDOMsource1 != null) {
            DOMSource domSource = new DOMSource();
            domSource.setNode(theDOMsource1);
            try {
                serializer.transform(domSource, result);
            }
            catch (TransformerException e) {
                return "";
            }
        }
        writer.flush();
        try {
            writer.close();
        }
        catch (IOException e) {
            return "";
        }
        return writer.toString();
    }

    public static NodeList parseStringToDom(String in, String which_elements) {
        if (in == null) {
            return null;
        }
        if (in.equals("")) {
            return null;
        }
        int length = in.length();
        if (length < 4) {
            return null;
        }
        char[] chars = new char[length];
        in.getChars(0, length, chars, 0);
        Document doc = null;
        DOMParser parser = new DOMParser();
        CharArrayReader newStream = new CharArrayReader(chars);
        InputSource source = new InputSource(newStream);
        try {
            parser.parse(source);
            doc = parser.getDocument();
        }
        catch (Exception e) {
            newStream.close();
            BatchXSLT.g_mainXSLTFrame.showMess("##### ERROR: Exception at 'parseStringToDom(String, String). See consol log.'");
            System.out.println("##### ERROR: Exception at 'parseStringToDom(String, String)'");
            System.out.println("##### Failing string:");
            System.out.println(in);
            System.out.println("##### END Failing string:");
            e.printStackTrace();
            return null;
        }
        NodeList nodes = doc.getElementsByTagName(which_elements);
        newStream.close();
        return nodes;
    }

    public static Element parseStringToDom(String in) {
        if (in == null) {
            return null;
        }
        if (in.equals("")) {
            return null;
        }
        int length = in.length();
        if (length < 4) {
            return null;
        }
        char[] chars = new char[length];
        in.getChars(0, length, chars, 0);
        Document doc = null;
        DOMParser parser = new DOMParser();
        CharArrayReader newStream = new CharArrayReader(chars);
        InputSource source = new InputSource(newStream);
        try {
            parser.parse(source);
            doc = parser.getDocument();
        }
        catch (Exception e) {
            newStream.close();
            BatchXSLT.g_mainXSLTFrame.showMess("##### ERROR: Exception at 'parseStringToDom(String). See consol log.'");
            System.out.println("##### ERROR: Exception at 'parseStringToDom(String)'");
            System.out.println("##### Failing string:");
            System.out.println(in);
            System.out.println("##### END Failing string:");
            e.printStackTrace();
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docparser = factory.newDocumentBuilder();
                Document newdoc = docparser.newDocument();
                Element rootElement = newdoc.createElement("parseStringToDomError");
                newdoc.appendChild(rootElement);
                return newdoc.getDocumentElement();
            }
            catch (Exception dbe) {
                System.out.println(dbe.getMessage());
                return null;
            }
        }
        newStream.close();
        return doc.getDocumentElement();
    }

    public static String decodeBase64(String in) {
        return new String(Base64.decode((String)in));
    }

    public static String convertStringFromUTF8toSystemNative(String theStringToConvert) {
        try {
            String stringToConvert = theStringToConvert;
            byte[] convertStringToByte = stringToConvert.getBytes("UTF-8");
            return new String(convertStringToByte, mainXSLTFrame.systemDefaultCharset);
        }
        catch (UnsupportedEncodingException e) {
            return theStringToConvert;
        }
    }

    public static String convertStringFromUTF8toUTF16LE(String theStringToConvert) {
        try {
            String stringToConvert = theStringToConvert;
            byte[] convertStringToByte = stringToConvert.getBytes("UTF-8");
            return new String(convertStringToByte, "UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            return theStringToConvert;
        }
    }

    public static String convertStringFromUTF16toSystemNative(String theStringToConvert) {
        try {
            String stringToConvert = theStringToConvert;
            byte[] convertStringToByte = stringToConvert.getBytes("UTF-16");
            return new String(convertStringToByte, mainXSLTFrame.systemDefaultCharset);
        }
        catch (UnsupportedEncodingException e) {
            return theStringToConvert;
        }
    }

    public static byte[] convertStringFromUNICODEtoOther(String theStringToConvert, String otherEnc) {
        try {
            byte[] barr = theStringToConvert.getBytes(otherEnc);
            return barr;
        }
        catch (UnsupportedEncodingException e) {
            return theStringToConvert.getBytes();
        }
    }

    public static int deleteLogFile(boolean doclear) {
        int retval;
        block6: {
            boolean deleted;
            lastFileExceptionMessage = "";
            lastFileExceptionError = 0;
            retval = 0;
            if (mainXSLTFrame.logfile_path.equals("") || mainXSLTFrame.logfile_name.equals("")) {
                return -1;
            }
            mainXSLTFrame.reset_StdOutErr();
            File logFile = new File(mainXSLTFrame.logfile_path + mainXSLTFrame.logfile_name);
            try {
                deleted = logFile.delete();
            }
            catch (Exception ex) {
                lastFileExceptionMessage = ex.getMessage();
                lastFileExceptionError = -2;
                if (doclear) {
                    utils.writeFile(mainXSLTFrame.logfile_path + mainXSLTFrame.logfile_name, "", true);
                }
                retval = -2;
                break block6;
            }
            if (!deleted) {
                lastFileExceptionMessage = "Log file could not be deleted at path: '" + mainXSLTFrame.logfile_path + mainXSLTFrame.logfile_name + "'. Cleared content instead.";
                lastFileExceptionError = -1;
                if (doclear) {
                    utils.writeFile(mainXSLTFrame.logfile_path + mainXSLTFrame.logfile_name, "", true);
                }
                retval = -1;
            }
        }
        mainXSLTFrame.redirect_StdOutErr_toLog();
        return retval;
    }

    public static boolean deleteDirectory(File path) {
        if (path == null) {
            return false;
        }
        boolean deleted = true;
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    utils.deleteDirectory(files[i]);
                    continue;
                }
                try {
                    deleted = files[i].delete();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            return false;
        }
        deleted = path.delete();
        return deleted;
    }

    public static String file_absolutePath(String the_pathname) {
        return utils.file_absolutePath(the_pathname, false);
    }

    public static String file_absolutePath(String the_pathname, boolean makeLocalFS) {
        File anyFile = new File(the_pathname);
        String path = anyFile.getAbsolutePath();
        if (makeLocalFS) {
            // empty if block
        }
        return path;
    }

    public static String file_fullPath(String theBasePath, String thePath) {
        if (theBasePath.equals("")) {
            return thePath;
        }
        if (thePath.indexOf(File.separator) == 0) {
            return thePath;
        }
        if (thePath.indexOf("file:") == 0) {
            return thePath;
        }
        if (thePath.indexOf(":") == 1) {
            return thePath;
        }
        if (thePath.indexOf("\\") == 0) {
            return thePath;
        }
        Object fullpath = theBasePath;
        if (!((String)fullpath).endsWith(File.separator) && thePath.indexOf(File.separator) != 0) {
            fullpath = (String)fullpath + File.separator;
        }
        fullpath = (String)fullpath + thePath;
        return fullpath;
    }

    public static boolean deleteFile(String pathname) {
        File f = new File(pathname);
        if (f.exists()) {
            try {
                f.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public static boolean existsFile(String pathname) {
        File f = new File(pathname);
        return f.exists();
    }

    public static long fileSize(String pathname) {
        File f = new File(pathname);
        return f.length();
    }

    public static String fileSizeS(String pathname) {
        long size = utils.fileSize(pathname);
        return "" + size;
    }

    public static String findFileInEnvirPath(String envirpathstrings, String filename, String skip_path) {
        return utils.findFileInEnvirPath(envirpathstrings, filename, skip_path, "");
    }

    public static String findFileInEnvirPath(String envirpathstrings, String filename, String skip_path, String must_path) {
        String[] envirpath = null;
        envirpath = envirpathstrings.split(File.pathSeparator);
        for (int i = 0; i < envirpath.length; ++i) {
            File f;
            if (!skip_path.equals("") && envirpath[i].toLowerCase().indexOf(skip_path) >= 0 || !must_path.equals("") && envirpath[i].toLowerCase().indexOf(must_path) < 0) continue;
            if (!envirpath[i].endsWith(File.separator)) {
                int n = i;
                envirpath[n] = envirpath[n] + File.separator;
            }
            if (!(f = new File(envirpath[i] + filename)).exists()) continue;
            return envirpath[i];
        }
        return "";
    }

    public static int writeFile(String pathname, String content, int overwrite) {
        boolean dooverwrite = true;
        if (overwrite <= 0) {
            dooverwrite = false;
        }
        return utils.writeFile(pathname, content, dooverwrite, false, "UTF8");
    }

    public static int writeFile(String pathname, String content, boolean overwrite) {
        return utils.writeFile(pathname, content, overwrite, false, "UTF8");
    }

    public static int writeFile(String pathname, String content, boolean overwrite, boolean append, String encoding) {
        BufferedWriter bw = null;
        OutputStreamWriter fwr = null;
        if (pathname.equals("")) {
            return -2;
        }
        File f = new File(pathname);
        String thepath = f.getParent();
        if (thepath != null) {
            File apath = new File(thepath);
            boolean bl = apath.mkdirs();
        }
        if (!overwrite && f.exists()) {
            return 0;
        }
        if (encoding.equals("") || encoding.equals("BINARY")) {
            try {
                fwr = new FileWriter(f, append);
                fwr.write(content);
                fwr.flush();
                fwr.close();
            }
            catch (IOException e) {
                try {
                    fwr.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    fwr.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return -1;
            }
        }
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f, append), "UTF8"));
            bw.write(content, 0, content.length());
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            try {
                bw.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                bw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return -1;
        }
        return 0;
    }

    public static byte[] readFile(String pathname) {
        byte[] bytes = null;
        try {
            File file = new File(pathname);
            FileInputStream insputStream = new FileInputStream(file);
            long length = file.length();
            bytes = new byte[(int)length];
            ((InputStream)insputStream).read(bytes);
            ((InputStream)insputStream).close();
        }
        catch (Exception e) {
            System.out.println("Error is:" + e.getMessage());
            return null;
        }
        return bytes;
    }

    public static String readFileUTF(String pathname) {
        lastFileExceptionMessage = "";
        lastFileExceptionError = 0;
        if (pathname == null || pathname.equals("")) {
            lastFileExceptionMessage = "Path/Name not given.";
            lastFileExceptionError = -1;
            return "";
        }
        FileInputStream fis = null;
        InputStreamReader isr = null;
        char[] cbuf = null;
        String data = "";
        int input_bytes_avail = -1;
        int bytes_read = -1;
        boolean ofs = false;
        try {
            fis = new FileInputStream(pathname);
        }
        catch (FileNotFoundException fnfe) {
            lastFileExceptionMessage = fnfe.getMessage();
            lastFileExceptionError = -2;
            return "";
        }
        try {
            isr = new InputStreamReader((InputStream)fis, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            lastFileExceptionMessage = e.getMessage();
            lastFileExceptionError = -3;
            return "";
        }
        try {
            input_bytes_avail = fis.available();
        }
        catch (IOException e) {
            try {
                fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                isr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            lastFileExceptionMessage = e.getMessage();
            lastFileExceptionError = -4;
            return "";
        }
        cbuf = new char[input_bytes_avail];
        try {
            bytes_read = isr.read(cbuf, 0, input_bytes_avail);
            if (bytes_read > 0) {
                data = new String(cbuf, 0, bytes_read);
            }
        }
        catch (IOException e) {
            try {
                fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                isr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            lastFileExceptionMessage = e.getMessage();
            lastFileExceptionError = -5;
            return "";
        }
        try {
            fis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            isr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return data;
    }

    public static boolean copyFolderPath2(String srcpath, String srcname, String targpath, String targname, int recursive, int onlyNew, String errormessage) {
        boolean retflag = utils.copyFolderPath(srcpath, srcname, targpath, targname, recursive > 0, onlyNew > 0, errormessage);
        return retflag;
    }

    public static boolean copyFolderPath(String srcpath, String srcname, String targpath, String targname, boolean recursive, boolean onlyNew, String errormessage) {
        File sf;
        if (srcpath == null || srcpath.equals("")) {
            return false;
        }
        Object src = srcpath;
        if (!((String)src).endsWith(File.separator)) {
            src = (String)src + File.separator;
        }
        if (srcname != null && !srcname.equals("")) {
            src = (String)src + srcname;
        }
        if (!(sf = new File((String)(src = utils.resolveRelativePath((String)src)))).exists()) {
            return false;
        }
        Object targ = "";
        targ = targpath == null || targpath.equals("") ? srcpath : targpath;
        if (targname != null && !targname.equals("")) {
            if (!((String)targ).endsWith(File.separator)) {
                targ = (String)targ + File.separator;
            }
            targ = (String)targ + targname;
        } else if (srcname != null && !srcname.equals("")) {
            if (!((String)targ).endsWith(File.separator)) {
                targ = (String)targ + File.separator;
            }
            targ = (String)targ + srcname;
        }
        targ = utils.resolveRelativePath((String)targ);
        if (((String)targ).equals(src)) {
            return false;
        }
        File tf = new File((String)targ);
        try {
            utils.copyFolder(sf, tf, recursive, onlyNew);
        }
        catch (Exception e) {
            if (!errormessage.equals("")) {
                BatchXSLT.g_mainXSLTFrame.showMess(errormessage + e.getMessage() + "'\n");
            }
            return false;
        }
        return true;
    }

    public static void copyFolder(File src, File dest, boolean recursive, boolean onlyNew) throws IOException {
        boolean copied = true;
        if (!src.isDirectory()) {
            throw new IOException("com.epaperarchives.batchxslt.utils not a folder: " + src);
        }
        if (dest.isFile()) {
            throw new IOException("com.epaperarchives.batchxslt.utils is a file: " + dest);
        }
        if (!dest.exists() && !dest.mkdirs()) {
            throw new IOException("com.epaperarchives.batchxslt.utils can not make folder: " + dest);
        }
        File[] srcFiles = src.listFiles();
        for (int i = 0; i < srcFiles.length; ++i) {
            File file = srcFiles[i];
            if (file.isDirectory()) {
                if (!recursive) continue;
                utils.copyFolder(file, new File(dest, file.getName()), recursive, onlyNew);
                continue;
            }
            File destFile = new File(dest, file.getName());
            if (onlyNew && destFile.isFile() && destFile.lastModified() > file.lastModified()) continue;
            utils.copyFile(file, destFile);
        }
        dest.setLastModified(src.lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest) throws IOException {
        if (!src.isFile()) {
            throw new IOException("com.epaperarchives.batchxslt.utils not a file: " + src);
        }
        if (dest.isDirectory()) {
            throw new IOException("com.epaperarchives.batchxslt.utilsis Folder: " + dest);
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest, false));){
            utils.copyStream(in, out, 4096);
        }
        dest.setLastModified(src.lastModified());
    }

    public static void copyStream(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int len;
        byte[] buf = new byte[bufferSize];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
    }

    public static void copyFolder(String srcpath, String destpath, boolean recursive, boolean deletesource) throws IOException {
        File src = new File(srcpath);
        if (!src.exists()) {
            throw new IOException("com.epaperarchives.batchxslt.utils not found: " + srcpath);
        }
        boolean f_deleted = false;
        if (src.isDirectory()) {
            File[] srcFiles = src.listFiles();
            for (int i = 0; i < srcFiles.length; ++i) {
                if (mainXSLTFrame.general_abort) {
                    return;
                }
                File file = srcFiles[i];
                Object path = file.getParent();
                if (!((String)path).endsWith(File.separator)) {
                    path = (String)path + File.separator;
                }
                String pathname = (String)path + file.getName();
                if (file.getName().equals(".DS_Store")) {
                    f_deleted = BatchXSLTransform.file_delete(pathname);
                    continue;
                }
                if (file.isDirectory()) {
                    if (!recursive) continue;
                    utils.copyFolder(pathname, destpath + file.getName() + File.separator, recursive, deletesource);
                    File[] flist = file.listFiles();
                    if (flist.length > 0 || !deletesource) continue;
                    f_deleted = BatchXSLTransform.file_delete(pathname);
                    continue;
                }
                int copied = BatchXSLTransform.copyFile((String)path, file.getName(), destpath, "", 1, true, false);
                if (!deletesource) continue;
                f_deleted = BatchXSLTransform.file_delete(pathname);
            }
        } else {
            Object path = src.getParent();
            if (!((String)path).endsWith(File.separator)) {
                path = (String)path + File.separator;
            }
            String pathname = (String)path + src.getName();
            if (src.getName().equals(".DS_Store")) {
                f_deleted = BatchXSLTransform.file_delete(pathname);
                return;
            }
            int copied = BatchXSLTransform.copyFile((String)path, src.getName(), destpath, "", 1, true, false);
            if (deletesource) {
                f_deleted = BatchXSLTransform.file_delete(pathname);
            }
        }
    }

    public static void copyMultipleFiles(File[] files, String destpath, boolean recursive, boolean deletesource) throws IOException {
        for (int idx = 0; idx < files.length; ++idx) {
            if (mainXSLTFrame.general_abort) break;
            if (files[idx].isDirectory()) {
                Object my_PathName = files[idx].getPath() != null ? files[idx].getPath() : "";
                my_PathName = (String)my_PathName + File.separator;
                Object my_outputPathName = destpath;
                if (!((String)my_outputPathName).endsWith("/")) {
                    my_outputPathName = (String)my_outputPathName + "/";
                }
                my_outputPathName = (String)my_outputPathName + files[idx].getName() + "/";
                try {
                    utils.copyFolder((String)my_PathName, (String)my_outputPathName, true, false);
                }
                catch (Exception exception) {}
            } else {
                Object my_Path;
                Object object = my_Path = files[idx].getParent() != null ? files[idx].getParent() : "";
                if (!((String)my_Path).endsWith(File.separator)) {
                    my_Path = (String)my_Path + File.separator;
                }
                String my_Name = files[idx].getName() != null ? files[idx].getName() : "";
                int n = BatchXSLTransform.copyFile((String)my_Path, my_Name, destpath, "", 1, true, false);
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        BatchXSLTransform.copyFile_disconnect();
    }

    public static String resolveRelativePath(String path) {
        if (path == null || path.equals("")) {
            return "";
        }
        String relsep = ".." + File.separator;
        int pos = path.indexOf(relsep);
        if (pos < 0) {
            return path;
        }
        Object resolvedpath = path;
        while (pos >= 0) {
            String part1 = ((String)resolvedpath).substring(0, ((String)resolvedpath).indexOf(relsep));
            if (part1.endsWith(File.separator)) {
                part1 = part1.substring(0, part1.length() - 1);
            }
            part1 = part1.substring(0, part1.lastIndexOf(File.separator));
            String part2 = ((String)resolvedpath).substring(pos + relsep.length());
            resolvedpath = part1 + File.separator + part2;
            pos = ((String)resolvedpath).indexOf(relsep);
        }
        return resolvedpath;
    }

    public static int copyFile(String the_sourcepath, String the_sourcename, String the_targetpath, String the_targetname, int create_target_path, boolean give_message) {
        int copied = BatchXSLTransform.copyFile(the_sourcepath, the_sourcename, the_targetpath, the_targetname, create_target_path, give_message);
        return copied;
    }

    public static String detectMimeType(String path) {
        if (path == null || path.equals("")) {
            return "";
        }
        if (path.endsWith(File.separator)) {
            return "";
        }
        String lc_path = path.toLowerCase();
        if (path.indexOf(".") >= 0) {
            if (lc_path.endsWith(".tif") || lc_path.endsWith(".tiff")) {
                return "image/tiff";
            }
            if (lc_path.endsWith(".jpg") || lc_path.endsWith(".jpeg")) {
                return "image/jpeg";
            }
            if (lc_path.endsWith(".gif")) {
                return "image/gif";
            }
            if (lc_path.endsWith(".png")) {
                return "image/png";
            }
            if (lc_path.endsWith(".eps")) {
                return "image/eps";
            }
            if (lc_path.endsWith(".ps")) {
                return "application/postscript";
            }
            if (lc_path.endsWith(".psd")) {
                return "image/vnd.adobe.photoshop";
            }
            if (lc_path.endsWith(".ai")) {
                return "application/postscript";
            }
            if (lc_path.endsWith(".bmp")) {
                return "image/bmp";
            }
            if (lc_path.endsWith(".wbmp")) {
                return "image/vnd.wap.wbmp";
            }
            if (lc_path.endsWith(".webp")) {
                return "image/webp";
            }
            if (lc_path.endsWith(".svg")) {
                return "image/svg+xml";
            }
            if (lc_path.endsWith(".ico")) {
                return "image/x-icon";
            }
            if (lc_path.endsWith(".wav")) {
                return "audio/wav";
            }
            if (lc_path.endsWith(".weba")) {
                return "audio/webm";
            }
            if (lc_path.endsWith(".webm")) {
                return "audio/webm";
            }
            if (lc_path.endsWith(".oga")) {
                return "audio/ogg";
            }
            if (lc_path.endsWith(".3gp")) {
                return "video/3gpp";
            }
            if (lc_path.endsWith(".3g2")) {
                return "video/3gpp2";
            }
            if (lc_path.endsWith(".ogv")) {
                return "video/ogg";
            }
            if (lc_path.endsWith(".mpeg")) {
                return "video/mpeg";
            }
            if (lc_path.endsWith(".html") || lc_path.endsWith(".htm")) {
                return "text/html";
            }
            if (lc_path.endsWith(".txt")) {
                return "text/plain";
            }
            if (lc_path.endsWith(".xml")) {
                return "text/xml";
            }
            if (lc_path.endsWith(".xsl")) {
                return "text/xml";
            }
            if (lc_path.endsWith(".xhtml") || lc_path.endsWith(".xhtm")) {
                return "application/xhtml+xml";
            }
            if (lc_path.endsWith(".xls")) {
                return "application/vnd.ms-excel";
            }
            if (lc_path.endsWith(".js")) {
                return "application/javascript";
            }
            if (lc_path.endsWith(".rar")) {
                return "application/x-rar-compressed";
            }
            if (lc_path.endsWith(".sit")) {
                return "application/x-sit";
            }
            if (lc_path.endsWith(".sitx")) {
                return "application/x-sit";
            }
            if (lc_path.endsWith(".sea")) {
                return "application/sea";
            }
            if (lc_path.endsWith(".zip")) {
                return "application/zip";
            }
            if (lc_path.endsWith(".7z")) {
                return "application/x-7z-compressed";
            }
            if (lc_path.endsWith(".epub")) {
                return "application/epub+zip";
            }
            if (lc_path.endsWith(".eot")) {
                return "application/vnd.ms-fontobject";
            }
            if (lc_path.endsWith(".woff")) {
                return "font/woff";
            }
            if (lc_path.endsWith(".woff2")) {
                return "font/woff2";
            }
            if (lc_path.endsWith(".ttf")) {
                return "font/ttf";
            }
        }
        return "application/octet-stream";
    }

    public static String detectFileType(String path) {
        FileInputStream mystream;
        String detectedType;
        block56: {
            if (path == null || path.equals("")) {
                return "";
            }
            detectedType = "";
            if (path.endsWith(File.separator)) {
                return "";
            }
            String lc_path = path.toLowerCase();
            if (path.indexOf(".") >= 0) {
                if (lc_path.endsWith(".tif") || lc_path.endsWith(".tiff")) {
                    return "tif";
                }
                if (lc_path.endsWith(".jpg") || lc_path.endsWith(".jpeg")) {
                    return "jpg";
                }
                if (lc_path.endsWith(".gif")) {
                    return "gif";
                }
                if (lc_path.endsWith(".png")) {
                    return "png";
                }
                if (lc_path.endsWith(".eps")) {
                    return "eps";
                }
                if (lc_path.endsWith(".ps")) {
                    return "ps";
                }
                if (lc_path.endsWith(".psd")) {
                    return "psd";
                }
                if (lc_path.endsWith(".ai")) {
                    return "psd";
                }
                if (lc_path.endsWith(".bmp")) {
                    return "bmp";
                }
                if (lc_path.endsWith(".xml")) {
                    return "xml";
                }
                if (lc_path.endsWith(".xsl")) {
                    return "xsl";
                }
                if (lc_path.endsWith(".qxd")) {
                    return "qxd";
                }
                if (lc_path.endsWith(".indd")) {
                    return "indd";
                }
                if (lc_path.endsWith(".html") || lc_path.endsWith(".htm")) {
                    return "htm";
                }
                if (lc_path.endsWith(".xhtml") || lc_path.endsWith(".xhtm")) {
                    return "xhtm";
                }
                if (lc_path.endsWith(".txt")) {
                    return "txt";
                }
                if (lc_path.endsWith(".sit")) {
                    return "sit";
                }
                if (lc_path.endsWith(".sitx")) {
                    return "sitx";
                }
                if (lc_path.endsWith(".sea")) {
                    return "sea";
                }
                if (lc_path.endsWith(".zip")) {
                    return "zip";
                }
                if (lc_path.endsWith(".7z")) {
                    return "7z";
                }
                if (lc_path.endsWith(".idml")) {
                    return "idml";
                }
                if (lc_path.endsWith(".epub")) {
                    return "epub";
                }
            }
            mystream = null;
            try {
                mystream = new FileInputStream(path);
            }
            catch (FileNotFoundException e) {
                return detectedType;
            }
            try {
                int numbytes = mystream.available();
                if (numbytes > 3) break block56;
                try {
                    mystream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return detectedType;
            }
            catch (IOException e) {
                try {
                    mystream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return detectedType;
            }
        }
        int buffersize = 1000;
        byte[] mybuf = new byte[buffersize];
        try {
            mystream.read(mybuf, 0, buffersize);
        }
        catch (IOException e) {
            try {
                mystream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return detectedType;
        }
        try {
            mystream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        int scanLength = 50;
        for (int i = 0; i < scanLength; ++i) {
            if (mybuf[i] == 77 && mybuf[i + 1] == 77 && mybuf[i + 2] == 0 && mybuf[i + 3] == 42) {
                detectedType = "tif";
                break;
            }
            if (mybuf[i] == 73 && mybuf[i + 1] == 73 && mybuf[i + 2] == 42) {
                detectedType = "tif";
                break;
            }
            if (mybuf[i] == 37 && mybuf[i + 1] == 33 && mybuf[i + 2] == 80 && mybuf[i + 3] == 83) {
                detectedType = "eps";
                break;
            }
            if (mybuf[i] == 37 && mybuf[i + 1] == 69 && mybuf[i + 2] == 80 && mybuf[i + 3] == 83) {
                detectedType = "eps";
                break;
            }
            if (mybuf[i] == 37 && mybuf[i + 1] == 80 && mybuf[i + 2] == 68 && mybuf[i + 3] == 70) {
                detectedType = "pdf";
                break;
            }
            if (mybuf[i] == 56 && mybuf[i + 1] == 66 && mybuf[i + 2] == 80 && mybuf[i + 3] == 83) {
                detectedType = "psd";
                break;
            }
            if (mybuf[i] == 137 && mybuf[i + 1] == 80 && mybuf[i + 2] == 78 && mybuf[i + 3] == 71) {
                detectedType = "png";
                break;
            }
            if (i == 0 && mybuf[i] == 255 && mybuf[i + 1] == 216 && mybuf[i + 2] == 255) {
                detectedType = "jpg";
                break;
            }
            if (i == 6 && mybuf[i] == 74 && mybuf[i + 1] == 70 && mybuf[i + 2] == 73 && mybuf[i + 3] == 70) {
                detectedType = "jpg";
                break;
            }
            if (i == 0 && mybuf[i] == 71 && mybuf[i + 1] == 73 && mybuf[i + 2] == 70 && mybuf[i + 3] == 56) {
                detectedType = "gif";
                break;
            }
            if (i == 0 && mybuf[i] == 66 && mybuf[i + 1] == 77 && mybuf[i + 2] == 72) {
                detectedType = "bmp";
                break;
            }
            if (i == 0 && mybuf[i] == 0 && mybuf[i + 1] == 0 && mybuf[i + 2] == 77 && mybuf[i + 3] == 77 && mybuf[i + 4] == 88 && mybuf[i + 5] == 80 && mybuf[i + 6] == 82 && mybuf[i + 7] == 51) {
                detectedType = "qxd";
                break;
            }
            if (i == 0 && mybuf[i] == 6 && mybuf[i + 1] == 6 && mybuf[i + 2] == 237 && mybuf[i + 3] == 245 && mybuf[i + 4] == 216) {
                detectedType = "indd";
                break;
            }
            if (mybuf[i] == 60 && mybuf[i + 1] == 63 && mybuf[i + 2] == 120 && mybuf[i + 3] == 109 && mybuf[i + 4] == 108) {
                detectedType = "xml";
                break;
            }
            if (i == 0 && mybuf[i] == 83 && mybuf[i + 1] == 116 && mybuf[i + 2] == 117 && mybuf[i + 3] == 102 && mybuf[i + 4] == 102) {
                detectedType = "sit";
                break;
            }
            if (i != 0 || mybuf[i] != 80 || mybuf[i + 1] != 75 || mybuf[i + 2] != 3 || mybuf[i + 3] != 4) continue;
            detectedType = "zip";
            break;
        }
        return detectedType;
    }

    public static int detectFileContent(String path, String searchstring, int checksize) {
        FileInputStream mystream;
        byte[] searchbytes;
        int buffersize;
        int bytesread;
        int filesize;
        block25: {
            if (path == null || path.equals("")) {
                return -1;
            }
            if (searchstring == null || searchstring.equals("")) {
                return -1;
            }
            int pos = -1;
            filesize = 0;
            bytesread = 0;
            buffersize = checksize;
            searchbytes = null;
            mystream = null;
            try {
                mystream = new FileInputStream(path);
            }
            catch (FileNotFoundException e) {
                return -1;
            }
            try {
                filesize = mystream.available();
                if (filesize > 0) break block25;
                try {
                    mystream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                return -1;
            }
            catch (IOException e) {
                try {
                    mystream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return -1;
            }
        }
        if (filesize < searchstring.length()) {
            try {
                mystream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return -1;
        }
        if (checksize <= 0) {
            buffersize = filesize;
        }
        byte[] mybuf = new byte[buffersize];
        try {
            bytesread = mystream.read(mybuf, 0, buffersize);
        }
        catch (IOException e) {
            try {
                mystream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return -1;
        }
        try {
            mystream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (bytesread < 0) {
            return -1;
        }
        searchbytes = searchstring.getBytes();
        int foundpos = -1;
        for (int i = 0; i < bytesread - searchbytes.length; ++i) {
            int k;
            for (k = 0; k < searchbytes.length; ++k) {
                try {
                    if (mybuf[i + k] == searchbytes[k]) continue;
                    break;
                }
                catch (Exception e) {
                    return -1;
                }
            }
            if (k < searchbytes.length) continue;
            foundpos = i;
            break;
        }
        return foundpos;
    }

    public static void directoryListInit() {
        directoryListIterator = null;
        directoryListRootPath = "";
    }

    public static boolean directoryListValid() {
        return directoryListIterator != null;
    }

    public static int directoryListCreate(String rootPath, String theExtensions, boolean doRecursive) {
        File rootdir;
        if (rootPath == null || rootPath.equals("")) {
            return -1;
        }
        Object therootPath = rootPath;
        if (((String)therootPath).startsWith("~")) {
            Object home = System.getProperty("user.home");
            if (!((String)home).endsWith(File.separator)) {
                home = (String)home + File.separator;
            }
            therootPath = (String)home + ((String)therootPath).substring(2);
        }
        if (!(rootdir = new File((String)therootPath)).exists()) {
            return -2;
        }
        if (!rootdir.isDirectory()) {
            return -3;
        }
        String[] extensions = null;
        if (theExtensions != null && !theExtensions.equals("")) {
            extensions = theExtensions.split(",");
        }
        try {
            directoryListIterator = FileUtils.iterateFiles((File)rootdir, extensions, (boolean)doRecursive);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (directoryListIterator != null) {
            directoryListRootPath = therootPath;
        }
        return directoryListIterator.hasNext() ? 1 : 0;
    }

    public static String directoryListGetFile() {
        if (directoryListIterator == null) {
            return "";
        }
        String filePathname = "";
        while (directoryListIterator.hasNext()) {
            File thefile = directoryListIterator.next();
            if (!thefile.exists() || thefile.isDirectory()) continue;
            filePathname = thefile.getAbsolutePath();
            break;
        }
        return filePathname;
    }

    public static String directoryListGetAsXMLString(boolean withXMLdeclaration) {
        String path;
        if (directoryListIterator == null) {
            return "<!-- EMPTY list -->";
        }
        String CR = "\n";
        if (BatchXSLTransform.isWindows()) {
            CR = "\r\n";
        }
        Object listXML = "";
        if (withXMLdeclaration) {
            listXML = (String)listXML + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + CR + "<!DOCTYPE folderList>" + CR;
        }
        listXML = (String)listXML + "<folderList>" + CR;
        listXML = (String)listXML + "<rootPath>" + directoryListRootPath + "</rootPath>" + CR;
        while (!(path = utils.directoryListGetFile()).equals("")) {
            listXML = (String)listXML + "<file>" + path + "</file>" + CR;
        }
        listXML = (String)listXML + "</folderList>" + CR;
        return listXML;
    }

    public static String directoryListWriteXMLFile(String xmlFilePathName, boolean withXMLdeclaration) {
        if (xmlFilePathName == null || xmlFilePathName.equals("")) {
            return "";
        }
        String xmlstr = utils.directoryListGetAsXMLString(withXMLdeclaration);
        int written = utils.writeFile(xmlFilePathName, xmlstr, true, false, "UTF-8");
        if (written == 0) {
            return xmlFilePathName;
        }
        return "";
    }

    public static int setLogFile(String dowrite, String path, String name, String maxsize, String maxlogfiles) {
        if (dowrite != null) {
            mainXSLTFrame.logfile_write = Integer.valueOf(dowrite);
        }
        if (path != null) {
            mainXSLTFrame.logfile_path = path;
        }
        if (name != null) {
            mainXSLTFrame.logfile_name = name;
        }
        if (maxsize != null) {
            mainXSLTFrame.logfile_maxsize = Integer.valueOf(maxsize);
            if (mainXSLTFrame.logfile_maxsize < mainXSLTFrame.logfile_minsize) {
                mainXSLTFrame.logfile_maxsize = mainXSLTFrame.logfile_minsize;
            }
        }
        if (maxlogfiles != null) {
            mainXSLTFrame.logfile_max = Integer.valueOf(maxlogfiles);
            if (mainXSLTFrame.logfile_max < mainXSLTFrame.logfile_min) {
                mainXSLTFrame.logfile_max = mainXSLTFrame.logfile_min;
            }
        }
        return 0;
    }

    public static int setLogFile(String dowrite, String path, String name, String maxsize) {
        return utils.setLogFile(dowrite, path, name, maxsize, null);
    }

    public static int setLogFile(String dowrite, String path, String name) {
        return utils.setLogFile(dowrite, path, name, null, null);
    }

    public static void sendMail(String mailHost, String from, String to, String subject, String body) {
        block6: {
            boolean debug = true;
            try {
                if (debug) {
                    System.out.println("mail.host: " + System.getProperty("mail.host"));
                }
                if (mailHost != null && !mailHost.equals("")) {
                    System.getProperties().put("mail.host", mailHost);
                }
                Properties props = new Properties();
                props.put("mail.smtp.host", "localhost");
                URL u = new URL("mailto:" + to);
                URLConnection c = u.openConnection();
                c.setAllowUserInteraction(false);
                c.setDoInput(false);
                c.setDoOutput(true);
                c.setConnectTimeout(1000);
                if (debug) {
                    System.out.println("Connecting...");
                    System.out.flush();
                }
                c.connect();
                BufferedWriter bwr = new BufferedWriter(new OutputStreamWriter(c.getOutputStream()));
                bwr.write("From: \"" + from + "\" <" + System.getProperty("user.name") + "@" + InetAddress.getLocalHost().getHostName() + ">\n");
                bwr.write("To: " + to + "\n");
                bwr.write("Subject: " + subject + "\n");
                bwr.write("\n");
                bwr.write(body);
                bwr.flush();
                bwr.close();
                if (debug) {
                    System.out.println("Message sent.");
                    System.out.flush();
                }
            }
            catch (Exception e) {
                if (!debug) break block6;
                System.out.println("ERROR sending mail:");
                System.out.println(e);
            }
        }
    }

    public static String checkAvailableExtConverter(int whichConverter) {
        if (whichConverter <= 0) {
            return "";
        }
        String version_str = "";
        if ((whichConverter & 1) > 0) {
            version_str = BatchXSLTGhostScript.get_GS_version();
            return version_str;
        }
        if ((whichConverter & 2) > 0) {
            version_str = BatchXSLTGhostScript.get_pstotext_version();
            return version_str;
        }
        if ((whichConverter & 4) > 0) {
            version_str = BatchXSLTImageMagick.get_IMconvert_version();
            return version_str;
        }
        return "";
    }

    public static String getGhostScriptVersion() {
        return mainXSLTFrame.gs_version_str;
    }

    public static String getPsToTextVersion() {
        return mainXSLTFrame.pstotext_version_str;
    }

    public static String getImageMagickVersion() {
        return mainXSLTFrame.im_version_str;
    }

    public static String getImageMagickVersionNum() {
        return mainXSLTFrame.im_version_num;
    }

    public static int resize_jpeg(String sourcefileName, String targetfileName, double scale, float quality, int antialias, int numresizeruns) {
        return utils.resize_jpeg(sourcefileName, targetfileName, scale, quality, antialias, numresizeruns, 0, 0, 0);
    }

    public static int resize_jpeg(String sourcefileName, String targetfileName, double scale, float quality, int antialias, int numresizeruns, int dpi, int exif_imgWidth, int exif_imgHeight) {
        JpgImage ji = null;
        if (sourcefileName == null || sourcefileName.equals("")) {
            return -1;
        }
        if (targetfileName == null || targetfileName.equals("")) {
            return -2;
        }
        try {
            ji = new JpgImage(sourcefileName);
        }
        catch (Exception e) {
            return -3;
        }
        ji.scalePercent(scale, antialias, numresizeruns, null);
        float myquality = quality;
        if (myquality > 1.0f) {
            myquality /= 100.0f;
        }
        try {
            ji.sendToFile(targetfileName, myquality, dpi, exif_imgWidth, exif_imgHeight);
        }
        catch (IOException ioe) {
            return -4;
        }
        return 0;
    }

    public static int resize_jpeg_maxwidth(String sourcefileName, String targetfileName, int maxwidth, float quality, int antialias, int numresizeruns, int dpi) {
        float myquality;
        JpgImage ji;
        if (sourcefileName == null || sourcefileName.equals("")) {
            return -1;
        }
        if (targetfileName == null || targetfileName.equals("")) {
            return -2;
        }
        try {
            ji = new JpgImage(sourcefileName);
        }
        catch (Exception e) {
            return -3;
        }
        int currentWidth = ji.getWidth();
        if (currentWidth > maxwidth) {
            double scale = (double)maxwidth / (double)currentWidth;
            ji.scalePercent(scale, antialias, numresizeruns, null);
        }
        if ((myquality = quality) > 1.0f) {
            myquality /= 100.0f;
        }
        try {
            ji.sendToFile(targetfileName, myquality, dpi);
        }
        catch (IOException ioe) {
            return -4;
        }
        return 0;
    }

    public static String PDFtextExtract(String sourcePDFpath) {
        if (sourcePDFpath == null || sourcePDFpath.equals("")) {
            return "";
        }
        return utils.PDFtextExtract(sourcePDFpath, 1, Integer.MAX_VALUE, 0, "UTF-8", "", 0);
    }

    public static String PDFtextExtract(String sourcePDFpath, int verbose) {
        if (sourcePDFpath == null || sourcePDFpath.equals("")) {
            return "";
        }
        return utils.PDFtextExtract(sourcePDFpath, 1, Integer.MAX_VALUE, 0, "UTF-8", "", verbose);
    }

    public static String PDFtextExtract(String sourcePDFpath, int startPage, int endPage, int sort, String encoding, String password, int verbose) {
        PDDocument document;
        String pdftext;
        block16: {
            if (verbose > 0) {
                System.out.println("**** PDFtextExtract");
                System.out.println("     sourcePDFpath: " + sourcePDFpath);
                System.out.println("     startPage: " + startPage);
                System.out.println("     endPage: " + endPage);
                System.out.println("     sort: " + sort);
                System.out.println("     encoding: " + encoding);
                System.out.println("     password: " + password);
                System.out.println("     verbose: " + verbose);
            }
            if (sourcePDFpath == null || sourcePDFpath.equals("")) {
                return "";
            }
            pdftext = "";
            int mystartPage = 1;
            int myendPage = Integer.MAX_VALUE;
            if (startPage > 0) {
                mystartPage = startPage;
            }
            if (endPage > 0) {
                myendPage = endPage;
            }
            document = null;
            try {
                try {
                    URL url = new URL(sourcePDFpath);
                    document = PDDocument.load((URL)url);
                    String string = url.getFile();
                }
                catch (MalformedURLException e) {
                    document = PDDocument.load((String)sourcePDFpath);
                }
                if (document.isEncrypted()) {
                    StandardDecryptionMaterial sdm = new StandardDecryptionMaterial(password);
                    document.openProtection((DecryptionMaterial)sdm);
                    AccessPermission ap = document.getCurrentAccessPermission();
                    if (!ap.canExtractContent()) {
                        throw new IOException("No permission to extract text from PDF file: " + sourcePDFpath);
                    }
                }
                PDFTextStripper stripper = new PDFTextStripper();
                if (sort > 0) {
                    stripper.setSortByPosition(true);
                } else {
                    stripper.setSortByPosition(false);
                }
                stripper.setStartPage(startPage);
                stripper.setEndPage(endPage);
                pdftext = stripper.getText(document);
                if (verbose > 0) {
                    System.out.println("**** Text: " + pdftext);
                }
            }
            catch (Exception e) {
                if (verbose <= 0) break block16;
                System.out.println("#### Exception: " + e);
            }
        }
        try {
            if (document != null) {
                document.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pdftext;
    }

    public static String getPDFmergeError() {
        return PDFmergeError;
    }

    public static int PDFmerge(String args) {
        String[] argsarr = args.split(",");
        return utils.PDFmerge(argsarr);
    }

    public static int PDFmerge(String[] args) {
        PDFmergeError = "";
        String destinationFileName = "";
        String sourceFileName = null;
        if (args.length < 3) {
            PDFmergeError = "#ERROR# PDFmerge: not enough arguments. Usage: PDFMerger(String[]) - 2 docs to merge, last ist destination pdf name";
            return -1;
        }
        PDFMergerUtility merger = new PDFMergerUtility();
        for (int i = 0; i < args.length - 1; ++i) {
            sourceFileName = args[i];
            merger.addSource(sourceFileName);
        }
        destinationFileName = args[args.length - 1];
        merger.setDestinationFileName(destinationFileName);
        try {
            merger.mergeDocuments();
        }
        catch (Exception ex) {
            PDFmergeError = ex.getMessage();
            return -2;
        }
        return 0;
    }

    public static String cleanXMLstring(String inputString) {
        if (inputString == null || inputString.equals("")) {
            return "";
        }
        StringBuilder sb = new StringBuilder(inputString);
        char[] chars2remove = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\u000b', '\f', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f'};
        for (int s = 0; s < sb.length(); ++s) {
            for (int cr = 0; cr < chars2remove.length; ++cr) {
                if (sb.charAt(s) == chars2remove[cr]) {
                    sb.setCharAt(s, ' ');
                    continue;
                }
                if (sb.charAt(s) == '<') {
                    if (sb.capacity() < sb.length() + 3) {
                        sb.ensureCapacity(sb.capacity() + 50);
                    }
                    sb.replace(s, s + 1, "&lt;");
                    s += 4;
                    continue;
                }
                if (sb.charAt(s) == '>') {
                    if (sb.capacity() < sb.length() + 3) {
                        sb.ensureCapacity(sb.capacity() + 50);
                    }
                    sb.replace(s, s + 1, "&gt;");
                    s += 4;
                    continue;
                }
                if (sb.charAt(s) != '&') continue;
                if (sb.capacity() < sb.length() + 4) {
                    sb.ensureCapacity(sb.capacity() + 50);
                }
                sb.replace(s, s + 1, "&amp;");
                s += 5;
            }
        }
        return sb.toString();
    }

    public static String getMetaExtractorError() {
        return metaExtractError;
    }

    public static String getMetaData() {
        return utils.getMetaData(true);
    }

    public static String getMetaData(boolean clean) {
        if (clean) {
            return utils.cleanXMLstring(metaExtractData);
        }
        return metaExtractData;
    }

    public static int extractMetaData(String args) {
        String[] argsarr = args.split(",");
        return utils.extractMetaData(argsarr);
    }

    public static int extractMetaData(String[] args) {
        metaExtractError = "";
        metaExtractData = "";
        String metaData = "";
        if (args == null || args.length < 1) {
            metaExtractError = "No path to input file given.";
            return -1;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        PrintStream old = System.out;
        System.setOut(ps);
        try {
            TikaCLI.main((String[])args);
        }
        catch (Exception ex) {
            metaExtractError = ex.getMessage();
            System.out.flush();
            System.setOut(old);
            return -2;
        }
        System.out.flush();
        System.setOut(old);
        try {
            metaExtractData = baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            metaExtractError = "Unsupported ecoding: UTF-8";
            return -3;
        }
        return 0;
    }

    public static String getNZIPexpandError() {
        return NZIPexpandError;
    }

    public static String nzip(String source, String theTarget) {
        return utils.nzip(source, theTarget, false);
    }

    public static String nzip(String source, String theTarget, Boolean showmessage) {
        NZIPexpandError = "";
        String target = theTarget;
        if (showmessage.booleanValue()) {
            BatchXSLT.g_mainXSLTFrame.showMess("*** nzip: '" + source + "' to '" + target + "'\n");
        }
        String[] cmd = new String[]{"cp", source, target};
        NZip nzip = new NZip();
        try {
            nzip.runWithException(cmd);
        }
        catch (IOException ioe) {
            NZIPexpandError = "NZip failed to expand '" + source + "'";
            return "";
        }
        return target;
    }

    public static String getIDMLexpandError() {
        return IDMLexpandError;
    }

    public static int getIDMLexpandErrorNum() {
        return IDMLexpandErrorNum;
    }

    public static String getIDMLexpandParentFolder() {
        return IDMLexpandParentFolder;
    }

    public static String getIDMLexpandFolderName() {
        return IDMLexpandFolderName;
    }

    public static String getIDMLmergedPath() {
        return IDMLmergedPath;
    }

    public static String getIDMLmergedXMLName() {
        return IDMLmergedXMLName;
    }

    public static String mergeIDML(String theSourcePath, String theSourceIDMLname, String theExpandPath, String theTargetPath, String theTargetName, int showmessage) {
        String fldrODF;
        File fldr;
        Object targetPath;
        IDMLexpandError = "";
        IDMLexpandErrorNum = 0;
        IDMLexpandParentFolder = "";
        IDMLexpandFolderName = "";
        IDMLmergedPath = "";
        IDMLmergedXMLName = "";
        Object sourcePath = theSourcePath;
        int error = 0;
        if (!((String)sourcePath).endsWith(File.separator)) {
            sourcePath = (String)sourcePath + File.separator;
        }
        if (((String)(targetPath = theExpandPath)).equals("")) {
            targetPath = System.getProperty("java.io.tmpdir");
        }
        if (!((String)targetPath).endsWith(File.separator)) {
            targetPath = (String)targetPath + File.separator;
        }
        String[] fname = theSourceIDMLname.split(".idml");
        String targetName = theTargetName;
        if (targetName.equals("")) {
            targetName = fname[0];
        }
        if ((fldr = new File((String)targetPath + targetName)).exists()) {
            utils.deleteDirectory(fldr);
        }
        if (!(fldrODF = utils.nzip((String)sourcePath + theSourceIDMLname, (String)targetPath + targetName, false)).equals("")) {
            File unzippedFile;
            IDMLexpandParentFolder = targetPath;
            if (!((String)IDMLexpandParentFolder).endsWith(File.separator)) {
                IDMLexpandParentFolder = IDMLexpandParentFolder + File.separator;
            }
            if (!(unzippedFile = new File(IDMLexpandParentFolder + (IDMLexpandFolderName = targetName))).isDirectory()) {
                error = 2;
                IDMLexpandErrorNum = 2;
            }
        } else {
            error = 1;
            IDMLexpandErrorNum = 1;
        }
        if (error != 0) {
            IDMLexpandError = NZIPexpandError;
            if ((showmessage & 2) > 0) {
                switch (error) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        IDMLexpandError = "uNZip IDML package did not result in a folder structure";
                    }
                }
            }
            return "";
        }
        String mergedXMLname = utils.mergeIDMLxmlFiles(IDMLexpandParentFolder, IDMLexpandFolderName, theTargetPath, theTargetName, showmessage);
        return mergedXMLname;
    }

    public static String mergeIDMLxmlFiles(String theSourcePath, String theSourceIDMLname, String theTargetPath, String theTargetName, int showmessage) {
        int retval;
        String containerXML;
        String containerXMLpathname;
        String IDMLroot;
        Object sourcePath;
        Object mergedXMLname = theTargetName;
        if (((String)mergedXMLname).equals("")) {
            mergedXMLname = theSourceIDMLname + ".imx";
        }
        if (!((String)(sourcePath = theSourcePath)).endsWith(File.separator)) {
            sourcePath = (String)sourcePath + File.separator;
        }
        if (!(IDMLroot = (String)sourcePath + theSourceIDMLname).endsWith(File.separator)) {
            IDMLroot = IDMLroot + File.separator;
        }
        if (!new File(containerXMLpathname = IDMLroot + (containerXML = "META-INF/container.xml")).exists()) {
            IDMLexpandError = "IDML container XML file not found: '" + containerXML + "'";
            if ((showmessage & 2) > 0) {
                BatchXSLT.g_mainXSLTFrame.showMess("### ERROR: " + IDMLexpandError + "\n");
            }
            return "";
        }
        Object mergeXSLfileName = mainXSLTFrame.appDir;
        if (!((String)mergeXSLfileName).endsWith(File.separator)) {
            mergeXSLfileName = (String)mergeXSLfileName + File.separator;
        }
        if ((retval = utils.XSLtransform(IDMLroot, containerXML, (String)(mergeXSLfileName = (String)mergeXSLfileName + "XSL/IDMLmerge.xsl"), theTargetPath, (String)mergedXMLname, showmessage, true, true, false)) == 0) {
            IDMLmergedPath = theTargetPath;
            IDMLmergedXMLName = mergedXMLname;
        }
        return mergedXMLname;
    }

    public static int XSLtransform(String XMLpath, String XMLname, String XSLpathname, String outPath, String outName) {
        int error = utils.XSLtransform(XMLpath, XMLname, XSLpathname, outPath, outName, 3, true, true, false);
        return error;
    }

    public static int XSLtransform(String XMLpath, String XMLname, String XSLpathname, String outPath, String outName, int showmessage, Boolean XIncludeAware, Boolean NamespaceAware, Boolean Validating) {
        Transformer transformer;
        OutputStream outputStream;
        StreamResult my_stream_result;
        int error;
        block47: {
            String sourceXMLpathname;
            StreamSource my_stream_source;
            File my_source_file;
            block56: {
                block55: {
                    Object outputFileName;
                    block52: {
                        StreamSource xslt_inputstream;
                        TransformerFactory tFactory;
                        block54: {
                            block53: {
                                block50: {
                                    Source stylesheet;
                                    block51: {
                                        block49: {
                                            block48: {
                                                error = 0;
                                                my_source_file = null;
                                                my_stream_source = null;
                                                my_stream_result = null;
                                                outputStream = null;
                                                outputFileName = "";
                                                transformer = null;
                                                tFactory = null;
                                                Object sourceXMLpath = XMLpath;
                                                if (!((String)sourceXMLpath).endsWith(File.separator)) {
                                                    sourceXMLpath = (String)sourceXMLpath + File.separator;
                                                }
                                                if (new File(sourceXMLpathname = (String)sourceXMLpath + XMLname).exists()) break block48;
                                                error = 1;
                                                if ((showmessage & 2) > 0) {
                                                    BatchXSLT.g_mainXSLTFrame.showMess("### ERROR " + error + " XML not found: " + sourceXMLpathname + "\n");
                                                }
                                                break block47;
                                            }
                                            my_source_file = new File(sourceXMLpathname);
                                            my_stream_source = new StreamSource(my_source_file);
                                            if ((showmessage & 1) > 0) {
                                                BatchXSLT.g_mainXSLTFrame.showMess("Transforming XML: " + sourceXMLpathname + "\n");
                                            }
                                            try {
                                                tFactory = TransformerFactory.newInstance();
                                            }
                                            catch (Exception tfe) {
                                                error = 60;
                                                BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR " + error + " TransformerFactory.newInstance: '" + tfe.getMessage() + "'\n");
                                                tfe.printStackTrace();
                                                break block47;
                                            }
                                            if (tFactory != null) break block49;
                                            error = 601;
                                            BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR " + error + " TransformerFactory Error. TransformerFactory is NULL\n");
                                            break block47;
                                        }
                                        if (!XSLpathname.equals("")) break block50;
                                        stylesheet = null;
                                        String media = null;
                                        String title = null;
                                        String charset = null;
                                        try {
                                            stylesheet = tFactory.getAssociatedStylesheet(my_stream_source, media, title, charset);
                                        }
                                        catch (TransformerConfigurationException e) {
                                            error = 20;
                                            BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR " + error + " External Stylesheet Exception: '" + e.getMessage() + "'\n");
                                            e.printStackTrace();
                                            break block47;
                                        }
                                        if (stylesheet != null) break block51;
                                        error = 21;
                                        BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR " + error + " No associated XSL found'\n");
                                        break block47;
                                    }
                                    try {
                                        transformer = tFactory.newTransformer(stylesheet);
                                    }
                                    catch (TransformerConfigurationException e) {
                                        error = 22;
                                        BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR " + error + " Transformer ConfigurationException when loading XSL: '" + e.getMessage() + "'\n");
                                        break block47;
                                    }
                                    if (transformer != null) break block52;
                                    error = 221;
                                    BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR " + error + " Transformer Instance Error. Transformer is NULL\n");
                                    break block47;
                                }
                                xslt_inputstream = null;
                                if (new File(XSLpathname).exists()) break block53;
                                error = 2;
                                if ((showmessage & 2) > 0) {
                                    BatchXSLT.g_mainXSLTFrame.showMess("### ERROR " + error + " XSL not found: " + XSLpathname + "\n");
                                }
                                break block47;
                            }
                            try {
                                xslt_inputstream = new StreamSource(new FileInputStream(XSLpathname));
                                xslt_inputstream.setSystemId(new File(XSLpathname));
                            }
                            catch (IOException e) {
                                error = 23;
                                if ((showmessage & 2) > 0) {
                                    BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR " + error + " Loading XSL :'" + XSLpathname + "'\n");
                                }
                                break block47;
                            }
                            if (xslt_inputstream != null) break block54;
                            error = 231;
                            BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR " + error + " Transformer XSL Error. xslt_inputstream is NULL for XSL file: " + XSLpathname + "\n");
                            break block47;
                        }
                        try {
                            transformer = tFactory.newTransformer(xslt_inputstream);
                        }
                        catch (Exception e) {
                            error = 24;
                            if ((showmessage & 2) > 0) {
                                BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR " + error + " Transformer ConfigurationException when loading XSL: '" + e.getMessage() + "'\n");
                            }
                            break block47;
                        }
                        if (transformer != null) break block52;
                        error = 241;
                        BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR " + error + " Transformer Instance Error. Transformer is NULL\n");
                        break block47;
                    }
                    if ((showmessage & 1) > 0) {
                        BatchXSLT.g_mainXSLTFrame.showMess("       using XSL: " + XSLpathname + "\n");
                    }
                    if (!((String)(outputFileName = outPath)).equals("") && !((String)outputFileName).endsWith(File.separator)) {
                        outputFileName = (String)outputFileName + File.separator;
                    }
                    if (((String)(outputFileName = (String)outputFileName + outName)).equals("*NONE*")) break block55;
                    try {
                        outputStream = new FileOutputStream((String)outputFileName);
                    }
                    catch (IOException e) {
                        error = 30;
                        BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR " + error + " FileOutputStream IOExceptio: '" + e.getMessage() + "'\n");
                        break block47;
                    }
                    my_stream_result = new StreamResult(outputStream);
                    if (my_stream_result != null) break block56;
                    error = 31;
                    BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR " + error + " Output StreamResult is NULL\n");
                    break block47;
                }
                my_stream_result = new StreamResult(new NullOutputStream());
            }
            try {
                transformer.setParameter("XMLpath", XMLpath);
                transformer.setParameter("XMLname", XMLname);
            }
            catch (Exception e) {
                error = 40;
                BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR " + error + " Transformer Parameter: '" + e.getMessage() + "'\n");
                break block47;
            }
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            try {
                docFactory.setXIncludeAware(XIncludeAware);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                docFactory.setNamespaceAware(NamespaceAware);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                docFactory.setValidating(Validating);
            }
            catch (Exception e) {
                // empty catch block
            }
            DocumentBuilder docBuilder = null;
            Document xmlSourceDocument = null;
            try {
                docBuilder = docFactory.newDocumentBuilder();
            }
            catch (Exception dbex) {
                error = 41;
                BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR " + error + " in creating DocumentBuilder for source document.\n");
                dbex.printStackTrace();
                break block47;
            }
            try {
                xmlSourceDocument = docBuilder.parse(my_source_file);
            }
            catch (Exception srcex) {
                error = 42;
                System.out.println("### ERROR " + error + " in DocumentBuilder parsing source document: '" + sourceXMLpathname + "'");
                srcex.printStackTrace();
                break block47;
            }
            try {
                if (xmlSourceDocument != null) {
                    transformer.transform(new DOMSource(xmlSourceDocument), my_stream_result);
                } else {
                    transformer.transform(my_stream_source, my_stream_result);
                }
            }
            catch (Exception e) {
                if (transformer != null) {
                    transformer.clearParameters();
                }
                error = 43;
                BatchXSLT.g_mainXSLTFrame.showMess("\n#### ERROR " + error + " Transformer Exception: '" + e.getMessage() + "'\n");
                e.printStackTrace();
            }
        }
        if (transformer != null) {
            transformer.clearParameters();
        }
        my_stream_result = null;
        transformer = null;
        if (my_stream_result != null || outputStream != null) {
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                ((FileOutputStream)outputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (showmessage > 0) {
            if (error == 0 && (showmessage & 1) > 0) {
                BatchXSLT.g_mainXSLTFrame.showMess("Transform complete.\n");
            } else if ((showmessage & 2) > 0) {
                BatchXSLT.g_mainXSLTFrame.showMess("### ERROR " + error + " during transform\n");
            }
        }
        return error;
    }

    public static byte[] compressZIP(String instring, int compression) {
        if (instring == null || instring.equals("")) {
            return null;
        }
        Deflater compressor = new Deflater();
        switch (compression) {
            case 0: {
                compressor.setLevel(-1);
                break;
            }
            case 1: {
                compressor.setLevel(9);
                break;
            }
            case 2: {
                compressor.setLevel(1);
                break;
            }
            default: {
                compressor.setLevel(-1);
            }
        }
        byte[] input = null;
        try {
            input = instring.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("### ERROR in compressZIP(): '" + e.getMessage() + "'");
            return null;
        }
        compressor.setInput(input);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(instring.length());
        byte[] output = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(output);
            bos.write(output, 0, count);
        }
        compressor.end();
        try {
            bos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public static String decompressZIP(byte[] inbytes) {
        if (inbytes == null || inbytes.length == 0) {
            return "";
        }
        Inflater decompressor = new Inflater();
        decompressor.setInput(inbytes);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(inbytes.length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                System.out.println("### ERROR while decompressing in decompressZIP(): '" + e.getMessage() + "'");
                return "";
            }
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        String retstr = null;
        try {
            retstr = bos.toString("UTF-8");
        }
        catch (Exception e) {
            System.out.println("### ERROR at data return in decompressZIP(): '" + e.getMessage() + "'");
            return "";
        }
        return retstr;
    }

    public static int testZIPstorage(String str) {
        System.out.println("*** calling testZIPstorage() with string: '" + str + "'");
        utils.publicStorageArray_init();
        utils.publicStorageArray_addString(str, true, 0);
        utils.publicStorageArray_addString(str, true, 1);
        utils.publicStorageArray_addString(str, true, 2);
        int numElements = utils.publicStorageArray_size();
        System.out.println("    added " + numElements + " zipped strings.'");
        for (int i = 0; i < numElements; ++i) {
            String decompressed = utils.publicStorageArray_getString(i, true);
            if (!decompressed.equals(str)) continue;
            System.out.println("*** testZIP() returned from storage index # " + i + ": '" + decompressed + "'");
            System.out.println("          input size: " + str.length() + " bytes.'");
            System.out.println("   decompressed size: " + decompressed.length() + " bytes.'");
        }
        utils.publicStorageArray_init();
        return 0;
    }

    public static int publicStorageArray_init() {
        publicStorageArray.clear();
        System.gc();
        return 0;
    }

    public static int publicStorageArray_size() {
        return publicStorageArray.size();
    }

    public static int publicStorageArray_addString(String thestring, boolean zip, int compression) {
        if (zip) {
            publicStorageArray.add(utils.compressZIP(thestring, compression));
        } else {
            publicStorageArray.add(thestring);
        }
        return publicStorageArray.size();
    }

    public static int publicStorageArray_setString(int index, String thestring, boolean zip, int compression) {
        if (zip) {
            publicStorageArray.set(index, utils.compressZIP(thestring, compression));
        } else {
            publicStorageArray.set(index, thestring);
        }
        return publicStorageArray.size();
    }

    public static String publicStorageArray_getString(int theindex, boolean dezip) {
        int index = theindex;
        if (index < 0) {
            index = 0;
        }
        if (index >= publicStorageArray.size()) {
            index = publicStorageArray.size() - 1;
        }
        if (dezip) {
            return utils.decompressZIP((byte[])publicStorageArray.get(index));
        }
        return publicStorageArray.get(index).toString();
    }

    public static void publicStorageArray_remove(int theindex) {
        if (theindex < 0 || theindex >= publicStorageArray.size()) {
            return;
        }
        try {
            publicStorageArray.remove(theindex);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String publicStorageArray_serialize(boolean dezip, String delimiter) {
        int size = publicStorageArray.size();
        if (size <= 0) {
            return "";
        }
        Object serialized = "";
        for (int i = 0; i < size; ++i) {
            serialized = dezip ? (String)serialized + utils.decompressZIP((byte[])publicStorageArray.get(i)) : (String)serialized + (String)publicStorageArray.get(i);
        }
        return serialized;
    }

    public static String var_dump(Object o) {
        return new ToStringBuilder(o, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }
}

