/*
 * Decompiled with CFR 0.152.
 */
package com.epaperarchives.http;

import com.epaperarchives.batchxslt.utils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;

public class httpConnector {
    private static int DEBUG = 0;
    private static String lastConnectionMessage = "";
    private static String lastConnectionState = "";
    private static String lastConnectionCode = "";
    private static String lastConnectionResponseBody = "";

    public static int setDEBUG(String val) {
        DEBUG = Integer.valueOf(val);
        return DEBUG;
    }

    public static int setDEBUG(int val) {
        DEBUG = val;
        return DEBUG;
    }

    public static String getLastConnectionMessage() {
        return lastConnectionMessage;
    }

    public static String getLastConnectionState() {
        return lastConnectionState;
    }

    public static String getLastConnectionCode() {
        return lastConnectionCode;
    }

    public static String getLastConnectionResponseBody() {
        return lastConnectionResponseBody;
    }

    public static String getHTTP(String[] params) {
        if (params.length < 3) {
            return "### ERROR -200";
        }
        return httpConnector.getHTTP(params[0], params[1], params[2]);
    }

    public static String getHTTP(String url, String enc, String dodebug) {
        DEBUG = !dodebug.equals("0") ? 1 : 0;
        String response = httpConnector.getHTTP(url, enc, false);
        DEBUG = 0;
        return response;
    }

    public static String getHTTP(String url, String enc) {
        return httpConnector.getHTTP(url, enc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHTTP(String url, String enc, boolean silent) {
        lastConnectionMessage = "";
        lastConnectionState = "";
        lastConnectionCode = "";
        if (url.equals("")) {
            return "";
        }
        DefaultHttpClient httpclient = new DefaultHttpClient();
        ProxySelectorRoutePlanner routePlanner = null;
        try {
            if (DEBUG > 0) {
                httpConnector.listProxies();
            }
            routePlanner = new ProxySelectorRoutePlanner(httpclient.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
            httpclient.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HttpGet httpget = new HttpGet(url);
        if (DEBUG > 0) {
            utils.showMess("getHTTP request URI: " + httpget.getURI() + "\n    encoding: " + enc + "\n    silent: " + silent + "\n", "1");
            if (routePlanner != null) {
                utils.showMess("    using proxy route planner " + routePlanner + "\n", "1");
            } else {
                utils.showMess("    NO proxy found.\n", "1");
            }
        }
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        try {
            lastConnectionResponseBody = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
        }
        catch (IOException ioe) {
            lastConnectionMessage = "Unexpected http error: " + ioe.getMessage();
            lastConnectionState = "";
            lastConnectionCode = "-2";
            if (!silent) {
                utils.showMess("Unexpected http error: " + ioe.getMessage() + "\n", "1");
                ioe.printStackTrace();
            }
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        if (DEBUG > 0) {
            utils.showMess("-------------- response body ----------\n", "1");
            utils.showMess(lastConnectionResponseBody, "1");
            utils.showMess("\n----------------------------------------\n", "1");
        }
        if (lastConnectionResponseBody == null) {
            return "";
        }
        try {
            if (enc.equals("binary")) {
                return new String(lastConnectionResponseBody);
            }
            if (!enc.equals("")) {
                return new String(lastConnectionResponseBody.getBytes(enc), enc);
            }
            return new String(lastConnectionResponseBody);
        }
        catch (Exception e) {
            lastConnectionMessage = e.getMessage();
            lastConnectionState = "";
            lastConnectionCode = "-2";
            return "";
        }
    }

    public static void listProxies() {
        utils.showMess("******** available Proxy servers:\n", "1");
        try {
            System.setProperty("java.net.useSystemProxies", "true");
            List<Proxy> l = ProxySelector.getDefault().select(new URI("http://aiedv.ch"));
            for (Proxy proxy : l) {
                utils.showMess("proxy hostname : " + proxy.type() + "\n", "1");
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                if (addr == null) {
                    utils.showMess("No Proxy\n", "1");
                    continue;
                }
                utils.showMess("proxy hostname : " + addr.getHostName() + "\n", "1");
                utils.showMess("proxy port : " + addr.getPort() + "\n", "1");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

