/*
 * Decompiled with CFR 0.152.
 */
package com.epaperarchives.batchxslt;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import com.epaperarchives.batchxslt.BatchXSLT;
import java.io.FileNotFoundException;
import java.io.IOException;

public class BXSLT_SERVER {
    private static final String PACKAGE_NAME = "com.epaperarchives.batchxslt.BXSLT_SERVER";

    public static int BSH_InterpreteSource(String pathname) {
        if (pathname.equals("")) {
            return -1;
        }
        Interpreter ipret = new Interpreter();
        try {
            ipret.source(pathname);
        }
        catch (FileNotFoundException fnfe) {
            return -2;
        }
        catch (IOException ioe) {
            return -3;
        }
        catch (TargetError se) {
            Throwable t = se.getTarget();
            System.out.println("BSH ERROR -4. Script file threw exception: " + t);
            return -4;
        }
        catch (EvalError eve) {
            System.out.println("BSH ERROR -5. Exception: " + eve.getErrorText());
            return -5;
        }
        return 0;
    }

    public static int BSH_InterpreteString(String src) {
        if (src.equals("")) {
            return -1;
        }
        Interpreter ipret = new Interpreter();
        try {
            ipret.eval(src);
        }
        catch (TargetError se) {
            Throwable t = se.getTarget();
            System.out.println("BSH ERROR -4. Script string threw exception: " + t);
            se.printStackTrace();
            return -4;
        }
        catch (EvalError eve) {
            System.out.println("BSH ERROR -5. Exception: " + eve.getErrorText());
            eve.printStackTrace();
            return -5;
        }
        return 0;
    }

    public static int BSH_remote(String portstr) {
        if (portstr.equals("")) {
            return -1;
        }
        Interpreter ipret = new Interpreter();
        try {
            ipret.set("BatchXSLTServer", (Object)"utils");
        }
        catch (EvalError eve2) {
            System.out.println("BSH_Remote ERROR -2. Exception: " + eve2.getErrorText());
            eve2.printStackTrace();
            return -2;
        }
        int port = Integer.valueOf(portstr);
        try {
            ipret.set("portnum", port);
        }
        catch (EvalError eve3) {
            System.out.println("BSH_Remote ERROR -3. Exception: " + eve3.getErrorText());
            eve3.printStackTrace();
            return -3;
        }
        try {
            ipret.eval("setAccessibility(true)");
        }
        catch (EvalError eve4) {
            System.out.println("BSH_Remote ERROR -4. Exception: " + eve4.getErrorText());
            eve4.printStackTrace();
            return -4;
        }
        try {
            ipret.eval("server(portnum)");
        }
        catch (EvalError eve5) {
            System.out.println("BSH_Remote ERROR -4. Exception: " + eve5.getErrorText());
            eve5.printStackTrace();
            return -5;
        }
        BatchXSLT.g_mainXSLTFrame.showMess("*** BSH_Remote HTTP startet on port  " + port + "\n");
        return 0;
    }
}

