/*
 * Decompiled with CFR 0.152.
 */
package com.epaperarchives.batchxslt;

import com.epaperarchives.batchxslt.BatchXSLT;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RescaleOp;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JpgImage {
    private static final double INCH_2_CM = 2.54;
    private BufferedImage bi = null;
    private String currentImagePathName = "";

    public JpgImage() {
    }

    public JpgImage(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        this.bi = ImageIO.read(fis);
        fis.close();
    }

    public void JpgImageDispose() {
        if (this.bi != null) {
            this.bi.flush();
            this.bi = null;
        }
    }

    public JpgImage(BufferedImage image) throws IOException {
        if (image == null) {
            throw new IOException("BufferedImage is null");
        }
        this.bi = image;
    }

    public int getHeight() {
        return this.bi.getHeight();
    }

    public int getWidth() {
        return this.bi.getWidth();
    }

    public void scaleHeight(int height) {
        double scale = (double)height / (double)this.bi.getHeight();
        this.scalePercent(scale);
    }

    public void scaleWidth(int width) {
        double scale = (double)width / (double)this.bi.getWidth();
        this.scalePercent(scale);
    }

    public void scaleHeightWidthMax(int height, int width) {
        double scaleH = (double)height / (double)this.bi.getHeight();
        double scaleW = (double)width / (double)this.bi.getWidth();
        this.scalePercent(Math.max(scaleH, scaleW));
    }

    public void scaleHeightWidthMin(int height, int width) {
        double scaleH = (double)height / (double)this.bi.getHeight();
        double scaleW = (double)width / (double)this.bi.getWidth();
        this.scalePercent(Math.min(scaleH, scaleW));
    }

    public void scalePercent(double scale) {
        this.scalePercent(scale, 1, 1, null);
    }

    public void scalePercent(double scale, int antialias, int numSteps, BufferedImage theimage) {
        if (scale < 0.0 || scale == 1.0) {
            return;
        }
        BufferedImage myimage = theimage;
        if (myimage == null) {
            myimage = this.bi;
        }
        RenderingHints hints = null;
        Object destImg = null;
        BufferedImage intermedImg = null;
        Object op = null;
        double myScale = scale;
        int mynumSteps = numSteps;
        if (mynumSteps <= 0) {
            mynumSteps = 1;
        }
        if (antialias > 0) {
            hints = new RenderingHints(null);
            if ((antialias & 1) > 0) {
                hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if ((antialias & 2) > 0) {
                hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
            if ((antialias & 4) > 0) {
                hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            }
            if ((antialias & 8) > 0) {
                hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
            if ((antialias & 0x10) > 0) {
                hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            }
            if ((antialias & 0x20) > 0) {
                hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            }
            if ((antialias & 0x40) > 0) {
                hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            if ((antialias & 0x80) > 0) {
                hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            }
        }
        double currentSize = 1.0;
        double endSize = scale;
        double newSize = 1.0;
        int remainSteps = mynumSteps;
        if (remainSteps <= 0) {
            remainSteps = 1;
        }
        double stepSize = (1.0 - endSize) / (double)mynumSteps;
        while (true) {
            newSize = (endSize + (double)(remainSteps - 1) * stepSize) / (endSize + (double)remainSteps * stepSize);
            myimage = intermedImg = JpgImage.scale(myimage, newSize, hints);
            if (--remainSteps <= 0) break;
            currentSize = newSize;
        }
        if (theimage == null) {
            this.bi = myimage;
        } else {
            theimage = myimage;
        }
    }

    private static BufferedImage scale(BufferedImage imageToScale, Double ratio, RenderingHints hints) {
        Integer dWidth = (int)((double)imageToScale.getWidth() * ratio);
        Integer dHeight = (int)((double)imageToScale.getHeight() * ratio);
        BufferedImage scaledImage = new BufferedImage(dWidth, dHeight, 1);
        Graphics2D graphics2D = scaledImage.createGraphics();
        graphics2D.setRenderingHints(hints);
        graphics2D.drawImage(imageToScale, 0, 0, dWidth, dHeight, null);
        graphics2D.dispose();
        return scaledImage;
    }

    public void cropProportions(double width, double height) {
        int currentHeight = this.bi.getHeight();
        int currentWidth = this.bi.getWidth();
        int cropHeight = (int)((double)currentWidth * (height / width));
        int cropWidth = (int)((double)currentHeight * (width / height));
        this.bi = cropHeight > currentHeight ? this.bi.getSubimage((currentWidth - cropWidth) / 2, 0, cropWidth, currentHeight) : this.bi.getSubimage(0, (currentHeight - cropHeight) / 2, currentWidth, cropHeight);
    }

    public void cropProportions(double width, double height, boolean optimize) {
        double big = Math.max(width, height);
        double small = Math.min(width, height);
        if (optimize) {
            if (this.bi.getWidth() > this.bi.getHeight()) {
                this.cropProportions(big, small);
            } else {
                this.cropProportions(small, big);
            }
        } else {
            this.cropProportions(width, height);
        }
    }

    public int cutSubJPGImage(String infilePathName, int x, int y, int w, int h, int density, float quality, double scale, double dpiscale, String outfilePathName, int overwriteexisting) {
        IIOMetadata metadata;
        FileImageOutputStream outs;
        BufferedImage cutimage;
        File outfile = new File(outfilePathName);
        if (outfile.exists()) {
            if (overwriteexisting == 0) {
                return 0;
            }
            try {
                outfile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.bi == null || !this.currentImagePathName.equals(infilePathName)) {
            try {
                this.bi = ImageIO.read(new File(infilePathName));
                this.currentImagePathName = infilePathName;
            }
            catch (Exception excp) {
                this.bi = null;
                this.currentImagePathName = "";
                return -1;
            }
            if (this.bi == null) {
                this.currentImagePathName = "";
                return -2;
            }
        }
        int maxwidth = this.bi.getWidth();
        int maxheight = this.bi.getHeight();
        int cutX = x;
        int cutY = y;
        if (cutX < 0) {
            cutX = 0;
        }
        if (cutY < 0) {
            cutY = 0;
        }
        int cutwidth = w;
        int cutheight = h;
        if (cutX + cutwidth > maxwidth) {
            cutwidth = maxwidth - cutX;
        }
        if (cutY + cutheight > maxheight) {
            cutheight = maxheight - cutY;
        }
        try {
            cutimage = this.bi.getSubimage(cutX, cutY, cutwidth, cutheight);
        }
        catch (Exception excpcut) {
            return -3;
        }
        BufferedImage resizedimage = null;
        if (scale != 1.0 || dpiscale != 1.0) {
            int newWidth = Double.valueOf((double)cutimage.getWidth() / dpiscale * scale).intValue();
            int newHeight = Double.valueOf((double)cutimage.getHeight() / dpiscale * scale).intValue();
            resizedimage = new BufferedImage(newWidth, newHeight, cutimage.getType());
            Graphics2D g = resizedimage.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(cutimage, 0, 0, newWidth, newHeight, 0, 0, cutimage.getWidth(), cutimage.getHeight(), null);
            g.dispose();
        }
        try {
            outs = new FileImageOutputStream(new File(outfilePathName));
        }
        catch (IOException fnfex) {
            return -4;
        }
        ImageReader imageReader = ImageIO.getImageReadersBySuffix("jpeg").next();
        try {
            metadata = imageReader.getImageMetadata(0);
        }
        catch (IOException iorex) {
            return -5;
        }
        Element tree = (Element)metadata.getAsTree("javax_imageio_jpeg_image_1.0");
        Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
        String dpiX = jfif.getAttribute("Xdensity");
        String dpiY = jfif.getAttribute("Ydensity");
        ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("jpeg").next();
        imageWriter.setOutput(outfile);
        ImageWriteParam writeParams = imageWriter.getDefaultWriteParam();
        writeParams.setCompressionMode(2);
        writeParams.setCompressionQuality(quality);
        metadata = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(this.bi), writeParams);
        tree = (Element)metadata.getAsTree("javax_imageio_jpeg_image_1.0");
        jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
        jfif.setAttribute("Xdensity", "" + density);
        jfif.setAttribute("Ydensity", "" + density);
        jfif.setAttribute("resUnits", "1");
        try {
            if (resizedimage != null) {
                imageWriter.write(metadata, new IIOImage(resizedimage, null, null), writeParams);
                resizedimage.flush();
                cutimage.flush();
            } else {
                imageWriter.write(metadata, new IIOImage(cutimage, null, null), writeParams);
                cutimage.flush();
            }
        }
        catch (IOException ex) {
            try {
                outs.close();
            }
            catch (IOException exouts) {
                return -6;
            }
            return -7;
        }
        try {
            outs.close();
        }
        catch (IOException ex) {
            return -8;
        }
        return 0;
    }

    public void rotate(double degrees) {
        this.rotate(degrees, Color.white);
    }

    public void rotate(double degrees, Color backgroundColor) {
        double positiveDegrees = degrees % 360.0 + (double)(degrees < 0.0 ? 360 : 0);
        double degreesMod90 = positiveDegrees % 90.0;
        double radians = Math.toRadians(positiveDegrees);
        double radiansMod90 = Math.toRadians(degreesMod90);
        if (positiveDegrees == 0.0) {
            return;
        }
        int quadrant = 0;
        if (positiveDegrees < 90.0) {
            quadrant = 1;
        } else if (positiveDegrees >= 90.0 && positiveDegrees < 180.0) {
            quadrant = 2;
        } else if (positiveDegrees >= 180.0 && positiveDegrees < 270.0) {
            quadrant = 3;
        } else if (positiveDegrees >= 270.0) {
            quadrant = 4;
        }
        int height = this.bi.getHeight();
        int width = this.bi.getWidth();
        double side1 = Math.sin(radiansMod90) * (double)height + Math.cos(radiansMod90) * (double)width;
        double side2 = Math.cos(radiansMod90) * (double)height + Math.sin(radiansMod90) * (double)width;
        double h = 0.0;
        int newWidth = 0;
        int newHeight = 0;
        if (quadrant == 1 || quadrant == 3) {
            h = Math.sin(radiansMod90) * (double)height;
            newWidth = (int)side1;
            newHeight = (int)side2;
        } else {
            h = Math.sin(radiansMod90) * (double)width;
            newWidth = (int)side2;
            newHeight = (int)side1;
        }
        int shiftX = (int)(Math.cos(radians) * h) - (quadrant == 3 || quadrant == 4 ? width : 0);
        int shiftY = (int)(Math.sin(radians) * h) + (quadrant == 2 || quadrant == 3 ? height : 0);
        BufferedImage newbi = new BufferedImage(newWidth, newHeight, this.bi.getType());
        Graphics2D g2d = newbi.createGraphics();
        g2d.setBackground(backgroundColor);
        g2d.clearRect(0, 0, newWidth, newHeight);
        g2d.rotate(radians);
        g2d.drawImage((Image)this.bi, shiftX, -shiftY, null);
        this.bi = newbi;
    }

    public void invert() {
        AffineTransform at = AffineTransform.getTranslateInstance(this.bi.getWidth(), 0.0);
        at.scale(-1.0, 1.0);
        AffineTransformOp op = new AffineTransformOp(at, null);
        this.bi = op.filter(this.bi, null);
    }

    public void grayscale() {
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        this.bi = op.filter(this.bi, null);
    }

    public void negative() {
        RescaleOp op = new RescaleOp(-1.0f, 255.0f, null);
        this.bi = op.filter(this.bi, null);
    }

    public BufferedImage sendToBufferedImage() {
        return this.bi;
    }

    public void sendToFile(String fileName) throws IOException {
        this.sendToFile(fileName, 0.75f);
    }

    public void sendToFile(String fileName, float quality) throws IOException {
        this.sendToFile(fileName, quality, 0, 0, 0);
    }

    public void sendToFile(String fileName, float quality, int dpi) throws IOException {
        this.sendToFile(fileName, quality, dpi, 0, 0);
    }

    public void sendToFile(String fileName, float quality, int dpi, int imgWidth, int imgHeight) throws IOException {
        if (quality < 0.0f) {
            quality = 0.0f;
        }
        if (quality > 1.0f) {
            quality = 1.0f;
        }
        File outf = new File(fileName);
        ImageOutputStream out = ImageIO.createImageOutputStream(outf);
        IIOMetadata metadata = null;
        ImageWriteParam writeParams = null;
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByFormatName("jpg");
        while (imageWriters.hasNext()) {
            imageWriter = imageWriters.next();
            writeParams = imageWriter.getDefaultWriteParam();
            writeParams.setCompressionMode(2);
            writeParams.setCompressionQuality(quality);
            metadata = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(this.bi), writeParams);
            if (!metadata.isReadOnly() && metadata.isStandardMetadataFormatSupported()) break;
            System.out.println("\n## imageWriter NOT suitable");
        }
        if (imageWriter == null) {
            System.out.println("###FATAL ERROR: no imageWriter found!");
            return;
        }
        IIOMetadataNode metadata_tree = null;
        metadata_tree = (IIOMetadataNode)metadata.getAsTree("javax_imageio_jpeg_image_1.0");
        if (imgWidth > 0 || imgHeight > 0) {
            Element sof = (Element)metadata_tree.getElementsByTagName("sof").item(0);
            sof.setAttribute("numLines", Integer.toString(imgHeight));
            sof.setAttribute("samplesPerLine", Integer.toString(imgWidth));
            metadata.setFromTree("javax_imageio_jpeg_image_1.0", metadata_tree);
        }
        if (dpi > 0) {
            Element jfif = (Element)metadata_tree.getElementsByTagName("app0JFIF").item(0);
            jfif.setAttribute("Xdensity", Integer.toString(dpi));
            jfif.setAttribute("Ydensity", Integer.toString(dpi));
            jfif.setAttribute("resUnits", "1");
            metadata.setFromTree("javax_imageio_jpeg_image_1.0", metadata_tree);
        }
        imageWriter.setOutput(out);
        imageWriter.write(null, new IIOImage(this.bi, null, metadata), writeParams);
        out.close();
        imageWriter.dispose();
    }

    public Graphics2D getImageGraphics() {
        return (Graphics2D)this.bi.getGraphics();
    }

    private void setDPIdimenson(IIOMetadata metadata, int dpi) throws IIOInvalidTreeException {
        double dotsPerMilli = 1.0 * (double)dpi / 10.0 / 2.54;
        IIOMetadataNode metadata_tree = null;
        metadata_tree = (IIOMetadataNode)metadata.getAsTree("javax_imageio_1.0");
        NodeList HorizontalPixelSizeNodeList = metadata_tree.getElementsByTagName("HorizontalPixelSize");
        Element HorizontalPixelSize = HorizontalPixelSizeNodeList.getLength() < 1 ? new IIOMetadataNode("HorizontalPixelSize") : (Element)HorizontalPixelSizeNodeList.item(0);
        HorizontalPixelSize.setAttribute("value", Double.toString(dotsPerMilli));
        NodeList VerticalPixelSizeNodeList = metadata_tree.getElementsByTagName("VerticalPixelSize");
        Element VerticalPixelSize = VerticalPixelSizeNodeList.getLength() < 1 ? new IIOMetadataNode("HorizontalPixelSize") : (Element)VerticalPixelSizeNodeList.item(0);
        VerticalPixelSize.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode("Dimension");
        dim.appendChild(HorizontalPixelSize);
        dim.appendChild(VerticalPixelSize);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dim);
        System.out.println("+++ metadata_tree BEFORE PixelSize change: ");
        System.out.println(this.serializeNode(root));
        metadata.mergeTree("javax_imageio_1.0", root);
        System.out.println("+++ metadata AFTER PixelSize change: ");
        this.listMetadataTree(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIOMetadata getMetadata(String fileName, boolean do_print) {
        IIOMetadata metadata = null;
        ImageInputStream iis = null;
        try {
            File file = new File(fileName);
            iis = ImageIO.createImageInputStream(file);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                reader.setInput(iis, true);
                metadata = reader.getImageMetadata(0);
                reader.dispose();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (iis != null) {
                try {
                    iis.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (do_print) {
            this.listMetadataTree(metadata);
            return null;
        }
        return metadata;
    }

    public void listMetadataTree(IIOMetadata metadata) {
        String[] metaFormatNames = metadata.getMetadataFormatNames();
        System.out.println("\n** metadata root elements **");
        for (String s : metaFormatNames) {
            System.out.println("--" + s);
        }
        for (int mfn = 0; mfn < metaFormatNames.length; ++mfn) {
            Element metadata_tree = null;
            metadata_tree = (Element)metadata.getAsTree(metaFormatNames[mfn]);
            System.out.println("++ childNodes of '" + metaFormatNames[mfn] + "'");
            NodeList childNodes = metadata_tree.getChildNodes();
            for (int n = 0; n < childNodes.getLength(); ++n) {
                System.out.println("----Node " + childNodes.item(n).getNodeName());
                NodeList childNodes2 = childNodes.item(n).getChildNodes();
                for (int n2 = 0; n2 < childNodes2.getLength(); ++n2) {
                    String serial = this.serializeNode(childNodes2.item(n2));
                    System.out.println("      " + serial);
                }
            }
        }
    }

    public String serializeNode(Node node) {
        Transformer transformer;
        TransformerFactory transFactory = TransformerFactory.newInstance();
        try {
            transformer = transFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            BatchXSLT.g_mainXSLTFrame.showMess("#### serializeNode TransformerConfigurationException:" + e.getMessage() + "'\n");
            e.printStackTrace();
            return "";
        }
        StringWriter buffer = new StringWriter();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        try {
            transformer.transform(new DOMSource(node), new StreamResult(buffer));
        }
        catch (TransformerException e) {
            BatchXSLT.g_mainXSLTFrame.showMess("#### serializeNode TransformerException:" + e.getMessage() + "'\n");
            e.printStackTrace();
            return "";
        }
        String str = buffer.toString();
        return str;
    }
}

