/*
 * Decompiled with CFR 0.152.
 */
package com.epaperarchives.batchxslt;

import com.epaperarchives.batchxslt.BatchXSLT;
import com.epaperarchives.batchxslt.BatchXSLTransform;
import com.epaperarchives.batchxslt.mainXSLTFrame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Calendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ftp {
    private static final String PACKAGE_NAME = "com.epaperarchives.batchxslt.ftp";
    private static int max_ftpClients = 4;
    private static int initialized_ftpClients = -1;
    private static ftpClient[] ftpClients;
    private static ArrayList<String> ftp_sendQueue;
    private static int result_code;
    private static String result_text;
    public static boolean DEBUG_FTP_CLIENT;
    public static boolean DEBUG_FTP_QUEUE;
    private static boolean ftp_sendQueueThread_isrunning;
    private static int ftp_sendQueueThread_returnvalue;

    public static void set_DEBUG_FTP_CLIENT(boolean bol) {
        DEBUG_FTP_CLIENT = bol;
    }

    public static int init_ftpClients() {
        return ftp.init_ftpClients(max_ftpClients);
    }

    public static int init_ftpClients(int num) {
        ftpClients = new ftpClient[num];
        for (int i = 0; i < num; ++i) {
            ftp.ftpClients[i] = null;
        }
        max_ftpClients = num;
        initialized_ftpClients = num;
        BatchXSLT.g_mainXSLTFrame.showMess("*** initialized FTPClients: " + ftpClients.length + "\n");
        return num;
    }

    public static int activeFTPClients() {
        int numclients = 0;
        if (initialized_ftpClients < 0) {
            ftp.init_ftpClients(max_ftpClients);
        }
        for (int i = 0; i < max_ftpClients; ++i) {
            if (ftpClients[i] == null) continue;
            ++numclients;
        }
        return numclients;
    }

    public static int set_max_ftpClients(int max) {
        if (ftp.activeFTPClients() > 0) {
            return -1;
        }
        ftp.init_ftpClients(max);
        return ftpClients.length;
    }

    public static int maxFTPClients() {
        return max_ftpClients;
    }

    public static ftpClient newFTPClient() {
        if (initialized_ftpClients < 0) {
            ftp.init_ftpClients(max_ftpClients);
        }
        for (int i = 0; i < max_ftpClients; ++i) {
            if (ftpClients[i] != null) continue;
            ftp.ftpClients[i] = new ftpClient();
            if (ftpClients[i] != null && ftp.ftpClients[i].defaultTimeout > 0) {
                ftpClients[i].setDataTimeout(ftp.ftpClients[i].defaultTimeout);
            }
            return ftpClients[i];
        }
        return null;
    }

    public static int destroyFTPClient(ftpClient client) {
        for (int i = 0; i < max_ftpClients; ++i) {
            if (ftpClients[i] != client) continue;
            ftp.ftpClients[i] = null;
            return 0;
        }
        return -1;
    }

    public static void disconnectDestroyFTPClient(int clientID) {
        if (ftpClients[clientID] == null) {
            return;
        }
        if (ftp.ftpClients[clientID].loggedin) {
            ftpClients[clientID].logout();
        }
        if (ftp.ftpClients[clientID].connected) {
            ftpClients[clientID].disconnect();
        }
        ftp.ftpClients[clientID] = null;
        BatchXSLT.g_mainXSLTFrame.showMess("*** FTPClient " + clientID + " disconnected and released.\n");
    }

    public static int getFTPClientID(ftpClient client) {
        for (int i = 0; i < max_ftpClients; ++i) {
            if (ftpClients[i] != client) continue;
            return i;
        }
        return -1;
    }

    public static void set_DEBUG_FTP_QUEUE(boolean bol) {
        DEBUG_FTP_QUEUE = bol;
    }

    private static String myGetNodeValue(Element elem) {
        String cont;
        if (elem == null) {
            return "";
        }
        Node child = elem.getFirstChild();
        if (child == null) {
            return "";
        }
        try {
            cont = child.getNodeValue();
        }
        catch (DOMException ex) {
            return "";
        }
        if (cont == null) {
            return "";
        }
        return cont;
    }

    public static int queue_putFile(String itemElement) {
        boolean added = ftp_sendQueue.add(itemElement);
        if (added) {
            if (!ftp_sendQueueThread_isrunning) {
                if (DEBUG_FTP_CLIENT) {
                    BatchXSLT.g_mainXSLTFrame.showMess("****** ftp_sendQueueThread will start\n");
                }
                ftp_sendQueueThread sqt = new ftp_sendQueueThread();
                sqt.start();
                if (DEBUG_FTP_CLIENT) {
                    BatchXSLT.g_mainXSLTFrame.showMess("****** ftp_sendQueueThread STARTED\n");
                }
            }
            return 0;
        }
        return -1;
    }

    static {
        ftp_sendQueue = new ArrayList();
        result_code = 0;
        result_text = "";
        DEBUG_FTP_CLIENT = false;
        DEBUG_FTP_QUEUE = false;
        ftp_sendQueueThread_isrunning = false;
        ftp_sendQueueThread_returnvalue = -1;
    }

    public static class ftpClient {
        private String type = "ftp";
        private String controlEncoding = "UTF-8";
        private String transfermode = "stream";
        private int defaultTimeout = 10000;
        private int sendBufferSize = 16384;
        private int receiveBufferSize = 16384;
        private String activePassive = "active";
        private String filetype = "binary";
        private String server = "localhost";
        private int port = 0;
        private String username = "";
        private String password = "";
        private String account = "";
        private String base_path = "";
        private String sub_path = "";
        private String remote_path_separator = "/";
        private int excludeHiddenFiles = 1;
        private int last_result_code = 0;
        private String last_result_text = "";
        private final int undefined_value = -9999;
        public FTPClient ftp = null;
        boolean connected = false;
        boolean loggedin = false;
        private String remote_curdir = "";
        boolean putFileThread_isrunning = false;
        int putFileThread_returnvalue = -1;

        public int setOption(String which, String value) {
            int option_ok = 0;
            if (which.equals("type")) {
                this.type = value;
            } else if (which.equals("controlEncoding")) {
                this.controlEncoding = value;
            } else if (which.equals("transfermode")) {
                this.transfermode = value;
            } else if (which.equals("defaultTimeout")) {
                this.defaultTimeout = Integer.valueOf(value);
            } else if (which.equals("sendBufferSize")) {
                int tmp;
                if (!value.equals("") && (tmp = Integer.valueOf(value).intValue()) > 0) {
                    this.sendBufferSize = tmp;
                }
            } else if (which.equals("receiveBufferSize")) {
                int tmp;
                if (!value.equals("") && (tmp = Integer.valueOf(value).intValue()) > 0) {
                    this.receiveBufferSize = tmp;
                }
            } else if (which.equals("activePassive")) {
                this.activePassive = value;
            } else if (which.equals("filetype")) {
                this.filetype = value;
            } else if (which.equals("server")) {
                this.server = value;
            } else if (which.equals("port")) {
                this.port = Integer.valueOf(value);
            } else if (which.equals("user")) {
                this.username = value;
            } else if (which.equals("username")) {
                this.username = value;
            } else if (which.equals("password")) {
                this.password = value;
            } else if (which.equals("account")) {
                this.account = value;
            } else if (which.equals("base_path")) {
                this.base_path = value;
            } else if (which.equals("sub_path")) {
                this.sub_path = value;
            } else if (which.equals("remote_path_separator")) {
                this.remote_path_separator = value;
            } else if (which.equals("excludeHiddenFiles")) {
                this.excludeHiddenFiles = Integer.valueOf(value);
            } else {
                option_ok = -1;
            }
            return option_ok;
        }

        public void resetOptions() {
            this.type = "ftp";
            this.controlEncoding = "UTF-8";
            this.transfermode = "stream";
            this.defaultTimeout = 10000;
            this.sendBufferSize = 16384;
            this.receiveBufferSize = 16384;
            this.activePassive = "active";
            this.filetype = "binary";
            this.server = "localhost";
            this.port = 0;
            this.username = "";
            this.password = "";
            this.account = "";
            this.base_path = "";
            this.sub_path = "";
            this.last_result_code = 0;
            this.last_result_text = "";
        }

        public int getResultCode() {
            return this.last_result_code;
        }

        public String getResultMessage() {
            return this.last_result_text;
        }

        public int getDefaultPort() {
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "FTP client not defined";
                return -1;
            }
            return this.ftp.getDefaultPort();
        }

        public int connectLogin() {
            int result;
            if (this.ftp != null) {
                this.disconnect();
            }
            if ((result = this.connect()) == 0) {
                result = this.login();
            }
            return result;
        }

        public int connect() {
            this.last_result_code = 0;
            this.last_result_text = "";
            this.ftp = this.type.equals("ftps") || this.type.equals("ftpes") ? new FTPSClient() : new FTPClient();
            if (this.sendBufferSize >= 0) {
                try {
                    this.ftp.setSendBufferSize(this.sendBufferSize);
                }
                catch (SocketException ex) {
                    this.last_result_code = -1;
                    this.last_result_text = ex.getMessage();
                }
            }
            if (this.receiveBufferSize >= 0) {
                try {
                    this.ftp.setReceiveBufferSize(this.receiveBufferSize);
                }
                catch (SocketException ex) {
                    this.last_result_code = -2;
                    this.last_result_text = ex.getMessage();
                }
            }
            if (!this.filetype.equals("ascii")) {
                int ft = 2;
                if (this.filetype.equals("binary")) {
                    ft = 2;
                }
                try {
                    this.ftp.setFileType(ft);
                }
                catch (IOException ex) {
                    this.last_result_code = -3;
                    this.last_result_text = ex.getMessage();
                }
            }
            if (!this.transfermode.equals("stream")) {
                int tm = 10;
                if (this.transfermode.equals("block")) {
                    tm = 11;
                } else if (this.transfermode.equals("block")) {
                    tm = 12;
                }
                try {
                    this.ftp.setFileTransferMode(tm);
                }
                catch (IOException ex) {
                    this.last_result_code = -4;
                    this.last_result_text = ex.getMessage();
                }
            }
            if (this.controlEncoding != null && !this.controlEncoding.equals("")) {
                this.ftp.setControlEncoding(this.controlEncoding);
            }
            try {
                if (this.port > 0) {
                    this.ftp.connect(this.server, this.port);
                } else {
                    this.ftp.connect(this.server);
                }
            }
            catch (IOException ex) {
                this.last_result_code = -5;
                this.last_result_text = ex.getMessage();
                return -5;
            }
            if (!FTPReply.isPositiveCompletion((int)this.ftp.getReplyCode())) {
                this.last_result_code = -6;
                this.last_result_text = "### ERROR Could not connect to: " + this.server + " port: " + this.port + ". Reply: " + this.ftp.getReplyString();
                return -6;
            }
            int actpass_set = this.activePassive.equals("active") ? this.setActive() : this.setPassive();
            if (actpass_set != 0 && DEBUG_FTP_QUEUE) {
                BatchXSLT.g_mainXSLTFrame.showMess("### ERROR connect(): Could not set '" + this.activePassive + "' mode.\n");
            }
            if (this.controlEncoding != null && !this.controlEncoding.equals("")) {
                if (this.controlEncoding.equals("UTF-8")) {
                    this.command("OPTS", "UTF8 ON");
                } else {
                    this.command("OPTS", "UTF8 OFF");
                }
                BatchXSLT.g_mainXSLTFrame.showMess(this.last_result_text + "\n");
            }
            this.loggedin = true;
            return 0;
        }

        public int disconnect() {
            this.last_result_code = 0;
            this.last_result_text = "";
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return 0;
            }
            try {
                this.ftp.disconnect();
            }
            catch (IOException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
            }
            this.ftp = null;
            this.connected = false;
            return 0;
        }

        public int login() {
            this.last_result_code = 0;
            this.last_result_text = "";
            boolean loggedin = false;
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return -1;
            }
            try {
                loggedin = !this.account.equals("") ? this.ftp.login(this.username, this.password, this.account) : this.ftp.login(this.username, this.password);
            }
            catch (IOException ex) {
                this.last_result_code = -2;
                this.last_result_text = ex.getMessage();
                return -3;
            }
            if (!loggedin) {
                this.last_result_code = -3;
                this.last_result_text = "ERROR -3 Could not login with username: '" + this.username + "' and password: '" + this.password + "'";
                return -3;
            }
            this.last_result_code = 0;
            this.last_result_text = "Successfully logged in.";
            loggedin = true;
            return 0;
        }

        public int logout() {
            this.last_result_code = 0;
            this.last_result_text = "";
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return -1;
            }
            try {
                this.ftp.logout();
            }
            catch (IOException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
            }
            this.loggedin = false;
            return 0;
        }

        public String[] doCommand(String command) {
            return this.doCommand(command, null);
        }

        public String[] doCommand(String command, String params) {
            String[] replies = null;
            this.last_result_code = 0;
            this.last_result_text = "";
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return null;
            }
            try {
                replies = this.ftp.doCommandAsStrings(command, params);
                if (replies == null) {
                    this.last_result_code = this.ftp.getReplyCode();
                    this.last_result_text = this.ftp.getReplyString();
                }
            }
            catch (IOException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
            }
            return replies;
        }

        public FTPFile[] listDir(String path) {
            FTPFile[] replies = null;
            this.last_result_code = 0;
            this.last_result_text = "";
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return null;
            }
            try {
                replies = this.ftp.mlistDir(path);
                if (replies == null) {
                    this.last_result_code = this.ftp.getReplyCode();
                    this.last_result_text = this.ftp.getReplyString();
                }
            }
            catch (IOException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
            }
            return replies;
        }

        public FTPFile listFile(String pathname) {
            FTPFile replies = null;
            this.last_result_code = 0;
            this.last_result_text = "";
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return null;
            }
            try {
                replies = this.ftp.mlistFile(pathname);
                if (replies == null) {
                    this.last_result_code = this.ftp.getReplyCode();
                    this.last_result_text = this.ftp.getReplyString();
                }
            }
            catch (IOException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
            }
            return replies;
        }

        public boolean mkdir(String dirname) {
            boolean success = false;
            this.last_result_code = 0;
            this.last_result_text = "";
            if (dirname.equals("")) {
                this.last_result_code = -2;
                this.last_result_text = "No directory name given";
                return false;
            }
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return false;
            }
            try {
                success = this.ftp.makeDirectory(dirname);
                if (!success) {
                    this.last_result_code = this.ftp.getReplyCode();
                    this.last_result_text = this.ftp.getReplyString();
                }
            }
            catch (IOException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
            }
            return success;
        }

        public boolean mkdirPath(String path) {
            this.last_result_code = 0;
            this.last_result_text = "";
            if (path.equals("")) {
                this.last_result_code = -2;
                this.last_result_text = "No path given";
                return false;
            }
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return false;
            }
            String[] path_parts = path.split("/");
            for (int i = 0; i < path_parts.length; ++i) {
                if (path_parts[i].equals("")) continue;
                boolean success = this.mkdir(path_parts[i]);
                if (DEBUG_FTP_CLIENT) {
                    BatchXSLT.g_mainXSLTFrame.showMess("======= mkdirPath success: " + success + " last_result_code: " + this.last_result_code + " : " + this.last_result_text + "\n");
                }
                if (!success && this.last_result_code != 550) {
                    return false;
                }
                success = this.cd(path_parts[i]);
                if (success) continue;
                return false;
            }
            return true;
        }

        public boolean rmdir(String pathname) {
            boolean success = false;
            this.last_result_code = 0;
            this.last_result_text = "";
            if (pathname.equals("")) {
                this.last_result_code = -2;
                this.last_result_text = "No path name name given";
                return false;
            }
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return false;
            }
            try {
                success = this.ftp.removeDirectory(pathname);
                if (!success) {
                    this.last_result_code = this.ftp.getReplyCode();
                    this.last_result_text = this.ftp.getReplyString();
                }
            }
            catch (IOException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
            }
            return success;
        }

        public boolean cd(String pathname) {
            boolean success = false;
            this.last_result_code = 0;
            this.last_result_text = "";
            if (pathname.equals("")) {
                this.last_result_code = -2;
                this.last_result_text = "No path name given";
                return false;
            }
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return false;
            }
            try {
                success = this.ftp.changeWorkingDirectory(pathname);
                if (!success) {
                    this.last_result_code = this.ftp.getReplyCode();
                    this.last_result_text = this.ftp.getReplyString();
                }
            }
            catch (IOException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
            }
            return success;
        }

        public String pwd() {
            String currwd = null;
            this.last_result_code = 0;
            this.last_result_text = "";
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return null;
            }
            try {
                currwd = this.ftp.printWorkingDirectory();
            }
            catch (IOException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
            }
            return currwd;
        }

        public boolean storeFile(String local_pathname, String remote_filename) {
            return this.storeFile(local_pathname, remote_filename, 2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean storeFile(String local_pathname, String remote_filename, int fileType) {
            boolean success = false;
            InputStream is = null;
            this.last_result_code = 0;
            this.last_result_text = "";
            if (remote_filename.equals("")) {
                this.last_result_code = -2;
                this.last_result_text = "No file name given";
                return false;
            }
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return false;
            }
            try {
                if (fileType != -9999) {
                    this.ftp.setFileType(fileType);
                }
                is = new FileInputStream(local_pathname);
                success = this.ftp.storeFile(remote_filename, is);
                try {
                    if (is != null) {
                        is.close();
                        is = null;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!success) {
                    this.last_result_code = this.ftp.getReplyCode();
                    this.last_result_text = this.ftp.getReplyString();
                }
            }
            catch (IOException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                        is = null;
                    }
                }
                catch (IOException iOException) {}
            }
            return success;
        }

        public boolean getFile(String remote_filename, String local_pathname) {
            return this.getFile(remote_filename, local_pathname, 2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getFile(String remote_filename, String local_pathname, int fileType) {
            boolean success = false;
            OutputStream os = null;
            this.last_result_code = 0;
            this.last_result_text = "";
            if (remote_filename.equals("")) {
                this.last_result_code = -2;
                this.last_result_text = "No file name given";
                return false;
            }
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return false;
            }
            try {
                this.ftp.setFileType(fileType);
                os = new FileOutputStream(local_pathname);
                success = this.ftp.retrieveFile(remote_filename, os);
                try {
                    if (os != null) {
                        os.flush();
                        os.close();
                        os = null;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!success) {
                    this.last_result_code = this.ftp.getReplyCode();
                    this.last_result_text = this.ftp.getReplyString();
                }
            }
            catch (IOException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                        os = null;
                    }
                }
                catch (IOException iOException) {}
            }
            return success;
        }

        public boolean renameFile(String from, String to) {
            boolean success = false;
            this.last_result_code = 0;
            this.last_result_text = "";
            if (from.equals("")) {
                this.last_result_code = -2;
                this.last_result_text = "No from name name given";
                return false;
            }
            if (to.equals("")) {
                this.last_result_code = -3;
                this.last_result_text = "No to name name given";
                return false;
            }
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return false;
            }
            try {
                success = this.ftp.rename(from, to);
                if (!success) {
                    this.last_result_code = this.ftp.getReplyCode();
                    this.last_result_text = this.ftp.getReplyString();
                }
            }
            catch (IOException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
            }
            return success;
        }

        public boolean existsFile(String remote_name) {
            this.last_result_code = 0;
            this.last_result_text = "";
            if (remote_name.equals("")) {
                this.last_result_code = -2;
                this.last_result_text = "No file or directory name given";
                return false;
            }
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return false;
            }
            try {
                FTPFile[] result = this.ftp.listFiles(remote_name);
                if (result == null || result.length == 0) {
                    return false;
                }
            }
            catch (IOException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
            }
            return true;
        }

        public boolean noop() {
            boolean success = false;
            this.last_result_code = 0;
            this.last_result_text = "";
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return false;
            }
            try {
                success = this.ftp.sendNoOp();
                if (!success) {
                    this.last_result_code = this.ftp.getReplyCode();
                    this.last_result_text = this.ftp.getReplyString();
                }
            }
            catch (IOException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
            }
            return success;
        }

        public String systemType() {
            String result = null;
            this.last_result_code = 0;
            this.last_result_text = "";
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return null;
            }
            try {
                result = this.ftp.getSystemType();
                if (result == null) {
                    this.last_result_code = this.ftp.getReplyCode();
                    this.last_result_text = this.ftp.getReplyString();
                }
            }
            catch (IOException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
            }
            return result;
        }

        public boolean getFeature(String feature) {
            boolean result = false;
            this.last_result_code = 0;
            this.last_result_text = "";
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return false;
            }
            try {
                result = this.ftp.hasFeature(feature);
            }
            catch (IOException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
            }
            return result;
        }

        public boolean getFeature(String feature, String value) {
            boolean result = false;
            this.last_result_code = 0;
            this.last_result_text = "";
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return false;
            }
            try {
                result = this.ftp.hasFeature(feature, value);
            }
            catch (IOException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
            }
            return result;
        }

        public int setSendBufferSize(int s) {
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return -1;
            }
            try {
                this.ftp.setSendBufferSize(s);
            }
            catch (SocketException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
                return -1;
            }
            return 0;
        }

        public int setReceiveBufferSize(int s) {
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return -1;
            }
            try {
                this.ftp.setReceiveBufferSize(s);
            }
            catch (SocketException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
                return -1;
            }
            return 0;
        }

        public int setPassive() {
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return -1;
            }
            this.ftp.enterLocalPassiveMode();
            if (!FTPReply.isPositiveCompletion((int)this.ftp.getReplyCode())) {
                this.last_result_code = -2;
                this.last_result_text = "### ERROR Could not enter into passive mode: " + this.ftp.getReplyString();
                return -2;
            }
            return 0;
        }

        public int setActive() {
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return -1;
            }
            this.ftp.enterLocalActiveMode();
            if (!FTPReply.isPositiveCompletion((int)this.ftp.getReplyCode())) {
                this.last_result_code = -2;
                this.last_result_text = "### ERROR Could not enter into active mode: " + this.ftp.getReplyString();
                return -2;
            }
            return 0;
        }

        public int controlEncoding(String encoding) {
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return -1;
            }
            this.ftp.setControlEncoding(encoding);
            if (!FTPReply.isPositiveCompletion((int)this.ftp.getReplyCode())) {
                this.last_result_code = -2;
                this.last_result_text = "### ERROR Could not control encoding to: " + encoding + ". Reply: " + this.ftp.getReplyString();
                return -2;
            }
            return 0;
        }

        public int command(String cmd, String params) {
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return -1;
            }
            if (params == null || params.equals("")) {
                try {
                    this.ftp.sendCommand(cmd);
                }
                catch (IOException ex) {
                    this.last_result_code = -2;
                    this.last_result_text = "### ERROR sending command; " + cmd;
                    return -2;
                }
            }
            try {
                this.ftp.sendCommand(cmd, params);
            }
            catch (IOException ex) {
                this.last_result_code = -2;
                this.last_result_text = "### ERROR sending command; " + cmd + " " + params;
                return -2;
            }
            this.last_result_code = this.ftp.getReplyCode();
            this.last_result_text = this.ftp.getReplyString();
            return 0;
        }

        public int setDataTimeout(int timeout) {
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return -1;
            }
            this.ftp.setDataTimeout(timeout);
            return 0;
        }

        public int getSocketTimeout() {
            if (this.ftp == null) {
                this.last_result_code = -1;
                this.last_result_text = "No FTP client available";
                return -1;
            }
            try {
                this.ftp.getSoTimeout();
            }
            catch (SocketException ex) {
                this.last_result_code = -1;
                this.last_result_text = ex.getMessage();
                return -1;
            }
            return 0;
        }

        public int putFileAsThread(String localPathName, String remoteFileName, boolean waitCompleted) {
            return this.putFileAsThread(localPathName, remoteFileName, 2, waitCompleted, -1);
        }

        public int putFileAsThread(String localPathName, String remoteFileName, int fileType, boolean waitCompleted, int destroyWhenDoneID) {
            long max_sleep = 8400000L;
            long sleep_interval = 300L;
            putFileThread pft = new putFileThread(localPathName, remoteFileName, fileType, destroyWhenDoneID);
            pft.start();
            if (waitCompleted) {
                for (long total_sleep = 0L; total_sleep < max_sleep; total_sleep += sleep_interval) {
                    try {
                        pft.join(sleep_interval);
                        sleep_interval = 30L;
                        if (pft.isAlive()) {
                            continue;
                        }
                        break;
                    }
                    catch (InterruptedException e) {
                        System.out.println("##### FTP Transfer EXCEPTION: " + e);
                        System.out.println("      for local file: '" + localPathName + "'\n");
                        System.out.println("      to remote file: '" + remoteFileName + "'\n");
                        break;
                    }
                }
            } else {
                return 0;
            }
            return this.putFileThread_returnvalue;
        }

        public int putFolder(String srcpath, String destpath, boolean recursive, boolean excludeHiddenFiles, boolean deletesource, boolean waitcompleted) {
            boolean f_deleted = false;
            Object my_destpath = destpath;
            int totalfiles = 0;
            File src = new File(srcpath);
            int max_reconnects = 5;
            boolean try_again = true;
            if (DEBUG_FTP_CLIENT) {
                BatchXSLT.g_mainXSLTFrame.showMess("*** putFolder srcpath: '" + srcpath + "'\n");
            }
            if (!src.exists()) {
                result_code = -1;
                result_text = "Source path does not exist";
                return result_code;
            }
            if (src.isDirectory()) {
                File[] srcFiles = src.listFiles();
                if (!((String)my_destpath).endsWith(this.remote_path_separator)) {
                    my_destpath = (String)my_destpath + this.remote_path_separator;
                }
                my_destpath = (String)my_destpath + src.getName();
                for (int i = 0; i < srcFiles.length; ++i) {
                    if (mainXSLTFrame.general_abort) {
                        return -99;
                    }
                    File file = srcFiles[i];
                    if (excludeHiddenFiles && file.getName().startsWith(".")) continue;
                    Object path = file.getParent();
                    if (!((String)path).endsWith(File.separator)) {
                        path = (String)path + File.separator;
                    }
                    String pathname = (String)path + file.getName();
                    if (file.isDirectory()) {
                        if (!recursive) continue;
                        this.putFolder(pathname, (String)my_destpath + this.remote_path_separator, recursive, excludeHiddenFiles, deletesource, waitcompleted);
                        File[] flist = file.listFiles();
                        if (flist.length > 0 || !deletesource) continue;
                        f_deleted = BatchXSLTransform.file_delete(pathname);
                        continue;
                    }
                    if (!file.isFile()) continue;
                    try_again = true;
                    while (try_again) {
                        boolean directory_created;
                        try_again = false;
                        if (DEBUG_FTP_CLIENT) {
                            BatchXSLT.g_mainXSLTFrame.showMess("*** putFolder remote_curdir requested: '" + (String)my_destpath + "', is: '" + this.remote_curdir + "'\n");
                        }
                        if (this.remote_curdir.equals("")) {
                            this.remote_curdir = this.pwd();
                            if (DEBUG_FTP_CLIENT) {
                                BatchXSLT.g_mainXSLTFrame.showMess("*** putFolder remote_curdir retrieved: '" + this.remote_curdir + "'\n");
                            }
                        } else if (DEBUG_FTP_CLIENT) {
                            BatchXSLT.g_mainXSLTFrame.showMess("*** putFolder remote_curdir is: '" + this.remote_curdir + "'\n");
                        }
                        if (!this.remote_curdir.equals(my_destpath)) {
                            this.cd("/");
                            directory_created = this.mkdirPath((String)my_destpath);
                            if (directory_created) {
                                this.remote_curdir = my_destpath;
                                if (DEBUG_FTP_CLIENT) {
                                    BatchXSLT.g_mainXSLTFrame.showMess("*** putFolder remote_curdir created: '" + this.remote_curdir + "\n");
                                }
                            } else {
                                BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR putFolder while creating remote path: " + (String)my_destpath + "\n");
                            }
                        } else {
                            directory_created = true;
                        }
                        if (DEBUG_FTP_CLIENT) {
                            BatchXSLT.g_mainXSLTFrame.showMess("*** putFolder remote_curdir: '" + this.remote_curdir + "'(" + this.remote_curdir.length() + "), my_destpath: '" + (String)my_destpath + "(" + ((String)my_destpath).length() + ")'\n");
                        }
                        if (!directory_created) continue;
                        String my_destfilename = file.getName();
                        BatchXSLT.g_mainXSLTFrame.showMess("*** putFolder src: " + pathname + " to: " + (String)my_destpath + " as '" + my_destfilename + "'\n");
                        boolean stored = this.storeFile(pathname, my_destfilename);
                        if (!stored) {
                            BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR putFolder: " + this.last_result_code + " : " + this.last_result_text + "\n");
                            BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR putFolder source file: " + pathname + ", target path: " + (String)my_destpath + " as file '" + my_destfilename + "'\n");
                            this.remote_curdir = "";
                            if (--max_reconnects > 0) {
                                BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR - reconnecting...\n");
                                int result = this.connectLogin();
                                if (result == 0) {
                                    try_again = true;
                                    continue;
                                }
                                BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR - could not re-connect. code: " + result + "\n");
                            }
                            this.last_result_code = this.ftp.getReplyCode();
                            this.last_result_text = this.ftp.getReplyString();
                        }
                        ++totalfiles;
                        if (!deletesource) continue;
                        f_deleted = BatchXSLTransform.file_delete(pathname);
                    }
                }
            } else {
                boolean directory_created;
                if (excludeHiddenFiles && src.getName().startsWith(".")) {
                    return 0;
                }
                Object path = src.getParent();
                if (!((String)path).endsWith(File.separator)) {
                    path = (String)path + File.separator;
                }
                if (DEBUG_FTP_CLIENT) {
                    BatchXSLT.g_mainXSLTFrame.showMess("*** putFolder remote_curdir requested: '" + (String)my_destpath + "', is: '" + this.remote_curdir + "'\n");
                }
                if (this.remote_curdir.equals("")) {
                    this.remote_curdir = this.pwd();
                    if (DEBUG_FTP_CLIENT) {
                        BatchXSLT.g_mainXSLTFrame.showMess("*** putFolder remote_curdir retrieved: '" + this.remote_curdir + "'\n");
                    }
                } else if (DEBUG_FTP_CLIENT) {
                    BatchXSLT.g_mainXSLTFrame.showMess("*** putFolder remote_curdir is: '" + this.remote_curdir + "'\n");
                }
                if (!this.remote_curdir.equals(my_destpath)) {
                    this.cd("/");
                    directory_created = this.mkdirPath((String)my_destpath);
                    if (directory_created) {
                        this.remote_curdir = my_destpath;
                        if (DEBUG_FTP_CLIENT) {
                            BatchXSLT.g_mainXSLTFrame.showMess("*** putFolder remote_curdir created: '" + this.remote_curdir + "'\n");
                        }
                    } else {
                        BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR putFolder while creating remote path: " + (String)my_destpath + "\n");
                    }
                } else {
                    directory_created = true;
                }
                if (DEBUG_FTP_CLIENT) {
                    BatchXSLT.g_mainXSLTFrame.showMess("*** putFolder remote_curdir: '" + this.remote_curdir + "'(" + this.remote_curdir.length() + "), my_destpath: '" + (String)my_destpath + "(" + ((String)my_destpath).length() + ")'\n");
                }
                if (directory_created) {
                    boolean stored;
                    String pathname = (String)path + src.getName();
                    String my_destfilename = src.getName();
                    if (DEBUG_FTP_CLIENT) {
                        BatchXSLT.g_mainXSLTFrame.showMess("*** putFolder src: " + pathname + ", my_destpath: " + (String)my_destpath + " as '" + my_destfilename + "'\n");
                    }
                    if (!(stored = this.storeFile(pathname, my_destfilename))) {
                        this.last_result_code = this.ftp.getReplyCode();
                        this.last_result_text = this.ftp.getReplyString();
                        BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR putFolder: " + this.last_result_code + " : " + this.last_result_text + "\n");
                        BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR putFolder source file: " + pathname + ", target path: " + (String)my_destpath + " as file '" + my_destfilename + "'\n");
                    }
                    ++totalfiles;
                    if (deletesource) {
                        f_deleted = BatchXSLTransform.file_delete(pathname);
                    }
                }
            }
            BatchXSLT.g_mainXSLTFrame.showMess("*** putFolder totalfiles: " + totalfiles + "\n");
            return 0;
        }

        class putFileThread
        extends Thread {
            String localFileName;
            String remoteFileName;
            int fileType;
            int destroyWhenDoneID;

            putFileThread(String localFileName, String remoteFileName, int fileType, int destroyWhenDoneID) {
                this.localFileName = localFileName;
                this.remoteFileName = remoteFileName;
                this.fileType = fileType;
                this.destroyWhenDoneID = destroyWhenDoneID;
            }

            @Override
            public void run() {
                long startticks = Calendar.getInstance().getTimeInMillis();
                File f = new File(this.localFileName);
                long f_length = f.length();
                Thread.currentThread().setName("putFileThread");
                ftpClient.this.putFileThread_isrunning = true;
                boolean success_transfer = ftpClient.this.storeFile(this.localFileName, this.remoteFileName, this.fileType);
                ftpClient.this.putFileThread_returnvalue = success_transfer ? 0 : -1;
                ftpClient.this.putFileThread_isrunning = false;
                long endticks = Calendar.getInstance().getTimeInMillis();
                long transfernms = endticks - startticks;
                if (success_transfer) {
                    ftpClient.this.last_result_code = ftpClient.this.ftp.getReplyCode();
                    ftpClient.this.last_result_text = ftpClient.this.ftp.getReplyString();
                    BatchXSLT.g_mainXSLTFrame.showMess("*** putFileThread file successfully sent: '" + this.localFileName + "' to remote: '" + this.remoteFileName + "'\n");
                } else {
                    BatchXSLT.g_mainXSLTFrame.showMess("### ERROR putFileThread: " + ftpClient.this.last_result_text + "\n");
                }
                if (this.destroyWhenDoneID >= 0) {
                    if (DEBUG_FTP_CLIENT) {
                        BatchXSLT.g_mainXSLTFrame.showMess("*** FTP transfer id: " + this.destroyWhenDoneID + " complete. Success: " + success_transfer + ", File: " + this.localFileName + ", Size: " + f_length + " bytes in " + transfernms + " ms. sendBufferSize: " + ftpClient.this.sendBufferSize + " bytes\n");
                    }
                    com.epaperarchives.batchxslt.ftp.disconnectDestroyFTPClient(this.destroyWhenDoneID);
                }
            }
        }
    }

    private static class ftp_sendQueueThread
    extends Thread {
        ftp_sendQueueThread() {
        }

        @Override
        public void run() {
            boolean go_on = true;
            boolean hasEntries = false;
            String type = "ftp";
            String controlEncoding = "UTF-8";
            String transfermode = "stream";
            String defaultTimeout = "10000";
            String sendBufferSize = "16384";
            String receiveBufferSize = "16384";
            String activePassive = "active";
            String filetype = "binary";
            String server = "localhost";
            String port = "0";
            String username = "";
            String password = "";
            String account = "";
            String base_path = "";
            String sub_path = "";
            String src_pathname = "";
            String remote_path = "";
            String remote_filename = "";
            String remote_curdir = "";
            ftpClient ftpc = null;
            int ftpc_id = -1;
            Thread.currentThread().setName("ftp_sendQueueThread");
            if (DEBUG_FTP_QUEUE) {
                BatchXSLT.g_mainXSLTFrame.showMess("****** ftp_sendQueueThread running\n");
            }
            ftp_sendQueueThread_isrunning = true;
            while (go_on) {
                if (ftp_sendQueue.size() > 0) {
                    boolean directory_created;
                    Element elem;
                    Document doc;
                    DocumentBuilder db;
                    String xml_queueElement = ftp_sendQueue.get(0);
                    if (DEBUG_FTP_QUEUE) {
                        BatchXSLT.g_mainXSLTFrame.showMess("*** ftp_sendQueueThread xml_queueElement: " + xml_queueElement + "\n");
                    }
                    try {
                        db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    }
                    catch (ParserConfigurationException ex) {
                        if (DEBUG_FTP_QUEUE) {
                            BatchXSLT.g_mainXSLTFrame.showMess("### ERROR ftp_sendQueueThread; " + ex.getMessage() + "\n");
                        }
                        ftp_sendQueue.remove(0);
                        continue;
                    }
                    InputSource is = new InputSource();
                    is.setCharacterStream(new StringReader(xml_queueElement));
                    try {
                        doc = db.parse(is);
                    }
                    catch (SAXException ex) {
                        if (DEBUG_FTP_QUEUE) {
                            BatchXSLT.g_mainXSLTFrame.showMess("### ERROR ftp_sendQueueThread: " + ex.getMessage() + "\n");
                        }
                        ftp_sendQueue.remove(0);
                        continue;
                    }
                    catch (IOException ex) {
                        if (DEBUG_FTP_QUEUE) {
                            BatchXSLT.g_mainXSLTFrame.showMess("### ERROR ftp_sendQueueThread: " + ex.getMessage() + "\n");
                        }
                        ftp_sendQueue.remove(0);
                        continue;
                    }
                    NodeList nodes = doc.getElementsByTagName("type");
                    if (nodes != null && (elem = (Element)nodes.item(0)) != null) {
                        type = ftp.myGetNodeValue(elem);
                    }
                    if ((nodes = doc.getElementsByTagName("controlEncoding")) != null && (elem = (Element)nodes.item(0)) != null) {
                        controlEncoding = ftp.myGetNodeValue(elem);
                    }
                    if ((nodes = doc.getElementsByTagName("transfermode")) != null && (elem = (Element)nodes.item(0)) != null) {
                        transfermode = ftp.myGetNodeValue(elem);
                    }
                    if ((nodes = doc.getElementsByTagName("defaultTimeout")) != null && (elem = (Element)nodes.item(0)) != null) {
                        defaultTimeout = ftp.myGetNodeValue(elem);
                    }
                    if ((nodes = doc.getElementsByTagName("filetype")) != null && (elem = (Element)nodes.item(0)) != null) {
                        filetype = ftp.myGetNodeValue(elem);
                    }
                    if ((nodes = doc.getElementsByTagName("activePassive")) != null && (elem = (Element)nodes.item(0)) != null) {
                        activePassive = ftp.myGetNodeValue(elem);
                    }
                    if ((nodes = doc.getElementsByTagName("server")) != null && (elem = (Element)nodes.item(0)) != null) {
                        server = ftp.myGetNodeValue(elem);
                    }
                    if ((nodes = doc.getElementsByTagName("port")) != null && (elem = (Element)nodes.item(0)) != null) {
                        port = ftp.myGetNodeValue(elem);
                    }
                    if ((nodes = doc.getElementsByTagName("src_pathname")) != null && (elem = (Element)nodes.item(0)) != null) {
                        src_pathname = ftp.myGetNodeValue(elem);
                    }
                    if ((nodes = doc.getElementsByTagName("remote_path")) != null && (elem = (Element)nodes.item(0)) != null) {
                        remote_path = ftp.myGetNodeValue(elem);
                    }
                    if ((nodes = doc.getElementsByTagName("remote_filename")) != null && (elem = (Element)nodes.item(0)) != null) {
                        remote_filename = ftp.myGetNodeValue(elem);
                    }
                    if ((nodes = doc.getElementsByTagName("base_path")) != null && (elem = (Element)nodes.item(0)) != null) {
                        base_path = ftp.myGetNodeValue(elem);
                    }
                    if ((nodes = doc.getElementsByTagName("sub_path")) != null && (elem = (Element)nodes.item(0)) != null) {
                        sub_path = ftp.myGetNodeValue(elem);
                    }
                    if ((nodes = doc.getElementsByTagName("username")) != null && (elem = (Element)nodes.item(0)) != null) {
                        username = ftp.myGetNodeValue(elem);
                    }
                    if ((nodes = doc.getElementsByTagName("password")) != null && (elem = (Element)nodes.item(0)) != null) {
                        password = ftp.myGetNodeValue(elem);
                    }
                    if ((nodes = doc.getElementsByTagName("account")) != null && (elem = (Element)nodes.item(0)) != null) {
                        account = ftp.myGetNodeValue(elem);
                    }
                    if (src_pathname == null || server == null || remote_path == null || remote_filename == null) {
                        if (DEBUG_FTP_QUEUE) {
                            BatchXSLT.g_mainXSLTFrame.showMess("### ERROR ftp_sendQueueThread: invali params\n");
                        }
                        ftp_sendQueue.remove(0);
                        continue;
                    }
                    File f = new File(src_pathname);
                    if (!f.exists()) {
                        if (DEBUG_FTP_QUEUE) {
                            BatchXSLT.g_mainXSLTFrame.showMess("### ERROR ftp_sendQueueThread: file not exists: " + src_pathname + "\n");
                        }
                        ftp_sendQueue.remove(0);
                        continue;
                    }
                    if (ftpc == null) {
                        int loggedin;
                        int actpass_set;
                        int connected;
                        if (DEBUG_FTP_QUEUE) {
                            BatchXSLT.g_mainXSLTFrame.showMess("*** ftp_sendQueueThread: INIT connection.\n");
                        }
                        if ((ftpc = ftp.newFTPClient()) == null) {
                            if (!DEBUG_FTP_QUEUE) break;
                            BatchXSLT.g_mainXSLTFrame.showMess("### ERROR ftp_sendQueueThread: No ftpClient available. waiting...\n");
                            break;
                        }
                        ftpc_id = ftp.getFTPClientID(ftpc);
                        if (DEBUG_FTP_QUEUE) {
                            BatchXSLT.g_mainXSLTFrame.showMess("*** ftp_sendQueueThread Connection id: " + ftpc_id + ".\n");
                        }
                        if (DEBUG_FTP_QUEUE) {
                            BatchXSLT.g_mainXSLTFrame.showMess("*** ftp_sendQueueThread setting options.\n");
                        }
                        if (type != null) {
                            ftpc.setOption("type", type);
                        }
                        if (controlEncoding != null) {
                            ftpc.setOption("controlEncoding", controlEncoding);
                        }
                        if (transfermode != null) {
                            ftpc.setOption("transfermode", transfermode);
                        }
                        if (defaultTimeout != null) {
                            ftpc.setOption("defaultTimeout", defaultTimeout);
                        }
                        if (activePassive != null) {
                            ftpc.setOption("activePassive", activePassive);
                        }
                        if (filetype != null) {
                            ftpc.setOption("filetype", filetype);
                        }
                        if (server != null) {
                            ftpc.setOption("server", server);
                        }
                        if (port != null) {
                            ftpc.setOption("port", port);
                        }
                        if (username != null) {
                            ftpc.setOption("user", username);
                        }
                        if (password != null) {
                            ftpc.setOption("password", password);
                        }
                        if (account != null) {
                            ftpc.setOption("account", account);
                        }
                        if (base_path != null) {
                            ftpc.setOption("base_path", base_path);
                        }
                        if (sub_path != null) {
                            ftpc.setOption("sub_path", sub_path);
                        }
                        if (controlEncoding != null && !controlEncoding.equals("")) {
                            ftpc.controlEncoding(controlEncoding);
                        }
                        if (DEBUG_FTP_QUEUE) {
                            BatchXSLT.g_mainXSLTFrame.showMess("*** ftp_sendQueueThread connecting to server: " + server + "\n");
                        }
                        if ((connected = ftpc.connect()) != 0) {
                            if (DEBUG_FTP_QUEUE) {
                                BatchXSLT.g_mainXSLTFrame.showMess("### ERROR ftp_sendQueueThread: Could not connect to FTP server\n");
                            }
                            ftp_sendQueue.remove(0);
                            continue;
                        }
                        if (DEBUG_FTP_QUEUE) {
                            BatchXSLT.g_mainXSLTFrame.showMess("*** ftp_sendQueueThread connected.\n");
                        }
                        if (activePassive != null && (actpass_set = activePassive.equals("active") ? ftpc.setActive() : ftpc.setPassive()) != 0 && DEBUG_FTP_QUEUE) {
                            BatchXSLT.g_mainXSLTFrame.showMess("### ERROR ftp_sendQueueThread: Could not set '" + activePassive + "' mode.\n");
                        }
                        if (controlEncoding != null && !controlEncoding.equals("")) {
                            if (controlEncoding.equals("UTF-8")) {
                                ftpc.command("OPTS", "UTF8 ON");
                            } else {
                                ftpc.command("OPTS", "UTF8 OFF");
                            }
                            BatchXSLT.g_mainXSLTFrame.showMess(ftpc.last_result_text + "\n");
                        }
                        if (DEBUG_FTP_QUEUE) {
                            BatchXSLT.g_mainXSLTFrame.showMess("*** ftp_sendQueueThread logging in as user: " + username + "\n");
                        }
                        if ((loggedin = ftpc.login()) != 0) {
                            if (DEBUG_FTP_QUEUE) {
                                BatchXSLT.g_mainXSLTFrame.showMess("### ERROR ftp_sendQueueThread: Could not login to FTP server\n");
                            }
                            ftp_sendQueue.remove(0);
                            continue;
                        }
                        if (DEBUG_FTP_QUEUE) {
                            BatchXSLT.g_mainXSLTFrame.showMess("*** ftp_sendQueueThread logged in.\n");
                        }
                    }
                    if (DEBUG_FTP_QUEUE) {
                        BatchXSLT.g_mainXSLTFrame.showMess("*** ftp_sendQueueThread QUEUEING: " + src_pathname + ", remote_path" + remote_path + "\n");
                    }
                    boolean success_transfer = true;
                    if (DEBUG_FTP_CLIENT) {
                        BatchXSLT.g_mainXSLTFrame.showMess("*** ftp_sendQueueThread remote_curdir requested: '" + remote_path + "', is: '" + remote_curdir + "'\n");
                    }
                    if (remote_curdir.equals("")) {
                        remote_curdir = ftpc.pwd();
                        if (DEBUG_FTP_CLIENT) {
                            BatchXSLT.g_mainXSLTFrame.showMess("*** ftp_sendQueueThread remote remote_curdir retrieved: '" + remote_curdir + "'\n");
                        }
                    } else if (DEBUG_FTP_CLIENT) {
                        BatchXSLT.g_mainXSLTFrame.showMess("*** ftp_sendQueueThread remote remote_curdir is: '" + remote_curdir + "'\n");
                    }
                    if (!remote_curdir.equals(remote_path)) {
                        ftpc.cd("/");
                        directory_created = ftpc.mkdirPath(remote_path);
                        if (directory_created) {
                            remote_curdir = remote_path;
                            if (DEBUG_FTP_CLIENT) {
                                BatchXSLT.g_mainXSLTFrame.showMess("*** ftp_sendQueueThread remote remote_curdir created: '" + remote_curdir + "'\n");
                            }
                        } else {
                            BatchXSLT.g_mainXSLTFrame.showMess("#### ERROR ftp_sendQueueThread while creating remote path: " + remote_path + "\n");
                        }
                    } else {
                        directory_created = true;
                    }
                    if (directory_created) {
                        if (DEBUG_FTP_QUEUE) {
                            BatchXSLT.g_mainXSLTFrame.showMess("*** ftp_sendQueueThread PUT file: '" + src_pathname + "' to remote: '" + remote_filename + "' type: '" + filetype + "'\n");
                        }
                        success_transfer = ftpc.storeFile(src_pathname, remote_filename);
                    }
                    if (success_transfer) {
                        BatchXSLT.g_mainXSLTFrame.showMess("*** ftp_sendQueueThread file successfully sent: '" + src_pathname + "' to remote: '" + remote_filename + "' type: '" + filetype + "'\n");
                    } else {
                        BatchXSLT.g_mainXSLTFrame.showMess("### ERROR ftp_sendQueueThread: " + ftpc.last_result_text + "\n");
                    }
                    ftp_sendQueue.remove(0);
                }
                if (ftp_sendQueue.isEmpty()) {
                    if (ftpc_id >= 0) {
                        ftp.disconnectDestroyFTPClient(ftpc_id);
                    }
                    go_on = false;
                    continue;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ftp_sendQueueThread_returnvalue = 0;
            ftp_sendQueueThread_isrunning = false;
            if (DEBUG_FTP_QUEUE) {
                BatchXSLT.g_mainXSLTFrame.showMess("****** ftp_sendQueueThread QUIT\n");
            }
        }
    }
}

