/*
 * Decompiled with CFR 0.152.
 */
package com.epaperarchives.browser;

import com.epaperarchives.batchxslt.utils;
import java.awt.Desktop;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;

public class BrowserLaunch {
    static final String[] browsers = new String[]{"firefox", "opera", "safari", "konqueror", "epiphany", "seamonkey", "galeon", "kazehakase", "mozilla", "netscape"};
    private static final String errMsg = "Sorry, could not launch your standard web browser";
    private static final String errMsg2 = "Sorry, could not open  file";

    public static void openURL(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
            return;
        }
        catch (Exception ex) {
            try {
                Desktop.getDesktop().open(new File(url));
                return;
            }
            catch (Exception ex1) {
                utils.showMess("Sorry, could not open  file:\n" + ex1.getLocalizedMessage() + "\n");
                String osName = System.getProperty("os.name");
                try {
                    if (osName.startsWith("Mac OS")) {
                        Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                        Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                        openURL.invoke(null, url);
                    } else if (osName.startsWith("Windows")) {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                    } else {
                        String browser = null;
                        for (int count = 0; count < browsers.length && browser == null; ++count) {
                            if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                            browser = browsers[count];
                        }
                        if (browser == null) {
                            throw new Exception("Could not find web browser");
                        }
                        Runtime.getRuntime().exec(new String[]{browser, url});
                    }
                }
                catch (Exception ex2) {
                    utils.showMess("Sorry, could not launch your standard web browser:\n" + ex2.getLocalizedMessage() + "\n");
                }
                return;
            }
        }
    }
}

