/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.net.DaytimeTCPClient;
import org.apache.commons.net.DaytimeUDPClient;

public final class daytime {
    public static final String daytimeTCP(String host) throws IOException {
        DaytimeTCPClient client = new DaytimeTCPClient();
        client.setDefaultTimeout(6000);
        client.connect(host);
        String time = client.getTime().trim();
        client.disconnect();
        return time;
    }

    public static final void daytimeUDP(String host) throws IOException {
        DaytimeUDPClient client = new DaytimeUDPClient();
        client.setDefaultTimeout(3000);
        client.open();
        System.out.println(client.getTime(InetAddress.getByName(host)).trim());
        client.close();
    }

    public static final void main(String[] args) {
        if (args.length == 1) {
            try {
                daytime.daytimeTCP(args[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else if (args.length == 2 && args[0].equals("-udp")) {
            try {
                daytime.daytimeUDP(args[1]);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            System.err.println("Usage: daytime [-udp] <hostname>");
            System.exit(1);
        }
    }
}

