/*
 * Decompiled with CFR 0.152.
 */
package com.hatop.filters;

import com.hatop.sxql.database.DataFace;
import com.hatop.sxql.database.DataSession;
import com.hatop.sxql.transformer.SQLtransformer;
import com.hatop.sxql.transformer.SXsubst;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;

public final class SQLFilter
implements Filter {
    private static final String myself = "SQLFilter";
    private FilterConfig filterConfig = null;
    private String dbprops = null;

    public void destroy() {
        this.filterConfig = null;
    }

    public String toString() {
        if (this.filterConfig == null) {
            return "SQLFilter()";
        }
        StringBuffer stringBuffer = new StringBuffer("SQLFilter(");
        stringBuffer.append(this.filterConfig);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        String string = filterConfig.getInitParameter("database");
        this.dbprops = filterConfig.getServletContext().getRealPath(string);
        this.filterConfig.getServletContext().log("SQLFilter initialized with " + this.dbprops);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.filterConfig == null) {
            return;
        }
        this.transform((HttpServletRequest)servletRequest);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void transform(HttpServletRequest httpServletRequest) {
        block9: {
            this.filterConfig.getServletContext().log("SQLFilter transforming...");
            Document document = (Document)httpServletRequest.getAttribute("document");
            if (document == null) {
                this.filterConfig.getServletContext().log("SQLFilter null doc");
                return;
            }
            Hashtable hashtable = (Hashtable)httpServletRequest.getAttribute("params");
            SXsubst sXsubst = new SXsubst("sql");
            sXsubst.setQuery(document, hashtable);
            DataFace dataFace = this.getDataFace(httpServletRequest);
            Connection connection = null;
            connection = dataFace.getConnection();
            SQLtransformer sQLtransformer = new SQLtransformer(connection, "sql");
            sQLtransformer.transform(document);
            Object var9_9 = null;
            try {
                dataFace.releaseConnection(connection);
            }
            catch (Exception exception) {
                this.filterConfig.getServletContext().log("SQLFilter: " + exception.toString());
            }
            break block9;
            {
                catch (Exception exception) {
                    this.filterConfig.getServletContext().log("SQLFilter: " + exception.toString());
                    Object var9_10 = null;
                    try {
                        dataFace.releaseConnection(connection);
                    }
                    catch (Exception exception2) {
                        this.filterConfig.getServletContext().log("SQLFilter: " + exception2.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    dataFace.releaseConnection(connection);
                }
                catch (Exception exception) {
                    this.filterConfig.getServletContext().log("SQLFilter: " + exception.toString());
                }
                throw throwable;
            }
        }
    }

    private DataFace getDataFace(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession();
        DataFace dataFace = (DataFace)httpSession.getAttribute("database");
        if (dataFace != null) {
            return dataFace;
        }
        String string = (String)httpServletRequest.getAttribute("docbase");
        if (this.dbprops == null) {
            this.dbprops = "Database.properties";
        }
        String string2 = this.dbprops;
        this.filterConfig.getServletContext().log("SQLFilter: loading " + string2);
        Properties properties = null;
        try {
            properties = new Properties();
            properties.load(new FileInputStream(new File(string2)));
        }
        catch (IOException iOException) {
            this.filterConfig.getServletContext().log("SQLFilter: " + iOException.toString());
        }
        this.filterConfig.getServletContext().log("SQLFilter: making new database accessor");
        DataSession dataSession = new DataSession();
        dataSession.init(properties);
        httpSession.setAttribute("database", (Object)dataSession);
        return dataSession;
    }
}

