/*
 * Decompiled with CFR 0.152.
 */
package com.hatop.filters;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.serialize.SerializerFactory;
import org.apache.xalan.templates.OutputProperties;
import org.w3c.dom.Document;

public final class XSLTFilter
implements Filter {
    private FilterConfig filterConfig = null;
    static String Sep = System.getProperty("file.separator");
    private static String myself = "XSLTFilter";
    static HashMap cache = new HashMap(5);
    static boolean doCache = true;
    TransformerFactory tFactory = TransformerFactory.newInstance();
    Properties xsltmap;

    public void destroy() {
        this.filterConfig = null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        String string = filterConfig.getServletContext().getRealPath("") + Sep + filterConfig.getInitParameter("xsltmap");
        this.filterConfig.getServletContext().log(myself + " initialized with " + string);
        try {
            this.xsltmap = new Properties();
            this.xsltmap.load(new FileInputStream(new File(string)));
        }
        catch (IOException iOException) {
            filterConfig.getServletContext().log(myself + ": " + iOException.toString());
        }
        if ("off".equals(filterConfig.getInitParameter("cache"))) {
            doCache = false;
            filterConfig.getServletContext().log(myself + ": caching is off.");
        }
    }

    public String toString() {
        if (this.filterConfig == null) {
            return myself;
        }
        StringBuffer stringBuffer = new StringBuffer(myself + "(");
        stringBuffer.append(this.filterConfig);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.filterConfig == null) {
            return;
        }
        Document document = (Document)servletRequest.getAttribute("document");
        if (document == null) {
            this.filterConfig.getServletContext().log(myself + ": null doc");
            return;
        }
        String string = (String)servletRequest.getAttribute("docbase");
        if (string == null) {
            this.filterConfig.getServletContext().log(myself + ": no docbase, no result");
            return;
        }
        String string2 = (String)servletRequest.getAttribute("sheetname");
        if (string2 == null) {
            string2 = this.getSheet(servletRequest);
        }
        PrintWriter printWriter = servletResponse.getWriter();
        Transformer transformer = this.getTransformer(string, string2);
        if (transformer != null) {
            this.transform(document, transformer, printWriter);
        } else {
            this.filterConfig.getServletContext().log(myself + ": no transformer, will serialize doc");
            this.serialize(document, printWriter);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transformer getTransformer(String string, String string2) {
        Object object;
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            this.filterConfig.getServletContext().log(myself + ":found no sheet, can make no transformer");
            return null;
        }
        Transformer transformer = null;
        if (doCache && (object = cache.get(string2)) != null) {
            try {
                transformer = ((Templates)object).newTransformer();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                this.filterConfig.getServletContext().log(myself + ": " + transformerConfigurationException.toString());
            }
        }
        if (transformer == null) {
            this.filterConfig.getServletContext().log(myself + "parsing " + string + string2);
            try {
                object = this.tFactory.newTemplates(new StreamSource(new File(string + string2)));
                HashMap hashMap = cache;
                synchronized (hashMap) {
                    cache.put(string2, object);
                }
                transformer = object.newTransformer();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                this.filterConfig.getServletContext().log(myself + ": " + transformerConfigurationException.toString());
                return null;
            }
        }
        return transformer;
    }

    private void transform(Document document, Transformer transformer, PrintWriter printWriter) {
        if (transformer != null) {
            try {
                transformer.transform(new DOMSource(document), new StreamResult(printWriter));
            }
            catch (Exception exception) {
                this.filterConfig.getServletContext().log(myself + ": " + exception.toString());
            }
        } else {
            this.filterConfig.getServletContext().log(myself + ":serializing document");
            this.serialize(document, printWriter);
        }
    }

    private void serialize(Document document, PrintWriter printWriter) {
        try {
            Serializer serializer = SerializerFactory.getSerializer((Properties)OutputProperties.getDefaultMethodProperties((String)"xml"));
            serializer.setWriter((Writer)printWriter);
            DOMResult dOMResult = new DOMResult(document.getDocumentElement());
            serializer.asDOMSerializer().serialize(dOMResult.getNode());
        }
        catch (IOException iOException) {
            this.filterConfig.getServletContext().log(myself + ": " + iOException.toString());
        }
    }

    private String getSheet(ServletRequest servletRequest) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String string = (String)httpServletRequest.getAttribute("docbase");
        String string2 = httpServletRequest.getPathInfo();
        String string3 = string2.substring(0, string2.lastIndexOf(46));
        String string4 = string3 + ".xsl";
        this.filterConfig.getServletContext().log(myself + ": " + string + string4);
        if (new File(string + string4).exists()) {
            return string4;
        }
        if (this.xsltmap.containsKey(string3.substring(1))) {
            string4 = System.getProperty("file.separator") + (String)this.xsltmap.get(string3.substring(1));
            if (new File(string + string4).exists()) {
                httpServletRequest.setAttribute("sheetname", (Object)string4);
                return string4;
            }
        }
        if (new File(string + "default.xsl").exists()) {
            return "default.xsl";
        }
        return null;
    }
}

