/*
 * Decompiled with CFR 0.152.
 */
package com.hatop.sxql;

import com.hatop.sxql.Logger;
import com.hatop.sxql.helpers.EndsWithFilter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XTransform
implements ErrorHandler {
    private String[] entries;
    private static final String logfile = "xerrors.log";
    private boolean validate = false;
    private String outSuffix = ".html";
    private static String myself = "XTransform";
    private boolean isValid = true;

    private int scan_directory(String string) {
        try {
            File file = new File(string);
            if (!file.isDirectory()) {
                return 1;
            }
            EndsWithFilter endsWithFilter = new EndsWithFilter(".xml");
            this.entries = file.list(endsWithFilter);
        }
        catch (Exception exception) {
            Logger.log(3, exception);
        }
        return 0;
    }

    private boolean transform(String string, DocumentBuilder documentBuilder, Transformer transformer, String string2) {
        Logger.log(8, myself, "processing " + string);
        PrintWriter printWriter = null;
        File file = null;
        try {
            if (string2 == null) {
                printWriter = new PrintWriter(System.out);
            } else {
                file = new File(string2);
            }
            File file2 = new File(string);
            if (file != null && file2.lastModified() < file.lastModified()) {
                Logger.log(5, myself, "making nothing: " + string2);
                return true;
            }
            Document document = documentBuilder.parse(file2);
            if (!this.isValid) {
                return false;
            }
            Logger.log(8, myself, "creating: " + string2);
            if (printWriter == null) {
                FileWriter fileWriter = new FileWriter(file);
                printWriter = new PrintWriter(fileWriter);
            }
            Logger.log(2, myself, string + " --> " + string2);
            transformer.transform(new DOMSource(document), new StreamResult(printWriter));
        }
        catch (Exception exception) {
            Logger.log(3, exception);
            return false;
        }
        return true;
    }

    private void doMain(String string, String string2, String string3) {
        Object object;
        String string4 = System.getProperty("file.separator");
        Logger.log(4, myself, "doMain " + string);
        Transformer transformer = null;
        DocumentBuilder documentBuilder = null;
        try {
            object = TransformerFactory.newInstance();
            transformer = ((TransformerFactory)object).newTransformer(new StreamSource(string2));
        }
        catch (Exception exception) {
            Logger.log(3, exception);
            Logger.log(1, myself, "no transformer for " + string2 + " :" + exception.getMessage());
        }
        try {
            object = DocumentBuilderFactory.newInstance();
            if (this.validate) {
                ((DocumentBuilderFactory)object).setValidating(true);
            } else {
                ((DocumentBuilderFactory)object).setValidating(false);
            }
            documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            documentBuilder.setErrorHandler(this);
        }
        catch (Exception exception) {
            Logger.log(3, exception);
            Logger.log(1, myself, "no transformer for " + string2 + " :" + exception.getMessage());
        }
        try {
            if (this.scan_directory(string) == 0) {
                Logger.log(1, myself, "processing xml repository");
                int n = 0;
                while (n < this.entries.length) {
                    int n2 = this.entries[n].length() - 4;
                    String string5 = new String(this.entries[n].substring(0, n2));
                    String string6 = new String(string + string4 + this.entries[n]);
                    if (string3 != null) {
                        String string7 = new String(string3 + string4 + string5 + this.outSuffix);
                        this.transform(string6, documentBuilder, transformer, string7);
                    } else {
                        this.transform(string6, documentBuilder, transformer, null);
                    }
                    if (!this.isValid) {
                        Logger.log(1, myself, "please fix errors");
                        return;
                    }
                    ++n;
                }
                Logger.log(1, myself, "done");
            } else {
                Logger.log(5, myself, "processing single file");
                this.transform(string, documentBuilder, transformer, string3);
            }
        }
        catch (Exception exception) {
            Logger.log(3, exception);
        }
    }

    public void warning(SAXParseException sAXParseException) {
        this.isValid = false;
        System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        this.isValid = false;
        System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.isValid = false;
        System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Logger.setLevel(2);
        String string = null;
        String string2 = null;
        String string3 = null;
        if (stringArray.length == 0) {
            XTransform.printUsage();
            System.exit(1);
        }
        XTransform xTransform = new XTransform();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string4 = stringArray[n2];
            if (string4.equals("-h")) {
                XTransform.printUsage();
                System.exit(1);
            }
            if (string4.equals("-q")) {
                Logger.setLevel(0);
            } else if (string4.equals("-d")) {
                Logger.setLevel(6);
            } else if (string4.equals("-v")) {
                xTransform.validate = false;
            } else if (string4.equals("+v")) {
                xTransform.validate = true;
            } else if (string4.startsWith("-s")) {
                xTransform.outSuffix = new String("." + string4.substring(2));
            } else if (string == null) {
                string = string4;
            } else if (string2 == null) {
                string2 = string4;
            } else if (string3 == null) {
                string3 = string4;
            }
            ++n2;
        }
        if (string == null || string2 == null) {
            XTransform.printUsage();
            System.exit(1);
        }
        xTransform.doMain(string, string2, string3);
    }

    private static void printUsage() {
        System.err.println("usage: java XTransform -q -sxml xml xsl [out]");
        System.err.println("-q: be silent");
        System.err.println("-d: turn on debug mode");
        System.err.println("-v: turn off validation");
        System.err.println("+v: turn on  validation");
        System.err.println("-sxxx: set suffix to this.");
        System.err.println("xml: input file/directory where xml files live");
        System.err.println("xsl: style sheet. All xml files are processed against this");
        System.err.println("out: output files are put in that directory");
    }
}

