/*
 * Decompiled with CFR 0.152.
 */
package com.hatop.sxql;

import com.hatop.sxql.Logger;
import com.hatop.sxql.database.DataAccessor;
import com.hatop.sxql.transformer.SQLtransformer;
import com.hatop.sxql.transformer.SXsubst;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class sxdb {
    private static String myself = "sxdb";
    private String fileSep = System.getProperty("file.separator");
    private SQLtransformer sqlTransformer = null;
    private Connection connection = null;
    private DataAccessor dba = null;

    public static sxdb getInstance(Connection connection) {
        sxdb sxdb2 = new sxdb();
        sxdb2.sqlTransformer = new SQLtransformer(connection, "sql");
        sxdb2.connection = connection;
        return sxdb2;
    }

    public static sxdb getInstance(String string, String string2, String string3, String string4) throws SQLException {
        Logger.log(3, myself, "::init");
        Logger.log(3, myself, "dbuser=" + string3 + " dbpasswd=" + string4);
        Logger.log(3, myself, " dburl=" + string);
        sxdb sxdb2 = new sxdb();
        try {
            Class.forName(string2).newInstance();
            Connection connection = DriverManager.getConnection(string, string3, string4);
            sxdb2.sqlTransformer = new SQLtransformer(connection, "sql");
            sxdb2.connection = connection;
            return sxdb2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace(System.err);
            return null;
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace(System.err);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace(System.err);
            return null;
        }
    }

    public static sxdb getInstance(String string) throws SQLException {
        Logger.log(3, myself, "loading properties:" + string);
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(new File(string)));
        }
        catch (IOException iOException) {
            Logger.log(3, iOException.toString());
        }
        String string2 = properties.getProperty("db.dburl");
        String string3 = properties.getProperty("db.dbdriver");
        String string4 = properties.getProperty("db.dbuser");
        String string5 = properties.getProperty("db.dbpasswd");
        return sxdb.getInstance(string2, string3, string4, string5);
    }

    public static sxdb getInstance() throws SQLException {
        String string = "Database.properties";
        File file = new File(string);
        if (file.exists()) {
            return sxdb.getInstance(string);
        }
        return null;
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Document getDocument(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            return document;
        }
        catch (Exception exception) {
            Logger.log(3, exception);
            return null;
        }
    }

    private void transform(Document document) {
        this.sqlTransformer.transform(document);
    }

    public void transform(Document document, Hashtable hashtable) {
        SXsubst sXsubst = new SXsubst("sql");
        sXsubst.setQuery(document, hashtable);
    }

    public void transform(Document document, PrintWriter printWriter) {
        this.sqlTransformer.transform(document, printWriter);
    }

    public void transform(Document document, String string) {
        Logger.log(3, myself, "writing doc to file " + string);
        PrintWriter printWriter = null;
        try {
            if (string == null) {
                printWriter = new PrintWriter(System.out);
            } else {
                FileWriter fileWriter = new FileWriter(string);
                printWriter = new PrintWriter(fileWriter);
            }
        }
        catch (IOException iOException) {
            Logger.log(3, myself, iOException.toString());
        }
        this.sqlTransformer.transform(document, printWriter);
    }

    public void serialOut(Document document, String string) {
        this.transform(document, string);
    }

    private void doMain(Document document, String string) {
        if (string == null) {
            this.transform(document, new PrintWriter(System.out));
        } else {
            this.serialOut(document, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Object object2 = null;
        Object object3 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(12);
        String string5 = null;
        if (stringArray.length == 0) {
            sxdb.printUsage();
            System.exit(1);
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < stringArray.length) {
            object = stringArray[n2];
            if (((String)object).equals("-h")) {
                sxdb.printUsage();
                System.exit(1);
            }
            if (((String)object).equals("-u")) {
                if (n2 < n - 1) {
                    string = stringArray[++n2];
                }
            } else if (((String)object).equals("-p")) {
                if (n2 < n - 1) {
                    string2 = stringArray[++n2];
                }
            } else if (((String)object).equals("-d")) {
                if (n2 < n - 1) {
                    string3 = stringArray[++n2];
                }
            } else if (((String)object).equals("-debug")) {
                if (n2 < n - 1) {
                    Logger.setLevel(stringArray[++n2]);
                }
            } else if (((String)object).equals("-j")) {
                if (n2 < n - 1) {
                    string4 = stringArray[++n2];
                }
            } else if (((String)object).equals("-param")) {
                int n3;
                if (n2 < n - 1 && (n3 = stringArray[++n2].indexOf("=")) > 0) {
                    String string6 = stringArray[n2].substring(0, n3);
                    String string7 = stringArray[n2].substring(n3 + 1, stringArray[n2].length());
                    System.out.println("hashing " + string6 + "/" + string7);
                    hashtable.put(string6, string7);
                }
            } else if (((String)object).equals("-prop")) {
                if (n2 < n - 1) {
                    string5 = stringArray[++n2];
                }
            } else if (object2 == null) {
                object2 = object;
            } else if (object3 == null) {
                object3 = object;
            }
            ++n2;
        }
        object = null;
        try {
            block36: {
                try {
                    if (string5 != null) {
                        object = sxdb.getInstance(string5);
                    }
                    if ((object = string3 != null ? sxdb.getInstance(string3, string4, string, string2) : sxdb.getInstance()) != null) {
                        Document document = ((sxdb)object).getDocument((String)object2);
                        ((sxdb)object).transform(document, hashtable);
                        super.doMain(document, (String)object3);
                        break block36;
                    }
                    sxdb.printUsage();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    Object var16_18 = null;
                    if (object != null) {
                        ((sxdb)object).close();
                    }
                }
            }
            Object var16_17 = null;
            if (object != null) {
                ((sxdb)object).close();
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            if (object != null) {
                ((sxdb)object).close();
            }
            throw throwable;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java com.hatop.sxql.sxdb");
        System.err.print(" [-debug level]");
        System.err.print(" [-param name=value] ");
        System.err.print(" -prop properties ");
        System.err.println("infile [outfile]");
    }
}

