/*
 * Decompiled with CFR 0.152.
 */
package com.hatop.sxql.transformer;

import com.hatop.sxql.Logger;
import com.hatop.sxql.transformer.SXsubst;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SQLtransformer {
    private static final boolean xdebug = true;
    private static final int loglevel = 8;
    private static final String myself = "SQLtransformer";
    private static String sqltag = "sql";
    private Connection connection = null;
    private PrintWriter out = null;

    public SQLtransformer(Connection connection) {
        this.connection = connection;
    }

    public SQLtransformer(Connection connection, String string) {
        this.connection = connection;
        sqltag = string;
    }

    private String getQuery(Element element) {
        String string = SXsubst.getQuery(element);
        return string;
    }

    private Element getPattern(Element element) {
        Element element2 = null;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                element2 = (Element)node;
                break;
            }
            ++n2;
        }
        return element2;
    }

    private void makeTable(ResultSet resultSet, Document document, Element element) throws SQLException {
        this.makeTableHeader(resultSet, document, element);
        this.makeTableBody(resultSet, document, element);
    }

    private void makeTableHeader(ResultSet resultSet, Document document, Element element) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Element element2 = null;
        Element element3 = null;
        int n = resultSetMetaData.getColumnCount();
        if (this.out == null) {
            element2 = document.createElement("tr");
        } else {
            this.out.println("<tr>");
        }
        int n2 = 1;
        while (n2 <= n) {
            if (this.out == null) {
                element3 = document.createElement("th");
                element3.appendChild(document.createTextNode(resultSetMetaData.getColumnLabel(n2)));
                element2.appendChild(element3);
            } else {
                this.out.println("<th>" + resultSetMetaData.getColumnLabel(n2) + "</th>");
            }
            ++n2;
        }
        if (this.out == null) {
            element.appendChild(element2);
        } else {
            this.out.println("</tr>");
        }
    }

    private synchronized HashMap getColumns(ResultSet resultSet) {
        try {
            int n = resultSet.getMetaData().getColumnCount();
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(n);
            int n2 = 1;
            while (n2 <= n) {
                hashMap.put(resultSet.getMetaData().getColumnLabel(n2), new Integer(n2));
                ++n2;
            }
            return hashMap;
        }
        catch (SQLException sQLException) {
            Logger.log(3, sQLException);
            return null;
        }
    }

    private void makeTableBody(ResultSet resultSet, Document document, Element element) throws SQLException {
        int n = resultSet.getMetaData().getColumnCount();
        Element element2 = null;
        Element element3 = null;
        while (resultSet.next()) {
            if (this.out == null) {
                element2 = document.createElement("tr");
            } else {
                this.out.println("<tr>");
            }
            int n2 = 1;
            while (n2 <= n) {
                String string = resultSet.getString(n2);
                string = string == null ? new String("") : string.trim();
                if (this.out == null) {
                    element3 = document.createElement("td");
                    if ("".equals(string)) {
                        element3.appendChild(document.createElement("br"));
                    } else {
                        element3.appendChild(document.createTextNode(string));
                    }
                    element2.appendChild(element3);
                } else if ("".equals(string)) {
                    this.out.println("<td><br/></td>");
                } else {
                    this.out.println("<td>" + string + "</td>");
                }
                ++n2;
            }
            if (this.out == null) {
                element.appendChild(element2);
                continue;
            }
            this.out.println("</tr>");
        }
    }

    private void makeXML(ResultSet resultSet, Document document, Element element) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        while (resultSet.next()) {
            int n2 = 1;
            while (n2 <= n) {
                String string = resultSet.getString(n2);
                String string2 = resultSetMetaData.getColumnLabel(n2);
                string = string == null ? new String("") : string.trim();
                if (this.out == null) {
                    Element element2 = document.createElement(string2);
                    element2.appendChild(document.createTextNode(string));
                    element.appendChild(element2);
                } else {
                    this.out.println("<" + string2 + ">" + string + "</" + string2 + ">");
                }
                ++n2;
            }
        }
    }

    private void makeXMLrows(ResultSet resultSet, Document document, Element element) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        String string = resultSetMetaData.getTableName(1);
        Element element2 = null;
        while (resultSet.next()) {
            if (this.out == null) {
                element2 = document.createElement(string);
            } else {
                this.out.println("<" + string + ">");
            }
            int n2 = 1;
            while (n2 <= n) {
                String string2 = resultSet.getString(n2);
                String string3 = resultSetMetaData.getColumnLabel(n2);
                string2 = string2 == null ? new String("") : string2.trim();
                if (this.out == null) {
                    Element element3 = document.createElement(string3);
                    element3.appendChild(document.createTextNode(string2));
                    if (element2 != null) {
                        element2.appendChild(element3);
                    } else {
                        element.appendChild(element3);
                    }
                } else {
                    this.out.println("<" + string3 + ">" + string2 + "</" + string3 + ">");
                }
                ++n2;
            }
            if (this.out == null) {
                element.appendChild(element2);
                continue;
            }
            this.out.println("</" + string + ">");
        }
    }

    private void makeXElements(ResultSet resultSet, Document document, Element element, Element element2) throws SQLException {
        HashMap hashMap = this.getColumns(resultSet);
        while (resultSet.next()) {
            Element element3 = (Element)element2.cloneNode(true);
            if (element3 != null) {
                this.makeElements(document, element3, resultSet, hashMap);
            }
            if (this.out == null) {
                element.appendChild(element3);
                continue;
            }
            this.xprint(document, element3, this.out);
        }
    }

    private void makeElements(ResultSet resultSet, Document document, Element element, Element element2) throws SQLException {
        while (resultSet.next()) {
            Element element3 = (Element)element2.cloneNode(true);
            if (element3 != null) {
                this.makeElements(document, element3, resultSet);
            }
            if (this.out == null) {
                element.appendChild(element3);
                continue;
            }
            this.xprint(document, element3, this.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void makeResult(Document document, Element element) {
        block24: {
            ResultSet resultSet;
            Statement statement;
            String string;
            block23: {
                if (document == null) {
                    Logger.log(8, myself, "null document");
                    return;
                }
                string = this.getQuery(element);
                Logger.log(8, myself, string);
                if (string == null || string.length() < 3) {
                    return;
                }
                if (string.indexOf("$") >= 0) {
                    return;
                }
                Element element2 = this.getPattern(element);
                Element element3 = (Element)element.getParentNode();
                if (element3 == null) {
                    Logger.log(3, myself, "Note: makeResult: no parent");
                    element3 = element;
                }
                statement = null;
                resultSet = null;
                statement = this.connection.createStatement();
                resultSet = statement.executeQuery(string);
                if (element2 == null) {
                    if ("table".equals(element3.getNodeName())) {
                        if ("body".equals(element.getAttribute("out"))) {
                            this.makeTableBody(resultSet, document, element3);
                        } else {
                            this.makeTable(resultSet, document, element3);
                        }
                    } else if ("rows".equals(element.getAttribute("out"))) {
                        this.makeXMLrows(resultSet, document, element3);
                    } else {
                        this.makeXML(resultSet, document, element3);
                    }
                    break block23;
                }
                if ("hash".equals(element.getAttribute("out"))) {
                    this.makeXElements(resultSet, document, element3, element2);
                    break block23;
                }
                this.makeElements(resultSet, document, element3, element2);
            }
            Object var11_8 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                statement.close();
            }
            catch (SQLException sQLException) {
                Logger.log(3, sQLException);
            }
            break block24;
            {
                catch (SQLException sQLException) {
                    Logger.log(3, myself, "::makeResult: " + sQLException.toString());
                    Element element4 = document.createElement(sqltag + "Error");
                    element4.appendChild(document.createTextNode(string + ": " + sQLException.toString()));
                    element.getParentNode().appendChild(element4);
                    Object var11_9 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        statement.close();
                    }
                    catch (SQLException sQLException2) {
                        Logger.log(3, sQLException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    statement.close();
                }
                catch (SQLException sQLException) {
                    Logger.log(3, sQLException);
                }
                throw throwable;
            }
        }
    }

    private void makeElements(Document document, Element element, ResultSet resultSet, HashMap hashMap) {
        try {
            Object v;
            String string;
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                string = namedNodeMap.item(n).getNodeName();
                v = hashMap.get(string);
                if (v != null) {
                    element.setAttribute(string, resultSet.getString((Integer)v));
                }
                ++n;
            }
            if (element.getNodeName().equals(sqltag)) {
                string = SXsubst.getQuery(element);
                Logger.log(8, myself, "subst: " + string);
                element.setAttribute("query", SXsubst.setQuery(string, resultSet));
            }
            if ((v = hashMap.get(string = element.getNodeName())) != null) {
                element.appendChild(document.createTextNode(resultSet.getString((Integer)v)));
            }
            NodeList nodeList = element.getChildNodes();
            int n2 = nodeList.getLength();
            int n3 = 0;
            while (n3 < n2) {
                if (nodeList.item(n3).getNodeType() == 1) {
                    Element element2 = (Element)nodeList.item(n3);
                    this.makeElements(document, element2, resultSet, hashMap);
                }
                ++n3;
            }
        }
        catch (SQLException sQLException) {
            Logger.log(3, sQLException);
        }
    }

    private void makeElements(Document document, Element element, ResultSet resultSet) {
        Object object;
        String string;
        Logger.log(8, myself, "looking up node " + element.getNodeName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            string = namedNodeMap.item(n).getNodeName();
            object = null;
            try {
                object = resultSet.getString(string);
                if (object != null) {
                    Logger.log(8, myself, " setting " + string + ": " + (String)object);
                    element.setAttribute(string, (String)object);
                } else {
                    element.setAttribute(string, "");
                }
            }
            catch (SQLException sQLException) {
                Logger.log(8, myself, sQLException.toString());
            }
            if (string.equals("query") && element.getNodeName().equals(sqltag)) {
                Logger.log(8, myself, "substitute query: " + element.getAttribute("query"));
                element.setAttribute(string, SXsubst.setQuery(element.getAttribute("query"), resultSet));
            }
            ++n;
        }
        string = null;
        try {
            string = resultSet.getString(element.getNodeName());
            if (string != null) {
                element.appendChild(document.createTextNode(string));
            } else {
                element.appendChild(document.createTextNode(""));
            }
        }
        catch (SQLException sQLException) {
            Logger.log(8, myself, sQLException.toString());
        }
        object = element.getChildNodes();
        int n2 = object.getLength();
        int n3 = 0;
        while (n3 < n2) {
            if (object.item(n3).getNodeType() == 1) {
                Element element2 = (Element)object.item(n3);
                this.makeElements(document, element2, resultSet);
            }
            ++n3;
        }
    }

    public int transform(Document document) {
        if (this.connection == null) {
            return -1;
        }
        NodeList nodeList = document.getElementsByTagName(sqltag);
        int n = nodeList.getLength();
        Logger.log(8, myself, " found query tags: " + n);
        if (n == 0) {
            return 0;
        }
        Element element = (Element)nodeList.item(0);
        this.makeResult(document, element);
        element.getParentNode().removeChild(element);
        return this.transform(document);
    }

    public int transform(Document document, PrintWriter printWriter) {
        if (this.connection == null) {
            return -1;
        }
        NodeList nodeList = document.getElementsByTagName(sqltag);
        int n = nodeList.getLength();
        Logger.log(8, myself, " found query tags: " + n);
        this.out = printWriter;
        this.xprint(document, document, printWriter);
        return 1;
    }

    private void xprint(Document document, Node node, PrintWriter printWriter) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                printWriter.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                this.xprint(document, ((Document)node).getDocumentElement(), printWriter);
                printWriter.flush();
                break;
            }
            case 1: {
                Object object;
                if (node.getNodeName().equals(sqltag)) {
                    this.makeResult(document, (Element)node);
                    break;
                }
                printWriter.print('<');
                printWriter.print(node.getNodeName());
                Attr[] attrArray = this.sortAttributes(node.getAttributes());
                int n = 0;
                while (n < attrArray.length) {
                    object = attrArray[n];
                    printWriter.print(' ');
                    printWriter.print(object.getNodeName());
                    printWriter.print("=\"");
                    printWriter.print(object.getNodeValue());
                    printWriter.print('\"');
                    ++n;
                }
                printWriter.print('>');
                object = node.getChildNodes();
                if (object == null) break;
                int n2 = object.getLength();
                int n3 = 0;
                while (n3 < n2) {
                    this.xprint(document, object.item(n3), printWriter);
                    ++n3;
                }
                break;
            }
            case 3: {
                printWriter.print(node.getNodeValue());
            }
        }
        if (s == 1 && !node.getNodeName().equals(sqltag)) {
            printWriter.print("</");
            printWriter.print(node.getNodeName());
            printWriter.print('>');
            printWriter.println();
        }
        printWriter.flush();
    }

    private Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n];
        int n2 = 0;
        while (n2 < n) {
            attrArray[n2] = (Attr)namedNodeMap.item(n2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            Object object;
            Object object2 = attrArray[n3].getNodeName();
            int n4 = n3;
            int n5 = n3 + 1;
            while (n5 < n) {
                object = attrArray[n5].getNodeName();
                if (((String)object).compareTo((String)object2) < 0) {
                    object2 = object;
                    n4 = n5;
                }
                ++n5;
            }
            if (n4 != n3) {
                object = attrArray[n3];
                attrArray[n3] = attrArray[n4];
                attrArray[n4] = object;
            }
            ++n3;
        }
        return attrArray;
    }
}

