<?php

class getDataTree
{
	var $dirTree = null;
	var $DEBUG = false;


	function getTreePath($base_datapath = null, $sub_datapath = null) {
		$path = $base_datapath;
		if ($sub_datapath != "") {
			if (endsWith($base_datapath,"/") == false) $base_datapath .= "/";
			$path .= $sub_datapath;
		}
		//echo "path: " . $path . "<br>\n";
		if ( ($path == null) || ($path == "") ) return(-1);
		$aDir = opendir( $path );
		//echo "aDir: " . $aDir . "<br>\n";
		if ( !$aDir ) return(-2);
		if ($this->DEBUG == true) {
			echo "====================================<br>\n";
			echo "START path: " . $path . "<br>\n";
		}

		if (endsWith($path,"/")) $path = substr($path,0,strlen($path)-1);
		$this->read_directory( $path );

		if ($this->DEBUG == true) echo "--------------directories----------------<br>\n";
		$numdirs = sizeof($this->dir_tree['directories']);
		if ($numdirs > 0) {
			array_multisort ($this->dir_tree['directories'],SORT_DESC, SORT_STRING);
			if ($this->DEBUG == true) {
				echo "size of array = ".$numdirs."<br>";
				for ($i = 0; $i < $numdirs; $i++) echo "DIR: " . $this->dir_tree['directories'][$i] . "<br>\n";
			}
		}
		if ($this->DEBUG) echo "----------------------------------<br>\n";

		if ($numdirs > 0) return($this->dir_tree['directories'][0]);
		return("");
	}


	function read_directory( $directory ) {
		if ( $handle = @opendir( $directory ) ) {
			while ( false !== ( $file = readdir( $handle ) ) ) {
				if ( $file != ".." && $file != "." ) {
					if( is_dir( $directory.'/'.$file)) {
						$newpath = $directory . '/' . $file;
						//echo "DIR: " . $newpath . "<br>\n";
						if ($this->ends_with_date_string($newpath)) $this->dir_tree['directories'][] = $newpath;
						$this->read_directory( $newpath );
					}
					/* we don't need files
					else {
						$this->dir_tree['files'][] = $directory.'/'.$file;  
					}
					*/
				}
			}
		}
	}


	function ends_with_date_string($path) {
		if ($path == null || $path == "") return(false);
		$dirs = split ( "/" , $path);
		$numdirs = sizeof($dirs);
		if (strlen($dirs[$numdirs-1]) != 8) return(false);
		if (ctype_digit($dirs[$numdirs-1])) return(true);
		return(false);
	}


	function endsWith( $str, $sub ) {
	   return ( substr( $str, strlen( $str ) - strlen( $sub ) ) === $sub );
	}

} // end class dataTree
?>