/*
 ======================================================================
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.

THE PRODUCER:
Andreas Imhof
ai@aiedv.ch

Version: 46
Version date: 20200219
======================================================================
*/


/*********************************************************************
 * string conversion.
 * This function is called early in the process when converting
 * text runs to paragraphs.
 * Add your own sequences to convert - text and special characters
 * conversion only (no xml element and attribute tags)
 */
var preconverttext_flags = 31;	//  0 = no pre conversion of text
							//  1 = remove softhypens
							//  2 = remove divis paragraph (manual hypens)
							//  4 = convert any space to blank
							//  8 = hyphens
							// 16 = others
function set_preconverttext_flags(flags) {
	preconverttext_flags = parseInt(flags);
}

function strconv_pre(txt) {
	if (txt == "") return("");
	tmp_txt = txt;
	tmp_txt = tmp_txt.replace(/~~amp~~/g,'&');	// an ampersand given from convertWithFontTable

	tmp_txt = tmp_txt.replace(/\&#8232;/g,'<br type="LINE SEPARATOR"/>');	// LINE SEPARATOR
	tmp_txt = tmp_txt.replace(/\u2028/g,'<br type="LINE SEPARATOR"/>');

	if (preconverttext_flags <= 0) return(tmp_txt);

	if (preconverttext_flags & 1) {
		tmp_txt = tmp_txt.replace(/\u00AD\u2028/g,'');	// soft hyphen followed by LINE SEPARATOR: utf8 = C2 AD + E2 80 A8
		tmp_txt = tmp_txt.replace(/\u00AD/g,'');	// soft hyphen: utf8 = C2 AD
	}
	if (preconverttext_flags & 2) {
		tmp_txt = tmp_txt.replace(/-\u2028/g,'');	// divis followed by line break: utf8 = 2D + E2 80 A8
												// CAUTION: this may remove divis from dome words
	}
	if (preconverttext_flags & 4) {	// spaces to normal blank
		tmp_txt = tmp_txt.replace(/\u2000/g,' ');	// en quad: utf8 = E2 80 80
		tmp_txt = tmp_txt.replace(/\u2001/g,' ');	// em quad: utf8 = E2 80 81
		//tmp_txt = tmp_txt.replace(/\u2002/g,' ');	// en space: utf8 = E2 80 82
		//tmp_txt = tmp_txt.replace(/\u2003/g,' ');	// em space: utf8 = E2 80 83
		tmp_txt = tmp_txt.replace(/\u2004/g,' ');	// three-per-em space: utf8 = E2 80 84
		tmp_txt = tmp_txt.replace(/\u2005/g,' ');	// four-per-em space: utf8 = E2 80 85
		tmp_txt = tmp_txt.replace(/\u2006/g,' ');	// six-per-em space: utf8 = E2 80 86
		tmp_txt = tmp_txt.replace(/\u2007/g,' ');	// figure space: utf8 = E2 80 87
		tmp_txt = tmp_txt.replace(/\u2008/g,' ');	// punctuation space: utf8 = E2 80 88
		tmp_txt = tmp_txt.replace(/\u2009/g,' ');	// thin space: utf8 = E2 80 89
		tmp_txt = tmp_txt.replace(/\u200a/g,' ');	// hair space: utf8 = E2 80 8A
		tmp_txt = tmp_txt.replace(/\u200b/g,' ');	// zero width space: utf8 = E2 80 8B
		tmp_txt = tmp_txt.replace(/\u200c/g,' ');	// zero width non-joiner: utf8 = E2 80 8C
		tmp_txt = tmp_txt.replace(/\u200d/g,' ');	// zero width joiner: utf8 = E2 80 8D
		tmp_txt = tmp_txt.replace(/\u202f/g,'\u00a0');	// narrow non breaking space: utf8 = ef 81 b3
	}

	if (preconverttext_flags & 8) {	// hyphens
		tmp_txt = tmp_txt.replace(/\u2010/g,'');	// hyphen: utf8 = e2 80 90
		tmp_txt = tmp_txt.replace(/\u2011/g,'-');	// non-breaking hyphen: utf8 = e2 80 91
		tmp_txt = tmp_txt.replace(/\u2012/g,'-');	// figure dash: utf8 = E2 80 92
	//	tmp_txt = tmp_txt.replace(/\u2013/g,'\&#x02013;');	// en dash: utf8 = E2 80 93
	//	tmp_txt = tmp_txt.replace(/\u2014/g,'\&#x02014;');	// em dash: utf8 = E2 80 94
	//	tmp_txt = tmp_txt.replace(/\u2015/g,'\&#x02014;');	// horizontal bar: utf8 = E2 80 95
	}

	// other (unknown) characters
	if (preconverttext_flags & 16) {	// others
		//tmp_txt = tmp_txt.replace(/\uf073/g,'\u00a0');	// may be private non breaking space?: utf8 = ef 81 b3
		//tmp_txt = tmp_txt.replace(/\uc2a0/g,'\u00a0');	// may be private non breaking space?: utf8 = ec 8a a0
	}
	return(tmp_txt);
}









/*********************************************************************
 * Font conversion.
 * This function is called from a template representing a special attribute
 */
function mySpecialStyleToConvert(instr) {
	if (instr == "") return("");
	if (instr == " ") return(" ");
	var fa = new Array();
	
	// Font: European Pi 3
	fa["\ue050"]="\&#x02022;";	// &bull;   UTF8: EE 81 90, Unicode: e050
	// add your own conversions
	
	var outstr = "";
	var out = "";
	for (var i = 0; i < instr.length; i++) {
		out = fa[instr[i]];
		if (out == undefined) outstr += instr[i];	//"###UNDEFINED SYMBOL###";
		else outstr += out;
	}

	if (in_table_mode > 0) outstr = set_table_cells(outstr);

	return(outstr);
}





/*********************************************************************
 * functions to convert lines set with tab stops into a html table structure.
 */
var in_table_mode = 0;			// is set to 1 when we are in a table 
var table_tag_is_set = false;	// is set to true when <table > tag was set
var current_arributes = new Array();

function set_in_table_mode(val) {
	in_table_mode = val;
	current_arributes = new Array();	// reset array for currently active text attributes like bold italic...
	if (in_table_mode > 0) {
		if (table_tag_is_set == false) {
			table_tag_is_set = true;
			return("<table><tbody>");
		}
		else return("");
	}
	else {
		if (table_tag_is_set == true) {
			table_tag_is_set = false;
			return("</tbody></table>");
		}
		else return("");
	}
}
function get_in_table_mode() {
	return(in_table_mode);
}
function set_table_cells(rowtext) {
	if (in_table_mode < 1) return(rowtext);
	//if (rowtext.indexOf("\u0009") < 0) return(rowtext);
	var my_row = rowtext;
	var replacetext = "";
	if (current_arributes.length > 0) {
		for (var i = (current_arributes.length-1); i >= 0; i--) {
			replacetext += "</" + current_arributes[i] + ">";
		}
	}
	replacetext += "</p></td><td><p>";
	if (current_arributes.length > 0) {
		for (var i = 0; i < current_arributes.length; i++) {
			replacetext += "<" + current_arributes[i] + ">";
		}
	}

	my_row = my_row.replace(/\u0009/g,replacetext);
	return(my_row);
}

function set_current_arribute(attribs) {
	if (attribs == "") return;
	if (current_arributes == null) current_arributes = new Array();
	var my_attrs = attribs.split(",");
	for (var i = 0; i < my_attrs.length; i++) {
		current_arributes[current_arributes.length] = my_attrs[i];
	}
	return;
}
function clear_current_arribute() {
	if ( (current_arributes == null) || (current_arributes.length == 0) ) return;
	current_arributes.length--;
	return;
}






/*********************************************************************
 * Create a folder Index file.
 */
var folderIndexArr = new Array();
var folderIndexFileType = "xhtm";
var folderIndexFileLineBreak = "<br />";

function init_folder_index(pathname,title,creator,description,rights) {
	folderIndexArr = new Array();
	f = new java.io.File(pathname,title);
	if (f.exists()) return;
	// create the empty index file
	var doc = "";
	do {
		if (pathname.toLowerCase().indexOf(".xhtm") >= 0) {
			folderIndexFileType = "xhtm";
			folderIndexFileLineBreak = "<br />";
			doc += "<!DOCTYPE html PUBLIC \"-\/\/W3C\/\/DTD XHTML 1.0 Transitional\/\/EN\" \"http:\/\/www.w3.org\/TR\/xhtml1\/DTD\/xhtml1-transitional.dtd\">\n";
			doc += "<html xmlns=\"http:\/\/www.w3.org\/1999\/xhtml\">\n<head>\n";
			doc += "<title>";
			if ((title != null) && (title != "")) doc += title;
			doc += "</title>\n";
			if ((creator != null) && (creator != "")) doc += "<meta name=\"author\" content=\"" + creator + "\" \/>\n";
			if ((description != null) && (description != "")) doc += "<meta name=\"DC.description\" content=\"" + description + "\" \/>\n";
			if ((rights != null) && (rights != "")) doc += "<meta name=\"DC.rights\" content=\"" + rights + "\" \/>\n";
			doc += "<meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" \/>\n";
			doc += "<\/head>\n<body>\n<\/body>\n<\/html>\n";
			break;
		}
		if (pathname.toLowerCase().indexOf(".xml") >= 0) {
			folderIndexFileType = "xml";
			folderIndexFileLineBreak = "";
			doc += "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE folderindex>\n";
			doc += "<folderindex>\n";
			doc += "<title>";
			if ((title != null) && (title != "")) doc += title;
			doc += "</title>\n";
			doc += "<creator>";
			if ((creator != null) && (creator != "")) doc += creator;
			doc += "</creator>\n";
			doc += "<description>";
			if ((description != null) && (description != "")) doc += description;
			doc += "</description>\n";
			doc += "<rights>";
			if ((rights != null) && (rights != "")) doc += rights;
			doc += "</rights>\n";
			doc += "<body>\n<\/body>\n";
			doc += "<\/folderindex>\n";
			break;
		}

		// default make htm index file
		folderIndexFileType = "htm";
		folderIndexFileLineBreak = "<br>";
		doc += "<!DOCTYPE html PUBLIC \"-\/\/W3C\/\/DTD HTML 4.01 Transitional\/\/EN\" \"http:\/\/www.w3.org\/TR\/html4\/loose.dtd\">\n";
		doc += "<html>\n<head>\n";
		doc += "<title>";
		if ((title != null) && (title != "")) doc += title;
		doc += "</title>\n";
		if ((creator != null) && (creator != "")) doc += "<meta name=\"author\" content=\"" + creator + "\">\n";
		if ((description != null) && (description != "")) doc += "<meta name=\"DC.description\" content=\"" + description + "\">\n";
		if ((rights != null) && (rights != "")) doc += "<meta name=\"DC.rights\" content=\"" + rights + "\">\n";
		doc += "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n";
		doc += "<\/head>\n<body>\n<\/body>\n<\/html>\n";
		break;
	} while(false);

	// write the empty index file
	return(writeFile(pathname,doc,true));
}

function add_folder_index(filename) { folderIndexArr[folderIndexArr.length] = filename; }

function write_folder_index(pathname) {
	if ((pathname == null) || (pathname == "")) return(false);
	if (folderIndexArr.length <= 0) return(false);
	var my_pathname = pathname;
	// read the current file content
	var domstr = "";
	domstr = "" + Packages.com.epaperarchives.batchxslt.utils.readFileUTF(my_pathname);
	if (domstr == "") return(false);

	// add filename entries to the file content
	var rex = /\<\/body\>/;		// right before end body
	for (var i = 0; i < folderIndexArr.length; i++) {
		var entry = "<a href=\""  + encodeURI(folderIndexArr[i]) + "\">" + folderIndexArr[i] + "<\/a>" + folderIndexFileLineBreak + "\n<\/body>";
		domstr = domstr.replace(rex,entry);
	}
	// write new file content to disk
	return(writeFile(my_pathname,domstr,true,false));
}

function write_indexPHP(pathname, xml_file, xsl_file) {
	var content = "",
		htm_file = "",
		rex;
	if ((pathname == null) || (pathname == "")) return(false);
	if ((xml_file == null) || (xml_file == "")) return(false);

	// create the output html file name
	rex = /.xml/i;		// the source XML file name extension
	htm_file = xml_file.replace(rex,".htm");


	content += '<?php\r';
	content += '/**\r';
	content += ' * THIS SOFTWARE IS PROVIDED AS IS AND ANY EXPRESSED OR IMPLIED\r';
	content += ' * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\r';
	content += ' * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\r';
	content += ' * DISCLAIMED.  IN NO EVENT SHALL THE PRODUCER OR\r';
	content += ' * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\r';
	content += ' * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\r';
	content += ' * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF\r';
	content += ' * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\r';
	content += ' * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,\r';
	content += ' * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT\r';
	content += ' * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF\r';
	content += ' * SUCH DAMAGE.\r\r';

	content += 'THE PRODUCER:\r';
	content += 'Andreas Imhof\r';
	content += 'www.aiedv.ch\r\r';

	content += 'Short Description: Return a HTML version from a flipbook XML file\r';
	content += 'Description: Return a HTML version from a flipbook XML file. Optionally set the maximum number of pages to return.\r\r';

	content += 'Version: 1\r';
	content += 'Version date: 20140808\r';
	content += '*/\r\r';

	content += '$user = "";		// access protected directories\r';
	content += '$pwd = "";		// do not protect entire directories or flip books will not work\r\r';

	content += '$unleashedUNLOCK = 123456;	// the master unleash code\r';
	content += '$unleashed = 0;		// 1 = show entire document. 0 to apply given restrictions\r';
	content += '$maxpages = 5;		// Maximum number of pages to return: 0 for all pages, otherwise a max number of pages to process\r';
	content += '$noarticles = 0;	// suppress all articles and mouse overs: 0 = do suppress, otherwise show articles\r';
	content += '$nopdf = 1;			// suppress all PDF: 0 = do suppress, otherwise show PDF\r';
	content += '$nopagepdf = 0;		// suppress pages PDF: 0 = do suppress, otherwise show PDF\r';
	content += '$nodocpdf = 0;		// suppress document PDF: 0 = do suppress, otherwise show PDF\r\r';

	content += '$xml_filename = "' + xml_file + '";	// the source XML file\r';
	content += '$htm_filename = "' + htm_file + '";	// the full HTML file containig all pages\r';
	content += '$xsl_filename = "' + xsl_file + '";	// the XSL file to use\r\r';

	content += '// check for unleash\r';
	content += 'if (isset($_GET[\'unleashed\']) && is_numeric($_GET[\'unleashed\']) && (intval($_GET[\'unleashed\']) === $unleashedUNLOCK)) $unleashed = 1;\r';
	content += 'if (isset($_POST[\'unleashed\']) && is_numeric($_POST[\'unleashed\']) && (intval($_POST[\'unleashed\']) === $unleashedUNLOCK)) $unleashed = 1;\r';
	content += '// get the number of pages to process\r';
	content += 'if ($maxpages <= 0) {	// allow override only if not preset\r';
	content += '	if (isset($_GET[\'xp\']) && is_numeric($_GET[\'xp\'])) $maxpages = intval($_GET[\'xp\']);\r';
	content += '	if (isset($_GET[\'maxpages\']) && is_numeric($_GET[\'maxpages\'])) $maxpages = intval($_GET[\'maxpages\']);\r';
	content += '}\r';
	content += 'if (isset($_GET[\'noarticles\']) && is_numeric($_GET[\'noarticles\'])) $noarticles = intval($_GET[\'noarticles\']);\r';
	content += 'if (isset($_GET[\'nopdf\']) && is_numeric($_GET[\'nopdf\'])) $nopdf = intval($_GET[\'nopdf\']);\r';
	content += 'if (isset($_GET[\'nopagepdf\']) && is_numeric($_GET[\'nopagepdf\'])) $nopagepdf = intval($_GET[\'nopagepdf\']);\r';
	content += 'if (isset($_GET[\'nodocpdf\']) && is_numeric($_GET[\'nodocpdf\'])) $nodocpdf = intval($_GET[\'nodocpdf\']);\r\r';

	content += '$context = null;\r';
	content += 'if (($user != "") || ($pwd != "")) $context = stream_context_create(array (\'http\' => array (\'header\'=>\'Authorization: Basic \' . base64_encode("$user:$pwd")."\\r\\n")));\r\r';

	content += '// test if entire HTML file is requested: do no transform\r';
	content += 'if (($unleashed == 1) || (($maxpages <= 0) && ($noarticles <= 0) && ($nopdf <= 0) && ($nopagepdf <= 0) && ($nodocpdf <= 0))) {\r';
	content += '	echo file_get_contents($htm_filename, false, $context);\r';
	content += '	exit;\r';
	content += '}\r\r';

	content += '// extract the requested number of pages\r';
	content += '$xsl = new XSLTProcessor();\r';
	content += '$xsldoc = new DOMDocument();\r';
	content += '$xsldoc->load($xsl_filename);\r';
	content += '$xsl->importStyleSheet($xsldoc);\r\r';

	content += '$xmldoc = new DOMDocument();\r';
	content += '$xmldoc->load($xml_filename);\r';
	content += '$xsl->setParameter(\'\',"maxpages",$maxpages);\r';
	content += '$xsl->setParameter(\'\',"noarticles",$noarticles);\r';
	content += '$xsl->setParameter(\'\',"nopdf",$nopdf);\r';
	content += '$xsl->setParameter(\'\',"nopagepdf",$nopagepdf);\r';
	content += '$xsl->setParameter(\'\',"nodocpdf",$nodocpdf);\r';
	content += '// return the HTML result\r';
	content += 'echo $xsl->transformToXML($xmldoc);\r';
	content += '?>\r';

	// write new file content to disk
	return(writeFile(pathname,content,true,false));
}


function writeFile(pathname,content,overwrite) {
	var done = writeFile(pathname,content,overwrite,1);
	return( done );
}
function writeFile(pathname,content,overwrite,append) {
	if (overwrite == false) {
		var f = new java.io.File(pathname);
		if (f.exists() == true) return false;
	}
	var bwr = null;
	var doappend = false;
	if (append == true) bwr = new java.io.BufferedWriter( new java.io.OutputStreamWriter( new java.io.FileOutputStream(pathname,true), "UTF-8" ) );
	else bwr = new java.io.BufferedWriter( new java.io.OutputStreamWriter( new java.io.FileOutputStream(pathname,false), "UTF-8" ) );
	bwr.write(content);

	bwr.close();
	return true;
}


/*********************************************************************
 * Validate/complete UNC paths
 */
function validateUNCpath(path,encuri) {
	if ((path == null) || (path == "")) return("");
	mypath = path;
	if (encuri) mypath = encodeURI(mypath);
	mypath = mypath.replace(/%5c/gi,"\\");
	mypath = mypath.replace(/%2f/gi,"/");
	if ((mypath.indexOf("\\\\") == 0) || (mypath.indexOf("//") == 0)) {	// is UNC path? like: \\servername\path
		mypath = "file://" + mypath;
	}
	return(mypath);
}


function math_ceil(num) {
	return( Math.ceil(num) );
}
function endsWith(str, s){
	if ( (str == null) || (str == "") ) return(false);
	if ( (s == null) || (s == "") ) return(false);
	var reg = new RegExp (s + "$");
	return reg.test(str);
}


/*********
 * custom css file writer
 */
var custom_css_string = "";
function clear_custom_css_string(str) {
	custom_css_string = "";
}
function add_custom_css_string(str) {
	custom_css_string += str;
}
function cust_css_styles_writefile(csspathname) {
	// write styles to disk
	var retval = Packages.com.epaperarchives.batchxslt.utils.writeFile(csspathname, custom_css_string, true);
	if (retval == 0) return true;
	return false;
//	writeFile(csspathname,custom_css_string,true,false);	// fails if output XSLCSSD folder does not exist
}

