<?xml version="1.0" encoding="UTF-8"?>
<!-- 
 ======================================================================
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.

THE PRODUCER:
Andreas Imhof
ai@aiedv.ch

Version: 40
Version date: 20200219
======================================================================
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
				xmlns:lxslt="http://xml.apache.org/xslt"
				xmlns:xalan="http://xml.apache.org/xalan" 
				xmlns:myutils="com.epaperarchives.batchxslt.utils"
				xmlns:pubjs="pub_funcs"

				xmlns:container="urn:oasis:names:tc:opendocument:xmlns:container"
				xmlns:idPkg="http://ns.adobe.com/AdobeInDesign/idml/1.0/packaging"

				exclude-result-prefixes="xalan lxslt container"
				version="1.0">
<!--
-->

	<xsl:output method="xml" />
	<xsl:output media-type="text/xml"/>
	<xsl:output omit-xml-declaration="no"/>

<!--xsl:output xalan:indent-amount="0"/-->
	<xsl:output indent="yes"/>
	<xsl:output encoding="UTF-8"/>

<!-- standard parameters -->
	<xsl:param name="XMLpath"/>
	<xsl:param name="XMLname"/>

	<!-- *********** templates for the 'container.xml' ********** -->
	<xsl:template match="/"><!-- root file 'container.xml' -->
		<xsl:text disable-output-escaping="yes">&#10;</xsl:text>
		<xsl:comment>
IDML root path:<xsl:value-of select="$XMLpath"/>
IDML container file:<xsl:value-of select="$XMLname"/>
		</xsl:comment>
		<xsl:text disable-output-escaping="yes">&#10;</xsl:text>
		<xsl:apply-templates/>
	</xsl:template>

	<!-- 
	merge all XML file contained in an IDML package into a single XML file
	-->
	<!-- get all container XML files -->
	<xsl:template match="*[local-name()='container']">
		<Documents>
			<xsl:attribute name="numDocuments"><xsl:value-of select="count(//*[local-name()='rootfile'])"/></xsl:attribute>
			<xsl:attribute name="IDMLroot"><xsl:value-of select="$XMLpath"/></xsl:attribute>
			<xsl:attribute name="IDMLcontainerXML"><xsl:value-of select="$XMLname"/></xsl:attribute>
			<xsl:apply-templates/>
		</Documents>
	</xsl:template>

	<xsl:template match="*[local-name()='rootfiles']"><xsl:apply-templates/></xsl:template>

	<xsl:template match="*[local-name()='rootfile']">
		<xsl:variable name="designmapXMLPathname"><xsl:value-of select="$XMLpath"/><xsl:value-of select="@full-path"/></xsl:variable>
		<!--xsl:variable name="designmapXMLPathnameX" select="myutils:composeUnicodeNFC(string($designmapXMLPathname))"/-->
		<xsl:call-template name="mergeXML">
			<xsl:with-param name="designmapXMLPathname"><xsl:value-of select="$designmapXMLPathname"/></xsl:with-param>
		</xsl:call-template>
	</xsl:template>


	<!-- *********** templates for the 'designmap.xml' ********** -->
	<xsl:template name="mergeXML">
		<xsl:param name="designmapXMLPathname"/>
		<xsl:variable name="exists" select="myutils:existsFile(string($designmapXMLPathname))"/>
		<xsl:choose>
			<xsl:when test="($exists = true())">
				<xsl:comment>Designmap XML using file: <xsl:value-of select="$designmapXMLPathname"/></xsl:comment>
				<xsl:variable name="aFile">
					<xsl:value-of select="pubjs:validateUNCpath(string($designmapXMLPathname),true())"/>
				</xsl:variable>
				<xsl:variable name="designmapXML" select="document($aFile)" />
				<xsl:apply-templates select="xalan:nodeset($designmapXML)" mode="includeXML"/>
			</xsl:when>
			<xsl:otherwise>
				<ErrorDocument>
					<ErrorText>#### FATAL ERROR. Missing path/file</ErrorText>
					<ErrorPathFile><xsl:value-of select="$designmapXMLPathname"/>"</ErrorPathFile>
				</ErrorDocument>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template match="*" mode="includeXML">
		<!-- ********** name: <xsl:value-of select="name()"/> -->
		<xsl:choose>
			<xsl:when test="name() = 'Document'">
				<Document>
					<xsl:for-each select="@*">
						<xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
					</xsl:for-each>
					<xsl:apply-templates mode="includeXML"/>

					<xsl:variable name="metadatapathname"><xsl:value-of select="$XMLpath" />META-INF/metadata.xml</xsl:variable>
					<xsl:variable name="aFile">
						<xsl:value-of select="pubjs:validateUNCpath(string($metadatapathname),true())"/>
					</xsl:variable>
					<xsl:variable name="metadata" select="document($aFile)" />
					<metadata>
						<xsl:copy-of select="xalan:nodeset($metadata)/."/>
					</metadata>
				</Document>
			</xsl:when>
			<xsl:when test="starts-with(name(),'idPkg')">
				<xsl:variable name="IDpackageFile"><xsl:value-of select="@src"/></xsl:variable>
				<xsl:variable name="IDpackageFilePathName"><xsl:value-of select="$XMLpath"/><xsl:value-of select="@src"/></xsl:variable>
				<xsl:variable name="aFile">
					<xsl:value-of select="pubjs:validateUNCpath(string($IDpackageFilePathName),true())"/>
				</xsl:variable>
				<xsl:variable name="packageXML" select="xalan:nodeset(document($aFile))" />
				<xsl:variable name="packageRootName" select="local-name($packageXML/*[position()=1])" />
				<!--xsl:comment> **** package name: <xsl:value-of select="$packageRootName"/></xsl:comment-->
				<xsl:comment> **** Include package XML file: <xsl:value-of select="$IDpackageFile"/></xsl:comment>
				<xsl:text disable-output-escaping="yes">&#10;</xsl:text>
				<xsl:element name="{$packageRootName}">
					<xsl:for-each select="$packageXML/*[position()=1]/@*">
						<xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
					</xsl:for-each>
					<xsl:copy-of select="$packageXML/*[position() = 1]/*"/>
				</xsl:element>
				<xsl:comment> **** End package XML file: <xsl:value-of select="$IDpackageFile"/></xsl:comment>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="text()"></xsl:template>




	<!-- ############################################################################# -->
	<!-- =========================
		 our external JAVA Script functions: IMPORTED FROM EXTERNAL FILE
		 ========================= -->
	<lxslt:component prefix="pubjs">
	<lxslt:script lang="javascript" src="public.js"></lxslt:script>
	</lxslt:component>


</xsl:stylesheet>
