<?xml version="1.0" encoding="UTF-8"?>
<!-- 
 ======================================================================
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.

THE PRODUCER:
Andreas Imhof
ai@aiedv.ch

Version: 46
Version date: 20200218
20200118:	added support for images exported by InDesign
20160117:	added Free Edition
20150711:	added a comment
20140627:	enhanced for multiple page JPEGs
20140421:	handle bbox correct
20130804:	handle anchored buttons
			on window resize, resize lightbox and overlay (if closing lightbox, movies may not be brought to fullscreen)
20130702:	suppress HiddenText
======================================================================
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
				xmlns:lxslt="http://xml.apache.org/xslt"
				xmlns:xalan="http://xml.apache.org/xalan" 
				xmlns:myutils="com.epaperarchives.batchxslt.utils"
				xmlns:privjs="priv_funcs"
				xmlns:locjs="loc_funcs"
				xmlns:pubjs="pub_funcs"
				
				xmlns:x="adobe:ns:meta/"
				xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
				xmlns:stRef="http://ns.adobe.com/xap/1.0/sType/ResourceRef#"
				xmlns:xap="http://ns.adobe.com/xap/1.0/"
				xmlns:xapMM="http://ns.adobe.com/xap/1.0/mm/"
				xmlns:xapGImg="http://ns.adobe.com/xap/1.0/g/img/"
				xmlns:xapRights="http://ns.adobe.com/xap/1.0/rights/"
				xmlns:xapTPg="http://ns.adobe.com/xap/1.0/t/pg/"
				xmlns:xapG="http://ns.adobe.com/xap/1.0/g/"
				xmlns:stFnt="http://ns.adobe.com/xap/1.0/sType/Font#"
				xmlns:dc="http://purl.org/dc/elements/1.1/"
				xmlns:photoshop="http://ns.adobe.com/photoshop/1.0/"
				xmlns:illustrator="http://ns.adobe.com/illustrator/1.0/"
				
				extension-element-prefixes="locjs pubjs"
				exclude-result-prefixes="locjs privjs pubjs myutils xalan lxslt x rdf stRef xap xapMM xapGImg xapRights xapTPg xapG stFnt dc photoshop illustrator"
				version="1.0">


	<xsl:output method="xml" />
	<xsl:output media-type="text/xml"/>
	<xsl:output omit-xml-declaration="no"/>

	<xsl:output indent="no"/>
	<xsl:output encoding="UTF-8"/>
<!--xsl:output xalan:line-separator="&#10;"/-->
<!--xsl:output xalan:line-separator=""/-->

	<xsl:variable name="have_article_jpegs">0</xsl:variable><!--  say. that we currently do not have article jpegs -->



<!-- ================ HERE WE GO ================ -->
	<!-- create the XML ePaper pages -->
	<xsl:template name="makeXMLdefaultExport">
		<xsl:param name="XMLdumpfile"/>

		<!-- reload the dumped, raw transformed intermediary file -->
		<xsl:variable name="myXMLdumpfile">
			<xsl:value-of select="pubjs:validateUNCpath(string($XMLdumpfile),true())"/>
		</xsl:variable>
		<xsl:variable name="d" select="myutils:showMess(concat('&#10;   ++ loading intermediary XML file: ',$myXMLdumpfile),'1')"/>
		<xsl:variable name="exists" select="locjs:fileExists(string($XMLdumpfile))"/>
		<xsl:choose>
			<xsl:when test="$exists = true()">
				<xsl:variable name="d1" select="myutils:showMess(concat('&#10;   ++ intermediary XML file exists: ',$myXMLdumpfile),'1')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="d1" select="myutils:showMess(concat('&#10;   ## intermediary XML file does NOT exists: ',$myXMLdumpfile),'1')"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:variable name="XMLdocNodeset" select="xalan:nodeset(document($myXMLdumpfile))" />
		<xsl:if test="not($XMLdocNodeset)">
			<xsl:variable name="m">&#10;   ## FATAL ERROR loading intermediary XML file: <xsl:value-of select="$myXMLdumpfile" />&#10;   ## Report this problem to the software producer!</xsl:variable>
			<xsl:variable name="d" select="myutils:showMess(string($m),'1')"/>
			<xsl:message terminate="yes"><xsl:value-of select="$m" /></xsl:message>
		</xsl:if>

		<xsl:variable name="m">&#10;+++ creating XML output (IMX2xmlEpaperArticles.xsl): <xsl:value-of select="$OUTPUT_NAME" /></xsl:variable>
		<xsl:variable name="d" select="myutils:showMess(string($m),'1')"/>

		<!-- store the value to encode filenames or not -->
		<xsl:variable name="encodeNames">
			<xsl:choose>
				<xsl:when test="$XMLdocNodeset/document/call_parameters/par[@name='XPLATFORM_NAMES']/. = '0'">
			 		<xsl:value-of select="false()" />
			 	</xsl:when>
			 	<xsl:otherwise>
			 		<xsl:value-of select="true()" />
			 	</xsl:otherwise>
			 </xsl:choose>
		</xsl:variable>

		<xsl:text disable-output-escaping="yes">&lt;!DOCTYPE indd_document&gt;&#10;</xsl:text>

		<!-- include the desired xsl to view in browser in a certain mode? -->
		<xsl:choose>
			<xsl:when test="$outputModeCustomXSL != ''"><!-- special result XSL specified -->
				<xsl:variable name="viewEpaper_xsl"><xsl:value-of select="$outputModeCustomXSL"/></xsl:variable><!--  the xsl to use to transform to html in browser -->
				<xsl:variable name="fp"><xsl:value-of select="$XSLCSSInstallPathname"/><xsl:value-of select="$viewEpaper_xsl"/></xsl:variable>
				<xsl:variable name="exists" select="locjs:fileExists(string($fp))"/>
				<xsl:if test="$exists = false">
					<xsl:variable name="m1">&#10;   ++ Writing XSLCSS folder: <xsl:value-of select="$XSLCSSRelativePath"/></xsl:variable>
					<xsl:variable name="d1" select="myutils:showMess(string($m1),'1')"/>
					<xsl:variable name="created" select="myutils:copyFolderPath($XSLCSSSourceFolderpath, '', $XSLCSSInstallPathname, '', true(), true(), '#### XSLCSS Install error ')"/>
				</xsl:if>
				<xsl:text disable-output-escaping="yes">&lt;?xml-stylesheet href="</xsl:text><xsl:value-of select="privjs:encode_URI(concat($XSLCSSRelativePath,$viewEpaper_xsl),number(encodeNames))"/><xsl:text disable-output-escaping="yes">" type="text/xsl"?&gt;&#10;</xsl:text>
			</xsl:when>
			<xsl:otherwise><!-- XML tree: do not add an XSL: view as a XML tree -->
			</xsl:otherwise>
		</xsl:choose>

		<indd_document>

			<xsl:comment> **** calling XSL parameters:  **** </xsl:comment>
			<xsl:copy-of select="$XMLdocNodeset/document/call_parameters"/>

			<xsl:comment> **** GENERAL INFO:  **** </xsl:comment>
			<doctypeinfos encoding="UTF-8">
				<xsl:attribute name="xslpath"><xsl:value-of select="privjs:encode_URI(concat($XSLCSSPath,$outputModeCustomXSL),number(encodeNames))"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="$thecssname_isfullurl = '1'"><!-- if css name is a full url starting with http -->
						<xsl:attribute name="csspath"><xsl:value-of select="privjs:encode_URI(string($thecssname),number(encodeNames))"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="csspath"><xsl:value-of select="privjs:encode_URI(string($csspathname),number(encodeNames))"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:attribute name="xslbasepath"><xsl:value-of select="privjs:encode_URI(string($XSLCSSRelativePath),number(encodeNames))"/></xsl:attribute>
			</doctypeinfos>

			<xsl:call-template name="show_creator">
				<xsl:with-param name="creationYear"><xsl:value-of select="$XMLdocNodeset/document/@creation_year" /></xsl:with-param>
				<xsl:with-param name="creationDate"><xsl:value-of select="$XMLdocNodeset/document/@creation_date" /></xsl:with-param>
				<xsl:with-param name="creationTime"><xsl:value-of select="$XMLdocNodeset/document/@creation_time" /></xsl:with-param>
				<xsl:with-param name="outputVersion"><xsl:value-of select="$XMLdocNodeset/document/@version" /></xsl:with-param>
				<xsl:with-param name="inputPath"><xsl:value-of select="$XMLdocNodeset/document/indd_document/@inputbasepath" /></xsl:with-param>
				<xsl:with-param name="indesignDocname"><xsl:value-of select="$XMLdocNodeset/document/indd_document/@docname" /></xsl:with-param>
				<xsl:with-param name="sourceINXfileName"><xsl:value-of select="$XMLdocNodeset/document/indd_document/@inputname" /></xsl:with-param>
				<xsl:with-param name="operatingSystem"><xsl:value-of select="$XMLdocNodeset/document/@os" /></xsl:with-param>
				<xsl:with-param name="vmVersion"><xsl:value-of select="$XMLdocNodeset/document/@vm" /></xsl:with-param>
				<xsl:with-param name="transformEngine"><xsl:value-of select="$XMLdocNodeset/document/@engine" /></xsl:with-param>
				<xsl:with-param name="xsltVersion"><xsl:value-of select="$XMLdocNodeset/document/@xsltVersion" /></xsl:with-param>
				<xsl:with-param name="xsltVersionDate"><xsl:value-of select="$XMLdocNodeset/document/@xsltVersionDate" /></xsl:with-param>
			</xsl:call-template>

			<header type="layout">
				<headerfield name="creationYear"><xsl:value-of select="$XMLdocNodeset/document/@creation_year" /></headerfield>
				<headerfield name="creationDate"><xsl:value-of select="$XMLdocNodeset/document/@creation_date" /></headerfield>
				<headerfield name="creationTime"><xsl:value-of select="$XMLdocNodeset/document/@creation_time" /></headerfield>
				<headerfield name="outputVersion"><xsl:value-of select="$XMLdocNodeset/document/@version" /></headerfield>
				<headerfield name="filename"><xsl:value-of select="$OUTPUT_NAME" /></headerfield>
				<headerfield name="inputPath"><xsl:value-of select="privjs:encode_URI(string($XMLdocNodeset/document/indd_document/@inputbasepath),number(encodeNames))" /></headerfield>
				<headerfield name="indesignDocname"><xsl:value-of select="privjs:encode_URI(string($XMLdocNodeset/document/indd_document/@docname),number(encodeNames))" /></headerfield>
				<headerfield name="sourceINXfileName"><xsl:value-of select="privjs:encode_URI(string($XMLdocNodeset/document/indd_document/@inputname),number(encodeNames))" /></headerfield>
				<headerfield name="operatingSystem"><xsl:value-of select="$XMLdocNodeset/document/@os" /></headerfield>
				<headerfield name="vmVersion"><xsl:value-of select="$XMLdocNodeset/document/@vm" /></headerfield>
				<headerfield name="transformEngine"><xsl:value-of select="$XMLdocNodeset/document/@engine" /></headerfield>
				<headerfield name="xsltVersion"><xsl:value-of select="$XMLdocNodeset/document/@xsltVersion" /></headerfield>
				<headerfield name="xsltVersionDate"><xsl:value-of select="$XMLdocNodeset/document/@xsltVersionDate" /></headerfield>

				<headerfield name="pub_companyName"><xsl:value-of select="$XMLdocNodeset/document/call_parameters/par[@name='pub_companyName']/." /></headerfield>
				<headerfield name="pub_objectName"><xsl:value-of select="$XMLdocNodeset/document/call_parameters/par[@name='pub_objectName']/." /></headerfield>
				<headerfield name="pub_objectShortcut">
					<xsl:choose>
						<xsl:when test="$XMLdocNodeset/document/call_parameters/par[@name='pub_objectShortcut']/. != ''">
							<xsl:value-of select="$XMLdocNodeset/document/call_parameters/par[@name='pub_objectShortcut']/." />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="privjs:retrieve_objectShortcut(string($XMLdocNodeset/document/call_parameters/par[@name='OUTPUT_NAME']/.))" />
						</xsl:otherwise>
					</xsl:choose>
				</headerfield>
				<headerfield name="pub_issueYear">
					<xsl:choose>
						<xsl:when test="$XMLdocNodeset/document/call_parameters/par[@name='pub_issueYear']/. != ''">
							<xsl:value-of select="$XMLdocNodeset/document/call_parameters/par[@name='pub_issueYear']/." />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="privjs:retrieve_issue_year_date(string($XMLdocNodeset/document/call_parameters/par[@name='OUTPUT_NAME']/.), string($XMLdocNodeset/document/call_parameters/par[@name='OUTPUT_PATH']/.),true())" />
						</xsl:otherwise>
					</xsl:choose>
				</headerfield>
				<headerfield name="pub_issueDate">
					<xsl:choose>
						<xsl:when test="$XMLdocNodeset/document/call_parameters/par[@name='pub_issueDate']/. != ''">
							<xsl:value-of select="$XMLdocNodeset/document/call_parameters/par[@name='pub_issueDate']/." />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="privjs:retrieve_issue_year_date(string($XMLdocNodeset/document/call_parameters/par[@name='OUTPUT_NAME']/.), string($XMLdocNodeset/document/call_parameters/par[@name='OUTPUT_PATH']/.),false())" />
						</xsl:otherwise>
					</xsl:choose>
				</headerfield>

				<headerfield name="creator"><xsl:for-each select="$XMLdocNodeset/document/metadata/meta[@name='document_cMep']/descendant::dc:creator/rdf:Seq/rdf:li"><xsl:value-of select="." /><xsl:if test="position() != last()">;</xsl:if></xsl:for-each></headerfield>
				<headerfield name="description"><xsl:value-of select="$XMLdocNodeset/document/metadata/meta[@name='document_cMep']/descendant::dc:description/rdf:Alt/rdf:li/." /></headerfield>
				<headerfield name="title"><xsl:value-of select="$XMLdocNodeset/document/metadata/meta[@name='document_cMep']/descendant::dc:title/rdf:Alt/rdf:li/." /></headerfield>
				<!-- cleaned title for web site title tag -->
				<headerfield name="titleHead"><xsl:value-of select="locjs:clean_HTMLtags(string($XMLdocNodeset/document/metadata/meta[@name='document_cMep']/descendant::dc:title/rdf:Alt/rdf:li/.),' ')" /></headerfield>
				<headerfield name="rights"><xsl:value-of select="$XMLdocNodeset/document/metadata/meta[@name='document_cMep']/descendant::dc:rights/rdf:Alt/rdf:li/." /></headerfield>
				<headerfield name="AuthorsPosition"><xsl:value-of select="$XMLdocNodeset/document/metadata/meta[@name='document_cMep']/descendant::photoshop:AuthorsPosition/." /></headerfield>
				<headerfield name="CaptionWriter"><xsl:value-of select="$XMLdocNodeset/document/metadata/meta[@name='document_cMep']/descendant::photoshop:CaptionWriter/." /></headerfield>
				<headerfield name="copyrightStatus"><xsl:value-of select="$XMLdocNodeset/document/metadata/meta[@name='document_cMep']/descendant::xapRights:Marked/." /></headerfield>
				<headerfield name="WebStatement"><xsl:value-of select="$XMLdocNodeset/document/metadata/meta[@name='document_cMep']/descendant::xapRights:WebStatement/." /></headerfield>
				<headerfield name="subject"><xsl:for-each select="$XMLdocNodeset/document/metadata/meta[@name='document_cMep']/descendant::dc:subject/rdf:Bag/rdf:li" ><xsl:value-of select="."/><xsl:text> </xsl:text></xsl:for-each></headerfield>
			</header>
			<xsl:comment> **** GENERAL INFO: END **** </xsl:comment>


			<xsl:for-each select="$XMLdocNodeset/document/indd_document/sprd">
				<xsl:comment> **** SPREAD #<xsl:value-of select="@spread" /> **** </xsl:comment>
				<xsl:for-each select="page">
					<xsl:variable name="thepage"><xsl:value-of select="@page_sequence" /></xsl:variable>
					<xsl:comment> **** PAGE #<xsl:value-of select="$thepage" /> CONTENT: **** </xsl:comment>
	
					<page>
						<xsl:for-each select="@*">
							<xsl:choose>
								<xsl:when test="($outputXMLComplexity = '') or ($outputXMLComplexity = '0')">
									<xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:if test="(name() = 'page_sequence') or (name() = 'page_name')">
										<xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>
									</xsl:if>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
						<xsl:if test="pageJPEG">
							<pageJPEG>
								<xsl:attribute name="name"><xsl:value-of select="pageJPEG/."/></xsl:attribute>
								<xsl:attribute name="page_sequence"><xsl:value-of select="$thepage"/></xsl:attribute>
								<xsl:attribute name="page_name"><xsl:value-of select="@page_name"/></xsl:attribute>
								<xsl:attribute name="scale"><xsl:value-of select="pageJPEG/@scale"/></xsl:attribute>
								<xsl:attribute name="original"><xsl:value-of select="pageJPEG/@original"/></xsl:attribute>
								<xsl:if test="($outputXMLComplexity = '') or ($outputXMLComplexity = '0')">
									<xsl:attribute name="sizefactor"><xsl:value-of select="pageJPEG/@sizefactor"/></xsl:attribute>
									<xsl:attribute name="w"><xsl:value-of select="pageJPEG/@w"/></xsl:attribute>
									<xsl:attribute name="h"><xsl:value-of select="pageJPEG/@h"/></xsl:attribute>
								</xsl:if>
								<xsl:value-of select="privjs:encode_URI(string(pageJPEG/.),number(encodeNames))"/>
							</pageJPEG>
						</xsl:if>
						<xsl:if test="pageJPEG2">
							<pageJPEG2>
								<xsl:attribute name="name"><xsl:value-of select="pageJPEG2/."/></xsl:attribute>
								<xsl:attribute name="page_sequence"><xsl:value-of select="$thepage"/></xsl:attribute>
								<xsl:attribute name="page_name"><xsl:value-of select="@page_name"/></xsl:attribute>
								<xsl:attribute name="scale"><xsl:value-of select="pageJPEG2/@scale"/></xsl:attribute>
								<xsl:attribute name="original"><xsl:value-of select="pageJPEG2/@original"/></xsl:attribute>
								<xsl:if test="($outputXMLComplexity = '') or ($outputXMLComplexity = '0')">
									<xsl:attribute name="sizefactor"><xsl:value-of select="pageJPEG2/@sizefactor"/></xsl:attribute>
									<xsl:attribute name="w"><xsl:value-of select="pageJPEG2/@w"/></xsl:attribute>
									<xsl:attribute name="h"><xsl:value-of select="pageJPEG2/@h"/></xsl:attribute>
								</xsl:if>
								<xsl:value-of select="privjs:encode_URI(string(pageJPEG2/.),number(encodeNames))"/>
							</pageJPEG2>
						</xsl:if>
						<xsl:if test="pageJPEG3">
							<pageJPEG3>
								<xsl:attribute name="name"><xsl:value-of select="pageJPEG3/."/></xsl:attribute>
								<xsl:attribute name="page_sequence"><xsl:value-of select="$thepage"/></xsl:attribute>
								<xsl:attribute name="page_name"><xsl:value-of select="@page_name"/></xsl:attribute>
								<xsl:attribute name="scale"><xsl:value-of select="pageJPEG3/@scale"/></xsl:attribute>
								<xsl:attribute name="original"><xsl:value-of select="pageJPEG3/@original"/></xsl:attribute>
								<xsl:if test="($outputXMLComplexity = '') or ($outputXMLComplexity = '0')">
									<xsl:attribute name="sizefactor"><xsl:value-of select="pageJPEG3/@sizefactor"/></xsl:attribute>
									<xsl:attribute name="w"><xsl:value-of select="pageJPEG3/@w"/></xsl:attribute>
									<xsl:attribute name="h"><xsl:value-of select="pageJPEG3/@h"/></xsl:attribute>
								</xsl:if>
								<xsl:value-of select="privjs:encode_URI(string(pageJPEG3/.),number(encodeNames))"/>
							</pageJPEG3>
						</xsl:if>
						<xsl:if test="pageJPEG4">
							<pageJPEG4>
								<xsl:attribute name="name"><xsl:value-of select="pageJPEG4/."/></xsl:attribute>
								<xsl:attribute name="page_sequence"><xsl:value-of select="$thepage"/></xsl:attribute>
								<xsl:attribute name="page_name"><xsl:value-of select="@page_name"/></xsl:attribute>
								<xsl:attribute name="scale"><xsl:value-of select="pageJPEG4/@scale"/></xsl:attribute>
								<xsl:attribute name="original"><xsl:value-of select="pageJPEG4/@original"/></xsl:attribute>
								<xsl:if test="($outputXMLComplexity = '') or ($outputXMLComplexity = '0')">
									<xsl:attribute name="sizefactor"><xsl:value-of select="pageJPEG4/@sizefactor"/></xsl:attribute>
									<xsl:attribute name="w"><xsl:value-of select="pageJPEG4/@w"/></xsl:attribute>
									<xsl:attribute name="h"><xsl:value-of select="pageJPEG4/@h"/></xsl:attribute>
								</xsl:if>
								<xsl:value-of select="privjs:encode_URI(string(pageJPEG4/.),number(encodeNames))"/>
							</pageJPEG4>
						</xsl:if>
	
						<xsl:if test="pagePDF">
							<xsl:variable name="name" select="pagePDF/."/>
							<xsl:variable name="fullpath" select="pagePDF/@fullpath"/>
							<xsl:variable name="exists" select="locjs:fileExists(string($fullpath))"/>
							<xsl:if test="$exists = 'true'">
								<xsl:variable name="m">&#10;   ++ Copy page PDF: <xsl:value-of select="$name"/></xsl:variable>
								<xsl:variable name="d" select="myutils:showMess(string($m),'1')"/>
								<xsl:variable name="created" select="myutils:copyFile( string($INPUT_PATH), string($name), string($the_OUTPUT_PATH), string($name), 1, false)"/>
							</xsl:if>
				
							<pagePDF>
								<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
								<xsl:attribute name="page_sequence"><xsl:value-of select="$thepage"/></xsl:attribute>
								<xsl:attribute name="page_name"><xsl:value-of select="@page_name"/></xsl:attribute>
								<xsl:attribute name="fullpath"><xsl:value-of select="$fullpath"/></xsl:attribute>
								<xsl:value-of select="privjs:encode_URI(string(pagePDF/.),number(encodeNames))"/></pagePDF>
						</xsl:if>
	
						<xsl:if test="/document/articlegroups/page[@page_sequence=$thepage]"><!-- we have article groups on this page -->
							<xsl:call-template name="output_articles">
									<xsl:with-param name="thepage"><xsl:value-of select="$thepage"/></xsl:with-param>
									<xsl:with-param name="thepagename"><xsl:value-of select="@page_name"/></xsl:with-param>
							</xsl:call-template>
						</xsl:if>
					</page>
	
					<xsl:comment> **** PAGE #<xsl:value-of select="$thepage" /> CONTENT: END **** </xsl:comment>
				</xsl:for-each>
			</xsl:for-each>
	
			<xsl:if test="$XMLdocNodeset/document/indd_document/documentPDF">
				<xsl:variable name="name" select="$XMLdocNodeset/document/indd_document/documentPDF/."/>
				<xsl:variable name="fullpath" select="$XMLdocNodeset/document/indd_document/documentPDF/@fullpath"/>
				<xsl:variable name="exists" select="locjs:fileExists(string($fullpath))"/>
				<xsl:if test="$exists = 'true'">
					<xsl:variable name="m">&#10;   ++ Copy document PDF: <xsl:value-of select="$name"/></xsl:variable>
					<xsl:variable name="d" select="myutils:showMess(string($m),'1')"/>
					<xsl:variable name="created" select="myutils:copyFile( string($INPUT_PATH), string($name),  string($the_OUTPUT_PATH), string($name), 1, false)"/>
				</xsl:if>
	
				<documentPDF>
					<xsl:attribute name="fullpath"><xsl:value-of select="$fullpath"/></xsl:attribute>
					<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
					<xsl:value-of select="privjs:encode_URI(string($XMLdocNodeset/document/indd_document/documentPDF/.),number(encodeNames))"/></documentPDF>
			</xsl:if>

			<xsl:if test="($includeLayers = 1) and ($outputXMLComplexity = '') or ($outputXMLComplexity = '0')">
				<xsl:comment> **** layers info:  **** </xsl:comment>
				<xsl:copy-of select="$XMLdocNodeset/document/layers"/>
			</xsl:if>

			<xsl:if test="$XMLdocNodeset/document/extended_infos">
				<xsl:copy-of select="$XMLdocNodeset/document/extended_infos"/>
			</xsl:if>

			<xsl:if test="$includeMetaData = 1">
				<xsl:comment> **** mata data:  **** </xsl:comment>
				<xsl:copy-of select="$XMLdocNodeset/document/metadata"/>
			</xsl:if>

		</indd_document>
		<xsl:if test="$includeDescription = 1">
			<xsl:call-template name="includeDescription"/>
		</xsl:if>

	</xsl:template>




	<xsl:template name="output_articles"><!-- output the articles -->
		<xsl:param name="thepage"/>
		<xsl:param name="thepagename"/>
		<!-- show group boxes on this page -->
		<xsl:if test="(($outputXMLComplexity = '') or ($outputXMLComplexity = '0')) and (/document/indd_document/sprd/page[@page_sequence=$thepage]/descendant::group)">
			<groups>
				<xsl:attribute name="page_sequence"><xsl:value-of select="$thepage"/></xsl:attribute>
				<xsl:for-each select="/document/indd_document/sprd/page[@page_sequence=$thepage]/descendant::group">
					<group>
						<xsl:for-each select="@*">
							<xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>
						</xsl:for-each>
					</group>
				</xsl:for-each>
			</groups>
		</xsl:if>

		<xsl:for-each select="/document/articlegroups/page[@page_sequence=$thepage]"><!-- we have article groups on this page -->
			<xsl:comment> **** ARTICLES ON PAGE #<xsl:value-of select="@page_sequence"/>: **** </xsl:comment>
			<articles>
				<xsl:attribute name="page_sequence"><xsl:value-of select="@page_sequence"/></xsl:attribute>
		
				<xsl:for-each select="article">
					<xsl:sort data-type="number" select="box/@y1"/>
					<xsl:sort data-type="number" select="box/@x1"/>
					<xsl:comment> **** ARTICLE '<xsl:value-of select="@idx"/>' PAGE #<xsl:value-of select="@page"/>:  **** </xsl:comment>
					<xsl:variable name="page" select="@page"/>
					<article>
					  <xsl:attribute name="idx"><xsl:value-of select="@idx"/></xsl:attribute>
						<xsl:attribute name="page_sequence"><xsl:value-of select="$page"/></xsl:attribute>
						<xsl:attribute name="page_name"><xsl:value-of select="$thepagename"/></xsl:attribute>
						<xsl:attribute name="l"><xsl:value-of select="locjs:origsizeValue(string(@x1))"/></xsl:attribute>
						<xsl:attribute name="t"><xsl:value-of select="locjs:origsizeValue(string(@y1))"/></xsl:attribute>
						<xsl:attribute name="r"><xsl:value-of select="locjs:origsizeValue(string(@x2))"/></xsl:attribute>
						<xsl:attribute name="b"><xsl:value-of select="locjs:origsizeValue(string(@y2))"/></xsl:attribute>
						<xsl:if test="($outputXMLComplexity = '') or ($outputXMLComplexity = '0')">
							<!--xsl:attribute name="coords"><xsl:value-of select="locjs:resizeAreaCoords(string(@coords))"/></xsl:attribute-->
							<xsl:attribute name="coords"><xsl:value-of select="@coords"/></xsl:attribute>
							<xsl:attribute name="ls"><xsl:value-of select="@x1"/></xsl:attribute>
							<xsl:attribute name="ts"><xsl:value-of select="@y1"/></xsl:attribute>
							<xsl:attribute name="rs"><xsl:value-of select="@x2"/></xsl:attribute>
							<xsl:attribute name="bs"><xsl:value-of select="@y2"/></xsl:attribute>
						</xsl:if>
		
						<xsl:variable name="parent_storyid">
							<xsl:choose>
								<xsl:when test="@label and contains(@label,'prnt')">
									<xsl:value-of select="concat('prnt',substring-before(substring-after(@label,'prnt'),','),',')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:variable name="parent_storyid_tmp">
										<xsl:for-each select="descendant::box">
											<xsl:if test="@label and contains(@label,'prnt')">
												<xsl:value-of select="concat('prnt',substring-before(substring-after(@label,'prnt'),','),',')"/>
											</xsl:if>
										</xsl:for-each>
									</xsl:variable>
									<xsl:if test="$parent_storyid_tmp != ''">
										<xsl:value-of select="concat(substring-before($parent_storyid_tmp,','),',')"/>
									</xsl:if>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:if test="$parent_storyid != ''">
							<xsl:attribute name="parent_storyid"><xsl:value-of select="$parent_storyid" /></xsl:attribute>
						</xsl:if>
		
						<xsl:variable name="storyboxes">
							<xsl:for-each select="box[contains(@label,$parent_storyid)]">
								<xsl:sort data-type="number" select="@chainidx"/><!-- sort by chain idx. last one is next box in chain, first is previous box-->
								<xsl:copy-of select="."/>
							</xsl:for-each>
						</xsl:variable>
						<!-- get next box in chain -->
						<xsl:variable name="next_frame">
							<xsl:if test="contains(xalan:nodeset($storyboxes)//box[last()]/@label,';nf')">
								<xsl:value-of select="concat('tf',substring-before(substring-after(xalan:nodeset($storyboxes)//box[last()]/@label,';nf'),';'),';')"/>
							</xsl:if>
						</xsl:variable>
						<xsl:variable name="next_article_id">
							<xsl:if test="$next_frame !=''"><xsl:value-of select="/document/articlegroups/page/article/box[contains(@label,$next_frame) = 'true']/../@idx/."/></xsl:if>
						</xsl:variable>
						<xsl:variable name="next_article_page">
							<xsl:if test="$next_frame !=''"><xsl:value-of select="/document/articlegroups/page/article/box[contains(@label,$next_frame) = 'true']/../../@page_sequence/."/></xsl:if>
						</xsl:variable>
						<xsl:if test="$next_frame != ''">
							<xsl:attribute name="continuedframe"><xsl:value-of select="$next_frame" /></xsl:attribute>
						</xsl:if>
						<xsl:if test="$next_article_page != ''">
							<xsl:attribute name="continuedpage"><xsl:value-of select="$next_article_page" /></xsl:attribute>
						</xsl:if>
						<xsl:if test="$next_article_id != ''">
							<xsl:attribute name="continuedid"><xsl:value-of select="$next_article_id" /></xsl:attribute>
						</xsl:if>
		
						<!-- get previous box in chain -->
						<xsl:variable name="previous_frame">
							<xsl:if test="contains(xalan:nodeset($storyboxes)//box/@label,';pf')">
								<xsl:value-of select="concat('tf',substring-before(substring-after(xalan:nodeset($storyboxes)//box/@label,';pf'),';'),';')"/>
							</xsl:if>
						</xsl:variable>
						<xsl:variable name="previous_article_id">
							<xsl:if test="$previous_frame !=''"><xsl:value-of select="/document/articlegroups/page/article/box[contains(@label,$previous_frame) = 'true']/../@idx/."/></xsl:if>
						</xsl:variable>
						<xsl:variable name="previous_article_page">
							<xsl:if test="$previous_frame !=''"><xsl:value-of select="/document/articlegroups/page/article/box[contains(@label,$previous_frame) = 'true']/../../@page_sequence/."/></xsl:if>
						</xsl:variable>
						<xsl:if test="$previous_frame != ''">
							<xsl:attribute name="previousframe"><xsl:value-of select="$previous_frame" /></xsl:attribute>
						</xsl:if>
						<xsl:if test="$previous_article_page != ''">
							<xsl:attribute name="previouspage"><xsl:value-of select="$previous_article_page" /></xsl:attribute>
						</xsl:if>
						<xsl:if test="$previous_article_id != ''">
							<xsl:attribute name="previousid"><xsl:value-of select="$previous_article_id" /></xsl:attribute>
						</xsl:if>
		
		
						<xsl:if test="($outputXMLComplexity = '') or ($outputXMLComplexity = '0')">
							<boxchain>
								<xsl:for-each select="box">
									<xsl:sort data-type="number" select="@chainidx"/><!-- sort by chain idx -->
									<xsl:variable name="findboxid" select="@self"/><!-- get the box from indd_document (has more attribs) -->
									<box>
										<xsl:for-each select="/document/indd_document/sprd/page[@page_sequence=$page]/descendant::box[@Self=$findboxid]/@*">
											<xsl:choose>
												<xsl:when test="name() = 'backgroundColor'">
													<xsl:attribute name="backgroundColor"><xsl:if test="(. != '') and (. != 'transparent')">#</xsl:if><xsl:value-of select="."/></xsl:attribute>
												</xsl:when>
												<xsl:when test="name() = 'frameColor'">
													<xsl:attribute name="frameColor"><xsl:if test="(. != '') and (. != 'transparent')">#</xsl:if><xsl:value-of select="."/></xsl:attribute>
												</xsl:when>
												<xsl:when test="name() = 'frameWeight'">
													<xsl:attribute name="frameWeightX"><xsl:value-of select="."/></xsl:attribute>
													<xsl:attribute name="frameWeight"><xsl:if test=". != ''"><xsl:value-of select="pubjs:math_ceil(string(.))"/></xsl:if></xsl:attribute>
												</xsl:when>
												<xsl:when test="name() = 'coords'">
													<xsl:attribute name="coords"><xsl:value-of select="locjs:resizeAreaCoords(string(.))"/></xsl:attribute>
													<xsl:attribute name="coords_orig"><xsl:value-of select="."/></xsl:attribute>
												</xsl:when>
												<xsl:when test="name() = 'bbox'">
													<xsl:attribute name="bbox"><xsl:value-of select="."/></xsl:attribute>
												
													<!-- if we have a @bbox_orig then also have a scaled bbox -->
													<!--
													<xsl:choose>
														<xsl:when test="../@bbox_orig">
															<xsl:attribute name="bbox"><xsl:value-of select="."/></xsl:attribute>
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="bbox"><xsl:value-of select="locjs:resizeAreaCoords(string(.))"/></xsl:attribute>
														</xsl:otherwise>
													</xsl:choose>
													-->
												</xsl:when>
												<xsl:when test="name() = 'bbox_orig'">
													<xsl:attribute name="bbox_orig"><xsl:value-of select="."/></xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:for-each>
									</box>
								</xsl:for-each>
							</boxchain>
						</xsl:if>

						<xsl:for-each select="box">
							<xsl:variable name="findboxid" select="@self"/>
							<xsl:variable name="buttonaction"><xsl:value-of select="/document/indd_document/sprd/page[@page_sequence=$page]/descendant::box[@Self=$findboxid]/@action"/></xsl:variable>
							<xsl:variable name="thebox"><xsl:copy-of select="/document/indd_document/sprd/page[@page_sequence=$page]/descendant::box[@Self=$findboxid]/."/></xsl:variable>
							<xsl:variable name="theboxtype" select="xalan:nodeset($thebox)//@type"/>
							<!-- xsl:comment> == box type '<xsl:value-of select="$theboxtype"/>' == </xsl:comment -->
							<!-- #<xsl:value-of select="$buttonaction"/># -->
							<xsl:choose>
								<xsl:when test="$buttonaction='push'"></xsl:when><!-- push button images is handled below at $theboxtype='push' -->
								<xsl:when test="$theboxtype='text'">
									<xsl:apply-templates select="xalan:nodeset($thebox)" mode="create_output"/>
								</xsl:when>
								<xsl:when test="($theboxtype='chained_text') and ( ($outputXMLComplexity = '') or ($outputXMLComplexity = '0'))">
									<xsl:copy-of select="$thebox"/>
								</xsl:when>
								<xsl:when test="$theboxtype='line'">
									<xsl:copy-of select="$thebox"/>
								</xsl:when>
								<xsl:when test="$theboxtype='imag'">
									<xsl:apply-templates select="xalan:nodeset($thebox)" mode="create_output"/>
								</xsl:when>
								<xsl:when test="$theboxtype='push'">
									<xsl:copy-of select="$thebox"/>
									<!-- xsl:apply-templates select="xalan:nodeset($thebox)" mode="create_output"/ -->
								</xsl:when>
							</xsl:choose>
						</xsl:for-each>
						
						<textshortcut><xsl:value-of select="locjs:escape_quote(string(textshortcut/.))"/></textshortcut>
					</article>
					<xsl:comment> **** ARTICLE '<xsl:value-of select="@idx"/>' PAGE #<xsl:value-of select="@page"/>: END **** </xsl:comment>
				</xsl:for-each>
			</articles>
			<xsl:comment> **** ARTICLES ON PAGE #<xsl:value-of select="@page_sequence"/>: END **** </xsl:comment>
		</xsl:for-each>
	</xsl:template>



	<!-- all tags -->
	<xsl:template match="*" mode="create_output">
		<xsl:param name="continuedframe"/>
		<xsl:param name="continuedpage"/>
		<xsl:param name="continuedid"/>


		<xsl:choose>
			<xsl:when test="name() = 'HiddenText'"></xsl:when>
			<xsl:when test="(name() = 'area') and ($outputXMLComplexity != '') and ($outputXMLComplexity != '0')"></xsl:when>
			<xsl:when test="(name() = 'paraopts') and ($outputXMLComplexity != '') and ($outputXMLComplexity != '0')"></xsl:when>

			<xsl:when test="name() = 'contentElem'">
				<xsl:apply-templates select="*" mode="create_output"/>
			</xsl:when>

			<!-- anchored footnote boxes -->
			<xsl:when test="(name() = 'box') and (@type = 'footnote')">
				<xsl:variable name="d" select="locjs:store_splitlabel('')" /><!-- clear stored labels -->
				<xsl:element name="{name()}">
					<xsl:for-each select="@*">
						<xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>
					</xsl:for-each>
					<xsl:apply-templates select="*" mode="create_output"/>
				</xsl:element>
			</xsl:when>

			<!-- push buttons or anchored push buttons -->
			<xsl:when test="(name() = 'box') and (contains(@type,'push') = 'true')">
				<xsl:variable name="d" select="locjs:store_splitlabel(string(@label))" /><!-- prepare stored labels -->
				<xsl:element name="button">
					<xsl:for-each select="@*">
						<xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>
					</xsl:for-each>

					<xsl:if test="locjs:get_splitlabel('title:') != ''">
						<xsl:attribute name="title"><xsl:value-of select="locjs:get_splitlabel('title:')" /></xsl:attribute>
					</xsl:if>

					<xsl:if test="locjs:get_splitlabel('class:') != ''">
						<xsl:attribute name="mmclass"><xsl:value-of select="locjs:get_splitlabel('class:')" /></xsl:attribute>
					</xsl:if>
					<xsl:if test="locjs:get_splitlabel('style:') != ''">
						<xsl:attribute name="mmstyle"><xsl:value-of select="locjs:get_splitlabel('style:')" /></xsl:attribute>
					</xsl:if>
					<xsl:if test="locjs:get_splitlabel('id:') != ''">
						<xsl:attribute name="mmid"><xsl:value-of select="locjs:get_splitlabel('id:')" /></xsl:attribute>
					</xsl:if>
					<xsl:if test="locjs:get_splitlabel('script:') != ''">
						<xsl:attribute name="mmscript"><xsl:value-of select="locjs:get_splitlabel('script:')" /></xsl:attribute>
					</xsl:if>


					<xsl:if test="locjs:get_splitlabel('moviewidth:') != ''">
						<xsl:attribute name="moviewidth"><xsl:value-of select="locjs:get_splitlabel('moviewidth:')" /></xsl:attribute>
					</xsl:if>
					<xsl:if test="locjs:get_splitlabel('movieheight:') != ''">
						<xsl:attribute name="movieheight"><xsl:value-of select="locjs:get_splitlabel('movieheight:')" /></xsl:attribute>
					</xsl:if>
					<xsl:if test="locjs:get_splitlabel('moviecontrols:') != ''">
						<xsl:attribute name="moviecontrols"><xsl:value-of select="locjs:get_splitlabel('moviecontrols:')" /></xsl:attribute>
					</xsl:if>
					<xsl:if test="locjs:get_splitlabel('movieautoplay:') != ''">
						<xsl:attribute name="movieautoplay"><xsl:value-of select="locjs:get_splitlabel('movieautoplay:')" /></xsl:attribute>
					</xsl:if>
					<xsl:if test="locjs:get_splitlabel('movietype:') != ''">
						<xsl:attribute name="movietype"><xsl:value-of select="locjs:get_splitlabel('movietype:')" /></xsl:attribute>
					</xsl:if>
					<xsl:if test="locjs:get_splitlabel('movieprimary:') != ''">
						<xsl:attribute name="movieprimary"><xsl:value-of select="locjs:get_splitlabel('movieprimary:')" /></xsl:attribute>
					</xsl:if>
					<xsl:if test="locjs:get_splitlabel('moviealternate:') != ''">
						<xsl:attribute name="moviealternate"><xsl:value-of select="locjs:get_splitlabel('moviealternate:')" /></xsl:attribute>
					</xsl:if>


					<xsl:if test="locjs:get_splitlabel('soundwidth:') != ''">
						<xsl:attribute name="soundwidth"><xsl:value-of select="locjs:get_splitlabel('soundwidth:')" /></xsl:attribute>
					</xsl:if>
					<xsl:if test="locjs:get_splitlabel('soundheight:') != ''">
						<xsl:attribute name="soundheight"><xsl:value-of select="locjs:get_splitlabel('soundheight:')" /></xsl:attribute>
					</xsl:if>
					<xsl:if test="locjs:get_splitlabel('soundcontrols:') != ''">
						<xsl:attribute name="soundcontrols"><xsl:value-of select="locjs:get_splitlabel('soundcontrols:')" /></xsl:attribute>
					</xsl:if>
					<xsl:if test="locjs:get_splitlabel('soundautoplay:') != ''">
						<xsl:attribute name="soundautoplay"><xsl:value-of select="locjs:get_splitlabel('soundautoplay:')" /></xsl:attribute>
					</xsl:if>
					<xsl:if test="locjs:get_splitlabel('soundtype:') != ''">
						<xsl:attribute name="soundtype"><xsl:value-of select="locjs:get_splitlabel('soundtype:')" /></xsl:attribute>
					</xsl:if>
					<xsl:if test="locjs:get_splitlabel('soundprimary:') != ''">
						<xsl:attribute name="soundprimary"><xsl:value-of select="locjs:get_splitlabel('soundprimary:')" /></xsl:attribute>
					</xsl:if>
					<xsl:if test="locjs:get_splitlabel('soundalternate:') != ''">
						<xsl:attribute name="soundalternate"><xsl:value-of select="locjs:get_splitlabel('soundalternate:')" /></xsl:attribute>
					</xsl:if>
					<xsl:apply-templates select="*" mode="create_output"/>
				</xsl:element>
			</xsl:when>

			<!-- anchored boxes -->
			<xsl:when test="(name() = 'box') and (contains(@type,'anchored_') = 'true')">
				<xsl:variable name="d" select="locjs:store_splitlabel('')" /><!-- clear stored labels -->
				<xsl:element name="{name()}">
					<xsl:for-each select="@*">
						<xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>
					</xsl:for-each>
					<xsl:apply-templates select="*" mode="create_output"/>
				</xsl:element>
			</xsl:when>

			<xsl:when test="name() = 'box'"><xsl:apply-templates select="*" mode="create_output"/></xsl:when><!-- don't output box elements for other boxes. must be taken from boxchain -->

			<xsl:otherwise>
				<xsl:variable name="d" select="locjs:store_splitlabel('')" /><!-- clear stored labels -->
				<xsl:element name="{name()}">
					<!-- store an evtl. available in content attribut label -->
					<xsl:variable name="content_label">
						<xsl:choose>
							<xsl:when test="(name() = 'content') and (@label != '')">
								<xsl:if test="contains(@label,'##') = 'true'"><xsl:variable name="d" select="locjs:store_splitlabel(string(@label))" /></xsl:if>
								<xsl:value-of select="string(@label)" />
							</xsl:when>
							<xsl:when test="(name() = 'content') and (../@label != '')"><!-- get from parent box -->
								<xsl:if test="contains(../@label,'##') = 'true'"><xsl:variable name="d" select="locjs:store_splitlabel(string(../@label))" /></xsl:if>
								<xsl:value-of select="string(../@label)" />
							</xsl:when>
							<xsl:when test="(name(parent::node()) = 'content') and (../@label != '')">
								<xsl:if test="contains(../@label,'##') = 'true'"><xsl:variable name="d" select="locjs:store_splitlabel(string(../@label))" /></xsl:if>
								<xsl:value-of select="string(../@label)" />
							</xsl:when>
							<xsl:otherwise></xsl:otherwise>
						</xsl:choose>
					</xsl:variable>

					<xsl:for-each select="@*">
						<!-- element attributes may be adjusted here -->
						<xsl:choose>
							<xsl:when test="(name() = 'wwwLink') or (name() = 'urlLink')"></xsl:when><!-- remove non W3C conforme attributes -->
							<xsl:when test="contains(name(),'textInset')"></xsl:when>
							<xsl:when test="contains(name(),'borderLeft') or contains(name(),'borderTop') or contains(name(),'borderRight') or contains(name(),'borderBottom')"></xsl:when>

							<xsl:when test="name() = 'label'">
								<xsl:choose>
									<xsl:when test=". != ''">
										<xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>
									</xsl:when>
									<xsl:when test="$content_label != ''">
										<xsl:attribute name="{name()}"><xsl:value-of select="$content_label" /></xsl:attribute>
									</xsl:when>
									<xsl:otherwise><!-- is empty label -->
										<xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>

							<!-- adjust style attributes -->
							<xsl:when test="(name() = 'style')">
								<xsl:choose>
									<!-- uncomment to remove font-family from style attributes
									<xsl:when test="(name(parent::node()) = 'span') or (name(parent::node()) = 'div')">
										<xsl:variable name="newattr" select="locjs:allTrim(string(locjs:re_replace(string(.),'font-family:.+?;','','gi')))"/>
										<xsl:if test="$newattr != ''"><xsl:attribute name="{name()}"><xsl:value-of select="$newattr" /></xsl:attribute></xsl:if>
									</xsl:when>
									-->

									<xsl:when test="(name(parent::node()) = 'tr') or (name(parent::node()) = 'td')">
										<xsl:variable name="newattr" select="locjs:allTrim(string(locjs:re_replace(string(.),'height:.+?;','','gi')))"/>
										<xsl:if test="$newattr != ''"><xsl:attribute name="{name()}"><xsl:value-of select="$newattr" /></xsl:attribute></xsl:if>
									</xsl:when>

									<xsl:otherwise>
										<xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>

							<!-- suppress attributes in simple XML -->
							<xsl:when test="(($outputXMLComplexity != '') and ($outputXMLComplexity != '0')) and 
											( (name() = 'Self') or (name() = 'id') or (name() = 'groupid') or (name() = 'anchor_id') or (name() = 'label') or (name() = 'angle') or (name() = 'scaleX') or (name() = 'scaleY') )
											">
							</xsl:when>

							<xsl:otherwise><!-- all other attributes are left as they are -->
								<xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>

					<!-- Deal with parent content attribut label -->
					<xsl:if test="$content_label != ''"><!-- add attribs derived from label attribute of content element -->
						<xsl:if test="locjs:get_splitlabel('title:') != ''">
							<xsl:attribute name="title"><xsl:value-of select="locjs:get_splitlabel('title:')" /></xsl:attribute>
						</xsl:if>
					</xsl:if>

					<!-- Deal with parent box attributes like: backgroundColor -->
					<xsl:if test="name() = 'content'">
						<xsl:choose>
							<xsl:when test="../@backgroundColor">
								<xsl:attribute name="backgroundColor"><xsl:if test="(../@backgroundColor/. != '') and (../@backgroundColor/. != 'transparent')">#</xsl:if><xsl:value-of select="../@backgroundColor"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise></xsl:otherwise>
						</xsl:choose>

						<xsl:if test="../@x1 != ''"><xsl:attribute name="x1"><xsl:value-of select="../@x1"/></xsl:attribute></xsl:if>
						<xsl:if test="../@y1 != ''"><xsl:attribute name="y1"><xsl:value-of select="../@y1"/></xsl:attribute></xsl:if>
						<xsl:if test="../@x2 != ''"><xsl:attribute name="x2"><xsl:value-of select="../@x2"/></xsl:attribute></xsl:if>
						<xsl:if test="../@y2 != ''"><xsl:attribute name="y2"><xsl:value-of select="../@y2"/></xsl:attribute></xsl:if>
						<xsl:if test="../coords != ''"><xsl:attribute name="coords"><xsl:value-of select="../@coords"/></xsl:attribute></xsl:if>

						<xsl:if test="../@frameWeight != ''">
							<xsl:attribute name="frameWeight"><xsl:value-of select="../@frameWeight"/></xsl:attribute>
							<xsl:attribute name="frameStyleName"><xsl:value-of select="../@frameStyleName"/></xsl:attribute>
							<xsl:attribute name="frameStyleHTML"><xsl:value-of select="../@frameStyleHTML"/></xsl:attribute>
							<xsl:attribute name="frameColor"><xsl:value-of select="../@frameColor"/></xsl:attribute>
						</xsl:if>
						<xsl:if test="contains(@type,'text')">
							<xsl:attribute name="insetTopR"><xsl:value-of select="../@insetTopR"/></xsl:attribute>
							<xsl:attribute name="insetLeftR"><xsl:value-of select="../@insetLeftR"/></xsl:attribute>
							<xsl:attribute name="insetBottomR"><xsl:value-of select="../@insetBottomR"/></xsl:attribute>
							<xsl:attribute name="insetRightR"><xsl:value-of select="../@insetRightR"/></xsl:attribute>
							<xsl:attribute name="insetTop"><xsl:value-of select="../@insetTop"/></xsl:attribute>
							<xsl:attribute name="insetLeft"><xsl:value-of select="../@insetLeft"/></xsl:attribute>
							<xsl:attribute name="insetBottom"><xsl:value-of select="../@insetBottom"/></xsl:attribute>
							<xsl:attribute name="insetRight"><xsl:value-of select="../@insetRight"/></xsl:attribute>
						</xsl:if>
					</xsl:if>

					<!-- Deal with content for certain very special attributes like: wwwLink, urlLink -->
					<xsl:choose>
						<xsl:when test="@wwwLink">
							<xsl:variable name="href_url">
								<xsl:choose>
									<xsl:when test="starts-with(@wwwLink,'http://') = 'true'"><xsl:value-of select="@wwwLink"/></xsl:when>
									<xsl:when test="starts-with(@wwwLink,'https://') = 'true'"><xsl:value-of select="@wwwLink"/></xsl:when>
									<xsl:when test="starts-with(@wwwLink,'mailto:') = 'true'"><xsl:value-of select="@wwwLink"/></xsl:when>
									<xsl:otherwise>http://<xsl:value-of select="@wwwLink"/></xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							<xsl:choose>
								<xsl:when test="(name() = 'span') or ((name() = 'div') and not(child::*/@wwwLink))">
									<a target="_blank">
										<xsl:if test="@class"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if>
										<xsl:attribute name="href"><xsl:value-of select="$href_url"/></xsl:attribute><xsl:apply-templates mode="create_output"/></a>
								</xsl:when>
								<xsl:otherwise>
									<xsl:apply-templates mode="create_output"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="@urlLink">
							<xsl:variable name="href_url">
								<xsl:choose>
									<xsl:when test="starts-with(@urlLink,'http://') = 'true'"><xsl:value-of select="@urlLink"/></xsl:when>
									<xsl:when test="starts-with(@urlLink,'https://') = 'true'"><xsl:value-of select="@urlLink"/></xsl:when>
									<xsl:when test="starts-with(@urlLink,'mailto:') = 'true'"><xsl:value-of select="@urlLink"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="@urlLink"/></xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							<xsl:choose>
								<xsl:when test="(name() = 'span') or ((name() = 'div') and not(child::*/@urlLink))">
									<a target="_blank">
										<xsl:if test="@class"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if>
										<xsl:attribute name="href"><xsl:value-of select="$href_url"/></xsl:attribute><xsl:apply-templates mode="create_output"/></a>
								</xsl:when>
								<xsl:otherwise>
									<xsl:apply-templates mode="create_output"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:apply-templates mode="create_output">
								<xsl:with-param name="continuedframe"><xsl:value-of select="$continuedframe"/></xsl:with-param>
								<xsl:with-param name="continuedpage"><xsl:value-of select="$continuedpage"/></xsl:with-param>
								<xsl:with-param name="continuedid"><xsl:value-of select="$continuedid"/></xsl:with-param>
							</xsl:apply-templates>
						</xsl:otherwise>
					</xsl:choose>

					<!-- evtl. add text from parent content attribut label when all elements are processed -->
					<xsl:if test="($content_label != '') and (name() = 'content')"><!-- add text derived from label attribute of content element -->
						<xsl:if test="locjs:get_splitlabel('text:') != ''">
							<xsl:value-of select="locjs:get_splitlabel('text:')" disable-output-escaping="yes" />
						</xsl:if>
					</xsl:if>

				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<!-- image tags evtl, with active link -->
	<xsl:template match="img" mode="create_output">
		<xsl:variable name="d" select="locjs:store_splitlabel(string(../@label))" />
		<xsl:choose>
			<xsl:when test="locjs:get_splitlabel('href:') != ''">
				<!-- embed image into link: opens site when klicked on image -->
				<a>
					<xsl:attribute name="href"><xsl:value-of select="locjs:get_splitlabel('href:')" /></xsl:attribute>
					<xsl:if test="locjs:get_splitlabel('target:') != ''">
						<xsl:attribute name="target"><xsl:value-of select="locjs:get_splitlabel('target:')" /></xsl:attribute>
					</xsl:if>
					<xsl:if test="locjs:get_splitlabel('title:') != ''">
						<xsl:attribute name="title"><xsl:value-of select="locjs:get_splitlabel('title:')" /></xsl:attribute>
					</xsl:if>
					<xsl:call-template name="get_imagecontent">
						<xsl:with-param name="clearborder">1</xsl:with-param>
					</xsl:call-template>
				</a>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="get_imagecontent"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- image tags content -->
	<xsl:template name="get_imagecontent">
		<xsl:param name="clearborder"/>
		<xsl:element name="img">
			<xsl:for-each select="@*">
				<xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>
			</xsl:for-each>
			<xsl:if test="$clearborder = '1'"><!-- add attribs derived from label attribute  of content element -->
				<xsl:attribute name="border">0</xsl:attribute>
			</xsl:if>
			<xsl:if test="(../@label != '') and ( contains(../@label,'##') = 'true')"><!-- add attribs derived from label attribute  of content element -->
				<xsl:if test="locjs:get_splitlabel('title:') != ''">
					<xsl:attribute name="title"><xsl:value-of select="locjs:get_splitlabel('title:')" /></xsl:attribute>
				</xsl:if>
			</xsl:if>
			<xsl:copy-of select="metadata"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="debugstr" mode="create_output"></xsl:template>
	<xsl:template match="textshortcut" mode="create_output"></xsl:template>

	<!-- ===============================================
		 the processing-instruction for anchored objects like boxes and footnotes in txsr/pcnt
		 like anchored objects: <?customXMLstart element="elemname"?>
	     =============================================== -->
	<xsl:template match="processing-instruction()" mode="create_output">
		<xsl:processing-instruction name="{name()}">
			<xsl:value-of select="."/>
		</xsl:processing-instruction>
	</xsl:template>


	<!-- ===============================================
		 the plain text content
	     =============================================== -->
	<xsl:template match="text()" mode="create_output">
		<xsl:choose>
			<xsl:when test=". = '&#x0a;'"></xsl:when><!-- remove any combination of line breaks -->
			<xsl:when test=". = '&#x0d;'"></xsl:when>
			<xsl:when test=". = '&#x0d;&#x0a;'"></xsl:when>
			<xsl:otherwise><xsl:value-of disable-output-escaping="no" select="."/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>





	<!-- ===============================================
		 show creator comment for this output
	     =============================================== -->
	<xsl:template name="show_creator">
			<xsl:param name="creationYear"/>
			<xsl:param name="creationDate"/>
			<xsl:param name="creationTime"/>
			<xsl:param name="outputVersion"/>
			<xsl:param name="inputPath"/>
			<xsl:param name="indesignDocname"/>
			<xsl:param name="sourceINXfileName"/>
			<xsl:param name="operatingSystem"/>
			<xsl:param name="vmVersion"/>
			<xsl:param name="transformEngine"/>
			<xsl:param name="xsltVersion"/>
			<xsl:param name="xsltVersionDate"/>
<xsl:comment>
Creation Year: <xsl:value-of select="$creationYear" />
Creation Date: <xsl:value-of select="$creationDate" />
Creation Time: <xsl:value-of select="$creationTime" />
Output Version: <xsl:value-of select="$outputVersion" />
Input Path: <xsl:value-of select="$inputPath" />
Indesign Document Name: <xsl:value-of select="$indesignDocname" />
Source INX File Name: <xsl:value-of select="$sourceINXfileName" />
Operating System: <xsl:value-of select="$operatingSystem" />
VM Version: <xsl:value-of select="$vmVersion" />
XSLT Version: <xsl:value-of select="$xsltVersion" />
XSLT Version Date: <xsl:value-of select="$xsltVersionDate" />
Transformer Engine Name: <xsl:value-of select="$transformEngine" /> (CopyRight www.AiEDV.ch, ALL RIGHTS RESERVED) 
</xsl:comment>
	</xsl:template>







	<!-- ===============================================
		 the textual description of this output
	     =============================================== -->
	<xsl:template name="includeDescription">
<xsl:text>
</xsl:text>
<xsl:comment>
Output Format Description
=========================
GENERAL
=======
This output represents the content of the original Indesign document.
This XML file may be pushed into a database, viewed in a browser as an ePaper
or it may be transformed into any other output format.
The above content between the 'indd_document' tags is devided into several sections.
Each section is marked with a comment like '**** PAGE #...' and ended with a corresponding END comment.


SECTIONS DESCRIPTION (Content within the 'indd_document' tag)
====================

&lt;indd_document&gt;

**** GENERAL INFO:  ****
   1. A 'doctypeinfos' element containing the name of the css stylesheet to use.
   2. Information about the document in a comment
   3. the same information enclosed in a 'header' tag

**** PAGE #1 CONTENT: ****
   &lt;page&gt; A page's content containing two sub-sections:

   &lt;pageJPEG&gt; element with information on the page's JPEG
   
   and
   **** ARTICLES ON PAGE #1: ****
   &lt;articles&gt; containing all articles on this page.

      **** ARTICLE '0' PAGE #1: ****
      &lt;article&gt; containing an article's elements:
         &lt;content&gt; the container for the article.
         &lt;textshortcut&gt; a shortcut of the article's content.

      ... more articles

      **** ARTICLE 'X' PAGE #1:  ****
      The last article.


... more pages

**** PAGE #lastpage CONTENT: ****

&lt;documentPDF&gt; containing the information to the document's PDF if such a PDF was requested.

&lt;layers&gt; containing the information on layers if flag includeLayers is set to 1.

&lt;extended_infos&gt; extended infos in Pro version only: paragraph and character style sheets, table and object styles, color, fonts.

&lt;metadata&gt; containing detailed fonts information if flag includeMetaData is set to 1.

&lt;/indd_document&gt;


========== END ==========
</xsl:comment>
 	</xsl:template>


	<!-- =========================
		 our local JAVA Script functions
		 ========================= -->
	<lxslt:component prefix="privjs">
	<lxslt:script lang="javascript">
	//<![CDATA[
	function encode_URI(uri,mode) {
		// replace very special charactern
		var my_uri = uri.replace(/\#/g,"x23");
		my_uri = my_uri.replace(/\&/g,"x26");
		my_uri = my_uri.replace(/\?/g,"x3F");
		
		if(!mode || ( mode === 0) || ( mode === false)) return(my_uri);
		
		my_uri = encodeURI(uri);
		return (my_uri);
	}
	
	function retrieve_objectShortcut(docname) {	// get an id from document name
		if ( (docname == null) || (docname == "") ) return("");
		var mydocname = docname;
		if (mydocname.indexOf(".") >= 0) mydocname = mydocname.substr(0,mydocname.lastIndexOf("."));
		var start_underscore = mydocname.indexOf("_");
		var start_blank = mydocname.indexOf(" ");
		var start_divis = mydocname.indexOf("-");
		var start_dot = mydocname.indexOf(".");
		var end = mydocname.length;
		var end_was_set = false;
		if ((start_underscore < end) && (start_underscore >= 2)) { end = start_underscore; end_was_set = true; }
		if ((start_blank < end) && (start_blank >= 2)) { end = start_blank; end_was_set = true; }
		if ((start_divis < end) && (start_divis >= 2)) { end = start_divis; end_was_set = true; }
		if ((start_dot < end) && (start_dot >= 2)) { end = start_dot; end_was_set = true; }
		if (end_was_set == false) {
			if ((end < 2) || (end > 6)) end = 4;
		}
		if (end > mydocname.length) object_id = mydocname;
		else object_id = mydocname.substring(0,end);
		return (object_id);
	}

	var issueYear = "",
		issueDate = "";

	function retrieve_issue_year_date(docname,fullpath,getyear) {
		// retrieve an issue date and year from document name if a number like 20080423 (YYYYMMDD) is contained.
		// otherwise, try to retrieve from export path
		//
		// assume we have exported the layouts from this path
		//		Macintosh HD:ePaperData:Xport:inSRC:COMPANY:OBJECT:YEAR:ISSUE:
		//   and the document has a naming convention like this SSS-YYYYMMDD-##-section
		//		where sss = a 2-3 digits shortcut for the object
		//		where YYYYMMDD = the issue date
		//		where ## = the page number
	
	
		// first, try get issue year and date from the document name
		// if we have no document date in the form YYYYMMDD - 8 following digits we have to try to get it from the path
		var s = "";
		// ok - lets try to find 8 following digits from the given 'docname'
		var found_a_date = false;
		var string_to_search = unescape(docname);
		var run = 1;
		var monthdayObj = new Object();
		monthdayObj.day = "";
		monthdayObj.month = "";
	
		while ((found_a_date != true) && (run <= 3)) {
			switch(run) {
				case 1:	// try to get full 8 digits date from document name
				case 2:	// try to get full 8 digits date from path name
					for (var i=0; i < string_to_search.length-7; i++) {
						if (	(string_to_search.charAt(i)!=" ") && (isNaN(string_to_search.charAt(i))==false)
								&& (isNaN(string_to_search.charAt(i+1))==false)
								&& (isNaN(string_to_search.charAt(i+2))==false)
								&& (isNaN(string_to_search.charAt(i+3))==false)
								&& (isNaN(string_to_search.charAt(i+4))==false)
								&& (isNaN(string_to_search.charAt(i+5))==false)
								&& (isNaN(string_to_search.charAt(i+6))==false)
								&& (isNaN(string_to_search.charAt(i+7))==false)
							) {
								found_a_date = true;
								issueYear = string_to_search.substr(i,4);
								issueDate = string_to_search.substr(i,8);
								break;
						}
					}
					break;
				case 3: 	// try to get 4 digits year from document name
					for (var i=0; i < string_to_search.length-3; i++) {
						if (	(string_to_search.charAt(i)!=" ") 
								&& (isNaN(string_to_search.charAt(i))==false)
								&& (isNaN(string_to_search.charAt(i+1))==false)
								&& (isNaN(string_to_search.charAt(i+2))==false)
								&& (isNaN(string_to_search.charAt(i+3))==false) ) {
							issueYear = string_to_search.substr(i,4);
							if ( (issueYear.indexOf(".") >= 0) || (parseInt(issueYear) > 2050) ) {
								issueYear = "";
								continue;
							}
							found_a_date = true;
							issueDate = "";
							// try to find a month in a docname like: le-provencal-de-paris-1908-11-15
							var nameparts = null;
							do {	// try to get a 2 digits month
								if (string_to_search.indexOf("_") > 0) {
									nameparts = string_to_search.split("_");
									get_issueMonthDay(nameparts,monthdayObj);
									if (monthdayObj.month != "") break;
								}
								if (string_to_search.indexOf("-") > 0) {
									nameparts = string_to_search.split("-");
									get_issueMonthDay(nameparts,monthdayObj);
									if (monthdayObj.month != "") break;
								}
								if (string_to_search.indexOf(" ") > 0) {
									nameparts = string_to_search.split(" ");
									get_issueMonthDay(nameparts,monthdayObj);
									if (monthdayObj.month != "") break;
								}
								if (string_to_search.indexOf("/") > 0) {
									nameparts = string_to_search.split("/");
									get_issueMonthDay(nameparts,monthdayObj);
									if (monthdayObj.month != "") break;
								}
							} while(false);
							break;
						}
					}
					break;
			}
			if (found_a_date == true) break;
			if (run > 3) break;
			switch (run) {
				case 1: string_to_search = unescape(fullpath);
					break;
				case 2: string_to_search = unescape(docname);
					break;
			}
			run++;
		}
	
		// get current date
		if ((found_a_date == false) || ((issueYear == "") || (issueDate == ""))) {
			var now = new Date();
			var year = "";
			if (found_a_date == false) year = "" + now.getFullYear();
			else year = issueYear;
			var month = "";
			if (monthdayObj.month != "") month = monthdayObj.month;
			else month = "" + (now.getMonth() + 1);
			if (month.length < 2) month = "0" + month;
			var day = "";
			if (monthdayObj.day != "") day = monthdayObj.day;
			else day = "" + now.getDate();
			if (day.length < 2) day = "0" + day;
			//alert("monthdayObj.month: " + monthdayObj.month + "\nmonthdayObj.day: " + monthdayObj.day
			//	+ "\nmonth: " + month + "\nday: " + day);
			issueYear = year;
			issueDate = year + month + day;
		}
		if (getyear) return (issueYear);
		return (issueDate);
	}
	function retrieve_issue_date() {	// must be called after retrieve_issue_year_date()
		return (issueDate);
	}

	function get_issueMonthDay(nameparts,monthday) {	// get a 2 digits month from a string array
		if (nameparts == null) return("");
		var m = 0;
		for (m = 0; m < nameparts.length; m++) {	// try to get a 2 digits month
			if (nameparts[m].length != 2) continue;
			if ((nameparts[m].charAt(0)!=" ") && (isNaN(nameparts[m].charAt(0))==false)
					&& (nameparts[m].charAt(1)!=" ") && (isNaN(nameparts[m].charAt(1))==false)) {
					monthday.month = "" + nameparts[m];
					break;
			}
		}
		if ((m+1) >= (nameparts.length)) return;
		// get day in next part
		if ((nameparts[m + 1].charAt(0)!=" ") && (isNaN(nameparts[m + 1].charAt(0))==false)
				&& (nameparts[m + 1].charAt(1)!=" ") && (isNaN(nameparts[m + 1].charAt(1))==false)) {
				monthday.day = nameparts[m + 1].substr(0,2);
		}
		return;
	}
	
	//]]>
	</lxslt:script>
	</lxslt:component>

</xsl:stylesheet>
