/*
 ======================================================================
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.

THE PRODUCER:
Andreas Imhof
ai@aiedv.ch

Version: 46
Version date: 20200219
20171025: fixed a bug in font conversion tables convertWithFontTable()
20171005: enhanced CMYK JPEGs to sRGB conversion: additional output profile sRGB.icc for ImageMagick
20160124: enhanced font conversion tables for indic non-unicode aware fonts to unicodes
20160101: Fixed: rectangle integers out of range
20151125: enhanced font conversion table for indic non-unicode aware fonts to unicodes
20150522: Fixed loading font conversion tables (function loadFontConversionTable())
20141114: InDesign CC 2014 has DOM version 10.1
20140802: work with DOM v 10.x InDesign CC 2014
20140629: corrected table cell borders
		  fixed objects styles handling
20140409: handle areas of page overlapping boxes (in panorama pages)
20120622: handle HiddenText
======================================================================
*/

/* ======================================
	general functions and variables to controle the transformation
*/
var DEBUG = 0;			// is set by the content of XSL variable 'DEBUG'
var DEBUGIMAGES = 0;	// debug image functions only
var DEBUG_text = false;	// set to true to show article text runs in browser
var DEBUG_cssfile = false;	// set to true to show article text runs in browser

var DOMVersion = "7.0";	// set to default to CS2 dom 4.0, CS3 = 5.0, CS4 = 6.0, CS5 = 7.0, CS5.5 = 7.5, CS6 = 8.0, CC = 9.0, CC 2014 = 10.x

var indd_docname = "";	// the original Indesign document name without name extension

	// remove part bejond '(' like in non internet save fontfamily names like "Helvetica Neue (T1)"
var MAKE_INTERNET_AWARE_FONTNAMES = true;


var DEG2RAD = Math.PI/180;
var RAD2DEG = 180/Math.PI;


function main_DOMVersion(version) {	// return main DOM version
	if (version == '') return "";
	var versParts = version.split("."),
		domVers = parseInt(versParts[0],10);
	return domVers;
}
function set_DOMVersion(version) {	// set indd dom version
	if (version == '') return;
	DOMVersion = version;
	return;
}
function set_internet_aware_fonttnames(val) {	// get indd document name
	if (val == '1') MAKE_INTERNET_AWARE_FONTNAMES = true;
	else MAKE_INTERNET_AWARE_FONTNAMES = false;
	return;
}

var outputFeatures = 0;	// 0 = dont't output PRO additional attributes = Standard version
						// 2 = output PRO additional attributes
function store_outputFeatures(outputFeatures_str) {	// store output features
	if ((outputFeatures_str == null) || (outputFeatures_str == "")) return;
	try {
		outputFeatures = parseInt(outputFeatures_str,10);
	}
	catch (e) {}
	return(outputFeatures);
}
function get_outputFeatures() {	// check for enabled features
	return(outputFeatures);
}
var includeXMLtags = "0";
function store_includeXMLtags(includeXMLtags_str) {	// '0' or '1'
	includeXMLtags = includeXMLtags_str;
}
function get_includeXMLtags() {	// '0' or '1'
	return(includeXMLtags);
}

var addRuntypeInfo = 0;	// 0 = dont't output PRO additional runtype info


function store_indd_docname(path,inx_name) {	// store and split the path of the original indd document
									// and split the folders into an array
	var doc_path_arr;
	var cur_date = new Date();
	indd_docname = cur_date.getTime() + "genericINDDName";	// initialize
	var my_indd_docname = "";
	if ( ((path == null) || (path == "")) && ((inx_name == null) || (inx_name == "")) ) return (indd_docname);

	if ((path != null) && (path != "")) {
		do {	// generic URL path
			// Windows
			if ((path.indexOf(":\\") >= 0) || (path.indexOf("\\\\") >= 0)) {	// like c:\path... or \\192.168.23.12\path
				doc_path_arr = path.split("\\");
				break;
			}
			// mac
			if (path.indexOf(":") > 0) {	// like Volumes:myvol:fldr...
				doc_path_arr = path.split(":");
				break;
			}
			// other
			doc_path_arr = path.split("/");	// like Volumes/myvol/fldr...
		} while(false);
		my_indd_docname = doc_path_arr[doc_path_arr.length-1];
	}
	else {
		my_indd_docname = inx_name;
	}
	if ( (my_indd_docname == null) || (my_indd_docname == "") ) return (indd_docname);

	if (my_indd_docname.lastIndexOf(".") >= 0) {
		do {
			if (my_indd_docname.toLowerCase().lastIndexOf(".indd") >= 0) {
				my_indd_docname = my_indd_docname.substr(0,my_indd_docname.toLowerCase().lastIndexOf(".indd"));
				break;
			}
			if (my_indd_docname.toLowerCase().lastIndexOf(".inx") >= 0) {
				my_indd_docname = my_indd_docname.substr(0,my_indd_docname.toLowerCase().lastIndexOf(".inx"));
				break;
			}
			if (my_indd_docname.toLowerCase().lastIndexOf(".imx") >= 0) {
				my_indd_docname = my_indd_docname.substr(0,my_indd_docname.toLowerCase().lastIndexOf(".imx"));
				break;
			}
		} while(false);
	}
	my_indd_docname = my_indd_docname.replace(/~sep~/g,'_');
	indd_docname = my_indd_docname;
	if (DEBUG > 0) java.lang.System.out.println ("**** converting inx for document: '" + indd_docname + "', inx_name: '" + inx_name + "' ******");
	return (indd_docname);
}
function get_indd_docname() {	// get indd document name
	return indd_docname;
}

var system_os_name = "";	// the platform
var platformCRLF = "\n";	// set Unix CR LF
function set_system_os_name(os_name) {	// get indd document name
	system_os_name = os_name;
	if (system_os_name.toLowerCase().indexOf("win") >= 0) platformCRLF = "\r\n";
	return;
}

function set_debug_mode(debug_mode) {
	if (parseInt(debug_mode,10) > 0) DEBUG = 1;
	else DEBUG = 0;
	if (DEBUG > 0) java.lang.System.out.println ("**** DEBUG: '" + DEBUG + "' ******");
}

function set_debug_images_mode(debug_mode) {
	if (parseInt(debug_mode,10) > 0) DEBUGIMAGES = 1;
	else DEBUGIMAGES = 0;
	if (DEBUGIMAGES > 0) java.lang.System.out.println ("**** DEBUGIMAGES: '" + DEBUGIMAGES + "' ******");
}

function set_debug_css_mode(debug_mode) {
	if (parseInt(debug_mode,10) > 0) DEBUG_cssfile = true;
	else DEBUG_cssfile = false;
}

var export_images = 0;	// 0 = dont'export images, 1 = JPEG, 2 = GIF, 3 = PNG, 4 = TIFF
function set_export_images(exp) {
	export_images = parseInt(exp,10);
	if (export_images < 0) export_images = 0;
	if (export_images > 4) export_images = 4;
}
function get_export_images() { return(export_images); }




/* ======================================
   spreads
*/






/* ======================================
   fonts stuff
*/
var css_font_family_string = "";
function set_css_font_family_string(ff) {
	if (ff == null) return;
	css_font_family_string = ff;
	if (ff == "") return;
	try {
		if (css_font_family_string[css_font_family_string.length -1] == " ") css_font_family_string.length--;
		if (css_font_family_string[css_font_family_string.length -1] == ";") css_font_family_string.length--;
	} catch(e) {}

}

var fontFamilyReplaceArr = new Array();
function store_replaceFont(rF) {
	var rf0 = rF.split(",");
	for (var i = 0; i < rf0.length; i++) {
		if (rf0[i] == "") continue;	// nothing to do
		add_replaceFont(rf0[i]);
	}
	return;
}
function add_replaceFont(rF) {
	if (rF == "") return;
	fontFamilyReplaceArr[fontFamilyReplaceArr.length] = new Array(2);	// [0] = the font to replace with [1]
	x = fontFamilyReplaceArr.length - 1;
	farr = rF.split(":");
	fontFamilyReplaceArr[x][0] = farr[0].toLowerCase();
	fontFamilyReplaceArr[x][1] = farr[1];
	return;
}
function get_fontFamilyReplace(font) {
	if (fontFamilyReplaceArr.length <= 0) return(font);	// no replace fonts
	// try to find the font to replace
	for (var i = 0; i < fontFamilyReplaceArr.length; i++) {
		if (font.toLowerCase().indexOf(fontFamilyReplaceArr[i][0]) >= 0) {	// searched font found
			if (fontFamilyReplaceArr[i][1] == "") return (font);	// do not change if no replace font given
			else return (fontFamilyReplaceArr[i][1]);
		}
	}
	// we have not found a spezific replace font: try to find the general replace font *
	for (var i = 0; i < fontFamilyReplaceArr.length; i++) {
		if (fontFamilyReplaceArr[i][0] == "*") {	// general replace font
			if (fontFamilyReplaceArr[i][1] == "") return (font);	// do not change if no replace font given
			else return (fontFamilyReplaceArr[i][1]);
		}
	}
	return (font);	// nothing found: return original font
}
function print_replaceFonts() {
	java.lang.System.out.println ("****** Replace Fonts ******");
	for (var i = 0; i < fontFamilyReplaceArr.length; i++) {
		try { java.lang.System.out.println (fontFamilyReplaceArr[i].toString()); } catch(e) { break; }
	}
	java.lang.System.out.println ("****** Replace Fonts END ******");
}

var fontsizeFactor = 1.0;
function store_fontsizeFactor(f) { fontsizeFactor = parseFloat(f); }
var fontsizeMinimum = 0.0;
function store_fontsizeMinimum(f) { fontsizeMinimum = parseFloat(f); }
var fontsizeUnits = 0;
function store_fontsizeUnits(f) { fontsizeUnits = parseInt(f,10); }
var fontsizeBase = 9.0;	// 9 pt
function store_fontsizeBase(f) { fontsizeBase = parseFloat(f); }

var parentFontSizeStack = new Array();	// store the durrent parent's font size to calc relative fontz sizes for a child
function push_parentFontSize(size) {
	if ((size == null) || (size == "") || isNaN(size)) return(false);
	parentFontSizeStack.push(parseFloat(size));
	return(true);
}
function pop_parentFontSize() {
	return(parentFontSizeStack.pop());
}
function clear_parentFontSize() {
	parentFontSizeStack = new Array();
}
function get_parentFontSize() {
	if (parentFontSizeStack.length <= 0) return(null);
	return(parentFontSizeStack[parentFontSizeStack.length-1]);
}

function calc_fontsize(thefontsize, addunit) {
	if ((thefontsize == null) || (thefontsize == "")) return("");
	var myfontsize = parseFloat(thefontsize);
	myfontsize = thefontsize * fontsizeFactor;
	var myfontsizeStr = "";

	var myBaseFontSize = fontsizeBase;
	/****** currently unused - may be deleted later...
	var parentFontSize = get_parentFontSize();
	if (parentFontSize == null) myBaseFontSize = parentFontSize;	// get from parent class
	//java.lang.System.out.println ("----- calc FONT-size - parentFontSize: " + parentFontSize + ", myBaseFontSize: " + myBaseFontSize);
	*******/
	if ((fontsizeMinimum != 0.0) && (myfontsize < fontsizeMinimum)) myfontsize = fontsizeMinimum;
	switch (fontsizeUnits) {
		case 0:	// get in pt
			// round font size to 1 decimal
			myfontsize = Math.round(myfontsize*10)/10;  // returns rounded to 1 decimal
			break;
		case 1:	// get in %
			myfontsize = myfontsize * 100 / myBaseFontSize;
			myfontsize = Math.round(myfontsize);	// rounded to 0 decimal
			break;
		case 2:	// get in em
			myfontsize = myfontsize / myBaseFontSize;
			myfontsize = Math.round(myfontsize*100)/100;	// returns rounded to 2 decimal
			break;
	}

	myfontsizeStr = "" + myfontsize;

	// optionally add font unit
	if (addunit) {
		switch (fontsizeUnits) {
			case 0: { myfontsizeStr += "pt"; break; }	// get in pt
			case 1: { myfontsizeStr += "%"; break; }	// get in %
			case 2: { myfontsizeStr += "em"; break; }	// get in em
			// other number do not add a unit
		}
	}

	return(myfontsizeStr);
}



/* ======================================
   box catching stuff
*/
var catch_radius = 0;
function set_catch_radius(rad) {
	catch_radius = parseInt(rad,10);
	return null;
}

var all_no_boxcatch = false;
function set_all_no_boxcatch(theflag) {
	var flag = parseInt(theflag,10);
	//		java.lang.System.out.println ("------- ALL no box catching flag: " + flag);
	if (flag & 1) all_no_boxcatch = true;
	else all_no_boxcatch = false;
	if (flag & 2) empty_boxes_no_boxcatch = true;
	else empty_boxes_no_boxcatch = false;
	if (flag & 4) image_boxes_no_boxcatch = true;
	else image_boxes_no_boxcatch = false;
	if (flag & 8) chained_boxes_no_boxcatch = true;
	else chained_boxes_no_boxcatch = false;
	if (flag & 16) text_boxes_no_boxcatch = true;
	else text_boxes_no_boxcatch = false;
	if (flag & 32) chained_firstboxes_no_boxcatch = true;
	else chained_firstboxes_no_boxcatch = false;
	if (flag & 64) chained_followingboxes_no_boxcatch = true;
	else chained_followingboxes_no_boxcatch = false;
	return null;
}

var unassigned_boxes_no_boxcatch = true;
function set_unassigned_boxes_no_boxcatch(flag) {
	if (parseInt(flag,10) > 0) unassigned_boxes_no_boxcatch = true;
	else unassigned_boxes_no_boxcatch = false;
	return null;
}

var empty_boxes_no_boxcatch = true;
function set_empty_boxes_no_boxcatch(flag) {
	if (parseInt(flag,10) > 0) empty_boxes_no_boxcatch = true;
	else empty_boxes_no_boxcatch = false;
	return null;
}

var chained_boxes_no_boxcatch = false;
var chained_firstboxes_no_boxcatch = false;
var chained_followingboxes_no_boxcatch = false;
function set_chained_boxes_no_boxcatch(flag) {
	if (parseInt(flag,10) > 0) chained_boxes_no_boxcatch = true;
	else chained_boxes_no_boxcatch = false;
	return null;
}
function set_chained_firstboxes_no_boxcatch(flag) {
	if (parseInt(flag,10) > 0) chained_firstboxes_no_boxcatch = true;
	else chained_firstboxes_no_boxcatch = false;
	return null;
}
function set_chained_followingboxes_no_boxcatch(flag) {
	if (parseInt(flag,10) > 0) chained_followingboxes_no_boxcatch = true;
	else chained_followingboxes_no_boxcatch = false;
	return null;
}

var text_boxes_no_boxcatch = false;
function set_text_boxes_no_boxcatch(flag) {
	if (parseInt(flag,10) > 0) text_boxes_no_boxcatch = true;
	else text_boxes_no_boxcatch = false;
	return null;
}

var image_boxes_no_boxcatch = false;
function set_image_boxes_no_boxcatch(flag) {
	if (parseInt(flag,10) > 0) image_boxes_no_boxcatch = true;
	else image_boxes_no_boxcatch = false;
	return null;
}

var pageframing_boxes_no_boxcatch = true;
function set_pageframing_boxes_no_boxcatch(flag) {
	if (parseInt(flag,10) > 0) pageframing_boxes_no_boxcatch = true;
	else pageframing_boxes_no_boxcatch = false;
	return null;
}




/* ======================================
   CSS stuff
*/

var overwrite_CSS_files = 1;
function set_overwrite_CSS_files(flag) {
	if (parseInt(flag,10) > 0) overwrite_CSS_files = 1;
	else overwrite_CSS_files = 0;
	return null;
}
function get_overwrite_CSS_files() { return (overwrite_CSS_files); }





/* ======================================
   box inset stuff
   insetstring comes from attribute inst
           <TFPf clwd="U_161.4645669291339" inst="x_4_U_8.503937007874017_U_11.338582677165356_U_14.173228346456694_U_17.007874015748033" Self="rc_ud8TFPf1"/>
                     insets:                            top                 left                 bottom               right
*/
var textinsetsArr = new Array();
function init_textinset() {
	textinsetsArr = new Array();
}
function store_textinset(insetsstring) {
	// inset attributes: top left bottom right
	if ((insetsstring == null) || (insetsstring == "")) { init_textinset(); return(""); }
	var insArr = insetsstring.split(" ");
	if (insArr.length < 4) { init_textinset(); return(""); }
	textinsetsArr[0] = parseFloat(insArr[0]);	// top
	textinsetsArr[1] = parseFloat(insArr[1]);	// left
	textinsetsArr[2] = parseFloat(insArr[2]);	// bottom
	textinsetsArr[3] = parseFloat(insArr[3]);	// right
	return(textinsetsArr.toString());
}
function get_textinset(which, rounded) {	// which: 0 = top, 1 = left, 2 = bottom, 3 = right
	if (textinsetsArr.length < 4) return(0);
	if ( (which < 0) || (which > textinsetsArr.length-1) ) return(0);
	if (rounded > 0) return(Math.ceil(textinsetsArr[which]));
	else return(textinsetsArr[which]);
}






/* ======================================
   box grouping stuff
*/
var group_boxes_to_articles = 1;	// 1 = make article groups, 0 = don't
function set_group_boxes_to_articles(flag) {
	if (parseInt(flag,10) > 0) group_boxes_to_articles = 1;
	else group_boxes_to_articles = 0;
	return group_boxes_to_articles;
}
function get_group_boxes_to_articles() { return (group_boxes_to_articles); }

var sort_boxes_by_area_size = 1;	// 1 = sort boxes by area size, 0 = don't
function set_sort_boxes_by_area_size(flag) {
	if (parseInt(flag,10) > 0) sort_boxes_by_area_size = 1;
	else sort_boxes_by_area_size = 0;
	return null;
}
function get_sort_boxes_by_area_size() { return (sort_boxes_by_area_size); }

var sort_boxes_by_y_position = 1;	// 1 = sort boxes by area size, 0 = don't
function set_sort_boxes_by_y_position(flag) {
	if (parseInt(flag,10) > 0) sort_boxes_by_y_position = 1;
	else sort_boxes_by_y_position = 0;
	return null;
}








/* ======================================
   anchored boxes stuff
*/
var anchoredobjects_mode = 0;
function set_anchoredobjects_mode(mode) {
	anchoredobjects_mode = mode;
}
function get_anchoredobjects_mode(mode) {
	return(anchoredobjects_mode);
}

var anchored_objects_use_external_storage = true;
var anchored_objects_string_arr = new Array();
var anchored_objects_string_arr_length = 0;

function set_useExternalStorage(val) {
	if ((val == null) || (val == "")) return(anchored_objects_use_external_storage);
	try {
		if (parseInt(val,10) > 0) anchored_objects_use_external_storage = true;
		else anchored_objects_use_external_storage = false;
	} catch(e){}
	return(anchored_objects_use_external_storage);
}

function init_anchored_objects_string_arr() {
	if (anchored_objects_use_external_storage == false) anchored_objects_string_arr = new Array();
	else Packages.com.epaperarchives.batchxslt.utils.publicStorageArray_init();
	anchored_objects_string_arr_length = 0;
}
function store_anchored_objects_string (string) {
	if (anchored_objects_use_external_storage == false) {
		anchored_objects_string_arr[anchored_objects_string_arr.length] = string;
		anchored_objects_string_arr_length = anchored_objects_string_arr.length;
	}
	else {
		anchored_objects_string_arr_length = Packages.com.epaperarchives.batchxslt.utils.publicStorageArray_addString(string, true, 0);
	}
}
function get_anchored_objects_string () {
	if (anchored_objects_use_external_storage == false) return ("<anchored_objects numobjects=\"" + anchored_objects_string_arr.length + "\">" + anchored_objects_string_arr.join("") + "</anchored_objects>");
	else {
		var astr = "<anchored_objects numobjects=\"" + Packages.com.epaperarchives.batchxslt.utils.publicStorageArray_size() + "\">";
		astr += new String(Packages.com.epaperarchives.batchxslt.utils.publicStorageArray_serialize(true,""));
		astr +=  "</anchored_objects>";
		return(astr);
	}
}

var anchored_object_anchorid_arr = new Array();
function store_anchored_object_anchorid(anchorid) {	// return 0 if anchored box not already stored else return 1
	var i = 0;
	if (DEBUG > 0) java.lang.System.out.println ("%%%%%%%%%%%%%%%%%%% store_anchored_object_anchorid: "+anchorid);
	for (i = 0; i < anchored_object_anchorid_arr.length; i++) {
		if (anchored_object_anchorid_arr[i] == anchorid) {
			if (DEBUG > 0) java.lang.System.out.println ("%%%%%%%%%%%%%%%%%%% store_anchored_object_anchorid already stored: "+anchorid);
			return (1);
		}
	}
	if (DEBUG > 0) java.lang.System.out.println ("%%%%%%%%%%%%%%%%%%% store_anchored_object_anchorid stored: "+anchorid);
	anchored_object_anchorid_arr[anchored_object_anchorid_arr.length] = anchorid;
	return(0);
}
function get_num_anchored_objects() {
	if (anchored_objects_use_external_storage == false) return(anchored_object_anchorid_arr.length);
	else return(Packages.com.epaperarchives.batchxslt.utils.publicStorageArray_size());
}

function dump_anchored_objects(filename) {	// dump anchored objects into file for debugging
	if (anchored_objects_string_arr_length > 0) writeFile(filename," *** anchored objects #" + anchored_objects_string_arr_length + "\n",true,false);
	else {
		writeFile(filename," *** NO anchored objects available",true,false);
		return;
	}
	for (var z = 0; z < anchored_objects_string_arr.length; z++) {
		if (anchored_objects_use_external_storage == false) writeFile(filename,"##" + z+ ": " + anchored_objects_string_arr[z] + "\n",true,true);
		else writeFile(filename,"##" + z+ ": " + new String(Packages.com.epaperarchives.batchxslt.utils.publicStorageArray_getString(z,true)) + "\n",true,true);
	}
}

function merge_anchored_objects() {
	// first, merge anchored objects in the anchored_objects_string_arr: anchored in anchored in...
	if (DEBUG > 0) java.lang.System.out.println ("************************** MERGING ANCHORED OBJECTS: #" + anchored_objects_string_arr_length + " **************************");
	var i = 0; var k = 0;
	var found_anchors = null;
	for (i = anchored_objects_string_arr_length -1 ; i >= 0 ; i--) {	// check if anchored objects themselfes contain an anchor signature
																		// check from end to begin
		var anchored_objectStr = "";
		if (anchored_objects_use_external_storage == false) anchored_objectStr = anchored_objects_string_arr[i];
		else anchored_objectStr = new String(Packages.com.epaperarchives.batchxslt.utils.publicStorageArray_getString(i, true));
		if (DEBUG > 0) java.lang.System.out.println ("    search #" + i + " for anchor markers in: " + anchored_objectStr.substr(0,150));
		found_anchors = anchored_objectStr.match(/&lt;\?__anchored_object__ .*?&gt;/g);	// &lt;\?__anchored_object__ .?&gt;
		if (found_anchors != null) {
			if (DEBUG > 0) java.lang.System.out.println ("***************** found_anchors in anchored object #"+ i + ", num anchors: " + found_anchors.length + "\nanchors: '" + found_anchors + "'");
			for (k = 0; k < found_anchors.length; k++) {
				var anchored_objectID = found_anchors[k].split("\"")[1];
				// find anchored object with this id
				var x = 0;
				var found = false;
				if (DEBUG > 0) java.lang.System.out.println ("---------- searching for anchor ID: " + anchored_objectID);
				for (x = anchored_object_anchorid_arr.length - 1; x >= 0; x--) {	// find anchored object to insert
					if (anchored_object_anchorid_arr[x] == anchored_objectID) { found = true; break; }
				}
				// insert the anchored object (found at x) at signature
				if (found == true) {
					var anchored_objectStrX = "";
					if (anchored_objects_use_external_storage == false) anchored_objectStrX = anchored_objects_string_arr[x];
					else anchored_objectStrX = new String(Packages.com.epaperarchives.batchxslt.utils.publicStorageArray_getString(x, true));
					if (DEBUG > 0) {
						java.lang.System.out.println ("+++++++++++++++++ found_anchorid "+k+" anchorid="+anchored_objectID+" in: '" + anchored_objectStrX.substr(0,150));
						java.lang.System.out.println ("+++++++++++++++++ replacing: '" + found_anchors[k] + "' with above content.");
					}

					var re = null;		// escape/change Dollar characters with ugly hack - don't change without heavy testing!
										// we have to change the anchored string before inserting it otherwise strings like $1.25 will be truncated to .25
										// because $[1-9] are result match references
					var setbackDollar = false;
					if (anchored_objectStrX.indexOf("$") >= 0) {
						re = /\$/g;
						anchored_objectStrX = anchored_objectStrX.replace(re,"_#usd#_");
						setbackDollar = true;
					}

					anchored_objectStr = anchored_objectStr.replace(found_anchors[k],anchored_objectStrX);

					if (setbackDollar) {	// reset Dollar characters
						re = /_#usd#_/g;
						//anchored_objectStrX = anchored_objectStrX.replace(re,"$$");	// $$ is escape character for literal $
						anchored_objectStr = anchored_objectStr.replace(re,"$$");
					}

				}
				else {
					if (DEBUG > 0) java.lang.System.out.println ("----------------- NOT INSERTED anchorid k:" + k + ": '" + anchored_objectID);
					anchored_objectStr = anchored_objectStr.replace(found_anchors[k],"");
				}
				// update stored anchored object
				if (anchored_objects_use_external_storage == false) anchored_objects_string_arr[i] = anchored_objectStr;
				else Packages.com.epaperarchives.batchxslt.utils.publicStorageArray_setString(i,anchored_objectStr,true,0);
			}
		}
	}
	if (DEBUG > 0) java.lang.System.out.println ("************************** END MERGING ANCHORED OBJECTS **************************");
}


function merge_anchored_objects_to_output(instring, remove_unresolved_anchormarkers) {
//return(instring);
	var outstring = instring;
	var re = null;
	if (anchored_objects_string_arr_length > 0) {
		var found_anchors = outstring.match(/&lt;\?__anchored_object__ .*?&gt;/g);	// &lt;?__anchored_object__ "u237"?&gt;
		if (found_anchors != null) {
			if (DEBUG > 0) java.lang.System.out.println ("%%%%%%%%%%%%%%%%%%%%%%%%% MERGING ANCHORED OBJECTS TO OUTPUT:");
			var k = 0;
			var setbackDollar = false;
			for (k = 0; k < found_anchors.length; k++) {
				var anchored_objectID = found_anchors[k].split("\"")[1];
				// find anchored object with this id
				var x = 0;
				var found = false;
				for (x = anchored_object_anchorid_arr.length - 1; x >= 0; x--) {	// find anchored object to insert
					if (anchored_object_anchorid_arr[x] == anchored_objectID) { found = true; break; }
				}
				// insert the anchored object (found at x) at signature
				if (found == true) {
					var anchored_objectStr = "";
					if (anchored_objects_use_external_storage == false) anchored_objectStr = anchored_objects_string_arr[x];
					else anchored_objectStr = new String(Packages.com.epaperarchives.batchxslt.utils.publicStorageArray_getString(x, true));
					if (DEBUG > 0) {
						java.lang.System.out.println ("%%%%%%%%%%%%%%%%%%% found_anchor "+x+" anchorid="+anchored_objectID+": '" + anchored_objectStr.substr(0,150));
						java.lang.System.out.println ("%%%%%%%%%%%%%%%%%%% replacing: '" + found_anchors[k] + "' with above content.");
					}
					// escape/change Dollar characters with ugly hack - don't change without heavy testing!
					// we have to change the anchored string before inserting it otherwise strings like $1.25 will be truncated to .25
					// because $[1-9] are result match references
					if (anchored_objectStr.indexOf("$") >= 0) {
						re = /\$/g;
						anchored_objectStr = anchored_objectStr.replace(re,"_#USD#_");
						setbackDollar = true;	// reset at end all in one run
					}

					// replace anchor marker with real anchored content
					outstring = outstring.replace(found_anchors[k],anchored_objectStr);

				}
				else {	// not found - broken anchor?
					if (DEBUG > 0) java.lang.System.out.println ("################## MISSED_anchor #"+x+": ID: '" + anchored_objectID + "'");
					if (remove_unresolved_anchormarkers == true) outstring = outstring.replace(found_anchors[k],"");
				}
			}

			if (setbackDollar) {	// reset Dollar characters
				re = /_#USD#_/g;
				outstring = outstring.replace(re,"$$");	// $$ is escape character for literal $
			}
			if (DEBUG > 0) java.lang.System.out.println ("%%%%%%%%%%%%%%%%%%%%%%%%% END MERGING ANCHORED OBJECTS TO OUTPUT %%%%%%%%%%%%%%%%%%%%%%%%%");
		}
	}

	// and remove unresolved anchored objects: &lt;?__anchored_object__ "ucecins4"?&gt;
	// from text markers, cross references
	if (remove_unresolved_anchormarkers == true) {
		re = /&lt;\?__anchored_object__ .*?&gt;/g;
		outstring = outstring.replace(re,"");
	}

	return(outstring);
}

function getElementContent(instring, extractElement) {
	if (instring == "") return("");
	var outstring = "";
	var anchored_objects_content_offset = 0;
	while (true) {
		var start = instring.indexOf("<" + extractElement, anchored_objects_content_offset);			// find beginning of start tag...
		if (start < 0) return(outstring);
		start = instring.indexOf(">",start+extractElement.length);										// ...and get end of start tag
		if (start < 0) return(outstring);
		if (instring.charAt(start-1)=="/") {			// check if it is an empty element: ends with />
			anchored_objects_content_offset = start+1;	// store current end offset...
			continue;									// ...and get next element
		}
		while ( (instring.charAt(start+1)==" ") || (instring.charAt(start+1)=="\n") || (instring.charAt(start+1)=="\r") || (instring.charAt(start+1)=="\t") ) start++;
	
		var end = instring.indexOf("</" + extractElement,start);	// find beginning of end tag
		if (end < 0) return(outstring);
		anchored_objects_content_offset = end;	// store current end offset
		while ( (instring.charAt(end-1)==" ") || (instring.charAt(end-1)=="\n") || (instring.charAt(end-1)=="\r") || (instring.charAt(end-1)=="\t") ) end--;

		outstring += instring.substring(start+1,end);
	}
	return(outstring);
}


/* ======================================
   Note stuff
*/
var current_note_sequence = 0;
function reset_note_sequence() {
	current_note_sequence = 0;
	return("" + current_note_sequence);
}
function get_note_sequence() {
	return("" + ++current_note_sequence);
}


/* ======================================
   footnotes stuff
*/
var footnotesOptions = new Object();	// from IDML FootnoteOption element
footnotesOptions.StartAt="1";
footnotesOptions.Prefix="";
footnotesOptions.Suffix="";
footnotesOptions.FootnoteTextStyle="ParagraphStyle/$ID/NormalParagraphStyle";
footnotesOptions.FootnoteMarkerStyle="CharacterStyle/$ID/[No character style]";
footnotesOptions.SeparatorText="&#9;";
footnotesOptions.SpaceBetween="0";
footnotesOptions.Spacer="0";
footnotesOptions.FootnoteFirstBaselineOffset="LeadingOffset";
footnotesOptions.FootnoteMinimumFirstBaselineOffset="0";
footnotesOptions.EosPlacement="false";
footnotesOptions.NoSplitting="false";
footnotesOptions.RuleOn="true";
footnotesOptions.RuleLineWeight="1";
footnotesOptions.RuleTint="100";
footnotesOptions.RuleGapTint="100";
footnotesOptions.RuleGapOverprint="false";
footnotesOptions.RuleOverprint="false";
footnotesOptions.RuleLeftIndent="0";
footnotesOptions.RuleWidth="72";
footnotesOptions.RuleOffset="0";
footnotesOptions.ContinuingRuleOn="true";
footnotesOptions.ContinuingRuleLineWeight="1";
footnotesOptions.ContinuingRuleTint="100";
footnotesOptions.ContinuingRuleGapTint="100";
footnotesOptions.ContinuingRuleOverprint="false";
footnotesOptions.ContinuingRuleGapOverprint="false";
footnotesOptions.ContinuingRuleLeftIndent="0";
footnotesOptions.ContinuingRuleWidth="288";
footnotesOptions.ContinuingRuleOffset="0";

footnotesOptions.FootnoteNumberingStyle = "";	// <FootnoteNumberingStyle type="enumeration">["UpperRoman"]["LowerRoman"]["UpperLetters"]["LowerLetters]["Arabic"]["Symbols"]["Kanji"]["FullWidthArabic"]["SingleLeadingZeros"]["DoubleLeadingZeros"]["Asterisks"]["ArabicAlifBaTah"]["ArabicAbjad"]["HebrewBiblical"]["HebrewNonStandard"]</FootnoteNumberingStyle>
footnotesOptions.RestartNumbering = "";		// <RestartNumbering type="enumeration">["DontRestart"]["PageRestart"]["SpreadRestart"]["SectionRestart"]</RestartNumbering>
footnotesOptions.ShowPrefixSuffix = "";		// <ShowPrefixSuffix type="enumeration">["NoPrefixSuffix"]["PrefixSuffixReference"]["PrefixSuffixMarker"]["PrefixSuffixBoth"]</ShowPrefixSuffix>
footnotesOptions.MarkerPositioning = "";		// <MarkerPositioning type="enumeration">["NormalMarker"]["SuperscriptMarker"]["SubscriptMarker"]["RubyMarker"]</MarkerPositioning>
footnotesOptions.RuleType = "";				// <RuleType type="object">StrokeStyle/$ID/Solid</RuleType>
footnotesOptions.RuleColor = "";				// <RuleColor type="object">Color/Black</RuleColor>
footnotesOptions.RuleGapColor = "";			// <RuleGapColor type="object">Swatch/None</RuleGapColor>
footnotesOptions.ContinuingRuleType = "";		// <ContinuingRuleType type="object">StrokeStyle/$ID/Solid</ContinuingRuleType>
footnotesOptions.ContinuingRuleColor = "";	// <ContinuingRuleColor type="object">Color/Black</ContinuingRuleColor>
footnotesOptions.ContinuingRuleGapColor = "";	// <ContinuingRuleGapColor type="object">Swatch/None</ContinuingRuleGapColor>

var current_footnote_spread = 0;
var current_footnote_page = 0;
var current_footnote_number = 0;
var current_footnote_sequence = 0;	
var enable_footnote_number = 0;
function reset_footnote_number(force,callingElement,current_spreadnum,current_pagename,page_self,section_self) {
	if (force && force > 0) {
		current_footnote_number = 0;
		current_footnote_sequence = 0;
	}
	if (footnotesOptions.RestartNumbering != "DontRestart") {
		switch (callingElement) {
			case "Spread":
				if (footnotesOptions.RestartNumbering == "SpreadRestart") current_footnote_number = 0;
				break;
			case "Page":
				if (footnotesOptions.RestartNumbering == "PageRestart") {
					current_footnote_number = 0;
					break;
				}
				if (footnotesOptions.RestartNumbering == "SectionRestart") {
					if (section_self != '') current_footnote_number = 0;
					break;
				}
				break;
		}
	}
	current_footnote_spread = current_spreadnum;
	current_footnote_page = current_pagename;
	return;
}
function get_footnote_number(increment) {
	if (enable_footnote_number < 1) return("");
	if (increment) ++current_footnote_number;
	return("" + current_footnote_number);
}
function get_footnote_sequence() {
	return("" + ++current_footnote_sequence);
}
function allow_footnote_numbering(val) {
	enable_footnote_number = val;
}

var footnotesStartIndex = -1;
function add_footnote_number(footnoteID,footnoteNumber) {
	if (anchored_objects_string_arr_length < 1) return;
	if (DEBUG > 0) java.lang.System.out.println ("***** SEARCH add_footnote_number aid ID: '" + footnoteID + "', footnoteNumber: '" + footnoteNumber + "'");
	if (footnotesStartIndex < 0) {
		for (var i = 0; i < anchored_objects_string_arr_length; i++) {	// get start index of anchored footnote
			var ftnStr = "";
			if (anchored_objects_use_external_storage == false) ftnStr = anchored_objects_string_arr[i];
			else ftnStr = new String(Packages.com.epaperarchives.batchxslt.utils.publicStorageArray_getString(i,true));
			ftnStr = ftnStr.substr(0,110);
			if (DEBUG > 0) java.lang.System.out.println ("***** SEARCH add_footnote_number - index " + i + ": footnote: " + ftnStr);
			if (ftnStr.indexOf("cont=\"footnote\"") >= 0) {
				footnotesStartIndex = i;
				break;
			}
		}
	}
	if (footnotesStartIndex < 0) return;
	if (footnotesStartIndex >= anchored_objects_string_arr_length) return;
	for (var i = footnotesStartIndex; i < anchored_objects_string_arr_length; i++) {	// search for the anchored footnote
		var ftnStr = "";
		if (anchored_objects_use_external_storage == false) ftnStr = anchored_objects_string_arr[i];
		else ftnStr = new String(Packages.com.epaperarchives.batchxslt.utils.publicStorageArray_getString(i,true));
		if (DEBUG > 0) java.lang.System.out.println ("+++++++++++++++++ ftnStr atidx " + i+ " ID: " + footnoteID + " in '" + ftnStr + "'");
		if (ftnStr.indexOf("cont=\"footnote\"") < 0) break;	// no more footnotes
		if (ftnStr.indexOf("anchorid=\"" + footnoteID + "\"") >= 0) {	// found the footnote
			var re = /%_ftn_num_%/g;
			if (anchored_objects_use_external_storage == false) anchored_objects_string_arr[i] = anchored_objects_string_arr[i].replace(re,footnoteNumber);
			else {
				ftnStr = ftnStr.replace(re,footnoteNumber);
				if (DEBUG > 0) java.lang.System.out.println ("+++++++++++++++++ ftnStr new at idx " + i+ ": '" + ftnStr + "'");
				Packages.com.epaperarchives.batchxslt.utils.publicStorageArray_setString(i,ftnStr,true,0);
			}
			if (DEBUG > 0) {
				if (anchored_objects_use_external_storage == false) java.lang.System.out.println ("***** MERGE add_footnote_number aid ID: '" + footnoteID + "', footnoteNumber: '" + footnoteNumber + "' at index: "+i+": '" + anchored_objects_string_arr[i] + "'");
				else java.lang.System.out.println ("***** MERGE add_footnote_number aid ID: '" + footnoteID + "', footnoteNumber: '" + footnoteNumber + "' at index: "+i+": '" + ftnStr + "'");
			}
			return;
		}
	}
	if (DEBUG > 0) java.lang.System.out.println ("##### MISSED add_footnote_number aid ID: '" + footnoteID + "', footnoteNumber: '" + footnoteNumber + "' at index: "+i);
	return;
}

function clean_footnotetitle(thetitle) {
	if ((thetitle == null) || (thetitle == "")) return("");
	var title = thetitle;
	var re = /\>/g;
	var title = title.replace(re,'&gt;');
	var re = /\</g;
	var title = title.replace(re,'&lt;');
	return(title);
}






/* ======================================
   boxes stuff
*/
var boxes_arr = new Array();
function init_boxes() { boxes_arr.length = 0; }
function store_box(page_sequence,box_type,content,Self,textflowid,coords,chainidx,groupid,
					matrix,matrix_orig,label,firstflowid,lastflowid,previousflowid,nextflowid,
					angle,shape_orig,bbox,pageJPEGScale,allgroupid) {
	boxes_arr[boxes_arr.length] = new Array(22);	// [0] = page_sequence
												// [1] = box_type
												// [2] = content
												// [3] = Self (id)
												// [4] = textflowid
												// [5] = coords
												// [6] = chainidx (idx in boxchain)
												// [7] = groupid (non empty if grouped)
												// [8] = width of box taken from area
												// [9] = height of box taken from area
												// [10] = original (evtl. rotated) matrix
												// [11] = unrotated matrix
												// [12] = box label
												// [13] = firstflowid (first box in a box chain). -1 for images
												// [14] = lastflowid (first box in a box chain)
												// [15] = previousflowid (previous box in a box chain or 'n' for not chained)
												// [16] = nextflowid (first box in a box chain or 'n' for not chained)
												// [17] = angle
												// [18] = shape_orig
												// [19] = bbox
												// [20] = pageJPEGScale
												// [21] = all group IDs as space separated string
	boxes_arr[boxes_arr.length-1][0] = parseInt(page_sequence,10);
	boxes_arr[boxes_arr.length-1][1] = box_type;
	boxes_arr[boxes_arr.length-1][2] = content;
	boxes_arr[boxes_arr.length-1][3] = Self;
	boxes_arr[boxes_arr.length-1][4] = textflowid;
	boxes_arr[boxes_arr.length-1][5] = coords;	// left,top,right,bottom
	if (chainidx != "") boxes_arr[boxes_arr.length-1][6] = parseInt(chainidx,10);
	else boxes_arr[boxes_arr.length-1][6] = -1;	// for image boxes
	boxes_arr[boxes_arr.length-1][7] = groupid;
	var a1 = boxes_arr[boxes_arr.length-1][5].split(',');	// set width and height
	boxes_arr[boxes_arr.length-1][8] = a1[2] - a1[0];
	boxes_arr[boxes_arr.length-1][9] = a1[3] - a1[1];
	boxes_arr[boxes_arr.length-1][10] = matrix;
	boxes_arr[boxes_arr.length-1][11] = matrix_orig;
	boxes_arr[boxes_arr.length-1][12] = label;
	boxes_arr[boxes_arr.length-1][13] = firstflowid;
	boxes_arr[boxes_arr.length-1][14] = lastflowid;
	boxes_arr[boxes_arr.length-1][15] = previousflowid;
	boxes_arr[boxes_arr.length-1][16] = nextflowid;
	boxes_arr[boxes_arr.length-1][17] = angle;
	boxes_arr[boxes_arr.length-1][18] = shape_orig;
	boxes_arr[boxes_arr.length-1][19] = bbox;
	boxes_arr[boxes_arr.length-1][20] = pageJPEGScale;
	boxes_arr[boxes_arr.length-1][21] = allgroupid;
	//java.lang.System.out.println ("******** store_box:" + boxes_arr[boxes_arr.length-1]);
	return;
}

// sort the box by area size: small areas first, largest last. browser must have small areas first otherwise they are covered by larger ones
function sort_box_areas() {
	if ((boxes_arr == null) || (boxes_arr.length <= 1)) return;	// we do not have to sort a single article
	// sort boxes by width ascending
	for (var i = 0; i < boxes_arr.length-1; i++) {
		for (var j = i+1; j < boxes_arr.length; j++) {
			if (boxes_arr[i][0] != boxes_arr[j][0]) break;	// page changes
			if (boxes_arr[j][8] < boxes_arr[i][8]) {	// swap these two articles
				var swap = boxes_arr[j];
				boxes_arr[j] = boxes_arr[i];
				boxes_arr[i] = swap;
			}
		}
	}
}
var boxes_arr_ptr = 0;
function reset_boxes_arr() {
	boxes_arr_ptr = 0;
}
function get_num_boxes() {
	return boxes_arr.length;
}
function get_num_boxes_idx() {
	return (boxes_arr.length - 1);
}
function get_boxes_arr_ptr() {
	return boxes_arr_ptr;
}
function get_box_page() { return boxes_arr[boxes_arr_ptr][0]; }
function get_box_type() { return boxes_arr[boxes_arr_ptr][1]; }
function get_box_cont() { return boxes_arr[boxes_arr_ptr][2]; }
function get_box_self() { return boxes_arr[boxes_arr_ptr][3]; }
function get_box_textflowid() { return boxes_arr[boxes_arr_ptr][4]; }
function get_box_coords() { return boxes_arr[boxes_arr_ptr][5]; }
function get_box_chainidx() { return boxes_arr[boxes_arr_ptr][6]; }
function get_box_groupid() { return boxes_arr[boxes_arr_ptr][7]; }
function get_box_allgroupids() { return boxes_arr[boxes_arr_ptr][21]; }
function get_box_width() { return boxes_arr[boxes_arr_ptr][8]; }
function get_box_height() { return boxes_arr[boxes_arr_ptr][9]; }
function get_box_matrix() { return boxes_arr[boxes_arr_ptr][10]; }
function get_box_matrix_orig() { return boxes_arr[boxes_arr_ptr][11]; }
function get_box_label() { return boxes_arr[boxes_arr_ptr][12]; }

function next_box() {
	if (boxes_arr_ptr < (boxes_arr.length -1)) {
		boxes_arr_ptr++;
		return 0; // we have more boxes
	}
	return -1;	// no more boxes
}

function print_boxes(title) {
	if (title == null) java.lang.System.out.println ("***************** boxes ******************");
	else java.lang.System.out.println (title);
	for (var i = 0; i < boxes_arr.length; i++) {
		var str = "  boxid: " + boxes_arr[i][3] + ", width: " + boxes_arr[i][8] + ", page: " + boxes_arr[i][0] + ", boxtype: " + boxes_arr[i][1] + ", groupid: " + boxes_arr[i][7];
		java.lang.System.out.println (str);
	}
	java.lang.System.out.println ("***************** end ******************");
}





/* ======================================
   spreads stuff
*/
var spreads_arr = new Array();	// containing array of Spread infos
/* properties of a Spread:
aSpread.id = "";					// @Self
aSpread.spread_type = "";		// spread type: 'sprd' or (currently not used): 'mspr' for master spread
aSpread.spread_num = -1;			// spread number in <docu> from position()
aSpread.page_count = -1;			// number of pages on spread from @PagC
aSpread.pages_onLeftSpine = -1;	// num pages on left spine side. 0 if start with a right (odd) page
*/
function store_spread(id, spread_type, spread_num, page_count, pages_onLeftSpine) {
	if ((id == null) || (id == "") ) return;
	spreads_arr[spreads_arr.length] = new Object();
	spreads_arr[spreads_arr.length-1].id = id;
	spreads_arr[spreads_arr.length-1].spread_type = spread_type;
	spreads_arr[spreads_arr.length-1].spread_num = parseInt(spread_num,10);
	spreads_arr[spreads_arr.length-1].page_count = parseInt(page_count,10);
	spreads_arr[spreads_arr.length-1].pages_onLeftSpine = parseInt(pages_onLeftSpine,10);
	return;
}
function dump_spreads_arr() {
	java.lang.System.out.println ("============ spreads_arr:");
	for (var i = 0; i < spreads_arr.length; i++) {
		java.lang.System.out.println ("**  aSpread.id: " + spreads_arr[i].id
			+ "\n      spread_type: " + spreads_arr[i].spread_type
			+ "\n      spread_num: " + spreads_arr[i].spread_num
			+ "\n      page_count: " + spreads_arr[i].page_count
			+ "\n      pages_onLeftSpine: " + spreads_arr[i].pages_onLeftSpine
			);
	}
	java.lang.System.out.println ("============ spreads_arr END");
}




/* ======================================
   page numbers stuff
*/
var pageNumberType = "";
function store_pageNumberType(type) {
	if (type != "") pageNumberType = type;
	else pageNumberType = "";
	return;
}
function get_pageNumberType() {
	return(pageNumberType);
}
var currentPageNumbersArr = new Array();
currentPageNumbersArr[0] = "0";	// physical page sequence in document, starts with 0 in CS3 and 1 in CS2. comes from <page DCof="rl_0"...> (originally a hex number)
currentPageNumbersArr[1] = "1";	// physical page sequence in document, always starting with 1
currentPageNumbersArr[2] = "1";	// page name in document, starts with 1 and comes from <page pnam="rl_1"...>  (usually the page number we see on the paper)
currentPageNumbersArr[3] = "";	// page side on spread, comes from <page PgSd="re_rgth"...>  (values: rgth, lfth)
function store_current_pagenumbers(docpagesequence, pagesequence, pagename, pageside, master, numbering, 
									columncount, columngutter, margtop, margbott, margleft, margright, columdirection,
									previouspagename, nextpagename) {
	currentPageNumbersArr[0] = docpagesequence;
	currentPageNumbersArr[1] = pagesequence;
	currentPageNumbersArr[2] = pagename;
	currentPageNumbersArr[3] = pageside;
	currentPageNumbersArr[4] = master;
	currentPageNumbersArr[5] = numbering;	// PgDt="rx_6_c_SEC_e_MLrl_b_f_b_t_l_4_c_ab"
											// PgDt="rx_6_c__e_Marb_b_f_b_f_l_7d_c_Creating Equitable Instruction"
	currentPageNumbersArr[6] = "";	// number type shortcut like 'MLrl'
	currentPageNumbersArr[7] = columncount;
	currentPageNumbersArr[8] = columngutter;
	currentPageNumbersArr[9] = margtop;
	currentPageNumbersArr[10] = margbott;
	currentPageNumbersArr[11] = margleft;
	currentPageNumbersArr[12] = margright;
	currentPageNumbersArr[13] = columdirection;
	currentPageNumbersArr[14] = previouspagename;
	currentPageNumbersArr[15] = nextpagename;
	if (numbering != "") {
		var numbArr = numbering.split("/#/");
		currentPageNumbersArr[5] = new Array();
		currentPageNumbersArr[5][0] = numbArr[0];	// section prefix
		currentPageNumbersArr[5][1] = numbArr[1];	// numbering type
		currentPageNumbersArr[5][2] = numbArr[2];	// automatic numberif (t, f)
		currentPageNumbersArr[5][3] = numbArr[3];	// start page number with section marker (t, f)...
		currentPageNumbersArr[5][4] = numbArr[4];	// ... this page number
		currentPageNumbersArr[5][5] = numbArr[5];	// section marker
		currentPageNumbersArr[6] = currentPageNumbersArr[5][1];	// number type shortcut MLrl
		/* HYSTORIC CS4 INX NUMBERING TYPE SHORTCUTS
			IN CS5: PageNumberStyle_EnumValue = "UpperRoman" | "LowerRoman" | "UpperLetters" | "LowerLetters" | "Arabic"
											| "Kanji" | "DoubleLeadingZeros" | "TripleLeadingZeros" | "ArabicAlifBaTah" | "ArabicAbjad" 
											| "HebrewBiblical" | "HebrewNonStandard" | "SingleLeadingZeros" | "FullWidthArabic"
							CS4		CS5
			1,2,3,4			Marb	Arabic
			01,02,03		SEC		SingleLeadingZeros
			001,002,003		MDlz	DoubleLeadingZeros
			0001,0002,0003	MTlz	TripleLeadingZeros
			A,B,C,D			MLru	UpperLetters
			a,b,c,d			MLrl	LowerLetters
			I,II,III		MRmu	UpperRoman
			i,ii,iii		MRml	LowerRoman
			*/
		switch(currentPageNumbersArr[5][1]) {
			case "Arabic": currentPageNumbersArr[5][1] = "1,2,3,4...";
				break;
			case "DoubleLeadingZeros": currentPageNumbersArr[5][1] = "001,002,003,004...";
				break;
			case "TripleLeadingZeros": currentPageNumbersArr[5][1] = "0001,0002,0003,0004...";
				break;
			case "UpperLetters": currentPageNumbersArr[5][1] = "A,B,C,D...";
				break;
			case "LowerLetters": currentPageNumbersArr[5][1] = "a,b,c,d...";
				break;
			case "UpperRoman": currentPageNumbersArr[5][1] = "I,II,III,IV...";
				break;
			case "LowerRoman": currentPageNumbersArr[5][1] = "i,ii,iii,iv...";
				break;
			default: currentPageNumbersArr[5][1] = "01,02,03,04...";
				break;
		}
	}
	return;
}
function get_current_pagenumbers(which,elem) {
	if ( (which == null) || (which < 0) || (which > (currentPageNumbersArr.length-1)) ) return("");
	if (which != 5) return (currentPageNumbersArr[which]);
	if ( (elem == null) || (elem < 0) || (elem > (currentPageNumbersArr[5].length-1)) ) return("");
	return (currentPageNumbersArr[which][elem]);
}
function get_page_side(pagenumber_onspread, pagesonleftspread, facingpages) {	// for CS4 which does not state the page side in @PgSd  but a docp/@ppsd which is 't' for facing pages or 'f' for single pages
	if ((facingpages != null) && (facingpages == "false")) return ("usex");	// non facing pages
	var pgnum = 1;
	if (parseInt(pagenumber_onspread,10) <= parseInt(pagesonleftspread,10)) return("lfth");
	return("rgth");
}




/* ======================================
   pages stuff
*/
var page_height = 0.0;
var page_width = 0.0;
var page_top = 0.0;
var page_left = 0.0;
var page_bottom = 0.0;
var page_right = 0.0;
var yZero = 0.0;
var page_wh_rel = 0.0;	// width to heigth
// page sequence stuff for Domversion 6 and above
var page_sequenceDOM6 = 0;
function init_page_sequenceDOM6() {
	page_sequenceDOM6 = 0;
	return(page_sequenceDOM6);
}
function inc_page_sequenceDOM6() {
	page_sequenceDOM6++;
	return(page_sequenceDOM6);
}
function get_page_sequenceDOM6() {
	return(page_sequenceDOM6);
}
// page sequence stuff
function get_physical_page_sequence(num) {	// return the physical page number in document starting with 1
	var versParts = DOMVersion.split("."),
		domVers = parseInt(versParts[0],10);

	if (domVers >= 6) {	// in CS4 (and above) we have to count the page_sequence
		return(page_sequenceDOM6);
	}

	if (domVers <= 4) {	// in CS2 (and below) page numbering starts with "1"
		return(num);
	}
	else {	// in CS3 (and NOT above) page numbering starts with "0"
		return (parseInt(num,10) + 1);
	}
	return "";
}


var pages_arr = new Array();	// containing array of pages infos
/* properties of a page:
see Object below
---- additional props calculated here
yZero = page's zero Y
page_wh_rel = page width/height
*/
function store_pagebounds(page_sequence, spread_self, spread_num, page_self, pageOnSpread, page_name, pbnd, pwidth, pheight, page_side, pages_onspread) {
	if (DEBUG > 0) {
		java.lang.System.out.println ("============ store_pagebounds");
		java.lang.System.out.println ("             page_sequence:" + page_sequence);
		java.lang.System.out.println ("             spread_self:" + spread_self);
		java.lang.System.out.println ("             spread_num:" + spread_num);
		java.lang.System.out.println ("             page_self:" + page_self);
		java.lang.System.out.println ("             pageOnSpread:" + pageOnSpread);
		java.lang.System.out.println ("             page_name:" + page_name);
		java.lang.System.out.println ("             pbnd:" + pbnd);
		java.lang.System.out.println ("             pwidth:" + pwidth);
		java.lang.System.out.println ("             pheight:" + pheight);
		java.lang.System.out.println ("             page_side:" + page_side);
		java.lang.System.out.println ("             pages_onspread:" + pages_onspread);
	}
	var pbnd_arr = null;
	var pbnd_top = 0.0;
	var pbnd_left = 0.0;
	var pbnd_bottom = 0.0;
	var pbnd_right = 0.0;
		//if ((pbnd != null) && (pbnd != "")) {	// get from current's page @GeometricBounds
	if ((pheight != null) && (pwidth != null) && (pheight != "") && (pwidth != "") && !isNaN(pheight) && !isNaN(pwidth)) {	// IMPORTANT! get from DocumentPreference page/width if given 
		pbnd_top = 0.0;
		pbnd_left = 0.0;
		pbnd_bottom = pheight;
		pbnd_right = pwidth;
	}
	else {	// get from current's page @GeometricBounds
		pbnd_arr = pbnd.split(" ");		// results in 4 elements: top/left bottom/right
		pbnd_top = pbnd_arr[0];
		pbnd_left = pbnd_arr[1];
		pbnd_bottom = pbnd_arr[2];
		pbnd_right = pbnd_arr[3];
	}
	//try {
		switch (page_side) {
			case 'rgth':	// facing pages right hand side
				page_top = 0.0;
				page_left = 0.0;
				page_bottom = parseFloat(pbnd_bottom);
				page_right = parseFloat(pbnd_right);
				break;
			case 'lfth':	// facing pages left hand side
				page_top = 0.0;
				page_left = -(parseFloat(pbnd_right));
				page_bottom = parseFloat(pbnd_bottom);
				page_right = 0.0;
				break;
			default:	// NON facing pages 'usex' (center page)
				page_top = 0.0;
				page_bottom = parseFloat(pbnd_bottom);
				//page_left = -(parseFloat(pbnd_right) / 2);
				//page_right = (parseFloat(pbnd_right) / 2);
				page_left = -parseFloat(pbnd_right)*(parseFloat(pages_onspread) - (2*(parseFloat(pageOnSpread)-1)))/2;
				page_right = page_left+parseFloat(pwidth);
				break;
		}
	//} catch(e){}
	
	page_height = page_bottom - page_top;	// bottom - top
	page_width = page_right - page_left;	// right - left
	
	yZero = page_height / 2.0;
	page_wh_rel = page_height / page_width;

	pages_arr[pages_arr.length] = new Object();
	pages_arr[pages_arr.length-1].page_sequence = page_sequence;
	pages_arr[pages_arr.length-1].spread_self = spread_self;
	pages_arr[pages_arr.length-1].spread_num = spread_num;
	pages_arr[pages_arr.length-1].pages_onspread = pages_onspread;
	pages_arr[pages_arr.length-1].page_self = page_self;
	pages_arr[pages_arr.length-1].pageOnSpread = pageOnSpread;
	pages_arr[pages_arr.length-1].page_side = page_side;
	pages_arr[pages_arr.length-1].page_name = page_name;
	pages_arr[pages_arr.length-1].pbnd = pbnd;
	pages_arr[pages_arr.length-1].pwidth = pwidth;
	pages_arr[pages_arr.length-1].pheight = pheight;
	pages_arr[pages_arr.length-1].yZero = yZero;
	pages_arr[pages_arr.length-1].page_wh_rel = page_wh_rel;
	return;
}
function get_pageside_from_page_sequence(page_sequence) {
	for (var i = 0; i < pages_arr.length; i++) {
		if (pages_arr[i].page_sequence == page_sequence) return(pages_arr[i].page_side);
	}
	return(-1);
}
function get_pagesequence_from_page_name(page_name) {
	for (var i = 0; i < pages_arr.length; i++) {
		if (pages_arr[i].page_name == page_name) return(pages_arr[i].page_sequence);
	}
	return(-1);
}
function dump_pages_arr() {
	java.lang.System.out.println ("============ pages_arr:");
	if (pages_arr.length <= 0) {
		java.lang.System.out.println ("### no pages available!");
		return;
	}
	for (var i = 0; i < pages_arr.length; i++) {
		var str = "**  page_sequence: " + pages_arr[i].page_sequence;
		for (var key in pages_arr[i]) {
			if (key == "page_sequence") continue;
			str += "\n      " + key + " = " + pages_arr[i][key];
		}
		java.lang.System.out.println (str);
	}
	java.lang.System.out.println ("============ pages_arr END");
}
function get_page_height() { return page_height; }
function get_page_width() { return page_width; }
function get_page_left() { return page_left; }
function get_page_right() { return page_right; }
function y0() { return yZero; }
function get_page_wh_rel() { return page_wh_rel; }
function init_pagebounds() {
	pages_arr = new Array();
	page_height = 0.0;
	page_width = 0.0;
	page_top = 0.0;
	page_left = 0.0;
	page_bottom = 0.0;
	page_right = 0.0;
	yZero = 0.0;
	page_wh_rel = 0.0;	// width to heigth
}

var imagepagearea_arr = new Array();
function store_imagepagearea(imagepagearea) {	// imagepagearea="114.35633477639,64.4881889756142,282.907154448521,225.012779139549,px,1" for anchored objects
												//                   [0]=x1         [1]=y1            [2]=x2           [3]=y2        [4]px=measure units   [5]=pagename
	imagepagearea_arr = imagepagearea.split(",");
	return(imagepagearea_arr[5]);
}
function get_pageCoord_from_imagepagearea(which) {
	switch (which) {
		case "x1": return(imagepagearea_arr[0]);
			break;
		case "y1": return(imagepagearea_arr[1]);
			break;
		case "x2": return(imagepagearea_arr[2]);
			break;
		case "y2": return(imagepagearea_arr[3]);
			break;
		case "unit": return(imagepagearea_arr[4]);
			break;
		case "pname": return(imagepagearea_arr[5]);
			break;
	}
	return(0);
}

function get_jpeg_page_num2(num) {	// return the page  number: for page #1 "" otherwise the num
	if (num == "1") return("");
	return(num);
}
function get_jpeg_page_num(num) {	// return the page  number: for page #1 "" otherwise the num
	var versParts = DOMVersion.split("."),
		domVers = parseInt(versParts[0],10);

	if (domVers >= 6) {	// in CS4 (and above) we have to count the page_sequence
		return page_sequenceDOM6;
		/*
		if (page_sequenceDOM6 != '1') return page_sequenceDOM6;
		return "";
		*/
	}

	if (domVers <= 4) {	// in CS2 (and below) page numbering starts with "1"
		if (num != '1') return num;
		return "";
	}
	if (domVers >= 5) {	// in CS3 (and hopefully above) page numbering starts with "0"
		if (num != '0') return (parseInt(num,10) + 1);
		return "";
	}
	return "";
}

var currentPageJPEGname = "";
function storePageJPEGname(name) {	// store the current page jpeg name
	currentPageJPEGname = name;
}
function getPageJPEGname() {	// return the current page jpeg name
	return(currentPageJPEGname);
}





// ********** pages and boxes stuff
// description to coordinate sytem for pages and boxes (used i functions 'store_pagebounds' and 'store_coords'
// <page element attribute pbnd="" coords are in global system coords like
// 1st (right) page: pbnd="rx_4_U_-396_U_0_U_396_U_612"  (top, left, bottom right)
// 2nd (left) page:  pbnd="rx_4_U_576_U_-612_U_1368_U_0"
// 3nd (right) page: pbnd="rx_4_U_576_U_0_U_1368_U_612"
// 4th (left) page:  pbnd="rx_4_U_1548_U_-612_U_2340_U_0"

// crec or txtf on a page (image or text boxes) are in page coords (global coords must be inherited from page coords)
// to determine if a box belongs to a left or right sided page on a spread, we must have the real coords of the page on the
// spread and check if the box coord left fits into left or right sided page
// first page (first spread)
// IGeo="...._b_f_D_87.999_D_-549.8181818181818_D_188_D_-333.9999999999998_D_1_D_0_D_0_D_1_D_0_D_693"
//                   left       top               right    bottom         ||matrix           |Xdisplace |Ydisplace
// second or third page (2nd spread)
// IGeo="...._b_f_D_-361.2857142857143_D_243.45223931623923_D_-88.875_D_360_D_1_D_0_D_0_D_1_D_0_D_0"
//                    left                top                  right  bottom ||matrix         |Xdisplace |Ydisplace
// second or third page (3rd spread)
// IGeo="...._b_f_D_-120_D_-96.11999999999989_D_53.18867719698167_D_42.60413043478246_D_1_D_0_D_0_D_1_D_-429_D_-66.43357142857144"
//                  left      top                right              bottom            ||matrix          |Xdisplace |Ydisplace


function resizeAreaCoords(thecoords) {
	var coords = thecoords.split(",");
	for ( var i = 0; i < coords.length; i++) coords[i] = "" + parseInt(parseFloat(coords[i]) * get_pageJPEGScale(),10);
	return(coords.toString());
}
function resizeValue(val) {
	return ( "" + Math.round(parseFloat(val) * get_pageJPEGScale()) );
}
function origsizeValue(val) {
	return ( "" + Math.round(parseFloat(val) / get_pageJPEGScale()) );
}


var box2page_arr = new Array();
/* an array containing box to spread/page infos in such arrays:
 [0] = spread_num          on which spread
 [1] = spread_self
 [2] = page                on which page
 [3] = page_sequence
 [4] = page_name
 [5] = page_side
 [6] = page_self
 [7] = element_name        element info 'txtf' 'crec' ...
 [8] = element_self
 [9] = aBox Object previously filled in with store_coords
 */
 function init_box2page_arr() {
 	box2page_arr = new Array();
 }
function store_box2page(spread_num,spread_self,page,page_sequence,page_name,page_side,page_self,element_name,element_self) {
	if (aBox.is_valid == false) return;
	// check if already stored this box
	for (var i = 0; i < box2page_arr.length; i++) {
		if (box2page_arr[i][8] == element_self) return;
	}
	// add box
	box2page_arr[box2page_arr.length] = new Array();
	box2page_arr[box2page_arr.length-1][0] = spread_num;
	box2page_arr[box2page_arr.length-1][1] = spread_self;
	box2page_arr[box2page_arr.length-1][2] = page;
	box2page_arr[box2page_arr.length-1][3] = page_sequence;
	box2page_arr[box2page_arr.length-1][4] = page_name;
	box2page_arr[box2page_arr.length-1][5] = page_side;
	box2page_arr[box2page_arr.length-1][6] = page_self;
	box2page_arr[box2page_arr.length-1][7] = element_name;
	box2page_arr[box2page_arr.length-1][8] = element_self;
	box2page_arr[box2page_arr.length-1][9] = clone(aBox);
	//java.lang.System.out.println ("============ store_box2page: " + box2page_arr[box2page_arr.length-1]);
}
// get aBox object from box2page_arr from boxid
function get_aBox_info(boxid) {
	if ( (boxid == null) || (boxid =="") ) return(false);
	for (var i = 0; i < box2page_arr.length; i++) {
		if (box2page_arr[i][8] == boxid) {
			aBox = clone(box2page_arr[i][9]);
			return(true);
		}
	}
	return(false);
}
function get_box2page_arr_length() {
	return(box2page_arr.length);
}
function dump_box2page_arr() {
	if (box2page_arr.length <= 0) {
		java.lang.System.out.println ("============ box2page_arr: No boxes");
		return;
	}
	java.lang.System.out.println ("============ box2page_arr number of boxes: " + box2page_arr.length);
	java.lang.System.out.println ("spread_num, spread_self, page, page_sequence, page_name, page_side, page_self, element_name, element_self, aBox[Object]");
	var curspread = "";
	for (var i = 0; i < box2page_arr.length; i++) {
		if (box2page_arr[i].spread_num != curspread) {
			curspread = box2page_arr[i][0];
			java.lang.System.out.println ("** spread num: " + curspread);
		}
		java.lang.System.out.println ("   " + box2page_arr[i].toString());
		java.lang.System.out.println ("      aBox Object for boxid: " + box2page_arr[i][9].boxid);
		for (var key in box2page_arr[i][9]) java.lang.System.out.println ("      " + key + " = " + box2page_arr[i][9][key]);
	}
	java.lang.System.out.println ("============ box2page_arr END");
}
/* search for aBox.belongs_to_page
   @return -10 if box not found
*/
function get_box2page_belongs_to_page(element_self) {
	if (DEBUG > 0) java.lang.System.out.println ("============ get_box2page_belongs_to_page getting: " + element_self);
	if ( (element_self == null) || (element_self == "") ) return(-10);
	var findid = element_self;
	if (findid.indexOf("_") >= 0) findid = findid.split("_")[1];
	for (var i = 0; i < box2page_arr.length; i++) {
		if (box2page_arr[i][8] == findid) {
			if (box2page_arr[i][9] != null) {
				try {
					return(box2page_arr[i][9].belongs_to_page);
				} catch (e) {}
			}
			break;
		}
	}
	if (DEBUG > 0) java.lang.System.out.println ("============ get_box2page_belongs_to_page getting: " + element_self + " not found");
	return(-10);
}
function get_box2page_spread(element_self) {
	for (var i = 0; i < box2page_arr.length; i++) {
		if (box2page_arr[i][8] == element_self) return(box2page_arr[i][0]);
	}
	return("");
}
function get_box2page_page(element_self) {
	for (var i = 0; i < box2page_arr.length; i++) {
		if (box2page_arr[i][8] == element_self) return(box2page_arr[i][2]);
	}
	return("");
}
function get_box2page_page_sequence(element_self) {
	for (var i = 0; i < box2page_arr.length; i++) {
		if (box2page_arr[i][8] == element_self) return(box2page_arr[i][3]);
	}
	return("");
}
function get_box2page_page_name(element_self) {
	for (var i = 0; i < box2page_arr.length; i++) {
		if (box2page_arr[i][8] == element_self) return(box2page_arr[i][4]);
	}
	return("");
}
function get_box2page_page_side(element_self) {
	for (var i = 0; i < box2page_arr.length; i++) {
		if (box2page_arr[i][8] == element_self) return(box2page_arr[i][5]);
	}
	return("");
}



var pageJPEG_index = 0;			// page JPEG iterator index
var pageJPEGs = new Array();	// page JPEG container array
var pageJPEGScale = 1.0;	// page JPEG scale factor
var pageJPEGWidth = 0;		// page JPEG width in pixesl
var pageJPEGHeight = 0;		// page JPEG height in pixesl
function set_pageJPEGScale(size) {	// 0.6 or 350x400 or 350x or x400 as string
	var pagesizes, pi, i, wh;
	pageJPEGs = new Array();
	pageJPEG_index = 0;
	if ( (size == null) || (size == "") ) return;
	
	pagesizes = size.split("//");
	for (pi = 0; pi < pagesizes.length; pi++) {
		if ( (pagesizes[pi].indexOf(".") < 0) || (pagesizes[pi].indexOf("x") >= 0) ) {	// seems to be w x h
			wh = pagesizes[pi].split("x");
			for (i = 0; i < wh.length; i++) wh[i] = allTrim(wh[i]);
			do {
				if (wh[0] != "") {	// get from width
					pageJPEGWidth = parseInt(wh[0],10);
					if ( (wh.length >= 2) && (wh[1] != "") ) pageJPEGHeight = parseInt(wh[1],10);
					else pageJPEGHeight = Math.round(parseFloat(pageJPEGWidth) * page_wh_rel); // no height given: calculate
					pageJPEGScale = parseFloat(pageJPEGWidth) / page_width;	// calc page JPEG scale factor
					break;
				}
				if ( (wh.length >= 2) && (wh[1] != "") ) {	// get from height
					pageJPEGHeight = parseInt(wh[1],10);
					if ( wh[0] != "" ) pageJPEGWidth = parseInt(wh[0],10);
					pageJPEGWidth = Math.round(parseFloat(pageJPEGHeight) / page_wh_rel); // calculate width
					pageJPEGScale = parseFloat(pageJPEGHeight) / page_height;	// calc page JPEG scale factor
					break;
				}
			} while(false);
		}
		else { // set scale
			pageJPEGScale = parseFloat(pagesizes[pi]);
			if (pageJPEGScale < 0.0) pageJPEGScale = 1.0;
			pageJPEGWidth = Math.round(page_width * pageJPEGScale);
			pageJPEGHeight = Math.round(page_height * pageJPEGScale);
		}
		pageJPEGs[pageJPEGs.length] = { "scale": pageJPEGScale, "width": pageJPEGWidth, "height": pageJPEGHeight };
	}
	return;
}
function reset_pageJPEG() { pageJPEG_index = 0; return pageJPEG_index; }
function next_pageJPEG() { return ++pageJPEG_index; }
function hasnext_pageJPEG() {
	if (pageJPEG_index <= (pageJPEGs.length - 1)) return true;
	return false;
}
function get_numPageJPEGs() { return pageJPEGs.length; }
function get_pageJPEGScale() { return pageJPEGs[pageJPEG_index].scale; }
function get_pageJPEGScale100() { return Math.round(pageJPEGs[pageJPEG_index].scale * 100.0); }
function get_pageJPEGScalePercent() { return ("" + (pageJPEGs[pageJPEG_index].scale * 100) + "%"); }
function get_pageJPEGWidth() { return pageJPEGs[pageJPEG_index].width; }
function get_pageJPEGHeight() { return pageJPEGs[pageJPEG_index].height; }

	//	for text and image boxes: x_19 = IGeo has 19(hex) elements
	//    IGeo="x_19_l_1_l_4_l_2_D_70.86614173228347_D_-292.440944881126_l_2_D_70.86614173228347_D_-110.07874015671648_l_2_D_264.5669291338583_D_-110.07874015671648_l_2_D_264.5669291338583_D_-292.440944881126
	//				_b_
	//				f_D_70.86614173228347_D_-292.440944881126_D_264.5669291338583_D_-110.07874015671648
	//                    left[2]               top[4]             right[6]             bottom[8]         
	//              ||matrix 
	//              _D_1_D_0_D_0_D_1_D_-464.7706417317445_D_201.11715354221684"
	//                 |scaleX     |       Xdisplace           Ydisplace
	//                     |sin    |scaleY
	//                 a   b   c   d       tx                  ty
	//                [10][12][14][16]    [18]                [20]
	//
	//                          | a  b  0 |       a = cos(alpa)   b = sin(alpa)
	//    [x' y' 1] = [x y 1] * | c  d  0 |       c = -sin(alpa)  d = cos(alpa)
	//                          | tx ty 1 |       tx = Delta X    ty = Delta Y
	//    x' = ax + cy + tx
	//    y' = bx + dy + ty

	//	for group boxes:
	//	IGeo="x_b_l_0_D_178.72440944899998_D_-30.944881889000044_D_487.72440944899995_D_384.94488188900004_D_1_D_0_D_0_D_1_D_0_D_0"
	//                     left                 top                   right                bottom         ||matrix           Xdisplace Ydisplace

function matrix_X (x, y, matrix) { return ( x*matrix[0] + y*matrix[2] + matrix[4] ); }
function matrix_Y (x, y, matrix) { return ( x*matrix[1] + y*matrix[3] + matrix[5] ); }
//											x*cos(a)    + y*sin(a)    + Delta X


function get_box_pageRealCoords (theBox,theMatrix) {	// displace unrotated boxes
	if (theMatrix == null) return;
		// x' = (x * scaleX) + tX
	theBox.real_left = (theBox.real_left * theMatrix[0]) + theMatrix[4];
	theBox.real_right = (theBox.real_right * theMatrix[0]) + theMatrix[4];
		// y' = (y * scaleY) + tY
	theBox.real_top = (theBox.real_top * theMatrix[3]) + theMatrix[5];
	theBox.real_bottom = (theBox.real_bottom * theMatrix[3]) + theMatrix[5];
}


function rotatePoint(x,y,angle,tx,ty,scale,asInt) {
	var myscale = 1.0;
	if (scale != null) myscale = scale;
	var my_x = parseFloat(x);
	var my_y = parseFloat(y);
	var xrot =  my_x + tx;
	var yrot =  my_y + ty;
	if ((angle != null) && (angle != 0.0)) {
		var angleRad = DEG2RAD*(-parseFloat(angle));
		var my_tx = parseFloat(tx);
		var my_ty = parseFloat(ty);
		xrot =  myscale * (my_tx + (my_x*Math.cos(angleRad) + my_y*(-Math.sin(angleRad))));
		yrot =  myscale * (my_ty + (my_x*Math.sin(angleRad) + my_y*(Math.cos(angleRad))));
		if (asInt != null && asInt == true) return([Math.round(xrot),Math.round(yrot)]);
	}
	return([xrot,yrot]);
}

function getAngleImage(matrix, thescale_org,thescale_rotated, thesinX, thesinY) {
	var sc_org = parseFloat(thescale_org);
	var sc_rot = parseFloat(thescale_rotated);
	var sinX = parseFloat(thesinX);
	var sinY = parseFloat(thesinY);

	// calc real values when matrix is rotated
	if (matrix && (matrix != null)) {
		var aXorg = Math.atan(-matrix[1] / matrix[0]) * RAD2DEG;	// original rotation angle X = atan(-sinA' / sX')
		if (matrix[0] < 0) {	// a negative scale X means: angle over 90 degrees - add 90 degrees
			if (aYorg < 0) aXorg = 180 + aYorg;	// CW
			else aYorg = -180 + aYorg;			// CCW
		}
		aXorg = Math.round(aXorg * 1000000) / 1000000;	// round to 6 digits
		return(aXorg);
	}

	var angle = 0.0;

	if ( ((Math.round(sinX * 1000000) / 1000000) == 0.0) && (sc_rot < 0) ) {	// negative scale rotated and no angle is 180 degrees
		angle = 180.0;
	}
	else {
		//angle = Math.asin( Math.sqrt((sc_org*sc_org) - (sc_rot*sc_rot)) / sc_org ) * RAD2DEG;
		angle = Math.asin( Math.sqrt((sc_org*sc_org) - (sc_rot*sc_rot)) / sc_org ) * RAD2DEG;
		if (sc_rot < 0) angle = 180 - angle;	// 180 - (+angle) = positive CCW angle
		if (sinY < 0) angle = - angle;	// CW
		angle = Math.round(angle * 1000000) / 1000000;	// round to 6 digits
	}
	if (DEBUG > 0) java.lang.System.out.println ("********** getAngleImage for scale_org: " + sc_org + ", scale_rotated: " + sc_rot + ", sinX: " + sinX + ", sinY: " + sinY + " ==> angle degrees: " + angle);
	return(angle);
}


function getAngleFromMatrix(matrix, doround) {
	if (matrix == null) return(0);
	if ((matrix[1] == 0) && (matrix[0] < 0)) return(0);		// sinA == 0 and scale is negative
	if (matrix[1] == 0) return(0);		// sinA == 0
	if ((matrix[1] == -1) && ((matrix[0] == 1) || (matrix[0] == 0))) return(90);
	if ((matrix[1] ==  1) && ((matrix[0] == 1) || (matrix[0] == 0))) return(-90);

	var myScaleX = matrix[0];
	if (myScaleX == 0) myScaleX = 1.0;
	// we have to calculate
	var aXorg = Math.atan(-matrix[1] / myScaleX) * RAD2DEG;	// original rotation angle X = atan(-sinA' / sX')
	if (matrix[0] < 0) {	// a negative scale X means: angle over 90 degrees - add 90 degrees
		if (aXorg < 0) aXorg = 180 + aXorg;	// CW
		else aXorg = -180 + aXorg;			// CCW
	}
	if (doround && (doround == true)) {
		aXorg = Math.round(aXorg * 1000000) / 1000000;	// round to 6 digits
	}
	if (aXorg == -180) aXorg = Math.abs(aXorg);	// -180 == +180
	if (DEBUG > 0) java.lang.System.out.println ("********** getAngleFromMatrix: " + matrix + " ==> angle degrees: " + aXorg);
	return(aXorg);
}

//  math stuff see unrotate_box
function getScaleFromMatrix(matrix, doround) {
	// first calc real values when matrix is rotated
	var myScaleXorg = matrix[0];
	var myScaleYorg = matrix[3];
	if ((DEBUG > 0) || (DEBUGIMAGES > 0))  {
		java.lang.System.out.println ("       -- getScaleFromMatrix: " + matrix);
	}
	var myScaleX = Math.abs(myScaleXorg);
	var myScaleY = Math.abs(myScaleYorg);
	var aXorg = Math.atan(-matrix[1] / myScaleX) * RAD2DEG;	// original rotation angle X = atan(-sinA' / sX')
	if (myScaleXorg < 0) {	// a negative scale X means: angle over 90 degrees - add 90 degrees
		if (aXorg < 0) aXorg = 180 + aXorg;	// CW
		else aXorg = -180 + aXorg;			// CCW
	}
	var aXorg_rad = aXorg * DEG2RAD;	// convert to radians

	var aYorg = Math.atan( matrix[2] / myScaleY) * RAD2DEG;	// original rotation angle Y = atan(sinA' / sY')
	if (myScaleYorg < 0) {	// a negative scale Y means: angle over 90 degrees - add 90 degrees
		if (aYorg < 0) aYorg = 180 + aYorg;	// CW
		else aYorg = -180 + aYorg;			// CCW
	}
	var aYorg_rad = aYorg * DEG2RAD;	// convert to radians

	var sinAx = Math.sin(aXorg_rad);
	var cosAx = Math.cos(aXorg_rad);
	var sinAy = Math.sin(aYorg_rad);
	var cosAy = Math.cos(aYorg_rad);

	var sX = myScaleX / cosAx;	// original scale sX = sX' / cosA
	var sY = myScaleY / cosAy;	// original scale sY = sY' / cosA
	if ((DEBUG > 0) || (DEBUGIMAGES > 0))  {
		java.lang.System.out.println ("            scale org       X: " + myScaleX + ", Y: " + myScaleY);
		java.lang.System.out.println ("            angles          X: " + aXorg + ", Y: " + aYorg);
		java.lang.System.out.println ("            cos             X: " + cosAx + ", Y: " + cosAy);
		java.lang.System.out.println ("            scale unrounded X: " + sX + ", Y: " + sY);
	}
	sX = Math.abs(sX);
	sY = Math.abs(sY);
	if (doround && (doround == true)) {
		sX = Math.round(sX * 1000000) / 1000000;	// round to 6 digits
		sY = Math.round(sY * 1000000) / 1000000;
		if ((DEBUG > 0) || (DEBUGIMAGES > 0))  {
			java.lang.System.out.println ("            scale   rounded X: " + sX + ", Y: " + sY);
		}
	}
if (sX == 0) sX = 1.0;
if (sY == 0) sY = 1.0;
	if ((DEBUG > 0) || (DEBUGIMAGES > 0))  {
		java.lang.System.out.println ("            scale  returned X: " + sX + ", Y: " + sY);
	}
	return([sX,sY]);
}


	//			x = original x position
	//			y = original y position
	//			transform matrix is stored as [sX,aX,aY,sY,tX,tY]
	//                        | sX  aX |      sX = scaleX        aX = sin(alpha)X
	//    [tx' ty'] = [x y] * | aY  sY |      aY = -sin(alpha)   sY = scaleY
	//                        | tX  tY |      tX = Delta X       tY = Delta Y
function unrotate_box(theBox) {
	if (Math.abs(parseFloat(theBox.matrix[1])) < 0.0000000001) return;
	if ((DEBUG > 0) || (DEBUGIMAGES > 0))  {
		var boxidstr = "";
		if (theBox && (theBox.boxid)) boxidstr = ": " + theBox.boxid;
		java.lang.System.out.println ("    ** unrotating box" + boxidstr);
		java.lang.System.out.println ("       rotated  box coords l,t,r,b: " + theBox.real_left + "," + theBox.real_top + "," + theBox.real_right + "," + theBox.real_bottom);
		java.lang.System.out.println ("       rotated  matrix: " + theBox.matrix);
	}
	var myScaleX = theBox.matrix[0];
	var myScaleY = theBox.matrix[3];

	// first calc real values when matrix is rotated
	var aXorg = Math.atan(-theBox.matrix[1] / myScaleX) * RAD2DEG;	// original rotation angle X = atan(-sinA' / sX')
	if (myScaleX < 0) {	// a negative scale X means: angle over 90 degrees - add 90 degrees
		if (aXorg < 0) aXorg = 180 + aXorg;	// CW
		else aXorg = -180 + aXorg;			// CCW
	}
	aXorg = -aXorg;	// as we unrotate: negate angle
	var aXorg_rad = aXorg * DEG2RAD;	// convert to radians

	var sinAx = Math.sin(aXorg_rad);
	var cosAx = Math.cos(aXorg_rad);

	var sX = myScaleX / cosAx;	// original scale sX = sX' / cosA
	var sY = myScaleY / cosAx;	// original scale sY = sY' / cosA

if (sX == 0) sX = 1.0;
if (sY == 0) sY = 1.0;
	//            tX = tX'              - sX*(x - x*cosAx + y*-sinAx)
	var unrotated_tx = theBox.matrix[4] - sX*(theBox.real_left - theBox.real_left*cosAx - theBox.real_top*(-sinAx));
	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) java.lang.System.out.println ("       ** CALC unrotated_tx: " + unrotated_tx + " = " + theBox.matrix[4] + " - " + sX + " * ( " + theBox.real_left + " - " + (theBox.real_left*cosAx) + " - " + theBox.real_top*(-sinAx) + " )" );

	//            tY = tY'              - sY*(y - x*sinAx + y*cosAx)
	var unrotated_ty = theBox.matrix[5] - sY*(theBox.real_top - theBox.real_left*sinAx - theBox.real_top*cosAx);
	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) java.lang.System.out.println ("       ** CALC unrotated_ty: " + unrotated_ty + " = " + theBox.matrix[5] + " - " + sY + " * ( " + theBox.real_top + " - " + (theBox.real_left*sinAx) + " - " + theBox.real_top*cosAx + " )" );

	theBox.matrix[0] = sX;
	theBox.matrix[1] = 0.0;
	theBox.matrix[2] = 0.0;
	theBox.matrix[3] = sY;
	theBox.matrix[4] = unrotated_tx;
	theBox.matrix[5] = unrotated_ty;
	if ((DEBUG > 0) || (DEBUGIMAGES > 0))  {
		java.lang.System.out.println ("       unrotated box coords l,t,r,b: " + theBox.real_left + "," + theBox.real_top + "," + theBox.real_right + "," + theBox.real_bottom);
		java.lang.System.out.println ("       unrotated box matrix: " + theBox.matrix);
		java.lang.System.out.println ("           rotation original angle: " + aXorg + ", sin: " + sinAx + ", cos: " + cosAx);
		java.lang.System.out.println ("           scale original sX: " + sX + ", sY: " + sY);
	}
	return;
}


/*********
 coords and other stuff about a box like text image or group
 This box info also may be used by a direct subsequent image which must know parents coords for cropping
 */
var parent_groupboxes = new Array();	// an array of group box IDs a box is contained
function init_parent_groupboxes() {
	parent_groupboxes = new Array();
}
function get_parent_groupboxes() {
	if (parent_groupboxes.length <= 0) return("");
	return(parent_groupboxes.join(" "));
}
function ad_to_parent_groupboxes(elementName, groupboxID) {
	if (elementName == "Group") return(parent_groupboxes.join(" "));
	if ((groupboxID == null) || (groupboxID == "")) return("");
	// is group box ID already here?
	for (var i=0; i<parent_groupboxes.length; i++) {
		if (parent_groupboxes[i] == groupboxID) return(parent_groupboxes.join(" "));	// we already have this group ID - return
	}
	parent_groupboxes[parent_groupboxes.length] = groupboxID;	// add it
	return(parent_groupboxes.join(" "));
}
function is_in_parent_groups(thegroups,theparentgroups) {
	if ((thegroups == null) || (thegroups == "")) return(false);
	if ((theparentgroups == null) || (theparentgroups == "")) return(false);
	var groupsArr = thegroups.split(" ");
	var parentgroupsArr = theparentgroups.split(" ");
	for (var g=0; g<groupsArr.length; g++) {
		for (var p=0; p<parentgroupsArr.length; p++) {
			if (groupsArr[g] == parentgroupsArr[p]) return(true);
		}
	}
	return(false);
}

var excludeLayersArr = new Array();
function store_excludeLayers(layers) {	// comma separated list of layer names
	if (layers == "") return;
	excludeLayersArr = layers.split(",");
	return;
}
function is_excludeLayer(layer) {
	if (excludeLayersArr.length <= 0) return(false);
	for (var i = 0; i < excludeLayersArr.length; i++) {
		if (excludeLayersArr[i] == layer) return(true);
	}
	return(false);
}


var aBox = new Object();
aBox.is_valid = false;	// true if aBox is valid
aBox.matrices_applied = false;	// true if all matrices are applied
aBox.boxid = "";
aBox.noexp = 0;	// 1 when label contains *noexp* if this boix should not be exported
aBox.spread_num = -1;
aBox.belongs_to_page = -1;	// a page number or -1 for on left spread or -2 for on right spread
aBox.belongs_to_page_overlap = -1;	// an object overlaps from one page to left or right. -1 = does not overlap
aBox.boxtype = "";
aBox.real_left = 0.0;	// in native measure
aBox.real_top = 0.0;
aBox.real_right = 0.0;
aBox.real_bottom = 0.0;
aBox.real_left_orig = 0.0;
aBox.real_top_orig = 0.0;
aBox.real_right_orig = 0.0;
aBox.real_bottom_orig = 0.0;
aBox.real_left_orig = 0.0;
aBox.real_top_orig = 0.0;
aBox.real_right_orig = 0.0;
aBox.real_bottom_orig = 0.0;
aBox.left = 0.0;		// seen on page top-left for html coords attribute
aBox.top = 0.0;
aBox.right = 0.0;
aBox.bottom = 0.0;
aBox.left_overlap = 0.0;	// when overlaps to other page seen on page top-left for html coords attribute
aBox.top_overlap = 0.0;
aBox.right_overlap = 0.0;
aBox.bottom_overlap = 0.0;
aBox.left_orig = 0.0;	// rotated values
aBox.top_orig = 0.0;
aBox.right_orig = 0.0;
aBox.bottom_orig = 0.0;
aBox.scaleX = 1.0;
aBox.scaleY = 1.0;
aBox.angle = 0.0;
aBox.flip = "";
aBox.pageJPEGScale = 1.0;
aBox.shape_orig = "";	// the shape points of a box: x1,y1,x2,y2....xn,yn   - in original size
aBox.shape = "";		// same shape but scaled, rotated and coverted to plain integers
aBox.shape_overlap = "";	// shape overlapping to other page
aBox.bbox_orig = "";	// the shape's bounding box   - in original size
aBox.bbox = "";			// shape enclosing rectangle
aBox.label = null;		// the box label
aBox.layerID = "";
aBox.layerName = "";
aBox.layerVisibility = "";
aBox.matrix = null;
aBox.matrix_orig = null;
aBox.group1_box = null;	// first parent group
aBox.group2_box = null;
aBox.group3_box = null;
aBox.group4_box = null;	// top group
aBox.parentGroupIDs = "";	// array of parent group IDs
aBox.textboxstuff = new Array(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);	// see below: text insets. columns and more
aBox.anchoredObjec_stof = "";

function invalid_aBox() { aBox.is_valid = false; }
function valid_aBox() { aBox.is_valid = true; }
function store_coords(igeo,imagInImagIGeo,spreadnum,pagenum,pageside,boxtype,boxid,
							groupbox1_igeo,groupbox2_igeo,groupbox3_igeo,groupbox4_igeo,parentGroupIDs,
							label,layerID,layerName,layerVisibility,
							textinsets,colcnt,colwidth,colgutter,vjust,paraspacelimit,
							anchoredObjec_stof													/* the id if anchored is an anchored object if != "n" */
					) {
					// igeo is the box IGeo like from txtf, crec, cpgn
					// imgIgeo is the IGeo of a contained sub element 'imag' if igeo is an image container
					// PgSd = lfth | rgth for left or right sided page
					// usex = not applicable
					// boxtype = txtf | crec | cpgn | grop | glin
	var execBlock = "A";

	var boxBelongsAlreadyToPage = get_box2page_belongs_to_page(boxid);
	if (boxBelongsAlreadyToPage != -10) {	// -10 = box not stored box already stored
		return(boxBelongsAlreadyToPage);
	}

	var sXsY = null;

try {
		execBlock = "B";
		invalid_aBox();
		if ((igeo == null) || (igeo == "")) return(0);
		aBox.is_valid = false;	// true if aBox is valid
		aBox.matrices_applied = false;	// true if all matrices are applied
		aBox.boxid = boxid;
		aBox.noexp = 0;	// 1 when label contains *noexp*, this boix should not be exported
		aBox.spread_num = -1;
		aBox.belongs_to_page = -1;
		aBox.belongs_to_page_overlap = -1;
		aBox.boxtype = boxtype;
		aBox.real_left = 0.0;	// coords seen from spine: at end already displaced to correct position on page
		aBox.real_top = 0.0;
		aBox.real_right = 0.0;
		aBox.real_bottom = 0.0;
		aBox.real_left_orig = 0.0;	// coords seen from spine: NOT displaced
		aBox.real_top_orig = 0.0;
		aBox.real_right_orig = 0.0;
		aBox.real_bottom_orig = 0.0;
		aBox.left = 0.0;
		aBox.top = 0.0;
		aBox.right = 0.0;
		aBox.bottom = 0.0;
		aBox.left_overlap = 0.0;
		aBox.top_overlap = 0.0;
		aBox.right_overlap = 0.0;
		aBox.bottom_overlap = 0.0;
		aBox.left_orig = 0.0;
		aBox.top_orig = 0.0;
		aBox.right_orig = 0.0;
		aBox.bottom_orig = 0.0;
		aBox.scaleX = 1.0;
		aBox.scaleY = 1.0;
		aBox.angle = 0.0;
		aBox.flip = "";
		aBox.pageJPEGScale = pageJPEGScale;
		aBox.shape_orig = "";	// the shape points of a box: x1,y1,x2,y2....xn,yn   - in original size
		aBox.shape = "";		// same shape but scaled, rotated and coverted to plain integers
		aBox.shape_overlap = "";	// shape overlapping to other page
		aBox.bbox_orig = "";	// the shape's bounding box   - in original size
		aBox.bbox = "";			// the shape's bounding box
		aBox.label = label; // the box label
		aBox.layerID = layerID;
		aBox.layerName = layerName;
		aBox.layerVisibility = layerVisibility;
		aBox.matrix = new Array(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);	// init matrix to 'identity' a, b, c, d, tx, ty (formula above)
							//   a    b    c    d    tx   ty
		aBox.matrix_orig = new Array(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);	// init matrix to 'identity' a, b, c, d, tx, ty (formula above)
		aBox.group1_box = null;	// first parent group
		aBox.group2_box = null;
		aBox.group3_box = null;
		aBox.group4_box = null; // top group
		aBox.parentGroupIDs = parentGroupIDs;
									// array of textbox stuff: textinsets,colcnt,colwidth,colgutter,vjust,paraspacelimit
		aBox.textboxstuff = new Array(0.0, 0.0, 0.0, 0.0, 0, "", "", "", "");
		if (textinsets && (textinsets != "")) {
			var txtinsets = store_textinset(textinsets);
			var textinsetsArr = txtinsets.split(",");
			aBox.textboxstuff[0] = textinsetsArr[0];	// [0] - [3] textinsets: t, l, b, r
			aBox.textboxstuff[1] = textinsetsArr[1];
			aBox.textboxstuff[2] = textinsetsArr[2];
			aBox.textboxstuff[3] = textinsetsArr[3];
		}
		if (colcnt && (colcnt != "")) aBox.textboxstuff[4] = parseInt(colcnt,10);				// [4] colcnt
		else aBox.textboxstuff[4] = "1";	// [4] colcnt
		if (colwidth && (colwidth != "")) aBox.textboxstuff[5] = colwidth;						// [5] colwidth
		if (colgutter && (colgutter != "")) aBox.textboxstuff[6] = colgutter;					// [6] colgutter
		if (vjust && (vjust != "")) aBox.textboxstuff[7] = vjust;								// [7] vjust
		if (paraspacelimit && (paraspacelimit != "")) aBox.textboxstuff[8] = paraspacelimit;	// [8] paraspacelimit
		aBox.anchoredObjec_stof = "";
		if (anchoredObjec_stof && (anchoredObjec_stof != "n")) aBox.anchoredObjec_stof = anchoredObjec_stof;

		if ((spreadnum != null) && (spreadnum != "")) try { aBox.spread_num = parseInt(spreadnum,10); } catch (e) {}

		if (aBox.label.indexOf("*noexp*") >= 0) aBox.noexp = 1;

		if (DEBUG > 0) {
			java.lang.System.out.println ("##############################################################");
			java.lang.System.out.println ("****** store_coords of boxID: " + aBox.boxid + ", boxtype: " + boxtype);
			java.lang.System.out.println ("       *noexp* label is: " + aBox.noexp);
			java.lang.System.out.println ("****** checking if box belongs to pageside: " + pageside);
		}

		execBlock = "C";
		// get stuff for the containing most inner group
		var groupbox1_geom_arr = null;
		var groupbox1_angle = 0.0;
		var group1Box = null;
		if (groupbox1_igeo && (groupbox1_igeo != "")) {
			var groupbox_geom_arr = get_normalized_IGeo(groupbox1_igeo,"grop");
			group1Box = new Object();
			group1Box.real_left = groupbox_geom_arr[0];		// left
			group1Box.real_top = groupbox_geom_arr[1];		// top
			group1Box.real_right = groupbox_geom_arr[2];	// right
			group1Box.real_bottom = groupbox_geom_arr[3];	// bottom
			group1Box.matrix = new Array(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
			group1Box.matrix[0] = parseFloat(groupbox_geom_arr[4]);	// scale X
			group1Box.matrix[1] = parseFloat(groupbox_geom_arr[5]);	// -sinX(angle) CCW
			group1Box.matrix[2] = parseFloat(groupbox_geom_arr[6]);	// sinY(angle) CW
			group1Box.matrix[3] = parseFloat(groupbox_geom_arr[7]);	// scaleY
			group1Box.matrix[4] = parseFloat(groupbox_geom_arr[8]);	// tx displace X
			group1Box.matrix[5] = parseFloat(groupbox_geom_arr[9]);	// ty displace Y
			group1Box.angle = getAngleFromMatrix(group1Box.matrix);	// angle in degrees
			sXsY = getScaleFromMatrix(group1Box.matrix);
			group1Box.scaleX = sXsY[0];
			group1Box.scaleY = sXsY[1];
			// add group to aBox
			aBox.group1_box = clone(group1Box);

			groupbox1_angle = group1Box.angle;	// angle in degrees
		}
		execBlock = "D";
		// get stuff for the containing parent group for group
		var groupbox2_geom_arr = null;
		var groupbox2_angle = 0.0;
		var group2Box = null;
		if (groupbox2_igeo && (groupbox2_igeo != "")) {
			var groupbox_geom_arr = get_normalized_IGeo(groupbox2_igeo,"grop");
			group2Box = new Object();
			group2Box.real_left = groupbox_geom_arr[0];		// left
			group2Box.real_top = groupbox_geom_arr[1];		// top
			group2Box.real_right = groupbox_geom_arr[2];	// right
			group2Box.real_bottom = groupbox_geom_arr[3];	// bottom
			group2Box.matrix = new Array(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
			group2Box.matrix[0] = parseFloat(groupbox_geom_arr[4]);	// scale X
			group2Box.matrix[1] = parseFloat(groupbox_geom_arr[5]);	// -sinX(angle) CCW
			group2Box.matrix[2] = parseFloat(groupbox_geom_arr[6]);	// sinY(angle) CW
			group2Box.matrix[3] = parseFloat(groupbox_geom_arr[7]);	// scaleY
			group2Box.matrix[4] = parseFloat(groupbox_geom_arr[8]);	// tx displace X
			group2Box.matrix[5] = parseFloat(groupbox_geom_arr[9]);	// ty displace Y
			group2Box.angle = getAngleFromMatrix(group2Box.matrix);	// angle in degrees
			sXsY = getScaleFromMatrix(group2Box.matrix);
			group2Box.scaleX = sXsY[0];
			group2Box.scaleY = sXsY[1];
			// add group to aBox
			aBox.group2_box = clone(group2Box);

			groupbox2_angle = group2Box.angle;	// angle in degrees
		}
		execBlock = "E";
		// get stuff for the containing parent group for group for group
		var groupbox3_geom_arr = null;
		var groupbox3_angle = 0.0;
		var group3Box = null;
		if (groupbox3_igeo && (groupbox3_igeo != "")) {
			var groupbox_geom_arr = get_normalized_IGeo(groupbox3_igeo,"grop");
			group3Box = new Object();
			group3Box.real_left = groupbox_geom_arr[0];		// left
			group3Box.real_top = groupbox_geom_arr[1];		// top
			group3Box.real_right = groupbox_geom_arr[2];	// right
			group3Box.real_bottom = groupbox_geom_arr[3];	// bottom
			group3Box.matrix = new Array(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
			group3Box.matrix[0] = parseFloat(groupbox_geom_arr[4]);	// scale X
			group3Box.matrix[1] = parseFloat(groupbox_geom_arr[5]);	// -sinX(angle) CCW
			group3Box.matrix[2] = parseFloat(groupbox_geom_arr[6]);	// -sinY(angle) CW
			group3Box.matrix[3] = parseFloat(groupbox_geom_arr[7]);	// scaleY
			group3Box.matrix[4] = parseFloat(groupbox_geom_arr[8]);	// tx displace X
			group3Box.matrix[5] = parseFloat(groupbox_geom_arr[9]);	// ty displace Y
			group3Box.angle = getAngleFromMatrix(group3Box.matrix);	// angle in degrees
			sXsY = getScaleFromMatrix(group3Box.matrix);
			group3Box.scaleX = sXsY[0];
			group3Box.scaleY = sXsY[1];
			// also group to aBox
			aBox.group3_box = clone(group3Box);

			groupbox3_angle = group3Box.angle;	// angle in degrees
		}
		execBlock = "F";
		// get stuff for the containing parent group for group for group for group
		var groupbox4_geom_arr = null;
		var groupbox4_angle = 0.0;
		var group4Box = null;
		if (groupbox4_igeo && (groupbox4_igeo != "")) {
			var groupbox_geom_arr = get_normalized_IGeo(groupbox4_igeo,"grop");
			group4Box = new Object();
			group4Box.real_left = groupbox_geom_arr[0];		// left
			group4Box.real_top = groupbox_geom_arr[1];		// top
			group4Box.real_right = groupbox_geom_arr[2];	// right
			group4Box.real_bottom = groupbox_geom_arr[3];	// bottom
			group4Box.matrix = new Array(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
			group4Box.matrix[0] = parseFloat(groupbox_geom_arr[4]);	// scale X
			group4Box.matrix[1] = parseFloat(groupbox_geom_arr[5]);	// -sinX(angle) CCW
			group4Box.matrix[2] = parseFloat(groupbox_geom_arr[6]);	// sinY(angle) CW
			group4Box.matrix[3] = parseFloat(groupbox_geom_arr[7]);	// scaleY
			group4Box.matrix[4] = parseFloat(groupbox_geom_arr[8]);	// tx displace X
			group4Box.matrix[5] = parseFloat(groupbox_geom_arr[9]);	// ty displace Y
			group4Box.angle = getAngleFromMatrix(group4Box.matrix);	// angle in degrees
			sXsY = getScaleFromMatrix(group4Box.matrix);
			group4Box.scaleX = sXsY[0];
			group4Box.scaleY = sXsY[1];
			// add group to aBox
			aBox.group4_box = clone(group4Box);

			groupbox4_angle = group4Box.angle;	// angle in degrees
		}

		var imagInImag_geom_arr = "";
		var imagInImag = null;
		var imagInImag_angle = 0.0;	// for convenience
		var imagInImagScaleX = 1.0;
		var imagInImagScaleY = 1.0;
		if (imagInImagIGeo && (imagInImagIGeo != "")) {
			imagInImag_geom_arr = get_normalized_IGeo(imagInImagIGeo,'imag');
			imagInImag = new Object();
			imagInImag.real_left = imagInImag_geom_arr[0];		// left
			imagInImag.real_top = imagInImag_geom_arr[1];		// top
			imagInImag.real_right = imagInImag_geom_arr[2];	// right
			imagInImag.real_bottom = imagInImag_geom_arr[3];	// bottom
			imagInImag.matrix = new Array(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
			imagInImag.matrix[0] = parseFloat(imagInImag_geom_arr[4]);	// scale X
			imagInImag.matrix[1] = parseFloat(imagInImag_geom_arr[5]);	// -sinX(angle) CCW
			imagInImag.matrix[2] = parseFloat(imagInImag_geom_arr[6]);	// sinY(angle) CW
			imagInImag.matrix[3] = parseFloat(imagInImag_geom_arr[7]);	// scaleY
			imagInImag.matrix[4] = parseFloat(imagInImag_geom_arr[8]);	// tx displace X
			imagInImag.matrix[5] = parseFloat(imagInImag_geom_arr[9]);	// ty displace Y
			imagInImag_angle = imagInImag.angle = getAngleFromMatrix(imagInImag.matrix);	// angle in degrees
			sXsY = getScaleFromMatrix(imagInImag.matrix, false);
			imagInImag.scaleX = imagInImagScaleX = sXsY[0];
			imagInImag.scaleY = imagInImagScaleY = sXsY[1];
		}

		execBlock = "G";
		// get basic left top right bottom
		var box_geom_arr = get_normalized_IGeo(igeo,boxtype);
		aBox.real_left   = parseFloat(box_geom_arr[0]);
		aBox.real_top    = parseFloat(box_geom_arr[1]);
		aBox.real_right  = parseFloat(box_geom_arr[2]);
		aBox.real_bottom = parseFloat(box_geom_arr[3]);
		// fill transform matrix
		aBox.matrix[0] = parseFloat(box_geom_arr[4]);	// a = scale X: -1=flip horizontal, negative and zero sinX is 180 degrees
		aBox.matrix[1] = parseFloat(box_geom_arr[5]);	// b = -sinX(angle) CCW
		aBox.matrix[2] = parseFloat(box_geom_arr[6]);	// c = sinY(angle) CW
		aBox.matrix[3] = parseFloat(box_geom_arr[7]);	// d = scale Y: -1=flip vertical
		aBox.matrix[4] = parseFloat(box_geom_arr[8]);	// tx
		aBox.matrix[5] = parseFloat(box_geom_arr[9]);	// ty
		aBox.angle = getAngleFromMatrix(aBox.matrix);	// angle in degrees
		sXsY = getScaleFromMatrix(aBox.matrix);
		aBox.scaleX = aBoxScaleX = sXsY[0];
		aBox.scaleY = aBoxScaleY = sXsY[1];

		// store untouched state
		aBox.real_left_orig = aBox.real_left;
		aBox.real_top_orig = aBox.real_top;
		aBox.real_right_orig = aBox.real_right;
		aBox.real_bottom_orig = aBox.real_bottom;
		aBox.matrix_orig = aBox.matrix.slice();	// copy

		if (DEBUG > 0) {
			if (pageside == null || pageside == "") java.lang.System.out.println ("       page coords not available, is an anchored box");
			else java.lang.System.out.println ("       page coords l: " + page_left + ", t: " + page_top + ", r: " + page_right + ", b: " + page_bottom);
			java.lang.System.out.println ("       box iGeo: " + igeo);
			java.lang.System.out.println ("       box geom: " + box_geom_arr);
			java.lang.System.out.println ("    ** real cordinates (original, no matrices applied)");
			java.lang.System.out.println ("       aBox l,t,r,b: " + aBox.real_left + "," + aBox.real_top + "," + aBox.real_right + "," + aBox.real_bottom );
		}

		execBlock = "H";
		// scale, angles of groups above boxes are in
		var group1BoxScaleX = 1.0;
		var group1BoxScaleY = 1.0;
		var group2BoxScaleX = 1.0;
		var group2BoxScaleY = 1.0;
		var group3BoxScaleX = 1.0;
		var group3BoxScaleY = 1.0;
		var group4BoxScaleX = 1.0;
		var group4BoxScaleY = 1.0;
		if (aBox.group1_box != null) {
			group1BoxScaleX = aBox.group1_box.scaleX;
			group1BoxScaleY = aBox.group1_box.scaleY;
		}
		if (aBox.group2_box != null) {
			group2BoxScaleX = aBox.group2_box.scaleX;
			group2BoxScaleY = aBox.group2_box.scaleY;
		}
		if (aBox.group3_box != null) {
			group3BoxScaleX = aBox.group3_box.scaleX;
			group3BoxScaleY = aBox.group3_box.scaleY;
		}
		if (aBox.group4_box != null) {
			group4BoxScaleX = aBox.group4_box.scaleX;
			group4BoxScaleY = aBox.group4_box.scaleY;
		}

		var imgScaleX = aBoxScaleX * imagInImagScaleX * group1BoxScaleX * group2BoxScaleX * group3BoxScaleX * group4BoxScaleX;
		var imgScaleY = aBoxScaleY * imagInImagScaleY * group1BoxScaleY * group2BoxScaleY * group3BoxScaleY * group4BoxScaleY;
		aBox.scaleX = imgScaleX;
		aBox.scaleY = imgScaleY;
	
		execBlock = "I";
		// get total rotation
		var total_angle = aBox.angle + imagInImag_angle + groupbox1_angle + groupbox2_angle + groupbox3_angle + groupbox4_angle;

		// if aBox is rotated: make it unrotated
		if ( aBox.angle != 0.0 ) unrotate_box(aBox);

		// apply aBox own displace to get coords seen from spine
		get_box_pageRealCoords(aBox,aBox.matrix);
		if (DEBUG > 0) {
			java.lang.System.out.println ("    ** applied aBox own displace: " + aBox.matrix);
			java.lang.System.out.println ("       aBox real page coords l,t,r,b: " + aBox.real_left + "," + aBox.real_top + "," + aBox.real_right + "," + aBox.real_bottom);
		}

		execBlock = "J";
		// unrotate group boxes
		if ((group1Box != null) || (group1Box != null) || (group1Box != null) || (group1Box != null) || (imagInImag != null)) {
			if (DEBUG > 0) {
				java.lang.System.out.println ("    ** applying groups matrices");
				java.lang.System.out.println ("       parentGroupIDs: " + parentGroupIDs);
			}
			if ((groupbox1_angle != 0.0) && (group1Box)) unrotate_box(group1Box);
			if ((groupbox2_angle != 0.0) && (group2Box)) unrotate_box(group2Box);
			if ((groupbox3_angle != 0.0) && (group3Box)) unrotate_box(group3Box);
			if ((groupbox4_angle != 0.0) && (group4Box)) unrotate_box(group4Box);

			if (DEBUG > 0) {
				if (group1Box != null) java.lang.System.out.println ("       group1Box matrix: " + group1Box.matrix);
				if (group2Box != null) java.lang.System.out.println ("       group2Box matrix: " + group2Box.matrix);
				if (group3Box != null) java.lang.System.out.println ("       group3Box matrix: " + group3Box.matrix);
				if (group4Box != null) java.lang.System.out.println ("       group4Box matrix: " + group4Box.matrix);
			}
			// apply matrices of containing group boxes
			if (imagInImag != null) get_box_pageRealCoords (aBox,imagInImag.matrix);
			if (group1Box != null) get_box_pageRealCoords(aBox,group1Box.matrix);
			if (group2Box != null) get_box_pageRealCoords(aBox,group2Box.matrix);
			if (group3Box != null) get_box_pageRealCoords(aBox,group3Box.matrix);
			if (group4Box != null) get_box_pageRealCoords(aBox,group4Box.matrix);
			if (DEBUG > 0) {
				java.lang.System.out.println ("       aBox l,t,r,b: " + aBox.real_left + "," + aBox.real_top + "," + aBox.real_right + "," + aBox.real_bottom);
			}
		}

		execBlock = "K";
		// check real coords of this box
		if (aBox.real_bottom < aBox.real_top) {	// if a box is rotated right/bottom point may be higher than top/left
			var b = aBox.real_bottom; aBox.real_bottom = aBox.real_top; aBox.real_top = b;
		}
		if (aBox.real_right < aBox.real_left) {	// if a box is rotated left point may be higher than right
			var b = aBox.real_right; aBox.real_right = aBox.real_left; aBox.real_left = b;
		}

		// check if box coords left - right are correct
		if (aBox.right < aBox.left) {
			if (DEBUG > 0) java.lang.System.out.println ("   ### illegal box right to left coords for boxtype '" + boxtype + "', Boxid: '" + boxid + "', pageside: '" + pageside + "' ******");
			return 0;	// uuuups - should not be: illegal coords!
		}

		// now store total angle
		aBox.angle = total_angle;
		if (DEBUG > 0) {
			java.lang.System.out.println ("       box total angle: " + aBox.angle);
		}
		// mark that matrices are applied
		aBox.matrices_applied = true;

		execBlock = "L";
		// calc page coords
		if (pageside != null && pageside != "") {

			// calculate how much a box overlaps a page
			var overlap_leftpage = 0.0,
				overlap_rightpage = 0.0;
			if (aBox.real_left < 0) overlap_leftpage = Math.abs(aBox.real_left);
			if (aBox.real_right > 0) overlap_rightpage = Math.abs(aBox.real_right);
			if (DEBUG > 0) {
				java.lang.System.out.println ("    -- left Page overlap of box Boxid: '" + boxid + "' is: " + overlap_leftpage);
				java.lang.System.out.println ("    -- right Page overlap of box Boxid: '" + boxid + "' is: " + overlap_rightpage);
			}
			switch (pageside) {
				case 'rgth':	// check for double sided documents
					if (overlap_rightpage > overlap_leftpage) {
						aBox.belongs_to_page = pagenum;
						if ( (overlap_leftpage > 0.0) && (pagenum > 1) ) aBox.belongs_to_page_overlap = pagenum - 1;
						break;
					}
					break;
				case 'lfth':
					if (overlap_leftpage >= overlap_rightpage) {
						aBox.belongs_to_page = pagenum;
						if ( overlap_rightpage > 0.0 ) aBox.belongs_to_page_overlap = pagenum + 1;
						break;
					}
					break;
				default: // single page docs ('usex')
					if ( (aBox.real_left <= page_right) )  { aBox.belongs_to_page = pagenum; break; }
					break;
			}

			switch (pageside) {
				case 'rgth':
					aBox.left = aBox.real_left;					// left
					aBox.top = yZero + aBox.real_top;			// yZero + top
					aBox.right = aBox.real_right;				// right
					aBox.bottom = yZero + aBox.real_bottom;		// yZero + bottom

					aBox.left_orig = aBox.real_left_orig;		// rotated values
					aBox.top_orig = yZero + aBox.real_top_orig;
					aBox.right_orig = aBox.real_right_orig;
					aBox.bottom_orig = yZero + aBox.real_bottom_orig;

					// if box overlaps to left page, we have to calc these coords
					if (aBox.belongs_to_page_overlap >= 0) {	// must overlap to left page. calc like 'lfth' below
						aBox.left_overlap = page_width + aBox.real_left;	// page_width + left
						aBox.top_overlap = yZero + aBox.real_top;			// yZero + top
						aBox.right_overlap = page_width + aBox.real_right;	// page_width + right
						aBox.bottom_overlap = yZero + aBox.real_bottom;		// yZero + bottom
					}
					break;
				case 'lfth':
					aBox.left = page_width + aBox.real_left;	// page_width + left
					aBox.top = yZero + aBox.real_top;			// yZero + top
					aBox.right = page_width + aBox.real_right;	// page_width + right
					aBox.bottom = yZero + aBox.real_bottom;		// yZero + bottom

					aBox.left_orig = page_width + aBox.real_left_orig;	// rotated values
					aBox.top_orig = yZero + aBox.real_top_orig;
					aBox.right_orig = page_width + aBox.real_right_orig;
					aBox.bottom_orig = yZero + aBox.real_bottom_orig;

					// if box overlaps to right page, we have to calc these coords
					if (aBox.belongs_to_page_overlap >= 0) {	// must overlap to right page. calc like 'rgth' above
						aBox.left_overlap = aBox.real_left;					// left
						aBox.top_overlap = yZero + aBox.real_top;			// yZero + top
						aBox.right_overlap = aBox.real_right;				// right
						aBox.bottom_overlap = yZero + aBox.real_bottom;		// yZero + bottom
					}
					break;
				case 'usex':
					//java.lang.System.out.println ("** usex page_left: " + page_left + " page_right: " + page_right + ", pagenum: " + pagenum + ", pageside: " + pageside + ", spreadnum: " + pages_arr[pagenum-1].spread_num + ", page on spread: " + pages_arr[pagenum-1].pageOnSpread + ", page sequence: " + pages_arr[pagenum-1].page_sequence + ", pages onspread: " + pages_arr[pagenum-1].pages_onspread);
					if ( (page_left == 0) || (page_right == 0) ) {	// evtl. a double page with coords zero in middle of both
						if (page_left == 0) {
							aBox.left = aBox.real_left;		// left
							aBox.right = aBox.real_right;	// right

							aBox.left_orig = aBox.real_left_orig;	// rotated
							aBox.right_orig = aBox.real_right_orig;
						}
						else {
							aBox.left = page_width + aBox.real_left;	// page_width + left
							aBox.right = page_width + aBox.real_right;	// page_width + right
	
							aBox.left_orig = page_width + aBox.real_left_orig;	// rotated
							aBox.right_orig = page_width + aBox.real_right_orig;
						}
					}
					else {
						//aBox.left = page_width/2.0 + aBox.real_left;	// page_width/2 + left
						//aBox.right = page_width/2.0 + aBox.real_right;	// page_width/2 + right
						aBox.left = page_width*(pages_arr[pagenum-1].pages_onspread - (2*(pages_arr[pagenum-1].pageOnSpread-1)))/2 + aBox.real_left;	// page_width/2 + left
						aBox.right = page_width*(pages_arr[pagenum-1].pages_onspread - (2*(pages_arr[pagenum-1].pageOnSpread-1)))/2 + aBox.real_right;	// page_width/2 + right

						//aBox.left_orig = page_width/2.0 + aBox.real_left_orig;	// rotated
						//aBox.right_orig = page_width/2.0 + aBox.real_right_orig;
						aBox.left_orig = page_width*(pages_arr[pagenum-1].pages_onspread - (2*(pages_arr[pagenum-1].pageOnSpread-1)))/2 + aBox.real_left_orig;	// rotated
						aBox.right_orig = page_width*(pages_arr[pagenum-1].pages_onspread - (2*(pages_arr[pagenum-1].pageOnSpread-1)))/2 + aBox.real_right_orig;
					}
					aBox.top = yZero + aBox.real_top;				// yZero + top
					aBox.bottom = yZero + aBox.real_bottom;			// yZero + bottom

					aBox.top_orig = yZero + aBox.real_top_orig;		// rotated
					aBox.bottom_orig = yZero + aBox.real_bottom_orig;
					break;
				default:	// not available for anchored boxes
					break;
			}
			if (DEBUG > 0) {
				java.lang.System.out.println ("** checking box belongs to page #" + pagenum + ": boxtype: '" + boxtype + "', Boxid: '" + boxid + "', pageside: '" + pageside + "'");
				java.lang.System.out.println ("   box real page coords for Boxid: '" + boxid + "' l,t,r,b: " + aBox.real_left + "," + aBox.real_top + "," + aBox.real_right + "," + aBox.real_bottom);
				java.lang.System.out.println ("   page coords this box is on  Boxid: '" + boxid + "' page_left: " + page_left + ", page_right: " + page_right);
				java.lang.System.out.println ("                          page yZero: " + yZero);
			}

			// check if this area belongs to a page
			if ( aBox.real_right < page_left ) {	// might belong to this page but is off the page (left on spread or on left hand page)
				if (DEBUG > 0) {
					java.lang.System.out.println ("    ## box Boxid: '" + boxid + "' not for this '" + pageside + "' side page: coords are LEFT off page");
				}
				aBox.belongs_to_page = -1;
				return (aBox.belongs_to_page);	// do not export: is left on spread
			}
			if ( aBox.real_left > page_right ) {	// might belong to this page but is right off the page (on spread)
				if (DEBUG > 0) {
					java.lang.System.out.println ("    ## box Boxid: '" + boxid + "' not for this '" + pageside + "' side page: coords are RIGHT off page");
				}
				aBox.belongs_to_page = -2;
				return (aBox.belongs_to_page);	// do not export: is right on spread
			}
			if (DEBUG > 0) {
				java.lang.System.out.println ("    -- box Boxid: '" + boxid + "' is not off page(s) - not totally on spread.");
			}
		}
		else {	// is anchored box
			aBox.belongs_to_page = pagenum;
					aBox.left = aBox.real_left;					// left
					aBox.top = yZero + aBox.real_top;			// yZero + top
					aBox.right = aBox.real_right;				// right
					aBox.bottom = yZero + aBox.real_bottom;		// yZero + bottom
				aBox.right = aBox.real_right - aBox.real_left;
				aBox.bottom = aBox.real_bottom - aBox.real_top;
				aBox.left = aBox.top = 0;
					aBox.left_orig = aBox.real_left_orig;		// rotated values
					aBox.top_orig = yZero + aBox.real_top_orig;
					aBox.right_orig = aBox.real_right_orig;
					aBox.bottom_orig = yZero + aBox.real_bottom_orig;
				aBox.right_orig = aBox.real_right_orig - aBox.real_left_orig;
				aBox.bottom_orig = aBox.real_bottom_orig - aBox.real_top_orig;
				aBox.left_orig = aBox.top_orig = 0;
		}

		execBlock = "M";
		// calc the shape points of this (rotated) box as x1,y1,x2,y2....xn,yn
		aBox.shape_orig = "" + aBox.left + "," + aBox.top + "," + aBox.right + "," + aBox.top + "," + aBox.right + "," + aBox.bottom + "," + aBox.left + "," + aBox.bottom;
		var tx = aBox.left,	// we rotate around top left point
			ty = aBox.top,
			lt = rotatePoint(aBox.left-tx,aBox.top-ty,aBox.angle,tx,ty,1.0,true),		// left,top
			rt = rotatePoint(aBox.right-tx,aBox.top-ty,aBox.angle,tx,ty,1.0,true),		// right,top
			rb = rotatePoint(aBox.right-tx,aBox.bottom-ty,aBox.angle,tx,ty,1.0,true),	// right, bottom
			lb = rotatePoint(aBox.left-tx,aBox.bottom-ty,aBox.angle,tx,ty,1.0,true);	// left,bottom
		//aBox.shape = "" + lt[0] + "," + lt[1] + "," + rt[0] + "," + rt[1] + "," + rb[0] + "," + rb[1] + "," + lb[0] + "," + lb[1];
		aBox.shape = "" + resizeValue(lt[0]) + "," + resizeValue(lt[1]) + "," + resizeValue(rt[0]) + "," + resizeValue(rt[1]) + "," + resizeValue(rb[0]) + "," + resizeValue(rb[1]) + "," + resizeValue(lb[0]) + "," + resizeValue(lb[1]);
		var txo = aBox.left_overlap,	// page overlapping boxes: we rotate around top left point
			tyo = aBox.top_overlap,
			lto = rotatePoint(aBox.left_overlap-txo,aBox.top_overlap-tyo,aBox.angle,txo,tyo,1.0,true),		// left,top
			rto = rotatePoint(aBox.right_overlap-txo,aBox.top_overlap-tyo,aBox.angle,txo,tyo,1.0,true),		// right,top
			rbo = rotatePoint(aBox.right_overlap-txo,aBox.bottom_overlap-tyo,aBox.angle,txo,tyo,1.0,true),	// right, bottom
			lbo = rotatePoint(aBox.left_overlap-txo,aBox.bottom_overlap-tyo,aBox.angle,txo,tyo,1.0,true);	// left,bottom
		aBox.shape_overlap = "" + resizeValue(lto[0]) + "," + resizeValue(lto[1]) + "," + resizeValue(rto[0]) + "," + resizeValue(rto[1]) + "," + resizeValue(rbo[0]) + "," + resizeValue(rbo[1]) + "," + resizeValue(lbo[0]) + "," + resizeValue(lbo[1]);
		var bbl = lt[0],	// get bounding box
			bbt = lt[1],
			bbr = lt[0],
			bbb = lt[1];
		if (rt[0] < bbl) bbl = rt[0];	// get smallest left x
		if (rb[0] < bbl) bbl = rb[0];
		if (lb[0] < bbl) bbl = lb[0];
		if (rt[1] < bbt) bbt = rt[1];	// get smallest top y
		if (rb[1] < bbt) bbt = rb[1];
		if (lb[1] < bbt) bbt = lb[1];
		if (rt[0] > bbr) bbr = rt[0];	// get largest right x
		if (rb[0] > bbr) bbr = rb[0];
		if (lb[0] > bbr) bbr = lb[0];
		if (rt[1] > bbb) bbb = rt[1];	// get largest bottom y
		if (rb[1] > bbb) bbb = rb[1];
		if (lb[1] > bbb) bbb = lb[1];
		aBox.bbox_orig = "" + bbl + "," + bbt + "," + bbr + "," + bbb;
		aBox.bbox = "" + resizeValue(bbl) + "," + resizeValue(bbt) + "," + resizeValue(bbr) + "," + resizeValue(bbb);

		var bblo = lto[0],	// page overlapping boxes: get bounding box
			bbto = lto[1],
			bbro = lto[0],
			bbbo = lto[1];
		if (rto[0] < bblo) bblo = rto[0];	// get smallest left x
		if (rbo[0] < bblo) bblo = rbo[0];
		if (lbo[0] < bblo) bblo = lbo[0];
		if (rto[1] < bbto) bbto = rto[1];	// get smallest top y
		if (rbo[1] < bbto) bbto = rbo[1];
		if (lbo[1] < bbto) bbto = lbo[1];
		if (rto[0] > bbro) bbro = rto[0];	// get largest right x
		if (rbo[0] > bbro) bbro = rbo[0];
		if (lbo[0] > bbro) bbro = lbo[0];
		if (rto[1] > bbbo) bbbo = rto[1];	// get largest bottom y
		if (rbo[1] > bbbo) bbbo = rbo[1];
		if (lbo[1] > bbbo) bbbo = lbo[1];
		aBox.bbox_overlap = "" + resizeValue(bblo) + "," + resizeValue(bbto) + "," + resizeValue(bbro) + "," + resizeValue(bbbo);
			//java.lang.System.out.println ("     * box Boxid: '" + boxid + "' belongs_to_page #" + aBox.belongs_to_page + ", pageside '" + pageside + "' overlap to page: " + aBox.belongs_to_page_overlap + " bbox_overlap: " + aBox.bbox_overlap);
	
		if (DEBUG > 0) {
			java.lang.System.out.println ("     * box Boxid: '" + boxid + "' belongs_to_page #" + aBox.belongs_to_page + ", pageside '" + pageside + "' overlap to page: " + aBox.belongs_to_page_overlap + " ******");
			java.lang.System.out.println ("##############################################################");
		}

		valid_aBox();	// this aBox Object is valid
		return aBox.belongs_to_page;	// >0: is a valid area for this page, <=0: belongs to other page

	} catch (e) {
		java.lang.System.out.println ("####################### FATAL error in 'store_coords' ################################");
		java.lang.System.out.println ("'store_coords' in block '" + execBlock + "' called with params:"
				+ "\n  igeo [" + typeof(igeo) + "]: " + igeo
				+ "\n  spreadnum [" + typeof(spreadnum) + "]: " + spreadnum
				+ "\n  pagenum [" + typeof(pagenum) + "]: " + pagenum
				+ "\n  pageside [" + typeof(pageside) + "]: " + pageside
				+ "\n  boxtype [" + typeof(boxtype) + "]: " + boxtype
				+ "\n  boxid [" + typeof(boxid) + "]: " + boxid
				+ "\n  imagInImagIGeo [" + typeof(imagInImagIGeo) + "]: " + imagInImagIGeo
				+ "\n  groupbox1_igeo [" + typeof(groupbox1_igeo) + "]: " + groupbox1_igeo
				+ "\n  groupbox2_igeo [" + typeof(groupbox2_igeo) + "]: " + groupbox2_igeo
				+ "\n  groupbox3_igeo [" + typeof(groupbox3_igeo) + "]: " + groupbox3_igeo
				+ "\n  groupbox4_igeo [" + typeof(groupbox4_igeo) + "]: " + groupbox4_igeo
				+ "\n  parentGroupIDs [" + typeof(parentGroupIDs) + "]: " + parentGroupIDs
				+ "\n  label [" + typeof(label) + "]: " + label
				+ "\n  layerID [" + typeof(layerID) + "]: " + layerID
				+ "\n  layerName [" + typeof(layerName) + "]: " + layerName
				+ "\n  layerVisibility [" + typeof(layerVisibility) + "]: " + layerVisibility
				+ "\n  textinsets [" + typeof(textinsets) + "]: " + textinsets
				+ "\n  colcnt [" + typeof(colcnt) + "]: " + colcnt
				+ "\n  colwidth [" + typeof(colwidth) + "]: " + colwidth
				+ "\n  colgutter [" + typeof(colgutter) + "]: " + colgutter
				+ "\n  vjust [" + typeof(vjust) + "]: " + vjust
				+ "\n  paraspacelimit [" + typeof(paraspacelimit) + "]: " + paraspacelimit
				+ "\n  anchoredObjec_stof [" + typeof(anchoredObjec_stof) + "]: " + anchoredObjec_stof
				+ "\n  ##### ERROR name: " + e.name
				+ "\n  ##### ERROR message: " + e.message
				+ "\n  ##### ERROR: " + e
				);
		java.lang.System.out.println ("####################### FATAL error 'store_coords' Report end ########################");
	}

	return(-999);
}

function get_textboxstuff(which, rounded) {
/*		aBox.textboxstuff[0] = textinsetsArr[0];	// [0] - [3] textinsets: t, l, b, r
		aBox.textboxstuff[1] = textinsetsArr[1];
		aBox.textboxstuff[2] = textinsetsArr[2];
		aBox.textboxstuff[3] = textinsetsArr[3];
		aBox.textboxstuff[4] = h2d(parseInt(colcnt,10));				// [4] colcnt
		aBox.textboxstuff[5] = colwidth;			// [5] colwidth
		aBox.textboxstuff[6] = colgutter;			// [6] colgutter
		aBox.textboxstuff[7] = vjust;				// [7] vjust
		aBox.textboxstuff[8] = paraspacelimit;		// [8] paraspacelimit
*/
	if ( (which < 0) || (which > aBox.textboxstuff.length-1) ) return("");
	if ((rounded > 0) && (aBox.textboxstuff[which] != "") && (!isNaN(aBox.textboxstuff[which])) && (which != 7)) return(Math.ceil(aBox.textboxstuff[which]));
	else return (aBox.textboxstuff[which]);
}
function get_stof() { return (aBox.anchoredObjec_stof); }
function ls() { return parseInt(aBox.left,10); }
function ts() { return parseInt(aBox.top,10); }
function rs() { return parseInt(aBox.right,10); }
function bs() { return parseInt(aBox.bottom,10); }
function lso() { return parseInt(aBox.left_overlap,10); }
function tso() { return parseInt(aBox.top_overlap,10); }
function rso() { return parseInt(aBox.right_overlap,10); }
function bso() { return parseInt(aBox.bottom_overlap,10); }
function get_real_left() { return aBox.real_left; }
function get_real_top() { return aBox.real_top; }
function get_real_right() { return aBox.real_right; }
function get_real_bottom() { return aBox.real_bottom; }
function get_matrix() {
	if (aBox.matrix != null) return aBox.matrix.toString();
	return("");
}
function get_matrix_orig() {
	if (aBox.matrix_orig != null) return aBox.matrix_orig.toString();
	return("");
}
function get_angle() {
	return(aBox.angle);
}
function get_scaleX() {
	return(aBox.scaleX);
}
function get_scaleY() {
	return(aBox.scaleY);
}
function get_bbox_orig() {
	return(aBox.bbox_orig);
}
function get_bbox() {
	return(aBox.bbox);
}
function get_bbox_overlap() {
	return(aBox.bbox_overlap);
}
function get_shape_orig() {
	return(aBox.shape_orig);
}
function get_shape() {
	return(aBox.shape);
}
function get_shape_overlap() {
	return(aBox.shape_overlap);
}
function get_layerID() {
	return(aBox.layerID);
}
function get_layerName() {
	return(aBox.layerName);
}
function get_layerVisibility() {
	return(aBox.layerVisibility);
}
function get_noexp() {
	return(aBox.noexp);
}
function get_parentGroupIDs() {
	return(aBox.parentGroupIDs);
}
function get_belongs_to_page() {
	return(aBox.belongs_to_page);
}
function get_belongs_to_page_overlap() {
	return(aBox.belongs_to_page_overlap);
}
function get_label() {
	if (aBox.label != null) {
		var label = aBox.label.replace(/~sep~/g,'_');
		return label;
	}
	return("");
}
function get_thislabel(label) {
	// a label from an InDesign object attribute like:
	// ptag="x_1_x_2_c_Label_c_title:BatchXSLT for InDesign wird von aiedv.ch entwickelt und vertrieben. Mit einem Klick besuchen Sie die Webseite www.aiedv.ch##href:http://www.aidev.ch##"
	if ( (label == null) || (label == "") ) return("");
	if (label.indexOf("_c_") < 0) return(label);
	var mylabel = label.substr(label.lastIndexOf("_c_") + 3,label.length);
	mylabel = mylabel.replace(/~sep~/g,'_');
	return(mylabel); // the filtered label text
}

var split_label = new Array();
var split_label_idx = -1;
function store_splitlabel(labelstring) {
	if ( (labelstring == null) || (labelstring == "") ) { split_label = new Array(); split_label_idx = -1; return; }
	if (labelstring.indexOf("##") < 0) { split_label = new Array(); split_label_idx = -1; return; }
	var re = /~sep~/g;		// replace underscore
	var lbl = labelstring.replace(re,'_');
	split_label = lbl.split("##");
	split_label_idx = 0;
	// clean lables
	for (var i = 0; i < split_label.length; i++) {
		if ( (split_label[i].indexOf("<") >= 0) || (split_label[i].indexOf("&lt;") >= 0) ) {	// have XML in it?
			var re = /\u201D/g;		// E2 80 9D (U+201D RIGHT DOUBLE QUOTATION MARK)
			split_label[i] = split_label[i].replace(re, "\"");
			re = /\u201C/g;		// E2 80 9C (U+201C LEFT DOUBLE QUOTATION MARK)
			split_label[i] = split_label[i].replace(re, "\"");
		}
	}
	return;
}
function have_splitlabel(whichattrib) {
	if ( (whichattrib == null) || (whichattrib == "") ) return(false);
	if ( split_label.length <= 0 ) return(false);
	for (var i = 0; i < split_label.length; i++) {
		if (split_label[i].indexOf(whichattrib == 0)) return(true);
	}
	return(false);
}
function get_splitlabel(whichattrib) {
	if ( (whichattrib == null) || (whichattrib == "") ) return(false);
	if ( split_label.length <= 0 ) return("");
	for (var i = 0; i < split_label.length; i++) {
		if (split_label[i].indexOf(whichattrib) == 0) return(split_label[i].substr(split_label[i].lastIndexOf(whichattrib) + whichattrib.length,split_label[i].length));
	}
	return("");
}

var split_values = new Array();
var split_value_idx = -1;
function store_splitvalue(valuestring) {	// a comma separated string
	if ( (valuestring == null) || (valuestring == "") ) { split_values = new Array(); split_value_idx = -1; return; }
	split_values = valuestring.split(",");
	split_value_idx = 0;
	return;
}
function have_splitvalue() {
	if ( split_values.length <= 0 ) return(false);
	if ( split_value_idx >= split_values.length ) return(false);
	return(true);
}
function get_splitvalue() {
	if ( split_values.length <= 0 ) return("");
	if ( split_value_idx >= split_values.length ) return("");
	return(split_values[split_value_idx++]);
}

function get_labelvalue(thestring, val) {	// a slash separated string like: imagename/width/height
	if ( (thestring == null) || (thestring == "") ) { return ""; }
	var values = thestring.split("/");
	switch (val) {
	  case 0: // the image name
	    if (values.length > 0) return values[0];
	    break;
	  case 1: // the image width
	    if (values.length > 1) return values[1];
	    break;
	  case 2: // the image height
	    if (values.length > 2) return values[2];
	    break;
	}
	return "";
}


var textshortcut_length = 200;
var textshortcut = "";
function store_textshortcut(txt) {
	if ( (txt == null) || (txt == "") ) return;
	if (textshortcut.length >= textshortcut_length) return;
	mytxt = txt;
	var re = /\u2029/g;		// E2 80 A9 (Paragraph separator)
	mytxt = mytxt.replace(re,'+');
	re = /\u2028/g;		// E2 80 A8 (Line separator)
	mytxt = mytxt.replace(re,'+');
	re = /\r/g;		// CR
	mytxt = mytxt.replace(re,'');
	re = /\n/g;		// LF
	mytxt = mytxt.replace(re,'');
	re = /  /g;		// multiple spaces
	mytxt = mytxt.replace(re,' ');
	if (mytxt == "") return;

	// special chars:
	if ((textshortcut != "") && (textshortcut[textshortcut.length -1] != "+") && (mytxt[0] != "+")) textshortcut += "+";
	textshortcut += mytxt;
	if (textshortcut.length > textshortcut_length) textshortcut = textshortcut.substr(0,textshortcut_length) + "...";
}
function set_textshortcut_length(len) { try { textshortcut_length = parseInt(len,10) } catch(e) {} }
function reset_textshortcut() { textshortcut = ""; }
function get_textshortcut() {
	return textshortcut;
}


// ********** the article runs stuff
// ========== paragraph tabs
/*
                                                                        num tabs start 1st tab                                             start 2nd tab
                                                                               | |                                                           |
<txsr prst="o_u6b" crst="o_u67" inbl="U_30" inbr="U_20.1" infl="U_-16" alts="x_1_z_4_7473616c_e_tbac_74736163_c_A_74736c64_c_W_706f736d_U_85_z_4_7473616c_e_cent_74736163_c_A_74736c64_c__706f736d_U_139">
                                    |           |             |                                   |             |            |             |
                                    indent      indent        indent                              |             alignon      leader        position
                                    block left  block right   first line                        align           character
                                                                                                left
                                                                                                rght
                                                                                                cent
                                                                                                tbac          =>on this character
*/
var paragraphtabs = new Array();
function clear_paratabs() {
	paragraphtabs = new Array();
}
function store_paratabs(alts) {	// alts is the alts attribute
	paragraphtabs = new Array();
	if ((alts == null) || (alts == "")) return;
	var tabsdataarray = alts.split("/tab/");
	for (var z = 0; z < tabsdataarray.length; z++) {	// process each tab
		var tabs = tabsdataarray[z].split("_");
		paragraphtabs[paragraphtabs.length] = new Object();
		paragraphtabs[paragraphtabs.length - 1].align = tabs[0];
		paragraphtabs[paragraphtabs.length - 1].alignChar = tabs[1];
		paragraphtabs[paragraphtabs.length - 1].leaderChar = tabs[2];
		paragraphtabs[paragraphtabs.length - 1].pos = tabs[3];
	}
}
function get_paratabsXMLtag() {	// get whole xml tag
	var result = "";
	if ((paragraphtabs != null) && (paragraphtabs.length > 0)) {	// must be PRO version
		result += "<paratabs numtabs=\"" + paragraphtabs.length + "\">";
		for (var z = 0; z < paragraphtabs.length; z++) {
			result += "<tab align=\"" + safe_attr(paragraphtabs[z].align) + "\" alignChar=\"" + safe_attr(paragraphtabs[z].alignChar) + "\" leaderChar=\"" + safe_attr(paragraphtabs[z].leaderChar) + "\" pos=\"" + paragraphtabs[z].pos + "\"/>";
		}
		result += "</paratabs>";
	}
	return(result);
}


var paragraphsets = null;
function clear_parasets() {
	paragraphsets = null;
}
function store_parasets(AppliedParagraphStyle, Justification, LeftIndent, RightIndent, FirstLineIndent, LastLineIndent, SpaceBefore, SpaceAfter, StartParagraph, 
						KeepWithNext, KeepLinesTogether, KeepWithPrevious, DropCapCharacters, DropCapLines, DropcapDetail, GridAlignment, Hyphenation) {
	paragraphsets = new Object();
	paragraphsets.paraStyleID = "" + AppliedParagraphStyle;
	paragraphsets.Justification = "" + Justification;
	paragraphsets.insetBlockLeft = "" + LeftIndent;
	paragraphsets.insetBlockRight = "" + RightIndent;
	paragraphsets.insetFirstLine = "" + FirstLineIndent;
	paragraphsets.insetLastLineRight = "" + LastLineIndent;
	paragraphsets.SpaceBefore = "" + SpaceBefore;
	paragraphsets.SpaceAfter = "" + SpaceAfter;
	paragraphsets.StartParagraph = "" + StartParagraph;
	paragraphsets.KeepWithNext = "" + KeepWithNext;
	paragraphsets.KeepLinesTogether = "" + KeepLinesTogether;
	paragraphsets.KeepWithPrevious = "" + KeepWithPrevious;
	paragraphsets.DropCapCharacters = "" + DropCapCharacters;
	paragraphsets.DropCapLines = "" + DropCapLines;
	paragraphsets.DropcapDetail = "" + DropcapDetail;
	paragraphsets.GridAlignment = "" + GridAlignment;
	paragraphsets.Hyphenation = "" + Hyphenation;
	paragraphsets.xmlTag = "<parasets paraStyleID=\"" + safe_attr(paragraphsets.paraStyleID) + "\" justification=\"" + paragraphsets.Justification 
									+ "\" insetLeft=\"" + paragraphsets.insetBlockLeft + "\" insetRight=\"" + paragraphsets.insetBlockRight + "\" insetFirstline=\"" + paragraphsets.insetFirstLine + "\" insetLastLineRight=\"" + paragraphsets.insetLastLineRight 
									+ "\" spaceBefore=\"" + paragraphsets.SpaceBefore + "\" spaceAfter=\"" + paragraphsets.SpaceAfter  + "\" startParagraph=\"" + paragraphsets.StartParagraph 
									+ "\" keepWithNext=\"" + paragraphsets.KeepWithNext + "\" keepLinesTogether=\"" + paragraphsets.KeepLinesTogether  + "\" keepWithPrevious=\"" + paragraphsets.KeepWithPrevious 
									+ "\" dropCapsChars=\"" + paragraphsets.DropCapCharacters + "\" dropCapLines=\"" + paragraphsets.DropCapLines  + "\" dropcapDetail=\"" + paragraphsets.DropcapDetail 
									+ "\" adjustBaseLine=\"" + paragraphsets.GridAlignment + "\" hyph=\"" + paragraphsets.Hyphenation+ "\"/>";
}
function get_parasetsXMLtag() {	// get whole xml tag
	if (paragraphsets != null) return(paragraphsets.xmlTag);
	return("");
}


var paragraphlist = null;
function clear_paralist() {
	paragraphlist = null;
}
//		<txsr prst="o_u6b" crst="o_u67" inbl="U_5.669291338582678" infl="U_8.503937007874017" bnlt="e_LTnm" bnst="l_c" DHnm="c_i, ii, iii, iv..." bnle="l_2" bnbs="o_ued" bnnc="o_ued" bnba="e_cent" bnta="c_^m^t">
function store_paralist(BulletsAndNumberingListType, AppliedNumberingList, NumberingLevel, NumberingFormat, NumberingExpression, BulletsCharacterStyle, NumberingCharacterStyle, NumberingStartAt, NumberingContinue, NumberingAlignment, BulletsAlignment, BulletCharacterValue, BulletsTextAfter) {
	paragraphlist = null;
	if ( ((BulletsAndNumberingListType == null) || (BulletsAndNumberingListType == ""))
		&& ((AppliedNumberingList == null) || (AppliedNumberingList == ""))
		&& ((NumberingLevel == null) || (NumberingLevel == ""))
		&& ((NumberingFormat == null) || (NumberingFormat == ""))
		&& ((NumberingExpression == null) || (NumberingExpression == ""))
		&& ((BulletsCharacterStyle == null) || (BulletsCharacterStyle == ""))
		&& ((NumberingCharacterStyle == null) || (NumberingCharacterStyle == ""))
		&& ((NumberingStartAt == null) || (NumberingStartAt == ""))
		&& ((NumberingContinue == null) || (NumberingContinue == ""))
		&& ((NumberingAlignment == null) || (NumberingAlignment == ""))
		&& ((BulletsAlignment == null) || (BulletsAlignment == ""))
		&& ((BulletCharacterValue == null) || (BulletCharacterValue == ""))
		&& ((BulletsTextAfter == null) || (BulletsTextAfter == ""))
		) return;
	paragraphlist = new Object();
	paragraphlist.BulletsAndNumberingListType = "" + BulletsAndNumberingListType;	// bullets and numbering type: LTbt = bullets, LTnm = numbers
	paragraphlist.AppliedNumberingList = "" + AppliedNumberingList;
	paragraphlist.NumberingLevel = "" + NumberingLevel;
	paragraphlist.NumberingFormat = "" + NumberingFormat;
	paragraphlist.NumberingExpression = "" + NumberingExpression;
	paragraphlist.BulletsCharacterStyle = "" + BulletsCharacterStyle;
	paragraphlist.NumberingCharacterStyle = "" + NumberingCharacterStyle;
	paragraphlist.NumberingStartAt = "" + NumberingStartAt;
	paragraphlist.NumberingContinue = "" + NumberingContinue;
	paragraphlist.NumberingAlignment = "" + NumberingAlignment;
	paragraphlist.BulletsAlignment = "" + BulletsAlignment;
	paragraphlist.BulletCharacterValue = "" + BulletCharacterValue;
	paragraphlist.BulletsTextAfter = "" + BulletsTextAfter;
	paragraphlist.xmlTag = "<paralist BulletsAndNumberingListType=\"" + paragraphlist.BulletsAndNumberingListType
							+ "\" AppliedNumberingList=\"" + paragraphlist.AppliedNumberingList 
							+ "\" NumberingLevel=\"" + paragraphlist.NumberingLevel 
							+ "\" NumberingFormat=\"" + paragraphlist.NumberingFormat 
							+ "\" NumberingExpression=\"" + paragraphlist.NumberingExpression 
							+ "\" BulletsCharacterStyle=\"" + safe_attr(paragraphlist.BulletsCharacterStyle) 
							+ "\" NumberingCharacterStyle=\"" + safe_attr(paragraphlist.NumberingCharacterStyle) 
							+ "\" NumberingStartAt=\"" + paragraphlist.NumberingStartAt 
							+ "\" NumberingContinue=\"" + paragraphlist.NumberingContinue 
							+ "\" NumberingAlignment=\"" + safe_attr(paragraphlist.NumberingAlignment) 
							+ "\" BulletsAlignment=\"" + safe_attr(paragraphlist.BulletsAlignment) 
							+ "\" BulletCharacterValue=\"" + safe_attr(paragraphlist.BulletCharacterValue) 
							+ "\" BulletsTextAfter=\"" + safe_attr(paragraphlist.BulletsTextAfter) 
							+ "\"/>";
}
function get_paralistXMLtag() {	// get whole xml tag
	if (paragraphlist != null) return(paragraphlist.xmlTag);
	return("");
}


var paragraphrules = null;
function clear_pararules() {
	paragraphrules = new Array(2);
	paragraphrules[0] = null;
	paragraphrules[1] = null;
}
function have_pararules() {
	if ((paragraphrules != null) && ((paragraphrules[0] != null) || (paragraphrules[1] != null))) return(true);
	return(false);
}
function store_pararules(raon, ratp, rasz, rawd, raof, rail, rair, rakf, racl, rati, raop, ragc, ragt, rago,
						 rbon, rbtp, rbsz, rbwd, rbof, rbil, rbir, rbkf, rbcl, rbti, rbop, rbgc, rbgt, rbgo) {
	clear_pararules();
	if (   (raon=="") && (ratp=="") && (rasz=="") && (rawd=="") && (raof=="") && (rail=="") && (rair=="") && (rakf=="") && (racl=="") && (rati=="") && (raop=="") && (ragc=="") && (ragt=="") && (rago=="")
		&& (rbon=="") && (rbtp=="") && (rbsz=="") && (rbwd=="") && (rbof=="") && (rbil=="") && (rbir=="") && (rbkf=="") && (rbcl=="") && (rbti=="") && (rbop=="") && (rbgc=="") && (rbgt=="") && (rbgo=="")
		) return;
	if ( (raon!="") || (ratp!="") || (rasz!="") || (rawd!="") || (raof!="") || (rail!="") || (rair!="") || (rakf!="") || (racl!="") || (rati!="") || (raop!="") || (ragc!="") || (ragt!="") || (rago=="") ) {
		ruleAbove = new Object();
		ruleAbove.on = "" + raon;	// ON or OFF
		ruleAbove.type = "" + ratp;
		ruleAbove.size = "" + rasz;
		ruleAbove.width = "" + rawd;
		ruleAbove.offset = "" + raof;
		ruleAbove.leftIndent = "" + rail;
		ruleAbove.rightIndent = "" + rair;
		ruleAbove.keepInFrame = "" + rakf;
		ruleAbove.colorID = "" + racl;
		ruleAbove.tint = "" + rati;
		ruleAbove.overprint = "" + raop;
		ruleAbove.gapcolorID = "" + ragc;
		ruleAbove.gaptint = "" + ragt;
		ruleAbove.gapoverprint = "" + rago;
		ruleAbove.xmlTag = "<paraRuleAbove on=\"" + ruleAbove.on + "\" type=\"" + ruleAbove.type + "\" size=\"" + ruleAbove.size + "\" width=\"" + ruleAbove.width + "\" offset=\"" + ruleAbove.offset + "\" leftIndent=\"" + ruleAbove.leftIndent + "\" rightIndent=\"" + ruleAbove.rightIndent 
					+ "\"  keepInFrame=\"" + ruleAbove.keepInFrame + "\" colorID=\"" + ruleAbove.colorID + "\" tint=\"" + ruleAbove.tint + "\" overprint=\"" + ruleAbove.overprint + "\" gapcolorID=\"" + ruleAbove.gapcolorID + "\" gaptint=\"" + ruleAbove.gaptint + "\" gapoverprint=\"" + ruleAbove.gapoverprint + "\"/>";
		paragraphrules[0] = clone(ruleAbove);
	}
	if ( (rbon!="") || (rbtp!="") || (rbsz!="") || (rbwd!="") || (rbof!="") || (rbil!="") || (rbir!="") || (rbkf!="") || (rbcl!="") || (rbti!="") || (rbop!="") || (rbgc!="") || (rbgt!="") || (rbgo=="") ) {
		ruleBelow = new Object();
		ruleBelow.on = "" + rbon;	// ON or OFF
		ruleBelow.type = "" + rbtp;
		ruleBelow.size = "" + rbsz;
		ruleBelow.width = "" + rbwd;
		ruleBelow.offset = "" + rbof;
		ruleBelow.leftIndent = "" + rbil;
		ruleBelow.rightIndent = "" + rbir;
		ruleBelow.keepInFrame = "" + rbkf;
		ruleBelow.colorID = "" + rbcl;
		ruleBelow.tint = "" + rbti;
		ruleBelow.overprint = "" + rbop;
		ruleBelow.gapcolorID = "" + rbgc;
		ruleBelow.gaptint = "" + rbgt;
		ruleBelow.gapoverprint = "" + rbgo;
		ruleBelow.xmlTag = "<paraRuleBelow on=\"" + ruleBelow.on + "\" type=\"" + ruleBelow.type + "\" size=\"" + ruleBelow.size + "\" width=\"" + ruleBelow.width + "\" offset=\"" + ruleBelow.offset + "\" leftIndent=\"" + ruleBelow.leftIndent + "\" rightIndent=\"" + ruleBelow.rightIndent 
					+ "\"  keepInFrame=\"" + ruleBelow.keepInFrame + "\" colorID=\"" + ruleBelow.colorID + "\" tint=\"" + ruleBelow.tint + "\" overprint=\"" + ruleBelow.overprint + "\" gapcolorID=\"" + ruleBelow.gapcolorID + "\" gaptint=\"" + ruleBelow.gaptint + "\" gapoverprint=\"" + ruleBelow.gapoverprint + "\"/>";
		paragraphrules[1] = clone(ruleBelow);
	}
}
function get_pararulesXMLtag() {	// get whole xml tag
	var xml = "";
	if ((paragraphrules != null) && ((paragraphrules[0] != null) || (paragraphrules[1] != null))) {
		xml += "<pararules>";
		if (paragraphrules[0] != null) xml += paragraphrules[0].xmlTag;
		if (paragraphrules[1] != null) xml += paragraphrules[1].xmlTag;
		xml += "</pararules>";
	}
	return(xml);
}


var anchor_level = 0;
function incr_anchor_level() { anchor_level++; return(anchor_level); }
function decr_anchor_level() {
	if (anchor_level <= 0) {
		java.lang.System.out.println ("###### ERROR decrement anchor level. Level is already zero. Check anchor nestings.");
	}
	else anchor_level--;
	return (anchor_level);
}
function get_anchor_level() { return (anchor_level); }


// ********** a text run runs stuff
var articleruns = new Array();
var num_articleruns_items = 44;	// number of array elements
		// [0] == para start(1), end(2), start&end(3) else 0 for a 'span' styled text
		// [1] == prst, paragraph style name
		// [2] == crst, character style name
		// [3] == paln, paragraph align
		// [4] == font, fontname (the font family)
		// [5] == ptsz, fontsize
		// [6] == RGB color built from flcl (color id) and filt
		// [7] == filt, tone in %
		// [8] == CHARACTER ATTRIBUTES LIST
		// 		  ptfs, character attributes: Bold Italic...			BI or 1,2,3 for European Pi 1...2...3...
		// 		  undr, underline flag: true/false						U
		// 		  capm, character attributes: allcaps, smallcaps....	Cc
		// 		  posm, position: superscript, subscript
		// 		  strk, strike through
		// [9] == FREE TO USE (former content_node - never used)
		// [10] == txt, the plain text in this run
		// [11] == url to www link or empty if is no link - defined by a style sheet
		// [12] == fontName, the real fontname
		// [13] == fontNamePS, the PostScript fontname
		// [14] == spbe space before
		// [15] == spaf space after
		// [16] == inbl indent block left
		// [17] == inbr indent block right
		// [18] == infl indent first line
		// [19] == url to www link or empty if is no link - defined by a real Hyperlink
		// [20] == paragraphrules;	// store para tabs
		// [21] == paragraphsets;	// store para sets
		// [22] == paragraphtabs;	// store para rule
		// [23] == paragraphlist;	// store para list options
		// [24] == bshf;	// base line shift
		// [25] == phzs;	// horizontal scale
		// [26] == pvts;	// vertical scale
		// [27] == szld;	// line leading
		// [28] == pake;	// kerning
		// [29] == nobk;	// non breaking
		// [30] == ligt;	// ligatures
		// [31] == trak;	// tracking
		// [32] == array if attribs: ptfs,pskw,undr,capm,posm,strk,fontchange,font,fontName,fontNamePS
		// [33] = flcl;	// font color ID (use with filt)
		// [34] = plng;	// paragraph language
		// [35] = conditionalTextSelf;	// the Self attrib of condition if this is conditional text
		// [36] = the custom XML tag Self: XMLElementSelf
		// [37] = the custom XML tag tag name: XMLElementMarkupTag
		// [38] = the custom XML tag ID to Story ID: XMLElementXMLContent
		// [39] = render type like: inline | block
		// [40] = position # in Element
		// [41] = last # in block
		// [42] = runtype of text: 1==opara start, 2==para end, 3== para start and end, 0== inline text
		// [43] = container element tag name
		// [44] = the custom XML tag XMLAttribute: XMLElementAttributes
var textflowid = "";
var para_is_started = 0;
function store_textrun(containerElement,render,current_textrun,last_textrun,runtype,
						prst,crst,paln,spbe,spaf,inbl,inbr,infl,fontchange,fontFamily,fontName,fontNamePS,
						ptsz,flcl,filt,
						ptfs,pskw,undr,capm,posm,strk,
						txt,wwwLink,urlLink,bshf,phzs,pvts,szld,pake,nobk,ligt,trak,plng,
						conditionalTextSelf,XMLElementSelf,XMLElementMarkupTag,XMLElementXMLContent,XMLElementAttributes
						) {
		function new_articlerun() {
			articleruns[articleruns.length] = new Array(num_articleruns_items);
			articleruns[articleruns.length-1][9] = 0;	// free to use
			articleruns[articleruns.length-1][10] = "";
			articleruns[articleruns.length-1][36] = XMLElementSelf;
			articleruns[articleruns.length-1][37] = XMLElementMarkupTag;
			articleruns[articleruns.length-1][38] = XMLElementXMLContent;
			articleruns[articleruns.length-1][39] = render;					// "inline" or "block"
			articleruns[articleruns.length-1][40] = "" + current_textrun;
			articleruns[articleruns.length-1][41] = "" + last_textrun;
			articleruns[articleruns.length-1][42] = "" + runtype;
			articleruns[articleruns.length-1][43] = "" + containerElement;
			articleruns[articleruns.length-1][44] = XMLElementAttributes;
		}
		function add_articlerun_text(i) {	// store the plain text
			articleruns[articleruns.length-1][10] += articlerunstmp[i];
		}

	/* About paragraphs:
		1. A paragraph end is solely given by the <Br> element in the IMX. This <Br> is pre-converted to '\u2029'.
			A ParagraphStyleRange is NOT a start nor an end of a para
		2. A paragraph is started at the very beginning of a story or after a <Br> ('\u2029') has closed the para
	*/
	var ready_paras = 0;

	// split runs by paras
	var articlerunstmp = txt.split('\u2029');		// E2 80 A9 (Paragraph separator) split run to paragraphs
	if (DEBUG > 0) {
		java.lang.System.out.println ("****** STORING articleruns ******");
		java.lang.System.out.println ("       containerElement= '" + containerElement + "'");
		java.lang.System.out.println ("       runtype= '" + runtype + "'");
		java.lang.System.out.println ("       render= '" + render + "'");
		java.lang.System.out.println ("       current_textrun= " + current_textrun);
		java.lang.System.out.println ("       last_textrun= " + last_textrun);
		java.lang.System.out.println ("       numParasInRun: " + (articlerunstmp.length-1));
		java.lang.System.out.println ("       para_is_started: " + para_is_started);
		java.lang.System.out.println ("       paragraph style: " + prst);
		java.lang.System.out.println ("       character style: " + crst);
		java.lang.System.out.println ("       fontFamily: " + fontFamily);
		java.lang.System.out.println ("       fontName: " + fontName);
		var cr = /\u2029/g;		// E2 80 A9 (Paragraph separator)
		java.lang.System.out.println ("       TEXT= '" + txt.replace(cr,"/CR/") + "'");
	}

	var have_paras = (articlerunstmp.length > 1);
	// remove a last empty element
	var removed_last_empty_para = false;
	
	var nextParaStartTag = "";

	if ((articlerunstmp.length > 1) && (articlerunstmp[articlerunstmp.length-1] == "")) {
		articlerunstmp.length--;
		removed_last_empty_para = true;
		if (DEBUG > 0) java.lang.System.out.println ("     * removed last empty para");
	}

	// push each paragraph to articleruns array
	for (var i = 0; i < articlerunstmp.length; i++) {
		if (DEBUG > 0) {
			java.lang.System.out.println ("       **** Run: " + i + ", have_paras: " + have_paras + ", para_is_started: " + para_is_started);
		}
		var set_para_attrs = true;
		var set_char_attrs = true;


		// store CharacterStyleRange type and prepare store of paragraph attributes
		do {
			// create new article run if para is not started
			new_articlerun();
			add_articlerun_text(i);

			if (DEBUG > 0) java.lang.System.out.println ("------- text run: " + i);
			if (!have_paras) {
				if (DEBUG > 0) java.lang.System.out.println ("       handling non para..." );
				if (para_is_started == 0) {
					articleruns[articleruns.length-1][0] = 1;	// a para start
					para_is_started = 1;
				}
				else {
					articleruns[articleruns.length-1][0] = 0;	// a character run
					set_para_attrs = false;
				}
				break;
			}

			// ----- handle all text runs when containing para break
			if ( i < (articlerunstmp.length-1) ) {	// any of the split paragraphs
				if (DEBUG > 0) java.lang.System.out.println ("       handling a complete para..." );
				if (para_is_started == 0) {
					articleruns[articleruns.length-1][0] = 3;	// a para start and end
				}
				else {
					articleruns[articleruns.length-1][0] = 2;	// a para end
					para_is_started = 0;
				}
				break;
			}


			if ( i >= (articlerunstmp.length-1) ) {	// is last para in this CharacterStyleRange
				if (DEBUG > 0) java.lang.System.out.println ("       handling a last of split runs..." );
				if (para_is_started == 0) {
					if (removed_last_empty_para) {
						articleruns[articleruns.length-1][0] = 3;	// a para start and end
						para_is_started = 0;
					}
					else {
						articleruns[articleruns.length-1][0] = 1;	// a para start
						para_is_started = 1;
					}
				}
				else {
					if (removed_last_empty_para) {
						articleruns[articleruns.length-1][0] = 2;	// a para end
						para_is_started = 0;
					}
					else {
						articleruns[articleruns.length-1][0] = 0;	// a char run
					}
				}
			}

			break;

			// ----- handle character runs without para character
			if (!have_paras) {
				if (DEBUG > 0) java.lang.System.out.println ("       handling non paras..." );
				if (current_textrun == last_textrun) {	// the last CharacterStyleRange run in a ParagraphStyleRange
					if (para_is_started == 0) {
						articleruns[articleruns.length-1][0] = 3;	// start and end of para
					}
					else {
						articleruns[articleruns.length-1][0] = 2;	// end of para
						para_is_started = 0;
						set_para_attrs = true;
					}
				}
				else {	// may be first or following text run
					if (para_is_started == 0) {
						articleruns[articleruns.length-1][0] = 1;	// start para
						para_is_started = 1;
					}
					else {
						articleruns[articleruns.length-1][0] = 0;	// inline text
						set_para_attrs = false;
					}
				}
				break;
			}

			// if we are here, then we have paras in the run
			// ----- set the runtype of this CharacterStyleRange
			// ----- handle the very first para
			if ( (current_textrun == 1) && (i == 0) ) {
				if (DEBUG > 0) java.lang.System.out.println ("             the very first para..." );
				if (para_is_started == 0) {
					articleruns[articleruns.length-1][0] = 3;	// this CharacterStyleRange is an own paragraph
				}
				else {
					articleruns[articleruns.length-1][0] = 2;	// this CharacterStyleRange ends an already opened paragraph
					para_is_started = 0;
					set_para_attrs = false;
				}
				break;
			}

			// ----- handle the very last para
			if ( (current_textrun == last_textrun) && (i >= (articlerunstmp.length-1)) ) {
				if (DEBUG > 0) java.lang.System.out.println ("             the very last para..." );
				if (para_is_started == 0) {
					articleruns[articleruns.length-1][0] = 3;	// this CharacterStyleRange is an own paragraph
				}
				else {
					articleruns[articleruns.length-1][0] = 2;	// this CharacterStyleRange ends an already opened paragraph
					para_is_started = 0;
					set_para_attrs = false;
				}
				break;
			}
			
			// ----- handle all other para
			if (DEBUG > 0) java.lang.System.out.println ("             the other para..." );
			if ( i >= (articlerunstmp.length-1) ) {	// is last para in this CharacterStyleRange
				if (para_is_started == 0) {
					if (removed_last_empty_para) {
						articleruns[articleruns.length-1][0] = 3;	// a para
					}
					else {
						articleruns[articleruns.length-1][0] = 1;	// a para start
						para_is_started = 1;
					}
				}
				else {
					articleruns[articleruns.length-1][0] = 2;	// paragraph run at end of story
					para_is_started = 0;
					set_para_attrs = false;
				}
			}
			else {
				if (para_is_started == 0) {
					articleruns[articleruns.length-1][0] = 3;	// paragraph
				}
				else {
					articleruns[articleruns.length-1][0] = 2;	// paragraph
					para_is_started = 0;
					set_para_attrs = false;
				}
			}

		} while(false);

		if (DEBUG > 0) {
			java.lang.System.out.println ("       ----- resulting CharacterStyleRange RUNTYPE: " + articleruns[articleruns.length-1][0]);
			java.lang.System.out.println ("             para_is_started: " + para_is_started);
			java.lang.System.out.println ("       setting attributes");
		}

		if (set_para_attrs) {	// set paragraph attrs
			if (DEBUG > 0) java.lang.System.out.println ("               setting paragraph attributes: " + ptfs);
			articleruns[articleruns.length-1][1] = prst;	// set paragraph style name
			articleruns[articleruns.length-1][2] = crst;	// set caracter style name
			articleruns[articleruns.length-1][3] = paln;	// set paragraph align ("LeftAlign" | "CenterAlign" | "RightAlign" | "LeftJustified" | "RightJustified" | "CenterJustified" | "FullyJustified" | "ToBindingSide)
			articleruns[articleruns.length-1][4] = fontFamily;	// set fontFamily
			articleruns[articleruns.length-1][5] = ptsz;	// set fontsize
				var colr = "";
				if ((flcl == "") && (filt != "") ) {	// get color from char style
					colr = get_style_fontcolor(crst);
				}
				else colr = flcl;
			articleruns[articleruns.length-1][6] = get_rgb_color(colr,filt);	// set color
			articleruns[articleruns.length-1][7] = filt;	// color shade in %
			articleruns[articleruns.length-1][8] = store_char_attrs(ptfs,pskw,undr,capm,posm,strk,fontchange,fontFamily,fontName,fontNamePS);	// store character attributes for para
			articleruns[articleruns.length-1][11] = wwwLink;	// store link address
			articleruns[articleruns.length-1][12] = fontName;	// set real fontname
			articleruns[articleruns.length-1][13] = fontNamePS;	// set PS fontname
			articleruns[articleruns.length-1][14] = spbe;	// space before
			articleruns[articleruns.length-1][15] = spaf;	// space after
			articleruns[articleruns.length-1][16] = inbl;	// indent block left
			articleruns[articleruns.length-1][17] = inbr;	// indent block right
			articleruns[articleruns.length-1][18] = infl;	// indent first line
			articleruns[articleruns.length-1][19] = urlLink;	// store link address
			articleruns[articleruns.length-1][20] = get_pararulesXMLtag();	// store para rules
			articleruns[articleruns.length-1][21] = get_parasetsXMLtag();	// store para sets
			articleruns[articleruns.length-1][22] = get_paratabsXMLtag();	// store para tabs
			articleruns[articleruns.length-1][23] = get_paralistXMLtag();	// store para lists
			articleruns[articleruns.length-1][24] = bshf;	// base line shift
			articleruns[articleruns.length-1][25] = phzs;	// horizontal scale
			articleruns[articleruns.length-1][26] = pvts;	// vertical scale
			articleruns[articleruns.length-1][27] = szld;	// line leading
			if (isNaN(articleruns[articleruns.length-1][27])) articleruns[articleruns.length-1][27] = "";	// line leading auto
			articleruns[articleruns.length-1][28] = pake;	// kerning
			articleruns[articleruns.length-1][29] = nobk;	// non breaking
			articleruns[articleruns.length-1][30] = ligt;	// ligatures
			articleruns[articleruns.length-1][31] = trak;	// tracking
			articleruns[articleruns.length-1][32] = new Array(ptfs,pskw,undr,capm,posm,strk,fontchange);
			articleruns[articleruns.length-1][33] = flcl;	// font color ID (use with filt)
			articleruns[articleruns.length-1][34] = plng;	// language
			articleruns[articleruns.length-1][35] = conditionalTextSelf;	// conditional text Self
		}
		else {	// set character attrs
			if (set_char_attrs) {
				if (DEBUG > 0) java.lang.System.out.println ("               setting character attributes: " + ptfs);
				articleruns[articleruns.length-1][1] = prst;	// set paragraph style name
				articleruns[articleruns.length-1][2] = crst;	// set caracter style name
				articleruns[articleruns.length-1][4] = fontFamily;	// set fontFamily
				articleruns[articleruns.length-1][5] = ptsz;	// set fontsize
				var colr = "";
				if ((flcl == "") && (filt != "") ) {	// get color from char style
					colr = get_style_fontcolor(crst);
				}
				else colr = flcl;
				articleruns[articleruns.length-1][6] = get_rgb_color(colr,filt);	// set color
				articleruns[articleruns.length-1][7] = filt;	// color shade in %
				articleruns[articleruns.length-1][8] = store_char_attrs(ptfs,pskw,undr,capm,posm,strk,fontchange,fontFamily,fontName,fontNamePS);	// store character attributes for span
				articleruns[articleruns.length-1][11] = wwwLink;	// store link address
				articleruns[articleruns.length-1][12] = fontName;	// set real fontname
				articleruns[articleruns.length-1][13] = fontNamePS;	// set PS fontname
				articleruns[articleruns.length-1][19] = urlLink;	// store link address
				articleruns[articleruns.length-1][24] = bshf;	// base line shift
				articleruns[articleruns.length-1][25] = phzs;	// horizontal scale
				articleruns[articleruns.length-1][26] = pvts;	// vertical scale
				articleruns[articleruns.length-1][27] = szld;	// line leading
				if (isNaN(articleruns[articleruns.length-1][27])) articleruns[articleruns.length-1][27] = "";	// line leading auto
				articleruns[articleruns.length-1][28] = pake;	// kerning
				articleruns[articleruns.length-1][29] = nobk;	// non breaking
				articleruns[articleruns.length-1][30] = ligt;	// ligatures
				articleruns[articleruns.length-1][31] = trak;	// tracking
				articleruns[articleruns.length-1][32] = new Array(ptfs,pskw,undr,capm,posm,strk,fontchange);
				articleruns[articleruns.length-1][33] = flcl;	// font color ID (use with filt)
				articleruns[articleruns.length-1][34] = plng;	// language
				articleruns[articleruns.length-1][35] = conditionalTextSelf;	// conditional text Self
			}
		}

	}
	ready_paras = articleruns.length;

	if (DEBUG > 0) {
		java.lang.System.out.println ("       articlerun: " + articleruns[articleruns.length-1].toString());
		java.lang.System.out.println ("****** STORING articlerun end ******");
	}
	return ready_paras;
}
function equal_textrun_attribs(prst,crst,paln,spbe,spaf,inbl,inbr,infl,fontchange,font,fontName,fontNamePS,
								ptsz,flcl,filt,ptfs,pskw,undr,capm,posm,txt,wwwLink,urlLink,strk,bshf,phzs,pvts,szld,pake,nobk,ligt,trak,plng,
								conditionalTextSelf) {
	if (articleruns.length <= 0) return (false);
	/*
	java.lang.System.out.println ("******* prev_textrun_attribs: " + articleruns[articleruns.length-1][1] + "," + 
									articleruns[articleruns.length-1][2] + "," + 
									articleruns[articleruns.length-1][3] + "," + 
									articleruns[articleruns.length-1][4] + "," + 
									articleruns[articleruns.length-1][5] + "," + 
									articleruns[articleruns.length-1][6] + "," + 
									articleruns[articleruns.length-1][7] + "," + 
									articleruns[articleruns.length-1][8] + "," + 
									articleruns[articleruns.length-1][11] + "," + 
									articleruns[articleruns.length-1][12] + "," + 
									articleruns[articleruns.length-1][13] + "," + 
									articleruns[articleruns.length-1][14] + "," + 
									articleruns[articleruns.length-1][15] + "," + 
									articleruns[articleruns.length-1][16] + "," + 
									articleruns[articleruns.length-1][17] + "," + 
									articleruns[articleruns.length-1][18] + "," + 
									articleruns[articleruns.length-1][19]
									);
	java.lang.System.out.println ("******* equal_textrun_attribs: " + prst + "," + 
									crst + "," + 
									paln + "," + 
									font + "," + 
									ptsz + "," + 
									get_rgb_color(flcl,filt) + "," + 
									filt + "," + 
									store_char_attrs(ptfs,pskw,undr,capm,posm,strk,fontchange,font,fontName,fontNamePS) + "," + 
									wwwLink + "," + 
									fontName + "," + 
									fontNamePS + "," + 
									spbe + "," + 
									spaf + "," + 
									inbl + "," + 
									inbr + "," + 
									infl + "," + 
									urlLink
									);
	*/
	if (	   (articleruns[articleruns.length-1][1] == prst)	// paragraph style name
			&& (articleruns[articleruns.length-1][2] == crst)	// caracter style name
			&& (articleruns[articleruns.length-1][3] == paln)	// paragraph align (left | rght | cent | ljst | cjst | rjst | full)
			&& (articleruns[articleruns.length-1][4] == font)	// fontname
			&& (articleruns[articleruns.length-1][5] == ptsz)	// fontsize
			&& (articleruns[articleruns.length-1][6] == get_rgb_color(flcl,filt))	// color
			&& (articleruns[articleruns.length-1][7] == filt)	// color shade in %
			&& (articleruns[articleruns.length-1][8] == store_char_attrs(ptfs,pskw,undr,capm,posm,strk,fontchange,font,fontName,fontNamePS))	// character attributes for para
			&& (articleruns[articleruns.length-1][11] == wwwLink)	// link address
			&& (articleruns[articleruns.length-1][12] == fontName)	// real fontname
			&& (articleruns[articleruns.length-1][13] == fontNamePS)	// PS fontname
			&& (articleruns[articleruns.length-1][14] == spbe)	// space before
			&& (articleruns[articleruns.length-1][15] == spaf)	// space after
			&& (articleruns[articleruns.length-1][16] == inbl)	// indent block left
			&& (articleruns[articleruns.length-1][17] == inbr)	// indent block right
			&& (articleruns[articleruns.length-1][18] == infl)	// indent first line
			&& (articleruns[articleruns.length-1][19] == urlLink)	// link address
			&& (articleruns[articleruns.length-1][20] == get_pararulesXMLtag())	// para rules
			&& (articleruns[articleruns.length-1][21] == get_parasetsXMLtag())	// para sets
			&& (articleruns[articleruns.length-1][22] == get_paratabsXMLtag())	// para tabs
			&& (articleruns[articleruns.length-1][23] == get_paralistXMLtag())	// para lists
			&& (articleruns[articleruns.length-1][24] == bshf)	// base line shift
			&& (articleruns[articleruns.length-1][25] == phzs)	// horizontal scale
			&& (articleruns[articleruns.length-1][26] == pvts)	// vertical scale
			&& (articleruns[articleruns.length-1][27] == szld)	// line leading
			&& (articleruns[articleruns.length-1][28] == pake)	// kerning
			&& (articleruns[articleruns.length-1][29] == nobk)	// non breaking
			&& (articleruns[articleruns.length-1][30] == ligt)	// ligatures
			&& (articleruns[articleruns.length-1][31] == trak)	// tracking
			&& (articleruns[articleruns.length-1][34] == plng)	// language
			&& (articleruns[articleruns.length-1][35] == conditionalTextSelf)	// conditional text
		) return(true);
	return (false);
}
function print_articleruns() {
	java.lang.System.out.println ("****** articleruns ******");
	for (var i = 0; i < articleruns.length; i++) java.lang.System.out.println (articleruns[i].toString());
	java.lang.System.out.println ("****** articleruns end ******");
}

function get_num_articleruns() {
	return articleruns.length;
}
function get_articlerun_type() {
	if (articleruns.length <= 0) return -1;	// no more article runs
	return articleruns[0][0];
}
function get_articlerun_paraclass() {
	if (articleruns.length <= 0) return "";
	return get_style_class_name(articleruns[0][1]);
}
function get_articlerun_charclass() {
	if (articleruns.length <= 0) return "";
	return get_style_class_name(articleruns[0][2]);
}
function get_articlerun_paraStyleID() {
	if (articleruns.length <= 0) return "";
	return (articleruns[0][1]);
}
function get_articlerun_charStyleID() {
	if (articleruns.length <= 0) return "";
	return (articleruns[0][2]);
}
function get_articlerun_paraalign() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][3];
}
function get_articlerun_fontsize() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][5];
}
function get_articlerun_fontColorFilt() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][7] != null) return(articleruns[0][7]);
	return "";
}
function get_articlerun_fontFamily(force) {
	var ff;
	if (articleruns.length <= 0) return "";
	if (articleruns[0][4] != "") return articleruns[0][4];
	if (force) {
		ff = entity_fix(get_style_fontName(articleruns[0][2]));
		if (ff != "") return ff;
		ff = entity_fix(get_style_fontName(articleruns[0][1]));
		if (ff != "") return ff;
	}
	return "";
}
function get_articlerun_fontName(force) {
	var fn;
	if (articleruns.length <= 0) return "";
	if (articleruns[0][12] != "") return articleruns[0][12];
	if (force) {
		fn = entity_fix(get_style_fontName(articleruns[0][2]));	// get from characterstyle
		if (fn != "") {
			if (get_articlerun_fontStyle() != "") return fn + " " + get_articlerun_fontStyle();
			return fn + " Regular";
		}
		fn = entity_fix(get_style_fontName(articleruns[0][1]));	// get from paragraphstyle
		if (fn != "") {
			if (get_articlerun_fontStyle() != "") return fn + " " + get_articlerun_fontStyle();
			return fn + " Regular";
		}
	}
	return articleruns[0][4];	// return fontName
}
function get_articlerun_fontNamePS() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][13];
}
function get_articlerun_margTop() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][14];
}
function get_articlerun_margBott() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][15];
}
function get_articlerun_margLeft() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][16];
}
function get_articlerun_margRight() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][17];
}
function get_articlerun_firstLineIndent() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][18];
}
function get_articlerun_pararulesXMLtag() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][20] != null) return(articleruns[0][20]);
	return "";
}
function get_articlerun_parasetsXMLtag() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][21] != null) return(articleruns[0][21]);
	return "";
}
function get_articlerun_paratabsXMLtag() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][22] != null) return(articleruns[0][22]);
	return "";
}
function get_articlerun_paralistXMLtag() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][23] != null) return(articleruns[0][23]);
	return "";
}
function get_articlerun_baselineShift() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][24] != null) return(articleruns[0][24]);
	return "";
}
function get_articlerun_horizontalScale() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][25] != null) return(articleruns[0][25]);
	return "";
}
function get_articlerun_verticalScale() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][26] != null) return(articleruns[0][26]);
	return "";
}
function get_articlerun_lineLeading() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][27] != null) return(articleruns[0][27]);
	return "";
}
function get_articlerun_kerning() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][28] != null) return(articleruns[0][28]);
	return "";
}
function get_articlerun_nonBreaking() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][29] != null) return(articleruns[0][29]);
	return "";
}
function get_articlerun_ligatures() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][30] != null) return(articleruns[0][30]);
	return "";
}
function get_articlerun_tracking() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][31] != null) return(articleruns[0][31]);
	return "";
}

function get_articlerun_fontStyle() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][32] != null) return(articleruns[0][32][0]);
	return "";
}
function get_articlerun_fontSkew() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][32] != null) return(articleruns[0][32][1]);
	return "";
}
function get_articlerun_undeline() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][32] != null) return(articleruns[0][32][2]);
	return "";
}
function get_articlerun_capsMode() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][32] != null) return(articleruns[0][32][3]);
	return "";
}
function get_articlerun_charPos() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][32] != null) return(articleruns[0][32][4]);
	return "";
}
function get_articlerun_strike() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][32] != null) return(articleruns[0][32][5]);
	return "";
}
function get_articlerun_fontchange() {	// manually set font overrides if @font is set in txsr
	if (articleruns.length <= 0) return "";
	if (articleruns[0][32] != null) return(articleruns[0][32][6]);
	return "";
}
function get_articlerun_fontColorID() {
	if (articleruns.length <= 0) return "";
	if (articleruns[0][33] != null) return(articleruns[0][33]);
	return "";
}
function get_articlerun_language() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][34];
}
function get_articlerun_textcondition() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][35];
}
function get_articlerun_XMLElementSelf() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][36];
}
function get_articlerun_XMLElementMarkupTag() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][37];
}
function get_articlerun_XMLElementXMLContent() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][38];
}
function get_articlerun_XMLElementAttributes() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][44];
}
function get_articlerun_render() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][39];
}
function get_articlerun_current_textrun() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][40];
}
function get_articlerun_last_textrun() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][41];
}
function get_articlerun_runtype() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][42];
}
function get_articlerun_containerElement() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][43];
}


var characterAttribsSuppress = 0;	// suppress manually set character attributes like font-size... 
									// 0 = leave attribs as is
									// 1 = suppress manually set font-family
									// 2 = suppress manually set font-size
function store_characterAttribsSuppress(suppress) {
	if ((suppress == null) || (suppress == "")) return;
	try {
		characterAttribsSuppress = parseInt(suppress,10);
	}
	catch (e) {}
	return;
}
var paragraphAttribsSuppress = 1;	// suppress paragraph attributes like line-height (leading)
									// 0 = leave attribs as is
									// 1 = suppress line leading
function store_paragraphAttribsSuppress(suppress) {
	if ((suppress == null) || (suppress == "")) return;
	try {
		paragraphAttribsSuppress = parseInt(suppress,10);
	}
	catch (e) {}
	return;
}


var parentDIVstyle = "";
function get_articlerun_style(stype) {	// stype = 0 for span style, 1 for div style
	if (articleruns.length <= 0) return "";
	var ss = "";	// temp style string
	var stylestr = "";

	if (stype == 0) {	// for character
		var charstyle_fontname = entity_fix(get_style_fontName(articleruns[0][2]));
		var fontname = entity_fix(articleruns[0][12]);	// get from character run
		if (fontname == "") fontname = charstyle_fontname;	// get from character style
		if (fontname == "") fontname = entity_fix(get_style_fontName(articleruns[0][1]));	// get from paragraph style
	/* debug
		stylestr += "charstyle_fontname:" +charstyle_fontname + ";";
		stylestr += "fontname:" +fontname + ";";
		stylestr += "articleruns[0][4]:" +articleruns[0][4] + ";";
		stylestr += "stype:" +stype + ";";
		stylestr += "parentDIVstyle:" +parentDIVstyle + ";";
	*/
		var family_styleAddition = entity_fix(get_style_fontfamily_attributeAddition(fontname));
		if ((characterAttribsSuppress & 1) != 1) {
			if (articleruns[0][4] != "") {	// +++++ font-family
				if (fontname != charstyle_fontname) {
					ss = "font-family:'" + plain_Name(entity_fix(get_fontFamilyReplace(articleruns[0][4]))) + "'";
					if (fontname != "") ss += ",'" + fontname + "'";
					if (family_styleAddition != "") ss += "," + family_styleAddition;
					ss += "; ";
					if (stype == 0) {
						if (parentDIVstyle.indexOf(ss) < 0) stylestr += ss;	// for char styles only if not already given in parent's div
					}
					else stylestr += ss;	// for paragraphs
				}
			}
			else {	// get font family from pstyle and cstyle
				var pstyle_fontfamily = entity_fix(get_style_fontfamily(articleruns[0][1]));
				var cstyle_fontfamily = entity_fix(get_style_fontfamily(articleruns[0][2]));
				if ( (cstyle_fontfamily != "") && (pstyle_fontfamily != cstyle_fontfamily) ) {
					ss = "font-family:'" + plain_Name(cstyle_fontfamily) + "'";
					if (family_styleAddition != "") ss += "," + family_styleAddition;
					ss += "; ";
					stylestr += ss;
				}
			}
		}
		if ((characterAttribsSuppress & 2) != 2) {
			if (articleruns[0][5] != "") {	// +++++ font-size
				ss = "font-size:" + calc_fontsize(articleruns[0][5], true) + "; "
				if (stype == 0) {
					if (parentDIVstyle.indexOf(ss) < 0) stylestr += ss;	// for char styles only if not already given in parent's div
				}
				else stylestr += ss;	// for paragraphs
			}
		}
		if ((articleruns[0][6] != "") || (articleruns[0][7] != "")) {	// +++++ color and filter (it may be a grayscale)
			var color = articleruns[0][6];
			if (articleruns[0][7] != "") {
				if (color == "") color = "000000";
				color = get_RGBcolorTone(color,articleruns[0][7]);
			}
			if (color != "") stylestr += "color:" + (color != "transparent" ? "#" : "") + color + "; ";
		}
	
		if (articleruns[0][8].indexOf('B') >= 0) {	// +++++ font-weight:bold
			ss = "font-weight:bold; ";
			if (stype == 0) {
				if (parentDIVstyle.indexOf(ss) < 0) stylestr += ss;	// for char styles only if not already given in parent's div
			}
			else stylestr += ss;	// for paragraphs
		}
		if (articleruns[0][8].indexOf('b') >= 0) {	// +++++ font-weight:normal
			ss = "font-weight:normal; ";
			if (stype == 0) {
				if (parentDIVstyle.indexOf(ss) < 0) stylestr += ss;	// for char styles only if not already given in parent's div
			}
			else stylestr += ss;	// for paragraphs
		}
	
		if (articleruns[0][8].indexOf('I') >= 0) {	// +++++ font-style
			ss = "font-style:italic; ";
			if (stype == 0) {
				if (parentDIVstyle.indexOf(ss) < 0) stylestr += ss;	// for char styles only if not already given in parent's div
			}
			else stylestr += ss;	// for paragraphs
		}
		if (articleruns[0][8].indexOf('i') >= 0) {	// +++++ font-style
			ss = "font-style:normal; ";
			if (stype == 0) {
				if (parentDIVstyle.indexOf(ss) < 0) stylestr += ss;	// for char styles only if not already given in parent's div
			}
			else stylestr += ss;	// for paragraphs
		}
	
		if (articleruns[0][8].indexOf('C') >= 0) {	// +++++ text-transform (allcaps)
			ss = "text-transform:uppercase; ";
			if (stype == 0) {
				if (parentDIVstyle.indexOf(ss) < 0) stylestr += ss;	// for char styles only if not already given in parent's div
			}
			else stylestr += ss;	// for paragraphs
		}
		if (articleruns[0][8].indexOf('U') >= 0) {	// +++++ text-decoration underline
			ss = "text-decoration:underline; ";
			if (stype == 0) {
				if (parentDIVstyle.indexOf(ss) < 0) stylestr += ss;	// for char styles only if not already given in parent's div
			}
			else stylestr += ss;	// for paragraphs
		}
		if (articleruns[0][8].indexOf('T') >= 0) {	// +++++ text-decoration line-through
			ss = "text-decoration:line-through; ";
			if (stype == 0) {
				if (parentDIVstyle.indexOf(ss) < 0) stylestr += ss;	// for char styles only if not already given in parent's div
			}
			else stylestr += ss;	// for paragraphs
		}
		if (articleruns[0][8].indexOf('c') >= 0) {	// +++++ text-transform (smallcaps)
			//ss = "text-transform:capitalize; ";
			ss = "font-variant:small-caps; ";
			if (stype == 0) {
				if (parentDIVstyle.indexOf(ss) < 0) stylestr += ss;	// for char styles only if not already given in parent's div
			}
			else stylestr += ss;	// for paragraphs
		}
		if (articleruns[0][8].indexOf('0') >= 0) {	// +++++ text-transform (none)
			ss = "text-transform:none; ";
			if (stype == 0) {
				if (parentDIVstyle.indexOf(ss) < 0) stylestr += ss;	// for char styles only if not already given in parent's div
			}
			else stylestr += ss;	// for paragraphs
		}
		if (articleruns[0][8].indexOf('S') >= 0) {	// +++++ vertical-align (superscript)
			ss = "vertical-align:super; ";
			if (stype == 0) {
				if (parentDIVstyle.indexOf(ss) < 0) stylestr += ss;	// for char styles only if not already given in parent's div
			}
			else stylestr += ss;	// for paragraphs
		}
		if (articleruns[0][8].indexOf('s') >= 0) {	// +++++ vertical-align (subscript)
			ss = "vertical-align:sub; ";
			if (stype == 0) {
				if (parentDIVstyle.indexOf(ss) < 0) stylestr += ss;	// for char styles only if not already given in parent's div
			}
			else stylestr += ss;	// for paragraphs
		}
		if (articleruns[0][8].indexOf('1') >= 0) {	// +++++ vertical-align (none)
			ss = "vertical-align:baseline; ";
			if (stype == 0) {
				if (parentDIVstyle.indexOf(ss) < 0) stylestr += ss;	// for char styles only if not already given in parent's div
			}
			else stylestr += ss;	// for paragraphs
		}
		if ((articleruns[0][29] != null) && (articleruns[0][29].indexOf('t') >= 0)) {
			stylestr += "white-space:nowrap; ";
		}
	}

	if (stype == 1) {	// for paragraphs
		if (articleruns[0][3] != "") {	// +++++ text-align
			stylestr += "text-align:";
			switch (articleruns[0][3]) {	// ("LeftAlign" | "CenterAlign" | "RightAlign" | "LeftJustified" | "RightJustified" | "CenterJustified" | "FullyJustified" | "ToBindingSide)
				case "LeftAlign": stylestr += "left";
					break;
				case "CenterAlign": stylestr += "center";
					break;
				case "RightAlign": stylestr += "right";
					break;
				default: stylestr += "justify";
					break;
			}
			stylestr += "; ";
		}
		if (articleruns[0][14] != "") {	// +++++ margin-top, space before
			ss = "margin-top:" + round_numberString(articleruns[0][14]) + "px; ";
			stylestr += ss;
		}
		if (articleruns[0][15] != "") {	// +++++ margin-bottom, space after
			ss = "margin-bottom:" + round_numberString(articleruns[0][15]) + "px; ";
			stylestr += ss;
		}
		if (articleruns[0][16] != "") {	// +++++ margin-left, indent block left
			ss = "margin-left:" + round_numberString(articleruns[0][16]) + "px; ";
			stylestr += ss;
		}
		if (articleruns[0][17] != "") {	// +++++ margin-right, indent block right
			ss = "margin-right:" + round_numberString(articleruns[0][17]) + "px; ";
			stylestr += ss;
		}
		if (articleruns[0][18] != "") {	// +++++ text-indent, indent first line
			ss = "text-indent:" + round_numberString(articleruns[0][18]) + "px; ";
			stylestr += ss;
		}

		if ((paragraphAttribsSuppress & 1) != 1) {
			if (articleruns[0][27] != "") {	// +++++ line-height, leading
				ss = "line-height:" + calc_fontsize(articleruns[0][27], true) + "; ";
				stylestr += ss;
			}
		}
	}

	return stylestr;
}
function clean_wwwLink(thelink) {	// clean out www links
	if ((thelink == null) || (thelink == "")) return "";
	var link = thelink;
	var re = /%3a/g;		// colon :
	link = link.replace(re,':');
	var re = /\u2029/g;		// E2 80 A9 (Paragraph separator)
	link = link.replace(re,'');
	re = /\u2028/g;		// E2 80 A8 (Line separator)
	link = link.replace(re,'');
	re = /\u2011/g;		// non-breaking hyphen: utf8 = e2 80 91
	link = link.replace(re,'');
	re = /\u2010/g;		// hyphen: utf8 = e2 80 90
	link = link.replace(re,'');
	re = /\t/g;		// tabs
	link = link.replace(re,'');

	re = /  /gi;		// remove double blanks
	link = link.replace(re,' ');
	re = /\<(.)*?\>/gi;		// remove any formatting within link URL <?...> construct
	link = link.replace(re,'');

	// truncate right
	while (link.charAt(link.length - 1) == " ") link = link.substring(0,link.length-1);
	return(link);
}
function get_articlerun_wwwLink() {
	if (articleruns.length <= 0) return "";
	return (articleruns[0][11]);
}
function get_articlerun_urlLink() {
	if (articleruns.length <= 0) return "";
	return articleruns[0][19];
}

function get_articlerun_text() {
	var used_font, have_conversion_table,
		txt = "", // original text
		txt2c = "", // text part to convert
		txtconverted = "", // converted text part
		startc = 0,
		endc = 0,
		processedpos = 0,
		re_lt = /(<)|(&lt;\?__)|(TT__HiddenText__TT)/,
		re_gt = /(>)|(?&gt;)|(TT__\/HiddenText__TT)/;
	if (articleruns.length <= 0) return "";

	// get the plain text content
	txt = articleruns[0][10];

	// entity fixing - must be done before convertWithFontTable inserts entities
//	txt = entity_fix(txt);

	/*
	if ( (
			(txt == "&amp;") || (txt == "&lt;") || (txt == "&gt;") || (txt == ";")
		)
		|| (
			(txt.indexOf("&lt;?__ctrlchar") < 0)
			&& (txt.indexOf("<footnote_num") < 0)
			&& (txt.indexOf("<br ") < 0)
			&& (txt.indexOf("&") < 0) && (endsWith(txt,";") === false)	// is no HTML entity name
			)
		 ) {
	*/

	// get the font name used
	used_font = get_articlerun_fontName(true);
	have_conversion_table = haveFontConversionTable(used_font);
	if (have_conversion_table < 0) {	// might be a wrong 'roman' fontStyle instead of 'Regular'
		if (used_font.indexOf(" Roman") > 0) {
			used_font = used_font.replace(/ Roman$/," Regular");
			have_conversion_table = haveFontConversionTable(used_font);
		}
	}
	if (DEBUG > 0) java.lang.System.out.println ("%%%%%%%FONT: " + get_articlerun_fontFamily(true) + "," + get_articlerun_fontName(true) + "," + get_articlerun_fontNamePS()  + ", style:" + get_articlerun_fontStyle() + ", used:" + used_font);
	if (have_conversion_table >= 0) {
		// we must NOT convert XML tags contained in the text stream!!
		if ((txt.indexOf("<") > -1) || (txt.indexOf("&lt;\?__") > -1)) {
			txtconverted = "";
			processedpos = startc = endc = 0;
			while (true) {
				//	Packages.com.epaperarchives.batchxslt.utils.showMess("   -- get_articlerun_text txt:" + txt + "\r\n");
				//	Packages.com.epaperarchives.batchxslt.utils.showMess("   -- get_articlerun_text length:" + txt.length + " processedpos:" + processedpos + " startc:" + startc+ " endc:" + endc + "\r\n");
				startc = txt.search(re_lt);
				//	Packages.com.epaperarchives.batchxslt.utils.showMess("   -- get_articlerun_text xml begins at startc:" + startc + "\r\n");
				if (startc < 0) {	// no more XML tags
					if (processedpos < (txt.length-1)) {	// convert and add ending plaintext
						txt2c = txt.substr(processedpos);
						txtconverted += convertWithFontTable(have_conversion_table,txt2c);
					}
					break;
				}

				endc = txt.search(re_gt);
				//	Packages.com.epaperarchives.batchxslt.utils.showMess("   -- get_articlerun_text xml ends at endc:" + endc + "\r\n");

				// now convert a text part
				if (processedpos < startc) {
					txt2c = txt.substring(processedpos, startc);
					txtconverted += convertWithFontTable(have_conversion_table,txt2c);
				}
				// add the xml part
				if (txt.charAt(endc) == '>') txtconverted += txt.substring(startc, endc+1);				// found >
				else if (txt.charAt(endc) == '?') txtconverted += txt.substring(startc, endc+5);		// found end of processing instruction
					  else if (txt.charAt(endc) == 'T') txtconverted += txt.substring(startc, endc+19);	//  found TT__/HiddenText__TT
					  	   else txtconverted += txt.substring(startc, endc+1);		// WE HAVE A PROBLEM!!
				
				if (endc >= (txt.length-1)) break;
				// copy rest of text to be processed
				if (txt.charAt(endc) == '>') txt = txt.substr(endc+1);				// found >
				else if (txt.charAt(endc) == '?') txt = txt.substr(endc+5);			// found end of processing instruction
					 else if (txt.charAt(endc) == 'T') txt = txt.substr(endc+19);	// found TT__/HiddenText__TT
					 	  else txt = txt.substr(endc+1);		// WE HAVE A PROBLEM!!
				processedpos = startc = endc = 0;
			}
			txt = txtconverted;
		}
		else {
			//java.lang.System.out.println ("------- font_table_name: " + used_font + ": " + txt);
			//Packages.com.epaperarchives.batchxslt.utils.showMess("------- font_table_name: " + used_font + ": '" +  txt + "'\r\n");
			txt = convertWithFontTable(have_conversion_table,txt);
			//Packages.com.epaperarchives.batchxslt.utils.showMess("------- txt converted: '" + txt + "'\r\n");
			//java.lang.System.out.println ("------- txt: " + txt);
		}
	}
	// uncomment to see font name and used table
	//txt = "**FONT:" + used_font + "," + have_conversion_table + "//" + txt;

	// replace other chars
	txt = txt.replace(/\u2028/g,'<br/>');	// line separator
	txt = txt.replace(/\&#8232;/g,'<br/>');	// line separator \u2028

	return (txt);
}
function articlerun_text_remove() {
	if (articleruns.length <= 0) return;
	// remove this run
	for (var i = 1; i < articleruns.length; i++) {
		articleruns[i-1] = articleruns[i];
	}
	articleruns.length--;
	return;
}
function next_articlerun_text_startsWith(t) {
	if (articleruns.length <= 0) return (false);
	if ( (t == null) || (t == "") ) return (false);

	// check text if starts with t
	if (articleruns[0][10].indexOf(t) == 0) return (true);
	return(false);
}
function get_next_articlerun_text() {	// call after get_articlerun_text and articlerun_text_remove()
	if (articleruns.length <= 0) return ("");
	return ( articleruns[0][10]);
}

function call_output_articleruns() {
	var result = "",
		runtype;
	while (get_num_articleruns() >= 1) {
		// runtype:
		// 0 = character run
		// 1 = para start
		// 2 = para end
		// 3 = para start and end
		runtype = get_articlerun_type();
		if (runtype >= 0) {	// if we have runs
			if (runtype >= 1) result += output_pararun();	// a para run
			else result += output_charrun();
		}
	}
	// ad / merge anchored objects
	if (result != "") {
		result = merge_anchored_objects_to_output(result,false);
		// throw out links with no link text like: <a href="http://www.aiedv.ch"></a>
		re = /\<a href=\"[^"]*\"\>\<\/a\>/g;
		result = result.replace(re,"");

		// now replace special control character markers: &lt;?__ctrlchar__ type="hex" code="3"__ctrlchar__?&gt;
		re = /&lt;\?__ctrlchar__/g;
		result = result.replace(re,"\<ctrlchar");
		re = /__ctrlchar__\?&gt;/g;
		result = result.replace(re,"/>");

		re = /&lt;__xmlElement__/g;
		result = result.replace(re,"\<xmlElement");
		re = /\/__xmlElementEND__\&gt;/g;
		result = result.replace(re,">");
		re = /\&lt;\/__xmlElement__\&gt;/g;
		result = result.replace(re,"</xmlElement>");

		re = /&lt;__xmlInstruction__/g;
		result = result.replace(re,"\<xmlInstruction");
		re = /\/__xmlInstructionEND__\&gt;/g;
		result = result.replace(re,"/>");

		re = /TT__HiddenText__TT/g;
		result = result.replace(re,"<HiddenText>");
		re = /TT__\/HiddenText__TT/g;
		result = result.replace(re,"</HiddenText>");
	}
	return (result);
}

var allow_paraclass_overrides = true;
function set_allow_paraclass_overrides(flag) {
	if ( (flag != null) && ((flag != 0) || (flag != '0')) ) allow_paraclass_overrides = true;
	else allow_paraclass_overrides = false;
}
function output_pararun() {	// called with runtype of 1,2 or 3
							// 0 = character run
							// 1 = para start
							// 2 = para end
							// 3 = para start and end
	var result = "";
	var paraclass = get_articlerun_paraclass();
	var charclass = get_articlerun_charclass();
	var style = "";		//paragraph style
	var style_is_set = false;	//paragraph style is applied
	var cstyle = "";	//character style
	var wwwLink = clean_wwwLink(get_articlerun_wwwLink());
	var urlLink = clean_wwwLink(get_articlerun_urlLink());
	var paradiv_is_open = false;

	// store current / parent font-size
	var runfontsize = get_articlerun_fontsize();
	var parentclassid = get_articlerun_paraStyleID();
	if ((parentclassid != null) && (parentclassid != "")) runfontsize = get_style_fontsize(parentclassid);

	var pushedparentfontsize = false; 
	if (runfontsize != null) pushedparentfontsize = push_parentFontSize(runfontsize);
	//java.lang.System.out.println ("%%%%%%%FONT-size: run: " + get_articlerun_fontsize() + ", parentclassid: " + parentclassid + ", class size: " + get_style_fontsize(parentclassid) + ", pushed: " + runfontsize);

	var runtype = get_articlerun_type();
	do {
		var reset_span = false;
		if (DEBUG) java.lang.System.out.println ("**** output_pararun(): runtype:" + runtype);
		if (runtype < 0) break;	// no more runs
		if ((runtype == 1) || (runtype == 3)) {	//	called with runtype of 1 or 3, for any start of paras
			paradiv_is_open = true;
			result += "<div";
				if (get_articlerun_XMLElementSelf() != "") result += " XMLElementSelf=\"" + get_articlerun_XMLElementSelf() + "\"";	// XMLElementSelf
				if (get_articlerun_XMLElementMarkupTag() != "") result += " XMLElementMarkupTag=\"" + get_articlerun_XMLElementMarkupTag() + "\"";	// XMLElementMarkupTag
				if (get_articlerun_XMLElementXMLContent() != "") result += " XMLElementXMLContent=\"" + get_articlerun_XMLElementXMLContent() + "\"";	// XMLElementXMLContent
				if (get_articlerun_XMLElementAttributes() != "") result += " XMLElementAttributes=\"" + get_articlerun_XMLElementAttributes() + "\"";	// XMLElementAttributes
				if (fontsizeUnits > 0) {
					var fs = get_articlerun_fontsize();
					if ((fs == null) || (fs == "")) {
						var classid = get_articlerun_paraStyleID();
						if ((classid != null) && (classid != "")) fs = get_style_fontsize(classid);
					}
					result += " data-fontsize=\"" + fs + "\"";
				}
				if ((outputFeatures >= 2) && (addRuntypeInfo > 0)) {	// must be PRO version
					result += " container=\"" + get_articlerun_containerElement() + "\"";
					result += " runtype=\"" + get_articlerun_runtype() + "\"";
					if (get_articlerun_current_textrun() != "") result += " run=\"" + get_articlerun_current_textrun() + "\"";
					if (get_articlerun_last_textrun() != "") result += " lastrun=\"" + get_articlerun_last_textrun() + "\"";
					if (get_articlerun_render() != "") result += " render=\"" + get_articlerun_render() + "\"";	// render typ like: inline | block
				}
				var paraclass_set = false;
				if (paraclass != "") {
					result += " class=\"" + paraclass + "\"";
					paraclass_set = true;
				}
					// IMPORTANT: if we have a class in div, we do NOT set other styles or we are not able to modify the external CSS file
					//			  the flag allow_paraclass_overrides set to true will allow to override para class settings
				if (allow_paraclass_overrides == true) {
					style = get_articlerun_style(1);	// get para style overrides
					if ( style != "" ) result += " style=\"" + style + "\"";
				}
				if (wwwLink != "") result += " wwwLink=\"" + wwwLink + "\"";
				if (urlLink != "") result += " urlLink=\"" + urlLink + "\"";
				if (outputFeatures >= 2) {	// PRO stuff
					if (get_articlerun_fontchange() != "") {
						if (get_articlerun_fontFamily() != "") result += " fontFamily=\"" + safe_attr(get_articlerun_fontFamily()) + "\"";	// font
						if (get_articlerun_fontName() != "") result += " fontName=\"" + safe_attr(get_articlerun_fontName()) + "\"";	// fontName
						if (get_articlerun_fontNamePS() != "") result += " fontNamePS=\"" + safe_attr(get_articlerun_fontNamePS()) + "\"";	// fontNamePS
					}
					if (get_articlerun_paraStyleID() != "") result += " pstyID=\"" + safe_attr(get_articlerun_paraStyleID()) + "\"";
					if (get_articlerun_charStyleID() != "") result += " cstyID=\"" + safe_attr(get_articlerun_charStyleID()) + "\"";
					if (get_articlerun_fontsize() != "") result += " fontSize=\"" + get_articlerun_fontsize() + "\"";	// ptsz
					if (get_articlerun_fontColorID() != "") result += " fontColorID=\"" + get_articlerun_fontColorID() + "\"";	// flcl
					if (get_articlerun_fontColorFilt() != "") result += " fontColorFilt=\"" + get_articlerun_fontColorFilt() + "\"";	// filt
					if (get_articlerun_fontStyle() != "") result += " fontStyle=\"" + safe_attr(get_articlerun_fontStyle()) + "\"";	// ptfs
					if (get_articlerun_fontSkew() != "") result += " fontSkew=\"" +  get_articlerun_fontSkew() + "\"";	// pskw
					if (get_articlerun_undeline() != "") result += " underline=\"" + get_articlerun_undeline() + "\"";	// undr
					if (get_articlerun_capsMode() != "") result += " capsMode=\"" + get_articlerun_capsMode() + "\"";	// capm
					if (get_articlerun_charPos() != "") result += " charPos=\"" + get_articlerun_charPos() + "\"";	// posm
					if (get_articlerun_strike() != "") result += " strike=\"" + get_articlerun_strike() + "\"";	// strk
					if (get_articlerun_baselineShift() != "") result += " baseShift=\"" + get_articlerun_baselineShift() + "\"";
					if (get_articlerun_horizontalScale() != "") result += " scaleHoriz=\"" + get_articlerun_horizontalScale() + "\"";
					if (get_articlerun_verticalScale() != "") result += " scaleVert=\"" + get_articlerun_verticalScale() + "\"";
					if (get_articlerun_lineLeading() != "") result += " leading=\"" + get_articlerun_lineLeading() + "\"";
					if (get_articlerun_kerning() != "") result += " kerning=\"" + get_articlerun_kerning() + "\"";
					if (get_articlerun_nonBreaking() != "") result += " nobreak=\"" + get_articlerun_nonBreaking() + "\"";
					if (get_articlerun_ligatures() != "") result += " ligatures=\"" + get_articlerun_ligatures() + "\"";
					if (get_articlerun_tracking() != "") result += " tracking=\"" + get_articlerun_tracking() + "\"";
					if (get_articlerun_margTop() != "") result += " margtop=\"" + get_articlerun_margTop() + "\"";
					if (get_articlerun_margBott() != "") result += " margbott=\"" + get_articlerun_margBott() + "\"";
					if (get_articlerun_margLeft() != "") result += " margleft=\"" + get_articlerun_margLeft() + "\"";
					if (get_articlerun_margRight() != "") result += " margright=\"" + get_articlerun_margRight() + "\"";
					if (get_articlerun_firstLineIndent() != "") result += " firstLineIndent=\"" + get_articlerun_firstLineIndent() + "\"";
					if (get_articlerun_language() != "") result += " language=\"" + safe_attr(get_articlerun_language()) + "\"";
					if (get_articlerun_textcondition() != "") result += " conditionID=\"" + get_articlerun_textcondition() + "\"";
				}
			result += ">";
			//*********** output para sets and tabs in PRO version
			if (outputFeatures >= 2) {	// PRO stuff
				var my_sets = get_articlerun_parasetsXMLtag();
				var my_rules = get_articlerun_pararulesXMLtag();
				var my_tabs = get_articlerun_paratabsXMLtag();
				var my_list = get_articlerun_paralistXMLtag();
				if ( (my_sets != "") || (my_rules != "") || (my_tabs != "") || (my_list != "") ) {
					result += "<paraopts>";
						result += my_sets;
						result += my_rules;
						result += my_tabs;
						result += my_list;
					result += "</paraopts>";
				}
			}
		}
		// we are her for runtypes: 0 = chararcter run , 1 = start of para, 2 = end of para
		cstyle = get_articlerun_style(0);	// get character style overrides
		if (style.indexOf(cstyle) >= 0) cstyle = "";	// character attrs already in paragraph style contained
		if (DEBUG) java.lang.System.out.println ("     c-style:'" + cstyle + "', charclass:'" + charclass + "'");
		//result += "**charclass:" + charclass + "**";
		//result += "**cstyle:" + cstyle + "**";
		if ((charclass != "C_____NoStyle____") || (cstyle != "") || (outputFeatures == 2) || (wwwLink != "") || (urlLink != "")) {
			var txt = get_articlerun_text();
			if (txt != "") {	// do not output empty elements (no text)
				var spanAttribs = get_spanAttribs(charclass, cstyle, wwwLink, urlLink);
				if (spanAttribs != "") {
					result += "<span" + spanAttribs;
					if (fontsizeUnits > 0) {
						var fs = get_articlerun_fontsize();
						if ((fs == null) || (fs == "")) {
							var classid = get_articlerun_charStyleID();
							if ((classid != null) && (classid != "")) fs = get_style_fontsize(classid);
						}
						result += " data-fontsize=\"" + fs + "\"";
					}
					result += ">";
				}
				result += txt;
				if (spanAttribs != "") result += "</span>";
			}
			articlerun_text_remove();	// remove this run
		}
		else {
			result += get_articlerun_text();
			articlerun_text_remove();	// remove this run
		}
		if (runtype == 2) break;	//	end of paras

		// we are here to check if next run is a character run: check runtype of next run
		var nextruntype = get_articlerun_type();
		if (DEBUG) java.lang.System.out.println ("------- p nextruntype: " + nextruntype);
		if ((nextruntype == 0) || (nextruntype == 2)) {	// next is a character run
			result += output_charrun();
		}
	} while (false);

	//if ((runtype == 2) || (runtype == 3)) {	//	for end of paras
	if (paradiv_is_open == true) {	//	for end of paras
		if (pushedparentfontsize) pop_parentFontSize();
		result += "</div>\r";
		parentDIVstyle = "";
	}

	if (DEBUG) java.lang.System.out.println ("------- presult: " + result);
	return (result);
}

function output_charrun() {
	var result = "";
	var charclass = get_articlerun_charclass();
	var cstyle = get_articlerun_style(0);
	var wwwLink = clean_wwwLink(get_articlerun_wwwLink());
	var urlLink = clean_wwwLink(get_articlerun_urlLink());
	if (DEBUG) java.lang.System.out.println ("**** output_charrun(): style:'" + cstyle + "', charclass:'" + charclass + "'");
//result += "##charclass:" + charclass + "##";
//result += "##style:" + cstyle + "##";
	if ((charclass != "C_____NoStyle____") || (cstyle != "") || (outputFeatures == 2) || (wwwLink != "") || (urlLink != "")) {
		var txt = get_articlerun_text();
		if (txt != "") {	// do not output empty elements (no text)
			var spanAttribs = get_spanAttribs(charclass, cstyle, wwwLink, urlLink);
			if (spanAttribs != "") {
				result += "<span" + spanAttribs;
				if (fontsizeUnits > 0) {
					var fs = get_articlerun_fontsize();
					if ((fs == null) || (fs == "")) {
						var classid = get_articlerun_charStyleID();
						if ((classid != null) && (classid != "")) fs = get_style_fontsize(classid);
					}
					result += " data-fontsize=\"" + fs + "\"";
				}
				result += ">";
			}
			result += txt;
			if (spanAttribs != "") result += "</span>";
		}
		articlerun_text_remove();	// remove this run
	}
	else {
		result += get_articlerun_text();
		articlerun_text_remove();	// remove this run
	}

	var nextruntype = get_articlerun_type(); // check runtype of next run
		if (DEBUG) java.lang.System.out.println ("------- c nextruntype: " + nextruntype);
	if ((nextruntype == 0) || (nextruntype == 2)) result += output_charrun();	//next is an other character run, recall us

	if (DEBUG) java.lang.System.out.println ("------- cresult: '" + result + "'");
	return (result);
}

function get_spanAttribs(charclass, cstyle, wwwLink, urlLink) {
	var spanAttribs = "";
	if (get_articlerun_XMLElementSelf() != "") spanAttribs += " XMLElementSelf=\"" + get_articlerun_XMLElementSelf() + "\"";	// XMLElementSelf
	if (get_articlerun_XMLElementMarkupTag() != "") spanAttribs += " XMLElementMarkupTag=\"" + get_articlerun_XMLElementMarkupTag() + "\"";	// XMLElementMarkupTag
	if (get_articlerun_XMLElementXMLContent() != "") spanAttribs += " XMLElementXMLContent=\"" + get_articlerun_XMLElementXMLContent() + "\"";	// XMLElementXMLContent
	if (get_articlerun_XMLElementAttributes() != "") spanAttribs += " XMLElementAttributes=\"" + get_articlerun_XMLElementAttributes() + "\"";	// XMLElementAttributes
	if ((outputFeatures >= 2) && (addRuntypeInfo > 0)) {	// PRO stuff
		spanAttribs += " container=\"" + get_articlerun_containerElement() + "\"";
		spanAttribs += " runtype=\"" + get_articlerun_runtype() + "\"";
		if (get_articlerun_current_textrun() != "") spanAttribs += " run=\"" + get_articlerun_current_textrun() + "\"";
		if (get_articlerun_last_textrun() != "") spanAttribs += " lastrun=\"" + get_articlerun_last_textrun() + "\"";
		if (get_articlerun_render() != "") spanAttribs += " render=\"" + get_articlerun_render() + "\"";	// render typ like: inline | block
	}
	if ((charclass != "") && (charclass != "C_____NoStyle____")) spanAttribs += " class=\"" + charclass + "\"";
	if (cstyle != "") spanAttribs += " style=\"" + cstyle + "\"";
	if (wwwLink != "") spanAttribs += " wwwLink=\"" + wwwLink + "\"";
	if (urlLink != "") spanAttribs += " urlLink=\"" + urlLink + "\"";
	if (outputFeatures >= 2) {	// PRO stuff
		if (get_articlerun_fontchange() != "") {
			if (get_articlerun_fontFamily() != "") spanAttribs += " fontFamily=\"" + safe_attr(get_articlerun_fontFamily()) + "\"";	// font
			if (get_articlerun_fontName() != "") spanAttribs += " fontName=\"" + safe_attr(get_articlerun_fontName()) + "\"";	// fontName
			if (get_articlerun_fontNamePS() != "") spanAttribs += " fontNamePS=\"" + safe_attr(get_articlerun_fontNamePS()) + "\"";	// fontNamePS
		}
		if ((get_articlerun_charStyleID() != "") && (get_articlerun_charStyleID() != "n")) spanAttribs += " cstyID=\"" + safe_attr(get_articlerun_charStyleID()) + "\"";
		if (get_articlerun_fontsize() != "") spanAttribs += " fontSize=\"" + get_articlerun_fontsize() + "\"";	// ptsz
		if (get_articlerun_fontColorID() != "") spanAttribs += " fontColorID=\"" + safe_attr(get_articlerun_fontColorID()) + "\"";	// flcl
		if (get_articlerun_fontColorFilt() != "") spanAttribs += " fontColorFilt=\"" + get_articlerun_fontColorFilt() + "\"";	// filt
		if (get_articlerun_fontStyle() != "") spanAttribs += " fontStyle=\"" + safe_attr(get_articlerun_fontStyle()) + "\"";	// ptfs
		if (get_articlerun_fontSkew() != "") spanAttribs += " fontSkew=\"" +  get_articlerun_fontSkew() + "\"";	// pskw
		if (get_articlerun_undeline() != "") spanAttribs += " underline=\"" + get_articlerun_undeline() + "\"";	// undr
		if (get_articlerun_capsMode() != "") spanAttribs += " capsMode=\"" + get_articlerun_capsMode() + "\"";	// capm
		if (get_articlerun_charPos() != "") spanAttribs += " charPos=\"" + get_articlerun_charPos() + "\"";	// posm
		if (get_articlerun_strike() != "") spanAttribs += " strike=\"" + get_articlerun_strike() + "\"";	// strk
		if (get_articlerun_baselineShift() != "") spanAttribs += " baseShift=\"" + get_articlerun_baselineShift() + "\"";
		if (get_articlerun_horizontalScale() != "") spanAttribs += " scaleHoriz=\"" + get_articlerun_horizontalScale() + "\"";
		if (get_articlerun_verticalScale() != "") spanAttribs += " scaleVert=\"" + get_articlerun_verticalScale() + "\"";
		if (get_articlerun_lineLeading() != "") spanAttribs += " leading=\"" + get_articlerun_lineLeading() + "\"";
		if (get_articlerun_kerning() != "") spanAttribs += " kerning=\"" + get_articlerun_kerning() + "\"";
		if (get_articlerun_nonBreaking() != "") spanAttribs += " nobreak=\"" + get_articlerun_nonBreaking() + "\"";
		if (get_articlerun_ligatures() != "") spanAttribs += " ligatures=\"" + get_articlerun_ligatures() + "\"";
		if (get_articlerun_tracking() != "") spanAttribs += " tracking=\"" + get_articlerun_tracking() + "\"";
	}
	return(spanAttribs);
}

function reset_articleruns() {
	if (articleruns.length != 0) {
		java.lang.System.out.println ("###### ERROR: reset_articleruns(): " + articleruns.length + " unexported articleruns available!");
		return;
	}
	articleruns.length = 0;
	para_is_started = 0;
}
function store_textflowid(id) { textflowid = id; }
function get_textflowid() { return textflowid; }

function store_char_attrs(ptfs,pskw,undr,capm,posm,strk,fontchange,font,fontName,fontNamePS) {	// build a charcter attributes string
		// 		  ptfs, character attributes: Bold Italic...			BI or 1,2,3 for European Pi 1...2...3...
		// 		  undr, underline flag: true/false						U
		// 		  capm, character attributes: allcaps, smallcaps....	Cc
		// 		  posm, position: superscript, subscript
		// 		  strk, strike through
	var charattrstr = "";
	var font_skew = 0;
	if (pskw != "") font_skew = parseInt(pskw,10);

	if ((ptfs != "") || (font_skew > 8)) {
		var ptfsLC = ptfs.toLowerCase();
		if ( (ptfsLC.indexOf('demi') >= 0) || (ptfsLC.indexOf('bold') >= 0) || (ptfsLC.indexOf('black') >= 0) || (ptfsLC.indexOf('heavy') >= 0) ) charattrstr += "B";
		else charattrstr += "b";	// no bold
		if ((ptfsLC.indexOf('italic') >= 0) || (ptfsLC.indexOf('oblique') >= 0) // font skew more than 8 degrees: italic
			|| (font_skew > 8)) charattrstr += "I";
		else charattrstr += "i";	// no italic
		if ( ptfs.indexOf('1') >= 0 ) charattrstr += "1";
		if ( ptfs.indexOf('2') >= 0 ) charattrstr += "2";
		if ( ptfs.indexOf('3') >= 0 ) charattrstr += "3";
		if ( ptfs.indexOf('4') >= 0 ) charattrstr += "4";
		if ( ptfs.indexOf('5') >= 0 ) charattrstr += "5";
		if ( ptfs.indexOf('6') >= 0 ) charattrstr += "6";
		if ( ptfs.indexOf('7') >= 0 ) charattrstr += "7";
	}
	else {	// try to get 'bold' or 'italic' from font name
		do {
			if ((fontchange == null) || (fontchange =="")) break;	// font did not change
			if (font && font != "") {
				if ( (font.toLowerCase().indexOf('demi') >= 0) || (font.toLowerCase().indexOf('bold') >= 0) || (font.toLowerCase().indexOf('black') >= 0) || (font.toLowerCase().indexOf('heavy') >= 0) ) charattrstr += "B";
				else charattrstr += "b";
				break;
			}
			if (fontName && fontName != "") {
				if ( (fontName.toLowerCase().indexOf('demi') >= 0) || (fontName.toLowerCase().indexOf('bold') >= 0) || (fontName.toLowerCase().indexOf('black') >= 0) || (fontName.toLowerCase().indexOf('heavy') >= 0) ) charattrstr += "B";
				else charattrstr += "b";
				break;
			}
			if (fontNamePS && fontNamePS != "") {
				if ( (fontNamePS.toLowerCase().indexOf('demi') >= 0) || (fontNamePS.toLowerCase().indexOf('bold') >= 0) || (fontNamePS.toLowerCase().indexOf('black') >= 0) || (fontNamePS.toLowerCase().indexOf('heavy') >= 0) ) charattrstr += "B";
				else charattrstr += "b";
				break;
			}
		} while(false);
		do {
			if ((fontchange == null) || (fontchange =="")) break;	// font did not change
			if (font && font != "") {
				if ( (font.toLowerCase().indexOf('italic') >= 0) || (font.toLowerCase().indexOf('oblique') >= 0) ) charattrstr += "I";
				else charattrstr += "i";
				break;
			}
			if (fontName && fontName != "") {
				if ( (fontName.toLowerCase().indexOf('italic') >= 0) || (fontName.toLowerCase().indexOf('oblique') >= 0) ) charattrstr += "I";
				else charattrstr += "i";
				break;
			}
			if (fontNamePS && fontNamePS != "") {
				if ( (fontNamePS.toLowerCase().indexOf('italic') >= 0) || (fontNamePS.toLowerCase().indexOf('oblique') >= 0) ) charattrstr += "I";
				else charattrstr += "i";
				break;
			}
		} while(false);
	}

	if (undr.indexOf('t') >= 0) charattrstr += "U";
	if (strk.indexOf('t') >= 0) charattrstr += "T";

	if (capm.toLowerCase().indexOf('smallcaps') >= 0) charattrstr += "c";	// SmallCaps or CapToSmallCap
	else {
		if (capm.toLowerCase().indexOf('allcaps') >= 0) charattrstr += "C";	// caps mode; AllCaps
	}
	if (capm.toLowerCase().indexOf('normal') >= 0) charattrstr += "0";	// no caps

	if ((posm.toLowerCase().indexOf('superscript') >= 0) || (posm.toLowerCase().indexOf('numerat') >= 0)) charattrstr += "S";	// Superscript or OTSuperscript or OTNumerator
	if ((posm.toLowerCase().indexOf('subscript') >= 0) || (posm.toLowerCase().indexOf('denominat') >= 0)) charattrstr += "s";	// Subscript or OTSubscript or OTDenominator
	if (posm.toLowerCase().indexOf('normal') >= 0) charattrstr += "1";	// no suX script

	return charattrstr;
}



var boxchain_idx = 0;
function store_boxchain_idx(previousIdx) {
	if ( previousIdx != null ) {
		if ( previousIdx == "n" ) boxchain_idx = 0;
		else boxchain_idx++;
	}
	return boxchain_idx;
}
function get_boxchain_type(boxchain_idx) {	// 1= first box in chain or unchained, 2= chained box
	if ( (boxchain_idx == "-1") || (boxchain_idx == "0") || (boxchain_idx == "") || (boxchain_idx == null) ) return 1;
	return 2;
}


// ********** Style sheets stuff
var CSSclassNamesNoUnderscore = 0;
function store_CSSclassNamesNoUnderscore(val) {
	CSSclassNamesNoUnderscore = parseInt(val,10);
}
var CSSclassNamesASCII = 1;	// 1 for normal, 1 = css class names are converted to plain ASCII (URL-encode)
function store_CSSclassNamesASCII(val) {
	try { CSSclassNamesASCII = parseInt(val,10); } catch(e) {}
}

var stylesheet = new Object();
	stylesheet.comment = "";
	stylesheet.styleType = "";
	stylesheet.styleID = "";
	stylesheet.styleName = "";
	stylesheet.styleBasedOn = "";
	stylesheet.bulletChar = "";
	stylesheet.textAlign = "";
	stylesheet.fontFamily = "";
	stylesheet.fontName = "";
	stylesheet.fontNamePS = "";
	stylesheet.fontSize = "";
	stylesheet.fontColor = "";
	stylesheet.fontColorFilter = "";
	stylesheet.fontWeight = "";
	stylesheet.fontStyle = "";
	stylesheet.textTransform = "";
	stylesheet.textLanguage = "";
	stylesheet.cattrUnderline = "";
	stylesheet.cattrStrikethrough = "";
	stylesheet.cattrPositionmode = "";
	stylesheet.indentLeft = "";
	stylesheet.indentRight = "";
	stylesheet.indentFirstLine = "";
	stylesheet.spaceBefore = "";
	stylesheet.spaceAfter = "";
	stylesheet.styleAttributesString = "";	// full attributes given directly
	stylesheet.fullAttributes = null;
function init_styles() {
	stylesheet.comment = "";
	stylesheet.styleType = "";
	stylesheet.styleID = "";
	stylesheet.styleName = "";
	stylesheet.styleBasedOn = "";
	stylesheet.bulletChar = "";
	stylesheet.textAlign = "";
	stylesheet.fontFamily = "";
	stylesheet.fontName = "";
	stylesheet.fontNamePS = "";
	stylesheet.fontSize = "";
	stylesheet.fontColor = "";
	stylesheet.fontColorFilter = "";
	stylesheet.fontWeight = "";
	stylesheet.fontStyle = "";
	stylesheet.textTransform = "";
	stylesheet.textLanguage = "";
	stylesheet.cattrUnderline = "";
	stylesheet.cattrStrikethrough = "";
	stylesheet.cattrPositionmode = "";
	stylesheet.indentLeft = "";
	stylesheet.indentRight = "";
	stylesheet.indentFirstLine = "";
	stylesheet.spaceBefore = "";
	stylesheet.spaceAfter = "";
	stylesheet.lineLeading = "";
	stylesheet.styleAttributesString = "";
	stylesheet.fullAttributes = null;
}

function store_styleComment(text) { stylesheet.comment = text; }
function store_styleType(type) { stylesheet.styleType = type; }
function get_styleType() {
	return stylesheet.styleType;
}
function store_styleID(id) { stylesheet.styleID = id; }
function get_styleID() {
	return stylesheet.styleID;
}
function plain_Name(name) {	// style name can be like "$ID/[No character style]". we want to remove the "$ID/"
	if ((name == null) || (name == "")) return("");
	var pos = name.indexOf("$ID/");
	if (pos < 0) return(name);
	return(name.substr(pos+4));
}
function store_styleName(name) { stylesheet.styleName = name; }
function get_styleName() {
	return stylesheet.styleName;
}
function store_styleBasedOn(name) { stylesheet.styleBasedOn = name; }
function get_styleBasedOn() {
	return stylesheet.styleBasedOn;
}
function store_bulletChar(bchar) {
	if (bchar == "") stylesheet.bulletChar = lpad(d2h(8226),"0",6);	// bullet
	else stylesheet.bulletChar = lpad(d2h(bchar),"0",6);
}
function get_bulletChar() {
	return stylesheet.bulletChar;
}

function store_textAlign(tA) {
	//Justification_EnumValue = "LeftAlign" | "CenterAlign" | "RightAlign" | "LeftJustified" | "RightJustified" | "CenterJustified" | "FullyJustified" | "ToBindingSide" | "AwayFromBindingSide"

	switch (tA) {
		case 'LeftAlign': stylesheet.textAlign = 'left'; break;
		case 'ToBindingSide': stylesheet.textAlign = 'left'; break;
		case 'AwayFromBindingSide': stylesheet.textAlign = 'left'; break;
		case 'RightAlign': stylesheet.textAlign = 'right'; break;
		case 'CenterAlign': stylesheet.textAlign = 'center'; break;
		default: stylesheet.textAlign = 'justify'; break;
	}
}
function get_textAlign() {
	return stylesheet.textAlign;
}
function store_fontFamily(fF) {
	var fam = fF;
	if (fam.indexOf("(") > 0) {
		if (MAKE_INTERNET_AWARE_FONTNAMES == true) {
			fam = fam.substr(0,fam.indexOf("("));	// remove part bejond '(' like in "Helvetica Neue (T1)"
			// and remove trailing spaces
			while (fam.charAt(fam.length-1) == " ") { fam = fam.substr(0,fam.length-1); }
			stylesheet.fontFamily = fam;
		}
		else stylesheet.fontFamily = fF;
	}
	else stylesheet.fontFamily = fF;
}
function store_fontName(fn) {
	stylesheet.fontName = plain_Name(fn);
}
function store_fontNamePS(fn) {
	stylesheet.fontNamePS = plain_Name(fn);
}
function get_fontFamily() {
	get_fontFamilyReplace(stylesheet.fontFamily);
}
function store_fontSize(fS) { stylesheet.fontSize = fS; }
function get_fontSize() {
	if (stylesheet.fontSize == "") return "";
	return parseFloat(stylesheet.fontSize * fontsizeFactor);
}
function store_fontColor(fC,fF) { stylesheet.fontColor = fC; stylesheet.fontColorFilter = fF; }
function get_fontColor() { return stylesheet.fontColor; }
function get_fontColorFilter() { return stylesheet.fontColorFilter; }
function store_fontWeight(fW) { stylesheet.fontWeight = fW; }
function get_fontWeight() { return stylesheet.fontWeight; }
function store_fontStyle(fS) { stylesheet.fontStyle = fS; }
function get_fontStyle() { return stylesheet.fontStyle; }

function store_fullAttribute(aName,aValue) { 	// associative array for all style attributes
	if (stylesheet.fullAttributes == null) {
		//java.lang.System.out.println ("***********************************");
		stylesheet.fullAttributes = new Array();
	}
	stylesheet.fullAttributes[aName] = aValue;
	//java.lang.System.out.println (aName + ":" +stylesheet.fullAttributes[aName]);
}

function store_textTransform(tT) {
	//Capitalization_EnumValue = "Normal" | "SmallCaps" | "AllCaps" | "CapToSmallCap"

	switch (tT) {
		case 'AllCaps': stylesheet.textTransform = 'uppercase'; break;
		case 'SmallCaps': stylesheet.textTransform = 'small-caps'; break;	// small-caps
		case 'CapToSmallCap': stylesheet.textTransform = 'small-caps'; break;	// small-caps
		case 'Normal': stylesheet.textTransform = 'none'; break;
		default: stylesheet.textTransform = 'none'; break;
	}
}

// language strings like:
// "French", "French: Canadian", "English: UK", "de~sep~DE~sep~2006"
function store_textLanguage(lang) {
	stylesheet.textLanguage = lang;
}
function get_textLanguage() { return stylesheet.textLanguage; }

function store_characterAttributes(underline, position, strikethru) {
	if (underline != "") stylesheet.cattrUnderline = underline;
	if (position != "") stylesheet.cattrPositionmode = position;
	if (strikethru != "") stylesheet.cattrStrikethrough = strikethru;
}
function get_textTransform() { return stylesheet.textTransform; }
function store_indentLeft(indent) {
	stylesheet.indentLeft = indent;
	return;
}
function store_indentRight(indent) {
	stylesheet.indentRight = indent;
	return;
}
function store_indentFirstLine(indent) {
	stylesheet.indentFirstLine = indent;
	return;
}
function store_spaceBefore(sp) {
	if (sp == "") stylesheet.spaceBefore = "0.0";
	else stylesheet.spaceBefore = sp;
	return;
}
function store_spaceAfter(sp) {
	if (sp == "") stylesheet.spaceAfter = "0.0";
	else stylesheet.spaceAfter = sp;
	return;
}
function store_lineLeading(ll) {
	if ( (ll == "") || isNaN(ll) ) stylesheet.lineLeading = "";	// empty is auto
	else stylesheet.lineLeading = ll;
	return;
}
function store_styleAttributesString(str) { stylesheet.styleAttributesString = str; }


/* 
 tables stuff
 */
var in_table_element = 0;
var in_cell_element = 0;
function init_processing_table() {
	in_table_element = 0;
	in_cell_element = 0;
}
function processing_table() {
	in_table_element++;
}
function end_processing_table() {
	in_table_element--;
}
function now_processing_table() {
	return(in_table_element);
}
function processing_tablecell() {
	in_cell_element++;
}
function end_processing_tablecell() {
	in_cell_element--;
}
function now_processing_tablecell() {
	return(in_cell_element);
}
/* 
 CSS styles for tables
 */
var css_tablestyles_arr = new Array();
var css_tablestyles_idx = 0;		// point to first element
function css_tablestyles_arr_add(Self,pnam,basd,RwCt,colc,LBsw,LBsc,RBsw,RBsc,TBsw,TBsc,BBsw,BBsc,LBst,RBst,TBst,BBst,TBframestyle,TBframestylehtml,LBframestyle,LBframestylehtml,BBframestyle,BBframestylehtml,RBframestyle,RBframestylehtml,RFcf,RFtf,RFcs,RFts,Sffr,Slfr,HRCt,FRCt,RFfc,RFsc,fontColor) {
	if (Self == null || Self == "") return(-1);
	if (pnam == null || pnam == "") return(-2);
	css_tablestyles_arr[css_tablestyles_idx] = new Array();

	css_tablestyles_arr[css_tablestyles_idx][0] = create_tablestyle_classname_from_styleName(pnam);		// class name built from style name
	css_tablestyles_arr[css_tablestyles_idx][1] = Self;		// ID
	css_tablestyles_arr[css_tablestyles_idx][2] = pnam;		// style name
	css_tablestyles_arr[css_tablestyles_idx][3] = basd;		// based on style name
	if ((RwCt != null) && (RwCt != "")) css_tablestyles_arr[css_tablestyles_idx][4] = RwCt;		// Row Count (as dec)
	else css_tablestyles_arr[css_tablestyles_idx][4] = 0;
	if ((colc != null) && (colc != "")) css_tablestyles_arr[css_tablestyles_idx][5] = colc;		// column count (as dec)
	else css_tablestyles_arr[css_tablestyles_idx][5] = 0;
	if (pnam == "[No table style]") css_tablestyles_arr[css_tablestyles_idx][6] = "0";		// Left Border stroke width
	else css_tablestyles_arr[css_tablestyles_idx][6] = LBsw;								// Left Border stroke width
	css_tablestyles_arr[css_tablestyles_idx][7] = LBsc;		// 					color ID
	if (pnam == "[No table style]") css_tablestyles_arr[css_tablestyles_idx][8] = "0";		// Right Border stroke width
	else css_tablestyles_arr[css_tablestyles_idx][8] = RBsw;								// Right Border stroke width
	css_tablestyles_arr[css_tablestyles_idx][9] = RBsc;		// 					color ID
	if (pnam == "[No table style]") css_tablestyles_arr[css_tablestyles_idx][10] = "0";		// Top Border stroke width
	else css_tablestyles_arr[css_tablestyles_idx][10] = TBsw;								// Top Border stroke width
	css_tablestyles_arr[css_tablestyles_idx][11] = TBsc;	// 					color ID
	if (pnam == "[No table style]") css_tablestyles_arr[css_tablestyles_idx][12] = "0";		// Bottom Border stroke width
	else css_tablestyles_arr[css_tablestyles_idx][12] = BBsw;								// Bottom Border stroke width
	css_tablestyles_arr[css_tablestyles_idx][13] = BBsc;	// 					color ID

	css_tablestyles_arr[css_tablestyles_idx][14] = LBst;	// Left Border stroke tint
	css_tablestyles_arr[css_tablestyles_idx][15] = RBst;	// Right Border stroke tint
	css_tablestyles_arr[css_tablestyles_idx][16] = TBst;	// Top Border stroke tint
	css_tablestyles_arr[css_tablestyles_idx][17] = BBst;	// Bottom Border stroke tint
	css_tablestyles_arr[css_tablestyles_idx][18] = TBframestyle;		// original ind stroke style name from element StrokeStyle/@Name>
	css_tablestyles_arr[css_tablestyles_idx][19] = TBframestylehtml;	//stroke name possible in html
	css_tablestyles_arr[css_tablestyles_idx][20] = RFcf;	// Row Fill color first row (ID)
	css_tablestyles_arr[css_tablestyles_idx][21] = RFtf;	// Row Fill tint first row (ID)
	css_tablestyles_arr[css_tablestyles_idx][22] = RFcs;	// Row Fill color second row (ID)
	css_tablestyles_arr[css_tablestyles_idx][23] = RFts;	// Row Fill tint second row (ID)
	css_tablestyles_arr[css_tablestyles_idx][24] = get_rgb_color(RFcf,RFtf);						// Row Fill color first row (HTML color number)
	css_tablestyles_arr[css_tablestyles_idx][25] = get_rgb_color(RFcs,RFts);						// Row Fill color second row (HTML color number)
	if ((Sffr != null) && (Sffr != "")) css_tablestyles_arr[css_tablestyles_idx][26] = Sffr;			// Skip first fill row count (as dec)
	else css_tablestyles_arr[css_tablestyles_idx][26] = 0;
	if ((Slfr != null) && (Slfr != "")) css_tablestyles_arr[css_tablestyles_idx][27] = Slfr;			// Skip last fill row count (as dec)
	else css_tablestyles_arr[css_tablestyles_idx][27] = 0;
	if ((HRCt != null) && (HRCt != "")) css_tablestyles_arr[css_tablestyles_idx][28] = HRCt;	// Header Row Count (as dec)
	else css_tablestyles_arr[css_tablestyles_idx][28] = 0;
	if ((FRCt != null) && (FRCt != "")) css_tablestyles_arr[css_tablestyles_idx][29] = FRCt;	// Footer Row count (as dec)
	else css_tablestyles_arr[css_tablestyles_idx][29] = 0;
	if ((RFfc != null) && (RFfc != "")) css_tablestyles_arr[css_tablestyles_idx][30] = RFfc;	// Row Fill first count (as dec)
	else css_tablestyles_arr[css_tablestyles_idx][30] = 0;
	if ((RFsc != null) && (RFsc != "")) css_tablestyles_arr[css_tablestyles_idx][31] = RFsc;	// Row Fill second count (as dec)
	else css_tablestyles_arr[css_tablestyles_idx][31] = 0;

																// stroke widths for the table cells
	css_tablestyles_arr[css_tablestyles_idx][32] = LBsw;			// Left Border stroke width
	css_tablestyles_arr[css_tablestyles_idx][33] = RBsw;			// Right Border stroke width
	css_tablestyles_arr[css_tablestyles_idx][34] = TBsw;			// Top Border stroke width
	css_tablestyles_arr[css_tablestyles_idx][35] = BBsw;			// Bottom Border stroke width

	css_tablestyles_arr[css_tablestyles_idx][36] = fontColor;		// font color
		if (css_tablestyles_arr[css_tablestyles_idx][36] == "") css_tablestyles_arr[css_tablestyles_idx][36] = "000000";		// font color blck

	css_tablestyles_idx++;	// point to next empty element
	return(0);
}
// merge table styles which are based on a style
function css_tablestyles_merge_basedon() {
	for (var i = 0; i < css_tablestyles_arr.length; i++) {
		if (css_tablestyles_arr[i][3] == "") continue;	// basd attribute is not set
		if (css_tablestyles_arr[i][3].indexOf("[No table style]") >= 0) continue;	// basd on No Table Style, do not merge

		var j = 0;
		for (j = 0; j < css_tablestyles_arr.length; j++) {
			if (css_tablestyles_arr[j][2] == css_tablestyles_arr[i][3]) break;	// pnam == basd? = based on style found
		}
		if (j >= css_tablestyles_arr.length) continue;	// based on style not found
		for (var k = 4; k < css_tablestyles_arr[i].length; k++) {
			if (css_tablestyles_arr[i][k] == "") css_tablestyles_arr[i][k] = css_tablestyles_arr[j][k];
			/*
			switch (k) {
				case 6:  if (css_tablestyles_arr[i][k] == "") css_tablestyles_arr[i][k] = css_tablestyles_arr[j][32];
					break;
				case 8:  if (css_tablestyles_arr[i][k] == "") css_tablestyles_arr[i][k] = css_tablestyles_arr[j][33];
					break;
				case 10:  if (css_tablestyles_arr[i][k] == "") css_tablestyles_arr[i][k] = css_tablestyles_arr[j][34];
					break;
				case 12:  if (css_tablestyles_arr[i][k] == "") css_tablestyles_arr[i][k] = css_tablestyles_arr[j][35];
					break;
				default: if (css_tablestyles_arr[i][k] == "") css_tablestyles_arr[i][k] = css_tablestyles_arr[j][k];
					break;
			}
			*/
		}
	}
	return;
}
function create_tablestyle_classname_from_styleName(styleName) {
	if (styleName == "") return "";
	var class_name = "T_" + styleName;
	class_name = clean_classname(class_name);
	return class_name;
}
function get_tablestyle_classname_from_styleID(styleID) {
	var i = 0;
	var class_name = "";
	for (i = 0; i < css_tablestyles_arr.length; i++) {
		if (css_tablestyles_arr[i][1] == styleID) {
			return (css_tablestyles_arr[i][0]);
		}
	}
	return "";
}
function get_tablestyle_classname_from_styleName(styleName) {
	var i = 0;
	var class_name = "";
	for (i = 0; i < css_tablestyles_arr.length; i++) {
		if (css_tablestyles_arr[i][2] == styleName) {
			return (css_tablestyles_arr[i][0]);
		}
	}
	return "";
}
function get_tablestyle_from_styleID(styleID) {
	var i = 0;
	for (i = 0; i < css_tablestyles_arr.length; i++) {
		if (css_tablestyles_arr[i][1] == styleID) {
			return (css_tablestyles_arr[i]);
		}
	}
	return null;
}
function get_tablestyleID_from_styleName(styleName) {
	if ((styleName == null) || (styleName == "")) return(null);
	var i = 0;
	for (i = 0; i < css_tablestyles_arr.length; i++) {
		if (css_tablestyles_arr[i][2] == styleName) {
			return (css_tablestyles_arr[i][1]);
		}
	}
	return null;
}
// create a style string to override class
function css_tablestyle_create(anyatrr,LBss,LBsw,LBsc,LBst,RBss,RBsw,RBsc,RBst,TBss,TBsw,TBsc,TBst,BBss,BBsw,BBsc,BBst) {
	var style = "";
	var color = "";
	if (anyatrr != "") style += anyatrr + " ";

	var LBstrokeWidth = LBsw;
	var LBstrokeStyle = LBss;
	var LBstrokeColor = LBsc;
	var LBstrokeTint = LBst;
	if ((LBstrokeWidth == "") && ((LBstrokeColor != "") || (LBstrokeTint != ""))) {	// if have color or tint then we have a line
		LBstrokeWidth == "1";
	}

	var TBstrokeWidth = TBsw;
	var TBstrokeStyle = TBss;
	var TBstrokeColor = TBsc;
	var TBstrokeTint = TBst;
	if ((TBstrokeWidth == "") && ((TBstrokeColor != "") || (TBstrokeTint != ""))) {
		TBstrokeWidth == "1";
	}

	var RBstrokeWidth = RBsw;
	var RBstrokeStyle = RBss;
	var RBstrokeColor = RBsc;
	var RBstrokeTint = RBst;
	if ((RBstrokeWidth == "") && ((RBstrokeColor != "") || (RBstrokeTint != ""))) {
		RBstrokeWidth == "1";
	}

	var BBstrokeWidth = BBsw;
	var BBstrokeStyle = BBss;
	var BBstrokeColor = BBsc;
	var BBstrokeTint = BBst;
	if ((BBstrokeWidth == "") && ((BBstrokeColor != "") || (BBstrokeTint != ""))) {
		BBstrokeWidth == "1";
	}

	if (LBstrokeWidth != "") {
		style += "border-left-style:" + get_html_strokename(LBstrokeStyle) + "; ";
		style += "border-left-width:" + Math.ceil(LBstrokeWidth) + "px; ";
		color = get_rgb_color(LBstrokeColor,LBstrokeTint);
		if ((color == "") || (color == "transparent")) style += "border-left-color:transparent; ";
		else style += "border-left-color:#" + color + "; ";
	}
	if (TBstrokeWidth != "") {
		style += "border-top-style:" + get_html_strokename(TBstrokeStyle) + "; ";
		style += "border-top-width:" + Math.ceil(TBstrokeWidth) + "px; ";
		color = get_rgb_color(TBstrokeColor,TBstrokeTint);
		if ((color == "") || (color == "transparent")) style += "border-top-color:transparent; ";
		else style += "border-top-color:#" + color + "; ";
	}
	if (RBstrokeWidth != "") {
		style += "border-right-style:" + get_html_strokename(RBstrokeStyle) + "; ";
		style += "border-right-width:" + Math.ceil(RBstrokeWidth) + "px; ";
		color = get_rgb_color(RBstrokeColor,RBstrokeTint);
		if ((color == "") || (color == "transparent")) style += "border-right-color:transparent; ";
		else style += "border-right-color:#" + color + "; ";
	}
	if (BBstrokeWidth != "") {
		style += "border-bottom-style:" + get_html_strokename(BBstrokeStyle) + "; ";
		style += "border-bottom-width:" + Math.ceil(BBstrokeWidth) + "px; ";
		color = get_rgb_color(BBstrokeColor,BBstrokeTint);
		if ((color == "") || (color == "transparent")) style += "border-bottom-color:transparent; ";
		else style += "border-bottom-color:#" + color + "; ";
	}

	return(style);
}

// get alternating row color of table rows
var num_rows_with_first_color = 0;
var num_rows_with_second_color = 0;
var last_row_was_first_color = false;
var last_row_was_second_color = false;
var current_row_colorID = "";	// the currently processed row's background color ID
var current_row_colorTint = "100";	// .... and it's tint

function get_current_row_colorID() {
	return(current_row_colorID);
}
function get_current_row_colorTint() {
	return(current_row_colorTint);
}
function reset_table_row_colors () {
	num_rows_with_first_color = 0;
	num_rows_with_second_color = 0;
	last_row_was_first_color = false;
	last_row_was_second_color = false;
}
function get_table_row_color(rownumber,			// from ctbl/@pnam
							totalrows,			// from ctbl/@RwCt
							numheaderrows,		// from ctbl/@HRCt
							numfooterrows,		// from ctbl/@FRCt
							first_colorID,		// from ctbl/@RFcf
							first_colorTint,	// from ctbl/@RFtf
							second_colorID,		// from ctbl/@RFcs
							second_colorTint,	// from ctbl/@RFts
							skip_firstfillrow,	// from ctbl/@Sffr, how many rows to skip at top until color fill
							skip_lastfillrow,	// from ctbl/@Slfr, how many rows to skip at bottom for color fill
							rowfill_first_count,	// from ctbl/@RFfc, how many rows with first color
							rowfill_second_count,	// from ctbl/@RFsc, how many rows with second color
							tableStyleID		// from ctbl/@ptzz points to tsty
							) {
	current_row_colorID = "";
	current_row_colorTint = "100";
	if ((rownumber == null) || (rownumber < 0)) return ("");
	// prepare table style
	var my_tableStyleID = tableStyleID;
	if ((my_tableStyleID == null) || (my_tableStyleID == "")) {	// may be in CS2 there is no table style
		my_tableStyleID = get_tablestyleID_from_styleName("[No table style]");
	}
	var style_arr = null;
	if ((my_tableStyleID != null) && (my_tableStyleID != "")) style_arr = get_tablestyle_from_styleID(my_tableStyleID);

	// get row fill skip
	var my_skip_firstfillrow = skip_firstfillrow;
	if ((my_skip_firstfillrow == null) || (my_skip_firstfillrow == "")) {
		if (style_arr != null) my_skip_firstfillrow = style_arr[26];
		if ((my_skip_firstfillrow == null) || (my_skip_firstfillrow == "")) my_skip_firstfillrow = 0;
	}
	else my_skip_firstfillrow = parseInt(my_skip_firstfillrow,10);
	var my_skip_lastfillrow = skip_lastfillrow;
	if ((my_skip_lastfillrow == null) || (my_skip_lastfillrow == "")) {
		if (style_arr != null) my_skip_lastfillrow = style_arr[27];
		if ((my_skip_lastfillrow == null) || (my_skip_lastfillrow == "")) my_skip_lastfillrow = 0;
	}
	else my_skip_lastfillrow = parseInt(my_skip_lastfillrow,10);

	if ((rownumber - numheaderrows - my_skip_firstfillrow) < 0) return ("");				// this is a header row or to be skipped
	if (rownumber >= (totalrows + numheaderrows - my_skip_lastfillrow)) return ("");	// this is a footer row or to be skipped

	// get row count of same color
	var my_rowfill_first_count = rowfill_first_count;
	if ((my_rowfill_first_count == null) || (my_rowfill_first_count == "")) {
		if (style_arr != null) my_rowfill_first_count = style_arr[30];
		if ((my_rowfill_first_count == null) || (my_rowfill_first_count == "")) my_rowfill_first_count = 1;
	}
	else my_rowfill_first_count = my_rowfill_first_count;
	var my_rowfill_second_count = rowfill_second_count;
	if ((my_rowfill_second_count == null) || (my_rowfill_second_count == "")) {
		if (style_arr != null) my_rowfill_second_count = style_arr[31];
		if ((my_rowfill_second_count == null) || (my_rowfill_second_count == "")) my_rowfill_second_count = 1;
	}
	else my_rowfill_second_count = my_rowfill_second_count;

	// is colorable table row: determin if it is odd or even to fill with first or second color
	do {
		if (last_row_was_first_color) {
			if (num_rows_with_first_color < my_rowfill_first_count) use_row_color = 0;
			else use_row_color = 1;
			break;
		}
		if (last_row_was_second_color) {
			if (num_rows_with_second_color < my_rowfill_second_count) use_row_color = 1;
			else use_row_color = 0;
			break;
		}
		use_row_color = 0;	// never set a color: use first
	} while(false);

	switch (use_row_color) {
		case 0: {	// first alternatig row
			num_rows_with_second_color = 0; last_row_was_second_color = false;	//reset other color counter
			num_rows_with_first_color++;
			last_row_was_first_color = true;
			var my_first_colorID = first_colorID;	// get color ID from table tag ctbl
			if ((my_first_colorID == null) || (my_first_colorID == "")) {	// try to get from style
				if (style_arr != null) my_first_colorID = style_arr[20];
			}
			var my_first_colorTint = first_colorTint;	// get color Tint from table tag
			if ((my_first_colorTint == null) || (my_first_colorTint == "")) {	// try to get from style
				if (style_arr != null) my_first_colorTint = style_arr[21];
			}
			current_row_colorTint = my_first_colorTint;
			if (my_first_colorID != "") {
				current_row_colorID = my_first_colorID;
				var color = get_rgb_color(my_first_colorID,my_first_colorTint);
				return( (((color != "transparent") && (color != "")) ? "#" : "") + color);
			}
			// try to get from table style
			if (style_arr == null) return ("");
			var color = style_arr[24];
			return( (((color != "transparent") && (color != "")) ? "#" : "") + color);	// Row Fill color first row (HTML color number)
		}
		case 1: {	// second_colorID
			num_rows_with_first_color = 0; last_row_was_first_color = false;	//reset other color counter
			num_rows_with_second_color++;
			last_row_was_second_color = true;
			var my_second_colorID = second_colorID;	// get color ID from table tag
			if ((my_second_colorID == null) || (my_second_colorID == "")) {	// try to get from style
				if (style_arr != null) my_second_colorID = style_arr[22];
			}
			var my_second_colorTint = second_colorTint;	// get color Tint from table tag ctbl
			if ((my_second_colorTint == null) || (my_second_colorTint == "")) {	// try to get from style
				if (style_arr != null) my_second_colorTint = style_arr[23];
			}
			current_row_colorTint = my_second_colorTint;
			if (my_second_colorID != "") {
				current_row_colorID = my_second_colorID;
				var color = get_rgb_color(my_second_colorID,my_second_colorTint);
				return( (((color != "transparent") && (color != "")) ? "#" : "") + color);
			}
			// try to get from table style
			if (style_arr == null) return ("");
			var color = style_arr[25];
			return( (((color != "transparent") && (color != "")) ? "#" : "") + color);	// Row Fill color second row (HTML color number)
		}
	}
	return ("");
}

function get_html_strokename(styleNameINDD) {
	/* InDesign style names are:
	<StrokeStyle Self="StrokeStyle/$ID/Triple_Stroke" Name="$ID/Triple_Stroke"/>
	<StrokeStyle Self="StrokeStyle/$ID/ThickThinThick" Name="$ID/ThickThinThick"/>
	<StrokeStyle Self="StrokeStyle/$ID/ThinThickThin" Name="$ID/ThinThickThin"/>
	<StrokeStyle Self="StrokeStyle/$ID/ThickThick" Name="$ID/ThickThick"/>
	<StrokeStyle Self="StrokeStyle/$ID/ThickThin" Name="$ID/ThickThin"/>
	<StrokeStyle Self="StrokeStyle/$ID/ThinThick" Name="$ID/ThinThick"/>
	<StrokeStyle Self="StrokeStyle/$ID/ThinThin" Name="$ID/ThinThin"/>
	<StrokeStyle Self="StrokeStyle/$ID/Japanese Dots" Name="$ID/Japanese Dots"/>
	<StrokeStyle Self="StrokeStyle/$ID/White Diamond" Name="$ID/White Diamond"/>
	<StrokeStyle Self="StrokeStyle/$ID/Left Slant Hash" Name="$ID/Left Slant Hash"/>
	<StrokeStyle Self="StrokeStyle/$ID/Right Slant Hash" Name="$ID/Right Slant Hash"/>
	<StrokeStyle Self="StrokeStyle/$ID/Straight Hash" Name="$ID/Straight Hash"/>
	<StrokeStyle Self="StrokeStyle/$ID/Wavy" Name="$ID/Wavy"/>
	<StrokeStyle Self="StrokeStyle/$ID/Canned Dotted" Name="$ID/Canned Dotted"/>
	<StrokeStyle Self="StrokeStyle/$ID/Canned Dashed 3x2" Name="$ID/Canned Dashed 3x2"/>
	<StrokeStyle Self="StrokeStyle/$ID/Canned Dashed 4x4" Name="$ID/Canned Dashed 4x4"/>
	<StrokeStyle Self="StrokeStyle/$ID/Dashed" Name="$ID/Dashed"/>
	<StrokeStyle Self="StrokeStyle/$ID/Solid" Name="$ID/Solid"/>
	*/
	if ((styleNameINDD == null) || (styleNameINDD == "")) return("solid");
	if (styleNameINDD == 'n') return("none");
	var inddStylename = styleNameINDD.toLowerCase();
	if (inddStylename.indexOf("solid") >= 0) return("solid");
	if (inddStylename.indexOf("thin") >= 0) return("double");
	if (inddStylename.indexOf("thick") >= 0) return("double");
	if (inddStylename.indexOf("dot") >= 0) return("dotted");
	if (inddStylename.indexOf("dash") >= 0) return("dashed");
	if (inddStylename.indexOf("trip") >= 0) return("double");
	return("solid");
	//return("unknown:"+ inddStylename);
}


/* 
 CSS styles for table cells
 */
var css_cellstyles_arr = new Array();
var css_cellstyles_idx = 0;		// point to first element
function css_cellstyles_arr_add(Self,Name,BasedOn,AppliedParagraphStyle,TopInset,LeftInset,BottomInset,RightInset,VerticalJustification,ParagraphSpacingLimit,
									ClipContentToCell,FirstBaselineOffset,MinimumFirstBaselineOffset,RotationAngle,
									FillColor,FillTint,FillColorRGB,
									LeftEdgeStrokeWeight,LeftEdgeStrokeType,LeftEdgeStrokeColor,LeftEdgeStrokeTint,LeftEdgeStrokeGapColor,LeftEdgeStrokeGapTint,LeftEdgeStrokeColorHTML,LeftEdgeStrokeGapColorHTML,
									TopEdgeStrokeWeight,TopEdgeStrokeType,TopEdgeStrokeColor,TopEdgeStrokeTint,TopEdgeStrokeGapColor,TopEdgeStrokeGapTint,TopEdgeStrokeColorHTML,TopEdgeStrokeGapColorHTML,
									RightEdgeStrokeWeight,RightEdgeStrokeType,RightEdgeStrokeColor,RightEdgeStrokeTint,RightEdgeStrokeGapColor,RightEdgeStrokeGapTint,RightEdgeStrokeColorHTML,RightEdgeStrokeGapColorHTML,
									BottomEdgeStrokeWeight,BottomEdgeStrokeType,BottomEdgeStrokeColor,BottomEdgeStrokeTint,BottomEdgeStrokeGapColor,BottomEdgeStrokeGapTint,BottomEdgeStrokeColorHTML,BottomEdgeStrokeGapColorHTML,
									LeftEdgeStrokeStylename,LeftEdgeStrokeStylenameHTML,
									TopEdgeStrokeStylename,TopEdgeStrokeStylenameHTML,
									RightEdgeStrokeStylename,RightEdgeStrokeStylenameHTML,
									BottomEdgeStrokeStylename,BottomEdgeStrokeStylenameHTML
									) {
	if (Self == null || Self == "") return(-1);
	if (Name == null || Name == "") return(-2);
	css_cellstyles_arr[css_cellstyles_idx] = new Array();

	css_cellstyles_arr[css_cellstyles_idx][0] = create_cellstyle_classname_from_styleName(Name);		// class name built from style name
	css_cellstyles_arr[css_cellstyles_idx][1] = Self;		// ID
	css_cellstyles_arr[css_cellstyles_idx][2] = Name;		// style name
	css_cellstyles_arr[css_cellstyles_idx][3] = BasedOn;
	css_cellstyles_arr[css_cellstyles_idx][4] = AppliedParagraphStyle;
	css_cellstyles_arr[css_cellstyles_idx][5] = TopInset;
	css_cellstyles_arr[css_cellstyles_idx][6] = LeftInset;
	css_cellstyles_arr[css_cellstyles_idx][7] = BottomInset;
	css_cellstyles_arr[css_cellstyles_idx][8] = RightInset;
	css_cellstyles_arr[css_cellstyles_idx][9] = VerticalJustification;
	css_cellstyles_arr[css_cellstyles_idx][10] = ParagraphSpacingLimit;

	css_cellstyles_arr[css_cellstyles_idx][11] = ClipContentToCell;
	css_cellstyles_arr[css_cellstyles_idx][12] = FirstBaselineOffset;
	css_cellstyles_arr[css_cellstyles_idx][13] = MinimumFirstBaselineOffset;
	css_cellstyles_arr[css_cellstyles_idx][14] = RotationAngle;

	css_cellstyles_arr[css_cellstyles_idx][15] = FillColor;
	css_cellstyles_arr[css_cellstyles_idx][16] = FillTint;
	css_cellstyles_arr[css_cellstyles_idx][17] = FillColorRGB;

	css_cellstyles_arr[css_cellstyles_idx][18] = LeftEdgeStrokeWeight;
		if ( (css_cellstyles_arr[css_cellstyles_idx][1].indexOf("[None]") >= 0) && (css_cellstyles_arr[css_cellstyles_idx][18] == "") ) css_cellstyles_arr[css_cellstyles_idx][18] = 1;
	css_cellstyles_arr[css_cellstyles_idx][19] = LeftEdgeStrokeType;
	css_cellstyles_arr[css_cellstyles_idx][20] = LeftEdgeStrokeColor;
	css_cellstyles_arr[css_cellstyles_idx][21] = LeftEdgeStrokeTint;
	css_cellstyles_arr[css_cellstyles_idx][22] = LeftEdgeStrokeGapColor;
	css_cellstyles_arr[css_cellstyles_idx][23] = LeftEdgeStrokeGapTint;
	css_cellstyles_arr[css_cellstyles_idx][24] = LeftEdgeStrokeColorHTML;
	css_cellstyles_arr[css_cellstyles_idx][25] = LeftEdgeStrokeGapColorHTML;

	css_cellstyles_arr[css_cellstyles_idx][26] = TopEdgeStrokeWeight;
		if ( (css_cellstyles_arr[css_cellstyles_idx][1].indexOf("[None]") >= 0) && (css_cellstyles_arr[css_cellstyles_idx][26] == "") ) css_cellstyles_arr[css_cellstyles_idx][26] = 1;
	css_cellstyles_arr[css_cellstyles_idx][27] = TopEdgeStrokeType;
	css_cellstyles_arr[css_cellstyles_idx][28] = TopEdgeStrokeColor;
	css_cellstyles_arr[css_cellstyles_idx][29] = TopEdgeStrokeTint;
	css_cellstyles_arr[css_cellstyles_idx][30] = TopEdgeStrokeGapColor;
	css_cellstyles_arr[css_cellstyles_idx][31] = TopEdgeStrokeGapTint;
	css_cellstyles_arr[css_cellstyles_idx][32] = TopEdgeStrokeColorHTML;
	css_cellstyles_arr[css_cellstyles_idx][33] = TopEdgeStrokeGapColorHTML;

	css_cellstyles_arr[css_cellstyles_idx][34] = RightEdgeStrokeWeight;
		if ( (css_cellstyles_arr[css_cellstyles_idx][1].indexOf("[None]") >= 0) && (css_cellstyles_arr[css_cellstyles_idx][34] == "") ) css_cellstyles_arr[css_cellstyles_idx][34] = 1;
	css_cellstyles_arr[css_cellstyles_idx][35] = RightEdgeStrokeType;
	css_cellstyles_arr[css_cellstyles_idx][36] = RightEdgeStrokeColor;
	css_cellstyles_arr[css_cellstyles_idx][37] = RightEdgeStrokeTint;
	css_cellstyles_arr[css_cellstyles_idx][38] = RightEdgeStrokeGapColor;
	css_cellstyles_arr[css_cellstyles_idx][39] = RightEdgeStrokeGapTint;
	css_cellstyles_arr[css_cellstyles_idx][40] = RightEdgeStrokeColorHTML;
	css_cellstyles_arr[css_cellstyles_idx][41] = RightEdgeStrokeGapColorHTML;

	css_cellstyles_arr[css_cellstyles_idx][42] = BottomEdgeStrokeWeight;
		if ( (css_cellstyles_arr[css_cellstyles_idx][1].indexOf("[None]") >= 0) && (css_cellstyles_arr[css_cellstyles_idx][42] == "") ) css_cellstyles_arr[css_cellstyles_idx][42] = 1;
	css_cellstyles_arr[css_cellstyles_idx][43] = BottomEdgeStrokeType;
	css_cellstyles_arr[css_cellstyles_idx][44] = BottomEdgeStrokeColor;
	css_cellstyles_arr[css_cellstyles_idx][45] = BottomEdgeStrokeTint;
	css_cellstyles_arr[css_cellstyles_idx][46] = BottomEdgeStrokeGapColor;
	css_cellstyles_arr[css_cellstyles_idx][47] = BottomEdgeStrokeGapTint;
	css_cellstyles_arr[css_cellstyles_idx][48] = BottomEdgeStrokeColorHTML;
	css_cellstyles_arr[css_cellstyles_idx][49] = BottomEdgeStrokeGapColorHTML;

	css_cellstyles_arr[css_cellstyles_idx][50] = LeftEdgeStrokeStylename;
	css_cellstyles_arr[css_cellstyles_idx][51] = LeftEdgeStrokeStylenameHTML;
	css_cellstyles_arr[css_cellstyles_idx][52] = TopEdgeStrokeStylename;
	css_cellstyles_arr[css_cellstyles_idx][53] = TopEdgeStrokeStylenameHTML;
	css_cellstyles_arr[css_cellstyles_idx][54] = RightEdgeStrokeStylename;
	css_cellstyles_arr[css_cellstyles_idx][55] = RightEdgeStrokeStylenameHTML;
	css_cellstyles_arr[css_cellstyles_idx][56] = BottomEdgeStrokeStylename;
	css_cellstyles_arr[css_cellstyles_idx][57] = BottomEdgeStrokeStylenameHTML;

	css_cellstyles_idx++;	// point to next empty element
	return(0);
}
// merge cell styles which are based on a style
function css_cellstyles_merge_basedon() {
	for (var i = 0; i < css_cellstyles_arr.length; i++) {
		if (css_cellstyles_arr[i][3] == "") continue;	// BasedOn attribute is not set
		//if (css_cellstyles_arr[i][3].indexOf("[None]") >= 0) continue;	// basd on CellStyle/$ID/[None], do not merge ([None] has no attributes)

		var j = 0;
		var basedid = css_cellstyles_arr[i][3] + "#*";
		for (j = 0; j < css_cellstyles_arr.length; j++) {
			var styleid = css_cellstyles_arr[j][1]+ "#*";
			if (styleid.indexOf(basedid) >= 0) break;	// ID == BasedOn? = based on style found
		}
		if (j >= css_cellstyles_arr.length) continue;	// based on style not found
		for (var k = 4; k < css_cellstyles_arr[i].length; k++) {
			if (css_cellstyles_arr[i][k] == "") css_cellstyles_arr[i][k] = css_cellstyles_arr[j][k];
		}
	}
	return;
}
function get_cellstyle_from_styleID(styleID) {
	var i = 0;
	for (i = 0; i < css_cellstyles_arr.length; i++) {
		if (css_cellstyles_arr[i][1] == styleID) {
			return (css_cellstyles_arr[i]);
		}
	}
	return null;
}
function get_cellstyle_classname_from_styleID(styleID) {
	var i = 0;
	for (i = 0; i < css_cellstyles_arr.length; i++) {
		if (css_cellstyles_arr[i][1] == styleID) {
			return (css_cellstyles_arr[i][0]);
		}
	}
	return "";
}
function create_cellstyle_classname_from_styleName(styleName) {
	if (styleName == "") return "";
	var class_name = "Tc_" + styleName;
	class_name = clean_classname(class_name);
	return class_name;
}


function create_cell_style(	verticalalign,
							backgroundColor,
							borderLeftWidth,borderTopWidth,borderRightWidth,borderBottomWidth,
							borderLeftStyle,borderTopStyle,borderRightStyle,borderBottomStyle,
							borderLeftColor,borderTopColor,borderRightColor,borderBottomColor,
							cellStyleID,
							fontColor,
							textInsetLeft,textInsetTop,textInsetRight,textInsetBottom) {
	// prepare cell style
	var style_arr = null;
	var my_cellStyleID = cellStyleID;
	if ((my_cellStyleID == null) || (my_cellStyleID == "")) {
		my_cellStyleID = null;
	}
	else style_arr = get_cellstyle_from_styleID(cellStyleID);

	var have_border_info = false;

	var stylestr = "";
	if (verticalalign != "") stylestr += "vertical-align:" + verticalalign + ";";

	if (backgroundColor != "") stylestr += "background-color:" + (backgroundColor != "transparent" ? "#" : "") + backgroundColor + ";";

	if ((textInsetLeft) && (textInsetLeft != "") && (textInsetLeft != "0")) {
		stylestr += "padding-left:" + Math.ceil(textInsetLeft) + "px;";
	}
	if ((textInsetTop) && (textInsetTop != "") && (textInsetTop != "0")) {
		stylestr += "padding-top:" + Math.ceil(textInsetTop) + "px;";
	}
	if ((textInsetRight) && (textInsetRight != "") && (textInsetRight != "0")) {
		stylestr += "padding-right:" + Math.ceil(textInsetRight) + "px;";
	}
	if ((textInsetBottom) && (textInsetBottom != "") && (textInsetBottom != "0")) {
		stylestr += "padding-bottom:" + Math.ceil(textInsetBottom) + "px;";
	}

	if (fontColor != "") {
		stylestr += "color:" + (fontColor != "transparent" ? "#" : "") + fontColor + ";";
	}

	// ------- get border widths
	do {
		var my_borderLeftWidth = "" + borderLeftWidth,
			my_borderTopWidth = "" + borderTopWidth,
			my_borderRightWidth = "" + borderRightWidth,
			my_borderBottomWidth = "" + borderBottomWidth;
	
		if ((my_borderLeftWidth != ""))  have_border_info = true;
		else {	// get from cell style
			//if ((style_arr != null) && (style_arr[1].indexOf("[None]") < 0)) my_borderLeftWidth = style_arr[18];
			if ((my_borderLeftWidth != null) && (my_borderLeftWidth != "")) have_border_info = true;
		}
		if (my_borderTopWidth != "") have_border_info = true;
		else {	// get from table style
			//if ((style_arr != null) && (style_arr[1].indexOf("[None]") < 0)) my_borderTopWidth = style_arr[26];
			if ((my_borderTopWidth != null) && (my_borderTopWidth != "")) have_border_info = true;
		}
		if (my_borderRightWidth != "") have_border_info = true;
		else {	// get from table style
			//if ((style_arr != null) && (style_arr[1].indexOf("[None]") < 0)) my_borderRightWidth = style_arr[34];
			if ((my_borderRightWidth != null) && (my_borderRightWidth != "")) have_border_info = true;
		}
		if (my_borderBottomWidth != "") have_border_info = true;
		else {	// get from table style
			//if ((style_arr != null) && (style_arr[1].indexOf("[None]") < 0)) my_borderBottomWidth = style_arr[42];
			if ((my_borderBottomWidth != null) && (my_borderBottomWidth != "")) have_border_info = true;
		}
		if (!have_border_info) break;

		// init border styles: set always to solid
		var my_borderLeftStyle = (((borderLeftStyle == null) || (borderLeftStyle == "")) ? "" : get_html_strokename(borderLeftStyle));
		if ((my_borderLeftStyle == "") && (style_arr != null)) my_borderLeftStyle = get_html_strokename(style_arr[19]);	// get from cell style
		if (my_borderLeftStyle == "") my_borderLeftStyle = "solid";
		var my_borderTopStyle = (((borderTopStyle == null) || (borderTopStyle == "")) ? "" : get_html_strokename(borderTopStyle));
		if ((my_borderTopStyle == "") && (style_arr != null)) my_borderTopStyle = get_html_strokename(style_arr[27]);	// get from cell style
		if (my_borderTopStyle == "") my_borderTopStyle = "solid";
		var my_borderRightStyle = (((borderRightStyle == null) || (borderRightStyle == "")) ? "" : get_html_strokename(borderRightStyle));
		if ((my_borderRightStyle == "") && (style_arr != null)) my_borderRightStyle = get_html_strokename(style_arr[35]);	// get from cell style
		if (my_borderRightStyle == "") my_borderRightStyle = "solid";
		var my_borderBottomStyle = (((borderBottomStyle == null) || (borderBottomStyle == "")) ? "" : get_html_strokename(borderBottomStyle));
		if ((my_borderBottomStyle == "") && (style_arr != null)) my_borderBottomStyle = get_html_strokename(style_arr[43]);	// get from cell style
		if (my_borderBottomStyle == "") my_borderBottomStyle = "solid";

		// init border colors
		var my_borderLeftColor = (((borderLeftColor != null) && (borderLeftColor != "")) ? borderLeftColor : "");
		if ((my_borderLeftColor == "") && (style_arr != null)) my_borderLeftColor = get_rgb_color(style_arr[7],style_arr[14]);	// get from cell style
		if (my_borderLeftColor == "") my_borderLeftColor = "000000";
		var my_borderTopColor = (((borderTopColor != null) && (borderTopColor != "")) ? borderTopColor : "");
		if ((my_borderTopColor == "") && (style_arr != null)) my_borderTopColor = get_rgb_color(style_arr[11],style_arr[16]);	// get from cell style
		if (my_borderTopColor == "") my_borderTopColor = "000000";
		var my_borderRightColor = (((borderRightColor != null) && (borderRightColor != "")) ? borderRightColor : "");
		if ((my_borderRightColor == "") && (style_arr != null)) my_borderRightColor = get_rgb_color(style_arr[9],style_arr[15]);	// get from cell style
		if (my_borderRightColor == "") my_borderRightColor = "000000";
		var my_borderBottomColor = (((borderBottomColor != null) && (borderBottomColor != "")) ? borderBottomColor : "");
		if ((my_borderBottomColor == "") && (style_arr != null)) my_borderBottomColor = get_rgb_color(style_arr[13],style_arr[17]);	// get from cell style
		if (my_borderBottomColor == "") my_borderBottomColor = "000000";
/*
java.lang.System.out.println ("WWWWWWWWWWWWWWWWWW borderLeftWidth: '" + borderLeftWidth + "'");
java.lang.System.out.println ("WWWWWWWWWWWWWWWWWW border style name = style_arr[0]: '" + style_arr[0] + "'");
java.lang.System.out.println ("WWWWWWWWWWWWWWWWWW style borderLeftWidth = style_arr[32]: '" + style_arr[32] + "'");
java.lang.System.out.println ("WWWWWWWWWWWWWWWWWW my_borderLeftWidth: '" + my_borderLeftWidth + "'");
*/
		if (have_border_info && (my_borderLeftWidth != "")) {
			stylestr += "border-left:" + Math.ceil(my_borderLeftWidth) + "px " + my_borderLeftStyle + " " + (my_borderLeftColor != "transparent" ? "#" : "") + my_borderLeftColor + ";";
//java.lang.System.out.println ("WWWWWWWWWWWWWWWWWW stylestr: '" + stylestr + "'");
		}
		if (have_border_info && (my_borderTopWidth != "")) {
			stylestr += "border-top:" + Math.ceil(my_borderTopWidth) + "px " + my_borderTopStyle + " " + (my_borderTopColor != "transparent" ? "#" : "") + my_borderTopColor + ";";
		}
		if (have_border_info && (my_borderRightWidth != "")) {
			stylestr += "border-right:" + Math.ceil(my_borderRightWidth) + "px " + my_borderRightStyle + " " + (my_borderRightColor != "transparent" ? "#" : "") + my_borderRightColor + ";";
		}
		if (have_border_info && (my_borderBottomWidth != "")) {
			stylestr += "border-bottom:" + Math.ceil(my_borderBottomWidth) + "px " + my_borderBottomStyle + " " + (my_borderBottomColor != "transparent" ? "#" : "") + my_borderBottomColor + ";";
		}
	} while(false);

	return (stylestr);
}


/* 
 CSS styles for paragraphs and characters
 */
var css_styles_arr = new Array();
var css_styles_idx = 0;		// point to first element
function css_styles_arr_create(num_elements) {
	css_styles_arr = new Array(parseInt(num_elements,10));
	css_styles_idx = 0;
	return;
}
function css_styles_arr_length() {
	return css_styles_arr.length;
}
function get_css_styles_arr() {
	return css_styles_arr;
}
function css_styles_arr_add_style() {
	//if (css_styles_idx >= css_styles_arr.length) return;
	css_styles_arr[css_styles_idx] = new Array(30);	// [0] = style type: 'ParagraphStyle' or 'CharacterStyle'
													// [1] = @Self = style ID
													// [2] = @pnam = style name
													// [3] = @basd = based on style ID
													// [4] = @paln = text align
													// [5] = @font = font family
													// [6] = @ptsz = font size
													// [7] = @flcl = color ID
													// [8] = @ptfs = a part for font weight
													// [9] = @ptfs = a part for font style
													// [10] = @capm = capitaize, small caps...
													// [11] = @fPSN = PS font name from fFam/FonT/@fPSN
													// [12] = @pnam = font name from fFam/FonT/@pnam
													// [13] = filename of font conversion table
													// [14] = additional font-family style attribute like 'monospace'
													//        As a workaround for browsers not able to display Dingbats (U+2700) or Enclosed Alpanumerics (U+2460)
													//        Creating a style like: font-family:'European Pi 1', monospace;
													//        will enable Browsers like Firefox to display these fonts.
													//        This additional attribute is set from a font conversion table
													// [15] = @spbe = space before (paragraph)
													// [16] = @spaf = space after (paragraph)
													// [17] = @undr = character underline mode
													// [18] = @posm = character position mode
													// [19] = @filt = character color filter
													// [20] = @inbl = inset block left
													// [21] = @inbr = inset block right
													// [22] = @infl = inset first line
													// [23] = @szld = line leading
													// [24] = a full string containing style attribs
													// [25] = a comment line text
													// [26] = @strk = strike through mode
													// [27] = @plng = text language
													// [28] = the bullet char value for bullet list
													// [last] = an array containing ALL style attribs

	css_styles_arr[css_styles_idx][0] = stylesheet.styleType;
	css_styles_arr[css_styles_idx][1] = stylesheet.styleID;
	css_styles_arr[css_styles_idx][2] = stylesheet.styleName.replace(/~sep~/g,'_');
	css_styles_arr[css_styles_idx][3] = stylesheet.styleBasedOn.replace(/~sep~/g,'_');
	css_styles_arr[css_styles_idx][4] = stylesheet.textAlign;
	css_styles_arr[css_styles_idx][5] = stylesheet.fontFamily.replace(/~sep~/g,'_');
	if (MAKE_INTERNET_AWARE_FONTNAMES == true) {
		if (css_styles_arr[css_styles_idx][5].indexOf("(") > 0) {
			css_styles_arr[css_styles_idx][5] = css_styles_arr[css_styles_idx][5].substr(0,css_styles_arr[css_styles_idx][5].indexOf("("));	// remove part bejond '(' like in "Helvetica Neue (T1)"
			// and remove trailing spaces
			while (css_styles_arr[css_styles_idx][5].charAt(css_styles_arr[css_styles_idx][5].length-1) == " ") { css_styles_arr[css_styles_idx][5] = css_styles_arr[css_styles_idx][5].substr(0,css_styles_arr[css_styles_idx][5].length-1); }
		}
	}
	css_styles_arr[css_styles_idx][6] = stylesheet.fontSize;
	css_styles_arr[css_styles_idx][7] = stylesheet.fontColor;
	css_styles_arr[css_styles_idx][8] = stylesheet.fontWeight;
	css_styles_arr[css_styles_idx][9] = stylesheet.fontStyle;
	css_styles_arr[css_styles_idx][10] = stylesheet.textTransform;
	css_styles_arr[css_styles_idx][11] = stylesheet.fontNamePS.replace(/~sep~/g,'_');
	css_styles_arr[css_styles_idx][12] = stylesheet.fontName.replace(/~sep~/g,'_');
	// conversion table name
	if (isNumeric(stylesheet.fontStyle) == true) css_styles_arr[css_styles_idx][13] = css_styles_arr[css_styles_idx][12]; // table name = fontName - from fonts like "European Pi 1"
	else css_styles_arr[css_styles_idx][13] = css_styles_arr[css_styles_idx][5]; // table name = fontFamily 

	css_styles_arr[css_styles_idx][14] = "";
	css_styles_arr[css_styles_idx][15] = stylesheet.spaceBefore;
	css_styles_arr[css_styles_idx][16] = stylesheet.spaceAfter;
	css_styles_arr[css_styles_idx][17] = stylesheet.cattrUnderline;		// true or false
	css_styles_arr[css_styles_idx][18] = stylesheet.cattrPositionmode;	// position: sbsc=subscript, spsc=superscript, Normal
	css_styles_arr[css_styles_idx][19] = stylesheet.fontColorFilter;	// position: sbsc=subscript, spsc=superscript, norm=no

	css_styles_arr[css_styles_idx][20] = stylesheet.indentLeft;			// left para indent
	css_styles_arr[css_styles_idx][21] = stylesheet.indentRight;		// right para indent
	css_styles_arr[css_styles_idx][22] = stylesheet.indentFirstLine;	// first line indent
	css_styles_arr[css_styles_idx][23] = stylesheet.lineLeading;		// line leading

	css_styles_arr[css_styles_idx][24] = stylesheet.styleAttributesString;	// like: background-color:#eeef5; display:block;
	css_styles_arr[css_styles_idx][25] = stylesheet.comment;	// like: background-color:#eeef5; display:block;
	css_styles_arr[css_styles_idx][26] = stylesheet.cattrStrikethrough;		// strike through true or false
	css_styles_arr[css_styles_idx][27] = stylesheet.textLanguage;		// the text language

	css_styles_arr[css_styles_idx][28] = stylesheet.bulletChar;		// the bullet char for bullet lists
	// add more vars here...
	// full attribs must be the last one
	css_styles_arr[css_styles_idx][css_styles_arr[css_styles_idx].length -1 ] = stylesheet.fullAttributes;	// complete INX style attributes as last element

	css_styles_idx++;	// point to next empty element
	return;
}
var css_styles_arr_walker_idx = -1;
function init_css_styles_arr_walker_idx() {
	css_styles_arr_walker_idx = -1;
}
function next_css_styles_arr_walker_idx() {
	if (css_styles_arr_walker_idx < css_styles_arr.length-1) return(++css_styles_arr_walker_idx);
	return(-1);
}
function current_css_styles_arr_walker_idx() {
	return(css_styles_arr_walker_idx);
}
function get_css_styles_arr_item(whichstyle,whichitem,fullattr) {
	if ((whichstyle == null) || (whichstyle == "")) return("");
	var thestyle = parseInt(whichstyle,10);
	if ((thestyle < 0) || (thestyle >= css_styles_arr.length)) return("");
	var theitem = parseInt(whichitem,10);
	var thefullattr = "";
	if ((typeof(fullattr) != "undefined") && (fullattr != null) && (fullattr != "")) {
		thefullattr = fullattr;
		theitem = css_styles_arr[thestyle].length - 1;
	}
	// java.lang.System.out.println ("*** thefullattr: " + thefullattr + " -- theitem: " + theitem + " -- type fullattr: " + typeof(fullattr));
	try { 
		if ((theitem < 0) || (theitem >= css_styles_arr[thestyle].length)) return("");
		if (thefullattr != "") {
			if (css_styles_arr[thestyle][theitem][thefullattr]) return(css_styles_arr[thestyle][theitem][thefullattr]);
			else return("");
		}
		else {
			if (css_styles_arr[thestyle][theitem]) return(css_styles_arr[thestyle][theitem]);
			else return("");
		}
	} catch(e) { return(""); };
}
// merge para or char styles which are based on a style
function css_styles_merge_basedon(which) {
	if ((which == null) || (which == "")) return;
	if ((which != "ParagraphStyle") && (which != "CharacterStyle")) return;
	for (var i = 0; i < css_styles_arr.length; i++) {
		//java.lang.System.out.println ("*** css_styles_merge_basedon["+i+"]"+which+": " + css_styles_arr[i]);
		if (!css_styles_arr[i]) break;
		if (css_styles_arr[i][0] != which) continue;	// not the requested ParagraphStyle or CharacterStyle
		//if (css_styles_arr[i][3] == "") continue;		// basd attribute is not set
		var j = 0;
		for (j = 0; j < css_styles_arr.length; j++) {
			//java.lang.System.out.println ("       css_styles_merge_basedon["+i+"]"+which+": " + css_styles_arr[j]);
			if (!css_styles_arr[j]) { j = css_styles_arr.length; break; }	// say 'not found' and break
			if ((css_styles_arr[j][0] == which)
				&& (css_styles_arr[j][2] == css_styles_arr[i][3])
				&& (css_styles_arr[j][0] == css_styles_arr[i][0])) break;	// pnam == basd? and same style type = based on style found
		}
		if (j >= css_styles_arr.length) continue;	// based on style not found
		for (var k = 4; k < css_styles_arr[i].length - 1; k++) {	// the last element of a style array is the full attribs associative array! don't merge it!
			if (css_styles_arr[i][k] == "") css_styles_arr[i][k] = css_styles_arr[j][k];
		}
		//java.lang.System.out.println ("######  merged "+which);
	}
	return;
}
function get_style_name_from_id(styleID) {
	var i = 0;
	var style_name = "";
	for (i = 0; i < css_styles_arr.length; i++) {
		if (css_styles_arr[i][1] == styleID) {
			style_name = css_styles_arr[i][2];
			break;
		}
	}
	return(style_name);
}
function get_style_class_name(styleID) {
	var i = 0;
	var class_name = "";
	for (i = 0; i < css_styles_arr.length; i++) {
		if (css_styles_arr[i][1] == styleID) {
			class_name = plain_Name(css_styles_arr[i][2]);
			break;
		}
	}
	if (class_name == "") return "";
	do {
		if ((class_name.indexOf('[No ') >= 0) || (class_name.indexOf('[None') >= 0)) {	// like '[No paragraph style]' or '[None]'
			class_name = "____NoStyle____";
		}
		if (css_styles_arr[i][0].toLowerCase().indexOf('object') >= 0) class_name = "O_" + class_name;
		else if (css_styles_arr[i][0].toLowerCase().indexOf('paragraph') >= 0) class_name = "P_" + class_name;
			 else class_name = "C_" + class_name;
		class_name = clean_classname(class_name);
	} while(false);
	return class_name;
}
function get_style_class_name_from_stylename(styleName, type) {
	if (styleName == "") return "";
	var class_name = styleName;
	if (styleName.indexOf('[No ') >= 0) {	// like '[No paragraph style]' or '[No character style]'
		class_name = "____NoStyle____";
	}
	class_name = clean_classname(class_name);
	switch (type) {
		case "ParagraphStyle":	// paragraph styles
			class_name = "P_" + class_name;
			break;
		case "CharacterStyle":	// character styles
			class_name = "C_" + class_name;
			break;
		case "TableStyle":	// table styles
			class_name = "T_" + class_name;
			break;
		case "CellStyle":	// cell styles
			class_name = "Cl_" + class_name;
			break;
		case "ObjectStyle":	// object styles
			class_name = "O_" + class_name;
			break;
		case "StrokeStyle":	// stroke styles
			class_name = "S_" + class_name;
			break;
	}
	return class_name;
}
function clean_classname(class_name) {
	class_name = class_name.replace(/@/g,"a");
	class_name = class_name.replace(/#/g,"H");
	class_name = class_name.replace(/\$/g,"d");
	class_name = class_name.replace(/\*/g,"A");
	class_name = class_name.replace(/ /g,"b");
	class_name = class_name.replace(/,/g,"c");
	class_name = class_name.replace(/-/g,"M");
	class_name = class_name.replace(/\+/g,"P");
	class_name = class_name.replace(/\=/g,"E");
	class_name = class_name.replace(/\./g,"p");
	class_name = class_name.replace(/\;/g,"o");
	class_name = class_name.replace(/\:/g,"O");
	class_name = class_name.replace(/\!/g,"e");
	class_name = class_name.replace(/\?/g,"q");
	class_name = class_name.replace(/\\/g,"S");
	class_name = class_name.replace(/\//g,"s");
	class_name = class_name.replace(/\|/g,"B");
	class_name = class_name.replace(/\~/g,"t");

	class_name = class_name.replace(/\</g,"LT");
	class_name = class_name.replace(/\>/g,"GT");
	class_name = class_name.replace(/\(/g,"_");
	class_name = class_name.replace(/\)/g,"_");
	class_name = class_name.replace(/\{/g,"_");
	class_name = class_name.replace(/\}/g,"_");
	class_name = class_name.replace(/\]/g,"_");
	class_name = class_name.replace(/\[/g,"_");
	class_name = class_name.replace(/\%/g,"_");
	class_name = class_name.replace(/\&/g,"_");

	class_name = class_name.replace(/\'/g,"_");
	class_name = class_name.replace(/\"/g,"_");

	class_name = class_name.replace(/~sep~/g,"_");

	if (CSSclassNamesASCII > 0) {	// no special chars are allowed: URLencode and replace %
		class_name = encodeURI(class_name);
		class_name = class_name.replace(/\%/g,"0x");
	}
	if (CSSclassNamesNoUnderscore > 0) class_name = class_name.replace(/_/g,"u");
	return(class_name);
}
function set_style_fontfamily_attributeAddition(fontname,styleattr) {
	for (var i = 0; i < css_styles_arr.length; i++) {
		if (css_styles_arr[i][12] == fontname) {
			css_styles_arr[i][14] = styleattr;
			if (DEBUG) java.lang.System.out.println ("\n****** attributeAddition set for font '" + fontname + "':" + styleattr);
			return;
		}
	}
	return;
}
function get_style_fontfamily_attributeAddition(fontname) {
	if (fontname == "") return("");
	for (var i = 0; i < css_styles_arr.length; i++) {
		if (css_styles_arr[i][12] == fontname) {
			return css_styles_arr[i][14];
		}
	}
	return("");
}
function get_style_fontfamily(styleID) {
	for (var i = 0; i < css_styles_arr.length; i++) {
		if (css_styles_arr[i][1] == styleID) return(css_styles_arr[i][5]);
	}
	return "";
}
function get_style_fontName(styleID) {
	for (var i = 0; i < css_styles_arr.length; i++) {
		if (css_styles_arr[i][1] == styleID) {
			if (css_styles_arr[i][12] != "") return(css_styles_arr[i][12]);
			else return(css_styles_arr[i][5]);
		}
	}
	return "";
}
function get_style_fontNamePS(styleID) {
	for (var i = 0; i < css_styles_arr.length; i++) {
		if (css_styles_arr[i][1] == styleID) return(css_styles_arr[i][11]);
	}
	return "";
}
function get_style_fontweight(styleID) {
	for (var i = 0; i < css_styles_arr.length; i++) {
		if (css_styles_arr[i][1] == styleID) return(css_styles_arr[i][8]);
	}
	return "";
}
function get_style_fontstyle(styleID) {
	for (var i = 0; i < css_styles_arr.length; i++) {
		if (css_styles_arr[i][1] == styleID) return(css_styles_arr[i][9]);
	}
	return "";
}
function get_style_fontcolor(styleID) {
	for (var i = 0; i < css_styles_arr.length; i++) {
		if (css_styles_arr[i][1] == styleID) return(css_styles_arr[i][7]);
	}
	return "";
}
function get_style_fontsize(styleID) {
	for (var i = 0; i < css_styles_arr.length; i++) {
		if (css_styles_arr[i][1] == styleID) return(css_styles_arr[i][6]);
	}
	return "";
}
function get_style_fontverticalalign(styleID) {
	for (var i = 0; i < css_styles_arr.length; i++) {
		if (css_styles_arr[i][1] == styleID) return(css_styles_arr[i][18]);
	}
	return "";
}

function print_CSS_styles() {
	for (var i = 0; i < css_styles_arr.length; i++) {
		try { java.lang.System.out.println (css_styles_arr[i].toString()); } catch(e) { break; }
	}
	for (var i = 0; i < css_tablestyles_arr.length; i++) {
		try { java.lang.System.out.println (css_tablestyles_arr[i].toString()); } catch(e) { break; }
	}
	for (var i = 0; i < css_cellstyles_arr.length; i++) {
		try { java.lang.System.out.println (css_cellstyles_arr[i].toString()); } catch(e) { break; }
	}
}
function writeCSSfile(filename,overwrite) {
	if (overwrite == 0) {	// we should not overwrite existing CSS files
		var exists = Packages.com.epaperarchives.batchxslt.utils.existsFile(filename);
		if (exists == true) return false;
	}

	// write paragraph and character styles
	var style = "", style_class_name = "";
	style += "/*** Object Styles ***/" + platformCRLF;
	for (var i = 0; i < css_styles_arr.length; i++) {
		if (css_styles_arr[i][0] != "ObjectStyle") continue;	// for style types ObjectStyle
		style_class_name = get_style_class_name(css_styles_arr[i][1]);
		style += "." + style_class_name + " { ";
		if (DEBUG_cssfile) {
			style += "/* id:\"" + css_styles_arr[i][1] + "\"; ";
			style += "name:\"" + css_styles_arr[i][2] + "\"; ";
			style += "basedon:\"" + css_styles_arr[i][3] + "\"; */" + platformCRLF;
		}
		style += "}" + platformCRLF;
	}

	style += "/*** Paragraph and Character Styles ***/" + platformCRLF;
	for (var i = 0; i < css_styles_arr.length; i++) {
		if ((css_styles_arr[i][0] != "ParagraphStyle") && (css_styles_arr[i][0] != "CharacterStyle")) continue;	// for style types ParagraphStyle and CharacterStyle
		style_class_name = get_style_class_name(css_styles_arr[i][1]);
		if (style_class_name == "") continue;
		if (css_styles_arr[i][28] != "") {	// bullet list: add :before pseudo class
			style += "." + style_class_name + ":before { content:\"\\"+css_styles_arr[i][28]+"\\0000a0\\0000a0\"; }" + platformCRLF;
		}
		style += "." + style_class_name + " { ";
		if (DEBUG_cssfile) {
			style += "/* id:\"" + css_styles_arr[i][1] + "\"; ";
			style += "name:\"" + css_styles_arr[i][2] + "\"; ";
			style += "basedon:\"" + css_styles_arr[i][3] + "\"; */" + platformCRLF;
		}

		if (css_styles_arr[i][24] != "") style += css_styles_arr[i][24] + "; ";	// if all atribs are given in string

		if (css_styles_arr[i][4] != "") style += "text-align:" + css_styles_arr[i][4] + "; ";

		if (css_styles_arr[i][5] != "") {
			if (css_font_family_string != "") {
				style += "font-family:" + plain_Name(css_font_family_string);
			}
			else {
				style += "font-family:\"" + plain_Name(entity_fix(get_fontFamilyReplace(css_styles_arr[i][5]))) + "\"";
				if (css_styles_arr[i][11] != "") style += ",\"" + plain_Name(entity_fix(css_styles_arr[i][11])) + "\"";
				if (css_styles_arr[i][14] != "") style += "," + plain_Name(entity_fix(css_styles_arr[i][14])) + "";
			}
			style += "; ";
		}
		if (css_styles_arr[i][6] != "") style += "font-size:" + calc_fontsize(css_styles_arr[i][6], true) + "; ";
		if (css_styles_arr[i][7] != "") {
			var color = get_rgb_color(css_styles_arr[i][7],css_styles_arr[i][19]);
			style += "color:" + (color != "transparent" ? "#" : "") + color + "; ";
		}
		else if (css_styles_arr[i][0].indexOf("Paragraph") >= 0) style += "color:#000000; ";

		if (css_styles_arr[i][8] != "") {
			if (isNumeric(css_styles_arr[i][8]) == false) style += "font-weight:" + css_styles_arr[i][8] + "; ";
			else style += "font-weight:normal; ";
		}
		else if (css_styles_arr[i][0].indexOf("Paragraph") >= 0) style += "font-weight:normal; ";
		else style += "font-weight:normal; ";
		if (css_styles_arr[i][9] != "") {
			if (isNumeric(css_styles_arr[i][9]) == false) style += "font-style:" + css_styles_arr[i][9] + "; ";
			else style += "font-style:normal; ";
		}
		else if (css_styles_arr[i][0].indexOf("Paragraph") >= 0) style += "font-style:normal; ";
		if (css_styles_arr[i][10] != "") {
			if (css_styles_arr[i][10] == "small-caps") style += "font-variant:" + css_styles_arr[i][10] + "; ";
			else style += "text-transform:" + css_styles_arr[i][10] + "; ";
		}
		else if (css_styles_arr[i][0].indexOf("Paragraph") >= 0) style += "text-transform:none; ";
		if (css_styles_arr[i][15] != "") style += "margin-top:" + round_numberString(css_styles_arr[i][15]) + "px; ";
		if (css_styles_arr[i][16] != "") style += "margin-bottom:" + round_numberString(css_styles_arr[i][16]) + "px; ";

		if (css_styles_arr[i][17] == "t") style += "text-decoration:underline; ";
		if (css_styles_arr[i][26] == "t") style += "text-decoration:line-through; ";
		if (css_styles_arr[i][18] != "") {
			if (css_styles_arr[i][18] == "spsc") style += "vertical-align:super; ";
			if (css_styles_arr[i][18] == "sbsc") style += "vertical-align:sub; ";
		}

		if (css_styles_arr[i][20] != "") style += "padding-left:" + css_styles_arr[i][20] + "px; ";
		if (css_styles_arr[i][21] != "") style += "padding-right:" + css_styles_arr[i][21] + "px; ";
		if (css_styles_arr[i][22] != "") style += "text-indent:" + css_styles_arr[i][22] + "px; ";
		if ((paragraphAttribsSuppress & 1) != 1) {
			if (css_styles_arr[i][23] != "") {	// +++++ line-height, leading
				style += "line-height:" + calc_fontsize(css_styles_arr[i][23], true) + "; ";
			}
		}

		// do we have full attributes available?
		if (css_styles_arr[i][css_styles_arr[i].length - 1] != null) {	// last element is full attribs
			style += platformCRLF + "/*** FULL ATTRUBUTES" + platformCRLF;
			for (var attribname in css_styles_arr[i][css_styles_arr[i].length -1]) {
				style += attribname + ":" + css_styles_arr[i][css_styles_arr[i].length -1][attribname] + "; ";
			}
			style += platformCRLF + "*** END FULL ATTRUBUTES ***/" + platformCRLF;
		}
		style += "}" + platformCRLF;
	}

	// write table styles
	style += "/*** Table Styles ***/" + platformCRLF;
	for (var i = 0; i < css_tablestyles_arr.length; i++) {
		if (css_tablestyles_arr[i][0] == "") continue;
		style += "." + css_tablestyles_arr[i][0] + " { ";
			style += "/* id:\"" + css_tablestyles_arr[i][1] + "\"; ";
			style += "name:\"" + css_tablestyles_arr[i][2] + "\"; ";
			style += "basedon:\"" + css_tablestyles_arr[i][3] + "\"; */" + platformCRLF + " ";

		style += "empty-cells:show; border-collapse:collapse; ";
		if (css_tablestyles_arr[i][19] != "") style += "border-style:" + css_tablestyles_arr[i][19] + "; ";

		if (css_tablestyles_arr[i][6] != "") style += "border-left-width:" + Math.ceil(css_tablestyles_arr[i][6]) + "px; ";
		if (css_tablestyles_arr[i][10] != "") style += "border-top-width:" + Math.ceil(css_tablestyles_arr[i][10]) + "px; ";
		if (css_tablestyles_arr[i][8] != "")  style += "border-right-width:" + Math.ceil(css_tablestyles_arr[i][8]) + "px; ";
		if (css_tablestyles_arr[i][12] != "") style += "border-bottom-width:" + Math.ceil(css_tablestyles_arr[i][12]) + "px; ";
		if (css_tablestyles_arr[i][7] != "")  {
			var color = get_rgb_color(css_tablestyles_arr[i][7],css_tablestyles_arr[i][14]);
			style += "border-left-color:" + (color != "transparent" ? "#" : "") + color + "; ";
		}
		if (css_tablestyles_arr[i][11] != "") {
			var color = get_rgb_color(css_tablestyles_arr[i][11],css_tablestyles_arr[i][16]);
			style += "border-top-color:" + (color != "transparent" ? "#" : "") + color + "; ";
		}
		if (css_tablestyles_arr[i][9] != "") {
			var color = get_rgb_color(css_tablestyles_arr[i][9],css_tablestyles_arr[i][15]);
			style += "border-right-color:" + (color != "transparent" ? "#" : "") + color + "; ";
		}
		if (css_tablestyles_arr[i][13] != "") {
			var color = get_rgb_color(css_tablestyles_arr[i][13],css_tablestyles_arr[i][17]);
			style += "border-bottom-color:" + (color != "transparent" ? "#" : "") + color + "; ";
		}

		if (css_tablestyles_arr[i][36] != "") {
			style += "color:" + (css_tablestyles_arr[i][36] != "transparent" ? "#" : "") + css_tablestyles_arr[i][36] + "; ";
		}

		style += "}" + platformCRLF;
	}

	// write table cell styles
	style += "/*** Table Cell Styles ***/" + platformCRLF;
	for (var i = 0; i < css_cellstyles_arr.length; i++) {
		if (css_cellstyles_arr[i][0] == "") continue;
		style += "." + css_cellstyles_arr[i][0] + " { ";
			style += "/* id:\"" + css_cellstyles_arr[i][1] + "\"; ";
			style += "name:\"" + css_cellstyles_arr[i][2] + "\"; ";
			style += "basedon:\"" + css_cellstyles_arr[i][3] + "\"; */" + platformCRLF + " ";

		if (css_cellstyles_arr[i][5] != "") {
			style += "padding-top:" + css_cellstyles_arr[i][5] + "px; ";
		}
		if (css_cellstyles_arr[i][6] != "") {
			style += "padding-left:" + css_cellstyles_arr[i][6] + "px; ";
		}
		if (css_cellstyles_arr[i][7] != "") {
			style += "padding-bottom:" + css_cellstyles_arr[i][7] + "px; ";
		}
		if (css_cellstyles_arr[i][8] != "") {
			style += "padding-right:" + css_cellstyles_arr[i][8] + "px; ";
		}
		if (css_cellstyles_arr[i][9] != "") {
			style += "vertical-align:" + get_valign(css_cellstyles_arr[i][9]) + "; ";
		}

		if (css_cellstyles_arr[i][17] != "") {
			style += "background-color:" + (css_cellstyles_arr[i][17] != "transparent" ? "#" : "") + css_cellstyles_arr[i][17] + "; ";
		}

		if ((css_cellstyles_arr[i][18] != "") && (css_cellstyles_arr[i][18] != "0")) {	// left border
			style += "border-left-width:" + Math.ceil(css_cellstyles_arr[i][18]) + "px; ";
			style += "border-left-style:" + css_cellstyles_arr[i][51] + "; ";
			if (css_cellstyles_arr[i][24] != "") style += "border-left-color:" + (css_cellstyles_arr[i][24] != "transparent" ? "#" : "") + css_cellstyles_arr[i][24] + "; ";
			else style += "border-left-color:#000000; ";
		}

		if ((css_cellstyles_arr[i][26] != "") && (css_cellstyles_arr[i][26] != "0")) {	// top border
			style += "border-top-width:" + Math.ceil(css_cellstyles_arr[i][26]) + "px; ";
			style += "border-top-style:" + css_cellstyles_arr[i][53] + "; ";
			if (css_cellstyles_arr[i][32] != "") style += "border-top-color:" + (css_cellstyles_arr[i][32] != "transparent" ? "#" : "") + css_cellstyles_arr[i][32] + "; ";
			else style += "border-top-color:#000000; ";
		}

		if ((css_cellstyles_arr[i][34] != "") && (css_cellstyles_arr[i][34] != "0")) {	// right border
			style += "border-right-width:" + Math.ceil(css_cellstyles_arr[i][34]) + "px; ";
			style += "border-right-style:" + css_cellstyles_arr[i][55] + "; ";
			if (css_cellstyles_arr[i][40] != "") style += "border-right-color:" + (css_cellstyles_arr[i][40] != "transparent" ? "#" : "") + css_cellstyles_arr[i][40] + "; ";
			else style += "border-right-color:#000000; ";
		}

		if ((css_cellstyles_arr[i][42] != "") && (css_cellstyles_arr[i][42] != "0")) {	// bottom border
			style += "border-bottom-width:" + Math.ceil(css_cellstyles_arr[i][42]) + "px; ";
			style += "border-bottom-style:" + css_cellstyles_arr[i][57] + "; ";
			if (css_cellstyles_arr[i][48] != "") style += "border-bottom-color:" + (css_cellstyles_arr[i][48] != "transparent" ? "#" : "") + css_cellstyles_arr[i][48] + "; ";
			else style += "border-bottom-color:#000000; ";
		}

		style += "}" + platformCRLF;
	}


	// **** write all other helper styles like stylesheet.styleType == "hsty"
	for (var i = 0; i < css_styles_arr.length; i++) {
		if ((css_styles_arr[i][0] == "ObjectStyle") || (css_styles_arr[i][0] == "ParagraphStyle") || (css_styles_arr[i][0] == "CharacterStyle")) continue;	// all others but style types ParagraphStyle and CharacterStyle
		if (css_styles_arr[i][25] != "") {	// a comment line
			style += "/* " + css_styles_arr[i][25] + " */" + platformCRLF;
			continue;
		}
		if (css_styles_arr[i][2] == "") continue;
		style += css_styles_arr[i][2] + " { " + css_styles_arr[i][24] + " }" + platformCRLF;
	}

	// write styles to disk
	var retval = Packages.com.epaperarchives.batchxslt.utils.writeFile(filename, style, overwrite);
	if (retval == 0) return true;
	return false;
}


// ======= styles marking links to continued articles
var continuedAt_styles_arr = new Array();
function store_continuedAt_styles(styleslist) {
	if (styleslist == "") return null;
	var cont_styles_arr = styleslist.split("///");

	for (var s = 0; s < cont_styles_arr.length; s++) {
		for (var i = 0; i < css_styles_arr.length; i++) {
				// id = css_styles_arr[i][1]
				// name = css_styles_arr[i][2]
			if (css_styles_arr[i][2] == cont_styles_arr[s] ) {
				continuedAt_styles_arr[continuedAt_styles_arr.length] = new Array(2);
				continuedAt_styles_arr[continuedAt_styles_arr.length - 1][0] = css_styles_arr[i][1];	// the style id
				continuedAt_styles_arr[continuedAt_styles_arr.length - 1][1] = css_styles_arr[i][2];	// the style name
				break;
			}
		}
	}
	if (DEBUG > 0) {
		java.lang.System.out.println ("****** Link styles 'continued at':");
		if (continuedAt_styles_arr) {
			for (var s = 0; s < continuedAt_styles_arr.length; s++) {
				java.lang.System.out.println ("-- " + continuedAt_styles_arr[s]);
			}
		}
		else java.lang.System.out.println ("  NO styles defined");
	}
	return null;
}
function is_continuedAt_style(styleID) {
	if ( (styleID == null) || (styleID == "") ) return false;
	if ( (continuedAt_styles_arr == null) || (continuedAt_styles_arr.length <= 0) ) return false;

	for (var i = 0; i < continuedAt_styles_arr.length; i++) {
		if (continuedAt_styles_arr[i][0] == styleID) return true;
	}

	return false;
}


// ======= styles marking links to www addresses
var wwwLink_styles_arr = new Array();
function store_wwwLink_styles(styleslist) {
	if (styleslist == "") return null;
	var www_styles_arr = styleslist.split("///");

	for (var s = 0; s < www_styles_arr.length; s++) {
		for (var i = 0; i < css_styles_arr.length; i++) {
				// id = css_styles_arr[i][1]
				// name = css_styles_arr[i][2]
			if (css_styles_arr[i][2] == www_styles_arr[s] ) {
				wwwLink_styles_arr[wwwLink_styles_arr.length] = new Array(2);
				wwwLink_styles_arr[wwwLink_styles_arr.length - 1][0] = css_styles_arr[i][1];	// the style id
				wwwLink_styles_arr[wwwLink_styles_arr.length - 1][1] = css_styles_arr[i][2];	// the style name
				break;
			}
		}
	}

	if (DEBUG > 0) {
		if (wwwLink_styles_arr) {
			java.lang.System.out.println ("****** wwwLink styles: " + wwwLink_styles_arr.length);
			for (var s = 0; s < wwwLink_styles_arr.length; s++) {
				java.lang.System.out.println ("-- " + wwwLink_styles_arr[s]);
			}
		}
		else java.lang.System.out.println ("****** NO wwwLink styles defined");
	}
	return null;
}
function is_wwwLink_style(styleID) {
	if ( (styleID == null) || (styleID == "") ) return false;
	if ( (wwwLink_styles_arr == null) || (wwwLink_styles_arr.length <= 0) ) return false;

	for (var i = 0; i < wwwLink_styles_arr.length; i++) {
		if (wwwLink_styles_arr[i][0] == styleID) return true;
	}

	return false;
}





// ********** COLOR UTILITIES
var rgb_colors = new Array();
// takes the color id ColorValue attribute of a <Color element like
// clvl="x_4_D_86.26999855041504_D_77.64999866485596_D_0_D_0"
//               c                   m                 y   k
function store_color2rgb(colortype, id, name, space, colorvalue, basecolor, tintvalue, grad_type, grad_first_stopcolor, grad_first_stoplocation, grad_second_stopcolor, grad_second_stoplocation, grad_midpoint) {
	// 2 color spaces implemented:
	// a) Space="CMYK" ColorValue="0 0 0 100"
	// b) Space="RGB" ColorValue="255 255 255"
	if ((id == null) || (id == "")) return;
	rgb_colors[rgb_colors.length] = new Array(5);
	rgb_colors[rgb_colors.length-1][0] = id;
	rgb_colors[rgb_colors.length-1][1] = "";	// RGB color value
	rgb_colors[rgb_colors.length-1][2] = ( ((name != null)&&(name != "")) ? name : ("xx_" + id) );
	rgb_colors[rgb_colors.length-1][3] = space;	// color space
	rgb_colors[rgb_colors.length-1][4] = colortype;	// 0=from Color element, 1=from Swatch swch, 2= from tintvalue

	switch (colortype) {	// Color, Swatch or Tint (Tint???)
		case "0":	// from Color element
			var colors_arr = colorvalue.split(' ');
			var rgb_color = "";
			switch (space) {
				case "CMYK":
					//if ((colors_arr[0]=="0") && (colors_arr[3]=="0") && (colors_arr[2]=="0") && (colors_arr[3]=="0")) rgb_color = "transparent";
					//else rgb_color = rgb(colors_arr[0]/100, colors_arr[1]/100, colors_arr[2]/100, colors_arr[3]/100, ",", 255, 0);
					rgb_color = rgb(colors_arr[0]/100, colors_arr[1]/100, colors_arr[2]/100, colors_arr[3]/100, ",", 255, 0);
					break;
				case "RGB":
					rgb_color = d2h(colors_arr[0]) + "," + d2h(colors_arr[1]) + "," + d2h(colors_arr[2]);
					break;
				default:
					break;
			}
			if (rgb_color == "transparent") {
				rgb_colors[rgb_colors.length-1][1] = "transparent";
			}
			else {
				if (rgb_color != "") {
					var rgb_val_arr = rgb_color.split(",");
					var r = "" + rgb_val_arr[0]; if (r.length < 2) r = "0" + r;
					var g = "" + rgb_val_arr[1]; if (g.length < 2) g = "0" + g;
					var b = "" + rgb_val_arr[2]; if (b.length < 2) b = "0" + b;
					rgb_colors[rgb_colors.length-1][1] = r+g+b;
				}
				else rgb_colors[rgb_colors.length-1][1] = "";
			}
			break;
		case "1":	// from Swatch element
			if ( (name.toLowerCase() == "none") || (colorvalue == null) || (colorvalue == "") ) rgb_colors[rgb_colors.length-1][1] = "transparent";
			break;
		case "2":	// from Tint element
			try {
				var tintcolor = get_rgb_color(basecolor,tintvalue);
				if (tintcolor != "") rgb_colors[rgb_colors.length-1][1] = tintcolor;
			} catch (e) {}
			break;
		case "3":	// from Gradient element
			// not implemented
			break;
	}

	if (DEBUG > 0) java.lang.System.out.println ("-- color: '" + rgb_colors[rgb_colors.length-1]);
	return;
}
function store_grad_cmyk2rgb(id, name, clvl1, clvl2, shade1, shade2) {
	var cmyk_arr1 = clvl1.split('_');
	var cmyk_arr2 = clvl2.split('_');
	if (DEBUG > 0) {
		java.lang.System.out.println ("-- color grad 1: " + clvl1);
		java.lang.System.out.println ("-- color grad shade1: " + shade1);
		java.lang.System.out.println ("-- color grad 2: " + clvl2);
		java.lang.System.out.println ("-- color grad shade2: " + shade2);
	}
	cmyk_arr1[3] = parseFloat(cmyk_arr1[3]);
	cmyk_arr1[5] = parseFloat(cmyk_arr1[5]);
	cmyk_arr1[7] = parseFloat(cmyk_arr1[7]);
	cmyk_arr1[9] = parseFloat(cmyk_arr1[9]);
	cmyk_arr2[3] = parseFloat(cmyk_arr2[3]);
	cmyk_arr2[5] = parseFloat(cmyk_arr2[5]);
	cmyk_arr2[7] = parseFloat(cmyk_arr2[7]);
	cmyk_arr2[9] = parseFloat(cmyk_arr2[9]);
	if ((shade1 != "" ) && (parseFloat(shade1) >= 0)) {
		cmyk_arr1[3] = parseFloat(cmyk_arr1[3] * shade1 / 100);
		cmyk_arr1[5] = parseFloat(cmyk_arr1[5] * shade1 / 100);
		cmyk_arr1[7] = parseFloat(cmyk_arr1[7] * shade1 / 100);
		cmyk_arr1[9] = parseFloat(cmyk_arr1[9] * shade1 / 100);
	}
	if ((shade2 != "" ) && (parseFloat(shade2) >= 0)) {
		cmyk_arr2[3] = parseFloat(cmyk_arr2[3] * shade2 / 100);
		cmyk_arr2[5] = parseFloat(cmyk_arr2[5] * shade2 / 100);
		cmyk_arr2[7] = parseFloat(cmyk_arr2[7] * shade2 / 100);
		cmyk_arr2[9] = parseFloat(cmyk_arr2[9] * shade2 / 100);
	}
	if (DEBUG > 0) {
		java.lang.System.out.println ("-- color shaded 1: " + cmyk_arr1[3] + "," + cmyk_arr1[5] + "," + cmyk_arr1[7] + "," + cmyk_arr1[9]);
		java.lang.System.out.println ("-- color shaded 2: " + cmyk_arr2[3] + "," + cmyk_arr2[5] + "," + cmyk_arr2[7] + "," + cmyk_arr2[9]);
	}
	var c = (cmyk_arr1[3] + cmyk_arr2[3]) / 2.0;
	var m = (cmyk_arr1[5] + cmyk_arr2[5]) / 2.0;
	var y = (cmyk_arr1[7] + cmyk_arr2[7]) / 2.0;
	var k = (cmyk_arr1[9] + cmyk_arr2[9]) / 2.0;
	if (DEBUG > 0) java.lang.System.out.println ("-- color mixed: " + c + "," + m + "," + y + "," + k);

	var rgb_color = rgb(c/100, m/100, y/100, k/100, ",", 255, 0);

	var rgb_val_arr = rgb_color.split(",");
	var r = "" + rgb_val_arr[0]; if (r.length < 2) r = "0" + r;
	var g = "" + rgb_val_arr[1]; if (g.length < 2) g = "0" + g;
	var b = "" + rgb_val_arr[2]; if (b.length < 2) b = "0" + b;

	rgb_colors[rgb_colors.length] = new Array(3);
	rgb_colors[rgb_colors.length-1][0] = id;
	rgb_colors[rgb_colors.length-1][1] = r+g+b;
	rgb_colors[rgb_colors.length-1][2] = ( (name != "") ? name : ("xx_" + id) );
	if (DEBUG) {
		java.lang.System.out.println ("-- color grad id: " + rgb_colors[rgb_colors.length-1][0] + ", \"" + get_rgb_color_name(id) + "\", " + get_rgb_color(id));
		java.lang.System.out.println ();
	}
	return;
}
function get_rgb_color(id,tone) {
	if ((id == null) || (id == "")) {	// no color given == transparent
		return "";
	}
	if ((tone != null) && (tone == "0")) return ("transparent");
	for (var i = 0; i < rgb_colors.length; i++) {
		if (rgb_colors[i][0] == id) {
			// Tone values from 0 to 100%; tone value of -1 means 100%
			if ((rgb_colors[i][1] == "transparent") || (rgb_colors[i][1] == "")) return rgb_colors[i][1];
			if ((tone != null) && (tone != "") && (parseInt(tone,10) >= 0)) return (get_RGBcolorTone(rgb_colors[i][1],parseInt(tone,10)));
			return rgb_colors[i][1];
		}
	}
	// not found return no color
	return "";
}
function get_rgb_color_name(id) {
	for (var i = 0; i < rgb_colors.length; i++) {
		if (rgb_colors[i][0] == id) return rgb_colors[i][2];
	}
	return "";
}
function get_rgb_color_id(name) {
	var colorname= name.toLowerCase();
	for (var i = 0; i < rgb_colors.length; i++) {
		if (rgb_colors[i][2].toLowerCase() == colorname) return rgb_colors[i][0];
	}
	return "";
}

function get_grayscaleRGB(tone) {
	if (parseInt(tone,10) >= 100) return "000000";
	var my_tone = tone;
	if (parseInt(my_tone,10) == -1) my_tone = 100;
	var gray = "" + parseInt(255 - (255*parseFloat(my_tone)/100),10);
	var hex = d2h(gray);
	if (hex.length < 2) hex = "0" + hex;
	return "" + hex + hex + hex;
}
function get_RGBcolorTone(RGBcolor,tone) {
	if ((RGBcolor == "transparent") || (RGBcolor == "")) return RGBcolor;
	if (parseInt(tone,10) >= 100) return RGBcolor;
	if (parseInt(tone,10) == 0) return "transparent";
	if (parseInt(tone,10) <= 0) return RGBcolor;	// -1 is 100%
	var mytone = 1-parseFloat(tone)/100;

	var r = h2d(RGBcolor.substr(0,2));
	var g = h2d(RGBcolor.substr(2,2));
	var b = h2d(RGBcolor.substr(4,2));

	r = "" + parseInt( r + ((255-r)*parseFloat(mytone)),10 );
	r = d2h(r); if (r.length < 2) r = "0" + r;
	g = "" + parseInt( g + ((255-g)*parseFloat(mytone)),10 );
	g = d2h(g); if (g.length < 2) g = "0" + g;
	b = "" + parseInt( b + ((255-b)*parseFloat(mytone)),10 );
	b = d2h(b); if (b.length < 2) b = "0" + b;

	return r + g + b;
}

// Converts CMYK to RGB. CMYK values must be between 0 and 1.
// se is the delimiter, n is the RGB range and f is how many decimal places the returned values are rounded off
function rgb(c, m, y, k, se, n, f) {	// By http://file.autohotkey.net/Titan/
	var r = parseInt(Math.round((1 - (c * (1 - k) + k)) * n),10);
	var g = parseInt(Math.round((1 - (m * (1 - k) + k)) * n),10);
	var b = parseInt(Math.round((1 - (y * (1 - k) + k)) * n),10);
	return d2h(r) + se + d2h(g) + se + d2h(b);
}


// **************************
// ********** IMAGE functions
function parseMetaValue(metadata, which) {
	if ((metadata == null) || (metadata == '')) return("");
	if ((which == null) || (which == '')) return("");

	function get_value(s) {	// get value parts of "key=value" string and left/right trim the value (could be a path)
		if ((s == null) || (s == "")) return("");
		var pos = s.indexOf(": ");	// meta line like: "Copyright Notice: Copyright Notice TEXT"
		if (pos < 0) return("");
		var sv = s.substr(pos+1);
		return(sv.lrtrim());
	}

	var re = new RegExp(which+"(.)*[\r\n]","ig");
	var arr = metadata.match(re);
	if (arr && (arr.length > 0)) {
		return(get_value(arr[0]));
	}
	return("");
}

var imageInputParam = "";	/* given from transform param 'imageInputParam'
								params when IM is opening the canvas for original image like: -density 450  
								to clear all parameters, set to imageInputParam=*none*
								or
								must be individual for different input/output image formats:
								INPUT	OUTPUT		DENSITY			BACKGROUND						TRANSPARENCY
								type	type		param											param
								
								eps		jpg							-background white - flatten
										gif							-background none - flatten		-transparent black
										png			-density 300	-background none - flatten		-transparent black
										tif			-density 300	-background none - flatten		-transparent black
								pdf
								ai
								psd
								tif
								jpg
								gif
								wmf
								...		...		enhancable for any further input/output formats
								other	other	for non specified formats

								SYNTAX: Control string of above parameters:
								INPUTtype//OUTPUTtype//DENS::param//BGCLR::param//TRANS::param##...
								like a ## separated string on one line:
								eps//png//DENS::-density 150//BGCLR::-background none -flatten//TRAN:: -transparent black##
									eps//jpg//DENS:://BGCLR:://TRAN::##
								tif//jpg//DENS:://BGCLR::-background white -flatten//TRAN::##
							*/
var imageInputParamArr = new Array();	// all input/output parameters as array
/*********
 * set IM conversion default image input parameters 
 */
function set_imageInputParam_defaults() {
	imageInputParamArr = new Array();

	var inputFormatname = "eps";
	imageInputParamArr[inputFormatname]  = new Array();			// === eps to various
	imageInputParamArr[inputFormatname]["jpg"] = new Array();		// === eps to jpg
	imageInputParamArr[inputFormatname]["jpg"]["DENS"]  = "-density " + inputDensity;					// canvas input density to preset
	imageInputParamArr[inputFormatname]["jpg"]["BGCLR"] = "-background white";	// canvas background color or 'none'
	imageInputParamArr[inputFormatname]["jpg"]["TRAN"]  = "";								// image transparent color usually black
	imageInputParamArr[inputFormatname]["gif"] = new Array();		// === eps to gif
	imageInputParamArr[inputFormatname]["gif"]["DENS"]  = "-density " + inputDensity;
	imageInputParamArr[inputFormatname]["gif"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["gif"]["TRAN"]  = "-transparent black";
	imageInputParamArr[inputFormatname]["png"] = new Array();		// === eps to png
	imageInputParamArr[inputFormatname]["png"]["DENS"]  = "-density " + inputDensity;
	imageInputParamArr[inputFormatname]["png"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["png"]["TRAN"]  = "-transparent black";
	imageInputParamArr[inputFormatname]["tif"] = new Array();		// === eps to tif
	imageInputParamArr[inputFormatname]["tif"]["DENS"]  = "-density " + inputDensity;
	imageInputParamArr[inputFormatname]["tif"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["tif"]["TRAN"]  = "-transparent black";

	var inputFormatname = "pdf";
	imageInputParamArr[inputFormatname]  = new Array();			// === pdf to various
	imageInputParamArr[inputFormatname]["jpg"] = new Array();		// === pdf to jpg
	imageInputParamArr[inputFormatname]["jpg"]["DENS"]  = "-density " + inputDensity;					// canvas input density to preset
	imageInputParamArr[inputFormatname]["jpg"]["BGCLR"] = "-background white";	// canvas background color or 'none'
	imageInputParamArr[inputFormatname]["jpg"]["TRAN"]  = "";								// image transparent color usually black
	imageInputParamArr[inputFormatname]["gif"] = new Array();		// === pdf to gif
	imageInputParamArr[inputFormatname]["gif"]["DENS"]  = "-density " + inputDensity;
	imageInputParamArr[inputFormatname]["gif"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["gif"]["TRAN"]  = "-transparent black";
	imageInputParamArr[inputFormatname]["png"] = new Array();		// === pdf to png
	imageInputParamArr[inputFormatname]["png"]["DENS"]  = "-density " + inputDensity;
	imageInputParamArr[inputFormatname]["png"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["png"]["TRAN"]  = "-transparent black";
	imageInputParamArr[inputFormatname]["tif"] = new Array();		// === pdf to tif
	imageInputParamArr[inputFormatname]["tif"]["DENS"]  = "-density " + inputDensity;
	imageInputParamArr[inputFormatname]["tif"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["tif"]["TRAN"]  = "-transparent black";

	var inputFormatname = "ai";
	imageInputParamArr[inputFormatname]  = new Array();			// === ai to various
	imageInputParamArr[inputFormatname]["jpg"] = new Array();		// === ai to jpg
	imageInputParamArr[inputFormatname]["jpg"]["DENS"]  = "-density " + inputDensity;					// canvas input density to preset
	imageInputParamArr[inputFormatname]["jpg"]["BGCLR"] = "-background white";	// canvas background color or 'none'
	imageInputParamArr[inputFormatname]["jpg"]["TRAN"]  = "";								// image transparent color usually black
	imageInputParamArr[inputFormatname]["gif"] = new Array();		// === ai to gif
	imageInputParamArr[inputFormatname]["gif"]["DENS"]  = "-density " + inputDensity;
	imageInputParamArr[inputFormatname]["gif"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["gif"]["TRAN"]  = "-transparent black";
	imageInputParamArr[inputFormatname]["png"] = new Array();		// === ai to png
	imageInputParamArr[inputFormatname]["png"]["DENS"]  = "-density " + inputDensity;
	imageInputParamArr[inputFormatname]["png"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["png"]["TRAN"]  = "-transparent black";
	imageInputParamArr[inputFormatname]["tif"] = new Array();		// === ai to tif
	imageInputParamArr[inputFormatname]["tif"]["DENS"]  = "-density " + inputDensity;
	imageInputParamArr[inputFormatname]["tif"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["tif"]["TRAN"]  = "-transparent black";

	var inputFormatname = "psd";
	imageInputParamArr[inputFormatname]  = new Array();			// === psd to various
	imageInputParamArr[inputFormatname]["jpg"] = new Array();		// === psd to jpg
	imageInputParamArr[inputFormatname]["jpg"]["DENS"]  = "-density " + inputDensity;					// canvas input density to preset
	imageInputParamArr[inputFormatname]["jpg"]["BGCLR"] = "-background white";	// canvas background color or 'none'
	imageInputParamArr[inputFormatname]["jpg"]["TRAN"]  = "";								// image transparent color usually black
	imageInputParamArr[inputFormatname]["gif"] = new Array();		// === psd to gif
	imageInputParamArr[inputFormatname]["gif"]["DENS"]  = "-density " + inputDensity;
	imageInputParamArr[inputFormatname]["gif"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["gif"]["TRAN"]  = "-transparent black";
	imageInputParamArr[inputFormatname]["png"] = new Array();		// === psd to png
	imageInputParamArr[inputFormatname]["png"]["DENS"]  = "-density " + inputDensity;
	imageInputParamArr[inputFormatname]["png"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["png"]["TRAN"]  = "-transparent black";
	imageInputParamArr[inputFormatname]["tif"] = new Array();		// === psd to tif
	imageInputParamArr[inputFormatname]["tif"]["DENS"]  = "-density " + inputDensity;
	imageInputParamArr[inputFormatname]["tif"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["tif"]["TRAN"]  = "-transparent black";

	var inputFormatname = "tif";
	imageInputParamArr[inputFormatname]  = new Array();			// === tif to various
	imageInputParamArr[inputFormatname]["jpg"] = new Array();		// === tif to jpg
	imageInputParamArr[inputFormatname]["jpg"]["DENS"]  = ""		;					// canvas input density to preset
	imageInputParamArr[inputFormatname]["jpg"]["BGCLR"] = "-background white";	// canvas background color or 'none'
	imageInputParamArr[inputFormatname]["jpg"]["TRAN"]  = "";								// image transparent color usually black
	imageInputParamArr[inputFormatname]["gif"] = new Array();		// === tif to gif
	imageInputParamArr[inputFormatname]["gif"]["DENS"]  = "";
	imageInputParamArr[inputFormatname]["gif"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["gif"]["TRAN"]  = "-transparent black";
	imageInputParamArr[inputFormatname]["png"] = new Array();		// === tif to png
	imageInputParamArr[inputFormatname]["png"]["DENS"]  = "";
	imageInputParamArr[inputFormatname]["png"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["png"]["TRAN"]  = "-transparent black";
	imageInputParamArr[inputFormatname]["tif"] = new Array();		// === tif to tif
	imageInputParamArr[inputFormatname]["tif"]["DENS"]  = "";
	imageInputParamArr[inputFormatname]["tif"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["tif"]["TRAN"]  = "-transparent black";

	var inputFormatname = "wmf";
	imageInputParamArr[inputFormatname]  = new Array();			// === wmf to various
	imageInputParamArr[inputFormatname]["jpg"] = new Array();		// === wmf to jpg
	imageInputParamArr[inputFormatname]["jpg"]["DENS"]  = "";					// canvas input density to preset
	imageInputParamArr[inputFormatname]["jpg"]["BGCLR"] = "-background white";	// canvas background color or 'none'
	imageInputParamArr[inputFormatname]["jpg"]["TRAN"]  = "";								// image transparent color usually black
	imageInputParamArr[inputFormatname]["gif"] = new Array();		// === wmf to gif
	imageInputParamArr[inputFormatname]["gif"]["DENS"]  = "-density " + inputDensity;
	imageInputParamArr[inputFormatname]["gif"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["gif"]["TRAN"]  = "-transparent black";
	imageInputParamArr[inputFormatname]["png"] = new Array();		// === wmf to png
	imageInputParamArr[inputFormatname]["png"]["DENS"]  = "-density " + inputDensity;
	imageInputParamArr[inputFormatname]["png"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["png"]["TRAN"]  = "-transparent black";
	imageInputParamArr[inputFormatname]["tif"] = new Array();		// === wmf to tif
	imageInputParamArr[inputFormatname]["tif"]["DENS"]  = "-density " + inputDensity;
	imageInputParamArr[inputFormatname]["tif"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["tif"]["TRAN"]  = "-transparent black";

	var inputFormatname = "jpg";
	imageInputParamArr[inputFormatname]  = new Array();			// === jpg to various
	imageInputParamArr[inputFormatname]["jpg"] = new Array();		// === gif to jpg
	imageInputParamArr[inputFormatname]["jpg"]["DENS"]  = "";					// canvas input density to preset
	imageInputParamArr[inputFormatname]["jpg"]["BGCLR"] = "";					// canvas background color or 'none'
	imageInputParamArr[inputFormatname]["jpg"]["TRAN"]  = "";					// image transparent color usually black
	imageInputParamArr[inputFormatname]["gif"] = new Array();		// === jpg to gif
	imageInputParamArr[inputFormatname]["gif"]["DENS"]  = "";
	imageInputParamArr[inputFormatname]["gif"]["BGCLR"] = "";
	imageInputParamArr[inputFormatname]["gif"]["TRAN"]  = "";
	imageInputParamArr[inputFormatname]["png"] = new Array();		// === jpg to png
	imageInputParamArr[inputFormatname]["png"]["DENS"]  = "";
	imageInputParamArr[inputFormatname]["png"]["BGCLR"] = "";
	imageInputParamArr[inputFormatname]["png"]["TRAN"]  = "";
	imageInputParamArr[inputFormatname]["tif"] = new Array();		// === jpg to tif
	imageInputParamArr[inputFormatname]["tif"]["DENS"]  = "";
	imageInputParamArr[inputFormatname]["tif"]["BGCLR"] = "";
	imageInputParamArr[inputFormatname]["tif"]["TRAN"]  = "";

	var inputFormatname = "gif";
	imageInputParamArr[inputFormatname]  = new Array();			// === gif to various
	imageInputParamArr[inputFormatname]["jpg"] = new Array();		// === gif to jpg
	imageInputParamArr[inputFormatname]["jpg"]["DENS"]  = "";					// canvas input density to preset
	imageInputParamArr[inputFormatname]["jpg"]["BGCLR"] = "";					// canvas background color or 'none'
	imageInputParamArr[inputFormatname]["jpg"]["TRAN"]  = "";					// image transparent color usually black
	imageInputParamArr[inputFormatname]["gif"] = new Array();		// === gif to gif
	imageInputParamArr[inputFormatname]["gif"]["DENS"]  = "";
	imageInputParamArr[inputFormatname]["gif"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["gif"]["TRAN"]  = "";
	imageInputParamArr[inputFormatname]["png"] = new Array();		// === gif to png
	imageInputParamArr[inputFormatname]["png"]["DENS"]  = "";
	imageInputParamArr[inputFormatname]["png"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["png"]["TRAN"]  = "";
	imageInputParamArr[inputFormatname]["tif"] = new Array();		// === gif to tif
	imageInputParamArr[inputFormatname]["tif"]["DENS"]  = "";
	imageInputParamArr[inputFormatname]["tif"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["tif"]["TRAN"]  = "";

	var inputFormatname = "other";
	imageInputParamArr[inputFormatname]  = new Array();			// === other/unjdefined to various
	imageInputParamArr[inputFormatname]["jpg"] = new Array();		// === other to jpg
	imageInputParamArr[inputFormatname]["jpg"]["DENS"]  = "";					// canvas input density to preset
	imageInputParamArr[inputFormatname]["jpg"]["BGCLR"] = "";					// canvas background color or 'none'
	imageInputParamArr[inputFormatname]["jpg"]["TRAN"]  = "";					// image transparent color usually black
	imageInputParamArr[inputFormatname]["gif"] = new Array();		// === other to gif
	imageInputParamArr[inputFormatname]["gif"]["DENS"]  = "";
	imageInputParamArr[inputFormatname]["gif"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["gif"]["TRAN"]  = "";
	imageInputParamArr[inputFormatname]["png"] = new Array();		// === other to png
	imageInputParamArr[inputFormatname]["png"]["DENS"]  = "";
	imageInputParamArr[inputFormatname]["png"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["png"]["TRAN"]  = "";
	imageInputParamArr[inputFormatname]["tif"] = new Array();		// === other to tif
	imageInputParamArr[inputFormatname]["tif"]["DENS"]  = "";
	imageInputParamArr[inputFormatname]["tif"]["BGCLR"] = "-background none";
	imageInputParamArr[inputFormatname]["tif"]["TRAN"]  = "";

	// override from file "imagingParamameters.ctl" if available
	load_imageInputParam();
	return;
}
function load_imageInputParam() {	//load imaging parameters from file
	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) java.lang.System.out.println ("********* checking for imaging control parameters file 'XSL/imagingParamameters.ctl'");
	if (!fileExists("XSL/imagingParamameters.ctl")) return;
	var params = "" + Packages.com.epaperarchives.batchxslt.utils.readFileUTF("XSL/imagingParamameters.ctl");
	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) java.lang.System.out.println ("********* loading imaging control parameters file 'XSL/imagingParamameters.ctl'");
	if (params != "") store_imageInputParam(params);
}

function store_imageInputParam(the_imageInputParam) {	//INPUTtype//OUTPUTtype//DENS::param//BGCLR::param//TRANS::param##...

	if (the_imageInputParam == "") return;	// leave defaults
	if (the_imageInputParam == "*clear*") {
		imageInputParamArr = new Array();	// clear all
		return;
	}
	imageInputParam = the_imageInputParam;
	if (imageInputParam.indexOf("//") < 0) return;	// no valid commands
	// fill the array

	var paramsSeparator = "##";
	if (imageInputParam.indexOf(paramsSeparator) < 0) {	// no ## : also may be CR /LF instead of ##
		if (imageInputParam.indexOf("\r") >= 0) imageInputParam = imageInputParam.replace(/\r/gi,"\n");
		imageInputParam = imageInputParam.replace(/(\n)+/gi,"##");	// make one or multiple line feeds to ##
	}
	imageInputParam = imageInputParam.replace(/ +/gi," ");	// clean multiple spaces to one
	imageInputParam = imageInputParam.replace(/[\n|\r]/gi,"");	// clean line endings

	// replace variables with current values
	imageInputParam = imageInputParam.replace(/\$inputDensity\$/gi,inputDensity);	// clean line endings

	var parmsArr = imageInputParam.split(paramsSeparator);
	for (var pi = 0; pi < parmsArr.length; pi++) {
		if (parmsArr[pi] == "") continue;
		if (parmsArr[pi].indexOf("//") == 0) continue;	// commented line
		if (parmsArr[pi] == "*clear*") { imageInputParamArr = new Array(); continue; }	// should be first
		var parms = parmsArr[pi].split("//");
		if (typeof(imageInputParamArr[parms[0]]) == 'undefined') imageInputParamArr[parms[0]] = new Array();			// imageInputParamArr["eps"]
		if (typeof(imageInputParamArr[parms[0]][parms[1]]) == 'undefined') imageInputParamArr[parms[0]][parms[1]] = new Array();	// imageInputParamArr["eps"]["jpg"]

		// add like imageInputParamArr["eps"]["jpg"]["DENS"]  = "-density 150";	// canvas input density to preset
		var pp = 2;	// the parameter part (DENS - BGCLR - TRAN....)
		while (pp < parms.length) {
			imageInputParamArr[parms[0]][parms[1]][parms[pp].split("::")[0]] = parms[pp].split("::")[1];	// pp==2 => DENS,  pp==3 => BGCLR,  pp==4 => TRAN
			pp++;
		}
	}

	if ((DEBUG > 0) || (DEBUGIMAGES > 0))  {
		java.lang.System.out.println ("********* imaging control parameters:");
		for (var i in imageInputParamArr) {	// input format
			for (var o in imageInputParamArr[i]) {	// output format
				var parmline = "" + i;
				parmline += "//" + o;
				for (var d in imageInputParamArr[i][o]) {
					parmline += "//" + d + "::" + imageInputParamArr[i][o][d];
				}
				java.lang.System.out.println (parmline);
			}
		}
		java.lang.System.out.println ("********* imaging control parameters END");
	}
	return;
}
function get_imageInputParam(inputFormat,outputFormat){	// name extensions like: ('psd','gif')
	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) java.lang.System.out.println ("================== get_imageInputParam(): " + inputFormat + " to " + outputFormat);
	if (inputFormat == null) return("");
	if (outputFormat == "") return("");
	try {
		var len = 0;
		for (var k in imageInputParamArr) {
			len++;
		}
	
		if (len <= 0) return("");
		var params = "";
		if (inputFormat == "") {	// onknown - other format
			if (typeof(imageInputParamArr["other"]) == "undefined") return("");
			params += imageInputParamArr["other"][outputFormat]["DENS"];
			if ((params != "") && (imageInputParamArr["other"][outputFormat]["BGCLR"] != "")) params += " ";
			params += imageInputParamArr["other"][outputFormat]["BGCLR"];
			if ((params != "") && (imageInputParamArr["other"][outputFormat]["TRAN"] != "")) params += " ";
			params += imageInputParamArr["other"][outputFormat]["TRAN"];
			return(params);
		}
		// get defined format
		if (typeof(imageInputParamArr[inputFormat]) == "undefined") return("");
		if (typeof(imageInputParamArr[inputFormat][outputFormat]) == "undefined") return("");
	
		params += imageInputParamArr[inputFormat][outputFormat]["DENS"];
		if ((params != "") && (imageInputParamArr[inputFormat][outputFormat]["BGCLR"] != "")) params += " ";
		params += imageInputParamArr[inputFormat][outputFormat]["BGCLR"];
		if ((params != "") && (imageInputParamArr[inputFormat][outputFormat]["TRAN"] != "")) params += " ";
		params += imageInputParamArr[inputFormat][outputFormat]["TRAN"];
		if ((DEBUG > 0) || (DEBUGIMAGES > 0)) java.lang.System.out.println ("================== get_imageInputParam() params: " + params);
		return(params);
	} catch(e) {
		return("");
	}
}


var src_image_pathname = "";	// full path name
var src_imagename = "";
var target_imagename = "";
function get_image_pathname() {
	return(src_image_pathname);
}
// get filename fron link information:
// <Link ... LinkResourceURI="file:/Users/andreasimhof/Export/out/ZfK/ZfK/XSLCSS/ZfKlogo.png" ... />
// optionally ad a new name extension
function get_image_name(lnki, new_ext) {
	src_image_pathname = "";	// full path name
	if ( (lnki == null) || (lnki == "") ) {
		src_imagename = target_imagename = "";
		return "";
	}
	src_image_pathname = decodeURI(lnki);
	src_image_pathname = my_decode_URI(src_image_pathname);
	if (DEBUG > 0) {
		java.lang.System.out.println ("=============== get_image_name():");
		java.lang.System.out.println ("                image LinkURI pathname: '" + src_image_pathname + "'");
	}
	src_image_pathname = src_image_pathname.replace(/~sep~/g,"_");	// full path name
	var pathseparator = "/"; 		// init to unix
	if ((src_image_pathname.indexOf(':\\') >= 0) || (src_image_pathname.indexOf('\\\\') >= 0)) pathseparator = "\\";	// Windows style path like
	var image_path = src_image_pathname.substring(0,src_image_pathname.lastIndexOf(pathseparator));
	var image_filename = src_image_pathname.substr(src_image_pathname.lastIndexOf(pathseparator)+1);
	if (DEBUG > 0) {
		java.lang.System.out.println ("                image file path: '" + image_path + "'");
		java.lang.System.out.println ("                image file name: '" + image_filename + "'");
		java.lang.System.out.println ("                new extension: '" + new_ext + "'");
	}

//	image_filename = image_filename.replace(/\//g,":");		// image names containing a '/' must be accessed as ':' (don't ask me why)
	src_imagename = image_filename;
	if ( (new_ext != null) && (new_ext != "") ) {
		var name = image_filename;
		var lastDot = name.lastIndexOf(".");
		if (lastDot >= 0) {
			namepart = name.substring(0,lastDot);
			extpart = name.substr(lastDot+1,name.length);
			if (is_valid_image_extension(extpart)) {
				name = namepart;
			}
		}
		image_filename = name + new_ext;
	}
	target_imagename = image_filename;
	if (DEBUG > 0) {
		java.lang.System.out.println ("                target_imagename: '" + target_imagename + "'");
	}
	return(image_filename);
}
function get_imagename_extension(pathname) {
	if ((pathname == null) || (pathname == "")) return("");
	var lastDot = pathname.lastIndexOf(".");
	if (lastDot < 0) return("");
	var ext = pathname.substr(lastDot+1,pathname.length);
	// the extension could have additional layer info like image.pdf[0]
	if (ext.indexOf("[") >= 0) ext = ext.substr(0,ext.indexOf("["));
	return(ext.toLowerCase());
}
function is_valid_image_extension(ext) {
	if (ext.length < 2) return(false);
	if (ext.length > 5) return(false);
	var myext = ext.toLowerCase();
	if (myext.indexOf('tif') == 0) return (true);
	if (myext.indexOf('eps') == 0) return (true);
	if (myext.indexOf('psd') == 0) return (true);
	if (myext.indexOf('pdf') == 0) return (true);
	if (myext.indexOf('ai') == 0) return (true);
	if (myext.indexOf('jpg') == 0) return (true);
	if (myext.indexOf('png') == 0) return (true);
	if (myext.indexOf('gif') == 0) return (true);
	if (myext.indexOf('bmp') == 0) return (true);
	if (myext.indexOf('svg') == 0) return (true);
	return(false);
}
function get_image_type(lnki) {
	if ( (lnki == null) || (lnki == "") ) return "";
	var linki_arr = lnki.split('_');
	var image_type = linki_arr[11];	// like TIFF, JPEG, EPS, CompuServe GIF
	var image_type = image_type.toLowerCase();
	if (image_type.indexOf('tif') >= 0) return (".tif");
	if (image_type.indexOf('eps') >= 0) return (".eps");
	if ((image_type.indexOf('jpg') >= 0) || (image_type.indexOf('jpeg'))) return (".jpg");
	if (image_type.indexOf('gif') >= 0) return (".gif");
	return("");
}

function get_src_imagename() { return src_imagename; }
function get_target_imagename() { return target_imagename; }


var IGeo = "";
function store_IGeo(node_str) {
	IGeo = node_str;
	if (DEBUG > 0) java.lang.System.out.println ("--- store_IGeo: " + IGeo);
}
function get_IGeo() {
	return IGeo;
}
function calc_Image_igeo(box_igeo,leftCrop,topCrop,rightCrop,bottomCrop,imageTransform,boundsLeft,boundsTop,boundsRight,boundsBottom) {
	IGeo_basearr = box_igeo.split(";");	// results in: IGeo_basearr[0] = anchor points, IGeo_basearr[1] = ItemMatrix

	IGeo_boxanchorpointsarr = IGeo_basearr[0].split(" ");
	IGeo_boxmatrixsarr = IGeo_basearr[1].split(" ");	// 1 0 0 1 383.8740157480315 -298.86614173151963

	IGeo_imageanchorpointsarr = new Array( boundsLeft,boundsTop, boundsLeft,boundsBottom, boundsRight,boundsBottom, boundsRight,boundsTop );

	IGeo_imagematrixsarr = imageTransform.split(" ");	// 0.2 0 0 0.2 -64 -48

	var imageIgeo = IGeo_imageanchorpointsarr.join(" ");
	imageIgeo += ";";
	imageIgeo += IGeo_imagematrixsarr.join(" ");
	if (DEBUG > 0) {
		java.lang.System.out.println ("=============== calc_Image_igeo(): ");
		java.lang.System.out.println ("                box_igeo: " + box_igeo);
		java.lang.System.out.println ("                leftCrop: " + leftCrop);
		java.lang.System.out.println ("                topCrop: " + topCrop);
		java.lang.System.out.println ("                rightCrop: " + rightCrop);
		java.lang.System.out.println ("                bottomCrop: " + bottomCrop);
		java.lang.System.out.println ("                imageTransform: " + imageTransform);
		java.lang.System.out.println ("                image Bounds: L,T,R,B: " + boundsLeft + ", " + boundsTop + ", " + boundsRight + ", " + boundsBottom);
		java.lang.System.out.println ("      imageIgeo: " + imageIgeo);
	}
	return(imageIgeo);
}

var imagInImage_IGeo = "";
function store_imagInImage_IGeo(igeo) {
	imagInImage_IGeo = igeo;
	if (DEBUG > 0) java.lang.System.out.println ("--- store_imagInImage_IGeo: " + imagInImage_IGeo);
}
function get_imagInImage_IGeo() {
	return imagInImage_IGeo;
}

var imag_IGeo = "";
function store_imag_IGeo(node_str) {
	imag_IGeo = node_str;
	if (DEBUG > 0) java.lang.System.out.println ("--- store_imag_IGeo: " + imag_IGeo);
}
function get_imag_IGeo() {
	return imag_IGeo;
}

var imag_clnk_LnkI = "";
function store_imag_clnk_LnkI(node_str) {
	imag_clnk_LnkI = node_str;
	if (DEBUG > 0) java.lang.System.out.println ("--- store_imag_clnk_LnkI: " + imag_clnk_LnkI);
}
function get_imag_clnk_LnkI() {
	return my_decode_URI(imag_clnk_LnkI);
}

var imag_Appi = "";
function store_original_image_Appi(actualppi) {
	imag_Appi = actualppi;
	if (DEBUG > 0) java.lang.System.out.println ("--- store_original_image_Appi: " + imag_Appi);
}
function get_original_image_Appi() {
	return imag_Appi;
}

var imag_Eppi = "";
function store_original_image_Eppi(effectiveppi) {
	imag_Eppi = effectiveppi;
	if (DEBUG > 0) java.lang.System.out.println ("--- store_original_image_Eppi: " + imag_Eppi);
}
function get_original_image_Eppi() {
	return imag_Eppi;
}
function get_original_image_density_param(ad_trailing_space) {
	if (imag_Appi =="") return("");
	var imgOrgPpiX = imag_Appi.split(" ")[0];
	var imgOrgPpiY = imag_Appi.split(" ")[1];
	var param = "-density " + imgOrgPpiX + "x" + imgOrgPpiY;
	if (ad_trailing_space) param += " ";
	return(param);
}
function get_original_image_densityX() {
	if (imag_Appi =="") return("");
	var imgOrgPpiX = imag_Appi.split(" ")[0];
	return(imgOrgPpiX);
}
function get_original_image_densityY() {
	if (imag_Appi =="") return("");
	var imgOrgPpiY = imag_Appi.split(" ")[1];
	return(imgOrgPpiY);
}

function reset_IGeos() {
	IGeo = "";
	imagInImage_IGeo = "";
	imag_IGeo = "";
	imag_clnk_LnkI = "";
	imag_Appi = "";
	imag_Eppi = "";
}

// NO IMAGE DISPLACE:
// crec/@IGeo="x_19_l_1_l_4_l_2_D_70.86614173228347_D_-292.440944881126_l_2_D_70.86614173228347_D_-110.07874015671648_l_2_D_264.5669291338583_D_-110.07874015671648_l_2_D_264.5669291338583_D_-292.440944881126
//            _b_f_D_70.86614173228347_D_-292.440944881126_D_264.5669291338583_D_-110.07874015671648_D_1_D_0_D_0_D_1_D_0_D_0"
// imag/@IGeo="x_f_l_0_D_0_D_0_D_199.68_D_185.52_D_1_D_0_D_0_D_1_D_70.86614173228347_D_-292.440944881126_D_0_D_0_D_199.68_D_185.52"


// X and Y IMAGE DISPLACE:
//	crec/@IGeo="x_19_l_1_l_4_l_2_D_-99.84_D_-92.76_l_2_D_-99.84_D_92.76_l_2_D_99.84_D_92.76_l_2_D_99.84_D_-92.76_b_f_D_-99.84_D_-92.76_D_99.84_D_92.76_D_1_D_0_D_0_D_1_D_529.3873554095845_D_-81.74506518423162"
//                                                                                                                      |34left  |36top  |right  |bottom ||matrix        |Xdisplace           |Ydisplace
// 	imag/@IGeo="x_f_l_0_D_0_D_0_D_199.68_D_185.52_D_1_D_0_D_0_D_1_D_-158.99365462218293_D_-127.16832064177623_D_0_D_0_D_199.68_D_185.52"
//                                   |9       |11   |13         |19     |21                   |23
//	[9] & [29] = original imageWidth in pt
//	[11] & [31] = original imageHeight in pt
//                realImageWidth = (original imageWidth) * imageScaleX
//                realImageHeight = (original imageHeight) * imageScaleY
//	[13] = imageScaleX in %, 1.0 = 100%
//	[19] = imageScaleY in %, 1.0 = 100%
//	[21] = imageDisplaceX in pt within containing crec: image x displace = imag/@IGeo[21] - crec/@IGeo[34] = -158.99365462218293 - (-99.84) = -59.154 = shift left
//	[23] = imageDisplaceY in pt within containing crec: image y displace = imag/@IGeo[23] - crec/@IGeo[36] = -127.16832064177623 - (-92.76) = -34.408 = shift up

// next example:
// grop/IGeo="x_b_l_0_D_-505.11431884765625_D_-754.0158233642578_D_338.82025146484375_D_-645.6872100830078_D_1_D_0_D_0_D_1_D_0_D_0"
// crec/IGeo="x_19_l_1_l_4_l_2_D_-440.11431884765625_D_-754.0158233642578_l_2_D_-440.11431884765625_D_-650.5512847900391_l_2_D_338.82025146484375_D_-650.5512847900391_l_2_D_338.82025146484375_D_-754.0158233642578
//         _b_f_D_-440.11431884765625_D_-754.0158233642578_D_338.82025146484375_D_-650.5512847900391_D_1_D_-0_D_-0_D_1_D_-0_D_-0"
//  EPS/IGeo="x_f_l_0_D_71.5801010131836_D_364.6200866699219_D_540.5399780273438_D_427.2597961425781_D_1.65_D_0_D_0_D_1.65_D_-557.9120372772217_D_-1358.52647857666_D_71.5801010131836_D_364.6200866699219_D_540.5399780273438_D_427.2597961425781"
// and another:
// crec/IGeo="x_19_l_1_l_4_l_2_D_-99.84_D_-92.76_l_2_D_-99.84_D_92.76_l_2_D_36.15999999999997_D_92.76_l_2_D_36.15999999999997_D_-92.76
//         _b_f_D_-99.84_D_-92.76_D_36.15999999999997_D_92.76_D_1_D_0_D_0_D_1_D_124.84000000000003_D_-243.22538014486156"
//            x_19_l_1_l_4_l_2_D_-601.4500291957874_D_-447.7212175343758_l_2_D_-601.4500291957874_D_-313.2064869318816_l_2_D_-399.6779332920461_D_-313.2064869318816_l_2_D_-399.6779332920461_D_-447.7212175343758
//         _b_f_D_-601.4500291957874_D_-447.7212175343758_D_-399.6779332920461_D_-313.2064869318816_D_1_D_0_D_0_D_1_D_608.2531788020865_D_26.77633564537581
// Igeo of image may com in 2 array legth!!!   f or > f if preceeded by path info
//                                                                    imag/IGeo="x_f_l_0_D_0_D_0_D_199.68_D_185.52_D_1_D_0_D_0_D_1_D_-158.99365462218293_D_-127.16832064177623_D_0_D_0_D_199.68_D_185.52"
// imag/IGeo="x_1d_l_1_l_4_l_2_D_0_D_56_l_2_D_0_D_0_l_2_D_154_D_0_l_2_D_154_D_56_b_f_D_0_D_0_D_158_D_56_D_1_D_0_D_0_D_1_D_-76.5355224609375_D_-184.468017578125_D_0_D_0_D_158_D_56"

function get_normalized_IGeo(the_igeo,boxtype) {	// return a 'normalized' version of IGeo containmg measures only (no paths)
	// return an array containing measures:
	// [0] = left
	// [1] = top
	// [2] = right
	// [3] = bottom
	// [4] = matrix a (scale x)
	// [5] =        b
	// [6] =        c
	// [7] =        d (scale y)
	// [8] =        tx (x-displace)
	// [9] =        ty (y-displace)
	// [10] =       all anchor points for poligons

	if ( (the_igeo == null) || (the_igeo == "") ) return(null);

	// In the_igeo path anchor points and matrix box measures are separated by ;  (semicolon)
	// for path anchor points counter clock or counterclock wise: x1 y1 x2 y2 x3 y3 x4 y4  (4 path anchor points)
					//                                            left/top
					//                                                  left/bottom
					//                                                        right/bottom
					//                                                              right/top
	// matrix (ItemTransform): a b c d tx ty
	// results in an input igeo string: "anchor points;matrix"
	//     for a rectangle with 4 anchor points:    x1 y1 x2 y2 x3 y3 x4 y4;a b c d tx ty

	if (DEBUG > 0) {
		java.lang.System.out.println ("=============== get_normalized_IGeo():");
		java.lang.System.out.println ("                the_igeo Type: " + boxtype);
		java.lang.System.out.println ("                the_igeo: " + the_igeo);
	}
	var IGeo_arr = new Array(11);
	var IGeo_basearr = the_igeo.split(";");	// results in: IGeo_basearr[0] = anchor points, IGeo_basearr[1] = ItemMatrix
	IGeo_anchorpointsarr = IGeo_basearr[0].split(" ");
	IGeo_itemmatrixsarr = IGeo_basearr[1].split(" ");
	var left = null; //0.0;
	var top = null; //0.0;
	var right = null; //0.0;
	var bottom = null; //0.0;
	if (DEBUG > 0) java.lang.System.out.println ("                IGeo_anchorpointsarr.length: " + IGeo_anchorpointsarr.length);
	do {
		if (IGeo_anchorpointsarr.length <= 2) {	// Groups have no anchor points and if length is samller tha 2 there is no point x/y coordinates
			left = top = right = bottom = 0.0;
			break;
		}

		// get surrounding rectangle
		// get smalles x: = left
		for (var i=0; i<IGeo_anchorpointsarr.length; i+=2) if ((left == null) || (parseFloat(IGeo_anchorpointsarr[i]) < left)) left = parseFloat(IGeo_anchorpointsarr[i]);
		// get largest x: = right
		for (var i=0; i<IGeo_anchorpointsarr.length; i+=2) if ((right == null) || (parseFloat(IGeo_anchorpointsarr[i]) > right)) right = parseFloat(IGeo_anchorpointsarr[i]);
		// get smalles y: = top
		for (var i=1; i<IGeo_anchorpointsarr.length; i+=2) if ((top == null) || (parseFloat(IGeo_anchorpointsarr[i]) < top)) top = parseFloat(IGeo_anchorpointsarr[i]);
		// get largest y: = bottom
		for (var i=1; i<IGeo_anchorpointsarr.length; i+=2) if ((bottom == null) || (parseFloat(IGeo_anchorpointsarr[i]) > bottom)) bottom = parseFloat(IGeo_anchorpointsarr[i]);
	} while(false);
	// return values as array of strings
	IGeo_arr[0] = "" + left;	// left
	IGeo_arr[1] = "" + top;	// top
	IGeo_arr[2] = "" + right;	// right
	IGeo_arr[3] = "" + bottom;	// bottom
	if (IGeo_itemmatrixsarr.length >= 6) {	// the martrix
		IGeo_arr[4] = IGeo_itemmatrixsarr[0];	// a matrix = scale X
		IGeo_arr[5] = IGeo_itemmatrixsarr[1];	// b matrix sin(angle)
		IGeo_arr[6] = IGeo_itemmatrixsarr[2];	// c matrix cos(angle)
		IGeo_arr[7] = IGeo_itemmatrixsarr[3];	// d matrix = scale Y
		IGeo_arr[8] = IGeo_itemmatrixsarr[4];	// tx
		IGeo_arr[9] = IGeo_itemmatrixsarr[5];	// ty
	}
	IGeo_arr[10] = IGeo_basearr[0];			// all anchor points for poligons

	if (DEBUG > 0) java.lang.System.out.println ("                return IGeo_arr: " + IGeo_arr);
	return (IGeo_arr);
}


function get_original_imageWidth (IGeo,as_int) {	// calc unscaled image width from an EPS or imag IGeo attr
	var IGeo_arr = get_normalized_IGeo(IGeo);
	var realImageWidth = 0.0;
	// calc (right - left)
	realImageWidth = parseFloat(IGeo_arr[2]) - parseFloat(IGeo_arr[0]);
	if (as_int) return ( Math.round(realImageWidth) );
	return ( realImageWidth );
}
function get_original_imageHeight (IGeo,as_int) {	// calc unscaled image heightfrom an EPS or imag IGeo attr
	var IGeo_arr = get_normalized_IGeo(IGeo);
	var realImageHeight = 0.0;
	// calc (bottom - top)
	realImageHeight = parseFloat(IGeo_arr[3]) - parseFloat(IGeo_arr[1]);
	if (as_int) return ( Math.round(realImageHeight) );
	return ( realImageHeight );
}
function get_imageWidth (IGeo,as_int,boxScaleX) {	// calc image width from an EPS or imag IGeo attr
	var IGeo_arr = get_normalized_IGeo(IGeo);
	var realImageWidth = 0.0;
	// calc (right - left) * scaleX (matrix a)
	realImageWidth = (parseFloat(IGeo_arr[2]) - parseFloat(IGeo_arr[0])) * parseFloat(IGeo_arr[4]);
	if (boxScaleX && (boxScaleX != 1.0)) realImageWidth = realImageWidth * boxScaleX;
	if (as_int) return ( Math.round(realImageWidth) );
	return ( realImageWidth );
}
function get_imageHeight (IGeo,as_int,boxScaleY) {	// calc image heightfrom an EPS or imag IGeo attr
	var IGeo_arr = get_normalized_IGeo(IGeo);
	var realImageHeight = 0.0;
	// calc (bottom - top) * scaleY (matrix d)
	realImageHeight = (parseFloat(IGeo_arr[3]) - parseFloat(IGeo_arr[1])) * parseFloat(IGeo_arr[7]);
	if (boxScaleY && (boxScaleY != 1.0)) realImageHeight = realImageHeight * boxScaleY;
	if (as_int) return ( Math.round(realImageHeight) );
	return ( realImageHeight );
}
function get_imageLeft (imgIGeo,boxIGeo,as_int) {	// get image left pos
	var imgIGeo_arr = get_normalized_IGeo(imgIGeo);
	var boxIGeo_arr = get_normalized_IGeo(boxIGeo);
	var container_Xdisplace = parseFloat(boxIGeo_arr[8]);
	var container_Xscale = parseFloat(boxIGeo_arr[4]);
	var imgBox = new Object();
	// calc image left
	imgBox.left = 0.0;
	imgBox.top = 0.0;
	imgBox.matrix = new Array(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);	// init matrix to 'identity' a, b, c, d, tx, ty (formula above)
	// get basic left top right bottom
	imgBox.left   = parseFloat(imgIGeo_arr[0]);
	imgBox.top    = parseFloat(imgIGeo_arr[1]);
	// fill transform matrix
	imgBox.matrix[0] = parseFloat(imgIGeo_arr[4]);	// a = scale X
	imgBox.matrix[1] = parseFloat(imgIGeo_arr[5]);	// b
	imgBox.matrix[2] = parseFloat(imgIGeo_arr[6]);	// c
	imgBox.matrix[3] = parseFloat(imgIGeo_arr[7]);	// d = scale Y
	imgBox.matrix[4] = parseFloat(imgIGeo_arr[8]) * container_Xscale;	// tx
	imgBox.matrix[5] = parseFloat(imgIGeo_arr[9]);	// ty

	//java.lang.System.out.println ("%%%% get_imageLeft: " + imgBox.left + "," + imgBox.top + "  matrix: " + imgBox.matrix + "  container_Xdisplace: " + container_Xdisplace);
	imgBox.left = matrix_X (imgBox.left, imgBox.top, imgBox.matrix) + container_Xdisplace;
	//java.lang.System.out.println ("%%%% imgBox.left: " + imgBox.left);
	if (as_int) return ( Math.round(imgBox.left) );
	return ( imgBox.left );
}
function get_imageTop (imgIGeo,boxIGeo,as_int) {	// get image top pos
	var imgIGeo_arr = get_normalized_IGeo(imgIGeo);
	var boxIGeo_arr = get_normalized_IGeo(boxIGeo);
	var container_Ydisplace = parseFloat(boxIGeo_arr[9]);
	var container_Yscale = parseFloat(boxIGeo_arr[7]);
	var imgBox = new Object();
	imgBox.left = 0.0;
	imgBox.top = 0.0;
	imgBox.matrix = new Array(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);	// init matrix to 'identity' a, b, c, d, tx, ty (formula above)
	// get basic left top right bottom
	imgBox.left   = parseFloat(imgIGeo_arr[0]);	//5
	imgBox.top    = parseFloat(imgIGeo_arr[1]);	//7
	// fill transform matrix
	imgBox.matrix[0] = parseFloat(imgIGeo_arr[4]);	// a = scale X
	imgBox.matrix[1] = parseFloat(imgIGeo_arr[5]);	// b
	imgBox.matrix[2] = parseFloat(imgIGeo_arr[6]);	// c
	imgBox.matrix[3] = parseFloat(imgIGeo_arr[7]);	// d = scale Y
	imgBox.matrix[4] = parseFloat(imgIGeo_arr[8]);	// tx
	imgBox.matrix[5] = parseFloat(imgIGeo_arr[9]) * container_Yscale;	// ty
	imgBox.top = matrix_Y (imgBox.left, imgBox.top, imgBox.matrix) + container_Ydisplace;
	if (as_int) return ( Math.round(imgBox.top) );
	return ( imgBox.top );
}
function get_imageScaleX (IGeo) {	// calc image X scale
	var IGeo_arr = get_normalized_IGeo(IGeo);
	return ( parseFloat(IGeo_arr[4]) );
}
function get_imageScaleY (IGeo) {	// calc image X scale
	var IGeo_arr = get_normalized_IGeo(IGeo);
	return ( parseFloat(IGeo_arr[7]) );
}
function get_imageDisplaceX (IGeo,as_int) {	// calc image X displace
	var IGeo_arr = get_normalized_IGeo(IGeo);
	if (as_int) return ( parseInt(IGeo_arr[8],10) );
	return parseFloat(IGeo_arr[8]);
}
function get_imageDisplaceY (IGeo,as_int) {	// calc image Y displace
	var IGeo_arr = get_normalized_IGeo(IGeo);
	if (as_int) return ( parseInt(IGeo_arr[9],10) );
	return parseFloat(IGeo_arr[9]);
}


var imageExclude = new Array();
function store_imageExclude(exclude) {
	if ((exclude == null) || (exclude == "")) {
		imageExclude = new Array();
		return;
	}
	imageExclude = exclude.split(";");
}
function is_imageExclude(name) {
	if (imageExclude.length == 0) return(false);
	if ((name == null) || (name == "")) return(false);
	for (var i = 0; i < imageExclude.length; i++) {
		if (name.indexOf(imageExclude[i]) == 0) return(true);
	}
	return(false);
}


var imagePreviewFormat = new Array();
function reset_ImagePreviewFormats() {
	imagePreviewFormat = new Array();
	return;
}
function store_ImagePreviewFormats(imageWidth,imageHeight,imageFormat) {
	imagePreviewFormat[0] = imageWidth;
	imagePreviewFormat[1] = imageHeight;
	imagePreviewFormat[2] = imageFormat;	// JPEG
	return;
}
function get_ImagePreview_width() {
	if (imagePreviewFormat.length <= 0) return("");
	return(imagePreviewFormat[0]);
}
function get_ImagePreview_height() {
	if (imagePreviewFormat.length <= 0) return("");
	return(imagePreviewFormat[1]);
}
function get_ImagePreview_format() {
	if (imagePreviewFormat.length <= 0) return("");
	return(imagePreviewFormat[2]);
}

var imageScaleOriginal = "";	// the given resize factor or pixel value
var imageScale = 1.0;
var imageScaleType = "float";
var inputDensity = 150;		// image input density
var resampleDensity = 150;	// output density
var inputResampleFactor = 1.0;
var cropImages = false;
function store_imageScale(scale) {
	if ((scale == null) || (scale == "")) {
		imageScaleOriginal = "";
		imageScale = 1.0;
		imageScaleType = "float";
		return;
	}

	if (scale.indexOf(".") >= 0) {
		imageScaleOriginal = scale;
		imageScale = parseFloat(scale);	// a float resize factor like 2.0
		imageScaleType = "float";
		return;
	}
	// pixel values like widthxheight
	if (scale.indexOf("x") > 0) {	// fixed width like 125x auto calculate height
		var myscale = scale.replace(/x/gi,'');
		imageScaleOriginal = myscale;
		imageScale = 1.0;	// will be recalculated for every picture
		imageScaleType = "pixelwidth";
		return;
	}
	if (scale.indexOf("x") == 0) {	// fixed height like x200 auto calculate width
		var myscale = scale.replace(/x/gi,'');
		imageScaleOriginal = myscale;
		imageScale = 1.0;	// will be recalculated for every picture
		imageScaleType = "pixelheight";
		return;
	}
	imageScaleOriginal = scale;
	imageScale = parseFloat(scale);
	imageScaleType = "float";
}
function get_imageScale() {
	return(imageScale);
}
function get_imageScaleOriginalExtension() {
	var io = imageScaleOriginal;
	io = io.replace(/x/gi,"");
	io = io.replace(/\./gi,"_");
	return("_" + io);
}
function store_imageCrop(flag) {
	if ((flag == null) || (flag == "")) cropImages = false;
	if (flag != "0") cropImages = true;
	else cropImages = false;
}
function store_imageDPI(dpi) {
	if ((dpi == null) || (dpi == "")) return;	// leave default
	var dpi_arr = dpi.split(",");
	resampleDensity = parseInt(dpi_arr[dpi_arr.length-1],10);	// output density
	if (dpi_arr.length > 1) inputDensity = parseInt(dpi_arr[0],10);
	inputResampleFactor = inputDensity/72;
}
function get_imageInputDPI() {
	if (inputDensity == 0) return("");
	return("" + inputDensity);
}
function get_imageOutputDPI() {
	if (resampleDensity == 0) return("");
	return("" + resampleDensity);
}

function get_page_param (imgIGeo,width,height) {
	var originalImageWidth = "";
	var originalImageHeight = "";
	if (imgIGeo != "") {
		originalImageWidth = get_original_imageWidth(imgIGeo,1);
		originalImageHeight = get_original_imageHeight(imgIGeo,1);
		originalImageWidth = Math.round(parseFloat(originalImageWidth) * imageScale);
		originalImageHeight = Math.round(parseFloat(originalImageHeight) * imageScale);
	}
	else {
		if ((width != "") && (height != "")) {
			originalImageWidth = width;
			originalImageHeight = height;
		}
	}
	var param = "";
	if ((originalImageWidth != "") && (originalImageHeight != "")) {
		param = "-page " + originalImageWidth + "x" + originalImageHeight + "+0+0";
	}
	return(param);
}
function get_density_param () {
	if (inputDensity == 0) return("");
 	var param = "-density " + inputDensity;
	//java.lang.System.out.println ("  ###### get_density_param: " + param);
 	return(param);
}
function get_input_resample_param (imageName, forceNoDesitity) {
	if (resampleDensity == 0) return("");
	var imageDensityX = parseInt(get_original_image_densityX(),10);	// like 300
	var imageDensityY = parseInt(get_original_image_densityY(),10);
	// we don't have to resample if image already has the desired density (default resampleDensity == 300)
	if ((imageDensityX == inputDensity) && (imageDensityY == inputDensity)) return("");
	var density = "";
	if ((imageName != null) && (forceNoDesitity != '1')
		&& (endsWith(imageName.toLowerCase(),".tif") == false) && (endsWith(imageName.toLowerCase(),".tiff") == false)
		) density = get_original_image_density_param(true);	// for vector graphics only add -density parameter
	var param = density + "-resample " + inputDensity + "x" + inputDensity + " -density " + inputDensity;
	//java.lang.System.out.println ("  ###### get_input_resample_param: " + param);
	return(param);
}
function get_output_resample_param () {
	if (resampleDensity == 0) return("");
	var param = "-resample " + resampleDensity + "x" + resampleDensity + " -density " + resampleDensity;
	return(param);
}

var more_images = "";
function store_more_images(name) {
	more_images = name;
}
function get_more_images() {
	return(more_images);
}
function reset_more_images() {
	more_images = "";
}
var more_imagePARAMS = "";
function get_more_imagePARAMS() {
	return (more_imagePARAMS);
}
var more_imageScaleOriginal = "";
function get_more_imageScaleOriginalExtension() {
	var io = more_imageScaleOriginal;
	io = io.replace(/x/gi,"");
	io = io.replace(/\./gi,"_");
	return("_" + io);
}
function more_get_resize_crop_param (boxid,scale,imgIGeo,boxIGeo,imagInImagIGeo, imgOrigPPI, imgScaledPPI, addcropBox, doCrop) {	// create more images
	if ((scale == null) || (scale == "")) return("");
	// store original values
	var safe_imageScaleOriginal = imageScaleOriginal;
	var safe_imageScale = imageScale;
	var safe_imageScaleType = imageScaleType;

	var scaleArr = scale.split(";");
	store_imageScale(scaleArr[0]);	// store new scale for next image to create
	// store this for later use
	more_imageScaleOriginal = imageScaleOriginal;
	if (scaleArr.length > 1) more_imagePARAMS = scaleArr[1];
	else more_imagePARAMS = "";

	var param = get_resize_crop_param (boxid,imgIGeo,boxIGeo,imagInImagIGeo, imgOrigPPI, imgScaledPPI, addcropBox, doCrop);
	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
		java.lang.System.out.println ("  ######   SCALE 2nd IMAGE - scale: " + scale);
		java.lang.System.out.println ("           imageScaleOriginal: " + imageScaleOriginal);
		java.lang.System.out.println ("           more_imageScaleOriginal: " + more_imageScaleOriginal);
		java.lang.System.out.println ("           imageScale: " + imageScale);
		java.lang.System.out.println ("           imageScaleType: " + imageScaleType);
	}
	// restore original values
	imageScaleOriginal = safe_imageScaleOriginal;
	imageScale = safe_imageScale;
	imageScaleType = safe_imageScaleType;
	return(param);
}


/* new version for ImageMAgick 6.5 which seems to handle crop differently
 calc crop/cut for an image placed in a box. the box is the viewable frame over the image on the InDesign page
 adjust crop with image resample and Indesign measure: density/72*IndesignMeasure = new width=300/72*88
 The resulting command for ImageMAgick should be like this:
 convert -verbose -flatten 28_01hinweis.eps -resample 300x300 -crop 366x479+25+42! -resize 88x115! -quality 90 -colorspace RGB zzz_28_01hinweis.jpg

*/
var image_do_rotate = 0;
function store_imageDoRotate(val) {
	if ((val == null) || (val == "") || isNaN(val)) return;
	image_do_rotate = parseInt(val,10);
	return;
}
var cut_image2contentbox = true;	//cut to imag box, false to cut to image itself
function store_cut_image2contentbox(val) {
	if ((val == null) || (val == "") || isNaN) return;
	if (parseInt(val,10) > 0) cut_image2contentbox = true;
	else cut_image2contentbox = false;
	return;
}

var imgContainer = null;	// the image itself - not the image box containing it
function get_imgContainer_angle() {
	if (imgContainer == null) return(0);
	return(imgContainer.angle);
}
function get_imgContainer_scaleX() {
	if (imgContainer == null) return(1);
	return(imgContainer.scaleX);
}
function get_imgContainer_scaleY() {
	if (imgContainer == null) return(1);
	return(imgContainer.scaleY);
}
function get_imgContainer_displaceX() {
	if (imgContainer == null) return(0);
	return(imgContainer.displaceX);
}
function get_imgContainer_displaceY() {
	if (imgContainer == null) return(0);
	return(imgContainer.displaceY);
}

function get_resize_crop_param (boxid,imgIGeo,boxIGeo,imagInImagIGeo, imgOrigPPI, imgScaledPPI, addcropBox, doCrop) {	// create a '-resize WxH -crop WxH{+-}x{+-}y' parameter string for ImageMagick's convert
	// imgOrigPPI from @Appi = Image original PPI - @Appi="rx_2_D_300_D_300" attrib in <imag> element
	// imgOrimgScaledPPI from @Eppi = Image PPI when scaled - @Eppi="rx_2_D_1500_D_6000"
	// AppiX/EppiX = image original scale X 300/1500 = 0.2 
	// AppiY/EppiY = image original scale Y 300/6000 = 0.05 

	if (imgIGeo == null || boxIGeo == null) return("");
	if ((DEBUG > 0) || (DEBUGIMAGES > 0))  {
		java.lang.System.out.println ("************* getting get_resize_crop_param for boxid '" + boxid + "', is_valid: " + aBox.is_valid + "', aBox.boxid: " + aBox.boxid);
		if (aBox && (aBox.boxid == boxid) && (aBox.is_valid == true)) {	// show container box
			java.lang.System.out.println ("    Parent image box: " + aBox.boxid + ", type: " + aBox.boxtype + ", angle: " + aBox.angle + ", scaleX: " + aBox.scaleX + ", scaleY: " + aBox.scaleY);
		}
		java.lang.System.out.println ("    imgIGeo: " + imgIGeo + "\n    boxIGeo: " + boxIGeo + "\n    imagInImagIGeo: " + imagInImagIGeo);
		java.lang.System.out.println ("    imgOrigPPI: " + imgOrigPPI + "\n    imgScaledPPI: " + imgScaledPPI);
		java.lang.System.out.println ("    addcropBox: " + addcropBox);
	}

	var scale_param = "";
	var rotate_param = "";
	var crop_param = "";
	var resample_param = "";
	var resize_param = "";

	var imageOrigScaleX = 1.0;
	var imageOrigScaleY = 1.0;
	if ((imgOrigPPI && (imgOrigPPI != "")) && (imgScaledPPI && (imgScaledPPI != ""))) {
		var imgOrgPpiX = imgOrigPPI.split(" ")[0];
		var imgOrgPpiY = imgOrigPPI.split(" ")[1];
		var imgScaledPpiX = imgScaledPPI.split(" ")[0];
		var imgScaledPpiY = imgScaledPPI.split(" ")[1];
		imageOrigScaleX = parseInt(imgOrgPpiX,10) / parseInt(imgScaledPpiX,10);
		imageOrigScaleY = parseInt(imgOrgPpiY,10) / parseInt(imgScaledPpiY,10);
	}

	var cont_box_left = 0.0;
	var cont_box_top = 0.0;
	var cont_box_right = 0.0;
	var cont_box_bottom = 0.0;
	var sXsY = null;	// scale X[0] and Y[1] return array


	// the image itself - not the image box
	var imgContainer_geom_arr = get_normalized_IGeo(imgIGeo,'imag');
	imgContainer = new Object();
	imgContainer.real_left = imgContainer_geom_arr[0];		// left
	imgContainer.real_top = imgContainer_geom_arr[1];		// top
	imgContainer.real_right = imgContainer_geom_arr[2];	// right
	imgContainer.real_bottom = imgContainer_geom_arr[3];	// bottom
	imgContainer.matrix = new Array(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
	imgContainer.matrix[0] = parseFloat(imgContainer_geom_arr[4]);	// scale X
	imgContainer.matrix[1] = parseFloat(imgContainer_geom_arr[5]);	// -sinX(angle) CCW
	imgContainer.matrix[2] = parseFloat(imgContainer_geom_arr[6]);	// sinY(angle) CW
	imgContainer.matrix[3] = parseFloat(imgContainer_geom_arr[7]);	// scaleY
	imgContainer.matrix[4] = parseFloat(imgContainer_geom_arr[8]);	// tx displace X
	imgContainer.matrix[5] = parseFloat(imgContainer_geom_arr[9]);	// ty displace Y
	imgContainer.angle = getAngleFromMatrix(imgContainer.matrix);	// angle in degrees
	sXsY = getScaleFromMatrix(imgContainer.matrix, false);
	imgContainer.scaleX = sXsY[0];
	imgContainer.scaleY = sXsY[1];
	imgContainer.displaceX = 0.0;	// real image displace within image box
	imgContainer.displaceY = 0.0;
	/*
	java.lang.System.out.println ("------- imgContainer.angle: " + imgContainer.angle);
	java.lang.System.out.println ("        imgContainer.scaleX: " + imgContainer.scaleX);
	java.lang.System.out.println ("        imgContainer.scaleY: " + imgContainer.scaleY);
	java.lang.System.out.println ("        imageOrigScaleX: " + imageOrigScaleX);
	java.lang.System.out.println ("        imageOrigScaleY: " + imageOrigScaleY);
	*/
	// the image box containing an imgContainer
	var imgBox_geom_arr = get_normalized_IGeo(boxIGeo,'imag');
	var imgBox = new Object();
	imgBox.real_left = imgBox_geom_arr[0];		// left
	imgBox.real_top = imgBox_geom_arr[1];		// top
	imgBox.real_right = imgBox_geom_arr[2];	// right
	imgBox.real_bottom = imgBox_geom_arr[3];	// bottom
	imgBox.matrix = new Array(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
	imgBox.matrix[0] = parseFloat(imgBox_geom_arr[4]);	// scale X (rotated - not equal to original image scale)
	imgBox.matrix[1] = parseFloat(imgBox_geom_arr[5]);	// -sin(angle) X scaled by scale X!! CCW
	imgBox.matrix[2] = parseFloat(imgBox_geom_arr[6]);	// sin(angle) Y scaled by scale Y!! CW
	imgBox.matrix[3] = parseFloat(imgBox_geom_arr[7]);	// scale Y (rotated - not equal to original image scale)
	imgBox.matrix[4] = parseFloat(imgBox_geom_arr[8]);	// tx displace X
	imgBox.matrix[5] = parseFloat(imgBox_geom_arr[9]);	// ty displace Y
	imgBox.angle = getAngleFromMatrix(imgBox.matrix);	// angle in degrees
	sXsY = getScaleFromMatrix(imgBox.matrix, false);
	imgBox.scaleX = sXsY[0];
	imgBox.scaleY = sXsY[1];

	// imag in image like cpgn/cpgn/imag
	var imagInImag_geom_arr = "";
	var imagInImag = null;
	var imagInImag_angle = 0.0;	// for convenience
	var imagInImagScaleX = 1.0;
	var imagInImagScaleY = 1.0;
	if (imagInImagIGeo && (imagInImagIGeo != "")) {
		imagInImag_geom_arr = get_normalized_IGeo(imagInImagIGeo,'imag');
		imagInImag = new Object();
		imagInImag.real_left = imagInImag_geom_arr[0];		// left
		imagInImag.real_top = imagInImag_geom_arr[1];		// top
		imagInImag.real_right = imagInImag_geom_arr[2];	// right
		imagInImag.real_bottom = imagInImag_geom_arr[3];	// bottom
		imagInImag.matrix = new Array(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
		imagInImag.matrix[0] = parseFloat(imagInImag_geom_arr[4]);	// scale X
		imagInImag.matrix[1] = parseFloat(imagInImag_geom_arr[5]);	// -sinX(angle) CCW
		imagInImag.matrix[2] = parseFloat(imagInImag_geom_arr[6]);	// sinY(angle) CW
		imagInImag.matrix[3] = parseFloat(imagInImag_geom_arr[7]);	// scaleY
		imagInImag.matrix[4] = parseFloat(imagInImag_geom_arr[8]);	// tx displace X
		imagInImag.matrix[5] = parseFloat(imagInImag_geom_arr[9]);	// ty displace Y
		imagInImag.angle = imagInImag_angle = getAngleFromMatrix(imagInImag.matrix);	// angle in degrees
		sXsY = getScaleFromMatrix(imagInImag.matrix, false);
		imagInImag.scaleX = imagInImagScaleX = sXsY[0];
		imagInImag.scaleY = imagInImagScaleY = sXsY[1];
	}


	// scale, angles of groups above boxes are in
	var group1BoxScaleX = 1.0;
	var group1BoxScaleY = 1.0;
	var group2BoxScaleX = 1.0;
	var group2BoxScaleY = 1.0;
	var group3BoxScaleX = 1.0;
	var group3BoxScaleY = 1.0;
	var group4BoxScaleX = 1.0;
	var group4BoxScaleY = 1.0;
	if (aBox && (aBox.boxid == boxid) && (aBox.is_valid == true)) {	// get group scales
		if ((DEBUG > 0) || (DEBUGIMAGES > 0))  {
			java.lang.System.out.println ("       -- getting groups scales of boxid: " + aBox.boxid);
		}
		if (aBox.group1_box != null) {
			group1BoxScaleX = aBox.group1_box.scaleX;
			group1BoxScaleY = aBox.group1_box.scaleY;
		}
		if (aBox.group2_box != null) {
			group2BoxScaleX = aBox.group2_box.scaleX;
			group2BoxScaleY = aBox.group2_box.scaleY;
		}
		if (aBox.group3_box != null) {
			group3BoxScaleX = aBox.group3_box.scaleX;
			group3BoxScaleY = aBox.group3_box.scaleY;
		}
		if (aBox.group4_box != null) {
			group4BoxScaleX = aBox.group4_box.scaleX;
			group4BoxScaleY = aBox.group4_box.scaleY;
		}
	}

	// calc total scale
	var imgScaleX = imgContainer.scaleX * imgBox.scaleX * imagInImagScaleX * group1BoxScaleX * group2BoxScaleX * group3BoxScaleX * group4BoxScaleX;
	var imgScaleY = imgContainer.scaleY * imgBox.scaleY * imagInImagScaleY * group1BoxScaleY * group2BoxScaleY * group3BoxScaleY * group4BoxScaleY;
	imgScaleX = Math.round(imgScaleX * 1000000) / 1000000;	// round to 6 digits
	imgScaleY = Math.round(imgScaleY * 1000000) / 1000000;

	if ( (imgScaleX != 1.0) || (imgScaleY != 1.0) ) {
		if ( (Math.abs(1.0 - imgScaleX) > 0.001) || (Math.abs(1.0 - imgScaleY) > 0.001) ) {
			scale_param = "-scale " + (imgScaleX*100) + "%x" + (imgScaleY*100)  + "%!";
		}
	}


	// get angles of group boxes
	var group1Box_angle = 0.0;
	var group2Box_angle = 0.0;
	var group3Box_angle = 0.0;
	var group4Box_angle = 0.0;
	if (aBox && (aBox.boxid == boxid) && (aBox.is_valid == true)) {	// get group angles
		if (aBox.group1_box != null) group1Box_angle = aBox.group1_box.angle;	// angle in degrees
		if (aBox.group2_box != null) group2Box_angle = aBox.group2_box.angle;
		if (aBox.group3_box != null) group3Box_angle = aBox.group3_box.angle;
		if (aBox.group4_box != null) group4Box_angle = aBox.group4_box.angle;
	}
	var total_angle = imgBox.angle + imgContainer.angle + imagInImag_angle + group1Box_angle + group2Box_angle + group3Box_angle + group4Box_angle;
	total_angle = Math.round(total_angle * 1000000) / 1000000;	// round to 6 digits

	if ((DEBUG > 0) || (DEBUGIMAGES > 0))  {
		java.lang.System.out.println ("       Image imgIGeo: " + imgIGeo);
		java.lang.System.out.println ("       Imagebox boxIGeo: " + boxIGeo);
		if (imagInImag != null) java.lang.System.out.println ("       ImageInImage imagInImagIGeo: " + imagInImagIGeo);
		java.lang.System.out.println ("       Imagebox imgBox_geom_arr NORMALIZED: " + imgBox_geom_arr);
		java.lang.System.out.println ("       Imagebox imgContainer_geom_arr NORMALIZED: " + imgContainer_geom_arr);
		if (imagInImag != null) java.lang.System.out.println ("       ImageInImage imagInImag_geom_arr NORMALIZED: " + imgContainer_geom_arr);

		java.lang.System.out.println ("    --- angles in degrees");
		java.lang.System.out.println ("       Image angle: " + imgContainer.angle);
		java.lang.System.out.println ("             matrix: " + imgContainer.matrix);
		java.lang.System.out.println ("       Image Box angle: " + imgBox.angle);
		java.lang.System.out.println ("             matrix: " + imgBox.matrix);
		if (imagInImag != null) java.lang.System.out.println ("       ImageInImage angle: " + imagInImag.angle);
		java.lang.System.out.println ("       Groups angles: " + group1Box_angle + ", " + group2Box_angle + ", " + group3Box_angle + ", " + group4Box_angle);
		java.lang.System.out.println ("       Total angle degrees: " + total_angle);

		java.lang.System.out.println ("    --- scales");
		java.lang.System.out.println ("       Image self original PPI strings Appi: " + imgOrigPPI + ", Eppi: " + imgScaledPPI);
		java.lang.System.out.println ("       Image self original scale X: " + imageOrigScaleX + ", Y: " + imageOrigScaleY);
		java.lang.System.out.println ("       Container scale X: " + imgContainer.scaleX + ", Y: " + imgContainer.scaleY);
		java.lang.System.out.println ("       Image Box scale X: " + imgBox.scaleX + ", Y: " + imgBox.scaleY);
		if (imagInImag != null) java.lang.System.out.println ("       ImageInImage scale X: " + imagInImagScaleX + ", Y: " + imagInImagScaleY);
		java.lang.System.out.println ("       Groups scales X: " + group1BoxScaleX + ", " + group2BoxScaleX + ", " + group3BoxScaleX + ", " + group4BoxScaleX);
		java.lang.System.out.println ("       Groups scales Y: " + group1BoxScaleY + ", " + group2BoxScaleY + ", " + group3BoxScaleY + ", " + group4BoxScaleY);
		java.lang.System.out.println ("       Total scale X: " + imgScaleX + ", Y: " + imgScaleY);
	}

	// get rotation (before unrotating box)
	if ( (imgBox.angle != 0.0) || (imgContainer.angle != 0.0) || (imagInImag_angle != 0.0)) {
		rotate_param = "-rotate " + (-total_angle);
	}
	// if image is rotated: make it unrotated
	if ( imagInImag && (imagInImag_angle != 0.0) ) unrotate_box(imagInImag);
	if ( imgContainer.angle != 0.0 ) unrotate_box(imgContainer);
	if ( imgBox.angle != 0.0 ) unrotate_box(imgBox);


	// apply displaces to image
	// get imagInImag real page coords
	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
		java.lang.System.out.println ("    -----------");
		java.lang.System.out.println ("    ** real page cordinates of each single box (undisplaced and unrotated)");
	}

	// get image self real page coords
	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
		java.lang.System.out.println ("       Image imgContainer l,t,r,b: " + imgContainer.real_left + "," + imgContainer.real_top + "," + imgContainer.real_right + "," + imgContainer.real_bottom);
		java.lang.System.out.println ("                         matrix[]: " + imgContainer.matrix);
	}
	get_box_pageRealCoords (imgContainer,imgContainer.matrix);
	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
		java.lang.System.out.println ("                  on page l,t,r,b: " + imgContainer.real_left + "," + imgContainer.real_top + "," + imgContainer.real_right + "," + imgContainer.real_bottom);
	}

	// get imgBox real page coords
	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
		java.lang.System.out.println ("       Image imgBox       l,t,r,b: " + imgBox.real_left + "," + imgBox.real_top + "," + imgBox.real_right + "," + imgBox.real_bottom);
		java.lang.System.out.println ("                         matrix[]: " + imgBox.matrix);
	}
	get_box_pageRealCoords (imgBox,imgBox.matrix);
	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
		java.lang.System.out.println ("                  on page l,t,r,b: " + imgBox.real_left + "," + imgBox.real_top + "," + imgBox.real_right + "," + imgBox.real_bottom);
	}

	// get imageInImage real page coords
	if (imagInImag != null) {
		if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
			java.lang.System.out.println ("       Image imagInImag   l,t,r,b: " + imagInImag.real_left + "," + imagInImag.real_top + "," + imagInImag.real_right + "," + imagInImag.real_bottom);
			java.lang.System.out.println ("                         matrix[]: " + imagInImag.matrix);
		}
		get_box_pageRealCoords (imagInImag,imagInImag.matrix);
		if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
			java.lang.System.out.println ("                  on page l,t,r,b: " + imagInImag.real_left + "," + imagInImag.real_top + "," + imagInImag.real_right + "," + imagInImag.real_bottom);
		}
	}


	// --------------
	// apply page displace of all container boxes to image
	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
		java.lang.System.out.println ("    -----------");
		java.lang.System.out.println ("    ** real page cordinates of image (displaced by container boxes)");
	}
	// get image displaced by imgBox
	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
		java.lang.System.out.println ("       Image displaced by imgBox matrix[]: " + imgBox.matrix);
	}
	get_box_pageRealCoords (imgContainer,imgBox.matrix);
	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
		java.lang.System.out.println ("                  on page l,t,r,b: " + imgContainer.real_left + "," + imgContainer.real_top + "," + imgContainer.real_right + "," + imgContainer.real_bottom);
		java.lang.System.out.println ("       imgBox     on page l,t,r,b: " + aBox.real_left + "," + aBox.real_top + "," + aBox.real_right + "," + aBox.real_bottom);
	}
	// get image displaced by imagInImag
	if (imagInImag != null) {
		get_box_pageRealCoords (imgContainer,imagInImag.matrix);
		if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
			java.lang.System.out.println ("       Image displaced by imagInImag matrix[]: " + imagInImag.matrix);
			java.lang.System.out.println ("                  on page l,t,r,b: " + imgContainer.real_left + "," + imgContainer.real_top + "," + imgContainer.real_right + "," + imgContainer.real_bottom);
		}
		get_box_pageRealCoords (imgBox,imagInImag.matrix);
		if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
			java.lang.System.out.println ("       imgBox displaced by imagInImag matrix[]: " + imagInImag.matrix);
			java.lang.System.out.println ("                  on page l,t,r,b: " + imgBox.real_left + "," + imgBox.real_top + "," + imgBox.real_right + "," + imgBox.real_bottom);
		}
	}

	// get displaces of group boxes
	if (aBox && (aBox.boxid == boxid) && (aBox.is_valid == true)) {	// get group angles
		// unrotate group boxes
		if (aBox.group1_box != null) unrotate_box(aBox.group1_box);
		if (aBox.group2_box != null) unrotate_box(aBox.group2_box);
		if (aBox.group3_box != null) unrotate_box(aBox.group3_box);
		if (aBox.group4_box != null) unrotate_box(aBox.group4_box);
	}

	//	for CS5: DON'T apply displaces!!
	if (false && aBox && (aBox.boxid == boxid) && (aBox.is_valid == true)) {	// apply group matrices
		// apply matrixes of parent groups
		if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
			java.lang.System.out.println ("    -----------");
			java.lang.System.out.println ("    ** applying displaces of group boxes");
		}
		if (aBox.group1_box != null) {
			if ((DEBUG > 0) || (DEBUGIMAGES > 0)) java.lang.System.out.println ("        -- group1_box.matrix: " + aBox.group1_box.matrix);
			get_box_pageRealCoords (imgContainer,aBox.group1_box.matrix);
			if (imagInImag != null) get_box_pageRealCoords (imagInImag,aBox.group1_box.matrix);
			get_box_pageRealCoords (imgBox,aBox.group1_box.matrix);
		}
		if (aBox.group2_box != null) {
			if ((DEBUG > 0) || (DEBUGIMAGES > 0)) java.lang.System.out.println ("        -- group2_box.matrix: " + aBox.group2_box.matrix);
			get_box_pageRealCoords (imgContainer,aBox.group2_box.matrix);
			get_box_pageRealCoords (aBox,aBox.group2_box.matrix);
		}
		if (aBox.group3_box != null) {
			if ((DEBUG > 0) || (DEBUGIMAGES > 0)) java.lang.System.out.println ("        -- group3_box.matrix: " + aBox.group3_box.matrix);
			get_box_pageRealCoords (imgContainer,aBox.group3_box.matrix);
			//get_box_pageRealCoords (aBox,aBox.group3_box.matrix);
		}
		if (aBox.group4_box != null) {
			if ((DEBUG > 0) || (DEBUGIMAGES > 0)) java.lang.System.out.println ("        -- group4_box.matrix: " + aBox.group4_box.matrix);
			get_box_pageRealCoords (imgContainer,aBox.group4_box.matrix);
			//get_box_pageRealCoords (aBox,aBox.group4_box.matrix);
		}
	}

	// swap image box values if rotated
	if (imgBox.real_left > imgBox.real_right) {
		var b = imgBox.real_right; imgBox.real_right = imgBox.real_left; imgBox.real_left = b;
	}
	if (imgBox.real_top > imgBox.real_bottom) {
		var b = imgBox.real_bottom; imgBox.real_bottom = imgBox.real_top; imgBox.real_top = b;
	}

	// get coords of image or image box
	if (cut_image2contentbox) {
		cont_box_left = imgBox.real_left;	// get values from mother box
		cont_box_top = imgBox.real_top;
		cont_box_right = imgBox.real_right;
		cont_box_bottom = imgBox.real_bottom;
	}
	else {
		cont_box_left = imgContainer.real_left;
		cont_box_top = imgContainer.real_top;
		cont_box_right = imgContainer.real_right;
		cont_box_bottom = imgContainer.real_bottom;
	}

	var cont_box_real_left = cont_box_left;	// store for later use in image displace
	var cont_box_real_top = cont_box_top;



	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
		java.lang.System.out.println ("    -----------");
		java.lang.System.out.println ("    ** resulting real coordinates");
		java.lang.System.out.println ("       Image imgBox       l,t,r,b: " + imgBox.real_left + "," + imgBox.real_top + "," + imgBox.real_right + "," + imgBox.real_bottom);
		java.lang.System.out.println ("       Image imgContainer l,t,r,b: " + imgContainer.real_left + "," + imgContainer.real_top + "," + imgContainer.real_right + "," + imgContainer.real_bottom);
		java.lang.System.out.println ("       cont_box real coords l,t,r,b: " + cont_box_left + "," + cont_box_top + "," + cont_box_right + "," + cont_box_bottom);
	}

	var contboxWidth = cont_box_right - cont_box_left;
	var contboxHeight = cont_box_bottom - cont_box_top;
	cont_box_left = Math.round(cont_box_left);
	cont_box_top = Math.round(cont_box_top);
	cont_box_right = Math.round(cont_box_right);
	cont_box_bottom = Math.round(cont_box_bottom);
	var img_left = Math.round(imgContainer.real_left);
	var img_top = Math.round(imgContainer.real_top);
	var img_right = Math.round(imgContainer.real_right);
	var img_bottom = Math.round(imgContainer.real_bottom);
	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
		java.lang.System.out.println ("       image    real coords l,t,r,b: " + img_left + "," + img_top + "," + img_right + "," + img_bottom);
	}

	var imageWidth = imgBox.real_right - imgBox.real_left;
	var imageHeight = imgBox.real_bottom - imgBox.real_top;
	var imageWidthPixels = Math.round(imageWidth * inputResampleFactor);
	var imageHeightPixels = Math.round(imageHeight * inputResampleFactor);
	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
		java.lang.System.out.println ("    -----------");
		java.lang.System.out.println ("    ** Scaling");
		java.lang.System.out.println ("       original imageContainer scale in document: X:" + imgContainer.scaleX + ", Y:" + imgContainer.scaleY);
		java.lang.System.out.println ("       original image scale in document: X:" + imageOrigScaleX + ", Y:" + imageOrigScaleY);
		java.lang.System.out.println ("       Total image scale: X:" + imgScaleX + ", Y:" + imgScaleY);
		java.lang.System.out.println ("       UNSCALED image IND Width: " + imageWidth + ", Height=" + imageHeight);
		java.lang.System.out.println ("       RESAMPLE INPUT dpi: " + inputDensity + "   factor: " + inputResampleFactor);
		java.lang.System.out.println ("       UNSCALED image PIXELS Width: " + imageWidthPixels + ", Height=" + imageHeightPixels);
		java.lang.System.out.println ("       SCALE output image original string: " + imageScaleOriginal + "   type: " + imageScaleType);
	}

	// first, see if imageScale is percent or a fix px value
	switch (imageScaleType) {
		case "float":	// this is OK
			break;
		case "pixelwidth":	// recalc desired width into a scale factor
			if (cropImages == true) imageScale = parseFloat(imageScaleOriginal) / parseFloat(contboxWidth);
			else imageScale = parseFloat(imageScaleOriginal) / parseFloat(imageWidth);
			break;
		case "pixelheight":
			if (cropImages == true) imageScale = parseFloat(imageScaleOriginal) / parseFloat(contboxHeight);
			else imageScale = parseFloat(imageScaleOriginal) / parseFloat(imageHeight);
			break;
	}
	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
		java.lang.System.out.println ("       Scale output image value: " + imageScale + "   type: " + imageScaleType);
		java.lang.System.out.println ("    -----------");
	}

	// Calc image size for resize and crop parameter
	// we do not have to crop if image frame is contained entirely in the image box container
/*	var leftCrop = (cont_box_left > img_left ? cont_box_left : img_left);
	var topCrop = (cont_box_top > img_top ? cont_box_top : img_top);
	var rightCrop = (cont_box_right < img_right ? cont_box_right : img_right);
	var bottomCrop = (cont_box_bottom < img_bottom ? cont_box_bottom : img_bottom);
	*/
	var leftCrop = cont_box_left;
	var topCrop = cont_box_top;
	var rightCrop = cont_box_right;
	var bottomCrop = cont_box_bottom;
	// if box is rotated 180 degrees

	var WidthCropUnsampled = Math.ceil((rightCrop - leftCrop) * imageScale);
	var HeightCropUnsampled = Math.ceil((bottomCrop - topCrop) * imageScale);
//	WidthCropUnsampled = Math.round(imageWidth * imageScale * imgScaleX);
//	HeightCropUnsampled = Math.round(imageHeight * imageScale * imgScaleY);

	resize_param = "-resize " + WidthCropUnsampled + "x" + HeightCropUnsampled + "!";

	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
		java.lang.System.out.println ("    -----------");
		java.lang.System.out.println ("    ** RESIZING");
		java.lang.System.out.println ("       Unsampled crop dimension: l=" + leftCrop + ", t=" + topCrop + ", r=" + rightCrop + ", b=" + bottomCrop);
		java.lang.System.out.println ("       WidthCropUnsampled: " + WidthCropUnsampled);
		java.lang.System.out.println ("       HeightCropUnsampled: " + HeightCropUnsampled);
	}


	// store originale image displaces
	imgContainer.displaceX = imgContainer.real_left - cont_box_real_left;
	imgContainer.displaceY = imgContainer.real_top - cont_box_real_top;

	// check if we actually have to crop the image
	if (get_ImagePreview_width() == "") {	// no crop for preview images
		if (true || (img_left < cont_box_left) || (img_top < cont_box_top) 
			|| (img_right > cont_box_right) || (img_bottom > cont_box_bottom) ) {
	
			var XCrop = ( cont_box_left - img_left );
			if (XCrop < 0) XCrop = 0.0;	// our Zero is at image top/left corner
			var YCrop = ( cont_box_top - img_top );
			if (YCrop < 0) YCrop = 0.0;
			XCrop = Math.floor(XCrop * inputResampleFactor);
			YCrop = Math.floor(YCrop * inputResampleFactor);
			leftCrop = Math.floor(leftCrop * inputResampleFactor);
			topCrop = Math.floor(topCrop * inputResampleFactor);
			rightCrop = Math.ceil(rightCrop * inputResampleFactor);
			bottomCrop = Math.ceil(bottomCrop * inputResampleFactor);
	
			var WidthCrop = Math.ceil(rightCrop - leftCrop);
			var HeightCrop = Math.ceil(bottomCrop - topCrop);
	
			if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
				java.lang.System.out.println ("    -----------");
				java.lang.System.out.println ("    ** CROPPING");
				java.lang.System.out.println ("       crop displace: X=" + XCrop + ", Y=" + YCrop + " pixels");
				java.lang.System.out.println ("       crop dimension: l=" + leftCrop + ", t=" + topCrop + ", r=" + rightCrop + ", b=" + bottomCrop) + " pixels";
				java.lang.System.out.println ("       crop W=" + WidthCrop + ", H=" + HeightCrop);
			}
	
			if ( (WidthCrop != imageWidth) || (HeightCrop != imageHeight) || (XCrop != 0) || (YCrop != 0) ) {
				//*****crop_param = " -crop " + WidthCrop + "x" + HeightCrop;
				crop_param = "-crop " + WidthCrop + "x" + HeightCrop;
				if (XCrop >= 0) {
					crop_param += "+" + XCrop;
				}
				else  crop_param += "" + XCrop;
				if (YCrop >= 0) {
					crop_param += "+" + YCrop;
				}
				else  crop_param += "" + YCrop;
				crop_param += "!";
			}
		}
	}

	// have to resample?
	resample_param = get_output_resample_param ();

	// create the parameter string
	var param = "";
	var paramorder = 0;
	switch (paramorder) {
		case 0:	// -scale -crop -resize
			if (scale_param != "") {
				if (param != "") param += " ";
				param += scale_param;
			}

			//java.lang.System.out.println ("********** addcropBox: " + addcropBox);
			if ((typeof(doCrop) != 'undefined') && (doCrop == '0')) crop_param = "";
			if ((cropImages == true) && (addcropBox > '0') && (crop_param != "")) {
				if (param != "") param += " ";
				param += crop_param;
			}

			if (resample_param != "") {
				if (param != "") param += " ";
				param += resample_param;
			}

			if (resize_param != "") {
				if (param != "") param += " ";
				param += resize_param;
			}
			if ( (image_do_rotate != 0) && (rotate_param != "") ) {
				if (param != "") param += " ";
				param += rotate_param;
			}
			break;
		default:
			break;
	}

	if ((DEBUG > 0) || (DEBUGIMAGES > 0)) {
		java.lang.System.out.println ("    ** IMAGEMAGICK Parameters");
		java.lang.System.out.println ("       actual image density X: " + get_original_image_densityX() + " Y:" + get_original_image_densityY());
		java.lang.System.out.println ("       overriden image density: " + get_imageInputDPI());
		java.lang.System.out.println ("       resample output image density: " + get_imageOutputDPI());
		java.lang.System.out.println ("       SCALE    param: " + scale_param);
		java.lang.System.out.println ("       CROP     param: " + crop_param);
		java.lang.System.out.println ("       RESAMPLE param: " + resample_param);
		java.lang.System.out.println ("       RESIZE   param: " + resize_param);
		java.lang.System.out.println ("       ROTATE   param: " + rotate_param);
		java.lang.System.out.println ("    -- FULL PARAM to ImageMagick: " + param);
	}
//	if (DEBUGIMAGES > 0) param += " -bordercolor #000000 -border 1";

	return param;
}




// **************************
// ********** BOX UTILITIES (txtf crec)
function get_box_left(igeo) {
	var c_arr = get_normalized_IGeo(igeo);

	var aBox = new Object();
	aBox.real_left = 0.0;
	aBox.real_top = 0.0;
	aBox.real_right = 0.0;
	aBox.real_bottom = 0.0;
	aBox.matrix = new Array(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);	// init matrix to 'identity' a, b, c, d, tx, ty (formula above)
	// get basic left top right bottom
	aBox.real_left   = parseFloat(c_arr[0]);
	aBox.real_top    = parseFloat(c_arr[1]);
	aBox.real_right  = parseFloat(c_arr[2]);
	aBox.real_bottom = parseFloat(c_arr[3]);
	// fill transform matrix
	aBox.matrix[0] = parseFloat(c_arr[4]);	// a
	aBox.matrix[1] = parseFloat(c_arr[5]);	// b
	aBox.matrix[2] = parseFloat(c_arr[6]);	// c
	aBox.matrix[3] = parseFloat(c_arr[7]);	// d
	aBox.matrix[4] = parseFloat(c_arr[8]);	// tx
	aBox.matrix[5] = parseFloat(c_arr[9]);	// ty
	if (aBox.matrix[0] < 0) aBox.matrix[0] = -aBox.matrix[0];	// do not allow rotation. make negative scales positive
	if (aBox.matrix[3] < 0) aBox.matrix[3] = -aBox.matrix[3];

	aBox.real_left = matrix_X (aBox.real_left, aBox.real_top, aBox.matrix);

	if (DEBUG > 0) java.lang.System.out.println ("--- Box_IGeo_left[0]: " + c_arr.toString());
	return aBox.real_left;
}
function get_box_top(igeo) {
	var c_arr = get_normalized_IGeo(igeo);

	var aBox = new Object();
	aBox.real_left = 0.0;
	aBox.real_top = 0.0;
	aBox.real_right = 0.0;
	aBox.real_bottom = 0.0;
	aBox.matrix = new Array(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);	// init matrix to 'identity' a, b, c, d, tx, ty (formula above)
	// get basic left top right bottom
	aBox.real_left   = parseFloat(c_arr[0]);
	aBox.real_top    = parseFloat(c_arr[1]);
	aBox.real_right  = parseFloat(c_arr[2]);
	aBox.real_bottom = parseFloat(c_arr[3]);
	// fill transform matrix
	aBox.matrix[0] = parseFloat(c_arr[4]);	// a
	aBox.matrix[1] = parseFloat(c_arr[5]);	// b
	aBox.matrix[2] = parseFloat(c_arr[6]);	// c
	aBox.matrix[3] = parseFloat(c_arr[7]);	// d
	aBox.matrix[4] = parseFloat(c_arr[8]);	// tx
	aBox.matrix[5] = parseFloat(c_arr[9]);	// ty
	if (aBox.matrix[0] < 0) aBox.matrix[0] = -aBox.matrix[0];	// do not allow rotation. make negative scales positive
	if (aBox.matrix[3] < 0) aBox.matrix[3] = -aBox.matrix[3];

	aBox.real_top = matrix_Y (aBox.real_left, aBox.real_top, aBox.matrix);

	if (DEBUG > 0) java.lang.System.out.println ("--- Box_IGeo_top[1]: " + c_arr.toString());
	return aBox.real_top;
}
function get_box_right(igeo) {
	var c_arr = get_normalized_IGeo(igeo);

	var aBox = new Object();
	aBox.real_left = 0.0;
	aBox.real_top = 0.0;
	aBox.real_right = 0.0;
	aBox.real_bottom = 0.0;
	aBox.matrix = new Array(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);	// init matrix to 'identity' a, b, c, d, tx, ty (formula above)
	// get basic left top right bottom
	aBox.real_left   = parseFloat(c_arr[0]);
	aBox.real_top    = parseFloat(c_arr[1]);
	aBox.real_right  = parseFloat(c_arr[2]);
	aBox.real_bottom = parseFloat(c_arr[3]);
	// fill transform matrix
	aBox.matrix[0] = parseFloat(c_arr[4]);	// a
	aBox.matrix[1] = parseFloat(c_arr[5]);	// b
	aBox.matrix[2] = parseFloat(c_arr[6]);	// c
	aBox.matrix[3] = parseFloat(c_arr[7]);	// d
	aBox.matrix[4] = parseFloat(c_arr[8]);	// tx
	aBox.matrix[5] = parseFloat(c_arr[9]);	// ty
	if (aBox.matrix[0] < 0) aBox.matrix[0] = -aBox.matrix[0];	// do not allow rotation. make negative scales positive
	if (aBox.matrix[3] < 0) aBox.matrix[3] = -aBox.matrix[3];

	aBox.real_right = matrix_X (aBox.real_right, aBox.real_bottom, aBox.matrix);

	if (DEBUG > 0) java.lang.System.out.println ("--- Box_IGeo_right[2]: " + c_arr.toString());
	return aBox.real_right;
}
function get_box_bottom(igeo) {
	var c_arr = get_normalized_IGeo(igeo);

	var aBox = new Object();
	aBox.real_left = 0.0;
	aBox.real_top = 0.0;
	aBox.real_right = 0.0;
	aBox.real_bottom = 0.0;
	aBox.matrix = new Array(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);	// init matrix to 'identity' a, b, c, d, tx, ty (formula above)
	// get basic left top right bottom
	aBox.real_left   = parseFloat(c_arr[0]);
	aBox.real_top    = parseFloat(c_arr[1]);
	aBox.real_right  = parseFloat(c_arr[2]);
	aBox.real_bottom = parseFloat(c_arr[3]);
	// fill transform matrix
	aBox.matrix[0] = parseFloat(c_arr[4]);	// a
	aBox.matrix[1] = parseFloat(c_arr[5]);	// b
	aBox.matrix[2] = parseFloat(c_arr[6]);	// c
	aBox.matrix[3] = parseFloat(c_arr[7]);	// d
	aBox.matrix[4] = parseFloat(c_arr[8]);	// tx
	aBox.matrix[5] = parseFloat(c_arr[9]);	// ty
	if (aBox.matrix[0] < 0) aBox.matrix[0] = -aBox.matrix[0];	// do not allow rotation. make negative scales positive
	if (aBox.matrix[3] < 0) aBox.matrix[3] = -aBox.matrix[3];

	aBox.real_bottom = matrix_Y (aBox.real_right, aBox.real_bottom, aBox.matrix);

	if (DEBUG > 0) java.lang.System.out.println ("--- Box_IGeo_bottom[3]: " + c_arr.toString());
	return aBox.real_bottom;
}
var current_box_name = "";
function store_current_box_name(name) { current_box_name = name; }
function get_current_box_name() { return(current_box_name); }



// **************************
// ********** Rectangle stuff
var pageframing_boxsize_threshold = 1.0;
function set_pageframing_boxsize_threshold(value) {
	if ( (value == null) || (value == "") ) return;
	try {
		pageframing_boxsize_threshold = parseFloat(value);
	} catch(e) {}
	return;
}

function box_is_pageframe(boxwidth,boxheight) {	// check if box is larger 80% of page size
	if ( (boxwidth >= (pageframing_boxsize_threshold * page_width)) && (boxheight >= (pageframing_boxsize_threshold * page_height)) ) {
//java.lang.System.out.println ("############################ page framing box width/height: " + boxwidth + "/" + boxheight);
//java.lang.System.out.println ("                    ########       page_width/height: " + page_width + "/" + page_height);
		return(true);
	}
//java.lang.System.out.println ("---------------------------- no page framing box width/height: " + boxwidth + "/" + boxheight);
	return(false);
}

var articles_arr = new Array();	// array of box objects: box{page,boxid,rect}

function init_articles() {
	articles_arr.length = 0;
	return null;
}
function num_articles() {
	return articles_arr.length;
}


var last_row_added_article = -1;			// remember the row where to add chained boxes
var last_added_grouped_box = new Object();	// remember the row where to add grouped boxes
last_added_grouped_box.groupid = "";
last_added_grouped_box.row = -1;

function ad_article_box(page,boxtype,boxcontent,boxid,rect,chainidx,groupid,allgroupid,firstflowid,lastflowid,previousflowid,nextflowid,label) {
									// rect = "left,top,right,bottom"
	var i, j, r,
		coords,
		box = {
			page : page,
			type : boxtype,
			content : boxcontent,
			id : boxid,
			firstid : firstflowid,
			lastid : lastflowid,
			previousid : previousflowid,
			nextid : nextflowid,
			idx : chainidx,
			groupid : groupid,
			allgroupid : allgroupid,
			label : label,
			coords : rect
		};

	coords = rect.split(",");				// COUTION! may also be invalid for poligons like: NaN,NaN,NaN,NaN
	if (coords.length < 4) return(false);		// check valid coords
	for (i = 0; i < coords.length; i++) {
		if (isNaN(coords[i])) return(false);
	}

	try {
		//java.lang.System.out.println ("########### parseFloat coords");
		for (i=0; i< coords.length; i++) coords[i] = parseFloat(coords[i]);
		//java.lang.System.out.println ("########### Rectangle2D");
		box.rr = new java.awt.geom.Rectangle2D.Double(coords[0],coords[1],coords[2]-coords[0],coords[3]-coords[1]);	// as reals
		//java.lang.System.out.println ("########### parseInt coords");
		for (i=0; i<coords.length; i++) coords[i] = parseInt(coords[i],10);
		//java.lang.System.out.println ("########### Rectangle");
		try {
			if ((coords[0] <= java.lang.Integer.MAX_VALUE) && (coords[0] >= java.lang.Integer.MIN_VALUE)
				&& (coords[1] <= java.lang.Integer.MAX_VALUE) && (coords[1] >= java.lang.Integer.MIN_VALUE)
				&& (coords[2] <= java.lang.Integer.MAX_VALUE) && (coords[2] >= java.lang.Integer.MIN_VALUE)
				&& (coords[3] <= java.lang.Integer.MAX_VALUE) && (coords[3] >= java.lang.Integer.MIN_VALUE)
				&& ((coords[2]-coords[0]) <= java.lang.Integer.MAX_VALUE) && ((coords[2]-coords[0]) >= java.lang.Integer.MIN_VALUE)
				&& ((coords[3]-coords[1]) <= java.lang.Integer.MAX_VALUE) && ((coords[3]-coords[1]) >= java.lang.Integer.MIN_VALUE)
				) {
				box.r = new java.awt.Rectangle(coords[0],coords[1],coords[2]-coords[0],coords[3]-coords[1]);	// as integers
			}
			else {
				java.lang.System.out.println ("########### A box rectangle could not be added due to out of range coordinates.");
				return(false);
			}
		} catch (exrct) {
			java.lang.System.out.println ("########### A box rectangle could not be added due to out of range coordinates:");
			java.lang.System.out.println (exrct.message);
			return(false);
		}
		//java.lang.System.out.println ("########### Rectangle created");
		box.catching = true;	// init all boxes to do catching
	} catch (ex) {
		java.lang.System.out.println ("########### A box could not be added due to out of range coordinates");
		java.lang.System.out.println (ex.message);
		return(false);
	}

//DEBUG = 1;
	// check if box.r intersects with any of the rects contained in articles_arr
	var intersecting_row = -1,	// set to NOT intersecting
		do_break = false,
		force_new_article = false;
	do {
		do_break = false;
		if ( box.label.indexOf("*notcatched*") >= 0 ) {
			force_new_article = true;
			do_break = true;
			if (DEBUG > 0) java.lang.System.out.println ("############################ Label *notcatched*, box.id: " + box.id);
		}
		if ( box.label.indexOf("*nocatch*") >= 0 ) {
			box.catching = false;
			do_break = true;
			if (DEBUG > 0) java.lang.System.out.println ("############################ Label *nocatch*, box.id: " + box.id);
		}
		if ( box.label.indexOf("*catch*") >= 0 ) {
			box.catching = true;
			do_break = true;
			if (DEBUG > 0) java.lang.System.out.println ("############################ Label *catch*, box.id: " + box.id);
		}
		if (do_break == true) break;
		
		if ( all_no_boxcatch == true ) {
			force_new_article = true;
			box.catching = false;
			if (DEBUG > 0) java.lang.System.out.println ("############################ ALL no box catching, box.id: " + box.id);
			break;
		}
		if ( box.groupid != "" ) {	// all boxes which are in a group automatically are forced to catch
			box.catching = true;
			if (DEBUG > 0) java.lang.System.out.println ("############################ GROUPED box id " + box.id + " in group: " + box.groupid + " is catching, box.id: " + box.id);
			break;
		}
		if ( (unassigned_boxes_no_boxcatch == true) && (box.content == 'unas') ) {
			box.catching = false;
			if (DEBUG > 0) java.lang.System.out.println ("############################ unassigned box no box catching, box.id: " + box.id);
			break;
		}
		if ( (empty_boxes_no_boxcatch == true) && ( ((box.type == 'imag') && (box.content == 'empty')) || ((box.type.indexOf('text') >= 0) && (box.content == 'empty')) ) ) {
			box.catching = false;
			if (DEBUG > 0) java.lang.System.out.println ("############################ empty box no box catching, box.id: " + box.id);
			break;
		}
		if ( (image_boxes_no_boxcatch == true) && (box.type == 'imag') ) {
			box.catching = false;
			if (DEBUG > 0) java.lang.System.out.println ("############################ image box no box catching, box.id: " + box.id);
			break;
		}
		if ( (text_boxes_no_boxcatch == true) && (box.type == 'text') ) {
			box.catching = false;
			if (DEBUG > 0) java.lang.System.out.println ("############################ text box no box catching, box.id: " + box.id);
			break;
		}
		// check if box is 80% as large as page - then it is a page framing object or page background
		if ((pageframing_boxes_no_boxcatch == true) && ((box.content == 'unas') || (box.type.indexOf("text") < 0) || (box.type == 'imag')) && (box_is_pageframe(box.r.getWidth(),box.r.getHeight()) == true)) {
			box.catching = false;
			if (DEBUG > 0) java.lang.System.out.println ("############################ page framing box: id:" +box.id + " type:" + box.type + " no box catching");
			break;
		}

		if ( (chained_boxes_no_boxcatch == true)
				&& (box.type.indexOf("text") >= 0)	// for text boxes only
				&& ((box.previousid != 'n') || (box.nextid != 'n')) ) {		// previousid || nextid is non 'n' when box is in a chain
			box.catching = false;
			//if ( chainidx <= 0 ) force_new_article = true;	// force new article for first box of chain
			if (DEBUG > 0) java.lang.System.out.println ("############################ chained box no box catching, box.id: " + box.id + ", box.type: " + box.type + ", box.idx: " + box.idx + ", box.firstid: " + box.firstid + ", box.previousid: " + box.previousid + ", box.nextid: " + box.nextid + ", chainidx: " + chainidx);
			break;
		}
		if ( (chained_firstboxes_no_boxcatch == true)
				&& (box.type.indexOf("text") >= 0)	// for text boxes only
				&& ((box.previousid == 'n') || (box.nextid != 'n')) ) {		// previousid is 'n' and nextid is non 'n' when box is first in a chain
			box.catching = false;
			//if ( chainidx <= 0 ) force_new_article = true;	// force new article for first box of chain
			if (DEBUG > 0) java.lang.System.out.println ("############################ chained FIRST box no box catching, box.id: " + box.id + ", box.type: " + box.type + ", box.idx: " + box.idx + ", box.firstid: " + box.firstid + ", box.previousid: " + box.previousid + ", box.nextid: " + box.nextid + ", chainidx: " + chainidx);
			break;
		}
		if ( (chained_followingboxes_no_boxcatch == true)
				&& (box.type.indexOf("text") >= 0)	// for text boxes only
				&& (box.previousid != 'n') ) {		// non first boxes in a chain always have a previousid
			box.catching = false;
			//if ( chainidx <= 0 ) force_new_article = true;	// force new article for first box of chain
			if (DEBUG > 0) java.lang.System.out.println ("############################ chained FOLLOWING box no box catching, box.id: " + box.id + ", box.type: " + box.type + ", box.idx: " + box.idx + ", box.firstid: " + box.firstid + ", box.previousid: " + box.previousid + ", box.nextid: " + box.nextid + ", chainidx: " + chainidx);
			break;
		}
	} while (false);

	if ( chainidx <= 0 ) {	// -1 for image or 0 for a text and first box of a chain
		if ( !force_new_article ) {	// search for intersection if not forced new article
			//if ( (groupid != "") && (last_added_grouped_box.groupid == groupid) ) {	// same group as previous
			if ( is_in_parent_groups(allgroupid,last_added_grouped_box.groupid) ) {	// same group as previous
				intersecting_row = last_added_grouped_box.row;	// ad to same article row as last box
			}
			else {	// a non grouped box or grouped but not the same as the previous group
				for (i = 0; i < articles_arr.length; i++) {
					//java.lang.System.out.println ("############### " +articles_arr[i][0].page + " compared to " + box.page);
					if (articles_arr[i][0].page != box.page) continue;	// if box is on an other page
					for (j=0; j < articles_arr[i].length; j++) {
						if (articles_arr[i][j].page != box.page) continue;	// if box is on an other page
						if ( articles_arr[i][j].catching == false ) continue;	// no catch
						// outset box with catch_radius
						r = new java.awt.Rectangle(articles_arr[i][j].r);
						if (catch_radius != 0) {
							r.setBounds(r.getX() - catch_radius,r.getY() - catch_radius,r.getWidth() + 2*catch_radius,r.getHeight() + 2*catch_radius);
						}
						// check intersecting
						if (r.intersects(box.r)) {
							if (DEBUG > 0) java.lang.System.out.println ("     +++ box '" + box.id + "' intersects with: " + articles_arr[i][j].id);
							intersecting_row = i;
							break;
						}
					}
					if (intersecting_row >= 0) break;
				}
			}
		}
	}
	else {	// ad chained boxes to the same row where first box is
		if (last_row_added_article >= 0) intersecting_row = last_row_added_article;
		else intersecting_row = articles_arr.length - 1;
	}

	if (DEBUG > 0) {
		java.lang.System.out.println ("########## ad_article_box"
				+ "\n          box.page = " + box.page
				+ "\n          box.type = " + box.type
				+ "\n          box.content = " + box.content
				+ "\n          box.id = " + box.id
				+ "\n          box.firstid = " + box.firstid
				+ "\n          box.lastid = " + box.lastid
				+ "\n          box.previousid = " + box.previousid
				+ "\n          box.nextid = " + box.nextid
				+ "\n          box.idx = " + box.idx
				+ "\n          box.groupid = " + box.groupid
				+ "\n          box.allgroupid = " + box.allgroupid
				+ "\n          box.coords = " + box.coords
				+ "\n          box.catching = " + box.catching
				+ "\n          *all_no_boxcatch = " + all_no_boxcatch
				+ "\n          *unassigned_boxes_no_boxcatch = " + unassigned_boxes_no_boxcatch
				+ "\n          *empty_boxes_no_boxcatch = " + empty_boxes_no_boxcatch
				+ "\n          *image_boxes_no_boxcatch = " + image_boxes_no_boxcatch
				+ "\n          *text_boxes_no_boxcatch = " + text_boxes_no_boxcatch
				+ "\n          *chained_boxes_no_boxcatch = " + chained_boxes_no_boxcatch
				);
	}

	if ( (intersecting_row >= 0) && !force_new_article) {	// ad arect to the row with intersecting box
		articles_arr[intersecting_row][articles_arr[intersecting_row].length] = box;
		if (DEBUG > 0) java.lang.System.out.println ("     --- intersect with: " + articles_arr[intersecting_row][0].id);
		last_row_added_article = intersecting_row;
		if (allgroupid != "") last_added_grouped_box.groupid = allgroupid;
		else last_added_grouped_box.groupid = groupid;
		last_added_grouped_box.row = intersecting_row;
	}
	else {	// ad box to a new row (it is not intersecting with an existing box)
		if (DEBUG > 0) java.lang.System.out.println ("     --- NO intersect");
		articles_arr[articles_arr.length] = new Array();
		articles_arr[articles_arr.length-1][0] = box;
		last_row_added_article = articles_arr.length-1;
		if (allgroupid != "") last_added_grouped_box.groupid = allgroupid;
		else last_added_grouped_box.groupid = groupid;
		last_added_grouped_box.row = articles_arr.length-1;
	}
//DEBUG = 0;
	
	return (intersecting_row >= 0);
}


function group_articles() {
	if (group_boxes_to_articles <= 0) return;	// no grouping?
	var i = 0, j = 0, k = 0,
		l1, t1, r1, b1,
		l2, t2, r2, b2;
	
	if ( (boxes_arr == null) || (boxes_arr.length <= 0)) return;
	// get all boxes page by page
		// [0] = page_sequence
		// [1] = box_type
		// [2] = content
		// [3] = Self (id)
		// [4] = textflowid
		// [5] = coords
		// [6] = chainidx (idx in boxchain)
		// [7] = groupid (non empty if grouped)
		// [8] = width of box taken from area
		// [9] = height of box taken from area
		// [10] = original (evtl. rotated) matrix
		// [11] = unrotated matrix
		// [12] = box label
		// [13] = firstflowid
		// [14] = lastflowid
		// [15] = previousflowid
		// [16] = nextflowid
		// [17] = angle
		// [18] = shape_orig
		// [19] = bbox
		// [20] = pageJPEGScale
	//java.lang.System.out.println ("########## ADDING boxes to articles_arr - num boxes to add:" + boxes_arr.length);
	for (i = 0; i < boxes_arr.length; i++) {
		// if bounding box available use it, otherwise use coords
		//java.lang.System.out.println ("******id: " + boxes_arr[i][3] + "   bbox boxes_arr[i][19]: " + boxes_arr[i][19] + "  coords boxes_arr[i][5]: " + boxes_arr[i][5]);
		ad_article_box(boxes_arr[i][0],boxes_arr[i][1],boxes_arr[i][2],boxes_arr[i][3],(boxes_arr[i][19] != "" ? boxes_arr[i][19] : boxes_arr[i][5]),boxes_arr[i][6],boxes_arr[i][7],boxes_arr[i][21],boxes_arr[i][13],boxes_arr[i][14],boxes_arr[i][15],boxes_arr[i][16],boxes_arr[i][12],boxes_arr[i][21]);
	}
	//java.lang.System.out.println ("########## DONE ADDING boxes to articles_arr ******");
	if (articles_arr == null) {
		//java.lang.System.out.println ("       ### nothing to do with articles_arr ******");
		return;
	}
	// calc the new area containing boxes combined to an article
	// and ad this new area to the end of each row
/*
	java.lang.System.out.println ("***** group_articles: BEFORE creating union. Total articles in articles_arr: " + articles_arr.length);
	for (i = 0; i < articles_arr.length; i++) {
			java.lang.System.out.println ("   ** articles_arr #" + i);
			java.lang.System.out.println ("            boxid: " + articles_arr[i][0].id + ", type: " + articles_arr[i][0].type + ", page: " + articles_arr[i][0].page);
		for (j = 1; j < articles_arr[i].length; j++) {
			java.lang.System.out.println ("            boxid: " + articles_arr[i][j].id + ", type: " + articles_arr[i][j].type + ", page: " + articles_arr[i][j].page);
		}
	}
*/
	for (i = 0; i < articles_arr.length; i++) {
		// get first box to calc union
		var union = new Object();
		union.page = articles_arr[i][0].page;
		union.id = articles_arr[i][0].id;
		union.r = new java.awt.Rectangle(articles_arr[i][0].r);
		union.x1 = 0;
		union.y1 = 0;
		union.x2 = 0;
		union.y2 = 0;
		union.area = "";
		// get following boxes
		for (j = 1; j < articles_arr[i].length; j++) {
			union.id += "," + articles_arr[i][j].id;
			if (articles_arr[i][j].page != union.page) { // do not ad area if box is not on same page - probably is chained and on other other page
				//java.lang.System.out.println ("##### group_articles: current union.page:" + union.page + " box.page: " + articles_arr[i][j].page);
				continue;
			}
			l1 = union.r.getX();
			t1 = union.r.getY();
			r1 = l1 + union.r.getWidth();
			b1 = t1 + union.r.getHeight();

			l2 = articles_arr[i][j].r.getX();
			t2 = articles_arr[i][j].r.getY();
			r2 = l2 + articles_arr[i][j].r.getWidth();
			b2 = t2 + articles_arr[i][j].r.getHeight();

			if (l2 < l1) l1 = l2;
			if (t2 < t1) t1 = t2;
			if (r2 > r1) r1 = r2;
			if (b2 > b1) b1 = b2;
			union.r.setBounds(l1,t1,r1-l1,b1-t1);
		}
		// add the union array to end
		union.x1 = union.r.getX();
		union.y1 = union.r.getY();
		union.x2 = union.r.getX()+union.r.getWidth();
		union.y2 = union.r.getY()+union.r.getHeight();
		union.area = "" + union.x1 + "," + union.y1 + "," + union.x2 + "," + union.y2;
		articles_arr[i][articles_arr[i].length] = union;
	}
/*
	java.lang.System.out.println ("***** group_articles: AFTER creating union. Total articles in articles_arr: " + articles_arr.length);
	for (i = 0; i < articles_arr.length; i++) {
		java.lang.System.out.println ("   ** articles_arr #" + i + " boxes: " + articles_arr[i][articles_arr[i].length-1].id);
	}
*/
	if (DEBUG > 0)  {
		java.lang.System.out.println ("########## group_articles: Articles before combining: articles_arr ******");
		print_articles_arr();
	}
	//java.lang.System.out.println ("=========== recombining unions");
	// ---- recheck all articles areas for intersection and IF intersecting, then combine them into same article
	var had_intersections = true,
		security_loop_count = 0;
	while (had_intersections == true) {
		if (security_loop_count >= 1000) {
			java.lang.System.out.println ("##### Security loop break in function 'group_articles()' while recombining articles due to reached maximum of " + security_loop_count + " loops!");
			break;
		}
		had_intersections = false;
		for (i = 0; i < articles_arr.length; i++) {
			if (articles_arr[i][0].catching == false) {	// if box is non catching
				//java.lang.System.out.println ("      #### box is catching i: " + articles_arr[i][0].catching + ",  boxid: " + articles_arr[i][0].id + ", type: " + articles_arr[i][0].type);
				continue;
			}
			if (articles_arr[i][0].label.indexOf("*notcatched*") >= 0) {
				//java.lang.System.out.println ("      #### *notcatched* label i, boxid: " + articles_arr[i][0].id + ", type: " + articles_arr[i][0].type);
				continue;	// if box may not be catched
			}
	
			//java.lang.System.out.println ("   ####### union " + i + " '" + (articles_arr[i][articles_arr[i].length-1].id) + "': " + (articles_arr[i][articles_arr[i].length-1].r));
			for (j = i+1; j < articles_arr.length; j++) {
				//java.lang.System.out.println ("      #### next union: " + (articles_arr[j][articles_arr[j].length-1].r));
				if (articles_arr[j][0].catching == false) {
					//java.lang.System.out.println ("      #### box is catching j: " + articles_arr[j][0].catching + ",  boxid: " + articles_arr[j][0].id + ", type: " + articles_arr[j][0].type);
					continue;	// if box is non catching
				}
				//java.lang.System.out.println ("##### group_articles recheck: articles_arr[i][0].page:" + articles_arr[i][0].page + " articles_arr[j][0].page: " + articles_arr[j][0].page);
				if (articles_arr[i][0].page != articles_arr[j][0].page) {
					//java.lang.System.out.println ("      #### non matching pages i: " + articles_arr[i][0].page + " +, j: " + articles_arr[j][0].page);
					continue;	// if box is on an other page
				}
				if (articles_arr[j][0].label.indexOf("*notcatched*") >= 0) {
					//java.lang.System.out.println ("      #### *notcatched* label j, boxid: " + articles_arr[j][0].id + ", type: " + articles_arr[j][0].type);
					continue;	// if box may not be catched continue to catch others (don't break)
				}
				var catch_area_rect = new java.awt.Rectangle(articles_arr[i][articles_arr[i].length-1].r);
				if (catch_radius != 0) {
					catch_area_rect.setBounds(catch_area_rect.getX() - catch_radius,catch_area_rect.getY() - catch_radius,catch_area_rect.getWidth() + 2*catch_radius,catch_area_rect.getHeight() + 2*catch_radius);
				}
				/*
				java.lang.System.out.println ("######### catch_area_rect i: " + i + "   rect: " + catch_area_rect.getBounds());
				java.lang.System.out.println ("          intersects with j: " + j + "   rect: " + articles_arr[j][articles_arr[j].length-1].r);
				java.lang.System.out.println ("                      value: " + (catch_area_rect.intersects(articles_arr[j][articles_arr[j].length-1].r)));
				*/
				if (catch_area_rect.intersects(articles_arr[j][articles_arr[j].length-1].r)) {
					had_intersections = true;
					//java.lang.System.out.println ("         # intersecting unions '" + articles_arr[i][articles_arr[i].length-1].id + "': " + catch_area_rect + " AND '" + articles_arr[j][articles_arr[j].length-1].id + "': " + (articles_arr[j][articles_arr[j].length-1].r) );
					var union_area_rect = new java.awt.Rectangle(articles_arr[i][articles_arr[i].length-1].r);
					l1 = union_area_rect.getX();
					t1 = union_area_rect.getY();
					r1 = l1 + union_area_rect.getWidth();
					b1 = t1 + union_area_rect.getHeight();
		
					l2 = articles_arr[j][articles_arr[j].length-1].r.getX();
					t2 = articles_arr[j][articles_arr[j].length-1].r.getY();
					r2 = l2 + articles_arr[j][articles_arr[j].length-1].r.getWidth();
					b2 = t2 + articles_arr[j][articles_arr[j].length-1].r.getHeight();
	
					if (l2 < l1) l1 = l2;
					if (t2 < t1) t1 = t2;
					if (r2 > r1) r1 = r2;
					if (b2 > b1) b1 = b2;
					union_area_rect.setBounds(l1,t1,r1-l1,b1-t1);
					union_area = "" + l1 + "," + t1 + "," + r1 + "," + b1;
	
					//java.lang.System.out.println ("          -- new union_area_rect: " + union_area_rect );
					//java.lang.System.out.println ("          -- length with area: " + articles_arr[i].length );
					//prepare the new union of combined boxes
					var catching_union = articles_arr[i][articles_arr[i].length-1];
					catching_union = articles_arr[i][articles_arr[i].length-1];
					catching_union.r = union_area_rect;
					catching_union.x1 = l1;
					catching_union.y1 = t1;
					catching_union.x2 = r1;
					catching_union.y2 = b1;
					catching_union.area = union_area;
					// delete the union of catching box
					articles_arr[i].pop();
					//java.lang.System.out.println ("          -- length WITHOUT area: " + articles_arr[i].length );
					// add the j boxes to i boxes
					for (k = 0; k < articles_arr[j].length - 1 ; k++) {	// last one is the combined area
						//java.lang.System.out.println ("          -- combining box: '" + articles_arr[j][k].id + "' with: '" + articles_arr[i][articles_arr[i].length-1].id + "'");
						// insert at end the combining box(es)
						articles_arr[i][articles_arr[i].length] = articles_arr[j][k];
						catching_union.id += "," + articles_arr[j][k].id;
					}
					// add the new area to the end
					//java.lang.System.out.println ("             -- adding new area: '" + catching_union);
					articles_arr[i][articles_arr[i].length] = catching_union;
					//java.lang.System.out.println ("             -- new area ids: '" + catching_union.id);
					// delete the moved box
					articles_arr.splice(j,1);
					j--;
				}
			}
		}
		//java.lang.System.out.println ("########## had_intersections: " + had_intersections);
	}

	if (DEBUG > 0)  {
		java.lang.System.out.println ("########## UNSORTED: articles_arr ******");
		print_articles_arr();
	}
	//java.lang.System.out.println ("########## SORTED top down: articles_arr ******");
	// sort the boxes within an article top-down
	if (sort_boxes_by_y_position > 0) {
		for (i = 0; i < articles_arr.length; i++) {
			articles_arr[i] = sort_top_down(articles_arr[i]);
		}
		if (DEBUG > 0)  {
			java.lang.System.out.println ("########## SORTED top down: articles_arr ******");
			print_articles_arr();
		}
	}

	// sort the areas: small areas first, largest last
	//java.lang.System.out.println ("########## SORTED by area size: articles_arr ******");
	sort_article_areas(articles_arr);
	if (DEBUG > 0) {
		java.lang.System.out.println ("########## SORTED by area size: articles_arr ******");
		print_articles_arr();
	}
	//java.lang.System.out.println ("       *** group_articles DONE ******");
	return;
}

var sortbox_y_tolerance = 1.5;	// set to 0.0 to use strict top-down sorting
								// set to x.x to check for title box height too
function set_sort_box_y_tolerance(tol) {
	if (tol == null) return;
	try { sortbox_y_tolerance = parseFloat(tol); } catch(e){}
}
function sort_top_down(thearr) {
	if ((thearr == null) || (thearr.length <= 2)) return(thearr);	// we do not have to sort a single box. last one is the combined area
	var b_arr = thearr.slice(0);	// copy orig. array
/*
	java.lang.System.out.println ("**** UNsorted boxes ****");
	for (var i = 0; i < b_arr.length-1; i++) {	// last one is the combined area
		java.lang.System.out.println ("i: " + i + "    boxid: " + b_arr[i].id + "    type: " + b_arr[i].type + "    y: " + b_arr[i].rr.getY() + "    h: " + b_arr[i].rr.getHeight());
	}
	java.lang.System.out.println ("##### sorting top/down " + (b_arr.length-1) + " boxes");
*/

	// first we sort all boxes top-down
	for (var i = 0; i < b_arr.length-2; i++) {	// last one is the combined area
		for (var j = b_arr.length - 2; j > i; j--) {	// do backwards! last one is the combined area
			//java.lang.System.out.println ("---- comparing box#: " + i + " id: " + b_arr[i].id + " with box#: " + j + " id: " + b_arr[j].id);
			if (b_arr[i].page != b_arr[j].page) continue;	// if box is on an other page

			var yi = b_arr[i].rr.getY();
			var yj = b_arr[j].rr.getY();
			var ydiff = yj - yi;	// get displace from second box to first box. positive value means that second box is below first box = in correct sequence
			//java.lang.System.out.println ("---- comparing y values difference:" + ydiff);
			var do_swap = false;
			if (ydiff < 0.0) do_swap = true;	// second box must be moved up in read sequence
			//java.lang.System.out.println ("---- must swap:" + do_swap);
			if ((ydiff == 0.0) || ((sortbox_y_tolerance != 0.0) && (Math.abs(ydiff) < Math.abs(sortbox_y_tolerance)))) {	// check box heights if second box is at same y or a little bit below first box but smaller: could be a (slightly displaced) title box)
				//java.lang.System.out.println ("---- comparing height values");
				var hi = b_arr[i].rr.getHeight();
				var hj = b_arr[j].rr.getHeight();
				if ((hi / 2) > hj) do_swap = true;
				else do_swap = false;
				//java.lang.System.out.println ("---- must swap after HEIGHT check:" + do_swap);
			}
			if ( (do_swap == false) && (ydiff == 0.0) ) {	// same y position: check which one is more left
				//java.lang.System.out.println ("---- comparing left values");
				var xi = b_arr[i].rr.getX();
				var xj = b_arr[j].rr.getX();
				if (xj < xi) do_swap = true;
				//java.lang.System.out.println ("---- must swap after LEFT check:" + do_swap);
			}
			/*
			java.lang.System.out.println ("    yi: " + yi + "    yj: " + yj + "    ydiff: " + ydiff);
			java.lang.System.out.println ("    xi: " + b_arr[i].rr.getX() + "    xj: " + b_arr[j].rr.getX());
			java.lang.System.out.println ("    hi: " + b_arr[i].rr.getHeight() + "    hj: " + b_arr[j].rr.getHeight());
			java.lang.System.out.println ("    groupi: " + b_arr[i].groupid + "    groupj: " + b_arr[j].groupid);
			java.lang.System.out.println ("    typei: " + b_arr[i].type + "    typej: " + b_arr[j].type);
			java.lang.System.out.println ("---- must swap :" + do_swap);
			*/
			if (do_swap) {	// swap these two boxes even if Y is equal: this brings smaller title boxes or image titles to top
				//java.lang.System.out.println ("---- swapping box#: " + i + " id: " + b_arr[i].id + " with box#: " + j + " id: " + b_arr[j].id + " page: " + b_arr[j].page);
				var swap = b_arr[j];
				b_arr[j] = b_arr[i];
				b_arr[i] = swap;
				//java.lang.System.out.println ("---- swapped box#: " + i + " id: " + b_arr[i].id + " with box#: " + j + " id: " + b_arr[j].id + " page: " + b_arr[j].page);
			}
		}
	}
	//java.lang.System.out.println ("##### sorted top/down.");
	// now we have to restore the sequence of groups
	for (var i = 0; i < b_arr.length-3; i++) {	// last one is the combined area and the 2nd last one is the last box which must not be checked: is at correct position
		if (b_arr[i].groupid == "") continue;
		while ( (i < b_arr.length-3) && (b_arr[i].groupid == b_arr[i+1].groupid) ) i++;	// skip boxes in same group: already in top/down sequence
		if (i >= b_arr.length-3) break;	// we're done
		// check if more boxes of this group available
		for (var j = i+2; j <= b_arr.length - 2; j++) {	// last one is the combined area
														// we can ignore the box directly following j: this already is on correct position
			if (b_arr[i].groupid != b_arr[j].groupid) continue;
			if (b_arr[i].page != b_arr[j].page) continue;	// this should not happen here but check it anyways: if box is on an other page
			// we have found a box which is in same group and should be moved below the first in group
			b_arr = array_move_element(b_arr, j, i+1);
		}
	}
	/*
	java.lang.System.out.println ("**** sorted boxes ****");
	for (var i = 0; i < b_arr.length-1; i++) {	// last one is the combined area
		java.lang.System.out.println ("i: " + i + "    boxid: " + b_arr[i].id + "    type: " + b_arr[i].type + "    y: " + b_arr[i].rr.getY() + "    h: " + b_arr[i].rr.getHeight());
	}
	*/
	return(b_arr);
}
function array_move_element(thearr, fromidx, toidx) {
	if ((thearr == null) || (thearr.length <= 1)) return(thearr);	// also can not move a single array element
	if (fromidx == toidx) return(thearr);	// nothing to move
	if ((fromidx < 0) || (fromidx > thearr.length-1)) return(thearr);	// illegal index
	if ((toidx < 0) || (toidx > thearr.length-1)) return(thearr);	// illegal index

	var arr = thearr.slice(0);	// copy orig. array
	var movedelem = arr.slice(fromidx,fromidx+1);		// copy away the element to move...
	for (var i=fromidx; i < (arr.length-1); i++) {	// ...and shorten the array
		arr[i] = arr[i+1];
	}
	arr.length--;
	//separate this array
	var slice1 = new Array();	// make 2 slices
	var slice2 = new Array();
	if (toidx >= 0) slice1 = arr.slice(0,toidx);	// copies without the one at toidx
	if (toidx < arr.length) slice2 = arr.slice(toidx);

	// add the elem to be moved to first array slice
	slice1 = slice1.concat(movedelem);

	//recreate target array
	arr = slice1.concat(slice2);
	return(arr);
}

// sort the areas: small areas first, largest last. browser must have small areas first otherwise the are covered by larger ones
function sort_article_areas(a_arr) {
	if ((a_arr == null) || (a_arr.length <= 1)) return;	// we do not have to sort a single article
	for (var i = 0; i < a_arr.length-1; i++) {
		var a1 = a_arr[i][a_arr[i].length-1].area.split(',');
		var width1 = a1[2] - a1[0];
		for (var j = i+1; j < a_arr.length; j++) {
			if (a_arr[i][a_arr[i].length-1].page != a_arr[j][a_arr[j].length-1].page) break;	// page changes
			var a2 = a_arr[j][a_arr[j].length-1].area.split(',');
			var width2 = a2[2] - a2[0];
			if (width2 < width1) {	// swap these two articles
				var swap = a_arr[j];
				a_arr[j] = a_arr[i];
				a_arr[i] = swap;
			}
		}
	}
}

function print_articles_arr() {
	java.lang.System.out.println ("****** articles_arr ****** length: " + articles_arr.length);
	for (var i = 0; i < articles_arr.length; i++) {
		java.lang.System.out.println ("** boxes building an article **");
		// the last element is the combined area
		java.lang.System.out.println ("   ++ union: " + articles_arr[i][articles_arr[i].length-1].area + " // " + articles_arr[i][articles_arr[i].length-1].id);
		// get all boxes
		for (var j = 0; j < (articles_arr[i].length-1); j++) {
			var str = "   --- page:" + articles_arr[i][j].page +
						", type:" + articles_arr[i][j].type + 
						", id:" + articles_arr[i][j].id +
						", idx:" + articles_arr[i][j].idx;
						", rect:" + articles_arr[i][j].r.toString();
			java.lang.System.out.println (str);
		}
	}
	java.lang.System.out.println ("****** articles_arr end ******");
}

var articles_ptr = 0;
var article_boxes_ptr = 0;
function reset_articles_arr() {
	articles_ptr = 0;
}
function get_num_articles() {
	return articles_arr.length;
}
function get_article_page() {
	if (articles_arr.length <= 0) return -3;
	if (articles_ptr > (articles_arr.length-1)) return -4;
	return articles_arr[articles_ptr][0].page;
}
function get_article_idx() {
	return articles_ptr;
}
function next_article() {
	articles_ptr++;
	article_boxes_ptr = 0;
	if (articles_ptr <= (articles_arr.length -1)) return 0; // we have more articles
	return -1;	// no more articles
}
function get_article_coords() {
	return articles_arr[articles_ptr][articles_arr[articles_ptr].length-1].area;
}
function get_article_x1() {
	coords_arr = articles_arr[articles_ptr][articles_arr[articles_ptr].length-1].area.split(",");
	return coords_arr[0];
}
function get_article_y1() {
	coords_arr = articles_arr[articles_ptr][articles_arr[articles_ptr].length-1].area.split(",");
	return coords_arr[1];
}
function get_article_x2() {
	coords_arr = articles_arr[articles_ptr][articles_arr[articles_ptr].length-1].area.split(",");
	return coords_arr[2];
}
function get_article_y2() {
	coords_arr = articles_arr[articles_ptr][articles_arr[articles_ptr].length-1].area.split(",");
	return coords_arr[3];
}
function have_articles() {
	return (articles_arr.length - articles_ptr);
}

function get_num_article_boxes() {
	return articles_arr[articles_ptr].length - 1;	// the last one is the union box
}
function get_articlebox_idx() {
	return article_boxes_ptr;
}
function next_article_box() {
	article_boxes_ptr++;
	if (article_boxes_ptr <= (articles_arr[articles_ptr].length - 2)) return 0; // we have more boxes
	return -1;	// no more boxes
}
function get_article_boxid() {
	if (articles_arr.length <= 0) return "";
	if (article_boxes_ptr >= articles_arr[articles_ptr].length) return "";
	return articles_arr[articles_ptr][article_boxes_ptr].id;
}
function get_article_firstbox_chainid() {
	if (articles_arr.length <= 0) return "";
	if (article_boxes_ptr >= articles_arr[articles_ptr].length) return "";
	return "" + articles_arr[articles_ptr][article_boxes_ptr].firstid;
}
function get_article_previousbox_id() {
	if (articles_arr.length <= 0) return "";
	if (article_boxes_ptr >= articles_arr[articles_ptr].length) return "";
	return "" + articles_arr[articles_ptr][article_boxes_ptr].previousid;
}
function get_article_nextbox_id() {
	if (articles_arr.length <= 0) return "";
	if (article_boxes_ptr >= articles_arr[articles_ptr].length) return "";
	return "" + articles_arr[articles_ptr][article_boxes_ptr].nextid;
}
function get_article_box_chainidx() {
	if (articles_arr.length <= 0) return "";
	if (article_boxes_ptr >= articles_arr[articles_ptr].length) return "";
	return articles_arr[articles_ptr][article_boxes_ptr].idx;
}
function get_article_boxtype() {
	if (articles_arr.length <= 0) return "";
	if (article_boxes_ptr >= articles_arr[articles_ptr].length) return "";
	return articles_arr[articles_ptr][article_boxes_ptr].type;
}
function get_article_box_groupid() {
	if (articles_arr.length <= 0) return "";
	if (article_boxes_ptr >= articles_arr[articles_ptr].length) return "";
	return articles_arr[articles_ptr][article_boxes_ptr].groupid;
}
function get_article_box_allgroupid() {
	if (articles_arr.length <= 0) return "";
	if (article_boxes_ptr >= articles_arr[articles_ptr].length) return "";
	return articles_arr[articles_ptr][article_boxes_ptr].allgroupid;
}
function get_article_box_x1() {
	if (articles_arr.length <= 0) return "";
	if (article_boxes_ptr >= articles_arr[articles_ptr].length) return "";
	coords_arr = articles_arr[articles_ptr][article_boxes_ptr].coords.split(","); // coords = "left,top,right,bottom"
	return coords_arr[0];
}
function get_article_box_y1() {
	if (articles_arr.length <= 0) return "";
	if (article_boxes_ptr >= articles_arr[articles_ptr].length) return "";
	coords_arr = articles_arr[articles_ptr][article_boxes_ptr].coords.split(","); // coords = "left,top,right,bottom"
	return coords_arr[1];
}
function get_article_box_x2() {
	if (articles_arr.length <= 0) return "";
	if (article_boxes_ptr >= articles_arr[articles_ptr].length) return "";
	coords_arr = articles_arr[articles_ptr][article_boxes_ptr].coords.split(","); // coords = "left,top,right,bottom"
	return coords_arr[2];
}
function get_article_box_y2() {
	if (articles_arr.length <= 0) return "";
	if (article_boxes_ptr >= articles_arr[articles_ptr].length) return "";
	coords_arr = articles_arr[articles_ptr][article_boxes_ptr].coords.split(","); // coords = "left,top,right,bottom"
	return coords_arr[3];
}






// **************************
// ********** UTILITIES
function to_lower_case(str) { return str.toLowerCase(); }
function endsWith(str, s){
	if ( (str == null) || (str == "") ) return(false);
	if ( (s == null) || (s == "") ) return(false);
	var reg = new RegExp (s + "$");
	return reg.test(str);
}
function isEven(x) { return (x%2)?false:true; }
function isOdd(x) { return !isEven(x); }

function getFileNamePart(path,expand) {
	var mypath = path;
	var slashpos = mypath.lastIndexOf("/");
	if (slashpos < 0) slashpos = mypath.lastIndexOf("\\");	// is windows style path?
	var filename = mypath;
	if (slashpos >= 0) filename = mypath.substr(slashpos+1);
	if ((expand != null) && (expand != "")) {
		if (filename.indexOf(".") >= 0) {
			filename = filename.replace(/\./,expand+".");
		}
		else filename += expand;
	}
	return(filename);
}
function getFilePathPart(path) {
	var slashpos = path.lastIndexOf("/");
	if (slashpos < 0) slashpos = path.lastIndexOf("\\");	// is windows style path?
	if (slashpos < 0) return("");
	return(path.substr(0,slashpos+1));
}

function fileExists(filename) {
	f = new java.io.File(filename);
	if (DEBUG > 0) java.lang.System.out.println ("*** file: '" + filename + "' exists: " + f.exists());
	return f.exists();
}

function writeFile(pathname,content,overwrite) {
	var done = writeFile(pathname,content,overwrite,1);
	return( done );
}
var writeFile_ErrorDescription = "";
function writeFile_lasterror() {
	return(writeFile_ErrorDescription);
}
function writeFile(pathname,content,overwrite,append) {
	writeFile_ErrorDescription = "";
	if (overwrite == false) {
		var f = new java.io.File(pathname);
		if (f.exists() == true) return true;	// OK
	}
	var bwr = null;
	var written = true;
	var doappend = false;
	try {
		if (append == true) bwr = new java.io.BufferedWriter( new java.io.OutputStreamWriter( new java.io.FileOutputStream(pathname,true), "UTF-8" ) );
		else bwr = new java.io.BufferedWriter( new java.io.OutputStreamWriter( new java.io.FileOutputStream(pathname,false), "UTF-8" ) );
		try { bwr.write(content); }
		catch (ex) {
			written = false;
			writeFile_ErrorDescription = ex.message;
		}
	} catch (ebwr) {
		written = false;
		writeFile_ErrorDescription = ebwr.message;
	}
	finally {
		try { bwr.close(); } catch (ex) {}
	}
	return(written);
}

var storeValue = new Array(5);	// store up to 5 values
function store_Value(idx,str) {
	storeValue[idx] = str;
	return(str);
}
function restore_Value(idx) { return(storeValue[idx]); }


function lpad(str, padString, length) {
    while (str.length < length) str = padString + str;
    return str;
}

var hD="0123456789ABCDEF";
function d2h(d) {	// decimal to hex
	var h = hD.substr(d&15,1);
	while (d>15) { d>>=4; h=hD.substr(d&15,1)+h;}
	return h;
}
function h2d(h) {	// hex to decimal
	if ((h == null) || (h == "")) return(null);
	return parseInt(h,16);
}

function message(mess) {
	java.lang.System.out.println (mess);
}


// the functions xPlatformName MUST be equal to the ones in ExportCurrentDocument.jsx (DO NOT CHANGE WITHOUT ADVICE OF THE PRODUCER!!!)
function xPlatformName(uri) {
	return(xPlatformName(uri,false));
}
function xPlatformName(uri,encode) {
	if ((uri == null) || (uri == "")) return("");
	var myuri = uri;
	// make sure to translate these invalid characters: ? [ ] / \ = + * < > : ; " ,
	myuri = myuri.replace(/\?/g,"x3F");
	myuri = myuri.replace(/\[/g,"x5B");
	myuri = myuri.replace(/\]/g,"x5D");
	myuri = myuri.replace(/\//g,"x2F");
	myuri = myuri.replace(/\\/g,"x5C");
	myuri = myuri.replace(/\=/g,"x3D");
	myuri = myuri.replace(/\+/g,"x28");
	myuri = myuri.replace(/\*/g,"x2A");
	myuri = myuri.replace(/\</g,"x3C");
	myuri = myuri.replace(/\>/g,"x3E");
	myuri = myuri.replace(/\:/g,"x3A");
	myuri = myuri.replace(/\;/g,"x3B");
	myuri = myuri.replace(/\"/g,"x22");
	myuri = myuri.replace(/\,/g,"x2C");
	myuri = myuri.replace(/\'/g,"x27");

	myuri = myuri.replace(/#/g,"x23");
	myuri = myuri.replace(/\&/g,"x26");
	myuri = myuri.replace(/%/g,"x");

	// this is decomposed Unicode - have to make composed
	myuri = Packages.com.epaperarchives.batchxslt.utils.composeUnicodeNFC(myuri);
	if (encode) {
		myuri = encodeURI(myuri);
		myuri = myuri.replace(/%/g,"x");
	}

	return (myuri);
}
function my_decode_URI(uri) {
	if ((uri == null) || (uri == "")) return("");
	var myuri = uri.replace(/\%23/g,"#");
	myuri = myuri.replace(/\%26/g,"&");
	myuri = myuri.replace(/\%2B/g,"+");
	myuri = myuri.replace(/\%2C/g,",");
	//var myuri = myuri.replace(/\:/g,"\/");
	return(myuri);
}
function encode_URIjs(uri) {
	return(encode_URIjs(uri,true));
}
function encode_URIjs(uri,encode) {
	if ((uri == null) || (uri == "")) return("");
	var myuri = uri;
	if (encode) myuri = encodeURI(myuri);
	// make sure to translate these characters: ? [ ] / \ = + * < > : ; " ,
	myuri = myuri.replace(/\?/g,"%3F");
	myuri = myuri.replace(/\[/g,"%5B");
	myuri = myuri.replace(/\]/g,"%5D");
	myuri = myuri.replace(/\//g,"%2F");
	myuri = myuri.replace(/\\/g,"%5C");
	myuri = myuri.replace(/\=/g,"%3D");
	myuri = myuri.replace(/\+/g,"%28");
	myuri = myuri.replace(/\*/g,"%2A");
	myuri = myuri.replace(/\</g,"%3C");
	myuri = myuri.replace(/\>/g,"%3E");
	myuri = myuri.replace(/\:/g,"%3A");
	myuri = myuri.replace(/\;/g,"%3B");
	myuri = myuri.replace(/\"/g,"%22");
	myuri = myuri.replace(/\,/g,"%2C");

	myuri = myuri.replace(/#/g,"%23");
	myuri = myuri.replace(/\&/g,"%26");
/*
	myuri = myuri.replace(/'/g,"%27");
	myuri = myuri.replace(/\(/g,"%28");
	myuri = myuri.replace(/\)/g,"%29");
*/
	return (myuri);
}
function encode_URI(uri) {
	return (encode_URI(uri,'1','',0,false));
}
function encode_URI(uri,safe) {
	return (encode_URI(uri,safe,'',0,false));
}
// 0 or blank = do not encode leafe as is in filenames and uri
// 1 = URI encode  (%XX),
// 2 = Xplatform safe URI encode to  (xXX) -->
var max_filenname_length = 31;
function encode_URI(uri,safe,postfix,postfixlength,shorten31) {
	if ( (uri == null) || (uri == "") ) return("");
	var my_uri = encodeURI(uri);
	my_uri = my_uri.replace(/\#/g,"x23");
	my_uri = my_uri.replace(/\&/g,"x26");
	my_uri = my_uri.replace(/\?/g,"x3F");
	if ( (safe == null) || (safe == '') || (safe == '0') ) return(my_uri);
	do {
		if (safe.indexOf("2") >= 0) {
			my_uri = my_uri.replace(/\%/g,'x');
			if (my_uri.length <= 31) break;
			if ((shorten31 == null) || (shorten31 == false)) break;
			// shorten to a max length of 31 chars
			// split name and ext
			var my_name = my_uri;
			var my_ext = "";
			var pointpos = my_name.lastIndexOf(".");
			if (pointpos >= 0) {
				my_name = my_uri.substr(0,pointpos);
				my_ext = my_uri.substr(pointpos,my_uri.length - pointpos);
			}
			if (my_ext.length > 6) {	// this is not a real extension
				my_name = my_uri;
				my_ext = "";
			}
			// calc checksum
			var name_chksum = 0;
			// shorten name
			for (var i = 0; i < my_name.length; i++) name_chksum += i*my_name.charCodeAt(i);
			var name_chksum_str = "" + name_chksum;
			var mypostfix = "";
			var mypostfixstr = "";
			if ((postfix != null) && (postfix != "")) {
				mypostfix = prefixNumberString(postfix,postfixlength);
				mypostfixstr = '_' + mypostfix + '_';
			}
			var max_name_length = max_filenname_length - my_ext.length - name_chksum_str.length - mypostfixstr.length;
			my_name = my_name.substr(0,max_name_length);
			// add checksum + postfix
			my_name = my_name + mypostfixstr + name_chksum_str;
			// re-concat name and ext
			my_uri = my_name + my_ext;
		}
	} while(false);

	return (my_uri);
}
function prefixNumberString(str,len) {
	var mystr = str;
	while(mystr.length < len) mystr = "0" + mystr;
	return(mystr);
}
function set_max_filenname_length(len) {
	max_filenname_length = parseInt(len,10);
}


function safe_attr(str) {
	if ((str == null) || (str == "")) return("");
	var mystr = str;
	//mystr = mystr.replace(/\&(?!amp;)/g,"\&amp;");
	mystr = mystr.replace(/\&(?!quot;|apos;|amp;|lt;|gt;)/g,"\&amp;");
	mystr = mystr.replace(/\</g,"\&lt;");
	mystr = mystr.replace(/\>/g,"\&gt;");
	mystr = mystr.replace(/"/g,"\&quot;");
	mystr = mystr.replace(/'/g,"\&apos;");

	return (mystr);
}


function stripNameSpaceColon(str) {
	if ((str == null) || (str == "")) return("");
	return (str.replace(/:/g,"_NScolon_"));
}

function entity_fix(str) {
	if (str.length <= 0) return("");
	var mystr = str;
	if (mystr.indexOf("\&") >= 0) {	// we have amp
		do {
			mystr= mystr.replace(/\&/g,"\&amp;");	// convert all single '&' characters to &amp; if not already &amp;
			break;

			if (mystr.indexOf(";") < 0) {
				mystr= mystr.replace(/\&/g,"\&amp;");	// convert all single '&' characters to &amp; if string contains no ';'
				break;
			}
			// we have to scan the string
			var idx = 0;
			while (idx < mystr.length) {
				var amp1 = mystr.indexOf("\&",idx);
				if (amp1 < 0) break;
				var semi = mystr.indexOf(";",idx+1);
				var amp2 = mystr.indexOf("\&",idx+1);
				if ((semi > amp2) || (semi < 0)) {	// amp1 is a single '&': replace it by &amp;
					if (amp2 > amp1) {	// we have a following &
						mystr = mystr.substr(0,amp1) + "&amp;" + mystr.substr(idx+1,mystr.length-idx-1);
						idx += 5;
						continue;
					}
				}
				
				idx = amp1 + 1;
			}
		} while(false);
	}


	mystr = mystr.replace(/\</g,"\&lt;");
	mystr = mystr.replace(/\>/g,"\&gt;");

	return (mystr);
}

function escape_quote(str) {
	return (str.replace(/\'/g,"\\'"));
}

function parseToFloat(str) {
	if (str == null || str == "") return(0.0);
	try {
		return(parseFloat(str));
	}
	catch(e) {
		return(0.0);
	}
	return (0.0);
}

function parseToInt(str) {
	if (str == null || str == "") return(0);
	try {
		return(parseInt(str,10));
	}
	catch(e) {
		return(0);
	}
	return (0);
}
function round_numberString(str) {
	var point_idx = str.indexOf(".");
	if (point_idx < 0) return (str);
	return (str.substr(0,point_idx));
}

function isNumeric(sText) {
	if ((sText == null) || (sText == "")) return(false);
	var ValidChars = "0123456789.";
	var IsNumber = true;
	var Char;

	for (i = 0; (i < sText.length) && (IsNumber == true); i++) { 
		if (ValidChars.indexOf(sText.charAt(i)) == -1) IsNumber = false;
	}
	return IsNumber;
}

function compareVersionStrings(str1,str2) {	// compare 6.3.3 to 6.3.1
	// returns:
	// -1 if str1 < str2
	// 0  if str1 = str2
	// 1  if str1 > str2
	if (str1 == null || str1 == "") return(0);
	if (str2 == null || str2 == "") return(0);

	var str1_arr = str1.split(".");
	var str2_arr = str2.split(".");

	for (var i = 0; i < str1_arr.length; i++) {
		if (str1_arr[i] < str2_arr[i]) return(-1);
		if (str1_arr[i] > str2_arr[i]) return(1);
		if ((i >= str1_arr.length-1) || (i >= str2_arr.length-1)) {
			if (str1_arr.length == str2_arr.length) return(0);
			if (str1_arr.length < str2_arr.length) return(-1);
			if (str1_arr.length > str2_arr.length) return(1);
		}
	}

	return (0);
}

function getDate() {
	var cur_date = new Date();
	var m = "" + (cur_date.getMonth()+1);
	if (m.length != 2) m = "0" + m;
	var d = "" + cur_date.getDate();
	if (d.length != 2) d = "0" + d;
	var creation_date = "" + cur_date.getFullYear() + m + d;
	return (creation_date);
}
function getYear() {
	var cur_date = new Date();
	return ("" + cur_date.getFullYear());
}
function getTime() {
	var cur_date = new Date();
	var h = "" + cur_date.getHours(); if (h.length != 2) h = "0" + h;
	var m = "" + cur_date.getMinutes(); if (m.length != 2) m = "0" + m;
	var s = "" + cur_date.getSeconds(); if (s.length != 2) s = "0" + s;
	creation_time = "" + h + ":" + m + ":" + s;
	return("" + creation_time) ;
}

function clean(str) {	// return a cleaned string
	if ((str == null) || (str == "")) return ("");
	var cstr = str;
	var re = /\r/g;
	cstr = cstr.replace(re,"");
	re = /\n/g;
	cstr = cstr.replace(re,"");
	
	return (cstr);
}

function cleanSeparator(str) {	// remove ~sep~
	if ((str == null) || (str == "")) return ("");
	var cstr = str.replace(/~sep~/g,'_');
	return (cstr);
}

function cleanMagick(str) {	// return a cleaned string
	if ((str == null) || (str == "")) return ("");
	var cstr = str.replace(/~sep~/g,'_');
	cstr = cstr.replace(/~blnk~/g," ");
	return (cstr);
}

function escapeMagick(str) {
	if ((str == null) || (str == "")) return ("");
	var newstr = str;
//	newstr = newstr.replace(/-/g,'\\-');
	newstr = newstr.replace(/\|/g,'\\|');
//	newstr = newstr.replace(/%/g,'\\%');
//	newstr = newstr.replace(/\*/g,'\\*');

	newstr = newstr.replace(/ /g,'~blnk~');	// MUST be (LAST) to transfer arguments to JAVA routine -->
	return (newstr);
}

function removePercent(str) {
	if (str == "") return(str);
	if (str.indexOf("%") != 0) return(str);
	// remove starting %
	return (str.substr(1,str.length));
}

function createParamString(p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13,p14,p15,p16,p17,p18,p19,p20) {
	var param = "";
	if (p1 && (p1 != "")) param += p1;
	if (p2 && (p2 != "")) param += ((param != "") ? " " : "") + p2;
	if (p3 && (p3 != "")) param += ((param != "") ? " " : "") + p3;
	if (p4 && (p4 != "")) param += ((param != "") ? " " : "") + p4;
	if (p5 && (p5 != "")) param += ((param != "") ? " " : "") + p5;
	if (p6 && (p6 != "")) param += ((param != "") ? " " : "") + p6;
	if (p7 && (p7 != "")) param += ((param != "") ? " " : "") + p7;
	if (p8 && (p8 != "")) param += ((param != "") ? " " : "") + p8;
	if (p9 && (p9 != "")) param += ((param != "") ? " " : "") + p9;
	if (p10 && (p10 != "")) param += ((param != "") ? " " : "") + p10;
	if (p11 && (p11 != "")) param += ((param != "") ? " " : "") + p11;
	if (p12 && (p12 != "")) param += ((param != "") ? " " : "") + p12;
	if (p13 && (p13 != "")) param += ((param != "") ? " " : "") + p13;
	if (p14 && (p14 != "")) param += ((param != "") ? " " : "") + p14;
	if (p15 && (p15 != "")) param += ((param != "") ? " " : "") + p15;
	if (p16 && (p16 != "")) param += ((param != "") ? " " : "") + p16;
	if (p17 && (p17 != "")) param += ((param != "") ? " " : "") + p17;
	if (p18 && (p18 != "")) param += ((param != "") ? " " : "") + p18;
	if (p19 && (p19 != "")) param += ((param != "") ? " " : "") + p19;
	if (p20 && (p20 != "")) param += ((param != "") ? " " : "") + p20;
	return (param);
}

function make_internet_name(name) {
	var newname = name;
	newname = xPlatformName(newname,false);
	// now shorten to max 31 characters
	//java.lang.System.out.println (newname);
	if (newname.length <= 31) return(newname);
	var charsToCut = newname.length - 31;
	var namepart = "";
	var extpart = "";
	var lastDot = newname.lastIndexOf(".");
	if (lastDot >= 0) {
		namepart = newname.substring(0,lastDot);
		extpart = newname.substr(lastDot+1,newname.length);
	}
	//java.lang.System.out.println (namepart + "  |  " + extpart);
	namepart = namepart.substring(0,namepart.length-charsToCut);
	if (extpart == "") return(namepart);
	return (namepart + "." + extpart);
}

function get_valign(str) {
	if (str == "") return("top");
	if (str == "TopAlign") return("top");
	if (str == "CenterAlign") return("middle");
	if (str == "BottomAlign") return("bottom");
	//if (str == "JustifyAlign") return("middle");
	return ("top");
}

function create_new_name(filename, name_part) {
	return(create_new_name(filename, name_part, null));
}
function create_new_name(filename, name_part, pagenumber) {
	var pos = filename.lastIndexOf(".");	// cut filename extension
	var name = filename;
	var ext = "";
	var page = "";
	if (pagenumber != null) page = pagenumber;
	if (pos >= 0) {
		name = filename.substr(0,pos);
		ext = filename.substr(pos+1,filename.length);
	}
	return (name + page + "_" + name_part + "." + ext);
}
function create_new_nameextension(filename, newext) {
	if ((newext == null) || (newext == "")) return(filename);
	var pos = filename.lastIndexOf(".");	// cut filename extension
	var name = filename.substr(0,pos);
	return (name + newext);
}



// **************************
// ********** XML preprocessors
var xml_pre_processor_templates = new Array();
function store_xml_pre_processor_template(template_name) {
	xml_pre_processor_templates.push(template_name);
}
function have_xml_pre_processor_template(template_name) {
	var i;
	for (i = 0; i < xml_pre_processor_templates.length; i++) {
		if (xml_pre_processor_templates[i] == template_name) return true;
	}
	return false;
}

// **************************
// ********** XML postprocessors
var xml_post_processor_templates = new Array();
function store_xml_post_processor_template(template_name) {
	xml_post_processor_templates.push(template_name);
}
function have_xml_post_processor_template(template_name) {
	var i;
	for (i = 0; i < xml_post_processor_templates.length; i++) {
		if (xml_post_processor_templates[i] == template_name) return true;
	}
	return false;
}



// **************************
// ********** Font conversion tables
var fontconversionEquivalents_loaded = false,
	fontconversionEquivalents = null,
				/* fontconversionEquivalents file is like:
				Nudi 01 e.ftb==Nudi 01 e,
							Nudi 01 e Regular,
							Nudi 01 e Roman,
							Nudi 01 e Bold,
							Nudi 01 e Italic,
							/Nudi 12/i,
							##Nudi 12 e Regular,

							/vijayavani/i,
							##vijayavani gothic,
							##vijayavani text
							++
				*/
	fontconversiontable = new Object(),
	fontconversiontables_arr = new Array();
fontconversiontable.name = "";
fontconversiontable.table = new Array();

function loadFontconversionEquivalents() {
	var filepath = Packages.com.epaperarchives.batchxslt.mainXSLTFrame.userDir,
		equivalentsFile = "XSL" + java.io.File.separator + "fonttables" + java.io.File.separator + "_fontconversionEquivalents.ftb",
		exists,
		str,
		re, reclean,
		t_arr,
		t_arr2,
		f_arr, fontname,
		i, f;

	fontconversionEquivalents = null;

	if (endsWith(filepath,java.io.File.separator) === false) filepath += java.io.File.separator;
	filepath += equivalentsFile;

	exists = Packages.com.epaperarchives.batchxslt.utils.existsFile(filepath);
	if (exists == false) {
		fontconversionEquivalents_loaded = true;	// we have tried to load it
		return(-2);
	}

	// read the file
	str = "" + Packages.com.epaperarchives.batchxslt.utils.readFileUTF(filepath);
	if (str == "") return(-3);
	// clean the string
	reclean = new RegExp("^\s+","g");
	re = new RegExp("\r|\n| |\t","g");	// kill line ends and leading white space
	str = str.replace(re,"");

	t_arr = str.split("++");
		//	Packages.com.epaperarchives.batchxslt.utils.showMess("   -- loadFontconversionEquivalents length: '" + t_arr.length + "'\r\n");
	for (i = 0; i < t_arr.length; i++) {
		t_arr[i] = t_arr[i].replace(reclean,"");
		if (t_arr[i] == "") continue;
		if (t_arr[i].indexOf("##") >= 0) continue;

		t_arr2 = t_arr[i].split("==");	// t_arr2[0] is table name, t_arr2[1] is comma separated font list or REGEXP
		if (t_arr2.length < 2) continue;
			//Packages.com.epaperarchives.batchxslt.utils.showMess("   -- loadFontconversionEquivalents: '" + t_arr2 + "'\r\n");
		f_arr = t_arr2[1].split(",");	// font names in plain or as RegExp or starting with ## as comment

		if (fontconversionEquivalents == null) {
			fontconversionEquivalents = new Object();
		}
		for (f = 0; f < f_arr.length; f++) {
			fontname = f_arr[f];
			// clean font name from leading white space
			fontname = fontname.replace(reclean,"");
			if (fontname.indexOf("##") >= 0) continue;
			fontconversionEquivalents[fontname] = t_arr2[0];	// "font name": "table file name"
		}
	}

	fontconversionEquivalents_loaded = true;
	return 0;
}
function haveFontconversionEquivalents(fontname) {
	var key,
		fontequivalent,
		re, matches, rex = "", modi="";
	
	if (fontconversionEquivalents == null) return "";

	for (key in fontconversionEquivalents) {
		// skip loop if the property is from prototype
		if (!fontconversionEquivalents.hasOwnProperty(key)) continue;
		// check if key (font names) can match asked fontname 
		fontequivalent = key;	// can be a font name string or RegExp
			//Packages.com.epaperarchives.batchxslt.utils.showMess("   -- haveFontconversionEquivalents TEST fontequivalent: '" + fontequivalent + "' for fontname: '" + fontname + "'\r\n");
		if (fontequivalent.indexOf("/") == 0) {	// regexp
			rex = fontequivalent.substr(1,fontequivalent.lastIndexOf("/")-1);
			modi = fontequivalent.substr(fontequivalent.lastIndexOf("/")+1);
					//Packages.com.epaperarchives.batchxslt.utils.showMess("   -- haveFontconversionEquivalents REgExp rex: '" + rex + "' modi: '" + modi + "'\r\n");
			re = new RegExp(rex,modi);
			matches = re.test(fontname);
			if (matches) {
					//Packages.com.epaperarchives.batchxslt.utils.showMess("   -- haveFontconversionEquivalents fontname: '" + fontname + "' matches key: '" + key + "' tabel name: '" + fontconversionEquivalents[key] + "'\r\n");
				return fontconversionEquivalents[key];	// return font table name
			}
		}
		else {
			if (fontname.indexOf(fontequivalent) == 0) {
					//Packages.com.epaperarchives.batchxslt.utils.showMess("   -- haveFontconversionEquivalents fontname: '" + fontname + "' starts with: '" + fontequivalent + "' tabel name: '" + fontconversionEquivalents[key] + "'\r\n");
				return fontconversionEquivalents[key];	// return font table name
			}
		}
	}
	return "";	// no font table found
}

// load font converrsion tables
function loadFontConversionTables(font, FontFamily) {
	var checkfont, myfont, myFontFamily = "", fonttable = "",
		do_load_table = false,
		mess;
	if (!fontconversionEquivalents_loaded) {
		loadFontconversionEquivalents();
	}
	if (font) Packages.com.epaperarchives.batchxslt.utils.showMess("   ++ loadFontConversionTables for: '" + font + "'" + (FontFamily ? (" family: '" + FontFamily + "'") : "") + "\r\n");
	if (DEBUG) {
		if (font) java.lang.System.out.println ("   ++ loadFontConversionTables: '" + font + "'" + (FontFamily ? (" family: '" + FontFamily + "'") : "") + "\r\n");
		else java.lang.System.out.println ("   ++ loadFontConversionTables");
	}
	var loaded = 0;
	if ((font == undefined) || (font == null) || (font == "*") || (font == "")) {	// load all tables
		for (var i = 0; i < css_styles_arr.length; i++) {
			loaded = 0;
			var fontfamily = css_styles_arr[i][5];
			var fontname = css_styles_arr[i][13];
			if (fontname == "") fontname = css_styles_arr[i][12];
			if (fontname == "") fontname = fontfamily;
			if (fontname.indexOf("$ID/") > -1) fontname = fontname.replace(/\$ID\//gi,"");
			var fontstyle = css_styles_arr[i][9];
			if (DEBUG) {
				java.lang.System.out.print ("**** Table for Font-name: '" + fontname + "', Font-style: '" + fontstyle + "', Font-family: '" + fontfamily + "':");
				if (fontname == "") java.lang.System.out.println (" cannot be loaded - no font name");
			}
			if (fontname == "") continue;
			if (haveFontConversionTable(fontname) >= 0) {
				if (DEBUG) java.lang.System.out.println (" already loaded.");
				continue;
			}
			loaded = loadFontConversionTable(fontname,fontfamily);
			if ((loaded == 0) || (loaded == 1)) {
				if (loaded == 0) Packages.com.epaperarchives.batchxslt.utils.showMess("        loaded.\r\n");
				else  Packages.com.epaperarchives.batchxslt.utils.showMess("        already loaded.\r\n");
			}
			else {
				mess = "        --- NOT loaded, Code " + loaded + " = ";
				switch (loaded) {
					case -1:
						mess += "no font name given.";
						break;
					case -2:
						mess += "no table file available for this font.";
						break;
					case -2:
						mess += "table file is empty.";
						break;
					case -10:
						mess += "conversion table is empty.";
						break;
				}
				mess += "\r\n";
				Packages.com.epaperarchives.batchxslt.utils.showMess(mess);
			}
		}
	}
	else {	// load particular table
		checkfont = myfont = font;
		myFontFamily = FontFamily;
		do_load_table = false;

		fonttable = haveFontconversionEquivalents(checkfont);	// check the font name
		if (fonttable == "") {	// no table for this font
			// check FontFamily
			if ((typeof(FontFamily) != 'undefined') && (FontFamily != "")) {
				checkfont = myFontFamily = FontFamily;
				fonttable = haveFontconversionEquivalents(checkfont);
			}
		}
		if (fonttable != "") {
			fonttable = fonttable.split(".")[0];
				Packages.com.epaperarchives.batchxslt.utils.showMess("      ++ checking for fonttable: '" + fonttable + "'\r\n");
			if (haveFontConversionTable(fonttable) >= 0) {
				Packages.com.epaperarchives.batchxslt.utils.showMess("      '" + fonttable + "' already loaded.\r\n");
			}
			do_load_table = true;	// we have to register this font name too !!!
		}
		else {
			if (haveFontConversionTable(myfont) >= 0) {
				Packages.com.epaperarchives.batchxslt.utils.showMess(" already loaded.\r\n");
			}
			else do_load_table = true;
		}
		
		if (do_load_table) {
			Packages.com.epaperarchives.batchxslt.utils.showMess("      + loading Table for: '" + myfont + "' family: '" + myFontFamily + "' fonttable: '" + fonttable + "'\r\n");
			loaded = loadFontConversionTable(myfont, myFontFamily, fonttable);
			if ((loaded == 0) || (loaded == 1)) {
				if (loaded == 0) Packages.com.epaperarchives.batchxslt.utils.showMess("        loaded.\r\n");
				else  Packages.com.epaperarchives.batchxslt.utils.showMess("        already loaded.\r\n");
			}
			else {
				mess = "        -- NOT loaded, Code " + loaded + " = ";
				switch (loaded) {
					case -1:
						mess += "no font name given.";
						break;
					case -2:
						mess += "no table file available for this font.";
						break;
					case -2:
						mess += "table file is empty.";
						break;
					case -10:
						mess += "conversion table is empty.";
						break;
				}
				mess += "\r\n";
				Packages.com.epaperarchives.batchxslt.utils.showMess(mess);
			}
		}
	}
	if (DEBUG > 0) java.lang.System.out.println ("****** loaded Tables: " + getFontConversionTablesList() + "\r\n");
	return(true);
}

function loadFontConversionTable(font,fontfamily,fonttable) {
	var filepath = "", filename = "", fontname = "",
		filesubpath = "XSL" + java.io.File.separator + "fonttables" + java.io.File.separator,
		exists = false,
		tablestring,
		t_arr,
		start_of_table_idx,
		i, k, codeblock = "",
		tidx,
		num_entries,
		a_arr,
		idx,
		inp, outp,
		dumptable = false;
	if (font == "") return(-1);
	
	fontname = font;

	filepath = Packages.com.epaperarchives.batchxslt.mainXSLTFrame.userDir;
	if (endsWith(filepath,java.io.File.separator) === false) filepath += java.io.File.separator;
	filepath += filesubpath;

	// check if we have a table for the entire fontfamily
	if ((typeof(fonttable) != 'undefined') & (fonttable != "")) {
		filename =  fonttable + ".ftb";
		if (DEBUG) java.lang.System.out.println ("**************** loadFontConversionTable table file: '" + filepath + filename + "'");
		exists = Packages.com.epaperarchives.batchxslt.utils.existsFile(filepath + filename);
	}
	else if ((typeof(fontfamily) != 'undefined') & (fontfamily != "")) {
		fontname = fontfamily;
		filename =  fontname + ".ftb";
		if (DEBUG) java.lang.System.out.println ("**************** loadFontConversionTable fontfamily file: '" + filepath + filename + "'");
		exists = Packages.com.epaperarchives.batchxslt.utils.existsFile(filepath + filename);
	}
	if (exists == false) {
		// check if we have a table for the font
		if ((typeof(font) != 'undefined') & (font != "")) {
			fontname = font;
			filename =  fontname + ".ftb";
			if (DEBUG) java.lang.System.out.println ("**************** loadFontConversionTable font file: '" + filepath + filename + "'");
			exists = Packages.com.epaperarchives.batchxslt.utils.existsFile(filepath + filename);
		}
		if (exists == false) return(-2);
	}

	// check if table file already loaded
	for (tidx = 0; tidx < fontconversiontables_arr.length; tidx++) {
		if (fontconversiontables_arr[tidx].filename == filename) {
			// already loaded
			fontconversiontables_arr[tidx].use4fonts[fontconversiontables_arr[tidx].use4fonts.length] = font;
			return 1;
		}
	}

	// read the table file
	tablestring = "" + Packages.com.epaperarchives.batchxslt.utils.readFileUTF(filepath + filename);
	if (tablestring == "") return(-3);
	// clean the table
	tablestring = tablestring.replace(/(\r\n|\n|\r)/g,"\n");
	// load the table lines
	t_arr = tablestring.split("\n");
	// skip to "### BEGIN OF TABLE ###" line
	//java.lang.System.out.println ("*** loadFontConversionTable splitted lines: " + t_arr.length);
	start_of_table_idx = 0;
	for (i = 0; i < t_arr.length; i++) {
		if (t_arr[i].indexOf("### BEGIN OF TABLE ###") >= 0) {
			start_of_table_idx = i + 1;
			break;
		}
	}
	// load the table
	fontconversiontables_arr[fontconversiontables_arr.length] = new Object();
	tidx = fontconversiontables_arr.length-1;
	fontconversiontables_arr[tidx].filename = filename;		// the name of a font table file
	fontconversiontables_arr[tidx].name = fontname;			// the name of a font
	fontconversiontables_arr[tidx].use4fonts = new Array();	// list of font names this table is used for
	fontconversiontables_arr[tidx].table = new Array();		// the tables conversion strings
	fontconversiontables_arr[tidx].converter = null;		// the code to entire converter script
	fontconversiontables_arr[tidx].converter2 = null;		// the code to entire converter script
	fontconversiontables_arr[tidx].convert = null;			// the code pointer to the convert function
	fontconversiontables_arr[tidx].convert2 = null;			// the code pointer to the convert function
	fontconversiontables_arr[tidx].init = null;				// the code to initialize the code conversion
	num_entries = 0;
	for (i = start_of_table_idx; i < t_arr.length; i++) {
			//java.lang.System.out.println ("*** loadFontConversionTable line: " + i);
		if (t_arr[i].length < 3) continue;	// line with at least 3 characters like "c//" or "###"
		if (t_arr[i].indexOf("###") == 0) {	// special operator line
			if (t_arr[i].indexOf(" dumptable") >= 0) {	// want to log this table?
				dumptable = true;
				continue;
			}
			if (t_arr[i].indexOf("font-family//") >= 0) {	// set font-family attribute addition
				a_arr = t_arr[i].split("//");
				if (a_arr[1] != "") set_style_fontfamily_attributeAddition(font,a_arr[1]);
				continue;
			}

			if (t_arr[i].indexOf("use4fonts//") >= 0) {	// use this table for these fonts (a comma separated list of font-style names)
				a_arr = t_arr[i].split("//");
				if (a_arr[1] != "") fontconversiontables_arr[tidx].use4fonts = a_arr[1].split(",");
				fontconversiontables_arr[tidx].use4fonts[fontconversiontables_arr[tidx].use4fonts.length] = fontfamily;
				fontconversiontables_arr[tidx].use4fonts[fontconversiontables_arr[tidx].use4fonts.length] = font;
				continue;
			}

			// handle 'CODE and INIT' converter blocks
			// read a converters code block
			if (t_arr[i].indexOf("### CODE ###") >= 0) {
					//java.lang.System.out.println ("*** loadFontConversionTable line ### CODE ### line: " + i);
				codeblock = "";
				for (k = i + 1; k < t_arr.length; k++) {
					if (t_arr[k].length < 1) continue;	// line with at least 1 character
					if (t_arr[k].indexOf("//") == 0) continue;	// skip comments
						//java.lang.System.out.println ("*** loadFontConversionTable code block line: " + k + " : " + t_arr[k]);
					if (t_arr[k].indexOf("### CODE END ###") >= 0) break;
					codeblock += t_arr[k] + "\n";
				}
				if (codeblock != "") {
					// Java must have enough stack like -Xss128M to not run into Stack Overflow
					if (DEBUG) java.lang.System.out.println ("*** loadFontConversionTable new Function code block size: " + codeblock.length);
					if (fontconversiontables_arr[tidx].converter == null) {
						fontconversiontables_arr[tidx].converter = new Function ('initialize', 'tableindex', codeblock);
						if (DEBUG) java.lang.System.out.println ("*** loadFontConversionTable new Function done");
						if (DEBUG) {
							java.lang.System.out.println ("*** converter code block: " + fontconversiontables_arr[tidx].converter);
							java.lang.System.out.println ("*** converter calling .converter tidx:" + tidx + " " + typeof(fontconversiontables_arr[tidx].converter));
						}
						// initialize the converter
						// this calls the converter's internal function which checks: if (typeof(initialize) != 'undefined') { .... to do initialization
						fontconversiontables_arr[tidx].convert = fontconversiontables_arr[tidx].converter(true,tidx);	// initialize the converter (initialize=true and table index) and get pointer to convert function or null if none
						if (DEBUG) {
							java.lang.System.out.println ("*** converter calling DONE");
							java.lang.System.out.println ("*** convert func: " + ((fontconversiontables_arr[tidx].convert != null) ? fontconversiontables_arr[tidx].convert : "null"));
						}
					}
					else {	// always allow to overload converter2 with following code blocks ### CODE ###
						fontconversiontables_arr[tidx].converter2 = new Function ('initialize', 'tableindex', codeblock);
						if (DEBUG) java.lang.System.out.println ("*** loadFontConversionTable2 new Function done");
						if (DEBUG) {
							java.lang.System.out.println ("*** converter2 code block: " + fontconversiontables_arr[tidx].converter2);
							java.lang.System.out.println ("*** converter2 calling .converter tidx:" + tidx + " " + typeof(fontconversiontables_arr[tidx].converter));
						}
						// initialize the converter
						// this calls the converter's internal function which checks: if (typeof(initialize) != 'undefined') { .... to do initialization
						var conv = fontconversiontables_arr[tidx].converter2(true,tidx);	// initialize the converter2 (initialize=true and table index) and get pointer to convert function or null if none
						if (conv != null) fontconversiontables_arr[tidx].convert2 = conv;
						if (DEBUG) {
							java.lang.System.out.println ("*** converter2 calling DONE");
							java.lang.System.out.println ("*** convert2 func: " + ((fontconversiontables_arr[tidx].convert2 != null) ? fontconversiontables_arr[tidx].convert2 : "null"));
						}
					}
					
					codeblock = "";
				}
				i = k;	// set new index pointer
			}
			continue;
		}
		
		// handle 'standard' conversion strings like a//b
		if (t_arr[i].indexOf("//") <= 0) continue;	// must have separator '//' not a start
		c_arr = t_arr[i].split("//");
		if (c_arr.length < 2) continue;	// check if // was given
		if (c_arr[0] == "") continue;	// check if input string given
		
 		inp = parseUnicodeChar(c_arr[0]);	// might contain Unicode \uXXXX string
 		outp = parseUnicodeChar(c_arr[1]);	// might contain Unicode \uXXXX string
		fontconversiontables_arr[tidx].table[fontconversiontables_arr[tidx].table.length] = new Array(4);
		idx = fontconversiontables_arr[tidx].table.length - 1;
		fontconversiontables_arr[tidx].table[idx][0] = inp;		// the input string
		fontconversiontables_arr[tidx].table[idx][1] = outp;	// the output string
		if (c_arr.length > 2) {
			if (c_arr[2] && (c_arr[2] != "")) fontconversiontables_arr[tidx].table[idx][2] = c_arr[2];	// usually a named entity
			else fontconversiontables_arr[tidx].table[idx][2] = "";
			if (c_arr.length > 3) {
				if (c_arr[3] && (c_arr[3] != "")) fontconversiontables_arr[tidx].table[idx][3] = c_arr[3];	// usually a description
				else fontconversiontables_arr[tidx].table[idx][3] = "";
			}
		}
		if (DEBUG) java.lang.System.out.println ("---  " + fontconversiontables_arr[tidx].table[idx][0] + "=" + fontconversiontables_arr[tidx].table[idx][1]);
		num_entries++;
	}
	if ((num_entries == 0) && (fontconversiontables_arr[tidx].convert == null)) {	// if table is empty: remove it
		fontconversiontables_arr.length--;
		return(-10);
	}

	// check if use4fonts is set
	if (fontconversiontables_arr[tidx].use4fonts.length < 1) fontconversiontables_arr[tidx].use4fonts[fontconversiontables_arr[tidx].use4fonts.length] = fontconversiontables_arr[tidx].name;

	add_replaceFont(fontfamily + ":");	// automatically add this font to the exclude list for font replacement
	if (DEBUG || dumptable) {
		print_replaceFonts();
		printFontConversionTable(fontname);
	}
	return(0);
}

// check if we have loaded a table for this font
function haveFontConversionTable(font) {
	var i, u;
	for (i = 0; i < fontconversiontables_arr.length; i++) {
			//Packages.com.epaperarchives.batchxslt.utils.showMess("++++ font table search font: '" + font + "' in font_table: " + i + ", table name: '" + fontconversiontables_arr[i].name + "'\r\n");
		for (u = 0; u < fontconversiontables_arr[i].use4fonts.length; u++) {
			if (font.indexOf(fontconversiontables_arr[i].use4fonts[u]) == 0) return(i);	// font may have attribs like 'Regular' add to end of font name
		}
	}
	return(-1);
}

// check if we have loaded a table for this font
function getFontConversionTablesList() {
	var names = "Total tables: " + fontconversiontables_arr.length + "\n";
	for (var i = 0; i < fontconversiontables_arr.length; i++) {
		if (names != "") names += "//";
		names += fontconversiontables_arr[i].filename + ": ";
		names += fontconversiontables_arr[i].use4fonts + "\n";
	}
	return(names);
}

// check if we have loaded a table for this font
function printFontConversionTable(font) {
	var tidx = haveFontConversionTable(font),
		i;
	if (tidx < 0) return;
	java.lang.System.out.println ();
	java.lang.System.out.println ("-------- Font Table dump index:" + tidx + " for font: " + font);
	java.lang.System.out.println ("-------- Font Table use4fonts : " + fontconversiontables_arr[tidx].use4fonts);
	java.lang.System.out.println ("-------- Font Table standard:");
	for (i = 0; i < fontconversiontables_arr[tidx].table.length; i++) {
		java.lang.System.out.println (fontconversiontables_arr[tidx].table[i][0] + "=" + fontconversiontables_arr[tidx].table[1][1]);
	}
	if (fontconversiontables_arr[tidx].convert != null) {
		java.lang.System.out.println ("-------- Font convert code:");
		java.lang.System.out.println (fontconversiontables_arr[tidx].convert.toString());
	}
	return;
}

// convert text with table
function convertWithFontTable(tableidx,txt) {
	var outstr = "",
		inchar = "",
		ti = 0,
		i = 0,
		re;
	if (txt == "") return(txt);
	if (tableidx < 0) return(txt);
	if (tableidx > (fontconversiontables_arr.length - 1)) return(txt);
	if (DEBUG) {
		java.lang.System.out.println ("**** font conversion with table: '" + fontconversiontables_arr[tableidx].name + "'");
		java.lang.System.out.println ("**** orig txt: '" + txt + "'");
	}

	// check for single characters to convert only
	for (i = 0; i < txt.length; i++) {
		// find char in table
		inchar = txt.charAt(i);
		found = -1;
		for (ti=0; ti<fontconversiontables_arr[tableidx].table.length;ti++) {
			if (fontconversiontables_arr[tableidx].table[ti][0] == inchar) {
				found = ti;
				break;
			}
		}

		if (found > -1) {
			if (DEBUG > 0) java.lang.System.out.println ("****** '" + txt[i] + "' to:" + fontconversiontables_arr[tableidx].table[found][1]);
			outstr += fontconversiontables_arr[tableidx].table[found][1];
		}
		else {	// UNDEFINED input code
			outstr += txt[i];
		}
	}

	// convert with the standard string conversion table
	if (fontconversiontables_arr[tableidx].table.length > 0) {
		for (i=0; i<fontconversiontables_arr[tableidx].table.length;i++) {
			if (fontconversiontables_arr[tableidx].table[i][0].length < 2) continue;	// single chars were converted above
			if (outstr.indexOf(fontconversiontables_arr[tableidx].table[i][0]) > -1) {
				if (DEBUG) {
					java.lang.System.out.println ("--- replace input: '" + fontconversiontables_arr[tableidx].table[i][0] + "' with: '" + fontconversiontables_arr[tableidx].table[i][1] + "'");
				}
				re = new RegExp(fontconversiontables_arr[tableidx].table[i][0],"g");
				outstr = outstr.replace(re, fontconversiontables_arr[tableidx].table[i][1]);
			}
		}
	}
	
	// convert with the code block if available
	if (fontconversiontables_arr[tableidx].convert != null) {
		if (DEBUG) {
			java.lang.System.out.println ("--- convert conversion:");
		}
		outstr = fontconversiontables_arr[tableidx].convert(outstr);
	}

	if (DEBUG) {
		java.lang.System.out.println ("**** convert txt: '" + txt + "' to '" + outstr + "'");
	}
	return (outstr);
}

// convert Unicode String representation to a single character String
// str = \uXXXX
function parseUnicodeChar(str) {
	var idx = 0,
		pos = -1,
		hex,
		re = /\\u([a-zA-Z0-9]{4})/;		// search for Unicodes like \u0123
		outstr = "";
	if (str.length < 6) return(str);	// must be \uxxxx
	pos = str.search(re);
	if (pos < 0) return str;
		//java.lang.System.out.println ("---  parseUnicodeChar str: '" + str + "' length: " + str.length);
	while (pos > -1) {
		//java.lang.System.out.println ("---  parseUnicodeChar found Unicode at: " + pos + " idx:" + idx);
		if (pos > idx) {
			outstr += str.substring(idx,pos);
		}
		hex = str.substr(pos+2,4);
		outstr += String.fromCharCode(parseInt(hex,16));
		str = str.substr(pos + 6);
		idx = 0;
		if (str.length <= 0) break;
		pos = str.search(re);
	}
	if (str.length > 0) {	// add ending characters
		outstr += str;
	}
		//java.lang.System.out.println ("---  parseUnicodeChar outstr: " + outstr);
	return (outstr);
}


// replace using regexp
function re_replace(sourcestr,findstr,replstr,option) {
	if ( (sourcestr == "") || (findstr == "") ) return(sourcestr);
	var re = null;
	try { re = new RegExp(findstr,option); } catch(e) { return(sourcestr); }
	return (sourcestr.replace(re,replstr));
}
function clean_HTMLtags(sourcestr,replacestr) {
	if ( (sourcestr == null) || (sourcestr == "") ) return(sourcestr);
	var re = null;
	var mystr = sourcestr;
	try {
		re = /\<.*?\>/gi;		//replace(/(<([^>]+)>)/ig,"")
		mystr = mystr.replace(re,replacestr);
	} catch(e) { return(sourcestr); }
	try {
		re = /\&lt;.*?\&gt;/gi;
		mystr = mystr.replace(re,replacestr);
	} catch(e) { return(mystr); }
	return (mystr);
}


// string trim prototypes
String.prototype.trim = function() {
	return this.replace(/^\s+|\s+$/g,"");
}
String.prototype.ltrim = function() {
	return this.replace(/^\s+/,"");
}
String.prototype.rtrim = function() {
	return this.replace(/\s+$/,"");
}
String.prototype.lrtrim = function() {
	var s = this.replace(/^\s+/,"");
	return s.replace(/\s+$/,"");
}

// trim a string from leading and ending spaces
function allTrim(str) {
	if ( (str == null) || (str == "") ) return(str);
	while (str.substring(0,1) == ' ') {
		str = str.substring(1, str.length);
	}
	while (str.substring(str.length-1, str.length) == ' ') {
		str = str.substring(0,str.length-1);
	}
	return str;
}

// summarize values
var sumarized_value = 0.0;
function clear_sum() {
	sumarized_value = 0.0;
	return(sumarized_value);
}
function get_sum() {
	return("" + sumarized_value);
}
function sum(str) {
	if ( (str == null) || (str == "") ) return(sumarized_value);
	try {
		sumarized_value += parseFloat(str);
	} catch(e) {}
	return(sumarized_value);
}

// return the angle to the given sin and cos values
// always calculate from sin. cos +- only say in which quadrant
function sincos2angle(sinval,cosval,flipX,flipY) {
	//return(sinval+","+cosval);
	if (isNaN(sinval)) return (0.0);
	var myflipX = 0.0;
	var myflipY = 0.0;
	if (!isNaN(flipX)) myflipX = parseFloat(flipX);
	if (!isNaN(flipY)) myflipY = parseFloat(flipY);
	var mysin = parseFloat(sinval);	// we want it CCW but is given CW
	var mycos = 0.0;
	if ((cosval != null) && (cosval != "")) {	// 
		if (isNaN(cosval)) {
			if (cosval.indexOf("-") >= 0) mycos = -1.0;
		}
		else {
			try {
				mycos = parseFloat(cosval);
			}
			catch (e) {
				if (cosval.indexOf("-") >= 0) mycos = -1.0;
			}
		}
	}

	// special cases
	if ((mysin == 0) && (mycos == 0) && (myflipX == -1) && (myflipY == -1)) return(180.0);	// box flipped vert and horiz == rotated by 180 degrees

	// we have to calculate...
	//mysin = -mysin;	// we want it CCW but is given CW
	if (flipX < 0.0) mycos = -mycos;
	/*
	already defined at top
	DEG2RAD = Math.PI/180;
	RAD2DEG = 180/Math.PI;
	measureInRadian = grad*Math.PI/180;
	degree = measureInRadian*180/Math.PI;
	sin^-1: Math.asin(x);
	cos^-1: Math.acos(x);
	tan^-1: Math.atan(x);
	cot: 1/tan(x);
	All values in Radian.
	*/
	var angleCorrection = 0;
	var add = false;
	while (true) {
		if ((mysin >= 0) && (mycos >= 0)) { angleCorrection = 0; add = true; break; }
		if ((mysin >= 0) && (mycos < 0)) { angleCorrection = 180; add = false; break; }
		if ((mysin < 0) && (mycos >= 0)) { angleCorrection = 360; add = false; break; }
		if ((mysin < 0) && (mycos < 0)) { angleCorrection = 180; add = true; break; }
		break;
	}
	add = false;
	angleCorrection = 0.0;
	if ((myflipX < 0) && (myflipY < 0)) angleCorrection = 180.0;	// vert and horiz flip is 180degr rotation
	//if (mysin < 0) mysin = -mysin;
	var angle = Math.asin(mysin) * RAD2DEG;
	angle = -angle;
	if (angleCorrection != 0.0) angle = angleCorrection - angle;
	return(angle);
}

function clone(obj){
	if(obj == null || typeof(obj) != 'object') return obj;

	var temp = new obj.constructor();
	for (var key in obj) temp[key] = clone(obj[key]);

	return temp;
}
