<?xml version="1.0" encoding="UTF-8"?>
<!-- 
 ======================================================================
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.

THE PRODUCER:
Andreas Imhof
ai@aiedv.ch

Version: 46	!! also set the variable "XSLT_VERSION"
Version date: 20200221
20200221: Freeware
20171025:	fixed a bug in font conversion tables convertWithFontTable()
20171005:	enhanced CMYK JPEGs to sRGB conversion: additional output profile sRGB.icc for ImageMagick
20160111:	enhanced font conversion tables for indic non-unicode aware fonts to unicodes
20150802: 	enhanced params mainExportFolderIn, mainExportFolderOut
20150522: 	Fixed loading font conversion tables (in IMXepaper.js function loadFontConversionTable())
20141114:	InDesign CC 2014 has DOM version 10.1
20140804:	enhanced for new index.php file: write_indexPHP
20140802:	work with DOM v 10.x InDesign CC 2014
20140629:	enhanced for multiple page JPEGs
			fixed objects styles handling
20140409:	handle areas of page overlapping boxes (in panorama pages)
20140302:	default output colorspace changd to  -colorspace sRGB  due to newer ImageMagick
20120804:	Handle anchored buttons (movies)
20120622:	enhanced InDesign CC DOM version 9.0
			handle HiddenText
		 	handle CC MultiStateObject
20120603:	enhanced excludeLayers
20120930:	IM colorspace changes
20120908: added image meta data extract
20120903: added a debug flag: DEBUGPAGEIMAGES (nothing else)
20130208: worked around a problem, where images are named like page jpegs: adding to page JPEGs and PDFs the prefix '_px'

======================================================================
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
				xmlns:lxslt="http://xml.apache.org/xslt"
				xmlns:xalan="http://xml.apache.org/xalan" 
				xmlns:myutils="com.epaperarchives.batchxslt.utils"
				xmlns:myJpgImage="com.epaperarchives.batchxslt.JpgImage"
				xmlns:locjs="loc_funcs"
				xmlns:pubjs="pub_funcs"

				xmlns:x="adobe:ns:meta/"
				xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
				xmlns:stRef="http://ns.adobe.com/xap/1.0/sType/ResourceRef#"
				xmlns:xap="http://ns.adobe.com/xap/1.0/"
				xmlns:xapMM="http://ns.adobe.com/xap/1.0/mm/"
				xmlns:xapGImg="http://ns.adobe.com/xap/1.0/g/img/"
				xmlns:xapRights="http://ns.adobe.com/xap/1.0/rights/"
				xmlns:xapTPg="http://ns.adobe.com/xap/1.0/t/pg/"
				xmlns:xapG="http://ns.adobe.com/xap/1.0/g/"
				xmlns:stFnt="http://ns.adobe.com/xap/1.0/sType/Font#"
				xmlns:dc="http://purl.org/dc/elements/1.1/"
				xmlns:photoshop="http://ns.adobe.com/photoshop/1.0/"
				xmlns:illustrator="http://ns.adobe.com/illustrator/1.0/"
				xmlns:xmp="http://ns.adobe.com/xap/1.0/"
				xmlns:xmpGImg="http://ns.adobe.com/xap/1.0/g/img/"


				extension-element-prefixes="locjs pubjs"
				exclude-result-prefixes="locjs pubjs myutils myJpgImage xalan lxslt x rdf stRef xap xapMM xapGImg xapRights xapTPg xapG stFnt dc photoshop illustrator xmp xmpGImg"
				version="1.0">
<!-- standard parameters -->
	<xsl:param name="XMLSRC_VERSION"/>
	<xsl:param name="XMLSRC_ENCODING"/>
	<xsl:param name="XMLSRC_DOCTYPE_DECLARATION"/>
	<xsl:param name="SYSTEM_OS_NAME"/>
	<xsl:param name="SYSTEM_VM_VERSION"/>
	<xsl:param name="SYSTEM_DEFAULT_CHARSET"/>
	<xsl:param name="TRANSFORM_ENGINE"/>
	<xsl:param name="INPUT_PATH"/>
	<xsl:param name="INPUT_SUB_PATH"/>
	<xsl:param name="INPUT_NAME"/>
	<xsl:param name="OUTPUT_PATH"/>
	<xsl:param name="OUTPUT_NAME"/>
	<xsl:param name="STYLESHEET_PATH"/>
	<xsl:param name="STYLESHEET_NAME"/>
	<xsl:param name="LOGFILE_WRITE"/>
	<xsl:param name="LOGFILE_PATH"/>
	<xsl:param name="LOGFILE_NAME"/>
	<xsl:param name="APP_DIR"/><!-- app folder -->
	<xsl:param name="USER_NAME"/><!-- user's name -->
	<xsl:param name="USER_HOME"/><!-- home dir -->
	<xsl:param name="USER_DIR"/><!-- work dir -->
	<xsl:param name="LOCAL_MACHINE_NAME"/>

	<xsl:param name="GS_VERSION"/><!-- Version string of reachable Ghostscript -->
	<xsl:param name="GS_VERSION_NUM"/><!-- Version number of reachable Ghostscript -->
	<xsl:param name="GS_PGM_PATH"/><!-- The path and name to Ghostscript program -->
	<xsl:param name="GS_ENVIR"/><!-- Environement variables to set when calling Ghostscript -->
	<xsl:param name="IM_VERSION"/><!-- Version string of reachable ImageMagick -->
	<xsl:param name="IM_VERSION_NUM"/><!-- Version number of reachable ImageMagick -->
	<xsl:param name="IM_PGM_PATH"/><!-- The path and name to ImageMagick 'convert' program -->
	<xsl:param name="IM_PGM_CONVERT"/><!-- dito -->
	<xsl:param name="IM_PGM_IDENTIFY"/><!-- The path and name to ImageMagick 'identify' program -->
	<xsl:param name="IM_ENVIR"/><!-- Environement variables to set when calling ImageMagick (the path to Ghostscript) -->

	<xsl:param name="DEBUG"/><!-- set to 1 to show debug info in console -->
	<xsl:param name="DEBUGIMAGES"/><!-- set to 1 to show debug info in console -->
	<xsl:param name="DEBUGPAGEIMAGES" select="0"/><!-- set to 1 to show debug info in console while converting page images -->
	<xsl:param name="DEBUG_cssfile"/><!-- set to 1 for additional info in css -->

<!-- user definable parameters -->
	<xsl:param name="metaViewportContent"/><!-- The content attribute of a 'viewport' meta tag like: "initial-scale=0.68, width=device-width, user-scalable=yes"
															&lt;meta content="initial-scale=0.68, width=device-width, user-scalable=yes" name="viewport"&gt;
															will add the meta tag: name="viewport" content="initial-scale=0.68, width=device-width, user-scalable=yes" -->
	<xsl:param name="documentPDFname"/><!--  the name of the PDF file containing the whole document (if any) -->
	<xsl:param name="documentPDFnameSearch" select="1"/><!--  search for a PDF file containing the whole document with docname_doc.pdf -->
	<xsl:param name="outputMode"/><!-- 0 or empty = epaper view is created. 0=eBook, 1=epaperpages, 2=HTML article list, 3= XML tree -->
	<xsl:param name="outputModeCustomXSL"/><!-- if outputMode greater 3 then specify name of XSL to use for output view mode -->
	<xsl:param name="outputXMLComplexity" select="0"/><!-- the complexity of the XML file after processed by IMX2xmlEpaperArticles.xsl
															0 = default = full complexity
															1 = basic
															2 = simple
															3 = medium
															-->
	<xsl:param name="pageJPEGScale"/><!--  either the size of the page JPEG in percent without '%' char like 0.6 or 1.25
											if not spezified this is 1.0 or 100%
											or in pixels for widthxheight: like 350x400 or 350x or x400 as string
											-->
	<xsl:param name="pageJPEGQuality"/><!--  the quality the page JPEG -->
	<xsl:param name="pageJPEGdpi"/><!--  the resolution in dpi of the page JPEG -->
	<xsl:param name="pageJPEGParams"/><!--  additional params for IM's convert -->
	<xsl:param name="pageJPEGfinish"/><!--  page JPOEG finish params -->
	<xsl:param name="imageInputParam"/><!--  params when IM is opening the canvas for original image like: -density 450  
											to clear all parameters, set to imageInputParam=*none*
											or
											must be individual for different input/output image formats:
											INPUT	OUTPUT		DENSITY				TRANSPARENCY
											type	type		param				param
											
											eps		jpg			
													gif								-background none -transparent black
													png			-density 300		-background none -transparent black
													tif			-density 300		-background none -transparent black
											pdf
											ai
											psd
											tif
											jpg
											gif
											wmf
											...		...		enhancable for any further input/output formats
											other	other	for non specified formats

											SYNTAX: Control string of above parameters:
											INPUTtype/OUTPUTtype::DENSITYparam;TRANSPARENCYparam##INPUTtype/OUTPUTtype::DENSITYparam;TRANSPARENCYparam##...
											like:
											eps/png::-density 150;-background none -transparent black##
											eps/jpg::;##
											eps/gif:;-background none -transparent black##
											eps/tif:;-background none -transparent black##
										-->
	<xsl:param name="imageAddTargetPrefix" select="1"/><!-- 1 = add the unique box id as target image name prefix, 0 for no prefix -->
	<xsl:param name="imageOverwriteTargetIfExists" select="1"/><!-- 1 = always recreate the target image even if it already exists, 0 to not to overwrite existing target image -->
	<xsl:param name="imageTYPE" select="1"/><!-- 0 or empty = dont'export images, 1 = JPEG, 2 = GIF, 3 = PNG, 4 = TIFF -->
	<xsl:param name="imageQUALITY"/><!--  the quality for images (for JPEGs) -->
	<xsl:param name="imageDPI"/><!--  the resolution in dpi (comma separated): inputImageDPI,outputDPI or outputDPI -->
	<xsl:param name="imageSCALE"/><!--  the scale factor (1.25) TO SCALE IMAGES -->
	<xsl:param name="imageDoROTATE" select="0"/><!--  1 to rotate output images IMAGES -->
	<xsl:param name="imageCUT2imagebox" select="1"/><!--  1 = cut to imag box, 0 to cut to image itself -->
	<xsl:param name="imageOutputFinishParam"/><!--  parameters like "-strip" just before the output file -->
	<xsl:param name="imageNoDensityParam" select="0"/><!-- 1 = do not set an input desity parameter, 0 = default = set for vector images only -->
	
	<xsl:param name="imagePARAMS"/><!--  additional params for IM's convert for an image like -scale 3x1 -->
	<xsl:param name="imageCopyToOutput" select="1"/><!-- 0 or "" to not to copy original image files to output folder, 1 to copy them all, 2 to copy PDF, JPEG, GIF and PNG (web formats) only -->
	<xsl:param name="imageEXCLUDE"/><!-- exlude images from export when name starts with: "excl_;555" a semicolon separated list of chars -->
	<xsl:param name="imageCROP" select="1"/><!-- set to 1 to crop images to look like cut in InDesign -->
	<xsl:param name="imagesMORE"/><!-- more images parameters -->
	<xsl:param name="imageNOCONVERT" select="0"/><!-- set to 1 to export image box but do not convert the image to JPEG -->
	<xsl:param name="imagePreviewUseOriginals" select="0"/><!-- set to 1 to not convert images if created from internal preview. instead use the original image file -->
	<xsl:param name="imageMissingCreateFromPagePreview" select="2"/><!-- set to 0 to never recreate images from page preview
																		 set to 1 (default with ImageMagick) to extract images from screen page when original image file is missing (image box ectracted by InDesign script)
																 		 set to 2 (default without ImageMagick) to always create from screen page (image box ectracted by InDesign script)
																		 set to 3 to extract images from page preview JPEG if original image file is missing (extrtacted/cut by transformer)
																 		 set to 4 to always create from page preview (extrtacted/cut by transformer)
																		 -->
	<xsl:param name="imagesTotalSources" select="0"/><!-- total number of images in this document -->
	<xsl:param name="imagesTotalSourcesMissing" select="0"/><!-- total number of missing source images in this document -->

	<xsl:param name="XSLCSSPath"/><!--  a path or empty for output directory -->
	<xsl:param name="CSSpath"/><!--  a path or empty to use ../XSLCSS/ -->
	<xsl:param name="CSSname"/><!--  a name or empty to generate one -->
	<xsl:param name="overwriteCSSfiles"/><!--  1 = overwrite if css exists, otherwise don't -->
	<xsl:param name="CSSexpanded" select="0"/><!--  0 or empty for normal, otherwise expanded CSS style: write as much as possible style info from original INX file -->
	<xsl:param name="CSSclassNamesNoUnderscore" select="0"/><!--  0 or empty for normal, 1 = css class names should not contain underscore chars (OpenOffice does not like underscore) -->
	<xsl:param name="CSSclassNamesASCII" select="0"/><!--  0 or empty for normal, 1 = css class names are converted to plain ASCII (URL-encode) -->
	<xsl:param name="CSSfontFamilyString"/><!--  empty to write actual font into css, or a font-family css string like "Verdana","Arial",sans-serif (without ending semicalon or space) -->

	<xsl:param name="catchRadius"/><!--  any value in pixels  -->
	<xsl:param name="allBoxesNoCatch"/><!--  flag for all box types catching
										0 = normal
										1 = catch for all box types turned off
										2 = catch for empty boxes types turned off
										4 = catch for image boxes types turned off
										8 = catch for chained text boxes types turned off
										16 = catch for text boxes types turned off
										32 = catch for chained text boxes types turned off
										64 = catch for chained text boxes types turned off
										128 = catch for large page framing boxes turned off
										-->
	<xsl:param name="unassignedBoxesNoCatch" select="1"/><!--  >0 if unassigned content boxes should not catch other boxes to article groups -->
	<xsl:param name="emptyBoxesNoCatch" select="1"/><!--  >0 if empty boxes should not catch other boxes to article groups -->
	<xsl:param name="textBoxesNoCatch" select="0"/><!--  >0 if text boxes should not catch other boxes to article groups -->
	<xsl:param name="chainedBoxesNoCatch" select="0"/><!--  >0 if all chained boxes should not catch other boxes to article groups -->
	<xsl:param name="chainedFirstBoxesNoCatch" select="0"/><!--  >0 if first boxes of a chain should not catch other boxes to article groups -->
	<xsl:param name="chainedFollowingBoxesNoCatch" select="0"/><!--  >0 if following boxes in a chain should not catch other boxes to article groups -->
	<xsl:param name="imageBoxesNoCatch" select="0"/><!--  >0 if image boxes should not catch other boxes to article groups -->
	<xsl:param name="pageframingBoxesNoCatch" select="1"/><!--  >0 if large page framing boxes should not catch other boxes to article groups -->
	<xsl:param name="pageframingBoxSizeThreshold"/><!--  default = 1.0, the size factor of page size when a box should be treated as large page framer -->
	<xsl:param name="pageframingBoxNoExport" select="2"/><!--  default = 0, don't export large boxes combinable flag: 1 = text, 2 = images, 12 = both -->

	<xsl:param name="suppressAllEmptyBox" select="0"/><!-- 0 = don't suppress All empty boxes including unassigned content boxes, 1 = don't export -->
	<xsl:param name="suppressEmptyTextBox" select="0"/><!-- 0 = don't suppress empty text boxes, 1 = don't export -->
	<xsl:param name="suppressEmptyImageBox" select="0"/><!-- 0 = don't suppress empty image boxes, 1 = don't export -->
	<xsl:param name="suppressUnassignedBox" select="0"/><!-- 0 = don't suppress unsssaugned boxes, 1 = don't export -->
	<xsl:param name="suppressLineBox" select="0"/><!-- 0 = don't suppress line boxes, 1 = don't export -->
	<xsl:param name="suppressNonPrintingBox" select="1"/><!-- 0 = don't suppress non printing boxes, 1 = don't export -->

	<xsl:param name="replaceFont"/><!-- global font-family replace name or empty to preserve original font names -->
	<xsl:param name="fontsizeFactor" select="1.0"/><!--  font-size factor 1.0 = original size. set from 0.68 to ~ 0.78 to show browser font in same size as in InDesign -->
	<xsl:param name="fontsizeMinimum"/><!-- empty for original size or ex. 8 for 8pt -->
	<xsl:param name="fontsizeUnits" select="0"/><!-- default = 0. set to 1 to export fontsizes in percent to fontsizeBase, 2 = em -->
	<xsl:param name="fontsizeBase" select="9.0"/><!-- default = 9.0 (for 9.0pt). Used as 100% if fontsizeUnits is set to 1 or 2 -->
	<xsl:param name="wwwLinkStyles"/><!--  Stylenames representing a www link. Multiple names separated with '///'  -->
	<xsl:param name="continuedArticleStyles"/><!--  Stylenames representing a link to the next part of an article. Multiple names separated with '///'  -->
	<xsl:param name="includeDescription"/><!--  empty or 0 = don't include a textual description, 1 = do it -->
	<xsl:param name="CROPBOXmode" select="124"/><!--  how to handle CropBox for PDFs (default = 124)
													0 = do not add a "-define pdf:use-cropbox=true" command
													    and do not try to replace the artbox in pdf files with cropbox
													    and do not add a -crop command to ImageMagick
													    means: leave PDF as is and export uncropped
													addable flags like "124"
													1 = try to replace the 'ArtBox' in pdf files with 'CropBox' if 'CropBox' is not already set
													2 = add a "-define pdf:use-cropbox=true" command if PDF has 'CropBox'
													4 = add a "-crop WxHxXxY" command
													-->
	<xsl:param name="PDFhasCropBox" select="0"/><!--  set to 1 when sure that PDFs always heve a CropBox (default = 0) -->
	<xsl:param name="PDFhasTrimBox" select="0"/><!--  set to 1 when sure that PDFs always heve a TrimBox (default = 0) -->
	<xsl:param name="PDFnoBoxCropping">12</xsl:param><!-- Addable flags: 1 = don't set pdf:use-cropbox=true, 2 = don't set pdf:use-Trimbox=true
														Not to set these flags to ImageMagick/Ghostscript usually seems to work fine
														if an Artbox is set! and this should be!
															 -->

	<xsl:param name="INTERMEDIARY_XML_only"/><!--  1 = create intermediary XML file only -->
	<xsl:param name="INTERMEDIARY_XML_preserve" select="0"/><!--  1 = dont delete intermediary XML file -->

	<xsl:param name="XPLATFORM_NAMES" select="2"/><!-- combinable flags string
											0 or blank = do not encode, leave as is in filenames and uri
											1 = URI encode  (%XX),
											2 = Xplatform safe URI: replace unsafe characters encoded to  (xXX)
											3 = Xplatform safe URI: replace unsafe characters encoded to  (xXX)  and shorten names to 31 characters 
											9 = addable flag to replace all characters obove ASCII with xXX 
											    especially useful if filenames contain CJKV (Chinese, Japanese, Korean,Vietnames) characters
											    and the web server is not able to handle such names.
											    Also when exporting on Windows, this flag might be necessary to be set -->
	<xsl:param name="CONVERTFILENAMES" select="0"></xsl:param><!-- combinable flags string  [1][2][1-w][2-w]
														0 = don't convert
														1 = make composed unicode NFC (Windows)
														2 = convert Params To NativeCharset 
														3 = make decomposed unicode NFD (OSX)
														optionally add -w = not on windows, -x = not on OSX
														examples:
														make composed unicode but not for windows: 1-w 
														make composed unicode but not for windows, on windows make native : 1-w2-x -->

	<xsl:param name="MAX_IMAGENAME_LENGTH"/><!-- max file name length (default = 31) -->
	<xsl:param name="OUTPUT_FEATURES" select="2"/><!-- 0 = Standart version options, 2 = PRO: additional attribs -->

	<xsl:param name="FOLDERINDEXNAME"/><!-- index file name: a HTML index file containing all xml files will be written to output folder  -->
	<xsl:param name="INDEXPHPNAME" select="index.php"/><!-- index file name: a PHP file able to transform the XML to (partial) HTM file  -->

	<xsl:param name="COLORPROFILE_ignore" select="0"/><!-- if not 0: do not use color profile nor -colorspace sRGB -->
	<xsl:param name="COLORPROFILE"/><!-- either:
										*NONE* to not to make any color management
										"" empty to auto detect
										-colorspace sRGB
										or TWO -profile TheProfile.icc (input and output) perameters
										 -->
	<xsl:param name="COLORPROFILES_path"/><!-- the path to color profiles -->

	<xsl:param name="INTERNET_AWARE_FONTNAMES"/><!-- remove part bejond '(' like in non internet save font names like "Helvetica Neue (T1)" -->

	<xsl:param name="TABLE_CELLS_WIDTH_PRESERVE" select="1.3"/><!-- 0 or "" to not preserve, factor to expand cell width: 0.1toX to add cell style 'width' attribute (from 'colwidth') -->
	<xsl:param name="TABLE_BORDER_COLLAPSE" select="1"/><!-- 0 or "" to not collaps, 1 for 'border-collapse:collapse;', 2 for 'border-collapse:separate; border-spacing:0px;' -->
	<xsl:param name="TABLE_AS_BLOCK" select="0"/><!-- 0 or "" to show tables as inline elements, 1 as block -->
	<xsl:param name="ALLOW_PARACLASS_OVERRIDES" select="1"/><!-- 0 to suppress style overrides of a para class, 1 allow -->
	<xsl:param name="magnifyingGlass" select="1"/><!-- 0 to suppress view mode with magnifying glass, 1 allow -->
	<xsl:param name="excludeHiddenLayers" select="0"/><!-- 1 to suppress all on hidden layers, otherwise 0 -->
	<xsl:param name="excludeLayers" /><!-- a list of comma separated layer names to exclude from export. like *noexp* -->
	<xsl:param name="includeLayers" select="1"/><!-- 1 to include layers info, otherwise 0 -->
	<xsl:param name="includeXMLtags" select="0"/><!-- 1 to include custom XML tagging info, otherwise 0, PRO only -->
	<xsl:param name="includeMetaData" select="0"/><!-- 1 to export meta data like font infos in metadata tag -->

	<xsl:param name="excludeNotes" select="1"/><!-- 1 to not to export Notes into html -->

	<xsl:param name="includeAnchoredObjectsBlock" select="0"/><!-- 1 to include all anchored objects in the output XML in a 'anchored_objects' element -->
	<xsl:param name="useExternalStorage" select="1"/><!-- 1 to use external JAVA (zippable) storage for anchored objects, 0 = use internal javascript storage array -->
	<xsl:param name="memoryUsageMode" select="0"/><!-- 0 = prepare all boxes in memory before processing the document content,
														1 = don't collect boxes in advance = use less memory (for lots of boxes) -->

	<xsl:param name="suppressSiteElements" select="0"/><!-- addable flags to suppress elements in output html flipbook web site (processed by flipbook.xsl)
															1 to suppress the whole top head - page navigation bar
															2 to suppress the bottom PDF toolbar
															4 to suppress the loading progress
															8 to suppress the info message text below pages
															add each flag as it own char like: '148' -->
	<xsl:param name="suppressExportMouseOvers" select="0"/><!-- addable flags to suppress export and mouse overs in output html flipbook web site (processed by flipbook.xsl)
															1 to completely suppress the mouse over function
															2 to suppress all text and the mouse over text
															4 to suppress all images and the mouse over images
															8 to suppress mouse over empty boxes
															add each flag as it own char like: '14' -->
	<xsl:param name="showArticleInNewWindow" select="0"/><!-- set to 1 to show articles always in a new window (not in float div on right side) -->
	<xsl:param name="websiteParams" select="0"/><!-- the web site's parameters
													 a list of keyword=content*#*keyword=content*#*....-->

	<xsl:param name="groupBoxesToArticles" select="1"/><!-- 1 = make article groups, 0 = don't. set to 1 when article groups are wanted -->
	<xsl:param name="sortBoxesByAreaSize" select="1"/><!-- 1 = make article groups, 0 = don't. set to 1 when article should be sorted by area size -->
	<xsl:param name="sortBoxesByYposition" select="1"/><!-- 1 = box top/down sorting, 0 = don't. set to 1 when boxes should be sorted top down -->
	<xsl:param name="sortBoxYtolerance" select="1.5"/><!-- set to 0.0 to use strict top-down sorting
															 set to x.x to check for title box height too -->
	<xsl:param name="addMissingPages" select="0"/><!-- 1 = add missing left/right pages, 0 or empty to not to add pages -->

	<xsl:param name="preserveControlCharacters" select="0"/><!-- 1 to export all special chars as ctrlchar -->
	<xsl:param name="preconvertTextFlags" select="31"/><!-- remove/convert special characters -->
														<!-- 0 = no pre conversion of text
															 1 = remove softhypens, replace &#8232; LINE SEPARATOR with <br type="LINE SEPARATOR"/>
															 2 = remove divis paragraph (manual hypens)
															 4 = any space to blank
															 8 = hyphens
															16 = others
														-->
	<xsl:param name="characterAttribsSuppress" select="0"/><!-- suppress manually set character attributes like font-size... -->
														<!-- 0 = leave attribs as is
															 1 = suppress manually set font-family
															 2 = suppress manually set font-size
														-->
	<xsl:param name="paragraphAttribsSuppress" select="1"/><!-- suppress paragraph attributes like line-height (leading)... -->
														<!-- 0 = leave attribs as is
															 1 = suppress leading
														-->
	<xsl:param name="textshortcutLength" select="200"/><!-- the length of floater preview text shortcut. default = 200, 0 = no shortcut -->

	<!-- variables about the publication -->
	<xsl:param name="pub_companyName"/><!-- the company name publishiong this publication -->
	<xsl:param name="pub_objectName"/><!-- the publication name -->
	<xsl:param name="pub_objectShortcut"/><!-- the publication shortcut -->
	<xsl:param name="pub_issueYear"/><!-- the issue year -->
	<xsl:param name="pub_issueDate"/><!-- the issue full date -->

	<!-- variables for special systems -->
	<xsl:param name="addVirtualKeyboard"/><!-- add a virtual keybord to input fields for systems without a real keyboard -->

	<xsl:param name="extractImageMetaData" select="0"/><!--  1 to extract images metadata, otherwise: don't -->
	<xsl:param name="fullImageMetaData" select="0"/><!--  1 to additionally include the entire xmpmeta xml string, otherwise: title subject and description only -->
	<xsl:param name="typeImageMetaData" select="concat('&#45;&#45;','metadata')"/><!--  tika parameters (long or short version) comma separated preceeded by minus sign(s): &min;&min;metadata,&min;&min;xmp -->

	<xsl:param name="pageTurnMode"/><!-- how to turn pages -->

	<xsl:param name="mainExportFolderIn"/><!-- the main exporter input base path -->
	<xsl:param name="mainExportFolderOut"/><!-- the main exporter output base path -->

	<!-- user settable vars -->
	<xsl:param name="userVar1"/>
	<xsl:param name="userVar2"/>
	<xsl:param name="userVar3"/>
	<xsl:param name="userVar4"/>
	<xsl:param name="userVar5"/>
	<xsl:param name="userVar6"/>
	<xsl:param name="userVar7"/>
	<xsl:param name="userVar8"/>
	<xsl:param name="userVar9"/>

	<xsl:output method="xml" />
	<xsl:output media-type="text/xml"/>
	<xsl:output omit-xml-declaration="no"/>

	<xsl:output indent="no"/>
	<xsl:output encoding="UTF-8"/>




	<!-- ************************************************************************
		 SETTINGS
		 ========================= -->
	<xsl:variable name="XSLT_VERSION">46</xsl:variable><!-- the version of this transform -->
	<xsl:variable name="XSLT_VERSIONDATE">20200221</xsl:variable><!-- the version date of this transform -->

	<!-- get XML DOM version -->
	<xsl:variable name="DOMVersion">
		<xsl:choose>
			<xsl:when test="/Documents">
				<xsl:value-of select="/Documents/Document/@DOMVersion"/>
			</xsl:when>
			<xsl:when test="/Document">
				<xsl:value-of select="/Document/@DOMVersion"/>
			</xsl:when>
			<xsl:otherwise></xsl:otherwise><!-- no DOMversion -->
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="DOMVersionMain">
		<xsl:value-of select="locjs:main_DOMVersion(string($DOMVersion))"/>
	</xsl:variable>




	<xsl:variable name="my_XPLATFORM_NAMES">
		<xsl:choose>
			<xsl:when test="$XPLATFORM_NAMES = ''">0</xsl:when>
			<xsl:otherwise><xsl:value-of select="$XPLATFORM_NAMES"/></xsl:otherwise><!-- make Xplatform safe -->
		</xsl:choose>
	</xsl:variable>



	<!-- ========= Image converter settings -->
			<!-- for IM before 6.3.1 set to 32-w = 3:make composed unicode and 2:convertParamsToNativeCharset but not on windows may be [1][2][3][1-w][2-w][3-w][1-x][2-x][3-x] -->
			<!-- for IM after including 6.3.2 set to 3-w = 1:make composed unicode and but not on windows -->
	<xsl:variable name="filenameConversion">
		<xsl:choose>
			<xsl:when test="$CONVERTFILENAMES = '0'"></xsl:when>
			<xsl:when test="$CONVERTFILENAMES != ''"><xsl:value-of select="$CONVERTFILENAMES"/></xsl:when>
			<!--xsl:when test="locjs:compareVersionStrings(string($IM_VERSION_NUM),'6.3.1') &gt;= 0">1-w</xsl:when--><!-- version newer or equal to 6.3.1 do not need conversion to local filename encoding -->
			<xsl:when test="locjs:compareVersionStrings(string($IM_VERSION_NUM),'6.3.1') &gt;= 0">3-w</xsl:when><!-- version newer or equal to 6.3.1 do NOT need conversion to local filename encoding -->
			<xsl:otherwise>3-w</xsl:otherwise><!-- make decomposed NFD for Mac only -->
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="ImageMagickConvert"><!--  use ImageMagick's convert command line tool to convert images -->
		<xsl:choose>
			<xsl:when test="$IM_PGM_CONVERT != ''"><xsl:value-of select="$IM_PGM_CONVERT"/></xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="ImageMagickIdentify"><!--  use ImageMagick's identify command line tool to identify images -->
		<xsl:choose>
			<xsl:when test="$IM_PGM_IDENTIFY != ''"><xsl:value-of select="$IM_PGM_IDENTIFY"/></xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="ImageMagickConvertEnvir"><!--  set path to GhostScript to convert EPS -->
		<xsl:choose>
			<xsl:when test="$IM_ENVIR != ''"><xsl:value-of select="$IM_ENVIR"/></xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="IMtype">
		<xsl:choose>
			<xsl:when test="$imageTYPE = ''"></xsl:when>
			<xsl:when test="$imageTYPE = '0'"></xsl:when>
			<xsl:when test="$imageTYPE = '1'">.jpg</xsl:when>
			<xsl:when test="$imageTYPE = '2'">.png</xsl:when>
			<!-- with installed ImageMagick only -->
			<xsl:when test="$imageTYPE = '3'">.gif</xsl:when>
			<xsl:when test="$imageTYPE = '4'">.tif</xsl:when>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="IMquality"><!--  normal images quality (for JPEG) -->
		<xsl:choose>
			<xsl:when test="$imageQUALITY != ''">-quality <xsl:value-of select="$imageQUALITY"/></xsl:when>
			<xsl:otherwise></xsl:otherwise><!-- evtl given in imagePARAMS -->
		</xsl:choose>
	</xsl:variable>


	<xsl:variable name="IMPageJPEGquality">-quality <xsl:choose><xsl:when test="$pageJPEGQuality != ''"><xsl:value-of select="$pageJPEGQuality"/></xsl:when><xsl:otherwise>70</xsl:otherwise></xsl:choose></xsl:variable><!--  page JPEG quality -->
	<xsl:variable name="IMPageJPEGdpi">-resample <xsl:choose><xsl:when test="$pageJPEGdpi != ''"><xsl:value-of select="$pageJPEGdpi"/>x<xsl:value-of select="$pageJPEGdpi"/></xsl:when><xsl:otherwise>150x150</xsl:otherwise></xsl:choose></xsl:variable><!--  page JPEG dpi -->
	<!-- ******************
		 color profiles 
		 for all images the output profile is: 'sRGB Color Space Profile.icm'
	-->

	<!-- ************************************************************************
		 END SETTINGS
		 ========================= -->



	<!-- ******************************************* -->
	<!-- the original document's name -->
	<xsl:variable name="docname" select="locjs:store_indd_docname('',string($INPUT_NAME))"/>

	<xsl:variable name="the_OUTPUT_PATH">
		<xsl:choose>
			<xsl:when test="$OUTPUT_PATH = ''"><xsl:value-of select="$INPUT_PATH"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$OUTPUT_PATH"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<!-- init folder index stuff -->
	<xsl:variable name="the_FOLDERINDEXNAME">
		<xsl:choose>
			<xsl:when test="$FOLDERINDEXNAME != ''"><xsl:value-of select="$FOLDERINDEXNAME"/></xsl:when>
			<xsl:otherwise></xsl:otherwise><!-- no index file -->
		</xsl:choose>
	</xsl:variable>


	<!-- the install path of the folder XSLCSS -->
	<xsl:variable name="XSLCSSfoldername">XSLCSS</xsl:variable><!--  the source folder to copy from the application path -->
	<xsl:variable name="XSLCSSSourceFolderpath"><xsl:value-of select="$APP_DIR"/>/XSL/<xsl:value-of select="$XSLCSSfoldername"/></xsl:variable><!--  the source folder path seen from application dir -->
	<xsl:variable name="XSLCSSRelativePath"><!--  the relative path to XSL -->
		<xsl:choose>
		<xsl:when test="$XSLCSSPath = ''">../<xsl:value-of select="$XSLCSSfoldername"/>/</xsl:when>
		<xsl:otherwise><xsl:value-of select="$XSLCSSPath"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="XSLCSSInstallPathnameRel"><xsl:value-of select="$the_OUTPUT_PATH"/><xsl:value-of select="$XSLCSSRelativePath"/></xsl:variable><!--  the relative target path -->
	<xsl:variable name="XSLCSSInstallPathname" select="myutils:resolveRelativePath(string($XSLCSSInstallPathnameRel))"/><!--  the target path -->

	<xsl:variable name="dummy_max">
		<xsl:if test="$MAX_IMAGENAME_LENGTH != ''">
			<xsl:variable name="d" select="locjs:set_max_filenname_length(string($MAX_IMAGENAME_LENGTH))"/>
		</xsl:if>
	</xsl:variable>

	<!-- the name of the CSS file to create -->
	<xsl:variable name="thecssname">
		<xsl:choose>
			<xsl:when test="$CSSname = '*NONE*'"></xsl:when>
			<xsl:when test="$CSSname != ''"><xsl:value-of select="$CSSname"/></xsl:when>
			<xsl:when test="contains($my_XPLATFORM_NAMES,'0')"><xsl:value-of select="concat($docname,'.css')"/></xsl:when>
			<xsl:when test="contains($my_XPLATFORM_NAMES,'1')"><xsl:value-of select="locjs:encode_URI(concat($docname,'.css'),string($my_XPLATFORM_NAMES))"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="locjs:xPlatformName(concat($docname,'.css'))"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="thecssname_isfullurl">
		<xsl:choose>
			<xsl:when test="starts-with($thecssname,'http:') = 'true'">1</xsl:when>
			<xsl:when test="starts-with($thecssname,'https:') = 'true'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="csspathname">
		<xsl:choose>
			<xsl:when test="$thecssname = ''"></xsl:when>
			<xsl:when test="$CSSpath != ''"><xsl:value-of select="$CSSpath"/><xsl:value-of select="$thecssname"/></xsl:when>
			<!--xsl:otherwise><xsl:value-of select="$the_OUTPUT_PATH"/><xsl:value-of select="$thecssname"/></xsl:otherwise -->
			<xsl:otherwise><xsl:value-of select="$thecssname"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="cssInstallPathname">
		<xsl:choose>
			<xsl:when test="$thecssname_isfullurl = '1'"></xsl:when>
			<xsl:when test="$csspathname = ''"></xsl:when>
			<xsl:otherwise><xsl:value-of select="myutils:resolveRelativePath(concat($the_OUTPUT_PATH,$csspathname))"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="cropboxMode">
		<xsl:choose>
			<xsl:when test="$CROPBOXmode = ''">0</xsl:when>
			<xsl:otherwise><xsl:value-of select="$CROPBOXmode"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>


	<xsl:variable name="ImageMagickVersion"><xsl:value-of select="myutils:getImageMagickVersion()"/></xsl:variable>
	<xsl:variable name="GhostScriptVersion"><xsl:value-of select="myutils:getGhostScriptVersion()"/></xsl:variable>

	<xsl:variable name="cMepData"><xsl:copy-of select="/Documents/Document/metadata"/></xsl:variable>







	<!-- ******************************************* -->
	<xsl:template match="/">
		<xsl:choose>
			<!--  CS2 dom 4.0, CS3 = 5.0, CS4 = 6.0, CS5 = 7.0, CS5.5 = 7.5, CS6 = 8.0, CC = 9.0, CC 2014 = 10.x -->
			<xsl:when test="($DOMVersion = '') or (number($DOMVersionMain) &gt;= 7)">
				<xsl:choose>
					<xsl:when test="Documents">
						<xsl:apply-templates select="Documents"/>
					</xsl:when>
					<xsl:when test="Document">
						<xsl:apply-templates select="Document"/>
					</xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="d1" select="myutils:showMess(concat('&#10;### The Transformer can not operate on this DOM version: ',$DOMVersion,'!&#10;### Transform aborted!&#10;'),'1')"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="Documents">
		<xsl:apply-templates select="Document"/>
	</xsl:template>

	<!-- ******************************************* -->
	<xsl:template match="Document">

		<!-- globally used variables -->
		<xsl:variable name="d" select="locjs:set_debug_mode(string($DEBUG))"/>
		<xsl:variable name="d" select="locjs:set_debug_images_mode(string($DEBUGIMAGES))"/>
		<xsl:variable name="d" select="locjs:set_debug_css_mode(string($DEBUG_cssfile))"/>

		<xsl:variable name="outfeatures"><xsl:value-of select="locjs:store_outputFeatures(string($OUTPUT_FEATURES))"/></xsl:variable>

		<xsl:variable name="d" select="locjs:store_excludeLayers(string($excludeLayers))"/>

		<xsl:variable name="do_includeXMLtags">
			<xsl:choose>
				<xsl:when test="$includeXMLtags = '0'">0</xsl:when>
				<xsl:otherwise>1</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="d"><xsl:value-of select="locjs:store_includeXMLtags(string($do_includeXMLtags))"/></xsl:variable>

		<xsl:variable name="d6" select="locjs:set_useExternalStorage(string($useExternalStorage))"/>

		<xsl:variable name="suppressChar"><xsl:value-of select="locjs:store_characterAttribsSuppress(string($characterAttribsSuppress))"/></xsl:variable>
		<xsl:if test="locjs:get_outputFeatures() = '2'">
			<xsl:variable name="suppressPara"><xsl:value-of select="locjs:store_paragraphAttribsSuppress(string($paragraphAttribsSuppress))"/></xsl:variable>
		</xsl:if>

		<xsl:variable name="d" select="locjs:set_textshortcut_length(string($textshortcutLength))"/>

		<xsl:if test="$the_FOLDERINDEXNAME != ''">
			<xsl:if test="$cMepData">
				<xsl:variable name="title"><xsl:value-of select="xalan:nodeset($cMepData)//descendant::dc:title/rdf:Alt/rdf:li/." /></xsl:variable>
				<xsl:variable name="creator"><xsl:for-each select="xalan:nodeset($cMepData)//descendant::dc:creator/rdf:Seq/rdf:li"><xsl:value-of select="." />;</xsl:for-each></xsl:variable>
				<xsl:variable name="description"><xsl:value-of select="xalan:nodeset($cMepData)//descendant::dc:description/rdf:Alt/rdf:li/." /></xsl:variable>
				<xsl:variable name="rights"><xsl:value-of select="xalan:nodeset($cMepData)//descendant::dc:rights/rdf:Alt/rdf:li/." /></xsl:variable>
				<xsl:variable name="d4" select="pubjs:init_folder_index(concat($the_OUTPUT_PATH,$the_FOLDERINDEXNAME),string($title),string($creator),string($description),string($rights))"/>
			</xsl:if>
		</xsl:if>

		<xsl:variable name="d"><xsl:value-of select="locjs:store_imageDPI(string($imageDPI))"/></xsl:variable>
		<xsl:variable name="d"><xsl:value-of select="locjs:store_imageScale(string($imageSCALE))"/></xsl:variable>
		<xsl:variable name="d"><xsl:value-of select="locjs:store_imageDoRotate(string($imageDoROTATE))"/></xsl:variable>
		<xsl:variable name="d"><xsl:value-of select="locjs:store_cut_image2contentbox(string($imageCUT2imagebox))"/></xsl:variable>
		<xsl:variable name="d"><xsl:value-of select="locjs:store_imageExclude(string($imageEXCLUDE))"/></xsl:variable>
		<xsl:variable name="d"><xsl:value-of select="locjs:store_imageCrop(string($imageCROP))"/></xsl:variable>

		<xsl:variable name="d"><xsl:value-of select="locjs:set_imageInputParam_defaults()"/></xsl:variable>
		<xsl:variable name="d"><xsl:value-of select="locjs:store_imageInputParam(string($imageInputParam))"/></xsl:variable>

		<xsl:variable name="d2"><xsl:value-of select="locjs:set_allow_paraclass_overrides(number($ALLOW_PARACLASS_OVERRIDES))"/></xsl:variable>

		<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
			<xsl:variable name="d" select="myutils:showMess(concat('==== DOMVersion: ',$DOMVersion,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== DEBUG: ',$DEBUG,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== System OS name: ',$SYSTEM_OS_NAME,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== System Default Character Set: ',$SYSTEM_DEFAULT_CHARSET,'&#10;'),'1')"/>
	
			<xsl:variable name="d" select="myutils:showMess(concat('==== Input path: ',$INPUT_PATH,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== Input sub path: ',$INPUT_SUB_PATH,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== INPUT_NAME: ',$INPUT_NAME,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== docname: ',$docname,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== Output path: ',$the_OUTPUT_PATH,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== Output name: ',$OUTPUT_NAME,'&#10;'),'1')"/>

			<xsl:variable name="d" select="myutils:showMess(concat('==== XSL path: ',$STYLESHEET_PATH,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== XSL name: ',$STYLESHEET_NAME,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== XSLCSSSourceFolderpath: ',$XSLCSSSourceFolderpath,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== XSLCSSInstallPathname: ',$XSLCSSInstallPathname,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== XSLCSSRelativePath: ',$XSLCSSRelativePath,'&#10;'),'1')"/>

			<xsl:variable name="d" select="myutils:showMess(concat('==== Logfile ',$LOGFILE_WRITE,': ',$LOGFILE_PATH,$LOGFILE_NAME,'&#10;'),'1')"/>

			<xsl:variable name="d" select="myutils:showMess(concat('==== Page Scale: ',$pageJPEGScale,'&#10;'),'1')"/>

			<xsl:variable name="d" select="myutils:showMess(concat('==== user.home: ',$USER_HOME,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== user.dir: ',$USER_DIR,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== user name: ',$USER_NAME,'&#10;'),'1')"/>

			<xsl:variable name="d" select="myutils:showMess(concat('==== imageTYPE: ',$imageTYPE,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== IM_PGM_PATH: ',$IM_PGM_PATH,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== IM_PGM_CONVERT: ',$IM_PGM_CONVERT,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== IM_PGM_IDENTIFY: ',$IM_PGM_IDENTIFY,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== IM_ENVIR: ',$IM_ENVIR,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== IM_VERSION: ',$IM_VERSION,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== IM_VERSION_NUM: ',$IM_VERSION_NUM,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== filenameConversion: ',$filenameConversion,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== GS_PGM_PATH: ',$GS_PGM_PATH,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== GS_ENVIR: ',$GS_ENVIR,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== GS_VERSION_NUM: ',$GS_VERSION_NUM,'&#10;'),'1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('==== COLORPROFILES_path: ',$COLORPROFILES_path,'&#10;'),'1')"/>

			<xsl:variable name="toaddress"><xsl:value-of select="$USER_NAME"/>@<xsl:value-of select="$LOCAL_MACHINE_NAME"/>.com</xsl:variable>
			<!--xsl:variable name="d" select="myutils:sendMail('smtp.host.com',$toaddress,'ai@aiedv.ch','using BatchXSLT','it is me!')"/-->
		</xsl:if>

		<!--xsl:variable name="d0" select="myutils:deleteLogFile()"/-->
		<xsl:variable name="d0" select="myutils:setLogFile(1,null,null)"/>

		<xsl:variable name="m">&#10;********* InDesign ePaper XML Transformer V<xsl:value-of select="$XSLT_VERSION"/> / <xsl:value-of select="$XSLT_VERSIONDATE"/> *********</xsl:variable>
		<xsl:variable name="d1" select="myutils:showMess(string($m),'1')"/>
		<xsl:variable name="d2" select="myutils:showMess('&#10;+++ creating intermediary XML file','1')"/>

		<!-- INIT -->
		<xsl:variable name="d" select="locjs:set_DOMVersion(string($DOMVersion))"/>
		<xsl:variable name="d" select="locjs:set_system_os_name(string($SYSTEM_OS_NAME))"/>
	

		<xsl:variable name="d" select="locjs:set_group_boxes_to_articles(string($groupBoxesToArticles))"/><!--  1 = make article groups, 0 = don't. set to 1 when article groups are wanted -->
		<xsl:variable name="d" select="locjs:set_sort_boxes_by_area_size(string($sortBoxesByAreaSize))"/><!--  1 = make article groups, 0 = don't. set to 1 when article groups are wanted -->
		<xsl:variable name="d" select="locjs:set_sort_boxes_by_y_position(string($sortBoxesByYposition))"/><!--  1 = box sorting -->
		<xsl:variable name="d" select="locjs:set_sort_box_y_tolerance(string($sortBoxYtolerance))"/><!--  set to 0.0 to use strict top-down sorting
																										  set to x.x to check for title box height too -->

		<xsl:if test="$overwriteCSSfiles != ''">
			<xsl:variable name="d" select="locjs:set_overwrite_CSS_files(string($overwriteCSSfiles))"/>
		</xsl:if>
		<xsl:if test="$imageTYPE != ''">
			<xsl:variable name="d" select="locjs:set_export_images(string($imageTYPE))"/>
			<!--
			  may be we have pre-converted images directly from InDesign? So, allow image boxes to be processed.
			<xsl:if test="(locjs:get_export_images() > 0) and ($ImageMagickVersion = '')">
				<xsl:variable name="d0" select="locjs:set_export_images('0')"/>
				<xsl:variable name="d1" select="myutils:showMess('&#10;#### ImageMagick not reachable: NO image conversion possible!','1')"/>
			</xsl:if>
			-->
		</xsl:if>
		
		<xsl:if test="$replaceFont != ''">
			<xsl:variable name="d" select="locjs:store_replaceFont(string($replaceFont))"/>
			<xsl:if test="$DEBUG = 1">
				<xsl:variable name="d" select="locjs:print_replaceFonts()"/>
			</xsl:if>
		</xsl:if>
		<xsl:variable name="css_fontfamily_string" select="locjs:set_css_font_family_string(string($CSSfontFamilyString))"/>

		<xsl:if test="$INTERNET_AWARE_FONTNAMES != ''">
			<xsl:variable name="d" select="locjs:set_internet_aware_fonttnames(string($INTERNET_AWARE_FONTNAMES))"/>
		</xsl:if>

		<xsl:if test="$fontsizeFactor != ''">
			<xsl:variable name="d3" select="locjs:store_fontsizeFactor(string($fontsizeFactor))"/>
		</xsl:if>
		<xsl:if test="$fontsizeMinimum != ''">
			<xsl:variable name="d3" select="locjs:store_fontsizeMinimum(string($fontsizeMinimum))"/>
		</xsl:if>
		<xsl:if test="$fontsizeUnits != ''">
			<xsl:variable name="d3" select="locjs:store_fontsizeUnits(string($fontsizeUnits))"/>
		</xsl:if>
		<xsl:if test="$fontsizeBase != ''">
			<xsl:variable name="d3" select="locjs:store_fontsizeBase(string($fontsizeBase))"/>
		</xsl:if>
		<xsl:if test="$catchRadius != ''">
			<xsl:variable name="d" select="locjs:set_catch_radius(string($catchRadius))"/>
		</xsl:if>
		<xsl:if test="$allBoxesNoCatch != ''"><!-- must be set BEFORE all other catching settings for it can be overridden by individual settings -->
			<xsl:variable name="d" select="locjs:set_all_no_boxcatch(string($allBoxesNoCatch))"/>
		</xsl:if>
		<xsl:if test="$unassignedBoxesNoCatch != ''">
			<xsl:variable name="d" select="locjs:set_unassigned_boxes_no_boxcatch(string($unassignedBoxesNoCatch))"/>
		</xsl:if>
		<xsl:if test="$emptyBoxesNoCatch != ''">
			<xsl:variable name="d" select="locjs:set_empty_boxes_no_boxcatch(string($emptyBoxesNoCatch))"/>
		</xsl:if>
		<xsl:if test="$textBoxesNoCatch != ''">
			<xsl:variable name="d" select="locjs:set_text_boxes_no_boxcatch(string($textBoxesNoCatch))"/>
		</xsl:if>
		<xsl:if test="$chainedBoxesNoCatch != ''">
			<xsl:variable name="d" select="locjs:set_chained_boxes_no_boxcatch(string($chainedBoxesNoCatch))"/>
		</xsl:if>
		<xsl:if test="$chainedFirstBoxesNoCatch != ''">
			<xsl:variable name="d" select="locjs:set_chained_firstboxes_no_boxcatch(string($chainedFirstBoxesNoCatch))"/>
		</xsl:if>
		<xsl:if test="$chainedFollowingBoxesNoCatch != ''">
			<xsl:variable name="d" select="locjs:set_chained_followingboxes_no_boxcatch(string($chainedFollowingBoxesNoCatch))"/>
		</xsl:if>
		<xsl:if test="$imageBoxesNoCatch != ''">
			<xsl:variable name="d" select="locjs:set_image_boxes_no_boxcatch(string($imageBoxesNoCatch))"/>
		</xsl:if>
		<xsl:if test="$pageframingBoxesNoCatch != ''">
			<xsl:variable name="d" select="locjs:set_pageframing_boxes_no_boxcatch(string($pageframingBoxesNoCatch))"/>
		</xsl:if>
		<xsl:if test="$pageframingBoxSizeThreshold != ''">
			<xsl:variable name="d" select="locjs:set_pageframing_boxsize_threshold(string($pageframingBoxSizeThreshold))"/>
		</xsl:if>

		<xsl:if test="$preconvertTextFlags != ''">
			<xsl:variable name="d" select="pubjs:set_preconverttext_flags(string($preconvertTextFlags))"/>
		</xsl:if>


		<!-- get document colors -->
		<xsl:call-template name="get_colors"/>

		<!-- store paragraph and character styles settings -->
		<xsl:variable name="d" select="locjs:store_CSSclassNamesNoUnderscore($CSSclassNamesNoUnderscore)"/>
		<xsl:variable name="d" select="locjs:store_CSSclassNamesASCII($CSSclassNamesASCII)"/>
		

		<!-- store the post-processor templates to call. defined in IMXepaper_includes.xsl -->
		<xsl:for-each select="xalan:nodeset($xsl-postprocessors)//xsl-stylesheets/call-template">
			<xsl:variable name="template" select="."/>
			<xsl:variable name="d" select="locjs:store_xml_post_processor_template(string($template))"/>
		</xsl:for-each>

		<!-- store the pre-processor templates to call. defined in IMXepaper_includes.xsl -->
		<xsl:for-each select="xalan:nodeset($xsl-preprocessors)//xsl-stylesheets/call-template">
			<xsl:variable name="template" select="."/>
			<xsl:variable name="d" select="locjs:store_xml_pre_processor_template(string($template))"/>
		</xsl:for-each>

		<!-- call/process pre-processor templates. defined in IMXstylesWriter.xsl -->
		<!-- call the main css writer template. defined in IMXstylesWriter.xsl -->
		<xsl:if test="locjs:have_xml_pre_processor_template('get_styles')">
			<xsl:variable name="d2" select="myutils:showMess('&#10;   ++ pre-processor call-template: get_styles','1')"/>
			<xsl:call-template name="get_styles">
				<xsl:with-param name="param" select="@param/."/>
			</xsl:call-template>
			<xsl:if test="$DEBUG = 1">
				<xsl:variable name="d1" select="locjs:print_CSS_styles()"/>
				<xsl:variable name="d2" select="myutils:showMess('************** end of CSS','1')"/>
			</xsl:if>
		</xsl:if>
		<!-- call the custom css writer template. defined in IMXstylesWriter.xsl -->
		<xsl:if test="locjs:have_xml_pre_processor_template('custom_css_writer')">
			<xsl:variable name="d2" select="myutils:showMess('&#10;   ++ pre-processor call-template: custom_css_writer&#10;','1')"/>
			<xsl:call-template name="custom_css_writer">
				<xsl:with-param name="param" select="@param/."/>
			</xsl:call-template>
		</xsl:if>

		<!-- call the custom pre-processing template named xsl-preprocessor1 to xsl-preprocessor9 -->
		<xsl:if test="locjs:have_xml_pre_processor_template('xsl-preprocessor1')">
			<xsl:variable name="d2" select="myutils:showMess('&#10;   ++ pre-processor call-template: xsl-preprocessor1&#10;','1')"/>
			<xsl:call-template name="xsl-preprocessor1">
				<xsl:with-param name="param" select="@param/."/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="locjs:have_xml_pre_processor_template('xsl-preprocessor2')">
			<xsl:variable name="d2" select="myutils:showMess('&#10;   ++ pre-processor call-template: xsl-preprocessor2&#10;','1')"/>
			<xsl:call-template name="xsl-preprocessor2">
				<xsl:with-param name="param" select="@param/."/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="locjs:have_xml_pre_processor_template('xsl-preprocessor3')">
			<xsl:variable name="d2" select="myutils:showMess('&#10;   ++ pre-processor call-template: xsl-preprocessor3&#10;','1')"/>
			<xsl:call-template name="xsl-preprocessor3">
				<xsl:with-param name="param" select="@param/."/>
			</xsl:call-template>
		</xsl:if>





		<!-- load font conversion tables for fonts defined in styles MUST BE AFTER get_styles -->
		<!-- xsl:variable name="d" select="locjs:loadFontConversionTables()"/ -->
		<xsl:for-each select="/Documents/Document/Fonts/FontFamily">
			<xsl:for-each select="Font">
				<xsl:variable name="d" select="locjs:loadFontConversionTables(string(@Name), string(@FontFamily))"/>
			</xsl:for-each>
		</xsl:for-each>


		<xsl:if test="$continuedArticleStyles !=''">
			<xsl:variable name="d" select="locjs:store_continuedAt_styles(string($continuedArticleStyles))"/>
		</xsl:if>
		<xsl:if test="$wwwLinkStyles !=''">
			<xsl:variable name="d" select="locjs:store_wwwLink_styles(string($wwwLinkStyles))"/>
		</xsl:if>

		<!-- collect spread and page infos for all boxes -->
		<xsl:call-template name="collect_box2page_infos"/>


		<!-- dive into the document content -->
		<xsl:variable name="d" select="locjs:init_anchored_objects_string_arr()"/>

<!--xsl:variable name="d" select="locjs:message('******************* scan_spreads')"/-->
		<xsl:call-template name="scan_spreads"/>
		<xsl:variable name="d08" select="myutils:showMess('&#10;','1')"/>

		<xsl:variable name="d" select="locjs:init_anchored_objects_string_arr()"/>

	</xsl:template>







	<!-- ===============================================
		 collect spread and page infos of each box
	     =============================================== -->
	<xsl:template name="collect_box2page_infos">
		<!-- collect all boxes in document to be able to get sprd and page position of any box -->
		<xsl:choose>
			<xsl:when test="$memoryUsageMode = '0'">
				<xsl:variable name="d" select="myutils:showMess('&#10;   ++ Collecting box to page infos')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="d" select="myutils:showMess('&#10;   ++ Collecting page infos')"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:variable name="d" select="locjs:init_pagebounds()" /><!-- reset page boundaries -->
		<xsl:variable name="d" select="locjs:init_page_sequenceDOM6()" /><!-- CS4 DOMversion 6 has no DCof to have physical page sequence, we must count it -->
		<xsl:for-each select="Spread/Spread">
			<xsl:variable name="spread_num" select="position()" />
			<xsl:variable name="page_count" select="@PageCount" /><!-- num pages on left side. 0 if start with a right (odd) page -->
			<xsl:variable name="BindingLocation" select="@BindingLocation" /><!-- Binding Location: num pages on left side. 0 if start with a right (odd) page -->
			<xsl:variable name="spread_self" select="@Self" />
			<xsl:variable name="dsprd" select="locjs:store_spread(string($spread_self), string(name()), string($spread_num), string($page_count), string($BindingLocation))" />

			<xsl:for-each select="Page">
				<xsl:variable name="pageOnSpread" select="position()" />
				<xsl:variable name="d" select="locjs:inc_page_sequenceDOM6()" /><!-- useful in CS4 and above only -->
				<xsl:variable name="thepage">
					<xsl:value-of select="locjs:get_page_sequenceDOM6()" />
				</xsl:variable>
				<xsl:variable name="page_self" select="@Self" />
				<xsl:variable name="page_sequence" select="locjs:get_physical_page_sequence(string($thepage))" />
				<xsl:variable name="page_name" select="locjs:re_replace(string(@Name),'~sep~','_','gi')" />
				<xsl:variable name="page_side">
					<!-- CS5 has a /Documents/Document/Preferences/DocumentPreference/@FacingPages which is 'true' for facing pages or 'false' for single pages -->
					<xsl:value-of select="locjs:get_page_side(string($pageOnSpread),string($BindingLocation),string(/Documents/Document/Preferences/DocumentPreference/@FacingPages/.))" />
				</xsl:variable>
				<xsl:variable name="d" select="locjs:store_pagebounds(string($page_sequence),string($spread_self),string($spread_num),string($page_self),string($pageOnSpread),string($page_name),string(@GeometricBounds),string(/Documents/Document/Preferences/DocumentPreference/@PageWidth/.),string(/Documents/Document/Preferences/DocumentPreference/@PageHeight/.),string($page_side),string($page_count))" />
				<xsl:variable name="d" select="locjs:set_pageJPEGScale(string($pageJPEGScale))"/><!-- must be AFTER store_pagebounds -->

				<xsl:if test="$memoryUsageMode = '0'">
					<xsl:for-each select="..//TextFrame | ..//Rectangle | ..//Oval | ..//Polygon | ..//Group | ..//GraphicLine | ..//Button"><!-- the boxes on the spread (may be on any page) and must have an @Self -->
						<!--xsl:variable name="d" select="locjs:message(concat('======== box: ',@Self,' page_sequence: ',$page_sequence))"/-->
						<!-- store box infos into box2page array -->
						<xsl:call-template name="store_box2page_infos">
							<xsl:with-param name="spread_num"><xsl:value-of select="$spread_num"/></xsl:with-param>
							<xsl:with-param name="spread_self"><xsl:value-of select="$spread_self"/></xsl:with-param>
							<xsl:with-param name="page"><xsl:value-of select="$thepage"/></xsl:with-param>
							<xsl:with-param name="page_sequence"><xsl:value-of select="$page_sequence"/></xsl:with-param>
							<xsl:with-param name="page_name"><xsl:value-of select="$page_name"/></xsl:with-param>
							<xsl:with-param name="page_side"><xsl:value-of select="$page_side"/></xsl:with-param>
							<xsl:with-param name="page_self"><xsl:value-of select="$page_self"/></xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>
		</xsl:for-each>
		<xsl:if test="$DEBUG = 1">
			<xsl:variable name="d" select="locjs:dump_spreads_arr()" />
			<xsl:variable name="d" select="locjs:dump_pages_arr()" />
			<xsl:variable name="d" select="locjs:dump_box2page_arr()" />
		</xsl:if>
		<xsl:if test="$memoryUsageMode = '0'">
			<xsl:variable name="d" select="myutils:showMess(concat('&#10;          total boxes collected: ',locjs:get_box2page_arr_length()))"/>
		</xsl:if>
	</xsl:template>



	<!-- start scanning the spreads - pages - textruns - images -->
	<xsl:template name="scan_spreads">
		<!-- prepare all anchored objects -->
		<xsl:variable name="d" select="locjs:set_anchoredobjects_mode(1)"/><!-- state, that we are currently collecting anchored objects -->

		<xsl:if test="$DEBUG = 1">
			<xsl:variable name="d" select="locjs:message('************** Anchored Objects **************')"/>
		</xsl:if>
		<xsl:variable name="d" select="myutils:showMess('&#10;   ** Collecting anchored objects','1')"/>

		<!-- prepare Hypertext URL Links -->
		<xsl:call-template name="prepare_hypertext_links"/>

		<!-- prepare footnote numbers -->
		<xsl:call-template name="prepare_footnotes"/>

		<!-- prepare notes -->
		<xsl:call-template name="prepare_notes"/>

		<!-- other anchored object -->
		<xsl:if test="descendant::Story/Story/descendant::TextFrame 
					or descendant::Story/Story/descendant::Group 
					or descendant::Story/Story/descendant::Rectangle 
					or descendant::Story/Story/descendant::Button 
					or descendant::Story/Story/descendant::Polygon 
					or descendant::Story/Story/descendant::Oval">
			<xsl:variable name="d" select="myutils:showMess('&#10;   ++ Preparing anchored objects','1')"/>
			<xsl:for-each select="descendant::Story/Story/descendant::TextFrame[name(..) != 'Group'] 
								| descendant::Story/Story/descendant::Group[name(..) != 'Group'] 
								| descendant::Story/Story/descendant::Rectangle[name(..) != 'Group']
								| descendant::Story/Story/descendant::Button[name(..) != 'Group']
								| descendant::Story/Story/descendant::Polygon[name(..) != 'Group']
								| descendant::Story/Story/descendant::Oval[name(..) != 'Group']">
				<xsl:variable name="anchorID" select="@Self"/>
				<xsl:if test="locjs:store_anchored_object_anchorid(string($anchorID)) = 0"><!-- store if not already stored -->
					<xsl:variable name="d06" select="locjs:init_articles()" /><!-- reset articles -->
					<xsl:variable name="anchored_objects_level1">
						<xsl:call-template name="get_anchored_object">
							<xsl:with-param name="level">1</xsl:with-param>
							<xsl:with-param name="anchorID"><xsl:value-of select="$anchorID"/></xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:variable name="anchored_objects_dom_string1" select="myutils:serializeDOM(xalan:nodeset($anchored_objects_level1),'0','yes')"/>
					<xsl:if test="$anchored_objects_dom_string1 != ''">
						<xsl:if test="$DEBUG = 1"><xsl:variable name="d" select="locjs:message(concat('************************STORING anchored object level 1: ',$anchored_objects_dom_string1))"/></xsl:if>
						<xsl:variable name="aos" select="locjs:store_anchored_objects_string(string($anchored_objects_dom_string1))" />
						<xsl:if test="$DEBUG = 1"><xsl:variable name="d" select="locjs:message('************************STORING1 END')"/></xsl:if>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>


		<!-- Tables -->
		<xsl:if test="descendant::Story/Story/descendant::Table">
			<xsl:variable name="d" select="myutils:showMess('&#10;   ++ Preparing Tables','1')"/>
			<xsl:for-each select="descendant::Story/Story/descendant::Table">
				<xsl:variable name="anchorID" select="@Self"/>
				<xsl:if test="locjs:store_anchored_object_anchorid(string($anchorID)) = 0"><!-- store if not already stored -->
					<xsl:variable name="d06" select="locjs:init_articles()" /><!-- reset articles -->
					<xsl:variable name="anchored_objects_level1">
						<xsl:call-template name="get_anchored_object">
							<xsl:with-param name="level">1</xsl:with-param>
							<xsl:with-param name="anchorID"><xsl:value-of select="$anchorID"/></xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:variable name="anchored_objects_dom_string1" select="myutils:serializeDOM(xalan:nodeset($anchored_objects_level1),'0','yes')"/>
					<xsl:if test="$anchored_objects_dom_string1 != ''">
						<xsl:if test="$DEBUG = 1"><xsl:variable name="d" select="locjs:message(concat('************************STORING Table level 1: ',$anchored_objects_dom_string1))"/></xsl:if>
						<xsl:variable name="ats" select="locjs:store_anchored_objects_string(string($anchored_objects_dom_string1))" />
						<xsl:if test="$DEBUG = 1"><xsl:variable name="d" select="locjs:message('************************STORING1 END')"/></xsl:if>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>


		<xsl:variable name="d" select="locjs:set_anchoredobjects_mode(0)"/><!-- state, that we are NOT collecting anchored objects any more -->
		<xsl:variable name="d" select="myutils:showMess(concat('&#10;   ** Total anchored objects collected: ',locjs:get_num_anchored_objects()))"/>

		<!-- merge the anchored objects in the anchored_objects element (the objects anchored in an anchored in an....) -->
		<xsl:if test="locjs:get_num_anchored_objects() &gt; 0">
			<!-- xsl:variable name="d" select="locjs:dump_anchored_objects('anchored1.txt')"/ --><!-- for DEBUG -->
			<xsl:variable name="d" select="myutils:showMess(concat('&#10;   ++ Merging ',locjs:get_num_anchored_objects(),' anchored objects '),'1')"/>

			<xsl:variable name="merged" select="locjs:merge_anchored_objects()"/>
			<xsl:variable name="d" select="myutils:showMess('&#10;   ++ Verifying anchored objects ','1')"/>
			<xsl:variable name="merged" select="locjs:merge_anchored_objects()"/>

		</xsl:if>



		<xsl:variable name="d" select="myutils:showMess('&#10;   ++ Scanning spreads ','1')"/>
		<xsl:variable name="d" select="locjs:init_articles()" /><!-- reset articles -->
		<xsl:variable name="indd_document"><!-- store all elements of the Indesign document into this variable for later processing -->
		<indd_document><!-- the content of the Indesign document -->
			<xsl:attribute name="docname"><xsl:value-of select="$docname" /></xsl:attribute>
			<xsl:attribute name="inputname"><xsl:value-of select="$INPUT_NAME" /></xsl:attribute>
			<xsl:attribute name="inputbasepath"><xsl:value-of select="$INPUT_PATH" /></xsl:attribute>
			<xsl:attribute name="inputsubpath"><xsl:value-of select="$INPUT_SUB_PATH" /></xsl:attribute>
			<xsl:attribute name="outputpath"><xsl:value-of select="$the_OUTPUT_PATH" /></xsl:attribute>

			<!-- scan preads -->
			<xsl:variable name="d" select="locjs:init_pagebounds()" /><!-- reset page bounbdaries -->
			<xsl:variable name="d" select="locjs:init_page_sequenceDOM6()" /><!-- CS4 DOMversion 6 has no DCof to have physical page sequence, we must count it -->
			<xsl:choose>
				<xsl:when test="Spread/Spread">
					<xsl:for-each select="Spread/Spread">
							<xsl:call-template name="get_spread_content"/>
					</xsl:for-each>
				</xsl:when>
				<xsl:when test="Spread">
					<xsl:for-each select="Spread">
							<xsl:call-template name="get_spread_content"/>
					</xsl:for-each>
				</xsl:when>
			</xsl:choose>
			<!-- check for a document PDF -->
			<xsl:call-template name="get_documentPDF"/>
		</indd_document>
		</xsl:variable>

		<!-- at this point, the variable $indd_document contains the elements sprd, page, box .....
			 we use this $indd_document variable to 
			 a) group boxes to articles 
			 b) generate the taget document -->

		<xsl:if test="(locjs:get_group_boxes_to_articles() = 1) or (locjs:get_sort_boxes_by_area_size() = 1)"><!-- make the groups or sort by area size -->
			<xsl:call-template name="store_all_boxes">
				<xsl:with-param name="XMLdoc"><xsl:copy-of select="$indd_document"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<xsl:variable name="articlegroups"><!-- store all elements of the Indesign document into this variable for later processing -->
			<xsl:if test="locjs:get_group_boxes_to_articles() = 1"><!--  1 = make the groups, 0 = don't -->
				<xsl:variable name="d" select="myutils:showMess('&#10;   ++ grouping boxes to articles','1')"/>
				<xsl:call-template name="create_article_groups">
					<xsl:with-param name="XMLdoc" select="xalan:nodeset($indd_document)"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="boxes"><!-- store all elements of the Indesign document into this variable for later processing -->
			<xsl:if test="locjs:get_sort_boxes_by_area_size() = 1"><!--  1 = do the sorting -->
				<xsl:call-template name="get_sorted_box_areas"/>
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="styles_expanded"><!-- get styles block in PRO version -->
			<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
				<xsl:call-template name="get_styles_expanded"/>
			</xsl:if>
		</xsl:variable>


		<!-- combine all element trees to one document -->
		<xsl:variable name="entireXML">
			<document>
				<xsl:attribute name="creation_year"><xsl:value-of select="locjs:getYear()"/></xsl:attribute>
				<xsl:attribute name="creation_date"><xsl:value-of select="locjs:getDate()"/></xsl:attribute>
				<xsl:attribute name="creation_time"><xsl:value-of select="locjs:getTime()"/></xsl:attribute>
				<xsl:attribute name="os"><xsl:value-of select="$SYSTEM_OS_NAME"/></xsl:attribute>
				<xsl:attribute name="vm"><xsl:value-of select="$SYSTEM_VM_VERSION"/></xsl:attribute>
				<xsl:attribute name="engine"><xsl:value-of select="$TRANSFORM_ENGINE"/></xsl:attribute>
				<xsl:attribute name="version"><xsl:value-of select="$XSLT_VERSION"/></xsl:attribute>
				<xsl:attribute name="xsltVersion"><xsl:value-of select="$XSLT_VERSION"/></xsl:attribute>
				<xsl:attribute name="xsltVersionDate"><xsl:value-of select="$XSLT_VERSIONDATE"/></xsl:attribute>

				<!-- add given XSL parameters -->
				<xsl:call-template name="output_XSL_params"/>

				<xsl:if test="$includeAnchoredObjectsBlock != '0'">
					<!--xsl:variable name="anchored_objects_string" select="locjs:get_anchored_objects_string()"/>
						<xsl:variable name="anchored_objects" select="myutils:parseStringToDom(string($anchored_objects_string))"/-->
					<xsl:variable name="anchored_objects" select="myutils:parseStringToDom(locjs:get_anchored_objects_string())"/>
					<xsl:copy-of select="$anchored_objects"/>
				</xsl:if>
				<xsl:copy-of select="$indd_document"/>
				<xsl:copy-of select="$boxes"/>
				<xsl:copy-of select="$articlegroups"/>

				<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
					<xsl:copy-of select="$styles_expanded"/>
				</xsl:if>

				<!-- add layer infos -->
				<xsl:call-template name="get_layers"/>

				<!-- add meta data -->
				<xsl:call-template name="get_metadata"/>
			</document>
		</xsl:variable>

		<xsl:variable name="dom_string" select="myutils:serializeDOM(xalan:nodeset($entireXML),'0','yes')"/>
		<!-- merge the anchored objects into the output stream -->
		<!-- ALWAYS call this function! it also removes unresolved __anchored_object__ markers -->
		<xsl:choose>
			<xsl:when test="locjs:get_num_anchored_objects() &gt; 0">
				<xsl:variable name="d" select="myutils:showMess(concat('&#10;   ++ Merging ',locjs:get_num_anchored_objects(),' anchored objects to output '),'1')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="d" select="myutils:showMess('&#10;   ++ Cleaning output from unknown anchored objects ','1')"/>
			</xsl:otherwise>
		</xsl:choose>
		<!-- we MUST do this again because we can have hyper links directly within the Story Element on same level like ParagraphStyleRange -->
		<xsl:variable name="XMLdom_string">
			<xsl:value-of select="locjs:merge_anchored_objects_to_output(string($dom_string),true())"/>
		</xsl:variable>

		<!-- dump to intermediary file -->
		<xsl:variable name="dumpfilename"><xsl:value-of select="$the_OUTPUT_PATH"/><xsl:value-of select="locjs:xPlatformName(string($docname))"/>_int.xml</xsl:variable>
		<xsl:variable name="d" select="myutils:showMess(concat('&#10;   ++ writing intermediary XML file to: ',$dumpfilename),'1')"/>
		<xsl:variable name="created" select="locjs:writeFile(string($dumpfilename),string($XMLdom_string),true)"/>
		<xsl:if test="$created = false">
			<xsl:variable name="d" select="myutils:showMess('&#10;### ERROR writing intermediary xml file!!','1')"/>
			<xsl:variable name="d" select="myutils:showMess(concat('&#10;### ERROR message: ',locjs:writeFile_lasterror()),'1')"/>
		</xsl:if>


		<!-- =========================================== -->
		<!-- create target file from intermediary file -->
		<!--xsl:variable name="dumpfilenameURI"><xsl:value-of select="locjs:encode_URI(string($dumpfilename))"/></xsl:variable-->

		<xsl:if test="($INTERMEDIARY_XML_only = '') or ($INTERMEDIARY_XML_only &gt; 0)"><!-- if set to 1 we create intermediary XML file only -->
			<!-- ========================
			     post-processing -->
			<!-- Create the default ePaper capable XML export from intermediary file. defined in IMX2xmlEpaperArticles.xsl -->
			<xsl:if test="locjs:have_xml_post_processor_template('makeXMLdefaultExport')">
				<xsl:variable name="d2" select="myutils:showMess('&#10;   ++ post-processor call-template: makeXMLdefaultExport','1')"/>
				<xsl:call-template name="makeXMLdefaultExport">
					<xsl:with-param name="XMLdumpfile" select="$dumpfilename"/><!-- $dumpfilename is the intermediary XML file -->
				</xsl:call-template>
			</xsl:if>

			<!-- Call post-processing templatex -->
			<xsl:if test="locjs:have_xml_post_processor_template('xsl-postprocessor1')">
				<xsl:variable name="d2" select="myutils:showMess('&#10;   ++ post-processor call-template: xsl-postprocessor1','1')"/>
				<xsl:call-template name="xsl-postprocessor1">
					<xsl:with-param name="XMLdumpfile" select="$dumpfilename"/><!-- $dumpfilename is the intermediary XML file -->
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="locjs:have_xml_post_processor_template('xsl-postprocessor2')">
				<xsl:variable name="d2" select="myutils:showMess('&#10;   ++ post-processor call-template: xsl-postprocessor2','1')"/>
				<xsl:call-template name="xsl-postprocessor2">
					<xsl:with-param name="XMLdumpfile" select="$dumpfilename"/><!-- $dumpfilename is the intermediary XML file -->
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="locjs:have_xml_post_processor_template('xsl-postprocessor3')">
				<xsl:variable name="d2" select="myutils:showMess('&#10;   ++ post-processor call-template: xsl-postprocessor3','1')"/>
				<xsl:call-template name="xsl-postprocessor3">
					<xsl:with-param name="XMLdumpfile" select="$dumpfilename"/><!-- $dumpfilename is the intermediary XML file -->
				</xsl:call-template>
			</xsl:if>


			<!-- evtl. create or add to folder index -->
			<xsl:if test="$the_FOLDERINDEXNAME != ''">
				<xsl:variable name="d0" select="pubjs:add_folder_index(string($OUTPUT_NAME))"/>
				<xsl:variable name="d" select="myutils:showMess(concat('&#10;+++ Writing folder index file for ',$OUTPUT_NAME,' to: ',$the_OUTPUT_PATH,$the_FOLDERINDEXNAME),'1')"/>
				<xsl:variable name="d1" select="pubjs:write_folder_index(concat($the_OUTPUT_PATH,$the_FOLDERINDEXNAME))"/>
			</xsl:if>
			
			<!-- write an index.php file -->
			<xsl:if test="$INDEXPHPNAME != ''">
				<xsl:variable name="d" select="myutils:showMess(concat('&#10;+++ Writing php index file for ',$OUTPUT_NAME,' to: ',$the_OUTPUT_PATH,$INDEXPHPNAME),'1')"/>
				<xsl:variable name="d1" select="pubjs:write_indexPHP(concat($the_OUTPUT_PATH,$INDEXPHPNAME), string($OUTPUT_NAME), concat($XSLCSSPath,$outputModeCustomXSL))"/>
			</xsl:if>
		</xsl:if>

		<!-- delete the intermediary file -->
		<xsl:if test="($INTERMEDIARY_XML_preserve = 0) and ($DEBUG != 1)">
			<xsl:variable name="d" select="myutils:deleteFile(string($dumpfilename))"/>
		</xsl:if>

	</xsl:template>


	<!-- get spread content -->
	<xsl:template name="get_spread_content">
				<xsl:variable name="spread_self" select="@Self" />
				<xsl:variable name="thespread_num" select="position()" />
				<xsl:variable name="BnLc"><xsl:value-of select="@BindingLocation" /></xsl:variable>
				<xsl:variable name="spread_num" select="$thespread_num" />
				<xsl:variable name="page_count" select="@PageCount" /><!-- num pages on left side. 0 if start with a right (odd) page -->

				<xsl:variable name="d" select="locjs:reset_footnote_number(0,string(name()))"/>
				<xsl:variable name="d" select="locjs:reset_footnote_number(0,string(name()),string($spread_num),'')"/>

				<xsl:comment> **** Spread #<xsl:value-of select="$thespread_num" /> </xsl:comment>
				<sprd>
					<xsl:attribute name="spread"><xsl:value-of select="$thespread_num" /></xsl:attribute><!-- sprd number 0,1,2... -->
					<xsl:attribute name="numpages"><xsl:value-of select="@PageCount" /></xsl:attribute><!-- num pages on spread -->
					<xsl:attribute name="BnLc"><xsl:value-of select="@BindingLocation" /></xsl:attribute>
					<xsl:attribute name="Self"><xsl:value-of select="@Self" /></xsl:attribute><!-- sprd ID -->

					<xsl:for-each select="Page">
						<xsl:variable name="pageOnSpread" select="position()" />

						<xsl:variable name="d" select="locjs:inc_page_sequenceDOM6()" />
						<xsl:variable name="thepage" select="locjs:get_page_sequenceDOM6()" />
						<xsl:variable name="page_self" select="@Self" />
						<xsl:variable name="page_sequence" select="locjs:get_physical_page_sequence(string($thepage))" />
						<xsl:variable name="page_name" select="locjs:re_replace(string(@Name),'~sep~','_','gi')" />
						<xsl:variable name="thepage_side" select="locjs:get_page_side(string($pageOnSpread),string($BnLc),string(/Documents/Document/Preferences/DocumentPreference/@FacingPages/.))" />
						<xsl:variable name="d" select="locjs:store_pagebounds(string($page_sequence),string($spread_self),string($spread_num),string($page_self),string($pageOnSpread),string($page_name),string(@GeometricBounds),string(/Documents/Document/Preferences/DocumentPreference/@PageWidth),string(/Documents/Document/Preferences/DocumentPreference/@PageHeight),string($thepage_side),string($page_count))" />
						<xsl:variable name="d" select="locjs:set_pageJPEGScale(string($pageJPEGScale))"/><!-- must be AFTER store_pagebounds -->

						<xsl:variable name="sectionNumbering">
							<!-- "section prefix"/#/"numbering type"/#/"automatic numberif (t, f)"/#/"start page number with section marker (t, f)..."/#/"page number"/#/"section marker" -->
							<xsl:if test="Section[@PageStart = $page_self]">
								<xsl:value-of select="Section[@PageStart = $page_self]/@SectionPrefix"/><xsl:text>/#/</xsl:text>
								<xsl:value-of select="Section[@PageStart = $page_self]/Properties/PageNumberStyle/."/><xsl:text>/#/</xsl:text>
								<xsl:value-of select="Section[@PageStart = $page_self]/@ContinueNumbering"/><xsl:text>/#/</xsl:text>
								<xsl:value-of select="Section[@PageStart = $page_self]/@IncludeSectionPrefix"/><xsl:text>/#/</xsl:text>
								<xsl:value-of select="Section[@PageStart = $page_self]/@PageNumberStart"/><xsl:text>/#/</xsl:text>
								<xsl:value-of select="Section[@PageStart = $page_self]/@Marker"/><xsl:text>/#/</xsl:text>
							</xsl:if>
						</xsl:variable>

						<xsl:variable name="previous_page_name">
							<xsl:choose>
								<xsl:when test="preceding-sibling::Page">
									<xsl:value-of select="locjs:re_replace(string(preceding-sibling::Page/@Name),'~sep~','_','gi')" />
								</xsl:when>
								<xsl:when test="/Documents/Document/Spread[position() = ($thespread_num - 1)]/Spread/Page[position() = last()]">
									<xsl:value-of select="locjs:re_replace(string(/Documents/Document/Spread[position() = ($thespread_num - 1)]/Spread/Page[position() = last()]/@Name),'~sep~','_','gi')" />
								</xsl:when>
							</xsl:choose>
						</xsl:variable>
						<xsl:variable name="next_page_name">
							<xsl:choose>
								<xsl:when test="following-sibling::Page">
									<xsl:value-of select="locjs:re_replace(string(following-sibling::Page/@Name),'~sep~','_','gi')" />
								</xsl:when>
								<xsl:when test="../../following::Spread/Spread/Page[position() = 1]">
									<xsl:value-of select="locjs:re_replace(string(../../following::Spread/Spread/Page[position() = 1]/@Name),'~sep~','_','gi')" />
								</xsl:when>
							</xsl:choose>
						</xsl:variable>
						<!-- xsl:variable name="d" select="locjs:message(concat('**** spread position: ',$thespread_num, ' current page name: ', $page_name,' previous: ',$previous_page_name,' next: ',$next_page_name))"/-->

						<xsl:variable name="d" select="locjs:store_current_pagenumbers(string($thepage), string($page_sequence), string($page_name), string($thepage_side), string(@AppliedMaster), string($sectionNumbering), string(MarginPreference/@ColumnCount), string(MarginPreference/@ColumnGutter), string(MarginPreference/@Top), string(MarginPreference/@Bottom), string(MarginPreference/@Left), string(MarginPreference/@Right), string(MarginPreference/@ColumnDirection), string($previous_page_name), string($next_page_name))"/>

						<xsl:variable name="d" select="locjs:reset_footnote_number(0,string(name()),string($spread_num),string($page_name),string($page_self),string(/Documents/Document//Section[@PageStart = $page_self]/@Self))"/>
						<xsl:comment> **** Page sequence #<xsl:value-of select="$page_sequence" /> </xsl:comment>

						<page>
							<xsl:attribute name="Self"><xsl:value-of select="@Self" /></xsl:attribute><!-- page ID -->
							<xsl:attribute name="docname"><xsl:value-of select="$docname" /></xsl:attribute><!-- source indd doc name -->
							<xsl:attribute name="spread"><xsl:value-of select="$thespread_num" /></xsl:attribute>
							<xsl:attribute name="pageOnSpread"><xsl:value-of select="$pageOnSpread" /></xsl:attribute><!-- page sequence on spread -->
							<xsl:attribute name="page_sequence"><xsl:value-of select="$page_sequence" /></xsl:attribute><!-- page sequence number 1,2,3... -->
							<xsl:attribute name="page_name"><xsl:value-of select="$page_name" /></xsl:attribute><!-- page name like 22,23... -->
							<xsl:attribute name="page_side"><xsl:value-of select="$thepage_side" /></xsl:attribute><!-- lfth or rgth or usex -->
							<xsl:attribute name="page_left"><xsl:value-of select="locjs:get_page_left()" /></xsl:attribute>
							<xsl:attribute name="page_right"><xsl:value-of select="locjs:get_page_right()" /></xsl:attribute>
							<xsl:attribute name="w"><xsl:value-of select="locjs:get_page_width()" /></xsl:attribute>
							<xsl:attribute name="h"><xsl:value-of select="locjs:get_page_height()" /></xsl:attribute>
							<xsl:attribute name="y0"><xsl:value-of select="locjs:y0()" /></xsl:attribute>
							<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
								<xsl:attribute name="master"><xsl:value-of select="locjs:get_current_pagenumbers(4)" /></xsl:attribute>
								<xsl:attribute name="colcnt"><xsl:value-of select="locjs:get_current_pagenumbers(7)" /></xsl:attribute>
								<xsl:attribute name="colgutt"><xsl:value-of select="locjs:get_current_pagenumbers(8)" /></xsl:attribute>
								<xsl:attribute name="coldir"><xsl:value-of select="locjs:get_current_pagenumbers(13)" /></xsl:attribute>
								<xsl:attribute name="margtop"><xsl:value-of select="locjs:get_current_pagenumbers(9)" /></xsl:attribute>
								<xsl:attribute name="margbott"><xsl:value-of select="locjs:get_current_pagenumbers(10)" /></xsl:attribute>
								<xsl:attribute name="margleft"><xsl:value-of select="locjs:get_current_pagenumbers(11)" /></xsl:attribute>
								<xsl:attribute name="margright"><xsl:value-of select="locjs:get_current_pagenumbers(12)" /></xsl:attribute>
								<xsl:attribute name="numbtypesc"><xsl:value-of select="locjs:get_current_pagenumbers(6)" /></xsl:attribute>
								<xsl:attribute name="sectprefix"><xsl:value-of select="locjs:get_current_pagenumbers(5,0)" /></xsl:attribute>
								<xsl:attribute name="numbtype"><xsl:value-of select="locjs:get_current_pagenumbers(5,1)" /></xsl:attribute>
								<xsl:attribute name="autonumb"><xsl:value-of select="locjs:get_current_pagenumbers(5,2)" /></xsl:attribute>
								<xsl:attribute name="startpage"><xsl:value-of select="locjs:get_current_pagenumbers(5,4)" /></xsl:attribute>
								<xsl:attribute name="addsectionmarker"><xsl:value-of select="locjs:get_current_pagenumbers(5,3)" /></xsl:attribute>
								<xsl:attribute name="sectmark"><xsl:value-of select="locjs:get_current_pagenumbers(5,5)" /></xsl:attribute>
							</xsl:if>

							<xsl:variable name="d1" select="myutils:showMess(concat('&#10;   ++ Exporting Page #',$thepage),'1')"/>
							<!-- get the JPEG of this page -->
							<xsl:variable name="d" select="locjs:reset_pageJPEG()"/>
							<xsl:call-template name="get_pageJPEG">
								<xsl:with-param name="thepage"><xsl:value-of select="$thepage"/></xsl:with-param>
								<xsl:with-param name="page_sequence"><xsl:value-of select="$page_sequence"/></xsl:with-param>
								<xsl:with-param name="page_name"><xsl:value-of select="$page_name"/></xsl:with-param>
								<xsl:with-param name="pagescale_num">1</xsl:with-param>
							</xsl:call-template>
							<!-- get the PDF of this page -->
							<xsl:call-template name="get_pagePDF">
								<xsl:with-param name="thepage"><xsl:value-of select="$thepage"/></xsl:with-param>
								<xsl:with-param name="page_sequence"><xsl:value-of select="$page_sequence"/></xsl:with-param>
								<xsl:with-param name="page_name"><xsl:value-of select="$page_name"/></xsl:with-param>
							</xsl:call-template>

							<!-- get articles areas and text to this page and store in variable 'areas_and_articles' -->
							<xsl:variable name="d" select="myutils:showMess('&#10;      - Exporting content','1')"/>
							<xsl:variable name="d" select="locjs:init_boxes()" />
							<xsl:apply-templates select="../*"><!-- the boxes on the page -->
								<xsl:with-param name="spread_self"><xsl:value-of select="$spread_self"/></xsl:with-param>
								<xsl:with-param name="spread"><xsl:value-of select="$thespread_num"/></xsl:with-param>
								<xsl:with-param name="page_self"><xsl:value-of select="$page_self"/></xsl:with-param>
								<xsl:with-param name="page"><xsl:value-of select="$thepage"/></xsl:with-param>
								<xsl:with-param name="page_sequence"><xsl:value-of select="$page_sequence"/></xsl:with-param>
								<xsl:with-param name="page_name"><xsl:value-of select="$page_name"/></xsl:with-param>
								<xsl:with-param name="pageside"><xsl:value-of select="$thepage_side"/></xsl:with-param>
								<xsl:with-param name="maxwidth"><xsl:value-of select="locjs:get_page_width()"/></xsl:with-param>
								<xsl:with-param name="maxheight"><xsl:value-of select="locjs:get_page_height()"/></xsl:with-param>
								<xsl:with-param name="groupid"></xsl:with-param>
								<xsl:with-param name="anchorID"></xsl:with-param>
							</xsl:apply-templates>
						</page>
					</xsl:for-each>
				</sprd>
	</xsl:template>


	<!-- store box infos into box2page array -->
	<xsl:template name="store_box2page_infos">
		<xsl:param name="spread_num"/>
		<xsl:param name="spread_self"/>
		<xsl:param name="page"/>
		<xsl:param name="page_sequence"/>
		<xsl:param name="page_name"/>
		<xsl:param name="page_side"/>
		<xsl:param name="page_self"/>
		<!-- store this box' layer ID and visibility of layer -->
		<xsl:variable name="layerID">
			<xsl:choose>
				<xsl:when test="@ItemLayer"><xsl:value-of select="@ItemLayer"/></xsl:when>
				<xsl:when test="ancestor::Group/@ItemLayer"><xsl:value-of select="ancestor::Group/@ItemLayer"/></xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="layerName">
			<xsl:if test="$layerID != ''">
				<xsl:value-of select="/Documents/Document/Layer[@Self = $layerID]/@Name/."/>
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="layerVisibility">
			<xsl:choose>
				<xsl:when test="$layerID != ''">
					<xsl:value-of select="/Documents/Document/Layer[@Self = $layerID]/@Visible/."/>
				</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- check if box is not excluded by script label -->
		<xsl:variable name="label_noexp">
			<xsl:choose>
				<xsl:when test="contains(Properties/Label/KeyValuePair[@Key = 'Label']/@Value/.,'*noexp*')">1</xsl:when>
				<xsl:when test="locjs:is_excludeLayer(string($layerName)) = true()">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!--xsl:variable name="d" select="locjs:message(concat('     +++++ ',name(),': ',@Self,' page_sequence: ',$page_sequence,' Visible: ',@Visible,' layerID: ',$layerID,' layerVisibility: ',$layerVisibility))"/-->
		<xsl:if test="( not(($layerVisibility = 'false') and ($excludeHiddenLayers = '1')) and ($label_noexp = '0') )"><!-- not hidden layer or *noexp*, on this page or anchored box -->

			<!-- store this box' geometry and also group containing it. attention: skip imagInImage box: go one higher -->
			<xsl:variable name="d" select="locjs:init_parent_groupboxes()"/>
			<xsl:variable name="d2" select="locjs:reset_IGeos()"/>
			<!-- get image in image IGeo -->
			<xsl:if test="(name(..) = 'Rectangle') or (name(..) = 'Polygon') or (name(..) = 'Oval') or (name(..) = 'Button')">
				<xsl:variable name="igeo">
					<xsl:choose>
						<xsl:when test="../Properties/PathGeometry">
							<xsl:for-each select="../Properties/PathGeometry/GeometryPathType/PathPointArray/PathPointType">
								<xsl:value-of select="@Anchor"/><xsl:if test="position() != last()"><xsl:text> </xsl:text></xsl:if>
							</xsl:for-each>
							<xsl:text>;</xsl:text><xsl:value-of select="../@ItemTransform"/>
						</xsl:when>
						<xsl:when test="../Properties/PathBoundingBox"><!-- like for Button -->
							<xsl:value-of select="../Properties/PathBoundingBox/@Left"/><xsl:text> </xsl:text><xsl:value-of select="../Properties/PathBoundingBox/@Top"/><xsl:text> </xsl:text>
							<xsl:value-of select="../Properties/PathBoundingBox/@Left"/><xsl:text> </xsl:text><xsl:value-of select="../Properties/PathBoundingBox/@Bottom"/><xsl:text> </xsl:text>
							<xsl:value-of select="../Properties/PathBoundingBox/@Right"/><xsl:text> </xsl:text><xsl:value-of select="../Properties/PathBoundingBox/@Bottom"/><xsl:text> </xsl:text>
							<xsl:value-of select="../Properties/PathBoundingBox/@Right"/><xsl:text> </xsl:text><xsl:value-of select="../Properties/PathBoundingBox/@Top"/>
							<xsl:text>;</xsl:text><xsl:value-of select="../@ItemTransform"/>
						</xsl:when>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="d2" select="locjs:store_imagInImage_IGeo(string($igeo))"/>
			</xsl:if>
			<xsl:variable name="groupbox1_igeo">
				<xsl:choose>
					<xsl:when test="(name(..) = 'Rectangle') or (name(..) = 'Polygon') or (name(..) = 'Oval')">
						<xsl:if test="name(../..) = 'Group'"><xsl:text>;</xsl:text><xsl:value-of select="../../@ItemTransform" /><xsl:variable name="groupIDs" select="locjs:ad_to_parent_groupboxes(name(),string(../../@Self))"/></xsl:if>
					</xsl:when>
					<xsl:when test="name(..) = 'Group'"><xsl:text>;</xsl:text><xsl:value-of select="../@ItemTransform" /><xsl:variable name="groupIDs" select="locjs:ad_to_parent_groupboxes(name(),string(../@Self))"/></xsl:when>
					<xsl:when test="name(..) = 'Button'"><xsl:text>;</xsl:text><xsl:value-of select="../@ItemTransform" /></xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="groupbox2_igeo">
				<xsl:choose>
					<xsl:when test="(name(..) = 'Rectangle') or (name(..) = 'Polygon') or (name(..) = 'Oval')">
						<xsl:if test="name(../../..) = 'Group'"><xsl:text>;</xsl:text><xsl:value-of select="../../../@ItemTransform" /><xsl:variable name="groupIDs" select="locjs:ad_to_parent_groupboxes(name(),string(../../../@Self))"/></xsl:if>
					</xsl:when>
					<xsl:when test="name(../..) = 'Group'"><xsl:text>;</xsl:text><xsl:value-of select="../../@ItemTransform" /><xsl:variable name="groupIDs" select="locjs:ad_to_parent_groupboxes(name(),string(../../@Self))"/></xsl:when>
					<xsl:when test="name(../..) = 'Button'"><xsl:text>;</xsl:text><xsl:value-of select="../../@ItemTransform" /></xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="groupbox3_igeo">
				<xsl:choose>
					<xsl:when test="(name(..) = 'Rectangle') or (name(..) = 'Polygon') or (name(..) = 'Oval')">
						<xsl:if test="name(../../../..) = 'Group'"><xsl:text>;</xsl:text><xsl:value-of select="../../../../@ItemTransform" /><xsl:variable name="groupIDs" select="locjs:ad_to_parent_groupboxes(name(),string(../../../../@Self))"/></xsl:if>
						<xsl:if test="name(../../../..) = 'Button'"><xsl:text>;</xsl:text><xsl:value-of select="../../../../@ItemTransform" /></xsl:if>
					</xsl:when>
					<xsl:when test="name(../../..) = 'Group'"><xsl:text>;</xsl:text><xsl:value-of select="../../../@ItemTransform" /><xsl:variable name="groupIDs" select="locjs:ad_to_parent_groupboxes(name(),string(../../../@Self))"/></xsl:when>
					<xsl:when test="name(../../..) = 'Button'"><xsl:text>;</xsl:text><xsl:value-of select="../../../@ItemTransform" /></xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="groupbox4_igeo">
				<xsl:choose>
					<xsl:when test="(name(..) = 'Rectangle') or (name(..) = 'Polygon') or (name(..) = 'Oval')">
						<xsl:if test="name(../../../../..) = 'Group'"><xsl:text>;</xsl:text><xsl:value-of select="../../../../../@ItemTransform" /><xsl:variable name="groupIDs" select="locjs:ad_to_parent_groupboxes(name(),string(../../../../../@Self))"/></xsl:if>
						<xsl:if test="name(../../../../..) = 'Button'"><xsl:text>;</xsl:text><xsl:value-of select="../../../../../@ItemTransform" /></xsl:if>
					</xsl:when>
					<xsl:when test="name(../../../..) = 'Group'"><xsl:text>;</xsl:text><xsl:value-of select="../../../../@ItemTransform" /><xsl:variable name="groupIDs" select="locjs:ad_to_parent_groupboxes(name(),string(../../../../@Self))"/></xsl:when>
					<xsl:when test="name(../../../..) = 'Button'"><xsl:text>;</xsl:text><xsl:value-of select="../../../../@ItemTransform" /></xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
	
			<xsl:variable name="colcnt" select="TextFramePreference/@TextColumnCount/."/>
			<xsl:variable name="colwidth" select="TextFramePreference/@TextColumnFixedWidth/."/>
			<xsl:variable name="colgutter" select="TextFramePreference/@TextColumnGutter/."/>
			<xsl:variable name="vjust" select="TextFramePreference/@VerticalJustification/."/>
			<xsl:variable name="paraspacelimit" select="TextFramePreference/@VerticalThreshold/."/>
			<xsl:variable name="textinsets">
				<xsl:for-each select="TextFramePreference/Properties/InsetSpacing/ListItem"><!-- top left bottom right -->
					<xsl:value-of select="."/><xsl:if test="position() != last()"><xsl:text> </xsl:text></xsl:if>
				</xsl:for-each>
			</xsl:variable>
	
			<xsl:variable name="anchoredObject_self">
				<xsl:if test="AnchoredObjectSetting"><xsl:value-of select="@Self"/></xsl:if>
			</xsl:variable>
	
	
			<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
				<xsl:variable name="d" select="locjs:message(concat('     ----- trying to store ',name(),': ',@Self,' on spread: ',$spread_num,' for page sequence: ',$page_sequence,' textinsets: ',$textinsets,' colgutter: ',$colgutter))"/>
			</xsl:if>
			<xsl:variable name="igeo">
				<xsl:choose>
					<xsl:when test="Properties/PathGeometry">
						<xsl:for-each select="Properties/PathGeometry/GeometryPathType/PathPointArray/PathPointType">
							<xsl:value-of select="@Anchor"/><xsl:if test="position() != last()"><xsl:text> </xsl:text></xsl:if>
						</xsl:for-each>
						<xsl:text>;</xsl:text><xsl:value-of select="@ItemTransform"/>
					</xsl:when>
					<xsl:when test="Properties/PathBoundingBox"><!-- like for Button -->
						<xsl:value-of select="Properties/PathBoundingBox/@Left"/><xsl:text> </xsl:text><xsl:value-of select="Properties/PathBoundingBox/@Top"/><xsl:text> </xsl:text>
						<xsl:value-of select="Properties/PathBoundingBox/@Left"/><xsl:text> </xsl:text><xsl:value-of select="Properties/PathBoundingBox/@Bottom"/><xsl:text> </xsl:text>
						<xsl:value-of select="Properties/PathBoundingBox/@Right"/><xsl:text> </xsl:text><xsl:value-of select="Properties/PathBoundingBox/@Bottom"/><xsl:text> </xsl:text>
						<xsl:value-of select="Properties/PathBoundingBox/@Right"/><xsl:text> </xsl:text><xsl:value-of select="Properties/PathBoundingBox/@Top"/>
						<xsl:text>;</xsl:text><xsl:value-of select="@ItemTransform"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="belongs_to_page" select="locjs:store_coords(string($igeo),locjs:get_imagInImage_IGeo(),string($spread_num),string($page_sequence),string($page_side),string(name()),string(@Self),string($groupbox1_igeo),string($groupbox2_igeo),string($groupbox3_igeo),string($groupbox4_igeo),locjs:get_parent_groupboxes(),string(Properties/Label/KeyValuePair[@Key = 'Label']/@Value/.),string($layerID),string($layerName),string($layerVisibility),string($textinsets),string($colcnt),string($colwidth),string($colgutter),string($vjust),string($paraspacelimit),string($anchoredObject_self))" />
			<xsl:choose>
				<xsl:when test="$belongs_to_page &lt; 0"><!-- box is already stored and belong to a page or: -1 is on left spread, -2 on right spread -->
					<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
						<xsl:variable name="d" select="locjs:message(concat('     ----- ',name(),': ',@Self,' is already stored'))"/>
					</xsl:if>
				</xsl:when>
				<xsl:when test="$belongs_to_page = 0"><!-- box does not belong to a page: unknown condition -->
				</xsl:when>
				<xsl:when test="$belongs_to_page != $page"><!-- box does not belong to the page currently processed -->
				</xsl:when>
				<xsl:when test="name() = 'Group'"><!-- recall us: we are in a group -->
				</xsl:when>
				<xsl:otherwise><!-- store this box: it belongs to a page -->
					<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
						<xsl:variable name="d" select="locjs:message(concat('     ----- storing ',name(),': ',@Self,' page sequence: ',$page_sequence,' type: ',name(),' belongs to page: ',$belongs_to_page))"/>
					</xsl:if>
					<xsl:variable name="d" select="locjs:store_box2page(string($spread_num),string($spread_self),string($page),string($page_sequence),string($page_name),string($page_side),string($page_self),string(name()),string(@Self))" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>




	<xsl:template name="get_anchored_object">
		<xsl:param name="level"/>
		<xsl:param name="anchorID"/>
		<anchored_object>
			<xsl:attribute name="anchorid"><xsl:value-of select="$anchorID" /></xsl:attribute>
			<xsl:attribute name="idx"><xsl:value-of select="locjs:get_num_anchored_objects()" /></xsl:attribute>
			<xsl:attribute name="name"><xsl:value-of select="name()" /></xsl:attribute>
			<xsl:attribute name="Self"><xsl:value-of select="@Self" /></xsl:attribute>
			<xsl:attribute name="level"><xsl:value-of select="$level" /></xsl:attribute>
			
			<xsl:variable name="imagepagearea">
				<xsl:if test="contains(descendant::Properties/Label/KeyValuePair[@Key = 'Label']/@Value/.,'ag_gb:')">
					<xsl:variable name="d" select="locjs:store_splitlabel(string(descendant::Properties/Label/KeyValuePair[@Key = 'Label']/@Value/.))" /><!-- store lable -->
					<xsl:variable name="ag_gb" select="locjs:get_splitlabel('ag_gb:')" /><!-- get anchored graphic graphics boundary -->
					<xsl:if test="$ag_gb != ''">
						<xsl:value-of select="$ag_gb"/>
					</xsl:if>
				</xsl:if>
			</xsl:variable>
			<xsl:if test="$imagepagearea != ''">
				<xsl:attribute name="imagepagearea"><xsl:value-of select="$imagepagearea" /></xsl:attribute>
			</xsl:if>

			<xsl:apply-templates select="../*[@Self = $anchorID]">
				<xsl:with-param name="maxwidth">0</xsl:with-param>
				<xsl:with-param name="maxheight">0</xsl:with-param>
				<xsl:with-param name="anchorid"><xsl:value-of select="$anchorID" /></xsl:with-param>
				<xsl:with-param name="imagepagearea"><xsl:value-of select="$imagepagearea" /></xsl:with-param>
			</xsl:apply-templates>
		</anchored_object>
	</xsl:template>



	<xsl:template name="get_pageJPEG">
		<xsl:param name="thepage"/>
		<xsl:param name="page_sequence"/>
		<xsl:param name="page_name"/>
		<xsl:param name="pagescale_num"/>

		<xsl:if test="locjs:hasnext_pageJPEG() = true()">

			<xsl:variable name="pageJPEGname"><xsl:value-of select="concat($docname,'_p',locjs:get_jpeg_page_num(string($thepage)),'.jpg')"/></xsl:variable>
			<xsl:variable name="pageJPEGpath"><xsl:value-of select="$INPUT_PATH"/><xsl:value-of select="$pageJPEGname"/></xsl:variable>

			<xsl:variable name="d0" select="locjs:store_Value(0,'')"/>
			<xsl:variable name="exists" select="locjs:fileExists(string($pageJPEGpath))"/>
			<xsl:if test="$DEBUG = 1">
				<xsl:variable name="d" select="locjs:message(concat('****** Looking for original Page JPEG: ',$pageJPEGpath))"/>
			</xsl:if>
			<xsl:if test="($exists = 'true')"><xsl:variable name="d0" select="locjs:store_Value(0,string($pageJPEGname))"/></xsl:if><!-- store original name -->

			<!-- create resized jpeg name -->
			<xsl:if test="$exists = 'true'">
				<xsl:variable name="origWidth" select="locjs:get_page_width()"/>
				<xsl:variable name="origHeight" select="locjs:get_page_height()"/>
				<xsl:variable name="newWidth" select="locjs:get_pageJPEGWidth()"/>
				<xsl:variable name="newHeight" select="locjs:get_pageJPEGHeight()"/>

				<xsl:variable name="resizedPageJPEGname">
					<xsl:variable name="tmp_resizedPageJPEGname"><xsl:value-of select="locjs:create_new_name(string($pageJPEGname),locjs:get_pageJPEGScale100())"/></xsl:variable>
					<!--xsl:value-of select="locjs:encode_URI(string($tmp_resizedPageJPEGname),string($my_XPLATFORM_NAMES),string($thepage),3,false())"/-->
					<xsl:value-of select="$tmp_resizedPageJPEGname"/>
				</xsl:variable>
				<xsl:variable name="d0" select="locjs:store_Value(0,string($resizedPageJPEGname))"/>

				<xsl:variable name="m0">&#10;      - Resizing Page Image <xsl:value-of select="$pagescale_num"/> of <xsl:value-of select="locjs:get_numPageJPEGs()"/> (<xsl:value-of select="$origWidth"/>x<xsl:value-of select="$origHeight"/> to <xsl:value-of select="$newWidth"/>x<xsl:value-of select="$newHeight"/>): '<xsl:value-of select="$pageJPEGname"/>' to '<xsl:value-of select="$resizedPageJPEGname"/>': </xsl:variable>
				<xsl:variable name="d1" select="myutils:showMess(string($m0),'1')"/>

				<!-- call external Image Converter 'ImageMagick' -->
				<xsl:variable name="source"><xsl:value-of select="$INPUT_PATH"/><xsl:value-of select="$pageJPEGname"/></xsl:variable>
				<xsl:variable name="target"><xsl:value-of select="$the_OUTPUT_PATH"/><xsl:value-of select="$resizedPageJPEGname"/></xsl:variable>
				<xsl:variable name="d" select="locjs:storePageJPEGname(string($pageJPEGname))"/>

				<xsl:variable name="resize_param">-resize <xsl:value-of select="$newWidth"/>x<xsl:value-of select="$newHeight"/></xsl:variable>

				<xsl:variable name="mypageJPEGParams" select="locjs:removePercent(string(normalize-space($pageJPEGParams)))"/>
				<xsl:variable name="params" select="locjs:createParamString(string($mypageJPEGParams),locjs:escapeMagick(string($source)),string($IMPageJPEGdpi),string($resize_param),string($IMPageJPEGquality),string($pageJPEGfinish),locjs:escapeMagick(string($target)))"/>

				<xsl:variable name="imageconverted">
					<xsl:choose>
						<xsl:when test="$ImageMagickConvert != ''"><!-- create resized page jpeg using ImageMagick's CONVERT program if reachable -->
							<xsl:if test="($DEBUG = 1) or ($DEBUGPAGEIMAGES = 1)">
								<xsl:variable name="d" select="locjs:message(concat('****** Resizing Page Image pageJPEGdpi: ',$pageJPEGdpi,' params: ',$params))"/>
								<xsl:variable name="d" select="locjs:message(concat('****** page image: ',$ImageMagickConvert,' ',$params))"/>
							</xsl:if>
							<xsl:value-of select="myutils:callExternalApp(string($ImageMagickConvert),$params,$ImageMagickConvertEnvir,'',$filenameConversion)"/>
						</xsl:when>
						<xsl:otherwise><!-- use internal BatchXSLT converter -->
							<xsl:if test="($DEBUG = 1) or ($DEBUGPAGEIMAGES = 1)">
								<xsl:variable name="startmess">****** Resizing Page Image (internal): scale=<xsl:value-of select="locjs:get_pageJPEGScale()"/>, quality=<xsl:value-of select="string($pageJPEGQuality)"/>, dpi=<xsl:value-of select="string($pageJPEGdpi)"/>, <xsl:value-of select="$source"/>, <xsl:value-of select="$target"/></xsl:variable>
								<xsl:variable name="d" select="locjs:message(string($startmess))"/>
							</xsl:if>

							<xsl:value-of select="myutils:resize_jpeg(string($source),string($target),locjs:get_pageJPEGScale(),locjs:parseToFloat(string($pageJPEGQuality)),67,2,locjs:parseToInt(string($pageJPEGdpi)),locjs:parseToInt(string($newWidth)),locjs:parseToInt(string($newHeight)))"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="exists" select="locjs:fileExists(string($target))"/>
				<xsl:variable name="m1"><xsl:choose><xsl:when test="$exists='true'">OK</xsl:when><xsl:otherwise>### ERROR: <xsl:value-of select="$imageconverted"/></xsl:otherwise></xsl:choose></xsl:variable>
				<xsl:variable name="d" select="myutils:showMess(string($m1),'1')"/>

				<!-- evtl. copy original page JPEGfiles to output folder (for magnifier glass or recreation of images) -->
				<xsl:if test="($magnifyingGlass != '0') or ((($imageMissingCreateFromPagePreview = '3') or ($imageMissingCreateFromPagePreview = '4')) and ($imagesTotalSourcesMissing != '0'))">
					<xsl:variable name="d" select="myutils:copyFile(string($INPUT_PATH),string($pageJPEGname),string($the_OUTPUT_PATH),string($pageJPEGname),1,false)"/>
				</xsl:if>

				<xsl:variable name="pageJPEGsequ">
					<xsl:choose>
						<xsl:when test="$pagescale_num = 1"></xsl:when>
						<xsl:otherwise><xsl:value-of select="$pagescale_num"/></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:element name="{concat('pageJPEG',$pageJPEGsequ)}">
					<xsl:attribute name="page_sequence"><xsl:value-of select="$page_sequence" /></xsl:attribute>
					<xsl:attribute name="page_name"><xsl:value-of select="$page_name" /></xsl:attribute>
					<xsl:attribute name="sizefactor"><xsl:value-of select="locjs:get_pageJPEGScale()" /></xsl:attribute>
					<xsl:attribute name="scale"><xsl:value-of select="locjs:get_pageJPEGScalePercent()" /></xsl:attribute>
					<xsl:attribute name="w"><xsl:value-of select="locjs:get_pageJPEGWidth()" /></xsl:attribute>
					<xsl:attribute name="h"><xsl:value-of select="locjs:get_pageJPEGHeight()" /></xsl:attribute>
					<xsl:attribute name="original"><xsl:value-of select="$pageJPEGname" /></xsl:attribute>
					<xsl:value-of select="locjs:restore_Value(0)"/></xsl:element>

				<!-- recall us to make more page JPEGs -->
				<xsl:variable name="d" select="locjs:next_pageJPEG()"/>
				<xsl:choose>
					<xsl:when test="locjs:hasnext_pageJPEG() = true()">
						<xsl:call-template name="get_pageJPEG">
							<xsl:with-param name="thepage"><xsl:value-of select="$thepage"/></xsl:with-param>
							<xsl:with-param name="page_sequence"><xsl:value-of select="$page_sequence"/></xsl:with-param>
							<xsl:with-param name="page_name"><xsl:value-of select="$page_name"/></xsl:with-param>
							<xsl:with-param name="pagescale_num"><xsl:value-of select="number($pagescale_num)+1" /></xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise><!-- reset because the first size is used later -->
						<xsl:variable name="d" select="locjs:reset_pageJPEG()"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:if>
	</xsl:template>



	<xsl:template name="get_pagePDF">
		<xsl:param name="thepage"/>
		<xsl:param name="page_sequence"/>
		<xsl:param name="page_name"/>

		<xsl:variable name="PDFname"><xsl:value-of select="concat($docname,'_p',locjs:get_jpeg_page_num(string($thepage)),'.pdf')"/></xsl:variable>
		<xsl:variable name="PDFpath"><xsl:value-of select="$INPUT_PATH"/><xsl:value-of select="$PDFname"/></xsl:variable>

		<xsl:variable name="exists" select="locjs:fileExists(string($PDFpath))"/>
		<xsl:if test="$exists = 'true'">
			<pagePDF>
				<xsl:attribute name="page_sequence"><xsl:value-of select="$page_sequence" /></xsl:attribute>
				<xsl:attribute name="page_name"><xsl:value-of select="$page_name" /></xsl:attribute>
				<xsl:attribute name="fullpath"><xsl:value-of select="$PDFpath" /></xsl:attribute>
				<xsl:value-of select="$PDFname"/></pagePDF>
		</xsl:if>
	</xsl:template>



	<xsl:template name="get_documentPDF">
		<xsl:variable name="PDFname">
			<xsl:choose>
				<xsl:when test="$documentPDFname != ''">
					<xsl:value-of select="$documentPDFname"/>
				</xsl:when>
				<xsl:when test="$documentPDFnameSearch != '0'">
					<xsl:value-of select="concat($docname,'_doc.pdf')"/><!-- pdf of whole document -->
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($docname,'.pdf')"/><!-- this might be the PDF of the first page only -->
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="PDFpath"><xsl:value-of select="$INPUT_PATH"/><xsl:value-of select="$PDFname"/></xsl:variable>
		<xsl:variable name="exists" select="locjs:fileExists(string($PDFpath))"/>
		<xsl:if test="$exists = 'true'">
			<documentPDF>
				<xsl:attribute name="fullpath"><xsl:value-of select="$PDFpath" /></xsl:attribute>
				<xsl:value-of select="$PDFname"/></documentPDF>
		</xsl:if>
	</xsl:template>



	<!-- ===============================================
		 the boxes on the page
	     =============================================== -->
		<!-- in CS3 and below itxf is 0 for unchained or the first box in a chain
			in CS4 and above, there is NO itxf attrib (index textflow # for chained boxes). we use 'previous text flow id ptxf' which is 'n' for unchained or first boxes in a chain. -->
	<xsl:template match="TextFrame | Rectangle | Group | GraphicLine | Oval | Polygon | Button | MultiStateObject">
		<xsl:param name="action"/><!-- attr for push button images -->
		<xsl:param name="spread_self"/><!-- the spread id -->
		<xsl:param name="spread"/><!-- the spread number -->
		<xsl:param name="page_self"/><!-- the page Self ID -->
		<xsl:param name="page"/><!-- the page sequence -->
		<xsl:param name="page_sequence"/>
		<xsl:param name="page_name"/>
		<xsl:param name="pageside"/>
		<xsl:param name="maxwidth"/>
		<xsl:param name="maxheight"/>
		<xsl:param name="anchorid"/>
		<xsl:param name="imagepagearea"/>
		<xsl:param name="groupid"/>
		<xsl:param name="thefirstflowid"/><!-- is set when called to find chained boxes -->
		<xsl:param name="isImageInImageBelongs_to_page"/><!-- if we have an image box in an image box -->

		<!-- store this box' layer ID and visibility of layer -->
		<xsl:variable name="layerID">
			<xsl:choose>
				<xsl:when test="@ItemLayer"><xsl:value-of select="@ItemLayer"/></xsl:when>
				<xsl:when test="ancestor::Group/@ItemLayer"><xsl:value-of select="ancestor::Group/@ItemLayer"/></xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="layerName">
			<xsl:if test="$layerID != ''">
				<xsl:value-of select="/Documents/Document/Layer[@Self = $layerID]/@Name/."/>
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="layerVisibility">
			<xsl:choose>
				<xsl:when test="$layerID != ''">
					<xsl:value-of select="/Documents/Document/Layer[@Self = $layerID]/@Visible/."/>
				</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!-- prepare this box' info -->
		<xsl:variable name="anchorID"><!-- is set empty for anchored boxes only -->
			<xsl:choose>
				<xsl:when test="$anchorid != ''"><xsl:value-of select="$anchorid"/></xsl:when>
				<xsl:when test="AnchoredObjectSetting"><xsl:value-of select="@Self"/></xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="boxid"><xsl:value-of select="@Self"/></xsl:variable>

		<xsl:variable name="d" select="locjs:init_parent_groupboxes()"/>
		<xsl:variable name="d" select="locjs:invalid_aBox()"/>
		<xsl:variable name="boxprepared" select="locjs:get_aBox_info(string(@Self))"/><!-- anchored boxes are not prepared in advance -->
		<xsl:if test="($DEBUG = 1)">
			<xsl:variable name="d" select="locjs:message(concat('************ boxid name: ',string(name()),' boxid: ',string(@Self),' prepared: ',$boxprepared))"/>
		</xsl:if>


		<xsl:if test="( (($excludeHiddenLayers = '0') or (($excludeHiddenLayers != '0') and (@Visible = 'true') and ($layerVisibility = 'true'))) )">
						<!-- and ( (name() = 'Group') or ($boxprepared = true())) )"--><!-- non prepared boxes have not passed the initial export test -->
			<xsl:variable name="belongs_to_page">
				<xsl:choose>
					<xsl:when test="($boxprepared = true()) and ($isImageInImageBelongs_to_page != '')"><xsl:value-of select="$isImageInImageBelongs_to_page"/></xsl:when>
					<xsl:when test="$boxprepared = false()">
				<!--xsl:variable name="d" select="locjs:message(concat('############################ ',name(),' boxid: ',string(@Self),' prepared: ',$boxprepared))"/-->
						<xsl:if test="$memoryUsageMode != '0'"><!-- boxes are NOT prepared, clear previous box(es) -->
							<xsl:variable name="d" select="locjs:init_box2page_arr()"/>
						</xsl:if>
						<xsl:call-template name="store_box2page_infos">
							<xsl:with-param name="spread_num"><xsl:value-of select="$spread"/></xsl:with-param>
							<xsl:with-param name="spread_self"><xsl:value-of select="$spread_self"/></xsl:with-param>
							<xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
							<xsl:with-param name="page_sequence"><xsl:value-of select="$page_sequence"/></xsl:with-param>
							<xsl:with-param name="page_name"><xsl:value-of select="$page_name"/></xsl:with-param>
							<xsl:with-param name="page_side"><xsl:value-of select="$pageside"/></xsl:with-param>
							<xsl:with-param name="page_self"><xsl:value-of select="$page_self"/></xsl:with-param>
						</xsl:call-template>
						<xsl:value-of select="locjs:get_belongs_to_page()" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="locjs:get_belongs_to_page()" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<!-- this might be an box overlaping two pages and therefore just might be a duplicated box -->
			<xsl:variable name="belongs_to_page_overlap">
				<xsl:value-of select="locjs:get_belongs_to_page_overlap()" />
			</xsl:variable>

			<!-- check if we have to export this box -->
			<xsl:variable name="suppress_page_framer">
				<xsl:variable name="is_pageframer" select="locjs:box_is_pageframe(locjs:get_real_right()-locjs:get_real_left(),locjs:get_real_bottom()-locjs:get_real_top())"/>
				<xsl:choose>
					<xsl:when test="$is_pageframer = false()">0</xsl:when>
					<xsl:when test="($pageframingBoxNoExport = '0') or ($pageframingBoxNoExport = '')">0</xsl:when>
					<xsl:when test="name() = 'TextFrame'">
						<xsl:choose>
							<xsl:when test="contains($pageframingBoxNoExport,'1') = true()">1</xsl:when>
							<xsl:otherwise>0</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="(name() != 'Group') and (contains($pageframingBoxNoExport,'2') = true())">1</xsl:when><!-- all image boxes -->
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="label_noexp">
				<xsl:choose>
					<xsl:when test="contains(Properties/Label/KeyValuePair[@Key = 'Label']/@Value/.,'*noexp*')">1</xsl:when>
					<xsl:when test="locjs:is_excludeLayer(string($layerName)) = true()">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
				<xsl:variable name="d" select="locjs:message(concat('########### exporting boxid: ',@Self,' for current page sequence: ',$page_sequence))"/>
				<xsl:variable name="d" select="locjs:message(concat('  box belongs_to_page: ',locjs:get_belongs_to_page(),' belongs to page in question: ',(locjs:get_belongs_to_page() = $page_sequence) ))"/>
				<xsl:variable name="d" select="locjs:message(concat('  box belongs_to_page_overlap: ',locjs:get_belongs_to_page_overlap(),' belongs to page in question: ',(locjs:get_belongs_to_page_overlap() = $page_sequence) ))"/>
				<xsl:variable name="d" select="locjs:message(concat('  box noexp: ',locjs:get_noexp() ))"/>
				<xsl:variable name="d" select="locjs:message(concat('  box anchorID: ',$anchorID ))"/>
				<xsl:variable name="d" select="locjs:message(concat('  layerVisibility: ',locjs:get_layerVisibility() ))"/>
				<xsl:variable name="d" select="locjs:message(concat('  excludeHiddenLayers: ',$excludeHiddenLayers ))"/>
				<xsl:variable name="d" select="locjs:message(concat('  excludeLayer: ',$layerName, ' is ', locjs:is_excludeLayer(string($layerName))))"/>
				<xsl:variable name="d" select="locjs:message(concat('  l,t,r,b: ',locjs:ls(),',',locjs:ts(),',',locjs:rs(),',',locjs:bs(),','))"/>
			</xsl:if>
			<xsl:if test="( ($suppress_page_framer = '0') and not((locjs:get_layerVisibility() = 'false') and ($excludeHiddenLayers = '1')) and ($label_noexp = '0') ) or ($anchorID != '')"><!-- not hidden layer or *noexp*, on this page or anchored box -->
				<xsl:variable name="objectstyle"><!-- object style -->
					<xsl:if test="@AppliedObjectStyle and not(contains(@AppliedObjectStyle,'\[None\]'))">
						<xsl:value-of select="locjs:get_style_class_name(string(@AppliedObjectStyle))"/>
					</xsl:if>
				</xsl:variable>
	
				<xsl:variable name="coords"><xsl:value-of select="locjs:ls()"/>,<xsl:value-of select="locjs:ts()"/>,<xsl:value-of select="locjs:rs()"/>,<xsl:value-of select="locjs:bs()"/></xsl:variable>
				<xsl:variable name="coords_overlap"><xsl:value-of select="locjs:lso()"/>,<xsl:value-of select="locjs:tso()"/>,<xsl:value-of select="locjs:rso()"/>,<xsl:value-of select="locjs:bso()"/></xsl:variable>
				<xsl:variable name="x1"><xsl:if test="locjs:ls() &lt; '0'">0</xsl:if><xsl:if test="locjs:ls() &gt;= '0'"><xsl:value-of select="locjs:ls()"/></xsl:if></xsl:variable>
				<xsl:variable name="y1"><xsl:if test="locjs:ts() &lt; '0'">0</xsl:if><xsl:if test="locjs:ts() &gt;= '0'"><xsl:value-of select="locjs:ts()"/></xsl:if></xsl:variable>
				<xsl:variable name="x2"><xsl:value-of select="locjs:rs()"/></xsl:variable>
				<xsl:variable name="y2"><xsl:value-of select="locjs:bs()"/></xsl:variable>
				<!--xsl:variable name="x2"><xsl:if test="locjs:rs() &gt; $maxwidth"><xsl:value-of select="$maxwidth"/></xsl:if><xsl:if test="locjs:rs() &lt;= $maxwidth"><xsl:value-of select="locjs:rs()"/></xsl:if></xsl:variable-->
				<!--xsl:variable name="y2"><xsl:if test="locjs:bs() &gt; $maxheight"><xsl:value-of select="$maxheight"/></xsl:if><xsl:if test="locjs:bs() &lt;= $maxheight"><xsl:value-of select="locjs:bs()"/></xsl:if></xsl:variable-->
				<xsl:variable name="angle"><xsl:value-of select="locjs:get_angle()"/></xsl:variable>
				<xsl:variable name="shape_orig"><xsl:value-of select="locjs:get_shape_orig()"/></xsl:variable>
				<xsl:variable name="shape"><xsl:value-of select="locjs:get_shape()"/></xsl:variable>
				<xsl:variable name="shape_overlap"><xsl:value-of select="locjs:get_shape_overlap()"/></xsl:variable>
				<xsl:variable name="bbox_orig"><xsl:value-of select="locjs:get_bbox_orig()"/></xsl:variable>
				<xsl:variable name="bbox"><xsl:value-of select="locjs:get_bbox()"/></xsl:variable>
				<xsl:variable name="bbox_overlap"><xsl:value-of select="locjs:get_bbox_overlap()"/></xsl:variable>
				<xsl:variable name="pageJPEGScale"><xsl:value-of select="locjs:get_pageJPEGScale()"/></xsl:variable>
				<xsl:variable name="matrix"><xsl:value-of select="locjs:get_matrix()"/></xsl:variable>
				<xsl:variable name="matrix_orig"><xsl:value-of select="locjs:get_matrix_orig()"/></xsl:variable>
				<xsl:variable name="label"><xsl:value-of select="locjs:get_label()"/></xsl:variable>
				<xsl:variable name="parentstory"><xsl:value-of select="@ParentStory"/></xsl:variable>
				<xsl:variable name="parentGroupIDs"><xsl:value-of select="locjs:get_parentGroupIDs()"/></xsl:variable>
	
				<xsl:variable name="XMLElementSelf"><!-- has contained Story a custom XMLElement as direct child? Then, the stoy box is marked-->
					<xsl:choose>
						<xsl:when test="locjs:get_includeXMLtags() = '0'"></xsl:when>
						<xsl:when test="name() = 'TextFrame'">
							<xsl:if test="/Documents/Document/Story/Story[@Self = $parentstory]/XMLElement">
								<xsl:value-of select="/Documents/Document/Story/Story[@Self = $parentstory]/XMLElement/@Self/."/>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise><!-- for image boxes -->
							<xsl:if test="/Documents/Document/BackingStory/XmlStory//XMLElement[@XMLContent = $boxid]">
								<xsl:value-of select="/Documents/Document/BackingStory/XmlStory//XMLElement[@XMLContent = $boxid]/@Self/."/>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="XMLElementMarkupTag">
					<xsl:if test="$XMLElementSelf != ''">
						<xsl:choose>
							<xsl:when test="name() = 'TextFrame'">
								<xsl:value-of select="substring-after(/Documents/Document/Story/Story[@Self = $parentstory]/XMLElement/@MarkupTag/.,'/')"/>
							</xsl:when>
							<xsl:otherwise><!-- for image boxes -->
								<xsl:value-of select="/Documents/Document/BackingStory/XmlStory//XMLElement[@XMLContent = $boxid]/@MarkupTag/."/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
				</xsl:variable>
				<xsl:variable name="XMLElementXMLContent">
					<xsl:if test="$XMLElementSelf != ''">
						<xsl:choose>
							<xsl:when test="name() = 'TextFrame'">
								<xsl:value-of select="/Documents/Document/Story/Story[@Self = $parentstory]/XMLElement/@XMLContent/."/>
							</xsl:when>
							<xsl:otherwise><!-- for image boxes -->
								<xsl:value-of select="/Documents/Document/BackingStory/XmlStory//XMLElement[@XMLContent = $boxid]/@XMLContent/."/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
				</xsl:variable>
				<xsl:variable name="XMLElementAttributes">
					<xsl:if test="$XMLElementSelf != ''">
								<xsl:call-template name="getXMLElementAttributes"><xsl:with-param name="elem" select="/Documents/Document/Story/Story[@Self = $parentstory]/XMLElement"/></xsl:call-template>
					</xsl:if>
				</xsl:variable>
	
	<!--********* box: <xsl:value-of select="name()"/>, belongstopage:<xsl:value-of select="$belongs_to_page"/>, page_sequence:<xsl:value-of select="$page_sequence"/>, Nonprinting:<xsl:value-of select="@Nonprinting"/>************-->
	<!--***** Element name: <xsl:value-of select="name()"/-->
				<xsl:choose>
					<!-- *********** non printing boxes to suppress ************** -->
					<xsl:when test="(@Nonprinting = 'true') and ($suppressNonPrintingBox = '1')"></xsl:when>
	
	
					<!-- *********** group boxes LEAVE GROUP PROCESSING DIRECTLY AFTER NONPRINTING TEST! GROUPS CAN HAVE NONPRINTING ATTRIBUTE ************** -->
					<xsl:when test="name() = 'Group'">
						<!-- get the group layer's visibility -->
						<xsl:variable name="layerID">
							<xsl:choose>
								<xsl:when test="@ItemLayer"><xsl:value-of select="@ItemLayer"/></xsl:when>
								<xsl:when test="ancestor::Group/@ItemLayer"><xsl:value-of select="ancestor::Group/@ItemLayer"/></xsl:when>
							</xsl:choose>
						</xsl:variable>
						<xsl:variable name="masterLayerVisible">
							<xsl:choose>
								<xsl:when test="$layerID != ''">
									<xsl:value-of select="/Documents/Document/Layer[@Self = $layerID]/@Visible/."/>
								</xsl:when>
								<xsl:otherwise>true</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
			<!--xsl:variable name="d" select="locjs:message(concat('%%%%%%%% excludeHiddenLayers: ',$excludeHiddenLayers, ' group: ',@Self,' Visible: ',@Visible,' ItemLayer: ',@ItemLayer,' masterLayerVisible: ',$masterLayerVisible))"/-->
	
						<!-- xsl:comment> **** Group Box <xsl:value-of select="@Self" /> </xsl:comment -->
						<xsl:if test="($excludeHiddenLayers = '0') or (($excludeHiddenLayers != '0') and (@Visible = 'true') and ($masterLayerVisible = 'true'))">
			<!--xsl:variable name="d" select="locjs:message(concat('       +++++ exporting group: ',@Self,' page_sequence: ',$page_sequence,' Visible: ',@Visible,' ItemLayer: ',@ItemLayer,' masterLayerVisible: ',$masterLayerVisible))"/-->
							<xsl:variable name="box_type"><xsl:if test="$anchorID != ''">anchored_</xsl:if>group</xsl:variable>
							<group>
								<xsl:attribute name="type"><xsl:value-of select="$box_type"/></xsl:attribute>
								<xsl:attribute name="Self"><xsl:value-of select="@Self"/></xsl:attribute>
								<xsl:attribute name="groupid"><xsl:value-of select="$groupid"/></xsl:attribute>
								<xsl:attribute name="angle"><xsl:value-of select="locjs:get_angle()"/></xsl:attribute>
								<xsl:variable name="thisgroupid"><xsl:value-of select="@Self"/></xsl:variable>
								<!-- get boxes contained in group -->
								<xsl:apply-templates select="*">
									<xsl:with-param name="action"><xsl:value-of select="$action"/></xsl:with-param>
									<xsl:with-param name="anchorID"><xsl:value-of select="$anchorID"/></xsl:with-param>
									<xsl:with-param name="spread"><xsl:value-of select="$spread"/></xsl:with-param>
									<xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
									<xsl:with-param name="page_sequence"><xsl:value-of select="$page_sequence" /></xsl:with-param><!-- the 1 based page sequence -->
									<xsl:with-param name="page_name"><xsl:value-of select="$page_name"/></xsl:with-param>
									<xsl:with-param name="pageside"><xsl:value-of select="$pageside"/></xsl:with-param>
									<xsl:with-param name="maxwidth"><xsl:value-of select="$maxwidth"/></xsl:with-param>
									<xsl:with-param name="maxheight"><xsl:value-of select="$maxheight"/></xsl:with-param>
									<xsl:with-param name="groupid"><xsl:value-of select="$thisgroupid"/></xsl:with-param>
									<xsl:with-param name="thefirstflowid"><xsl:value-of select="$thefirstflowid"/></xsl:with-param>
								</xsl:apply-templates>
							</group>
						</xsl:if>
					</xsl:when>
	
					<!-- *********** do not continuue if does not belong to the page in question ************** -->
					<!--xsl:when test="$belongs_to_page != $page_sequence"-->
					<xsl:when test="($belongs_to_page != $page_sequence) and ($belongs_to_page_overlap != $page_sequence)">
						<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
							<xsl:variable name="d" select="locjs:message(concat('########################## Box: ',name(),' with id ',@Self, ' does not belong to page_sequence ',$page_sequence,' but to ',$belongs_to_page,' #############'))"/>
						</xsl:if>
					</xsl:when>
	
					<!-- *********** unassigned boxes to suppress ************** -->
					<xsl:when test="(@ContentType = 'Unassigned') and (($suppressUnassignedBox = '1') or ($suppressAllEmptyBox = '1'))">
						<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
							<xsl:variable name="d" select="locjs:message(concat('##### suppressing box: ',name(),' @Self: ',@Self,' ContentType: ',@ContentType))"/>
						</xsl:if>
					</xsl:when>
	
					<!-- *********** empty image boxes to suppress ************** -->
					<xsl:when test="((name() = 'Rectangle') or (name() = 'Polygon') or (name() = 'Oval')) and (@ContentType != 'GraphicType') and (($suppressEmptyImageBox = '1') or ($suppressAllEmptyBox = '1')) and not(Image | EPS | PICT | PDF | ImportedPage | WMF)">
						<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
							<xsl:variable name="d" select="locjs:message(concat('##### suppressing box: ',name(),' @Self: ',@Self,' ContentType: ',@ContentType))"/>
						</xsl:if>
					</xsl:when>
	
					<!-- *********** text boxes ************** -->
					<xsl:when test="name() = 'TextFrame'"><!-- for text boxes on page in question -->
						<xsl:variable name="textflow_id"><xsl:value-of select="@ParentStory"/></xsl:variable>
						<xsl:variable name="index" select="locjs:store_boxchain_idx(string(@PreviousTextFrame))" /><!-- 0=first box,>0=chained box -->
						<xsl:variable name="cont"><!-- TextType, GraphicType, Unassigned -->
							<xsl:choose>
								<xsl:when test="not(/Documents/Document/Story/Story[@Self=$textflow_id]//Table) and not(/Documents/Document/Story/Story[@Self=$textflow_id]//Rectangle) 
												and (/Documents/Document/Story/Story[@Self=$textflow_id]//Content/text() = '')">empty</xsl:when><!-- to text in box -->
								<xsl:otherwise>text</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:variable name="suppressTextBox" select="($cont = 'empty') and (($suppressEmptyTextBox = '1') or ($suppressAllEmptyBox = '1'))"/><!-- is empty text box to suppress -->
						<xsl:variable name="d" select="locjs:reset_textshortcut()"/>
						<!--xsl:comment> **** Box chain index: <xsl:value-of select="$index" /> </xsl:comment-->
						<xsl:if test="($index = 0) and ($suppressTextBox = false())"><!-- 0 = first box in chain only and not to be suppressed -->
							<!-- xsl:comment> **** Text Box <xsl:value-of select="@Self" /> </xsl:comment -->
							<xsl:variable name="box_type"><xsl:if test="$anchorID != ''">anchored_</xsl:if><xsl:if test="$index != 0">chained_</xsl:if>text</xsl:variable>
							<xsl:variable name="textinsets">
								<xsl:for-each select="TextFramePreference/Properties/InsetSpacing/ListItem">
									<xsl:value-of select="."/><xsl:if test="position() != last()"><xsl:text> </xsl:text></xsl:if>
								</xsl:for-each>
							</xsl:variable>
							<xsl:variable name="d" select="locjs:store_textinset(string($textinsets))"/>
	
							<box>
								<xsl:attribute name="type"><xsl:value-of select="$box_type"/></xsl:attribute>
								<xsl:attribute name="elementName"><xsl:value-of select="name()"/></xsl:attribute>
								<xsl:attribute name="cont"><xsl:value-of select="$cont"/></xsl:attribute>
								<xsl:attribute name="Self"><xsl:value-of select="@Self"/></xsl:attribute>
								<xsl:attribute name="spread"><xsl:value-of select="locjs:get_box2page_spread(string(@Self))"/></xsl:attribute>
								<xsl:attribute name="page_sequence"><xsl:value-of select="locjs:get_box2page_page_sequence(string(@Self))"/></xsl:attribute>
								<xsl:attribute name="page_name"><xsl:value-of select="locjs:get_box2page_page_name(string(@Self))"/></xsl:attribute>

								<xsl:choose>
									<xsl:when test="($belongs_to_page_overlap > 0) and ($belongs_to_page_overlap = $page_sequence)">	<!-- is duplicated box overlaping from an other page -->
										<xsl:attribute name="ispageoverlap"><xsl:value-of select="$belongs_to_page_overlap"/></xsl:attribute>
										<xsl:attribute name="coords"><xsl:value-of select="$coords_overlap"/></xsl:attribute>
										<xsl:attribute name="bbox"><xsl:value-of select="$bbox_overlap"/></xsl:attribute>
										<xsl:attribute name="shape"><xsl:value-of select="$shape_overlap"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="coords"><xsl:value-of select="$coords"/></xsl:attribute>
										<xsl:attribute name="bbox"><xsl:value-of select="$bbox"/></xsl:attribute>
										<xsl:attribute name="shape"><xsl:value-of select="$shape"/></xsl:attribute>

										<xsl:if test="$bbox_orig != ''">
											<xsl:attribute name="bbox_orig"><xsl:value-of select="$bbox_orig"/></xsl:attribute>
										</xsl:if>
										<xsl:if test="$shape_orig != ''">
											<xsl:attribute name="shape_orig"><xsl:value-of select="$shape_orig"/></xsl:attribute>
										</xsl:if>
										<xsl:attribute name="x1"><xsl:value-of select="$x1"/></xsl:attribute>
										<xsl:attribute name="y1"><xsl:value-of select="$y1"/></xsl:attribute>
										<xsl:attribute name="x2"><xsl:value-of select="$x2"/></xsl:attribute>
										<xsl:attribute name="y2"><xsl:value-of select="$y2"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>

								<xsl:if test="(locjs:get_includeXMLtags() != '0' ) and ($XMLElementSelf != '')">
									<xsl:attribute name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:attribute>
									<xsl:attribute name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:attribute>
									<xsl:if test="$XMLElementXMLContent != ''"><xsl:attribute name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:attribute></xsl:if>
									<!-- get more attribs from XMLAttribute elements -->
									<xsl:for-each select="/Documents/Document/Story/Story[@Self = $parentstory]/XMLElement/XMLAttribute">
										<xsl:attribute name="{concat('XMLAttribute_',locjs:stripNameSpaceColon(string(@Name)))}"><xsl:value-of disable-output-escaping="yes" select="locjs:safe_attr(locjs:cleanSeparator(string(@Value)))"/></xsl:attribute>
									</xsl:for-each>
								</xsl:if>
								<xsl:if test="TextFramePreference/@TextColumnCount">
									<xsl:attribute name="colcnt"><xsl:value-of select="TextFramePreference/@TextColumnCount"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="TextFramePreference/@TextColumnFixedWidth">
									<xsl:attribute name="colwidth"><xsl:value-of select="TextFramePreference/@TextColumnFixedWidth"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="TextFramePreference/@TextColumnGutter">
									<xsl:attribute name="colgutter"><xsl:value-of select="TextFramePreference/@TextColumnGutter"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="TextFramePreference/@VerticalJustification">
									<xsl:attribute name="vjust"><xsl:value-of select="TextFramePreference/@VerticalJustification"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="TextFramePreference/@VerticalThreshold">
									<xsl:attribute name="paraspacelimit"><xsl:value-of select="TextFramePreference/@VerticalThreshold"/></xsl:attribute>
								</xsl:if>
								<xsl:attribute name="groupid"><xsl:value-of select="$groupid"/></xsl:attribute>
								<xsl:attribute name="allgroupid"><xsl:value-of select="$parentGroupIDs"/></xsl:attribute>
								<xsl:attribute name="anchorid"><xsl:value-of select="$anchorID"/></xsl:attribute>
								<xsl:if test="@Nonprinting">
									<xsl:attribute name="nopr"><xsl:value-of select="@Nonprinting"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="($objectstyle != '') and ($objectstyle != 'n')">
									<xsl:attribute name="objstyle"><xsl:value-of select="$objectstyle"/></xsl:attribute>
								</xsl:if>
								<xsl:attribute name="chainidx"><xsl:value-of select="$index"/></xsl:attribute><!-- 0=first box,>0=chained box -->
								<xsl:attribute name="previousflowid"><xsl:value-of select="@PreviousTextFrame"/></xsl:attribute><!-- id of previous box in chain or 'n' if not chained -->
								<xsl:attribute name="nextflowid"><xsl:value-of select="@NextTextFrame"/></xsl:attribute><!-- id of last box in chain or 'n' if not chained -->
								<xsl:attribute name="textflowid"><xsl:value-of select="$textflow_id"/></xsl:attribute><!-- the pointer to the Story element -->
								<xsl:if test="@CornerRadius">
									<xsl:attribute name="cornerradius"><xsl:value-of select="@CornerRadius"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="$angle != 0.0">
									<xsl:attribute name="angle"><xsl:value-of select="$angle"/></xsl:attribute>
								</xsl:if>
								<xsl:attribute name="pageJPEGScale"><xsl:value-of select="$pageJPEGScale"/></xsl:attribute>
								<xsl:if test="locjs:get_layerID() != ''">
									<xsl:attribute name="layerID"><xsl:value-of select="locjs:get_layerID()"/></xsl:attribute>
									<xsl:attribute name="layerName"><xsl:value-of select="locjs:get_layerName()"/></xsl:attribute>
									<xsl:attribute name="layerVis"><xsl:value-of select="locjs:get_layerVisibility()"/></xsl:attribute>
								</xsl:if>
								<xsl:attribute name="label"><xsl:value-of select="locjs:get_label()"/></xsl:attribute>
								<xsl:attribute name="insetTopR"><xsl:value-of select="locjs:get_textinset(0, 1)"/></xsl:attribute>
								<xsl:attribute name="insetLeftR"><xsl:value-of select="locjs:get_textinset(1, 1)"/></xsl:attribute>
								<xsl:attribute name="insetBottomR"><xsl:value-of select="locjs:get_textinset(2, 1)"/></xsl:attribute>
								<xsl:attribute name="insetRightR"><xsl:value-of select="locjs:get_textinset(3, 1)"/></xsl:attribute>
								<xsl:attribute name="insetTop"><xsl:value-of select="locjs:get_textinset(0, 0)"/></xsl:attribute>
								<xsl:attribute name="insetLeft"><xsl:value-of select="locjs:get_textinset(1, 0)"/></xsl:attribute>
								<xsl:attribute name="insetBottom"><xsl:value-of select="locjs:get_textinset(2, 0)"/></xsl:attribute>
								<xsl:attribute name="insetRight"><xsl:value-of select="locjs:get_textinset(3, 0)"/></xsl:attribute>
								<xsl:attribute name="backgroundColor"><xsl:value-of select="locjs:get_rgb_color(string(@FillColor),string(@FillTint))"/></xsl:attribute>
								<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
									<xsl:if test="@FillColor"><xsl:attribute name="backgroundColorID"><xsl:value-of select="@FillColor"/></xsl:attribute></xsl:if>
									<xsl:if test="@FillTint"><xsl:attribute name="backgroundColorFilt"><xsl:value-of select="@FillTint"/></xsl:attribute></xsl:if>
									<xsl:attribute name="matrix"><xsl:value-of select="$matrix"/></xsl:attribute>
									<xsl:attribute name="matrix_orig"><xsl:value-of select="$matrix_orig"/></xsl:attribute>
								</xsl:if>
	
								<xsl:variable name="frameweight">
									<xsl:choose>
										<xsl:when test="@StrokeWeight"><xsl:value-of select="@StrokeWeight"/></xsl:when><!-- line weight is given -->
										<xsl:when test="@StrokeColor and @StrokeTint">1</xsl:when><!-- line tint is given but no line weight @lnwt: means line weight 1pt -->
										<xsl:otherwise>0</xsl:otherwise><!-- set to no line -->
									</xsl:choose>
								</xsl:variable>
								<xsl:if test="($frameweight != '0') and (@StrokeColor or @StrokeTint)"><!-- only if we also have frame line weight and a line tint or color attributes, add frame border attribs -->
									<xsl:attribute name="frameWeight"><xsl:value-of select="$frameweight"/></xsl:attribute>
	
									<xsl:variable name="stst" select="@StrokeType"/>
									<xsl:variable name="framestylename">
										<xsl:choose>
											<xsl:when test="$stst = 'n'">n</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="/Documents/Document/Graphic/StrokeStyle[@Self = $stst]/@Name/."/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:variable name="framestylenameLC" select="locjs:to_lower_case(string($framestylename))"/>
									<xsl:variable name="framestylehtml">
										<xsl:choose>
											<xsl:when test="contains($framestylenameLC,'solid')">solid</xsl:when>
											<xsl:when test="contains($framestylenameLC,'thin')">double</xsl:when>
											<xsl:when test="contains($framestylenameLC,'thick')">double</xsl:when>
											<xsl:when test="contains($framestylenameLC,'dot')">dotted</xsl:when>
											<xsl:when test="contains($framestylenameLC,'dash')">dashed</xsl:when>
											<xsl:otherwise>solid</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:attribute name="frameStyleName"><xsl:value-of select="$framestylename"/></xsl:attribute>
									<xsl:attribute name="frameStyleHTML"><xsl:value-of select="$framestylehtml"/></xsl:attribute>
	
									<xsl:variable name="framecolor">
										<xsl:choose>
											<xsl:when test="@StrokeColor"><xsl:value-of select="@StrokeColor"/></xsl:when>
											<xsl:otherwise><xsl:value-of select="locjs:get_rgb_color_id('black')"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:attribute name="frameColor"><xsl:value-of select="locjs:get_rgb_color(string($framecolor),string(@StrokeTint))"/></xsl:attribute>
									<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
										<xsl:if test="@StrokeColor"><xsl:attribute name="frameColorID"><xsl:value-of select="@StrokeColor"/></xsl:attribute></xsl:if>
										<xsl:if test="@StrokeTint"><xsl:attribute name="frameColorFilt"><xsl:value-of select="@StrokeTint"/></xsl:attribute></xsl:if>
										<xsl:if test="@GapColor"><xsl:attribute name="frameGapColor"><xsl:value-of select="locjs:get_rgb_color(string(@GapColor),string(@GapTint))"/></xsl:attribute></xsl:if>
										<xsl:if test="@GapColor"><xsl:attribute name="frameGapColorID"><xsl:value-of select="@GapColor"/></xsl:attribute></xsl:if>
										<xsl:if test="@GapTint"><xsl:attribute name="frameGapColorTint"><xsl:value-of select="@GapTint"/></xsl:attribute></xsl:if>
										<xsl:if test="@LeftLineEnd"><xsl:attribute name="leftFrameEnd"><xsl:value-of select="@LeftLineEnd"/></xsl:attribute></xsl:if>
										<xsl:if test="@RightLineEnd"><xsl:attribute name="rightFrameEnd"><xsl:value-of select="@RightLineEnd"/></xsl:attribute></xsl:if>
									</xsl:if>
								</xsl:if>
								<!-- attributes for anchored objects -->
								<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
									<xsl:if test="$anchorID != ''">
										<xsl:if test="AnchoredObjectSetting/@AnchoredPosition"><xsl:attribute name="ao_Position"><xsl:value-of select="AnchoredObjectSetting/@AnchoredPosition"/></xsl:attribute></xsl:if><!-- InlinePosition = inline, AOPa = Above Line, AoPa = custom -->
										<xsl:if test="AnchoredObjectSetting/@SpineRelative"><xsl:attribute name="ao_relSpine"><xsl:value-of select="AnchoredObjectSetting/@SpineRelative"/></xsl:attribute></xsl:if><!-- true or false -->
										<xsl:if test="AnchoredObjectSetting/@LockPosition"><xsl:attribute name="ao_lockPosition"><xsl:value-of select="AnchoredObjectSetting/@LockPosition"/></xsl:attribute></xsl:if><!-- true or false -->
										<xsl:if test="AnchoredObjectSetting/@PinPosition"><!-- Keep with Top/Bottom Column Boundaries: true or false -->
											<xsl:attribute name="ao_pinPosition"><xsl:value-of select="AnchoredObjectSetting/@PinPosition"/></xsl:attribute>
											<xsl:attribute name="ao_keepColBound"><xsl:value-of select="AnchoredObjectSetting/@PinPosition"/></xsl:attribute>
										</xsl:if>
										<xsl:if test="AnchoredObjectSetting/@AnchorPoint"><xsl:attribute name="ao_refPoint"><xsl:value-of select="AnchoredObjectSetting/@AnchorPoint"/></xsl:attribute></xsl:if><!-- reference Point of Anchored Object: ANtl, ANtc, ANtr, ANlc, ANbl, ANbc, ANtr, ANrc, ANct -->
										<xsl:if test="AnchoredObjectSetting/@HorizontalAlignment"><xsl:attribute name="ao_horizAlign"><xsl:value-of select="AnchoredObjectSetting/@HorizontalAlignment"/></xsl:attribute></xsl:if><!-- left, cent, rght, (spine opt not supported), txal -->
										<xsl:if test="AnchoredObjectSetting/@HorizontalReferencePoint"><xsl:attribute name="ao_xRelTo"><xsl:value-of select="AnchoredObjectSetting/@HorizontalReferencePoint"/></xsl:attribute></xsl:if><!-- x relative to: txtf=textframe, APan=anchor marker, APco= column edge, APmg= page margin, APpg=page edge -->
										<xsl:if test="AnchoredObjectSetting/@VerticalAlignment"><xsl:attribute name="ao_vertAlign"><xsl:value-of select="AnchoredObjectSetting/@VerticalAlignment"/></xsl:attribute></xsl:if><!-- left, cent, rght, (spine opt not supported), txal -->
										<xsl:if test="AnchoredObjectSetting/@VerticalReferencePoint"><xsl:attribute name="ao_yRelTo"><xsl:value-of select="AnchoredObjectSetting/@VerticalReferencePoint"/></xsl:attribute></xsl:if><!-- y relative to: AVba=baseline, AVxc=Cap Height, AVbl=Top of Leading, APco=column edge, txtf=Text Frame, APmg=page margin, APpg=page edge -->
										<xsl:if test="AnchoredObjectSetting/@AnchorXoffset"><xsl:attribute name="ao_xOffset"><xsl:value-of select="AnchoredObjectSetting/@AnchorXoffset"/></xsl:attribute></xsl:if><!-- custom x offset -->
										<xsl:if test="AnchoredObjectSetting/@AnchorYoffset"><xsl:attribute name="ao_yOffset"><xsl:value-of select="AnchoredObjectSetting/@AnchorYoffset"/></xsl:attribute></xsl:if><!-- inline y offset or 'above line: space after' -->
										<xsl:if test="AnchoredObjectSetting/@AnchorSpaceAbove"><xsl:attribute name="ao_yOffsetAbove"><xsl:value-of select="AnchoredObjectSetting/@AnchorSpaceAbove"/></xsl:attribute></xsl:if><!-- above line: space before -->
										<xsl:if test="AnchoredObjectSetting/@LockPosition"><!-- lock position: prevent manual positioning -->
											<xsl:attribute name="ao_lockPos"><xsl:value-of select="AnchoredObjectSetting/@LockPosition"/></xsl:attribute>
											<xsl:attribute name="ao_NoManualPos"><xsl:value-of select="AnchoredObjectSetting/@LockPosition"/></xsl:attribute><!-- due to history -->
										</xsl:if>
									</xsl:if>
								</xsl:if>
	
								<area><!-- get box area -->
									<xsl:attribute name="name">A<xsl:value-of select="@Self"/>_<xsl:value-of select="$page_sequence"/></xsl:attribute><!-- need name attr for Netscape -->
									<xsl:attribute name="shape">rect</xsl:attribute>
									<xsl:attribute name="coords"><xsl:value-of select="$coords"/></xsl:attribute>
									<xsl:if test="$angle != 0.0">
										<xsl:attribute name="angle"><xsl:value-of select="$angle"/></xsl:attribute>
									</xsl:if>
									<xsl:if test="$shape != ''">
										<xsl:attribute name="shape"><xsl:value-of select="$shape"/></xsl:attribute>
									</xsl:if>
									<xsl:attribute name="x1"><xsl:value-of select="$x1"/></xsl:attribute>
									<xsl:attribute name="y1"><xsl:value-of select="$y1"/></xsl:attribute>
									<xsl:attribute name="x2"><xsl:value-of select="$x2"/></xsl:attribute>
									<xsl:attribute name="y2"><xsl:value-of select="$y2"/></xsl:attribute>
									<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
										<xsl:attribute name="matrix"><xsl:value-of select="$matrix"/></xsl:attribute>
										<xsl:attribute name="matrix_orig"><xsl:value-of select="$matrix_orig"/></xsl:attribute>
									</xsl:if>
								</area>
	
								<xsl:if test="$index = 0"><!-- get following chained boxes only for first textbox -->
									<xsl:variable name="d"><xsl:value-of select="locjs:store_textflowid(string($textflow_id))"/></xsl:variable>
		
									<!-- check if we have chained boxes: have a @NextTextFrame -->
									<xsl:if test="@NextTextFrame != 'n'">
										<xsl:variable name="ftxf"><xsl:value-of select="string(@Self)" /></xsl:variable>
										<xsl:call-template name="get_chained_boxes">
											<xsl:with-param name="itxf">0</xsl:with-param><!-- 0 is index of mother box in a chain-->
											<xsl:with-param name="ftxf"><xsl:value-of select="$ftxf" /></xsl:with-param><!-- first box of chain -->
											<xsl:with-param name="ptxf"><xsl:value-of select="@PreviousTextFrame" /></xsl:with-param><!-- pointer to previous txtf in chain -->
											<xsl:with-param name="ntxf"><xsl:value-of select="@NextTextFrame" /></xsl:with-param><!-- pointer to next txtf in chain -->
											<xsl:with-param name="textflow_id"><xsl:value-of select="$textflow_id" /></xsl:with-param><!-- pointer to text cflo -->
											<xsl:with-param name="cont"><xsl:value-of select="$cont" /></xsl:with-param><!-- 'content type' -->
											<xsl:with-param name="spread_num"><xsl:value-of select="$spread" /></xsl:with-param>
											<xsl:with-param name="spread_self"><xsl:value-of select="$spread_self" /></xsl:with-param>
											<xsl:with-param name="page_self"><xsl:value-of select="$page_self" /></xsl:with-param>
											<xsl:with-param name="page"><xsl:value-of select="$page" /></xsl:with-param><!-- page the first box is on -->
											<xsl:with-param name="page_sequence"><xsl:value-of select="$page_sequence" /></xsl:with-param><!-- the 1 based page sequence -->
											<xsl:with-param name="page_name"><xsl:value-of select="$page_name"/></xsl:with-param>
											<xsl:with-param name="pageside"><xsl:value-of select="$pageside" /></xsl:with-param><!-- page the first box is on -->
											<xsl:with-param name="maxwidth"><xsl:value-of select="$maxwidth" /></xsl:with-param>
											<xsl:with-param name="maxheight"><xsl:value-of select="$maxheight" /></xsl:with-param>
											<xsl:with-param name="groupid"><xsl:value-of select="$groupid"/></xsl:with-param>
										</xsl:call-template>
									</xsl:if>
		
									<!-- get formatted text for first box in chain --> 
									<xsl:if test="$index = 0">
										<xsl:apply-templates select="/Documents/Document/Story/Story[@Self = $textflow_id]"><!-- may be called from any grouped (deeper) level -->
											<xsl:with-param name="themode">1</xsl:with-param><!-- 1 = get formatted text -->
											<xsl:with-param name="caller_txtf"><xsl:value-of select="@Self"/></xsl:with-param>
											<xsl:with-param name="coords"><xsl:value-of select="$coords"/></xsl:with-param>
											<xsl:with-param name="textflow_id"><xsl:value-of select="$textflow_id"/></xsl:with-param>
											<xsl:with-param name="label"><xsl:value-of select="$label"/></xsl:with-param>
											<xsl:with-param name="groupid"><xsl:value-of select="$groupid"/></xsl:with-param>
										</xsl:apply-templates>
									</xsl:if>
	
									<!-- get floater text: textshortcut --> 
									<xsl:apply-templates select="/Documents/Document/Story/Story[@Self = $textflow_id]"><!-- may be called from any grouped (deeper) level -->
										<xsl:with-param name="themode">2</xsl:with-param><!-- 2 = get floater text -->
										<xsl:with-param name="caller_txtf"><xsl:value-of select="@Self"/></xsl:with-param>
										<xsl:with-param name="textflow_id"><xsl:value-of select="$textflow_id"/></xsl:with-param>
									</xsl:apply-templates>
								</xsl:if>
							</box>
						</xsl:if>
					</xsl:when>
	
	
					<!-- *********** Push buttons boxes ************** -->
					<xsl:when test="name() = 'Button'"><!-- the rollover image change - ignore it -->
						<xsl:variable name="box_type"><xsl:if test="$anchorID != ''">anchored_</xsl:if>push</xsl:variable>
						<box>
							<xsl:attribute name="type"><xsl:value-of select="$box_type"/></xsl:attribute>
							<xsl:attribute name="elementName"><xsl:value-of select="name()"/></xsl:attribute>
							<xsl:attribute name="cont">push</xsl:attribute>
							<xsl:attribute name="Self"><xsl:value-of select="@Self"/></xsl:attribute>
							<xsl:attribute name="page_sequence"><xsl:value-of select="$page_sequence"/></xsl:attribute>
							<xsl:attribute name="page_name"><xsl:value-of select="$page_name"/></xsl:attribute>

							<xsl:choose>
								<xsl:when test="($belongs_to_page_overlap > 0) and ($belongs_to_page_overlap = $page_sequence)">	<!-- is duplicated box overlaping from an other page -->
									<xsl:attribute name="ispageoverlap"><xsl:value-of select="$belongs_to_page_overlap"/></xsl:attribute>
									<xsl:attribute name="coords"><xsl:value-of select="$coords_overlap"/></xsl:attribute>
									<xsl:attribute name="bbox"><xsl:value-of select="$bbox_overlap"/></xsl:attribute>
									<xsl:attribute name="shape"><xsl:value-of select="$shape_overlap"/></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="coords"><xsl:value-of select="$coords"/></xsl:attribute>
									<xsl:attribute name="bbox"><xsl:value-of select="$bbox"/></xsl:attribute>
									<xsl:attribute name="shape"><xsl:value-of select="$shape"/></xsl:attribute>

									<xsl:if test="$bbox_orig != ''">
										<xsl:attribute name="bbox_orig"><xsl:value-of select="$bbox_orig"/></xsl:attribute>
									</xsl:if>
									<xsl:if test="$shape_orig != ''">
										<xsl:attribute name="shape_orig"><xsl:value-of select="$shape_orig"/></xsl:attribute>
									</xsl:if>
									<xsl:attribute name="x1"><xsl:value-of select="$x1"/></xsl:attribute>
									<xsl:attribute name="y1"><xsl:value-of select="$y1"/></xsl:attribute>
									<xsl:attribute name="x2"><xsl:value-of select="$x2"/></xsl:attribute>
									<xsl:attribute name="y2"><xsl:value-of select="$y2"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>

							<xsl:attribute name="visibleInPDF"><xsl:value-of select="@VisibilityInPdf"/></xsl:attribute>
							<xsl:attribute name="groupid"><xsl:value-of select="$groupid"/></xsl:attribute>
							<xsl:attribute name="allgroupid"><xsl:value-of select="$parentGroupIDs"/></xsl:attribute>
							<xsl:attribute name="anchorid"><xsl:value-of select="$anchorID"/></xsl:attribute>
							<xsl:if test="@Nonprinting">
								<xsl:attribute name="nopr"><xsl:value-of select="@Nonprinting"/></xsl:attribute>
							</xsl:if>
							<xsl:if test="($objectstyle != '') and ($objectstyle != 'n')">
								<xsl:attribute name="objstyle"><xsl:value-of select="$objectstyle"/></xsl:attribute>
							</xsl:if>
							<xsl:if test="@CornerRadius">
								<xsl:attribute name="cornerradius"><xsl:value-of select="@CornerRadius"/></xsl:attribute>
							</xsl:if>
							<xsl:if test="$angle != 0.0">
								<xsl:attribute name="angle"><xsl:value-of select="$angle"/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="pageJPEGScale"><xsl:value-of select="$pageJPEGScale"/></xsl:attribute>
							<xsl:if test="locjs:get_layerID() != ''">
								<xsl:attribute name="layerID"><xsl:value-of select="locjs:get_layerID()"/></xsl:attribute>
								<xsl:attribute name="layerName"><xsl:value-of select="locjs:get_layerName()"/></xsl:attribute>
								<xsl:attribute name="layerVis"><xsl:value-of select="locjs:get_layerVisibility()"/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="label"><xsl:value-of select="$label"/></xsl:attribute>
							<xsl:attribute name="backgroundColor"><xsl:value-of select="locjs:get_rgb_color(string(@FillColor),string(@FillTint))"/></xsl:attribute>
							<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
								<xsl:if test="@FillColor"><xsl:attribute name="backgroundColorID"><xsl:value-of select="@FillColor"/></xsl:attribute></xsl:if>
								<xsl:if test="@FillTint"><xsl:attribute name="backgroundColorFilt"><xsl:value-of select="@FillTint"/></xsl:attribute></xsl:if>
								<xsl:attribute name="matrix"><xsl:value-of select="$matrix"/></xsl:attribute>
								<xsl:attribute name="matrix_orig"><xsl:value-of select="$matrix_orig"/></xsl:attribute>
							</xsl:if>
	
							<xsl:variable name="frameweight">
								<xsl:choose>
									<xsl:when test="@StrokeWeight"><xsl:value-of select="@StrokeWeight"/></xsl:when><!-- line weight is given -->
									<xsl:when test="@StrokeColor and @StrokeTint">1</xsl:when><!-- line tint is given but no line weight @lnwt: means line weight 1pt -->
									<xsl:otherwise>0</xsl:otherwise><!-- set to no line -->
								</xsl:choose>
							</xsl:variable>
							<xsl:if test="($frameweight != '0') and (@StrokeColor or @StrokeTint)"><!-- only if we also have frame line weight and a line tint or color attributes, add frame border attribs -->
								<xsl:attribute name="frameWeight"><xsl:value-of select="$frameweight"/></xsl:attribute>
	
								<xsl:variable name="stst" select="@StrokeType"/>
								<xsl:variable name="framestylename">
									<xsl:choose>
										<xsl:when test="$stst = 'n'">n</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="/Documents/Document/Graphic/StrokeStyle[@Self = $stst]/@Name/."/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:variable name="framestylenameLC" select="locjs:to_lower_case(string($framestylename))"/>
								<xsl:variable name="framestylehtml">
									<xsl:choose>
										<xsl:when test="contains($framestylenameLC,'solid')">solid</xsl:when>
										<xsl:when test="contains($framestylenameLC,'thin')">double</xsl:when>
										<xsl:when test="contains($framestylenameLC,'thick')">double</xsl:when>
										<xsl:when test="contains($framestylenameLC,'dot')">dotted</xsl:when>
										<xsl:when test="contains($framestylenameLC,'dash')">dashed</xsl:when>
										<xsl:otherwise>solid</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:attribute name="frameStyleName"><xsl:value-of select="$framestylename"/></xsl:attribute>
								<xsl:attribute name="frameStyleHTML"><xsl:value-of select="$framestylehtml"/></xsl:attribute>
	
								<xsl:variable name="framecolor">
									<xsl:choose>
										<xsl:when test="@StrokeColor"><xsl:value-of select="@StrokeColor"/></xsl:when>
										<xsl:otherwise><xsl:value-of select="locjs:get_rgb_color_id('black')"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:attribute name="frameColor"><xsl:value-of select="locjs:get_rgb_color(string($framecolor),string(@StrokeTint))"/></xsl:attribute>
								<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
									<xsl:if test="@StrokeColor"><xsl:attribute name="frameColorID"><xsl:value-of select="@StrokeColor"/></xsl:attribute></xsl:if>
									<xsl:if test="@StrokeTint"><xsl:attribute name="frameColorFilt"><xsl:value-of select="@StrokeTint"/></xsl:attribute></xsl:if>
									<xsl:if test="@GapColor"><xsl:attribute name="frameGapColor"><xsl:value-of select="locjs:get_rgb_color(string(@GapColor),string(@GapTint))"/></xsl:attribute></xsl:if>
									<xsl:if test="@GapColor"><xsl:attribute name="frameGapColorID"><xsl:value-of select="@GapColor"/></xsl:attribute></xsl:if>
									<xsl:if test="@GapTint"><xsl:attribute name="frameGapColorTint"><xsl:value-of select="@GapTint"/></xsl:attribute></xsl:if>
									<xsl:if test="@LeftLineEnd"><xsl:attribute name="leftFrameEnd"><xsl:value-of select="@LeftLineEnd"/></xsl:attribute></xsl:if>
									<xsl:if test="@RightLineEnd"><xsl:attribute name="rightFrameEnd"><xsl:value-of select="@RightLineEnd"/></xsl:attribute></xsl:if>
								</xsl:if>
							</xsl:if>
	
							<xsl:attribute name="buttonname"><xsl:value-of select="@Name"/></xsl:attribute>
							<xsl:attribute name="onaction"><xsl:value-of select="substring-after(APrc/@pnam,'_')"/></xsl:attribute>
							<xsl:for-each select="bclo"><!-- close -->
								<action>
									<xsl:attribute name="type"><xsl:value-of select="substring-after(@pnam,'_')"/></xsl:attribute>
								</action>
							</xsl:for-each>
							<xsl:for-each select="bext"><!-- exit -->
								<action>
									<xsl:attribute name="type"><xsl:value-of select="substring-after(@pnam,'_')"/></xsl:attribute>
								</action>
							</xsl:for-each>
							<xsl:for-each select="bgan"><!-- goto text anchor -->
								<action>
									<xsl:attribute name="type"><xsl:value-of select="substring-after(@pnam,'_')"/></xsl:attribute>
									<xsl:attribute name="target"><xsl:value-of select="substring-after(@gaan,'_')"/></xsl:attribute>
								</action>
							</xsl:for-each>
							<xsl:for-each select="bgfp"><!-- goto first page -->
								<action>
									<xsl:attribute name="type"><xsl:value-of select="substring-after(@pnam,'_')"/></xsl:attribute>
								</action>
							</xsl:for-each>
							<xsl:for-each select="bglp"><!-- goto last page -->
								<action>
									<xsl:attribute name="type"><xsl:value-of select="substring-after(@pnam,'_')"/></xsl:attribute>
								</action>
							</xsl:for-each>
							<xsl:for-each select="bgnp"><!-- goto next page -->
								<action>
									<xsl:attribute name="type"><xsl:value-of select="substring-after(@pnam,'_')"/></xsl:attribute>
								</action>
							</xsl:for-each>
							<xsl:for-each select="bgnv"><!-- goto next View -->
								<action>
									<xsl:attribute name="type"><xsl:value-of select="substring-after(@pnam,'_')"/></xsl:attribute>
								</action>
							</xsl:for-each>
							<xsl:for-each select="bgsp"><!-- goto page -->
								<action>
									<xsl:attribute name="type"><xsl:value-of select="substring-after(@pnam,'_')"/></xsl:attribute>
									<xsl:attribute name="page"><xsl:value-of select="substring-after(@Pgnb,'_')"/></xsl:attribute>
								</action>
							</xsl:for-each>
							<xsl:for-each select="pgpp"><!-- goto previous page -->
								<action>
									<xsl:attribute name="type"><xsl:value-of select="substring-after(@pnam,'_')"/></xsl:attribute>
								</action>
							</xsl:for-each>
							<xsl:for-each select="pgpv"><!-- goto previous View -->
								<action>
									<xsl:attribute name="type"><xsl:value-of select="substring-after(@pnam,'_')"/></xsl:attribute>
								</action>
							</xsl:for-each>
							<xsl:for-each select="bgur"><!-- goto URL -->
								<action>
									<xsl:attribute name="type"><xsl:value-of select="substring-after(@pnam,'_')"/></xsl:attribute>
									<xsl:attribute name="url"><xsl:value-of select="substring-after(@gurl,'_')"/></xsl:attribute>
								</action>
							</xsl:for-each>
							<xsl:for-each select="MovieBehavior"><!-- movie button -->
								<xsl:variable name="movieID"><xsl:value-of select="@MovieItem"/></xsl:variable>
								<xsl:variable name="name"><xsl:value-of select="/Documents/Document//Movie[@Self = $movieID]/@Name"/></xsl:variable>
								<xsl:variable name="path"><xsl:value-of select="/Documents/Document//Movie[@Self = $movieID]/@FilePath"/></xsl:variable>
								<xsl:variable name="pathonly"><xsl:value-of select="locjs:getFilePathPart(string($path))"/></xsl:variable>
								<action>
									<xsl:attribute name="type">Video</xsl:attribute>
									<xsl:attribute name="typename"><xsl:value-of select="@Name"/></xsl:attribute>
									<xsl:attribute name="event"><xsl:value-of select="@BehaviorEvent"/></xsl:attribute><!-- BehaviorEvents_EnumValue = "MouseUp" | "MouseDown" | "MouseEnter" | "MouseExit" | "OnFocus" | "OnBlur"
																																		old CS4 INX:            muev=onMouseUp, mdev=onClick, meev=onMouseOver, mxev=onMouseOut, ofev=onFocus, obev=onBlur -->
									<xsl:attribute name="operation"><xsl:value-of select="@Operation"/></xsl:attribute><!-- MoviePlayOperations_EnumValue = "Play" | "PlayFromNavigationPoint" | "Stop" | "Pause" | "Resume" | "StopAll" -->
									<xsl:attribute name="movieID"><xsl:value-of select="$movieID"/></xsl:attribute>
									<xsl:variable name="movieLeft"><xsl:value-of select="/Documents/Document//Spread/Spread//Movie[@Self = $movieID]/Properties/GraphicBounds/@Left"/></xsl:variable>
									<xsl:variable name="movieTop"><xsl:value-of select="/Documents/Document//Spread/Spread//Movie[@Self = $movieID]/Properties/GraphicBounds/@Top"/></xsl:variable>
									<xsl:variable name="movieRight"><xsl:value-of select="/Documents/Document//Spread/Spread//Movie[@Self = $movieID]/Properties/GraphicBounds/@Right"/></xsl:variable>
									<xsl:variable name="movieBottom"><xsl:value-of select="/Documents/Document//Spread/Spread//Movie[@Self = $movieID]/Properties/GraphicBounds/@Bottom"/></xsl:variable>
									<xsl:attribute name="movieLeft"><xsl:value-of select="$movieLeft"/></xsl:attribute>
									<xsl:attribute name="movieTop"><xsl:value-of select="$movieTop"/></xsl:attribute>
									<xsl:attribute name="movieRight"><xsl:value-of select="$movieRight"/></xsl:attribute>
									<xsl:attribute name="movieBottom"><xsl:value-of select="$movieBottom"/></xsl:attribute>
									<xsl:attribute name="movieWidth"><xsl:value-of select="number($movieRight) - number($movieLeft)"/></xsl:attribute>
									<xsl:attribute name="movieHeight"><xsl:value-of select="number($movieBottom) - number($movieTop)"/></xsl:attribute>
									<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
									<xsl:attribute name="path"><xsl:value-of select="$path"/></xsl:attribute>
								</action>
								<!-- copy video file(s) to out folder -->
								<xsl:call-template name="copy_media_files">
									<xsl:with-param name="recall">0</xsl:with-param>
									<xsl:with-param name="mediatype">video</xsl:with-param>
									<xsl:with-param name="inpath"><xsl:value-of select="$pathonly"/></xsl:with-param>
									<xsl:with-param name="outpath"><xsl:value-of select="$the_OUTPUT_PATH"/></xsl:with-param>
									<xsl:with-param name="primarymedia"><xsl:value-of select="$name"/></xsl:with-param>
									<xsl:with-param name="alternatemedia"><xsl:value-of select="$label"/></xsl:with-param>
								</xsl:call-template>
							</xsl:for-each>

							<xsl:for-each select="SoundBehavior"><!-- sound button -->
								<xsl:variable name="soundID"><xsl:value-of select="@SoundItem"/></xsl:variable>
								<xsl:variable name="name"><xsl:value-of select="/Documents/Document//Sound[@Self = $soundID]/@Name"/></xsl:variable>
								<xsl:variable name="path"><xsl:value-of select="/Documents/Document//Sound[@Self = $soundID]/@FilePath"/></xsl:variable>
								<xsl:variable name="pathonly"><xsl:value-of select="locjs:getFilePathPart(string($path))"/></xsl:variable>
								<action>
									<xsl:attribute name="type">Sound</xsl:attribute>
									<xsl:attribute name="typename"><xsl:value-of select="@Name"/></xsl:attribute>
									<xsl:attribute name="event"><xsl:value-of select="@BehaviorEvent"/></xsl:attribute><!-- BehaviorEvents_EnumValue = "MouseUp" | "MouseDown" | "MouseEnter" | "MouseExit" | "OnFocus" | "OnBlur"
																																		old CS4 INX:            muev=onMouseUp, mdev=onClick, meev=onMouseOver, mxev=onMouseOut, ofev=onFocus, obev=onBlur -->
									<xsl:attribute name="operation"><xsl:value-of select="@Operation"/></xsl:attribute><!-- MoviePlayOperations_EnumValue = "Play" | "PlayFromNavigationPoint" | "Stop" | "Pause" | "Resume" | "StopAll" -->
									<xsl:attribute name="soundID"><xsl:value-of select="$soundID"/></xsl:attribute>
									<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
									<xsl:attribute name="path"><xsl:value-of select="$path"/></xsl:attribute>
								</action>
								<!-- copy sound file(s) to out folder -->
								<xsl:call-template name="copy_media_files">
									<xsl:with-param name="recall">0</xsl:with-param>
									<xsl:with-param name="mediatype">sound</xsl:with-param>
									<xsl:with-param name="inpath"><xsl:value-of select="$pathonly"/></xsl:with-param>
									<xsl:with-param name="outpath"><xsl:value-of select="$the_OUTPUT_PATH"/></xsl:with-param>
									<xsl:with-param name="primarymedia"><xsl:value-of select="$name"/></xsl:with-param>
									<xsl:with-param name="alternatemedia"><xsl:value-of select="$label"/></xsl:with-param>
								</xsl:call-template>
							</xsl:for-each>

							<xsl:for-each select="bopf"><!-- open file -->
								<action>
									<xsl:attribute name="type"><xsl:value-of select="substring-after(@pnam,'_')"/></xsl:attribute>
									<xsl:attribute name="path"><xsl:value-of select="substring-after(@path,'_')"/></xsl:attribute>
								</action>
							</xsl:for-each>
	
							<xsl:variable name="groupid"><xsl:value-of select="@Self"/></xsl:variable>
							<!-- get boxes contained in push button -->
							<xsl:for-each select="State">
								<buttonstate>
									<xsl:attribute name="name"><xsl:value-of select="Properties/Statetype/."/></xsl:attribute>
									<xsl:attribute name="id"><xsl:value-of select="@Self"/></xsl:attribute>
									<xsl:apply-templates select="*">
										<xsl:with-param name="action">push</xsl:with-param>
										<xsl:with-param name="anchorID"><xsl:value-of select="$anchorID"/></xsl:with-param>
										<xsl:with-param name="spread"><xsl:value-of select="$spread"/></xsl:with-param>
										<xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
										<xsl:with-param name="page_sequence"><xsl:value-of select="$page_sequence" /></xsl:with-param><!-- the 1 based page sequence -->
										<xsl:with-param name="page_name"><xsl:value-of select="$page_name"/></xsl:with-param>
										<xsl:with-param name="pageside"><xsl:value-of select="$pageside"/></xsl:with-param>
										<xsl:with-param name="maxwidth"><xsl:value-of select="$maxwidth"/></xsl:with-param>
										<xsl:with-param name="maxheight"><xsl:value-of select="$maxheight"/></xsl:with-param>
										<xsl:with-param name="groupid"><xsl:value-of select="$groupid"/></xsl:with-param>
										<xsl:with-param name="thefirstflowid"><xsl:value-of select="$thefirstflowid"/></xsl:with-param>
									</xsl:apply-templates>
								</buttonstate>
							</xsl:for-each>

							<!-- may a button to manage MultiStateObject -->
							<xsl:if test="GotoStateBehavior">
								<xsl:copy-of select="GotoStateBehavior"/>
							</xsl:if>
	
							<area><!-- get box area -->
								<xsl:attribute name="name">A<xsl:value-of select="@Self"/>_<xsl:value-of select="$page_sequence"/></xsl:attribute><!-- need name attr for Netscape -->
								<xsl:attribute name="shape">rect</xsl:attribute>
								<xsl:attribute name="coords"><xsl:value-of select="$coords"/></xsl:attribute>
								<xsl:if test="$angle != 0.0">
									<xsl:attribute name="angle"><xsl:value-of select="$angle"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="$shape != ''">
									<xsl:attribute name="shape"><xsl:value-of select="$shape"/></xsl:attribute>
								</xsl:if>
								<xsl:attribute name="x1"><xsl:value-of select="$x1"/></xsl:attribute>
								<xsl:attribute name="y1"><xsl:value-of select="$y1"/></xsl:attribute>
								<xsl:attribute name="x2"><xsl:value-of select="$x2"/></xsl:attribute>
								<xsl:attribute name="y2"><xsl:value-of select="$y2"/></xsl:attribute>
								<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
									<xsl:attribute name="matrix"><xsl:value-of select="$matrix"/></xsl:attribute>
									<xsl:attribute name="matrix_orig"><xsl:value-of select="$matrix_orig"/></xsl:attribute>
								</xsl:if>
							</area>
						</box>
					</xsl:when>
	
	
					<!-- *********** MultiStateObject ************** -->
					<xsl:when test="name() = 'MultiStateObject'">
						<box>
							<xsl:attribute name="type">multistate</xsl:attribute>
							<xsl:attribute name="elementName"><xsl:value-of select="name()"/></xsl:attribute>
							<xsl:attribute name="cont">multistate</xsl:attribute>
							<xsl:attribute name="Self"><xsl:value-of select="@Self"/></xsl:attribute>
							<xsl:attribute name="page_sequence"><xsl:value-of select="$page_sequence"/></xsl:attribute>
							<xsl:attribute name="page_name"><xsl:value-of select="$page_name"/></xsl:attribute>

							<xsl:choose>
								<xsl:when test="($belongs_to_page_overlap > 0) and ($belongs_to_page_overlap = $page_sequence)">	<!-- is duplicated box overlaping from an other page -->
									<xsl:attribute name="ispageoverlap"><xsl:value-of select="$belongs_to_page_overlap"/></xsl:attribute>
									<xsl:attribute name="coords"><xsl:value-of select="$coords_overlap"/></xsl:attribute>
									<xsl:attribute name="bbox"><xsl:value-of select="$bbox_overlap"/></xsl:attribute>
									<xsl:attribute name="shape"><xsl:value-of select="$shape_overlap"/></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="coords"><xsl:value-of select="$coords"/></xsl:attribute>
									<xsl:attribute name="bbox"><xsl:value-of select="$bbox"/></xsl:attribute>
									<xsl:attribute name="shape"><xsl:value-of select="$shape"/></xsl:attribute>

									<xsl:if test="$bbox_orig != ''">
										<xsl:attribute name="bbox_orig"><xsl:value-of select="$bbox_orig"/></xsl:attribute>
									</xsl:if>
									<xsl:if test="$shape_orig != ''">
										<xsl:attribute name="shape_orig"><xsl:value-of select="$shape_orig"/></xsl:attribute>
									</xsl:if>
									<xsl:attribute name="x1"><xsl:value-of select="$x1"/></xsl:attribute>
									<xsl:attribute name="y1"><xsl:value-of select="$y1"/></xsl:attribute>
									<xsl:attribute name="x2"><xsl:value-of select="$x2"/></xsl:attribute>
									<xsl:attribute name="y2"><xsl:value-of select="$y2"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>

							<xsl:attribute name="visibleInPDF"><xsl:value-of select="@VisibilityInPdf"/></xsl:attribute>
							<xsl:attribute name="groupid"><xsl:value-of select="$groupid"/></xsl:attribute>
							<xsl:attribute name="allgroupid"><xsl:value-of select="$parentGroupIDs"/></xsl:attribute>
							<xsl:attribute name="anchorid"><xsl:value-of select="$anchorID"/></xsl:attribute>
							<xsl:if test="@Nonprinting">
								<xsl:attribute name="nopr"><xsl:value-of select="@Nonprinting"/></xsl:attribute>
							</xsl:if>
							<xsl:if test="($objectstyle != '') and ($objectstyle != 'n')">
								<xsl:attribute name="objstyle"><xsl:value-of select="$objectstyle"/></xsl:attribute>
							</xsl:if>
							<xsl:if test="@CornerRadius">
								<xsl:attribute name="cornerradius"><xsl:value-of select="@CornerRadius"/></xsl:attribute>
							</xsl:if>
							<xsl:if test="$angle != 0.0">
								<xsl:attribute name="angle"><xsl:value-of select="$angle"/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="pageJPEGScale"><xsl:value-of select="$pageJPEGScale"/></xsl:attribute>
							<xsl:if test="locjs:get_layerID() != ''">
								<xsl:attribute name="layerID"><xsl:value-of select="locjs:get_layerID()"/></xsl:attribute>
								<xsl:attribute name="layerName"><xsl:value-of select="locjs:get_layerName()"/></xsl:attribute>
								<xsl:attribute name="layerVis"><xsl:value-of select="locjs:get_layerVisibility()"/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="label"><xsl:value-of select="$label"/></xsl:attribute>
							<xsl:attribute name="backgroundColor"><xsl:value-of select="locjs:get_rgb_color(string(@FillColor),string(@FillTint))"/></xsl:attribute>
							<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
								<xsl:if test="@FillColor"><xsl:attribute name="backgroundColorID"><xsl:value-of select="@FillColor"/></xsl:attribute></xsl:if>
								<xsl:if test="@FillTint"><xsl:attribute name="backgroundColorFilt"><xsl:value-of select="@FillTint"/></xsl:attribute></xsl:if>
								<xsl:attribute name="matrix"><xsl:value-of select="$matrix"/></xsl:attribute>
								<xsl:attribute name="matrix_orig"><xsl:value-of select="$matrix_orig"/></xsl:attribute>
							</xsl:if>
	
							<xsl:variable name="frameweight">
								<xsl:choose>
									<xsl:when test="@StrokeWeight"><xsl:value-of select="@StrokeWeight"/></xsl:when><!-- line weight is given -->
									<xsl:when test="@StrokeColor and @StrokeTint">1</xsl:when><!-- line tint is given but no line weight @lnwt: means line weight 1pt -->
									<xsl:otherwise>0</xsl:otherwise><!-- set to no line -->
								</xsl:choose>
							</xsl:variable>
							<xsl:if test="($frameweight != '0') and (@StrokeColor or @StrokeTint)"><!-- only if we also have frame line weight and a line tint or color attributes, add frame border attribs -->
								<xsl:attribute name="frameWeight"><xsl:value-of select="$frameweight"/></xsl:attribute>
	
								<xsl:variable name="stst" select="@StrokeType"/>
								<xsl:variable name="framestylename">
									<xsl:choose>
										<xsl:when test="$stst = 'n'">n</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="/Documents/Document/Graphic/StrokeStyle[@Self = $stst]/@Name/."/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:variable name="framestylenameLC" select="locjs:to_lower_case(string($framestylename))"/>
								<xsl:variable name="framestylehtml">
									<xsl:choose>
										<xsl:when test="contains($framestylenameLC,'solid')">solid</xsl:when>
										<xsl:when test="contains($framestylenameLC,'thin')">double</xsl:when>
										<xsl:when test="contains($framestylenameLC,'thick')">double</xsl:when>
										<xsl:when test="contains($framestylenameLC,'dot')">dotted</xsl:when>
										<xsl:when test="contains($framestylenameLC,'dash')">dashed</xsl:when>
										<xsl:otherwise>solid</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:attribute name="frameStyleName"><xsl:value-of select="$framestylename"/></xsl:attribute>
								<xsl:attribute name="frameStyleHTML"><xsl:value-of select="$framestylehtml"/></xsl:attribute>
	
								<xsl:variable name="framecolor">
									<xsl:choose>
										<xsl:when test="@StrokeColor"><xsl:value-of select="@StrokeColor"/></xsl:when>
										<xsl:otherwise><xsl:value-of select="locjs:get_rgb_color_id('black')"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:attribute name="frameColor"><xsl:value-of select="locjs:get_rgb_color(string($framecolor),string(@StrokeTint))"/></xsl:attribute>
								<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
									<xsl:if test="@StrokeColor"><xsl:attribute name="frameColorID"><xsl:value-of select="@StrokeColor"/></xsl:attribute></xsl:if>
									<xsl:if test="@StrokeTint"><xsl:attribute name="frameColorFilt"><xsl:value-of select="@StrokeTint"/></xsl:attribute></xsl:if>
									<xsl:if test="@GapColor"><xsl:attribute name="frameGapColor"><xsl:value-of select="locjs:get_rgb_color(string(@GapColor),string(@GapTint))"/></xsl:attribute></xsl:if>
									<xsl:if test="@GapColor"><xsl:attribute name="frameGapColorID"><xsl:value-of select="@GapColor"/></xsl:attribute></xsl:if>
									<xsl:if test="@GapTint"><xsl:attribute name="frameGapColorTint"><xsl:value-of select="@GapTint"/></xsl:attribute></xsl:if>
									<xsl:if test="@LeftLineEnd"><xsl:attribute name="leftFrameEnd"><xsl:value-of select="@LeftLineEnd"/></xsl:attribute></xsl:if>
									<xsl:if test="@RightLineEnd"><xsl:attribute name="rightFrameEnd"><xsl:value-of select="@RightLineEnd"/></xsl:attribute></xsl:if>
								</xsl:if>
							</xsl:if>

							<!-- get boxes contained in MultiStateObject -->
							<xsl:for-each select="State">
								<multistate>
									<xsl:attribute name="id"><xsl:value-of select="@Self"/></xsl:attribute>
									<xsl:attribute name="initiallyhidden"><xsl:value-of select="@InitiallyHidden"/></xsl:attribute>
									<xsl:attribute name="name"><xsl:value-of select="@Name"/></xsl:attribute>
									<xsl:if test="@Description/.">
										<xsl:attribute name="description"><xsl:value-of select="@Description/."/></xsl:attribute>
									</xsl:if>
									<xsl:apply-templates select="*">
										<xsl:with-param name="action">push</xsl:with-param>
										<xsl:with-param name="anchorID"><xsl:value-of select="$anchorID"/></xsl:with-param>
										<xsl:with-param name="spread"><xsl:value-of select="$spread"/></xsl:with-param>
										<xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
										<xsl:with-param name="page_sequence"><xsl:value-of select="$page_sequence" /></xsl:with-param><!-- the 1 based page sequence -->
										<xsl:with-param name="page_name"><xsl:value-of select="$page_name"/></xsl:with-param>
										<xsl:with-param name="pageside"><xsl:value-of select="$pageside"/></xsl:with-param>
										<xsl:with-param name="maxwidth"><xsl:value-of select="$maxwidth"/></xsl:with-param>
										<xsl:with-param name="maxheight"><xsl:value-of select="$maxheight"/></xsl:with-param>
										<xsl:with-param name="groupid"><xsl:value-of select="$groupid"/></xsl:with-param>
										<xsl:with-param name="thefirstflowid"><xsl:value-of select="$thefirstflowid"/></xsl:with-param>
									</xsl:apply-templates>
								</multistate>
							</xsl:for-each>
	
							<area><!-- get box area -->
								<xsl:attribute name="name">A<xsl:value-of select="@Self"/>_<xsl:value-of select="$page_sequence"/></xsl:attribute><!-- need name attr for Netscape -->
								<xsl:attribute name="shape">rect</xsl:attribute>
								<xsl:attribute name="coords"><xsl:value-of select="$coords"/></xsl:attribute>
								<xsl:if test="$angle != 0.0">
									<xsl:attribute name="angle"><xsl:value-of select="$angle"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="$shape != ''">
									<xsl:attribute name="shape"><xsl:value-of select="$shape"/></xsl:attribute>
								</xsl:if>
								<xsl:attribute name="x1"><xsl:value-of select="$x1"/></xsl:attribute>
								<xsl:attribute name="y1"><xsl:value-of select="$y1"/></xsl:attribute>
								<xsl:attribute name="x2"><xsl:value-of select="$x2"/></xsl:attribute>
								<xsl:attribute name="y2"><xsl:value-of select="$y2"/></xsl:attribute>
								<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
									<xsl:attribute name="matrix"><xsl:value-of select="$matrix"/></xsl:attribute>
									<xsl:attribute name="matrix_orig"><xsl:value-of select="$matrix_orig"/></xsl:attribute>
								</xsl:if>
							</area>
						</box>
					</xsl:when>


					<!-- *********** line boxes ************** -->
					<xsl:when test="(name() = 'GraphicLine') and ($suppressLineBox != '1') and ($suppressAllEmptyBox != '1')">
						<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
							<box>
								<xsl:attribute name="type">line</xsl:attribute>
								<xsl:attribute name="elementName"><xsl:value-of select="name()"/></xsl:attribute>
								<xsl:attribute name="cont"><xsl:value-of select="@ContentType"/></xsl:attribute>
								<xsl:attribute name="Self"><xsl:value-of select="@Self"/></xsl:attribute>
								<xsl:attribute name="spread"><xsl:value-of select="locjs:get_box2page_spread(string(@Self))"/></xsl:attribute>
								<xsl:attribute name="page_sequence"><xsl:value-of select="locjs:get_box2page_page_sequence(string(@Self))"/></xsl:attribute>
								<xsl:attribute name="page_name"><xsl:value-of select="locjs:get_box2page_page_name(string(@Self))"/></xsl:attribute>

								<xsl:choose>
									<xsl:when test="($belongs_to_page_overlap > 0) and ($belongs_to_page_overlap = $page_sequence)">	<!-- is duplicated box overlaping from an other page -->
										<xsl:attribute name="ispageoverlap"><xsl:value-of select="$belongs_to_page_overlap"/></xsl:attribute>
										<xsl:attribute name="coords"><xsl:value-of select="$coords_overlap"/></xsl:attribute>
										<xsl:attribute name="bbox"><xsl:value-of select="$bbox_overlap"/></xsl:attribute>
										<xsl:attribute name="shape"><xsl:value-of select="$shape_overlap"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="coords"><xsl:value-of select="$coords"/></xsl:attribute>
										<xsl:attribute name="bbox"><xsl:value-of select="$bbox"/></xsl:attribute>
										<xsl:attribute name="shape"><xsl:value-of select="$shape"/></xsl:attribute>

										<xsl:if test="$bbox_orig != ''">
											<xsl:attribute name="bbox_orig"><xsl:value-of select="$bbox_orig"/></xsl:attribute>
										</xsl:if>
										<xsl:if test="$shape_orig != ''">
											<xsl:attribute name="shape_orig"><xsl:value-of select="$shape_orig"/></xsl:attribute>
										</xsl:if>
										<xsl:attribute name="x1"><xsl:value-of select="$x1"/></xsl:attribute>
										<xsl:attribute name="y1"><xsl:value-of select="$y1"/></xsl:attribute>
										<xsl:attribute name="x2"><xsl:value-of select="$x2"/></xsl:attribute>
										<xsl:attribute name="y2"><xsl:value-of select="$y2"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>

								<xsl:attribute name="groupid"><xsl:value-of select="$groupid"/></xsl:attribute>
								<xsl:attribute name="allgroupid"><xsl:value-of select="$parentGroupIDs"/></xsl:attribute>
								<xsl:attribute name="anchorid"><xsl:value-of select="$anchorID"/></xsl:attribute>
								<xsl:if test="@Nonprinting">
									<xsl:attribute name="nopr"><xsl:value-of select="@Nonprinting"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="($objectstyle != '') and ($objectstyle != 'n')">
									<xsl:attribute name="objstyle"><xsl:value-of select="$objectstyle"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="$angle != 0.0">
									<xsl:attribute name="angle"><xsl:value-of select="$angle"/></xsl:attribute>
								</xsl:if>
	
								<xsl:variable name="frameweight">
									<xsl:choose>
										<xsl:when test="@StrokeWeight"><xsl:value-of select="@StrokeWeight"/></xsl:when><!-- line weight is given -->
										<xsl:otherwise>1</xsl:otherwise><!-- set to 1pt line -->
									</xsl:choose>
								</xsl:variable>
								<xsl:attribute name="frameWeight"><xsl:value-of select="$frameweight"/></xsl:attribute>
	
									<xsl:variable name="stst" select="@StrokeType"/>
									<xsl:variable name="framestylename">
										<xsl:choose>
											<xsl:when test="$stst = 'n'">n</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="/Documents/Document/Graphic/StrokeStyle[@Self = $stst]/@Name/."/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:variable name="framestylenameLC" select="locjs:to_lower_case(string($framestylename))"/>
									<xsl:variable name="framestylehtml">
										<xsl:choose>
											<xsl:when test="contains($framestylenameLC,'solid')">solid</xsl:when>
											<xsl:when test="contains($framestylenameLC,'thin')">double</xsl:when>
											<xsl:when test="contains($framestylenameLC,'thick')">double</xsl:when>
											<xsl:when test="contains($framestylenameLC,'dot')">dotted</xsl:when>
											<xsl:when test="contains($framestylenameLC,'dash')">dashed</xsl:when>
											<xsl:otherwise>solid</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
								<xsl:attribute name="frameStyleName"><xsl:value-of select="$framestylename"/></xsl:attribute>
								<xsl:attribute name="frameStyleHTML"><xsl:value-of select="$framestylehtml"/></xsl:attribute>
	
								<xsl:variable name="framecolor">
									<xsl:choose>
										<xsl:when test="@StrokeColor"><xsl:value-of select="@StrokeColor"/></xsl:when>
										<xsl:otherwise><xsl:value-of select="locjs:get_rgb_color_id('black')"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:attribute name="frameColor"><xsl:value-of select="locjs:get_rgb_color(string($framecolor),string(@StrokeTint))"/></xsl:attribute>
								<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
									<xsl:if test="@StrokeColor"><xsl:attribute name="frameColorID"><xsl:value-of select="@StrokeColor"/></xsl:attribute></xsl:if>
									<xsl:if test="@StrokeTint"><xsl:attribute name="frameColorFilt"><xsl:value-of select="@StrokeTint"/></xsl:attribute></xsl:if>
									<xsl:if test="@GapColor"><xsl:attribute name="frameGapColor"><xsl:value-of select="locjs:get_rgb_color(string(@GapColor),string(@GapTint))"/></xsl:attribute></xsl:if>
									<xsl:if test="@GapColor"><xsl:attribute name="frameGapColorID"><xsl:value-of select="@GapColor"/></xsl:attribute></xsl:if>
									<xsl:if test="@GapTint"><xsl:attribute name="frameGapColorTint"><xsl:value-of select="@GapTint"/></xsl:attribute></xsl:if>
									<xsl:if test="@LeftLineEnd"><xsl:attribute name="leftFrameEnd"><xsl:value-of select="@LeftLineEnd"/></xsl:attribute></xsl:if>
									<xsl:if test="@RightLineEnd"><xsl:attribute name="rightFrameEnd"><xsl:value-of select="@RightLineEnd"/></xsl:attribute></xsl:if>
									<xsl:attribute name="matrix"><xsl:value-of select="$matrix"/></xsl:attribute>
									<xsl:attribute name="matrix_orig"><xsl:value-of select="$matrix_orig"/></xsl:attribute>
								</xsl:if>
								<xsl:attribute name="pageJPEGScale"><xsl:value-of select="$pageJPEGScale"/></xsl:attribute>
								<xsl:if test="locjs:get_layerID() != ''">
									<xsl:attribute name="layerID"><xsl:value-of select="locjs:get_layerID()"/></xsl:attribute>
									<xsl:attribute name="layerName"><xsl:value-of select="locjs:get_layerName()"/></xsl:attribute>
									<xsl:attribute name="layerVis"><xsl:value-of select="locjs:get_layerVisibility()"/></xsl:attribute>
								</xsl:if>
								<xsl:attribute name="label"><xsl:value-of select="locjs:get_label()"/></xsl:attribute>
	
								<area><!-- get box area -->
									<xsl:attribute name="name">A<xsl:value-of select="@Self"/>_<xsl:value-of select="$page_sequence"/></xsl:attribute><!-- need name attr for Netscape -->
									<xsl:attribute name="shape">rect</xsl:attribute>
									<xsl:attribute name="coords"><xsl:value-of select="$coords"/></xsl:attribute>
									<xsl:if test="$angle != 0.0">
										<xsl:attribute name="angle"><xsl:value-of select="$angle"/></xsl:attribute>
									</xsl:if>
									<xsl:if test="$shape != ''">
										<xsl:attribute name="shape"><xsl:value-of select="$shape"/></xsl:attribute>
									</xsl:if>
									<xsl:attribute name="x1"><xsl:value-of select="$x1"/></xsl:attribute>
									<xsl:attribute name="y1"><xsl:value-of select="$y1"/></xsl:attribute>
									<xsl:attribute name="x2"><xsl:value-of select="$x2"/></xsl:attribute>
									<xsl:attribute name="y2"><xsl:value-of select="$y2"/></xsl:attribute>
									<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
										<xsl:attribute name="matrix"><xsl:value-of select="$matrix"/></xsl:attribute>
										<xsl:attribute name="matrix_orig"><xsl:value-of select="$matrix_orig"/></xsl:attribute>
									</xsl:if>
								</area>
							</box>
						</xsl:if>
					</xsl:when>
	
	
					<!-- *********** we also can have an image box in an image box!!! 
									like: Rectangle/Rectangle/and_an_image_element
									or even: Rectangle/TextFrame/... ************** -->
					<xsl:when test="descendant::*[(@ContentType = 'GraphicType') or (@ContentType = 'TextType')]">
					<!--Image in Image box#################<xsl:value-of select="descendant::*[@ContentType = 'GraphicType']/@Self"/> -->
						<xsl:apply-templates select="descendant::*[(@ContentType = 'GraphicType') or (@ContentType = 'TextType')]">
							<xsl:with-param name="anchorID"><xsl:value-of select="$anchorID"/></xsl:with-param>
							<xsl:with-param name="spread"><xsl:value-of select="$spread"/></xsl:with-param>
							<xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
							<xsl:with-param name="page_sequence"><xsl:value-of select="$page_sequence" /></xsl:with-param>
							<xsl:with-param name="page_name"><xsl:value-of select="$page_name"/></xsl:with-param>
							<xsl:with-param name="pageside"><xsl:value-of select="$pageside"/></xsl:with-param>
							<xsl:with-param name="maxwidth"><xsl:value-of select="$maxwidth"/></xsl:with-param>
							<xsl:with-param name="maxheight"><xsl:value-of select="$maxheight"/></xsl:with-param>
							<xsl:with-param name="groupid"><xsl:value-of select="$groupid"/></xsl:with-param>
							<xsl:with-param name="thefirstflowid"><xsl:value-of select="$thefirstflowid"/></xsl:with-param>
							<xsl:with-param name="isImageInImageBelongs_to_page"><xsl:value-of select="$belongs_to_page"/></xsl:with-param>
						</xsl:apply-templates>
					</xsl:when>
	
	
					<!-- *********** for image boxes Rectangle, Polgon, Oval and GraphicLine ************** -->
					<xsl:otherwise>
						<xsl:variable name="d1" select="locjs:reset_ImagePreviewFormats()"/>
						<xsl:variable name="d2" select="locjs:reset_IGeos()"/>
						<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
							<xsl:variable name="d" select="locjs:message(concat('***** Image Tag: ',name(),' belongs_to_page: ',$belongs_to_page))"/>
							<xsl:if test="(name(..) = 'Rectangle') or (name(..) = 'Polygon') or (name(..) = 'Oval')">
								<xsl:variable name="d" select="locjs:message(concat('   ** Image ',name(),' is ImageInImage of parent element ',name(..)))"/>
							</xsl:if>
						</xsl:if>
						<xsl:if test="Image/Link | EPS/Link | PICT/Link | PDF/Link | ImportedPage/Link | WMF/Link"><!-- if image with a link to external file -->
							<!-- store infos to imageInImage -->
							<xsl:variable name="imageinimage_igeo">
								<xsl:if test="(name(..) = 'Rectangle') or (name(..) = 'Polygon') or (name(..) = 'Oval')">
									<xsl:for-each select="../Properties/PathGeometry/GeometryPathType/PathPointArray/PathPointType">
										<xsl:value-of select="@Anchor"/><xsl:if test="position() != last()"><xsl:text> </xsl:text></xsl:if>
									</xsl:for-each>
									<xsl:text>;</xsl:text><xsl:value-of select="../@ItemTransform"/>
								</xsl:if>
							</xsl:variable>
							<xsl:variable name="d2" select="locjs:store_imagInImage_IGeo(string($imageinimage_igeo))"/>
	
							<!-- store position of image box -->
							<xsl:variable name="imageboxigeo">
								<xsl:for-each select="Properties/PathGeometry/GeometryPathType/PathPointArray/PathPointType">
									<xsl:value-of select="@Anchor"/><xsl:if test="position() != last()"><xsl:text> </xsl:text></xsl:if>
								</xsl:for-each>
								<xsl:text>;</xsl:text><xsl:value-of select="@ItemTransform"/>
							</xsl:variable>
							<xsl:variable name="d1" select="locjs:store_IGeo(string($imageboxigeo))"/>
							<xsl:choose>
								<xsl:when test="Image/Link">
									<xsl:variable name="image_igeo" select="locjs:calc_Image_igeo(locjs:get_IGeo(),string(FrameFittingOption/@LeftCrop),string(FrameFittingOption/@TopCrop),string(FrameFittingOption/@RightCrop),string(FrameFittingOption/@BottomCrop),string(Image/@ItemTransform),string(Image/Properties/GraphicBounds/@Left),string(Image/Properties/GraphicBounds/@Top),string(Image/Properties/GraphicBounds/@Right),string(Image/Properties/GraphicBounds/@Bottom))"/>
									<xsl:variable name="d2" select="locjs:store_imag_IGeo(string($image_igeo))"/>
									<xsl:variable name="d3" select="locjs:store_imag_clnk_LnkI(string(Image/Link/@LinkResourceURI))"/>
									<xsl:if test="Image/@ActualPpi"><xsl:variable name="d1" select="locjs:store_original_image_Appi(string(Image/@ActualPpi))"/></xsl:if>
									<xsl:if test="Image/@EffectivePpi"><xsl:variable name="d1" select="locjs:store_original_image_Eppi(string(Image/@EffectivePpi))"/></xsl:if>
								</xsl:when>
								<xsl:when test="EPS/Link"><!-- for EPS -->
									<xsl:variable name="image_igeo" select="locjs:calc_Image_igeo(locjs:get_IGeo(),string(FrameFittingOption/@LeftCrop),string(FrameFittingOption/@TopCrop),string(FrameFittingOption/@RightCrop),string(FrameFittingOption/@BottomCrop),string(EPS/@ItemTransform),string(EPS/Properties/GraphicBounds/@Left),string(EPS/Properties/GraphicBounds/@Top),string(EPS/Properties/GraphicBounds/@Right),string(EPS/Properties/GraphicBounds/@Bottom))"/>
									<xsl:variable name="d2" select="locjs:store_imag_IGeo(string($image_igeo))"/>
									<xsl:variable name="d3" select="locjs:store_imag_clnk_LnkI(string(EPS/Link/@LinkResourceURI))"/>
									<xsl:if test="EPS/@ActualPpi"><xsl:variable name="d1" select="locjs:store_original_image_Appi(string(EPS/@ActualPpi))"/></xsl:if>
									<xsl:if test="EPS/@EffectivePpi"><xsl:variable name="d1" select="locjs:store_original_image_Eppi(string(EPS/@EffectivePpi))"/></xsl:if>
								</xsl:when>
								<xsl:when test="PDF/Link"><!-- for PDF and AI (Adobe Illustrator is PDF) -->
									<xsl:variable name="image_igeo" select="locjs:calc_Image_igeo(locjs:get_IGeo(),string(FrameFittingOption/@LeftCrop),string(FrameFittingOption/@TopCrop),string(FrameFittingOption/@RightCrop),string(FrameFittingOption/@BottomCrop),string(PDF/@ItemTransform),string(PDF/Properties/GraphicBounds/@Left),string(PDF/Properties/GraphicBounds/@Top),string(PDF/Properties/GraphicBounds/@Right),string(PDF/Properties/GraphicBounds/@Bottom))"/>
									<xsl:variable name="d2" select="locjs:store_imag_IGeo(string($image_igeo))"/>
									<xsl:variable name="d3" select="locjs:store_imag_clnk_LnkI(string(PDF/Link/@LinkResourceURI))"/>
									<xsl:if test="PDF/@ActualPpi"><xsl:variable name="d1" select="locjs:store_original_image_Appi(string(PDF/@ActualPpi))"/></xsl:if>
									<xsl:if test="PDF/@EffectivePpi"><xsl:variable name="d1" select="locjs:store_original_image_Eppi(string(PDF/@EffectivePpi))"/></xsl:if>
								</xsl:when>
								<xsl:when test="ImportedPage/Link"><!-- for PDF and AI (Adobe Illustrator is PDF) -->
									<xsl:variable name="image_igeo" select="locjs:calc_Image_igeo(locjs:get_IGeo(),string(FrameFittingOption/@LeftCrop),string(FrameFittingOption/@TopCrop),string(FrameFittingOption/@RightCrop),string(FrameFittingOption/@BottomCrop),string(ImportedPage/@ItemTransform),string(ImportedPage/Properties/GraphicBounds/@Left),string(ImportedPage/Properties/GraphicBounds/@Top),string(ImportedPage/Properties/GraphicBounds/@Right),string(ImportedPage/Properties/GraphicBounds/@Bottom))"/>
									<xsl:variable name="d2" select="locjs:store_imag_IGeo(string($image_igeo))"/>
									<xsl:variable name="d3" select="locjs:store_imag_clnk_LnkI(string(ImportedPage/Link/@LinkResourceURI))"/>
									<xsl:if test="ImportedPage/@ActualPpi"><xsl:variable name="d1" select="locjs:store_original_image_Appi(string(ImportedPage/@ActualPpi))"/></xsl:if>
									<xsl:if test="ImportedPage/@EffectivePpi"><xsl:variable name="d1" select="locjs:store_original_image_Eppi(string(ImportedPage/@EffectivePpi))"/></xsl:if>
								</xsl:when>
								<xsl:when test="PICT/Link">
									<xsl:variable name="image_igeo" select="locjs:calc_Image_igeo(locjs:get_IGeo(),string(FrameFittingOption/@LeftCrop),string(FrameFittingOption/@TopCrop),string(FrameFittingOption/@RightCrop),string(FrameFittingOption/@BottomCrop),string(PICT/@ItemTransform),string(PICT/Properties/GraphicBounds/@Left),string(PICT/Properties/GraphicBounds/@Top),string(PICT/Properties/GraphicBounds/@Right),string(PICT/Properties/GraphicBounds/@Bottom))"/>
									<xsl:variable name="d2" select="locjs:store_imag_IGeo(string($image_igeo))"/>
									<xsl:variable name="d3" select="locjs:store_imag_clnk_LnkI(string(PICT/Link/@LinkResourceURI))"/>
									<xsl:if test="PICT/@ActualPpi"><xsl:variable name="d1" select="locjs:store_original_image_Appi(string(PICT/@ActualPpi))"/></xsl:if>
									<xsl:if test="PICT/@EffectivePpi"><xsl:variable name="d1" select="locjs:store_original_image_Eppi(string(PICT/@EffectivePpi))"/></xsl:if>
								</xsl:when>
								<xsl:when test="WMF/Link"><!-- for Windows Meta Files -->
									<xsl:variable name="image_igeo" select="locjs:calc_Image_igeo(locjs:get_IGeo(),string(FrameFittingOption/@LeftCrop),string(FrameFittingOption/@TopCrop),string(FrameFittingOption/@RightCrop),string(FrameFittingOption/@BottomCrop),string(WMF/@ItemTransform),string(WMF/Properties/GraphicBounds/@Left),string(WMF/Properties/GraphicBounds/@Top),string(WMF/Properties/GraphicBounds/@Right),string(WMF/Properties/GraphicBounds/@Bottom))"/>
									<xsl:variable name="d2" select="locjs:store_imag_IGeo(string($image_igeo))"/>
									<xsl:variable name="d3" select="locjs:store_imag_clnk_LnkI(string(WMF/Link/@LinkResourceURI))"/>
									<xsl:if test="WMF/@ActualPpi"><xsl:variable name="d1" select="locjs:store_original_image_Appi(string(WMF/@ActualPpi))"/></xsl:if>
									<xsl:if test="WMF/@EffectivePpi"><xsl:variable name="d1" select="locjs:store_original_image_Eppi(string(WMF/@EffectivePpi))"/></xsl:if>
								</xsl:when>
								<xsl:otherwise><!-- for others -->
								</xsl:otherwise>
							</xsl:choose>
						</xsl:if>
	
						<xsl:variable name="source_imagename_orig" select="locjs:xPlatformName(locjs:get_image_name(string(locjs:get_imag_clnk_LnkI()),''),false())"/>
						<xsl:variable name="src_image_pathname" select="locjs:get_image_pathname()"/><!-- must be directly AFTER 'get_image_name' -->
						<xsl:variable name="source_imagename">
							<xsl:variable name="tmp_source_imagepathname"><xsl:value-of select="$INPUT_PATH"/><xsl:value-of select="$source_imagename_orig"/></xsl:variable>
							<xsl:variable name="tmp_src_file_exists" select="locjs:fileExists(string($tmp_source_imagepathname))"/>
							<xsl:choose>
								<xsl:when test="$tmp_src_file_exists = true()"><xsl:value-of select="$source_imagename_orig"/></xsl:when>
								<xsl:otherwise><!-- try to find the totally encoded name -->
									<!--xsl:variable name="d" select="myutils:showMess(concat('&#10;++++++ ',$source_imagename_orig),'1')"/-->
									<xsl:variable name="encoded_source_imagename"><xsl:value-of select="locjs:xPlatformName($source_imagename_orig,true())"/></xsl:variable>
									<!--xsl:variable name="d" select="myutils:showMess(concat('******* ',$encoded_source_imagename),'1')"/-->
									<xsl:choose>
										<xsl:when test="contains($my_XPLATFORM_NAMES,'9')"><xsl:value-of select="$encoded_source_imagename"/></xsl:when>
										<xsl:otherwise><xsl:value-of select="$source_imagename_orig"/></xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
							
						</xsl:variable>
	
						<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
							<xsl:variable name="d" select="locjs:message(concat('***** Image Box ID: ',@Self))"/>
							<xsl:variable name="d" select="locjs:message(concat('      Image Name orig: ',$source_imagename_orig))"/>
							<xsl:variable name="d" select="locjs:message(concat('      Image Name: ',$source_imagename))"/>
							<xsl:variable name="d" select="locjs:message(concat('      get_export_images: ',locjs:get_export_images()))"/>
							<xsl:variable name="d" select="locjs:message(concat('      is_imageExclude: ',locjs:is_imageExclude(string($source_imagename))))"/>
						</xsl:if>
						<xsl:if test="(locjs:get_export_images() > 0) and (locjs:is_imageExclude(string($source_imagename)) = false)">
							<xsl:variable name="cont">
								<xsl:choose>
									<xsl:when test="@ContentType = 'Unassigned'">unas</xsl:when>
									<xsl:when test="Image | EPS | PICT | PDF | ImportedPage | WMF">imag</xsl:when>
									<xsl:otherwise>empty</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							<xsl:variable name="box_type"><xsl:if test="$anchorID != ''">anchored_</xsl:if>imag</xsl:variable>
							<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
								<xsl:variable name="d" select="locjs:message(concat('      Image Box Type: ',$box_type))"/>
							</xsl:if>
	
							<box>
								<xsl:attribute name="type"><xsl:value-of select="$box_type"/></xsl:attribute>
								<xsl:attribute name="elementName"><xsl:value-of select="name()"/></xsl:attribute>
								<xsl:attribute name="cont"><xsl:value-of select="$cont"/></xsl:attribute>
								<xsl:attribute name="Self"><xsl:value-of select="@Self"/></xsl:attribute>
								<xsl:attribute name="page_sequence"><xsl:value-of select="$page_sequence"/></xsl:attribute>
								<xsl:attribute name="page_name"><xsl:value-of select="$page_name"/></xsl:attribute>

								<xsl:choose>
									<xsl:when test="($belongs_to_page_overlap > 0) and ($belongs_to_page_overlap = $page_sequence)">	<!-- is duplicated box overlaping from an other page -->
										<xsl:attribute name="ispageoverlap"><xsl:value-of select="$belongs_to_page_overlap"/></xsl:attribute>
										<xsl:attribute name="coords"><xsl:value-of select="$coords_overlap"/></xsl:attribute>
										<xsl:attribute name="bbox"><xsl:value-of select="$bbox_overlap"/></xsl:attribute>
										<xsl:attribute name="shape"><xsl:value-of select="$shape_overlap"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="coords"><xsl:value-of select="$coords"/></xsl:attribute>
										<xsl:attribute name="bbox"><xsl:value-of select="$bbox"/></xsl:attribute>
										<xsl:attribute name="shape"><xsl:value-of select="$shape"/></xsl:attribute>

										<xsl:if test="$bbox_orig != ''">
											<xsl:attribute name="bbox_orig"><xsl:value-of select="$bbox_orig"/></xsl:attribute>
										</xsl:if>
										<xsl:if test="$shape_orig != ''">
											<xsl:attribute name="shape_orig"><xsl:value-of select="$shape_orig"/></xsl:attribute>
										</xsl:if>
										<xsl:attribute name="x1"><xsl:value-of select="$x1"/></xsl:attribute>
										<xsl:attribute name="y1"><xsl:value-of select="$y1"/></xsl:attribute>
										<xsl:attribute name="x2"><xsl:value-of select="$x2"/></xsl:attribute>
										<xsl:attribute name="y2"><xsl:value-of select="$y2"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>

								<xsl:if test="(locjs:get_includeXMLtags() != '0' ) and ($XMLElementSelf != '')">
									<xsl:attribute name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:attribute>
									<xsl:attribute name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:attribute>
									<xsl:if test="$XMLElementXMLContent != ''"><xsl:attribute name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:attribute></xsl:if>
									<!-- get more attribs from XMLAttribute elements -->
									<xsl:for-each select="/Documents/Document/Story/Story[@Self = $parentstory]/XMLElement/XMLAttribute">
										<xsl:attribute name="{concat('XMLAttribute_',locjs:stripNameSpaceColon(string(@Name)))}"><xsl:value-of disable-output-escaping="yes" select="locjs:safe_attr(locjs:cleanSeparator(string(@Value)))"/></xsl:attribute>
									</xsl:for-each>
								</xsl:if>
								<xsl:if test="$action">
									<xsl:attribute name="action"><xsl:value-of select="$action"/></xsl:attribute>
								</xsl:if>
								<xsl:attribute name="groupid"><xsl:value-of select="$groupid"/></xsl:attribute>
								<xsl:attribute name="allgroupid"><xsl:value-of select="$parentGroupIDs"/></xsl:attribute>
								<xsl:attribute name="anchorid"><xsl:value-of select="$anchorID"/></xsl:attribute>
								<xsl:if test="$imagepagearea != ''"><!-- for anchored images only -->
									<xsl:attribute name="imagepagearea"><xsl:value-of select="$imagepagearea"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="@Nonprinting">
									<xsl:attribute name="nopr"><xsl:value-of select="@Nonprinting"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="($objectstyle != '') and ($objectstyle != 'n')">
									<xsl:attribute name="objstyle"><xsl:value-of select="$objectstyle"/></xsl:attribute><!-- object style -->
								</xsl:if>
								<xsl:if test="@CornerRadius">
									<xsl:attribute name="cornerradius"><xsl:value-of select="@CornerRadius"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="$angle != 0.0">
									<xsl:attribute name="angle"><xsl:value-of select="$angle"/></xsl:attribute>
								</xsl:if>
								<xsl:attribute name="pageJPEGScale"><xsl:value-of select="$pageJPEGScale"/></xsl:attribute>
								<xsl:if test="locjs:get_layerID() != ''">
									<xsl:attribute name="layerID"><xsl:value-of select="locjs:get_layerID()"/></xsl:attribute>
									<xsl:attribute name="layerName"><xsl:value-of select="locjs:get_layerName()"/></xsl:attribute>
									<xsl:attribute name="layerVis"><xsl:value-of select="locjs:get_layerVisibility()"/></xsl:attribute>
								</xsl:if>
								<xsl:attribute name="label"><xsl:value-of select="$label"/></xsl:attribute>
								<xsl:attribute name="backgroundColor"><xsl:value-of select="locjs:get_rgb_color(string(@FillColor),string(@FillTint))"/></xsl:attribute>
								<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
									<xsl:if test="@FillColor"><xsl:attribute name="backgroundColorID"><xsl:value-of select="@FillColor"/></xsl:attribute></xsl:if>
									<xsl:if test="@FillTint"><xsl:attribute name="backgroundColorFilt"><xsl:value-of select="@FillTint"/></xsl:attribute></xsl:if>
									<xsl:attribute name="matrix"><xsl:value-of select="$matrix"/></xsl:attribute>
									<xsl:attribute name="matrix_orig"><xsl:value-of select="$matrix_orig"/></xsl:attribute>
								</xsl:if>
	
								<xsl:variable name="frameweight">
									<xsl:choose>
										<xsl:when test="@StrokeWeight"><xsl:value-of select="@StrokeWeight"/></xsl:when><!-- line weight is given -->
										<xsl:when test="@StrokeColor and @StrokeTint">1</xsl:when>
										<xsl:otherwise>0</xsl:otherwise><!-- set to no line -->
									</xsl:choose>
								</xsl:variable>
								<xsl:if test="($frameweight != '0') and (@StrokeColor or @StrokeTint)"><!-- only if we also have frame line weight and a line tint or color attributes, add frame border attribs -->
									<xsl:attribute name="frameWeight"><xsl:value-of select="$frameweight"/></xsl:attribute>
	
									<xsl:variable name="stst" select="@StrokeType"/>
									<xsl:variable name="framestylename">
										<xsl:choose>
											<xsl:when test="$stst = 'n'">n</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="/Documents/Document/Graphic/StrokeStyle[@Self = $stst]/@Name/."/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:variable name="framestylenameLC" select="locjs:to_lower_case(string($framestylename))"/>
									<xsl:variable name="framestylehtml">
										<xsl:choose>
											<xsl:when test="contains($framestylenameLC,'solid')">solid</xsl:when>
											<xsl:when test="contains($framestylenameLC,'thin')">double</xsl:when>
											<xsl:when test="contains($framestylenameLC,'thick')">double</xsl:when>
											<xsl:when test="contains($framestylenameLC,'dot')">dotted</xsl:when>
											<xsl:when test="contains($framestylenameLC,'dash')">dashed</xsl:when>
											<xsl:otherwise>solid</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:attribute name="frameStyleName"><xsl:value-of select="$framestylename"/></xsl:attribute>
									<xsl:attribute name="frameStyleHTML"><xsl:value-of select="$framestylehtml"/></xsl:attribute>
	
									<xsl:variable name="framecolor">
										<xsl:choose>
											<xsl:when test="@StrokeColor"><xsl:value-of select="@StrokeColor"/></xsl:when>
											<xsl:otherwise><xsl:value-of select="locjs:get_rgb_color_id('black')"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:attribute name="frameColor"><xsl:value-of select="locjs:get_rgb_color(string($framecolor),string(@StrokeTint))"/></xsl:attribute>
									<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
										<xsl:if test="@StrokeColor"><xsl:attribute name="frameColorID"><xsl:value-of select="@StrokeColor"/></xsl:attribute></xsl:if>
										<xsl:if test="@StrokeTint"><xsl:attribute name="frameColorFilt"><xsl:value-of select="@StrokeTint"/></xsl:attribute></xsl:if>
										<xsl:if test="@GapColor"><xsl:attribute name="frameGapColor"><xsl:value-of select="locjs:get_rgb_color(string(@GapColor),string(@GapTint))"/></xsl:attribute></xsl:if>
										<xsl:if test="@GapColor"><xsl:attribute name="frameGapColorID"><xsl:value-of select="@GapColor"/></xsl:attribute></xsl:if>
										<xsl:if test="@GapTint"><xsl:attribute name="frameGapColorTint"><xsl:value-of select="@GapTint"/></xsl:attribute></xsl:if>
										<xsl:if test="@LeftLineEnd"><xsl:attribute name="leftFrameEnd"><xsl:value-of select="@LeftLineEnd"/></xsl:attribute></xsl:if>
										<xsl:if test="@RightLineEnd"><xsl:attribute name="rightFrameEnd"><xsl:value-of select="@RightLineEnd"/></xsl:attribute></xsl:if>
									</xsl:if>
								</xsl:if>
								<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
									<xsl:if test="$src_image_pathname != ''">
										<xsl:attribute name="srcimgpathname"><xsl:value-of select="$src_image_pathname"/></xsl:attribute>
									</xsl:if>
								</xsl:if>
								<!-- attributes for anchored objects -->
								<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
									<xsl:if test="$anchorID != ''">
										<xsl:if test="AnchoredObjectSetting/@AnchoredPosition"><xsl:attribute name="ao_Position"><xsl:value-of select="AnchoredObjectSetting/@AnchoredPosition"/></xsl:attribute></xsl:if><!-- InlinePosition = inline, AOPa = Above Line, AoPa = custom -->
										<xsl:if test="AnchoredObjectSetting/@SpineRelative"><xsl:attribute name="ao_relSpine"><xsl:value-of select="AnchoredObjectSetting/@SpineRelative"/></xsl:attribute></xsl:if><!-- true or false -->
										<xsl:if test="AnchoredObjectSetting/@LockPosition"><xsl:attribute name="ao_lockPosition"><xsl:value-of select="AnchoredObjectSetting/@LockPosition"/></xsl:attribute></xsl:if><!-- true or false -->
										<xsl:if test="AnchoredObjectSetting/@PinPosition"><!-- Keep with Top/Bottom Column Boundaries: true or false -->
											<xsl:attribute name="ao_pinPosition"><xsl:value-of select="AnchoredObjectSetting/@PinPosition"/></xsl:attribute>
											<xsl:attribute name="ao_keepColBound"><xsl:value-of select="AnchoredObjectSetting/@PinPosition"/></xsl:attribute>
										</xsl:if>
										<xsl:if test="AnchoredObjectSetting/@AnchorPoint"><xsl:attribute name="ao_refPoint"><xsl:value-of select="AnchoredObjectSetting/@AnchorPoint"/></xsl:attribute></xsl:if><!-- reference Point of Anchored Object: ANtl, ANtc, ANtr, ANlc, ANbl, ANbc, ANtr, ANrc, ANct -->
										<xsl:if test="AnchoredObjectSetting/@HorizontalAlignment"><xsl:attribute name="ao_horizAlign"><xsl:value-of select="AnchoredObjectSetting/@HorizontalAlignment"/></xsl:attribute></xsl:if><!-- left, cent, rght, (spine opt not supported), txal -->
										<xsl:if test="AnchoredObjectSetting/@HorizontalReferencePoint"><xsl:attribute name="ao_xRelTo"><xsl:value-of select="AnchoredObjectSetting/@HorizontalReferencePoint"/></xsl:attribute></xsl:if><!-- x relative to: txtf=textframe, APan=anchor marker, APco= column edge, APmg= page margin, APpg=page edge -->
										<xsl:if test="AnchoredObjectSetting/@VerticalAlignment"><xsl:attribute name="ao_vertAlign"><xsl:value-of select="AnchoredObjectSetting/@VerticalAlignment"/></xsl:attribute></xsl:if><!-- left, cent, rght, (spine opt not supported), txal -->
										<xsl:if test="AnchoredObjectSetting/@VerticalReferencePoint"><xsl:attribute name="ao_yRelTo"><xsl:value-of select="AnchoredObjectSetting/@VerticalReferencePoint"/></xsl:attribute></xsl:if><!-- y relative to: AVba=baseline, AVxc=Cap Height, AVbl=Top of Leading, APco=column edge, txtf=Text Frame, APmg=page margin, APpg=page edge -->
										<xsl:if test="AnchoredObjectSetting/@AnchorXoffset"><xsl:attribute name="ao_xOffset"><xsl:value-of select="AnchoredObjectSetting/@AnchorXoffset"/></xsl:attribute></xsl:if><!-- custom x offset -->
										<xsl:if test="AnchoredObjectSetting/@AnchorYoffset"><xsl:attribute name="ao_yOffset"><xsl:value-of select="AnchoredObjectSetting/@AnchorYoffset"/></xsl:attribute></xsl:if><!-- inline y offset or 'above line: space after' -->
										<xsl:if test="AnchoredObjectSetting/@AnchorSpaceAbove"><xsl:attribute name="ao_yOffsetAbove"><xsl:value-of select="AnchoredObjectSetting/@AnchorSpaceAbove"/></xsl:attribute></xsl:if><!-- above line: space before -->
										<xsl:if test="AnchoredObjectSetting/@LockPosition"><!-- lock position: prevent manual positioning -->
											<xsl:attribute name="ao_lockPos"><xsl:value-of select="AnchoredObjectSetting/@LockPosition"/></xsl:attribute>
											<xsl:attribute name="ao_NoManualPos"><xsl:value-of select="AnchoredObjectSetting/@LockPosition"/></xsl:attribute><!-- due to history -->
										</xsl:if>
									</xsl:if>
								</xsl:if>
	
								<!-- if NO image available = empty (background) box -->
								<xsl:if test="not(Image or EPS or PICT or PDF or ImportedPage or WMF)">
										<xsl:call-template name="get_image">
											<xsl:with-param name="exist">0</xsl:with-param>
											<xsl:with-param name="anchorID"><xsl:value-of select="$anchorID"/></xsl:with-param>
											<xsl:with-param name="groupid"><xsl:value-of select="$groupid"/></xsl:with-param>
											<xsl:with-param name="self"><xsl:value-of select="@Self"/></xsl:with-param>
											<xsl:with-param name="src_imagename"></xsl:with-param>
											<xsl:with-param name="src_imagename_orig"></xsl:with-param>
											<xsl:with-param name="target_imagename"></xsl:with-param>
											<xsl:with-param name="contentlabel"></xsl:with-param>
											<xsl:with-param name="originalCopied"></xsl:with-param>
											<xsl:with-param name="isemptyimagebox">1</xsl:with-param>
											<xsl:with-param name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:with-param>
											<xsl:with-param name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:with-param>
											<xsl:with-param name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:with-param>
											<xsl:with-param name="XMLElementAttributes"><xsl:value-of select="$XMLElementAttributes"/></xsl:with-param>
										</xsl:call-template>
								</xsl:if>
	
								<!-- if image available, else=empty (background) box -->
								<xsl:if test="Image or EPS or PICT or PDF or ImportedPage or WMF">
									<!-- get the desired layer out of an evtl. multi-layer PDF -->
									<xsl:variable name="source_image_layer">
										<xsl:choose>
											<xsl:when test="PDF/PDFAttribute/@PageNumber">[<xsl:value-of select="PDF/PDFAttribute/@PageNumber - 1"/>]</xsl:when>
											<xsl:when test="ImportedPage/PDFAttribute/@PageNumber">[<xsl:value-of select="ImportedPage/PDFAttribute/@PageNumber - 1"/>]</xsl:when>
										</xsl:choose>
									</xsl:variable>
	
									<xsl:variable name="d0" select="locjs:store_Value(0,string($source_imagename))"/><!-- our new source file name -->
									<xsl:variable name="source_imagepathname"><xsl:value-of select="$INPUT_PATH"/><xsl:value-of select="$source_imagename"/></xsl:variable>
									<xsl:variable name="d1" select="locjs:store_Value(1,string($source_imagepathname))"/><!-- our new source file path/name -->
			
									<xsl:variable name="target_prefix">
										<xsl:if test="$imageAddTargetPrefix != 0"><xsl:value-of select="concat(@Self,'_')"/></xsl:if>
									</xsl:variable>
									<xsl:variable name="target_imagename">
										<xsl:variable name="tmp_target_imagename">
											<xsl:value-of select="concat($target_prefix,locjs:get_image_name(string(locjs:get_imag_clnk_LnkI()),string($IMtype)))"/>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="$my_XPLATFORM_NAMES = '0'"><xsl:value-of select="$tmp_target_imagename"/></xsl:when>
											<xsl:when test="contains($my_XPLATFORM_NAMES,'1')"><xsl:value-of select="locjs:encode_URI(string($tmp_target_imagename),string($my_XPLATFORM_NAMES))"/></xsl:when>
											<xsl:when test="contains($my_XPLATFORM_NAMES,'3')"><xsl:value-of select="locjs:make_internet_name(string($tmp_target_imagename),string($my_XPLATFORM_NAMES))"/></xsl:when>
											<xsl:when test="contains($my_XPLATFORM_NAMES,'9')"><xsl:value-of select="locjs:xPlatformName(string($tmp_target_imagename),true())"/></xsl:when>
											<xsl:otherwise><xsl:value-of select="locjs:xPlatformName(string($tmp_target_imagename),false())"/></xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:variable name="d2" select="locjs:store_Value(2,string($target_imagename))"/><!-- our converted target file name -->
			
									<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
										<xsl:variable name="d" select="locjs:message(concat('***** Image Target Name: ',$target_imagename))"/>
									</xsl:if>
									<xsl:if test="( (locjs:is_imageExclude(string($source_imagename)) = false) and ($target_imagename != '') and ((locjs:get_export_images() &gt; 0) or ($DEBUG = 1) or ($DEBUGIMAGES = 1)) )">

										<xsl:variable name="target_imagepathname"><xsl:value-of select="$the_OUTPUT_PATH"/><xsl:value-of select="$target_imagename"/></xsl:variable>
										<xsl:variable name="target_imagepathname_exists"><xsl:value-of select="locjs:fileExists(string($target_imagepathname))"/></xsl:variable>
										<xsl:variable name="do_convert_to_target_image">
											<xsl:choose>
												<xsl:when test="($target_imagepathname_exists = 'true') and ($imageOverwriteTargetIfExists = '0')"><!-- do not overwrite if exists -->
													<xsl:value-of select="0"/>
													<xsl:variable name="d" select="myutils:showMess(concat('&#10;      - Image target EXISTS: ',$target_imagename),'1')"/>
												</xsl:when>
												<xsl:otherwise>1</xsl:otherwise><!-- convert it -->
											</xsl:choose>
										</xsl:variable>

										<xsl:if test="($do_convert_to_target_image = '1') and ($ImageMagickConvert != '') and ($imageNOCONVERT != '1')"><!-- create jpeg only if ImageMagick's CONVERT program is reachable AND images must be converted -->
			
											<!-- check if source image file exists -->
											<!-- xsl:variable name="d1" select="locjs:message(concat('   ++expected image: ',$source_imagepathname))"/ -->
											<xsl:variable name="original_image_file_exists" select="locjs:fileExists(string($source_imagepathname))"/>
	
	
											<xsl:variable name="imagedata64">
												<xsl:if test="($original_image_file_exists = false) or ($source_imagename = '')"><!-- if source image file does not exist, check if image data is embedded -->
													<!-- decode image data from Base64 -->
													<xsl:choose>
														<xsl:when test="PDF/Properties/Contents"><xsl:apply-templates select="PDF/Properties/Contents/text()" mode="embeddedimage"/></xsl:when>
														<xsl:when test="ImportedPage/Properties/Contents"><xsl:apply-templates select="ImportedPage/Properties/Contents/text()" mode="embeddedimage"/></xsl:when>
														<xsl:when test="Image/Properties/Contents"><xsl:apply-templates select="Image/Properties/Contents/text()" mode="embeddedimage"/></xsl:when>
														<xsl:when test="PICT/Properties/Contents"><xsl:apply-templates select="PICT/Properties/Contents/text()" mode="embeddedimage"/></xsl:when>
														<xsl:when test="EPS/Properties/Contents"><xsl:apply-templates select="EPS/Properties/Contents/text()" mode="embeddedimage"/></xsl:when>
														<xsl:when test="WMF/Properties/Contents"><xsl:apply-templates select="WMF/Properties/Contents/text()" mode="embeddedimage"/></xsl:when>
														<!-- no data embedded. try to get from preview data -->
														<!-- currently disabled, because image preview data is not saved into IDML -->
														<!--xsl:when test="descendant::MetadataPacketPreference/Properties/Contents">
															<xsl:call-template name="get_preview_image"/>
														</xsl:when-->
													</xsl:choose>
												</xsl:if>
											</xsl:variable>
				
											<xsl:variable name="d" select="locjs:store_Value(3,'0')"/><!-- set to 'image file NOT created' from internal -->
											<xsl:if test="((($original_image_file_exists = false) or ($source_imagename = '')) and ($imagedata64 != ''))"><!-- if source image file does not exist, check if image data is embedded -->
												<xsl:choose>
													<xsl:when test="$imagedata64 != ''"><!-- if image data embedded: create the source image file -->
														<!-- decode image data from Base64 -->
														<xsl:variable name="imagedata" select="myutils:decodeBase64(string($imagedata64))"/>
														<!-- write image to file -->
														<xsl:variable name="imagename">
															<xsl:variable name="preview_imageformat"><xsl:value-of select="locjs:get_ImagePreview_format()"/></xsl:variable>
															<xsl:if test="$preview_imageformat != ''"><!-- image is from internal preview -->
																<xsl:variable name="preview_imagename"><xsl:value-of select="locjs:restore_Value(0)"/></xsl:variable><!-- get original name -->
																<xsl:variable name="new_preview_imagename">
																	<xsl:choose>
																		<xsl:when test="$preview_imageformat = 'JPEG'">
																			<xsl:value-of select="locjs:create_new_nameextension(string($preview_imagename),'.jpg')"/>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:value-of select="preview_imagename"/>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:variable>
																<xsl:variable name="d0" select="locjs:store_Value(0,string($new_preview_imagename))"/><!-- store our new source file extension -->
															</xsl:if>
															<xsl:value-of select="locjs:restore_Value(0)"/>
														</xsl:variable>
														<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
															<xsl:variable name="d1" select="locjs:message(concat('   ++internal image: ',$imagename))"/>
														</xsl:if>
														<xsl:variable name="d1" select="locjs:store_Value(0,string($imagename))"/><!-- our new source file -->

														<xsl:choose><!-- create/write file only if a file name is ready -->
															<xsl:when test="$imagename != ''">
																<!--xsl:variable name="imagepathname"><xsl:value-of select="$source_imagepathname"/></xsl:variable-->
																<xsl:variable name="imagepathname"><xsl:value-of select="$INPUT_PATH"/><xsl:value-of select="$imagename"/></xsl:variable>
			
																<xsl:variable name="d2" select="locjs:store_Value(1,string($imagepathname))"/><!-- our new source file -->
								
																<!--xsl:variable name="d" select="locjs:message(concat('+++ line 2953 writefile: ',$imagepathname,' - imagedata: ',$imagedata))"/-->
																<xsl:variable name="created" select="myutils:writeFile(string($imagepathname),string($imagedata),true(),false(),'BINARY')"/>
																<xsl:variable name="d" select="locjs:store_Value(3,'1')"/><!-- set to 'image file created' -->
																<xsl:if test="$created = false"><!-- if image file could not be created reset the source path -->
																	<xsl:variable name="d1" select="locjs:message(concat('### ERROR creating image file: ',$imagepathname))"/>
																	<xsl:variable name="d2" select="locjs:store_Value(1,'')"/><!-- reset source_imagepathname to 'error' -->
																	<xsl:variable name="d3" select="locjs:store_Value(2,'')"/><!-- reset target_imagename to 'error' -->
																	<xsl:variable name="d" select="locjs:store_Value(3,'0')"/><!-- set to 'image file NOT created' -->
																</xsl:if>
																<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
																	<xsl:variable name="d" select="locjs:message(concat('######## image file created: ',$imagepathname, ' : ', $created))"/>
																</xsl:if>
															</xsl:when>
															<xsl:otherwise>
																	<xsl:variable name="d" select="locjs:store_Value(3,'0')"/><!-- set to 'image file NOT created' -->
															</xsl:otherwise>
														</xsl:choose>
													</xsl:when>
													<xsl:otherwise><!-- impossible to create image -->
															<xsl:variable name="d1" select="locjs:store_Value(1,'')"/><!-- reset source_imagepathname to 'error' -->
															<xsl:variable name="d2" select="locjs:store_Value(2,'')"/><!-- reset target_imagename to 'error' -->
													</xsl:otherwise>
												</xsl:choose>
											</xsl:if>
				
											<xsl:variable name="source_imagename" select="locjs:restore_Value(0)"/>
											<xsl:variable name="source_imagepathname" select="locjs:restore_Value(1)"/>
											<xsl:variable name="source_image_exists">
												<xsl:choose>
													<xsl:when test="$original_image_file_exists = 'true'">1</xsl:when><!-- source image as file available -->
													<xsl:when test="locjs:restore_Value(3) = '1'"></xsl:when><!-- created from internal -->
													<xsl:otherwise>0</xsl:otherwise><!-- no source image available -->
												</xsl:choose>
											</xsl:variable>
				
											<!-- evtl. copy original image files to output folder (for fulltext extract) -->
											<xsl:variable name="d2" select="locjs:store_Value(4,'')"/><!-- init this value -->
											<xsl:variable name="originalCopied">
												<xsl:if test="($imageCopyToOutput != '0') and ($source_image_exists != '0') and ($source_imagename != '')">
													<xsl:choose>
														<!-- copy web formats only -->
														<xsl:when test="$imageCopyToOutput = '2'">
															<xsl:if test="contains(locjs:to_lower_case(string($source_imagename)),'.pdf') or contains(locjs:to_lower_case(string($source_imagename)),'.jpg') or contains(locjs:to_lower_case(string($source_imagename)),'.gif') or contains(locjs:to_lower_case(string($source_imagename)),'.png')">
																<xsl:variable name="d" select="myutils:copyFile(string($INPUT_PATH),string($source_imagename),string($the_OUTPUT_PATH),string($source_imagename),1,false)"/>
																<xsl:value-of select="1"/>
															</xsl:if>
														</xsl:when>
														<!-- copy all -->
														<xsl:otherwise>
															<xsl:variable name="d" select="myutils:copyFile(string($INPUT_PATH),string($source_imagename),string($the_OUTPUT_PATH),string($source_imagename),1,false)"/>
															<xsl:value-of select="1"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:if>
											</xsl:variable>
											<xsl:variable name="d2" select="locjs:store_Value(4,string($originalCopied))"/><!-- store this value -->
	
	
											<xsl:variable name="d" select="locjs:reset_more_images()"/>
											<xsl:choose>
												<xsl:when test="($imageMissingCreateFromPagePreview = '2') or (($imageMissingCreateFromPagePreview = '1') and $source_image_exists = '0')">
																											<!-- 	1 (default) to extract images from screen page (image box ectracted by InDesignscript)
																													2 to always create from screen page (image box ectracted by InDesign script)
																													the target image should already be in the in folder. we will copy it simply to the out folder -->
													<xsl:variable name="exists" select="locjs:fileExists(concat($INPUT_PATH,$target_imagename))"/>
													<xsl:choose>
														<xsl:when test="$exists = false()">
															<xsl:variable name="m">&#10;      ### Image missing from page preview: '<xsl:value-of select="concat($INPUT_PATH,$target_imagename)"/>'</xsl:variable>
															<xsl:variable name="d" select="myutils:showMess(string($m),'1')"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:variable name="m1">&#10;      - Image copy from page preview: '<xsl:value-of select="$target_imagename"/>': </xsl:variable>
															<xsl:variable name="d" select="myutils:showMess(string($m1),'1')"/>
															<xsl:variable name="d" select="myutils:copyFile(string($INPUT_PATH),string($target_imagename),string($the_OUTPUT_PATH),string($target_imagename),1,false)"/>
															<xsl:variable name="exists" select="locjs:fileExists(concat($the_OUTPUT_PATH,$target_imagename))"/>
															<xsl:variable name="m1"><xsl:choose><xsl:when test="$exists='true'">OK</xsl:when><xsl:otherwise>### ERROR copying to out folder: '<xsl:value-of select="$the_OUTPUT_PATH"/>'</xsl:otherwise></xsl:choose></xsl:variable>
															<xsl:variable name="d" select="myutils:showMess(string($m1),'1')"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:when>
												<xsl:when test="($imageMissingCreateFromPagePreview = '4') 
																or (($imageMissingCreateFromPagePreview = '3') and ($source_image_exists = '0'))">
																											<!-- 	3 to extract images from page preview JPEG if original image file is missing (extrtacted/cut by transformer)
																													4 to always create from page preview (extrtacted/cut by transformer) -->
													<xsl:variable name="dpiF" select="number($pageJPEGdpi div 72)"/>
													<!--
													<xsl:variable name="d" select="locjs:message(concat('+++++++++++++++',$target_imagename))"/>
													<xsl:variable name="d" select="locjs:message(concat('dpiF: ',$dpiF))"/>
													-->
													<xsl:variable name="curPageSequence"><!-- only set for anchored images -->
														<xsl:if test="$imagepagearea != ''"><!-- from an anchored image: imagepagearea="114.35633477639,64.4881889756142,282.907154448521,225.012779139549,px,1" -->
															<xsl:variable name="pagename" select="locjs:store_imagepagearea(string($imagepagearea))"/>
															<!--xsl:variable name="d" select="locjs:message(concat('    ++ pagename from imagepagearea: ',$pagename))"/-->
															<xsl:value-of select="locjs:get_pagesequence_from_page_name(string($pagename))"/>
														</xsl:if>
													</xsl:variable>
													<!--
													<xsl:variable name="d" select="locjs:message(concat('imagepagearea: ',$imagepagearea))"/>
													<xsl:variable name="d" select="locjs:message(concat('curPageSequence: ',$curPageSequence))"/>
													<xsl:variable name="d" select="locjs:message(concat('pagename: ',locjs:get_pageCoord_from_imagepagearea('pname')))"/>
													-->
													<xsl:variable name="curPageJPEGname">
														<xsl:choose>
															<xsl:when test="locjs:getPageJPEGname() != ''">
																<xsl:value-of select="locjs:getPageJPEGname()"/>
															</xsl:when>
															<xsl:when test="$imagepagearea != ''"><!-- from an anchored image: imagepagearea="114.35633477639,64.4881889756142,282.907154448521,225.012779139549,px,1" -->
																<xsl:value-of select="concat($docname,locjs:get_jpeg_page_num2(string($curPageSequence)),'.jpg')"/>
															</xsl:when>
														</xsl:choose>
													</xsl:variable>
													<!--xsl:variable name="d" select="locjs:message(concat('curPageJPEGname: ',$curPageJPEGname))"/-->
													<xsl:variable name="px1">
														<xsl:choose>
															<xsl:when test="$imagepagearea != ''"><!-- for an anchored image -->
																<xsl:value-of select="ceiling(locjs:get_pageCoord_from_imagepagearea('x1')*$dpiF)"/>
															</xsl:when>
															<xsl:otherwise><xsl:value-of select="ceiling(number($x1)*$dpiF)"/></xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<xsl:variable name="py1">
														<xsl:choose>
															<xsl:when test="$imagepagearea != ''"><!-- for an anchored image -->
																<xsl:value-of select="ceiling(locjs:get_pageCoord_from_imagepagearea('y1')*$dpiF)"/>
															</xsl:when>
															<xsl:otherwise><xsl:value-of select="ceiling(number($y1)*$dpiF)"/></xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<xsl:variable name="px2">
														<xsl:choose>
															<xsl:when test="$imagepagearea != ''"><!-- for an anchored image -->
																<xsl:value-of select="ceiling(locjs:get_pageCoord_from_imagepagearea('x2')*$dpiF)"/>
															</xsl:when>
															<xsl:otherwise><xsl:value-of select="ceiling(number($x2)*$dpiF)"/></xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<xsl:variable name="py2">
														<xsl:choose>
															<xsl:when test="$imagepagearea != ''"><!-- for an anchored image -->
																<xsl:value-of select="ceiling(locjs:get_pageCoord_from_imagepagearea('y2')*$dpiF)"/>
															</xsl:when>
															<xsl:otherwise><xsl:value-of select="ceiling(number($y2)*$dpiF)"/></xsl:otherwise>
														</xsl:choose>
													</xsl:variable>

													<xsl:choose>
														<xsl:when test="$curPageJPEGname != ''">
															<xsl:variable name="m1">&#10;      - Image from page preview: '<xsl:value-of select="$curPageJPEGname"/>' to '<xsl:value-of select="$target_imagename"/> (<xsl:value-of select="$px1"/>,<xsl:value-of select="$py1"/>,<xsl:value-of select="$px2"/>,<xsl:value-of select="$py2"/>)': </xsl:variable>
															<xsl:variable name="d" select="myutils:showMess(string($m1),'1')"/>
															<xsl:variable name="targPathName" select="concat($the_OUTPUT_PATH,$target_imagename)"/>
		
															<!--                public int cutSubJPGImage ( String infilePathName, int x, int y, int w, int h, int density, float quality, double scale, double dpiscale, String outfilePathName, int overwriteexisting) -->
															<xsl:variable name="err" select="myJpgImage:cutSubJPGImage(concat($INPUT_PATH,$curPageJPEGname),number($px1),number($py1),floor(number($px2)-number($px1)),floor(number($py2)-number($py1)),number($pageJPEGdpi),1.0,number(locjs:get_imageScale()),number($dpiF),string($targPathName),number($imageOverwriteTargetIfExists))"/>
															<xsl:variable name="exists" select="locjs:fileExists(string($targPathName))"/>
															<xsl:variable name="m1"><xsl:choose><xsl:when test="$exists='true'">OK</xsl:when><xsl:otherwise>### ERROR: <xsl:value-of select="$err"/> on image extract from: <xsl:value-of select="concat($the_OUTPUT_PATH,$curPageJPEGname)"/></xsl:otherwise></xsl:choose></xsl:variable>
															<xsl:variable name="d" select="myutils:showMess(string($m1),'1')"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:variable name="m1">&#10;      ### ERROR missing anchored image '<xsl:value-of select="$source_imagename"/>' can not be extracted from page preview: '<xsl:value-of select="$curPageJPEGname"/>' to target '<xsl:value-of select="$target_imagename"/>'</xsl:variable>
															<xsl:variable name="d" select="myutils:showMess(string($m1),'1')"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:when>
												<xsl:when test="$source_image_exists = '0'"><!-- missing image -->
													<xsl:variable name="no_ext_image">
														<xsl:choose>
															<xsl:when test="not(Image/Link) and not(EPS/clnk) and not(PICT/Link) and not(PDF/Link) and not(ImportedPage/Link) and not(WMF/Link)"> ## no external image file available!</xsl:when>
														</xsl:choose>
													</xsl:variable>
													<xsl:variable name="m">&#10;### Image missing: '<xsl:value-of select="$source_imagename"/>'<xsl:value-of select="$no_ext_image"/></xsl:variable>
													<xsl:variable name="d" select="myutils:showMess(string($m),'1')"/>
													<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
														<xsl:variable name="d" select="locjs:message(concat('### Image missing: ',$source_imagename))"/>
													</xsl:if>
												</xsl:when>
												<xsl:when test="$source_imagename != ''"><!-- if it exist, convert it -->
													<!-- convert image to JPEG -->
													<xsl:variable name="src_imagename" select="locjs:restore_Value(0)"/>
													<!--xsl:variable name="d" select="locjs:message(concat('ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ src_imagename: ', $src_imagename))"/-->
	
													<xsl:variable name="dummy" select="myutils:clear_last_fileBynaryReplace_file()"/>
	
													<xsl:variable name="src_is_pdf">
														<xsl:choose>
															<xsl:when test="(contains(locjs:to_lower_case(string($source_imagepathname)),'.pdf') = 'true') or (contains(locjs:to_lower_case(string($source_imagepathname)),'.ai') = 'true')">1</xsl:when>
															<xsl:otherwise>0</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<!--xsl:variable name="d" select="locjs:message(concat('ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ src_is_pdf: ', $src_is_pdf))"/-->
	
													<xsl:variable name="hasCropBox">
														<xsl:choose>
															<xsl:when test="contains($PDFnoBoxCropping,'1')">-1</xsl:when>
															<xsl:when test="$PDFhasCropBox = '1'">1</xsl:when>
															<xsl:when test="$src_is_pdf &lt;= 0">-1</xsl:when><!-- non PDF images -->
															<xsl:when test="$cropboxMode = '0'">-1</xsl:when>
															<xsl:when test="contains($cropboxMode,'1')"><xsl:value-of select="myutils:detectFileContent(string($source_imagepathname),'CropBox',0)"/></xsl:when><!-- returns position of found string. otherwise -1 -->
															<xsl:otherwise>-1</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<!--xsl:variable name="d" select="locjs:message(concat('ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ hasCropBox: ', $hasCropBox))"/-->
	
													<xsl:variable name="hasTrimBox">
														<xsl:choose>
															<xsl:when test="contains($PDFnoBoxCropping,'2')">-1</xsl:when>
															<xsl:when test="$PDFhasTrimBox = '1'">1</xsl:when>
															<xsl:when test="$src_is_pdf &lt;= 0">-1</xsl:when><!-- non PDF images -->
															<xsl:when test="$cropboxMode = '0'">-1</xsl:when>
															<xsl:when test="number($hasCropBox) &gt;= 0">-1</xsl:when><!-- use CropBox if available -->
															<xsl:when test="contains($cropboxMode,'1')"><xsl:value-of select="myutils:detectFileContent(string($source_imagepathname),'TrimBox',0)"/></xsl:when><!-- returns position of found string. otherwise -1 -->
															<xsl:otherwise>-1</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<!--xsl:variable name="d" select="locjs:message(concat('ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ hasTrimBox: ', $hasTrimBox))"/-->
	
													<xsl:variable name="replacedArtBox">
														<xsl:choose>
															<xsl:when test="($src_is_pdf != '0') and contains($cropboxMode,'1') and (number($hasCropBox) &lt; 0) and (number($hasTrimBox) &lt; 0)"><!-- is a pdf with no cropbox: try to replace the artbox with cropbox -->
																<xsl:value-of select="myutils:fileBynaryReplace(string($source_imagepathname),'','ArtBox','CropBox')"/><!-- returns 0 if could be replaced - otherwise negative number -->
															</xsl:when>
															<xsl:otherwise>-1</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<!--xsl:variable name="d" select="locjs:message(concat('ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ replacedArtBox: ', $replacedArtBox))"/-->
	
													<xsl:variable name="source">
														<xsl:choose>
															<xsl:when test="($src_is_pdf != '0') and contains($cropboxMode,'1') and (number($hasCropBox) &lt; 0) and (number($hasTrimBox) &lt; 0)"><!-- is a pdf with no cropbox and no trimbox: try to replace the artbox with cropbox -->
																	<!--xsl:variable name="d" select="locjs:message(concat('ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ cropboxMode:', $cropboxMode,', src_is_pdf:', $src_is_pdf,', hasCropBox: ', $hasCropBox))"/-->
																	<!--xsl:variable name="d" select="locjs:message(concat('ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ source_imagepathname:', $source_imagepathname))"/-->
																<xsl:choose>
																	<xsl:when test="$replacedArtBox = 0"><xsl:value-of select="concat(myutils:getname_last_fileBynaryReplace_file(),$source_image_layer)"/></xsl:when>
																	<xsl:otherwise><xsl:value-of select="concat($source_imagepathname,$source_image_layer)"/></xsl:otherwise>
																</xsl:choose>
																	<!--xsl:variable name="d" select="locjs:message(concat('ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ source_imagepathname: ', $source_imagepathname))"/-->
																	<!--xsl:variable name="d" select="locjs:message(concat('ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ getname_last_fileBynaryReplace_file: ', myutils:getname_last_fileBynaryReplace_file()))"/-->
															</xsl:when>
															<xsl:otherwise><xsl:value-of select="concat($source_imagepathname,$source_image_layer)"/></xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
				
													<xsl:variable name="target"><xsl:value-of select="$the_OUTPUT_PATH"/><xsl:value-of select="locjs:restore_Value(2)"/></xsl:variable>
	
													<!-- determine input image format -->
													<xsl:variable name="inputImageFormat">
														<xsl:value-of select="locjs:get_imagename_extension(string($source))"/>
													</xsl:variable>
													<!-- determine output image format -->
													<xsl:variable name="outputImageFormat">
														<xsl:value-of select="locjs:get_imagename_extension(string($target))"/>
													</xsl:variable>
													<!-- determine the canvas format string -->
													<xsl:variable name="useImageInputParam">
														<xsl:value-of select="locjs:get_imageInputParam(string($inputImageFormat),string($outputImageFormat))"/>
													</xsl:variable>
	
													<xsl:variable name="DoAddCropBox"><!-- should we add a -crop command for ImageMagick? -->
														<xsl:choose>
															<xsl:when test="$src_is_pdf != '0'"><!-- for PDFs -->
																<xsl:choose>
																	<xsl:when test="$cropboxMode = '0'">0</xsl:when>
																	<xsl:when test="contains($cropboxMode,'4')">1</xsl:when>
																	<xsl:otherwise>0</xsl:otherwise>
																</xsl:choose>
															</xsl:when>
															<xsl:otherwise>1</xsl:otherwise><!-- all other images -->
														</xsl:choose>
													</xsl:variable>


													<!-- verbose debug? -->
													<xsl:variable name="verbose_debug">
														<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">-verbose</xsl:if>
													</xsl:variable>

													<!-- canvas size -->
													<xsl:variable name="page_param">
													</xsl:variable>

													<!-- the colorspace or color profile to use -->
													<xsl:variable name="theColorProfileINPUTParm">
														<xsl:choose>
															<xsl:when test="$COLORPROFILE_ignore != '0'"></xsl:when><!-- no color profile changes -->
															<xsl:when test="$COLORPROFILE = '*NONE*'"></xsl:when><!-- no profile for OUTPUT -->
															<xsl:when test="$COLORPROFILE != ''"><xsl:value-of select="$COLORPROFILE"/></xsl:when>
															<xsl:otherwise>
																<!-- AUTO DETECT: we have to check if image has embedded color profile: call 'identify' -->
																<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
																	<xsl:variable name="d" select="myutils:showMess(concat('****** Detect Image Color profile of: ',$source,'&#10;'),'1')"/>
																</xsl:if>
																<xsl:choose>
																	<xsl:when test="$ImageMagickIdentify != ''"><!-- create resized page jpeg using ImageMagick's CONVERT program if reachable -->
																		<xsl:variable name="identifyCmd">-format "class:%r"\n"profile:%[profiles]"\n"profileICC:%[profile:icc]"\n</xsl:variable>
																		<xsl:variable name="params" select="locjs:createParamString(string($identifyCmd),locjs:escapeMagick(string($source)))"/>
																		<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
																			<xsl:variable name="d" select="myutils:showMess(concat('****** Image identify: ',$ImageMagickIdentify,' ',$params,'&#10;'))"/>
																		</xsl:if>
																		<xsl:variable name="result">
																			<xsl:value-of select="myutils:callExternalApp(string($ImageMagickIdentify),$params,$ImageMagickConvertEnvir,'',$filenameConversion)"/>
																		</xsl:variable>
																		<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
																			<xsl:variable name="d" select="myutils:showMess(concat('--result: ',$result,'&#10;'),'1')"/>
																		</xsl:if>
																		<!-- get return message from IM identify -->
																		<xsl:variable name="identifyResult" select="myutils:callExternalAppGetStdoutResponse()"/>
																		<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
																			<xsl:variable name="d" select="myutils:showMess(concat('--  identifyResult: ',$identifyResult,'&#10;'),'1')"/>
																		</xsl:if>

																		<xsl:choose>
																			<!-- with two profiles: input/output -->
																			<!--
																			<xsl:when test="contains($identifyResult,'CMYK') and contains($identifyResult,'icc')">
																				<xsl:variable name="d" select="myutils:showMess(concat('&#10;      - Image is CMYK with ICC profile: ',$source),'1')"/>
																				<xsl:text>-profile </xsl:text><xsl:value-of select="$COLORPROFILES_path"/>default_cmyk.icc<xsl:text> -profile </xsl:text><xsl:value-of select="$COLORPROFILES_path"/><xsl:text>AdobeRGB1998.icc</xsl:text>
																			</xsl:when>
																			-->
																			<!-- Images with no or any icc profile contained: 
																				 Attach/override input profile with default profile 'default_cmyk.icc' and set output to -colorspace sRGB
																				 This is 50% faster than using input AND an output color profile like AdobeRGB.icc (see commented stuff abive)
																				 and gives same accurate output colors -->
																			<xsl:when test="contains($identifyResult,'CMYK')">
																				<xsl:variable name="d" select="myutils:showMess(concat('&#10;      - Image is CMYK with/without ICC profile: ',$source),'1')"/>
																				<!-- xsl:text>-profile </xsl:text><xsl:value-of select="locjs:escapeMagick(concat($COLORPROFILES_path,'default_cmyk.icc'))"/><xsl:text> -colorspace sRGB</xsl:text -->
																				<xsl:text>-profile </xsl:text><xsl:value-of select="locjs:escapeMagick(concat($COLORPROFILES_path,'default_cmyk.icc'))"/><xsl:text> -profile </xsl:text><xsl:value-of select="locjs:escapeMagick(concat($COLORPROFILES_path,'sRGB.icc'))"/><xsl:text> -colorspace sRGB</xsl:text>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:variable name="imgClass">
																					<xsl:choose>
																						<xsl:when test="contains($identifyResult,'CMYK')">CMYK</xsl:when>
																						<xsl:when test="contains($identifyResult,'sRGB')">sRGB</xsl:when>
																						<xsl:when test="contains($identifyResult,'RGB')">RGB</xsl:when>
																						<xsl:otherwise>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:variable>
																				<xsl:variable name="d" select="myutils:showMess(concat('&#10;      - Image is ',$imgClass,' without ICC profile: ',$source),'1')"/>
																				<xsl:text>-colorspace sRGB</xsl:text>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:when>
																	<xsl:otherwise>-colorspace sRGB</xsl:otherwise>
																</xsl:choose>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>

													<!-- imageFileOptions -->
													<xsl:variable name="imageFileOptions">
														<xsl:if test="starts-with($imagePARAMS,'%') = false">
															<xsl:choose>
																<xsl:when test="contains($useImageInputParam,'-flatten')"></xsl:when>
																<!-- is from internal preview? -->
																<xsl:when test="locjs:get_ImagePreview_width() != ''">
																	<!--
																	<xsl:variable name="imgwidth" select="locjs:get_ImagePreview_width()"/>
																	<xsl:variable name="imgheight" select="locjs:get_ImagePreview_height()"/>
																	<xsl:value-of select="locjs:get_page_param('',string($imgwidth),string($imgheight))"/><xsl:text> -flatten</xsl:text>
																	-->
																</xsl:when>
	
																<!-- is normal image -->
																<xsl:when test="($src_is_pdf != '0') and contains($cropboxMode,'2') and ((number($hasCropBox) &gt;= 0) or (number($replacedArtBox) &gt;= 0))">-define pdf:use-cropbox=true -flatten</xsl:when>
																<xsl:when test="($src_is_pdf != '0') and contains($cropboxMode,'2') and (number($hasTrimBox) &gt;= 0)">-define pdf:use-trimbox=true -flatten</xsl:when>
																<xsl:when test="contains(locjs:to_lower_case(string($source)),'.eps') = 'true'">-flatten</xsl:when>
																<xsl:when test="contains(locjs:to_lower_case(string($source)),'.psd') = 'true'">-flatten</xsl:when>
																<xsl:when test="contains(locjs:to_lower_case(string($source)),'.tif') = 'true'">-flatten</xsl:when>
																<xsl:when test="contains(locjs:to_lower_case(string($source)),'.wmf') = 'true'">-flatten</xsl:when>
																<!-- no ext -->
																<xsl:otherwise>-flatten</xsl:otherwise><!-- security: do all... -->
															</xsl:choose>
														</xsl:if>
													</xsl:variable>

													<xsl:variable name="resample_param">
														<xsl:choose>
															<xsl:when test="locjs:get_ImagePreview_width() != ''"></xsl:when><!-- no input resample for internal preview images -->
															<xsl:when test="contains($imagePARAMS,'-resample') = false">
																<xsl:value-of select="locjs:get_input_resample_param(string($source),string($imageNoDensityParam))"/>
															</xsl:when>
														</xsl:choose>
													</xsl:variable>
													<xsl:variable name="IMinputDPI">
														<xsl:choose>
															<!-- no desity parameter for TIFF images -->
															<xsl:when test="(locjs:endsWith(locjs:to_lower_case(string($source)),'.tif') = 'true') or (locjs:endsWith(locjs:to_lower_case(string($source)),'.tiff') = 'true')">
															</xsl:when>
															<xsl:otherwise>
																<xsl:value-of select="locjs:get_density_param()"/>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
	
													<xsl:variable name="doCrop">
														<xsl:choose>
															<xsl:when test="$inputImageFormat = 'wmf'">0</xsl:when>
															<xsl:otherwise></xsl:otherwise><!-- auto according to cropImages -->
														</xsl:choose>
													</xsl:variable>
	
													<xsl:variable name="resize_crop_param"><!-- we may manually control parameters: if they start with a % we do not auto resize the images -->
														<xsl:if test="starts-with($imagePARAMS,'%') = false">
															<xsl:value-of select="locjs:get_resize_crop_param(string(@Self),locjs:get_imag_IGeo(),locjs:get_IGeo(),locjs:get_imagInImage_IGeo(),locjs:get_original_image_Appi(),locjs:get_original_image_Eppi(),string($DoAddCropBox),string($doCrop))"/>
														</xsl:if>
													</xsl:variable>
													<xsl:variable name="myimagePARAMS" select="locjs:removePercent(string(normalize-space($imagePARAMS)))"/>
	
	
													<xsl:variable name="theIMsourceFiletypePrefix"><!-- must explicitely mark the source file name as 'Illustrator': ai:imagename.ai -->
														<xsl:choose>
															<xsl:when test="locjs:endsWith(locjs:to_lower_case(string($src_imagename)),'.ai') = 'true'">ai:</xsl:when>
															<xsl:otherwise></xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
	
													<!-- call external Image Converter 'ImageMagick' or copy preview file -->
													<xsl:variable name="imageconverted">
														<xsl:choose>
															<xsl:when test="(locjs:get_ImagePreview_width() != '') and ($imagePreviewUseOriginals != '0')"><!-- copy original preview file -->
																<xsl:variable name="d" select="locjs:store_Value(2,string($source_imagename))"/><!-- our created target file name is the source file -->
																<xsl:variable name="m1">&#10;      - Image Preview copy: '<xsl:value-of select="$src_imagename"/>' to output folder: </xsl:variable>
																<xsl:variable name="d" select="myutils:showMess(string($m1),'1')"/>
																<xsl:variable name="d" select="myutils:copyFile(string($INPUT_PATH),string($source_imagename),string($the_OUTPUT_PATH),string($source_imagename),1,false)"/>
																<xsl:value-of select="number('0')"/>
															</xsl:when>
															<xsl:otherwise><!-- convert the source image -->
																<xsl:variable name="params" select="locjs:createParamString(string($verbose_debug),string($page_param),string($theColorProfileINPUTParm),string($useImageInputParam),string($imageFileOptions),locjs:escapeMagick(concat($theIMsourceFiletypePrefix,$source)),string($resample_param),string($resize_crop_param),string($IMquality),string($myimagePARAMS),string($imageOutputFinishParam),locjs:escapeMagick(string($target)))"/>
	
																<xsl:variable name="m1">&#10;      - Image convert: '<xsl:value-of select="concat($theIMsourceFiletypePrefix,$src_imagename)"/>' to '<xsl:value-of select="locjs:restore_Value(2)"/>': </xsl:variable>
																<xsl:variable name="d" select="myutils:showMess(string($m1),'1')"/>
																<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
																	<xsl:variable name="d" select="myutils:showMess(concat('&#10;--source: ',$source,'&#10;'))"/>
																	<xsl:variable name="d" select="myutils:showMess(concat('--params: ',$params,'&#10;'))"/>
																	<xsl:variable name="d" select="myutils:showMess(concat('****** image: ',$ImageMagickConvert,' ',$params))"/>
																</xsl:if>
	
																<xsl:value-of select="myutils:callExternalApp(string($ImageMagickConvert),string($params),string($ImageMagickConvertEnvir),'',string($filenameConversion))"/>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
				
													<xsl:variable name="m2"><xsl:choose><xsl:when test="$imageconverted=0">OK</xsl:when><xsl:otherwise>### ERROR: <xsl:value-of select="$imageconverted"/></xsl:otherwise></xsl:choose></xsl:variable>
													<xsl:variable name="d2" select="myutils:showMess(string($m2),'1')"/>
													<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
														<xsl:variable name="d" select="locjs:message(concat('   *** convert image: ',$imageconverted))"/>
													</xsl:if>
				
													<!-- check if we have to create more images -->
													<xsl:variable name="d" select="locjs:reset_more_images()"/>
													<xsl:if test="($imagesMORE != '') and ($source_image_exists != '0')"><!-- need a second from non missing image -->
														<xsl:call-template name="create_more_images">
															<xsl:with-param name="self"><xsl:value-of select="@Self"/></xsl:with-param>
															<xsl:with-param name="imagesMORE"><xsl:value-of select="$imagesMORE"/></xsl:with-param>
															<xsl:with-param name="ImageMagickConvert"><xsl:value-of select="$ImageMagickConvert"/></xsl:with-param>
															<xsl:with-param name="ImageMagickConvertEnvir"><xsl:value-of select="$ImageMagickConvertEnvir"/></xsl:with-param>
															<xsl:with-param name="filenameConversion"><xsl:value-of select="$filenameConversion"/></xsl:with-param>
				
															<xsl:with-param name="verbose_debug"><xsl:value-of select="$verbose_debug"/></xsl:with-param>
															<xsl:with-param name="page_param"><xsl:value-of select="$page_param"/></xsl:with-param>
															<xsl:with-param name="theColorProfileINPUTParm"><xsl:value-of select="$theColorProfileINPUTParm"/></xsl:with-param>
															<xsl:with-param name="useImageInputParam"><xsl:value-of select="$useImageInputParam"/></xsl:with-param>
															<xsl:with-param name="imageFileOptions"><xsl:value-of select="$imageFileOptions"/></xsl:with-param>
															<xsl:with-param name="source"><xsl:value-of select="locjs:escapeMagick(string($source))"/></xsl:with-param>
															<xsl:with-param name="resample_param"><xsl:value-of select="$resample_param"/></xsl:with-param>
															<xsl:with-param name="IMquality"><xsl:value-of select="$IMquality"/></xsl:with-param>
															<xsl:with-param name="myimagePARAMS"><xsl:value-of select="$myimagePARAMS"/></xsl:with-param>
															<xsl:with-param name="imageOutputFinishParam"><xsl:value-of select="$imageOutputFinishParam"/></xsl:with-param>
															<xsl:with-param name="target"><xsl:value-of select="$target"/></xsl:with-param>
															<xsl:with-param name="DoAddCropBox"><xsl:value-of select="$DoAddCropBox"/></xsl:with-param>
															<xsl:with-param name="theIMsourceFiletypePrefix"><xsl:value-of select="$theIMsourceFiletypePrefix"/></xsl:with-param>
														</xsl:call-template>
													</xsl:if>
				
													<!-- must be after all images are created -->
													<xsl:variable name="dummy" select="myutils:delete_last_fileBynaryReplace_file()"/>
				
												</xsl:when>
											</xsl:choose>
										</xsl:if>
			
										<!-- check if target image exists -->
										<xsl:variable name="target"><xsl:value-of select="$the_OUTPUT_PATH"/><xsl:value-of select="locjs:restore_Value(2)"/></xsl:variable>
										<xsl:variable name="exists" select="locjs:fileExists(string($target))"/>

                    <!-- *********************************** -->
                    <!-- if we can not reach ImageMagick, check if pre-exported images are stated in the label attribute -->
                    <!-- this is a label content like: ##imgnameorig:28_01zimbabwe.eps##imgname1:28_01zimbabwe.jpg/width/height##imgname2:28_01zimbabwe_2.0.jpg/width/height## -->
                    <xsl:if test="$ImageMagickConvert = ''">
					            <xsl:variable name="d" select="myutils:showMess(concat('&#10;      -- Pre-converted images: ',$label),'1')"/>
				              <xsl:variable name="d" select="locjs:store_splitlabel(string($label))" /><!-- store label -->

                      <!-- get first exported image filename -->
							        <xsl:variable name="imgname1label" select="locjs:get_splitlabel('imgname1:')" />
										  <xsl:if test="$imgname1label != ''">
										    <xsl:variable name="imgname1" select="locjs:get_labelvalue(string($imgname1label),0)" />
										    <xsl:variable name="imgwidth1" select="locjs:get_labelvalue(string($imgname1label),1)" />
										    <xsl:variable name="imgheight1" select="locjs:get_labelvalue(string($imgname1label),2)" />
										    <xsl:variable name="imgname1_exists" select="locjs:fileExists(concat($INPUT_PATH,$imgname1))"/>
										    <xsl:if test="$imgname1_exists=true()">
					                <xsl:variable name="d" select="myutils:showMess(concat('&#10;      --- Copy primary image (',$imgwidth1,'x',$imgheight1,'): ',$imgname1,' to ',$the_OUTPUT_PATH),'1')"/>
					                <xsl:variable name="d" select="myutils:copyFile(string($INPUT_PATH),string($imgname1),string($the_OUTPUT_PATH),'',1,false)"/>
										    </xsl:if>
										  </xsl:if>

                      <!-- evtl. get second exported image filename -->
											<xsl:variable name="d" select="locjs:reset_more_images()"/>
							        <xsl:variable name="imgname2label" select="locjs:get_splitlabel('imgname2:')" />
										  <xsl:if test="$imgname2label != ''">
										    <xsl:variable name="imgname2" select="locjs:get_labelvalue(string($imgname2label),0)" />
										    <xsl:variable name="imgwidth2" select="locjs:get_labelvalue(string($imgname2label),1)" />
										    <xsl:variable name="imgheight2" select="locjs:get_labelvalue(string($imgname2label),2)" />
										    <xsl:variable name="imgname2_exists" select="locjs:fileExists(concat($INPUT_PATH,$imgname2))"/>
										    <xsl:if test="$imgname2_exists=true()">
					                <xsl:variable name="d" select="myutils:showMess(concat('&#10;      --- Copy secondary image (',$imgwidth2,'x',$imgheight2,'): ',$imgname2,' to ',$the_OUTPUT_PATH),'1')"/>
					                <xsl:variable name="d" select="myutils:copyFile(string($INPUT_PATH),string($imgname2),string($the_OUTPUT_PATH),'',1,false)"/>
		                      <xsl:variable name="d" select="locjs:store_more_images(string($imgname2))"/>
										    </xsl:if>
										  </xsl:if>
                    </xsl:if>

										<xsl:variable name="contentlabel">
											<xsl:choose>
												<xsl:when test="Image/Properties/Label/KeyValuePair[@Key = 'Label']/@Value/."><xsl:value-of select="locjs:get_thislabel(string(Image/Properties/Label/KeyValuePair[@Key = 'Label']/@Value/.))"/></xsl:when>
												<xsl:when test="PICT/Properties/Label/KeyValuePair[@Key = 'Label']/@Value/."><xsl:value-of select="locjs:get_thislabel(string(PICT/Properties/Label/KeyValuePair[@Key = 'Label']/@Value/.))"/></xsl:when>
												<xsl:when test="EPS/Properties/Label/KeyValuePair[@Key = 'Label']/@Value/."><xsl:value-of select="locjs:get_thislabel(string(EPS/Properties/Label/KeyValuePair[@Key = 'Label']/@Value/.))"/></xsl:when>
												<xsl:when test="PDF/Properties/Label/KeyValuePair[@Key = 'Label']/@Value/."><xsl:value-of select="locjs:get_thislabel(string(PDF/Properties/Label/KeyValuePair[@Key = 'Label']/@Value/.))"/></xsl:when>
												<xsl:when test="ImportedPage/Properties/Label/KeyValuePair[@Key = 'Label']/@Value/."><xsl:value-of select="locjs:get_thislabel(string(ImportedPage/Properties/Label/KeyValuePair[@Key = 'Label']/@Value/.))"/></xsl:when>
												<xsl:when test="WMF/Properties/Label/KeyValuePair[@Key = 'Label']/@Value/."><xsl:value-of select="locjs:get_thislabel(string(WMF/Properties/Label/KeyValuePair[@Key = 'Label']/@Value/.))"/></xsl:when>
											</xsl:choose>
										</xsl:variable>
										<xsl:variable name="imagefileexists">
											<xsl:choose>
												<!-- existing image -->
												<xsl:when test="$exists='true'">1</xsl:when>
												<xsl:otherwise>0</xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
										<!-- xsl:variable name="d" select="locjs:message(concat('   *** image: ',locjs:restore_Value(0),' - ',$imagefileexists))"/-->
										<xsl:call-template name="get_image">
											<xsl:with-param name="exist"><xsl:value-of select="$imagefileexists"/></xsl:with-param>
											<xsl:with-param name="anchorID"><xsl:value-of select="$anchorID"/></xsl:with-param>
											<xsl:with-param name="groupid"><xsl:value-of select="$groupid"/></xsl:with-param>
											<xsl:with-param name="self"><xsl:value-of select="@Self"/></xsl:with-param>
											<xsl:with-param name="src_imagename"><xsl:value-of select="locjs:restore_Value(0)"/></xsl:with-param>
											<xsl:with-param name="src_imagename_orig"><xsl:value-of select="$source_imagename_orig"/></xsl:with-param>
											<xsl:with-param name="source_imagepathname"><xsl:value-of select="$source_imagepathname"/></xsl:with-param>
											<xsl:with-param name="target_imagename"><xsl:value-of select="locjs:restore_Value(2)"/></xsl:with-param>
											<xsl:with-param name="contentlabel"><xsl:value-of select="$contentlabel"/></xsl:with-param>
											<xsl:with-param name="label"><xsl:value-of select="$label"/></xsl:with-param>
											<xsl:with-param name="originalCopied"><xsl:value-of select="locjs:restore_Value(4)"/></xsl:with-param>
											<xsl:with-param name="isemptyimagebox">0</xsl:with-param>
											<xsl:with-param name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:with-param>
											<xsl:with-param name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:with-param>
											<xsl:with-param name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:with-param>
										</xsl:call-template>
									</xsl:if>
								</xsl:if>
	
								<xsl:if test="$anchorID = ''">
									<area><!-- get box area -->
										<xsl:attribute name="name">A<xsl:value-of select="@Self"/>_<xsl:value-of select="$page_sequence"/></xsl:attribute><!-- need name attr for Netscape -->
										<xsl:if test="locjs:get_current_box_name() = 'imag'">
											<xsl:attribute name="alt"><xsl:value-of select="locjs:get_src_imagename()"/></xsl:attribute>
										</xsl:if>
										<xsl:attribute name="shape">rect</xsl:attribute>
										<xsl:attribute name="coords"><xsl:value-of select="$coords"/></xsl:attribute>
										<xsl:attribute name="x1"><xsl:value-of select="$x1"/></xsl:attribute>
										<xsl:attribute name="y1"><xsl:value-of select="$y1"/></xsl:attribute>
										<xsl:attribute name="x2"><xsl:value-of select="$x2"/></xsl:attribute>
										<xsl:attribute name="y2"><xsl:value-of select="$y2"/></xsl:attribute>
									</area>
								</xsl:if>
							</box>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
	
			</xsl:if>
		</xsl:if>
	</xsl:template>


	<!-- ===============================================
		 copy media files
	     =============================================== -->
	<xsl:template name="copy_media_files">
		<xsl:param name="recall"/>
		<xsl:param name="mediatype"/>
		<xsl:param name="inpath"/>
		<xsl:param name="outpath"/>
		<xsl:param name="primarymedia"/>
		<xsl:param name="alternatemedia"/><!-- first recall == 0 : the entire  @label: ##movieprimary:Mini.mov##moviealternate:Mini.ogv[,moremovies.xxx]
											following recall > 0 : a comma separated list of alternate media files -->

		<xsl:choose>
			<xsl:when test="$recall = 0"><!-- first call: we copy the main media file -->
				<xsl:variable name="d" select="locjs:store_splitlabel(string($alternatemedia))" /><!-- store alternate media files from @label -->
				
				<xsl:variable name="primarymediafile">
					<xsl:choose>
						<xsl:when test="($mediatype='video') and (locjs:get_splitlabel('movieprimary:') != '')"><!-- stated in label has priority over $primarymedia -->
							<xsl:variable name="primparts" select="locjs:get_splitlabel('movieprimary:')" /><!-- can be filename;mimetype -->
							<xsl:choose>
								<xsl:when test="contains($primparts,';')">
									<xsl:value-of select="substring-before($primparts,';')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$primparts"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="($mediatype='sound') and (locjs:get_splitlabel('soundprimary:') != '')">
							<xsl:variable name="primparts" select="locjs:get_splitlabel('soundprimary:')" /><!-- can be filename;mimetype -->
							<xsl:choose>
								<xsl:when test="contains($primparts,';')">
									<xsl:value-of select="substring-before($primparts,';')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$primparts"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$primarymedia" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<xsl:if test="$primarymediafile != ''">
					<xsl:variable name="d" select="myutils:showMess(concat('&#10;      -- Copy primary media file: ',$primarymediafile,' to ',$outpath),'1')"/>
					<xsl:variable name="d" select="myutils:copyFile(string($inpath),string($primarymediafile),string($outpath),'',1,false)"/>
				</xsl:if>

				<xsl:variable name="have_alternate_media"><!-- get the comma separated list of alternate media files -->
					<xsl:choose>
						<xsl:when test="$mediatype='video'">
							<xsl:value-of select="locjs:get_splitlabel('moviealternate:')" />
						</xsl:when>
						<xsl:when test="$mediatype='sound'">
							<xsl:value-of select="locjs:get_splitlabel('soundalternate:')" />
						</xsl:when>
					</xsl:choose>
				</xsl:variable>
				
				<xsl:if test="$have_alternate_media">
					<!-- recall us to copy alternate media files -->
					<xsl:call-template name="copy_media_files">
						<xsl:with-param name="recall">1</xsl:with-param>
						<xsl:with-param name="mediatype"><xsl:value-of select="$mediatype"/></xsl:with-param>
						<xsl:with-param name="inpath"><xsl:value-of select="$inpath"/></xsl:with-param>
						<xsl:with-param name="outpath"><xsl:value-of select="$outpath"/></xsl:with-param>
						<xsl:with-param name="primarymedia"></xsl:with-param>
						<xsl:with-param name="alternatemedia"><xsl:value-of select="$have_alternate_media"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:when>

			<xsl:otherwise><!-- following call: we copy the alternate media file(s) -->
				<xsl:if test="$recall = 1"><!-- first call for alternate media files: store comma separated list of alternate media files from recall==0 call -->
					<xsl:variable name="d" select="locjs:store_splitvalue(string($alternatemedia))" />
				</xsl:if>

				<xsl:if test="locjs:have_splitvalue() = true()"><!-- have media files? -->
					<xsl:variable name="alternatemediafile">
						<xsl:variable name="altparts" select="locjs:get_splitvalue()" /><!-- can be filename;mimetype -->
						<xsl:choose>
							<xsl:when test="contains($altparts,';')">
								<xsl:value-of select="substring-before($altparts,';')"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$altparts"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>

					<xsl:if test="$alternatemediafile != ''">
						<xsl:variable name="d" select="myutils:showMess(concat('&#10;      -- Copy alternate media file #',$recall,': ',$alternatemediafile,' to ',$outpath),'1')"/>
						<xsl:variable name="d" select="myutils:copyFile(string($inpath),string($alternatemediafile),string($outpath),'',1,false)"/>
					</xsl:if>
				
					<xsl:if test="locjs:have_splitvalue() = true()"><!-- have more media files? -->
						<xsl:call-template name="copy_media_files">
							<xsl:with-param name="recall"><xsl:value-of select="number($recall+1)"/></xsl:with-param>
							<xsl:with-param name="mediatype"><xsl:value-of select="$mediatype"/></xsl:with-param>
							<xsl:with-param name="inpath"><xsl:value-of select="$inpath"/></xsl:with-param>
							<xsl:with-param name="outpath"><xsl:value-of select="$outpath"/></xsl:with-param>
							<xsl:with-param name="primarymedia"></xsl:with-param>
							<xsl:with-param name="alternatemedia"><xsl:value-of select="$alternatemedia"/></xsl:with-param>
						</xsl:call-template>
					</xsl:if>
				</xsl:if>
			</xsl:otherwise>


		</xsl:choose>

	</xsl:template>


	<!-- ===============================================
		 get all chained boxes
	     =============================================== -->
	<xsl:template name="get_chained_boxes">
		<xsl:param name="cont"/>
		<xsl:param name="itxf"/>
		<xsl:param name="ftxf"/>
		<xsl:param name="ntxf"/>
		<xsl:param name="groupid"/>
		<xsl:param name="textflow_id"/>
		<xsl:param name="spread_num"/>
		<xsl:param name="spread_self"/>
		<xsl:param name="page_self"/><!-- the page Self ID -->
		<xsl:param name="page"/>
		<xsl:param name="page_sequence"/>
		<xsl:param name="page_name"/>
		<xsl:param name="pageside"/>
		<xsl:param name="maxwidth"/>
		<xsl:param name="maxheight"/>
		<!-- collect all chained boxes -->
		<xsl:variable name="boxchain">
			<boxesinchain>
			<xsl:call-template name="get_next_box_in_chain">
				<xsl:with-param name="cont" select="$cont"/>
				<xsl:with-param name="itxf" select="$itxf"/>
				<xsl:with-param name="ftxf" select="$ftxf"/>
				<xsl:with-param name="ntxf" select="$ntxf"/>
				<xsl:with-param name="groupid" select="$groupid"/>
				<xsl:with-param name="textflow_id" select="$textflow_id"/>
				<xsl:with-param name="spread_num" select="$spread_num"/>
				<xsl:with-param name="spread_self" select="$spread_self"/>
				<xsl:with-param name="page_self" select="$page_self"/>
				<xsl:with-param name="page" select="$page"/>
				<xsl:with-param name="page_sequence" select="$page_sequence"/>
				<xsl:with-param name="page_name" select="$page_name"/>
				<xsl:with-param name="pageside" select="$pageside"/>
				<xsl:with-param name="maxwidth" select="$maxwidth"/>
				<xsl:with-param name="maxheight" select="$maxheight"/>
			</xsl:call-template>
			</boxesinchain>
		</xsl:variable>

		<!-- COUNT:<xsl:value-of select="count(xalan:nodeset($boxchain)//boxesinchain/boxinchain/*)"/> -->
		<xsl:for-each select="xalan:nodeset($boxchain)//boxesinchain/boxinchain/box">
			<xsl:copy-of select="."/>
		</xsl:for-each>

	</xsl:template> 

	<xsl:template name="get_next_box_in_chain">
		<xsl:param name="cont"/>
		<xsl:param name="itxf"/>
		<xsl:param name="ftxf"/>
		<xsl:param name="ptxf"/>
		<xsl:param name="ntxf"/>
		<xsl:param name="groupid"/>
		<xsl:param name="textflow_id"/>
		<xsl:param name="spread_num"/>
		<xsl:param name="spread_self"/>
		<xsl:param name="page_self"/><!-- the page Self ID -->
		<xsl:param name="page"/>
		<xsl:param name="page_sequence"/>
		<xsl:param name="page_name"/>
		<xsl:param name="pageside"/>
		<xsl:param name="maxwidth"/>
		<xsl:param name="maxheight"/>

		<xsl:if test="/Documents/Document//TextFrame[@Self = $ntxf]">
			<!-- store this box' layer ID and visibility of layer -->
			<xsl:variable name="layerID"><xsl:value-of select="/Documents/Document//TextFrame[@Self = $ntxf]/@ItemLayer"/></xsl:variable>
			<xsl:variable name="layerName">
				<xsl:if test="$layerID != ''">
					<xsl:value-of select="/Documents/Document/Layer[@Self = $layerID]/@Name/."/>
				</xsl:if>
			</xsl:variable>
			<xsl:variable name="layerVisibility">
				<xsl:if test="$layerID != ''">
					<xsl:value-of select="/Documents/Document/Layer[@Self = $layerID]/@Visible/."/>
				</xsl:if>
			</xsl:variable>
			<boxinchain>
				<xsl:call-template name="get_box_in_chain_boxelement">
					<xsl:with-param name="cont" select="$cont"/>
					<xsl:with-param name="itxf" select="number($itxf)+1"/>
					<xsl:with-param name="ftxf" select="$ftxf"/>
					<xsl:with-param name="ptxf" select="$ptxf"/>
					<xsl:with-param name="ntxf" select="$ntxf"/>
					<xsl:with-param name="groupid" select="$groupid"/>
					<xsl:with-param name="textflow_id" select="$textflow_id"/>
					<xsl:with-param name="spread_num" select="$spread_num"/>
					<xsl:with-param name="spread_self" select="$spread_self"/>
					<xsl:with-param name="page_self" select="$page_self"/>
					<xsl:with-param name="page" select="$page"/>
					<xsl:with-param name="page_sequence" select="$page_sequence"/>
					<xsl:with-param name="page_name" select="$page_name"/>
					<xsl:with-param name="pageside" select="$pageside"/>
					<xsl:with-param name="maxwidth" select="$maxwidth"/>
					<xsl:with-param name="maxheight" select="$maxheight"/>
				</xsl:call-template>
			</boxinchain>
			<!-- recall us if we have a next box in chain -->
			<xsl:if test="/Documents/Document//TextFrame[@Self = $ntxf]/@NextTextFrame != 'n'">
				<xsl:call-template name="get_next_box_in_chain">
					<xsl:with-param name="cont" select="$cont"/>
					<xsl:with-param name="itxf" select="number($itxf)+1"/>
					<xsl:with-param name="ftxf" select="$ftxf"/>
					<xsl:with-param name="ptxf" select="/Documents/Document//TextFrame[@Self = $ntxf]/@PreviousTextFrame"/>
					<xsl:with-param name="ntxf" select="/Documents/Document//TextFrame[@Self = $ntxf]/@NextTextFrame"/>
					<xsl:with-param name="groupid" select="$groupid"/>
					<xsl:with-param name="textflow_id" select="$textflow_id"/>
					<xsl:with-param name="spread_num" select="$spread_num"/>
					<xsl:with-param name="spread_self" select="$spread_self"/>
					<xsl:with-param name="page_self" select="$page_self"/>
					<xsl:with-param name="page" select="$page"/>
					<xsl:with-param name="page_sequence" select="$page_sequence"/>
					<xsl:with-param name="page_name" select="$page_name"/>
					<xsl:with-param name="pageside" select="$pageside"/>
					<xsl:with-param name="maxwidth" select="$maxwidth"/>
					<xsl:with-param name="maxheight" select="$maxheight"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
	</xsl:template>


	<xsl:template name="get_box_in_chain_boxelement">
		<xsl:param name="cont"/>
		<xsl:param name="itxf"/>
		<xsl:param name="ftxf"/>
		<xsl:param name="ptxf"/>
		<xsl:param name="ntxf"/>
		<xsl:param name="groupid"/>
		<xsl:param name="textflow_id"/>
		<xsl:param name="spread_num"/>
		<xsl:param name="spread_self"/>
		<xsl:param name="page_self"/>
		<xsl:param name="page"/>
		<xsl:param name="page_sequence"/>
		<xsl:param name="page_name"/>
		<xsl:param name="pageside"/>
		<xsl:param name="maxwidth"/>
		<xsl:param name="maxheight"/>
<!--
<xsl:variable name="m1" select="concat('***** get_box_in_chain_boxelement:'
										,'&#10;     cont: ',$cont
										,'&#10;     itxf: ',$itxf
										,'&#10;     ftxf: ',$ftxf
										,'&#10;     ptxf: ',$ptxf
										,'&#10;     ntxf: ',$ntxf
										,'&#10;     groupid: ',$groupid
										,'&#10;     textflow_id: ',$textflow_id
										,'&#10;     spread_num: ',$spread_num
										,'&#10;     spread_self: ',$spread_self
										,'&#10;     page_self: ',$page_self
										,'&#10;     page: ',$page
										,'&#10;     page_sequence: ',$page_sequence
										,'&#10;     page_name: ',$page_name
										,'&#10;     pageside: ',$pageside
										,'&#10;     maxwidth: ',$maxwidth
										,'&#10;     maxheight: ',$maxheight
										)"/>
<xsl:variable name="d" select="locjs:message(string($m1))"/>
-->
		<xsl:for-each select="/Documents/Document//TextFrame[@Self = $ntxf]">
			<xsl:variable name="boxprepared">
				<xsl:choose>
					<xsl:when test="locjs:get_aBox_info(string($ntxf)) = true()">
						<xsl:value-of select="locjs:get_aBox_info(string($ntxf))"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="store_box2page_infos">
							<xsl:with-param name="spread_num"><xsl:value-of select="$spread_num"/></xsl:with-param>
							<xsl:with-param name="spread_self"><xsl:value-of select="$spread_self"/></xsl:with-param>
							<xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
							<xsl:with-param name="page_sequence"><xsl:value-of select="$page_sequence"/></xsl:with-param>
							<xsl:with-param name="page_name"><xsl:value-of select="$page_name"/></xsl:with-param>
							<xsl:with-param name="page_side"><xsl:value-of select="$pageside"/></xsl:with-param>
							<xsl:with-param name="page_self"><xsl:value-of select="$page_self"/></xsl:with-param>
						</xsl:call-template>
						<xsl:value-of select="locjs:get_aBox_info(string($ntxf))"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<xsl:if test="$boxprepared = 'true'">
				<xsl:variable name="coords"><xsl:value-of select="locjs:ls()"/>,<xsl:value-of select="locjs:ts()"/>,<xsl:value-of select="locjs:rs()"/>,<xsl:value-of select="locjs:bs()"/></xsl:variable>
				<xsl:variable name="x1"><xsl:if test="locjs:ls() &lt; '0'">0</xsl:if><xsl:if test="locjs:ls() &gt;= '0'"><xsl:value-of select="locjs:ls()"/></xsl:if></xsl:variable>
				<xsl:variable name="y1"><xsl:if test="locjs:ts() &lt; '0'">0</xsl:if><xsl:if test="locjs:ts() &gt;= '0'"><xsl:value-of select="locjs:ts()"/></xsl:if></xsl:variable>
				<xsl:variable name="x2"><xsl:if test="locjs:rs() &gt; $maxwidth"><xsl:value-of select="$maxwidth"/></xsl:if><xsl:if test="locjs:rs() &lt;= $maxwidth"><xsl:value-of select="locjs:rs()"/></xsl:if></xsl:variable>
				<xsl:variable name="y2"><xsl:if test="locjs:bs() &gt; $maxheight"><xsl:value-of select="$maxheight"/></xsl:if><xsl:if test="locjs:bs() &lt;= $maxheight"><xsl:value-of select="locjs:bs()"/></xsl:if></xsl:variable>
				<xsl:variable name="angle"><xsl:value-of select="locjs:get_angle()"/></xsl:variable>
				<xsl:variable name="shape"><xsl:value-of select="locjs:get_shape()"/></xsl:variable>
				<xsl:variable name="matrix"><xsl:value-of select="locjs:get_matrix()"/></xsl:variable>
				<xsl:variable name="matrix_orig"><xsl:value-of select="locjs:get_matrix_orig()"/></xsl:variable>

				<xsl:variable name="index" select="locjs:store_boxchain_idx(string(@PreviousTextFrame))" /><!-- 0=first box,>0=chained box -->

				<box>
					<xsl:attribute name="type">chained_text</xsl:attribute>
					<xsl:attribute name="cont"><xsl:value-of select="$cont"/></xsl:attribute>
					<xsl:attribute name="Self"><xsl:value-of select="@Self"/></xsl:attribute>
					<xsl:attribute name="spread"><xsl:value-of select="locjs:get_box2page_spread(string(@Self))"/></xsl:attribute>
					<xsl:attribute name="page_sequence"><xsl:value-of select="locjs:get_box2page_page_sequence(string(@Self))"/></xsl:attribute>
					<xsl:attribute name="page_name"><xsl:value-of select="locjs:get_box2page_page_name(string(@Self))"/></xsl:attribute>
					<xsl:attribute name="groupid"><xsl:value-of select="$groupid"/></xsl:attribute>
					<xsl:attribute name="anchorid"><xsl:value-of select="locjs:get_stof()"/></xsl:attribute>
					<xsl:variable name="parentstory"><xsl:value-of select="@ParentStory"/></xsl:variable>

					<xsl:if test="@Nonprinting">
						<xsl:attribute name="nopr"><xsl:value-of select="@Nonprinting"/></xsl:attribute>
					</xsl:if>
					<xsl:variable name="objectstyle"><!-- object style -->
						<xsl:if test="@AppliedObjectStyle and not(contains(@AppliedObjectStyle,'\[None\]'))">
							<xsl:value-of select="locjs:get_style_class_name(string(@AppliedObjectStyle))"/>
						</xsl:if>
					</xsl:variable>
					<xsl:if test="($objectstyle != '') and ($objectstyle != 'n')">
						<xsl:attribute name="objstyle"><xsl:value-of select="$objectstyle"/></xsl:attribute>
					</xsl:if>
					<xsl:choose>
						<xsl:when test="@NextTextFrame = 'n'">
							<xsl:attribute name="lastflowid"><xsl:value-of select="@Self"/></xsl:attribute><!-- id of last box in chain -->
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="lastflowid"></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:attribute name="chainidx"><xsl:value-of select="$index"/></xsl:attribute><!-- 0=first box,>0=chained box -->
					<xsl:attribute name="previousflowid"><xsl:value-of select="@PreviousTextFrame"/></xsl:attribute><!-- id of previous box in chain or 'n' if not chained -->
					<xsl:attribute name="nextflowid"><xsl:value-of select="@NextTextFrame"/></xsl:attribute><!-- id of last box in chain or 'n' if not chained -->
					<xsl:attribute name="textflowid"><xsl:value-of select="$textflow_id"/></xsl:attribute><!-- the pointer to the Story element -->
					<xsl:attribute name="angle"><xsl:value-of select="$angle"/></xsl:attribute>
					<xsl:attribute name="coords"><xsl:value-of select="locjs:ls()"/>,<xsl:value-of select="locjs:ts()"/>,<xsl:value-of select="locjs:rs()"/>,<xsl:value-of select="locjs:bs()"/></xsl:attribute>
					<xsl:attribute name="bbox"><xsl:value-of select="locjs:get_bbox()"/></xsl:attribute>
					<xsl:attribute name="bbox_orig"><xsl:value-of select="locjs:get_bbox_orig()"/></xsl:attribute>
					<xsl:attribute name="shape"><xsl:value-of select="$shape"/></xsl:attribute>
					<xsl:attribute name="shape_orig"><xsl:value-of select="locjs:get_shape_orig()"/></xsl:attribute>
					<xsl:attribute name="pageJPEGScale"><xsl:value-of select="locjs:get_pageJPEGScale()"/></xsl:attribute>
					<xsl:attribute name="x1"><xsl:value-of select="$x1"/></xsl:attribute>
					<xsl:attribute name="y1"><xsl:value-of select="$y1"/></xsl:attribute>
					<xsl:attribute name="x2"><xsl:value-of select="$x2"/></xsl:attribute>
					<xsl:attribute name="y2"><xsl:value-of select="$y2"/></xsl:attribute>
					<xsl:if test="locjs:get_layerID() != ''">
						<xsl:attribute name="layerID"><xsl:value-of select="locjs:get_layerID()"/></xsl:attribute>
						<xsl:attribute name="layerName"><xsl:value-of select="locjs:get_layerName()"/></xsl:attribute>
						<xsl:attribute name="layerVis"><xsl:value-of select="locjs:get_layerVisibility()"/></xsl:attribute>
					</xsl:if>
					<xsl:attribute name="label"><xsl:value-of select="locjs:get_label()"/></xsl:attribute>
					<xsl:attribute name="colcnt"><xsl:value-of select="locjs:get_textboxstuff(4, 1)"/></xsl:attribute>
					<xsl:attribute name="colwidth"><xsl:value-of select="locjs:get_textboxstuff(5, 1)"/></xsl:attribute>
					<xsl:if test="locjs:get_textboxstuff(6, 1) != ''"><xsl:attribute name="colgutter"><xsl:value-of select="locjs:get_textboxstuff(6, 1)"/></xsl:attribute></xsl:if>
					<xsl:attribute name="vjust"><xsl:value-of select="locjs:get_textboxstuff(7, 1)"/></xsl:attribute>
					<xsl:if test="locjs:get_textboxstuff(8, 1) != ''"><xsl:attribute name="paraspacelimit"><xsl:value-of select="locjs:get_textboxstuff(8, 1)"/></xsl:attribute></xsl:if>
					<xsl:attribute name="insetTopR"><xsl:value-of select="locjs:get_textboxstuff(0, 1)"/></xsl:attribute>
					<xsl:attribute name="insetLeftR"><xsl:value-of select="locjs:get_textboxstuff(1, 1)"/></xsl:attribute>
					<xsl:attribute name="insetBottomR"><xsl:value-of select="locjs:get_textboxstuff(2, 1)"/></xsl:attribute>
					<xsl:attribute name="insetRightR"><xsl:value-of select="locjs:get_textboxstuff(3, 1)"/></xsl:attribute>
					<xsl:attribute name="insetTop"><xsl:value-of select="locjs:get_textboxstuff(0, 0)"/></xsl:attribute>
					<xsl:attribute name="insetLeft"><xsl:value-of select="locjs:get_textboxstuff(1, 0)"/></xsl:attribute>
					<xsl:attribute name="insetBottom"><xsl:value-of select="locjs:get_textboxstuff(2, 0)"/></xsl:attribute>
					<xsl:attribute name="insetRight"><xsl:value-of select="locjs:get_textboxstuff(3, 0)"/></xsl:attribute>
					<xsl:attribute name="backgroundColor"><xsl:value-of select="locjs:get_rgb_color(string(@FillColor),string(@FillTint))"/></xsl:attribute>
					<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
						<xsl:if test="@FillColor"><xsl:attribute name="backgroundColorID"><xsl:value-of select="@FillColor"/></xsl:attribute></xsl:if>
						<xsl:if test="@FillTint"><xsl:attribute name="backgroundColorFilt"><xsl:value-of select="@FillTint"/></xsl:attribute></xsl:if>
						<xsl:attribute name="matrix"><xsl:value-of select="$matrix"/></xsl:attribute>
						<xsl:attribute name="matrix_orig"><xsl:value-of select="$matrix_orig"/></xsl:attribute>
					</xsl:if>

					<xsl:variable name="frameweight">
						<xsl:choose>
							<xsl:when test="@StrokeWeight"><xsl:value-of select="@StrokeWeight"/></xsl:when><!-- line weight is given -->
							<xsl:when test="@StrokeColor and @StrokeTint">1</xsl:when><!-- line tint is given but no line weight @lnwt: means line weight 1pt -->
							<xsl:otherwise>0</xsl:otherwise><!-- set to no line -->
						</xsl:choose>
					</xsl:variable>
					<xsl:if test="($frameweight != '0') and (@StrokeColor or @StrokeTint)"><!-- only if we also have frame line weight (lnwt) and a line tint (lint) or color attributes (lncl), add frame border attribs -->
						<xsl:attribute name="frameWeight"><xsl:value-of select="$frameweight"/></xsl:attribute>
	
							<xsl:variable name="stst" select="@StrokeType"/>
							<xsl:variable name="framestylename">
								<xsl:choose>
									<xsl:when test="$stst = 'n'">n</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="/Documents/Document/Graphic/StrokeStyle[@Self = $stst]/@Name/."/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							<xsl:variable name="framestylenameLC" select="locjs:to_lower_case(string($framestylename))"/>
							<xsl:variable name="framestylehtml">
								<xsl:choose>
									<xsl:when test="contains($framestylenameLC,'solid')">solid</xsl:when>
									<xsl:when test="contains($framestylenameLC,'thin')">double</xsl:when>
									<xsl:when test="contains($framestylenameLC,'thick')">double</xsl:when>
									<xsl:when test="contains($framestylenameLC,'dot')">dotted</xsl:when>
									<xsl:when test="contains($framestylenameLC,'dash')">dashed</xsl:when>
									<xsl:otherwise>solid</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
						<xsl:attribute name="frameStyleName"><xsl:value-of select="$framestylename"/></xsl:attribute>
						<xsl:attribute name="frameStyleHTML"><xsl:value-of select="$framestylehtml"/></xsl:attribute>
	
						<xsl:variable name="framecolor">
							<xsl:choose>
								<xsl:when test="@StrokeColor"><xsl:value-of select="@StrokeColor"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="locjs:get_rgb_color_id('black')"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:attribute name="frameColor"><xsl:value-of select="locjs:get_rgb_color(string($framecolor),string(@StrokeTint))"/></xsl:attribute>
						<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
							<xsl:if test="@StrokeColor"><xsl:attribute name="frameColorID"><xsl:value-of select="@StrokeColor"/></xsl:attribute></xsl:if>
							<xsl:if test="@StrokeTint"><xsl:attribute name="frameColorFilt"><xsl:value-of select="@StrokeTint"/></xsl:attribute></xsl:if>
							<xsl:if test="@GapColor"><xsl:attribute name="frameGapColor"><xsl:value-of select="locjs:get_rgb_color(string(@GapColor),string(@GapTint))"/></xsl:attribute></xsl:if>
							<xsl:if test="@GapColor"><xsl:attribute name="frameGapColorID"><xsl:value-of select="@GapColor"/></xsl:attribute></xsl:if>
							<xsl:if test="@GapTint"><xsl:attribute name="frameGapColorTint"><xsl:value-of select="@GapTint"/></xsl:attribute></xsl:if>
							<xsl:if test="@LeftLineEnd"><xsl:attribute name="leftFrameEnd"><xsl:value-of select="@LeftLineEnd"/></xsl:attribute></xsl:if>
							<xsl:if test="@RightLineEnd"><xsl:attribute name="rightFrameEnd"><xsl:value-of select="@RightLineEnd"/></xsl:attribute></xsl:if>
						</xsl:if>
					</xsl:if>
	
					<area><!-- get box area -->
						<xsl:attribute name="name">A<xsl:value-of select="@Self"/>_<xsl:value-of select="$page_sequence"/></xsl:attribute><!-- need name attr for Netscape -->
						<xsl:attribute name="shape">rect</xsl:attribute>
						<xsl:attribute name="coords"><xsl:value-of select="$coords"/></xsl:attribute>
						<xsl:if test="$angle != 0.0">
							<xsl:attribute name="angle"><xsl:value-of select="$angle"/></xsl:attribute>
						</xsl:if>
						<xsl:if test="$shape != ''">
							<xsl:attribute name="shape"><xsl:value-of select="$shape"/></xsl:attribute>
						</xsl:if>
						<xsl:attribute name="x1"><xsl:value-of select="$x1"/></xsl:attribute>
						<xsl:attribute name="y1"><xsl:value-of select="$y1"/></xsl:attribute>
						<xsl:attribute name="x2"><xsl:value-of select="$x2"/></xsl:attribute>
						<xsl:attribute name="y2"><xsl:value-of select="$y2"/></xsl:attribute>
						<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
							<xsl:attribute name="matrix"><xsl:value-of select="$matrix"/></xsl:attribute>
							<xsl:attribute name="matrix_orig"><xsl:value-of select="$matrix_orig"/></xsl:attribute>
						</xsl:if>
					</area>
				</box>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>



	<!-- ===============================================
		 an image
	     =============================================== -->
	<xsl:template name="get_image">
		<xsl:param name="groupid"/>
		<xsl:param name="exist"/>
		<xsl:param name="anchorID"/><!-- is anchored? -->
		<xsl:param name="self"/>
		<xsl:param name="src_imagename"/>
		<xsl:param name="src_imagename_orig"/>
		<xsl:param name="source_imagepathname"/>
		<xsl:param name="target_imagename"/>
		<xsl:param name="contentlabel"/>
		<xsl:param name="label"/>
		<xsl:param name="originalCopied"/>
		<xsl:param name="isemptyimagebox"/>
		<xsl:param name="XMLElementSelf"/>
		<xsl:param name="XMLElementMarkupTag"/>
		<xsl:param name="XMLElementXMLContent"/>
		<xsl:param name="XMLElementAttributes"/>

		<xsl:variable name="d" select="locjs:store_splitlabel(string($label))" /><!-- store label -->

		<xsl:variable name="imgname1label" select="locjs:get_splitlabel('imgname1:')" />
		<xsl:variable name="imgname1" select="locjs:get_labelvalue(string($imgname1label),0)" />
		<xsl:variable name="imgwidth1" select="locjs:get_labelvalue(string($imgname1label),1)" />
		<xsl:variable name="imgheight1" select="locjs:get_labelvalue(string($imgname1label),2)" />

		<xsl:variable name="imgname2label" select="locjs:get_splitlabel('imgname2:')" />
		<xsl:variable name="imgname2" select="locjs:get_labelvalue(string($imgname2label),0)" />
		<xsl:variable name="imgwidth2" select="locjs:get_labelvalue(string($imgname2label),1)" />
		<xsl:variable name="imgheight2" select="locjs:get_labelvalue(string($imgname2label),2)" />


		<content type="image">
			<xsl:attribute name="Self"><xsl:value-of select="$self"/></xsl:attribute>
			<xsl:attribute name="id"><xsl:value-of select="$self"/></xsl:attribute>
			<xsl:attribute name="anchor_id"><xsl:value-of select="$anchorID"/></xsl:attribute>
			<xsl:attribute name="groupid"><xsl:value-of select="$groupid"/></xsl:attribute>
			<xsl:attribute name="exist"><xsl:value-of select="$exist"/></xsl:attribute>
			<xsl:attribute name="label"><xsl:value-of select="$contentlabel"/></xsl:attribute>
			<xsl:if test="(locjs:get_includeXMLtags() != '0' ) and ($XMLElementSelf != '')">
				<xsl:attribute name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:attribute>
				<xsl:attribute name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:attribute>
				<xsl:if test="$XMLElementXMLContent != ''"><xsl:attribute name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:attribute></xsl:if>
				<xsl:if test="$XMLElementAttributes != ''"><xsl:attribute name="XMLElementAttributes"><xsl:value-of select="$XMLElementAttributes"/></xsl:attribute></xsl:if>
			</xsl:if>
			<xsl:attribute name="angle"><xsl:value-of select="locjs:get_imgContainer_angle()"/></xsl:attribute>
			<xsl:attribute name="scaleX"><xsl:value-of select="locjs:get_imgContainer_scaleX()"/></xsl:attribute>
			<xsl:attribute name="scaleY"><xsl:value-of select="locjs:get_imgContainer_scaleY()"/></xsl:attribute>
			<xsl:if test="$isemptyimagebox != '1'">
				<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
					<xsl:attribute name="displaceX"><xsl:value-of select="locjs:get_imgContainer_displaceX()"/></xsl:attribute>
					<xsl:attribute name="displaceY"><xsl:value-of select="locjs:get_imgContainer_displaceY()"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="$originalCopied = '1'"><xsl:attribute name="originalAvail"><xsl:value-of select="$originalCopied"/></xsl:attribute></xsl:if>
				<img>
					<xsl:if test="$exist = '0'"><xsl:attribute name="exist"><xsl:value-of select="$exist"/></xsl:attribute></xsl:if>
					<xsl:if test="$originalCopied = '1'"><xsl:attribute name="originalAvail"><xsl:value-of select="$originalCopied"/></xsl:attribute></xsl:if>
					<xsl:attribute name="src"><xsl:value-of select="locjs:encode_URIjs(string($target_imagename))"/></xsl:attribute>
					<xsl:attribute name="alt"><xsl:value-of select="locjs:encode_URIjs($src_imagename_orig)"/></xsl:attribute>
					<xsl:if test="$imgwidth1 != ''"><xsl:attribute name="width"><xsl:value-of select="$imgwidth1"/></xsl:attribute></xsl:if>
					<xsl:if test="$imgheight1 != ''"><xsl:attribute name="height"><xsl:value-of select="$imgheight1"/></xsl:attribute></xsl:if>
					<!-- Do we want meta data have extracted? -->
					<xsl:if test="($exist = true()) and ($extractImageMetaData != '0')">
						<xsl:variable name="d1" select="myutils:showMess(concat('&#10;---- Extracting Meta Data ',$typeImageMetaData,' from file: ',$source_imagepathname,' '),'1')"/>
						<!-- Apache Tika Options:
							WHERE == should be two minus chars
									-?  or ==help          Print this usage message
									-v  or ==verbose       Print debug level messages
									-V  or ==version       Print the Apache Tika version number
								
									-g  or ==gui           Start the Apache Tika GUI
									-s  or ==server        Start the Apache Tika server
									-f  or ==fork          Use Fork Mode for out-of-process extraction
								
									-x  or ==xml           Output XHTML content (default)
									-h  or ==html          Output HTML content
									-t  or ==text          Output plain text content
									-T  or ==text-main     Output plain text content (main content only)
									-m  or ==metadata      Output only metadata
									-j  or ==json          Output metadata in JSON
									-y  or ==xmp           Output metadata in XMP
									-l  or ==language      Output only language
									-d  or ==detect        Detect document type
									-eX or ==encoding=X    Use output encoding X
									-pX or ==password=X    Use document password X
									-z  or ==extract       Extract all attachements into current directory
									==extract-dir=<dir>    Specify target directory for -z
									-r  or ==pretty-print  For XML and XHTML outputs, adds newlines and whitespace, for better readability
								
									==create-profile=X
										 Create NGram profile, where X is a profile name
									==list-parsers
										 List the available document parsers
									==list-parser-details
										 List the available document parsers, and their supported mime types
									==list-detectors
										 List the available document detectors
									==list-met-models
										 List the available metadata models, and their supported keys
									==list-supported-types
										 List all known media types and related information
								
								Description:
									Apache Tika will parse the file(s) specified on the
									command line and output the extracted text content
									or metadata to standard output.
									Instead of a file name you can also specify the URL
									of a document to be parsed.
									If no file name or URL is specified (or the special
									name "-" is used), then the standard input stream
									is parsed. If no arguments were given and no input
									data is available, the GUI is started instead.
								
								- GUI mode
									Use the "==gui" (or "-g") option to start the
									Apache Tika GUI. You can drag and drop files from
									a normal file explorer to the GUI window to extract
									text content and metadata from the files.
								
								- Server mode
									Use the "==server" (or "-s") option to start the
									Apache Tika server. The server will listen to the
									ports you specify as one or more arguments.
						-->
						<xsl:variable name="imageMetaOK" select="myutils:extractMetaData(concat($typeImageMetaData,',','--encoding=utf-8',',',$source_imagepathname))"/><!-- make comma delimited string -->
						<xsl:variable name="imageMetaError" select="myutils:getMetaExtractorError()"/>
						<xsl:variable name="imageMeta">
							<xsl:if test="$imageMetaOK = 0">
								<xsl:value-of disable-output-escaping="yes" select="myutils:getMetaData()"/>
							</xsl:if>
						</xsl:variable>
						<!--
							<xsl:variable name="d" select="locjs:message(concat('*** getting Image Meta from file: ',$source_imagepathname))"/>
							<xsl:variable name="d" select="locjs:message(concat('### Meta error return code: ',$imageMetaOK))"/>
							<xsl:variable name="d" select="locjs:message(concat('### Meta error text: ',$imageMetaError))"/>
							<xsl:variable name="d" select="locjs:message($imageMeta)"/>
						-->
						<xsl:choose>
							<xsl:when test="$imageMetaOK = 0">
								<xsl:variable name="d1" select="myutils:showMess(concat('          OK','&#10;'),'1')"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:variable name="d1" select="myutils:showMess(concat('#### ERROR ',$imageMetaOK,' while extracing meta data','&#10;'),'1')"/>
								<xsl:variable name="d1" select="myutils:showMess(concat('#### ERROR Message: ',$imageMetaError,'&#10;'),'1')"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="$imageMeta != ''">
							<metadata>
								<xsl:if test="$fullImageMetaData != '0'"><!-- add entire meta data -->
									<metadatafull><xsl:copy-of select="$imageMeta"/></metadatafull>
								</xsl:if>
								<xsl:choose>
									<xsl:when test="starts-with($imageMeta,'&lt;x:xmpmeta') = 'true'"><!-- xmp XML -->
										<xsl:variable name="xmpmeta" select="myutils:parseStringToDom(string($imageMeta))"/>
										<title><xsl:value-of select="$xmpmeta//descendant::dc:title/rdf:Alt/rdf:li/." /></title>
										<description><xsl:value-of select="$xmpmeta//descendant::dc:description/rdf:Alt/rdf:li/." /></description>
										<subject>
											<xsl:for-each select="$xmpmeta//descendant::dc:subject/rdf:Bag/rdf:li[not (. = preceding::rdf:li/.)]">
												<xsl:sort select="." />
													<xsl:if test="position() != 1"><xsl:text>,</xsl:text></xsl:if><xsl:value-of select="." />
											</xsl:for-each>
										</subject>
									</xsl:when>
									<xsl:when test="starts-with($imageMeta,'{ ') = 'true'"><!-- json associative array -->
										<xsl:if test="$fullImageMetaData = '0'"><!-- add entire meta data in json -->
											<metadatafull><xsl:copy-of select="$imageMeta"/></metadatafull>
										</xsl:if>
									</xsl:when>
									<xsl:otherwise><!-- plain text lines -->
										<title><xsl:value-of select="locjs:parseMetaValue(string($imageMeta),'dc:title: ')" /></title>
										<description><xsl:value-of select="locjs:parseMetaValue(string($imageMeta),'dc:description: ')" /></description>
										<subject><xsl:value-of select="locjs:parseMetaValue(string($imageMeta),'dc:subject: ')" /></subject>
										<author><xsl:value-of select="locjs:parseMetaValue(string($imageMeta),'Author: ')" /></author>
										<copyright><xsl:value-of select="locjs:parseMetaValue(string($imageMeta),'Copyright: ')" /></copyright>
									</xsl:otherwise>
								</xsl:choose>
							</metadata>
						</xsl:if>
					</xsl:if>
				</img>
				<!-- check if we have images in other sizes to add -->
				<xsl:if test="locjs:get_more_images() != ''">
					<img2>
						<xsl:if test="$exist = '0'"><xsl:attribute name="exist"><xsl:value-of select="$exist"/></xsl:attribute></xsl:if>
						<xsl:if test="$originalCopied = '1'"><xsl:attribute name="originalAvail"><xsl:value-of select="$originalCopied"/></xsl:attribute></xsl:if>
						<xsl:attribute name="src"><xsl:value-of select="locjs:encode_URIjs(locjs:get_more_images())"/></xsl:attribute>
						<xsl:attribute name="alt"><xsl:value-of select="locjs:encode_URIjs($src_imagename_orig)"/></xsl:attribute>
						<xsl:if test="$imgwidth2 != ''"><xsl:attribute name="width"><xsl:value-of select="$imgwidth2"/></xsl:attribute></xsl:if>
						<xsl:if test="$imgheight2 != ''"><xsl:attribute name="height"><xsl:value-of select="$imgheight2"/></xsl:attribute></xsl:if>
					</img2>
				</xsl:if>
			</xsl:if>
		</content>
	</xsl:template>



	<!-- ===============================================
		 create more images
	     =============================================== -->
	<xsl:template name="create_more_images">
		<xsl:param name="self"/>
		<xsl:param name="imagesMORE"/><!-- new scale facor[;imagemagickparameters] -->
		<xsl:param name="ImageMagickConvert"/>
		<xsl:param name="ImageMagickConvertEnvir"/>
		<xsl:param name="filenameConversion"/>

		<xsl:param name="verbose_debug"/>
		<xsl:param name="page_param"/>
		<xsl:param name="theColorProfileINPUTParm"/>
		<xsl:param name="useImageInputParam"/>
		<xsl:param name="imageFileOptions"/>
		<xsl:param name="source"/>
		<xsl:param name="resample_param"/>
		<xsl:param name="IMquality"/>
		<xsl:param name="myimagePARAMS"/>
		<xsl:param name="imageOutputFinishParam"/>
		<xsl:param name="target"/>
		<xsl:param name="DoAddCropBox"/>
		<xsl:param name="theIMsourceFiletypePrefix"/>

			<!-- determine input image format -->
			<xsl:variable name="inputImageFormat">
				<xsl:value-of select="locjs:get_imagename_extension(string($source))"/>
			</xsl:variable>
			<!-- determine output image format -->
			<xsl:variable name="outputImageFormat">
				<xsl:value-of select="locjs:get_imagename_extension(string($target))"/>
			</xsl:variable>
			<!-- determine the canvas format string -->
			<xsl:variable name="useImageInputParam">
				<xsl:value-of select="locjs:get_imageInputParam(string($inputImageFormat),string($outputImageFormat))"/>
			</xsl:variable>

			<xsl:variable name="doCrop">
				<xsl:choose>
					<xsl:when test="$inputImageFormat = 'wmf'">0</xsl:when>
					<xsl:otherwise></xsl:otherwise><!-- auto according to cropImages -->
				</xsl:choose>
			</xsl:variable>

			<!-- create new resize and crop parameters -->
			<xsl:variable name="more_resize_crop_param" select="locjs:more_get_resize_crop_param(string($self), string($imagesMORE),locjs:get_imag_IGeo(),locjs:get_IGeo(),locjs:get_imagInImage_IGeo(),locjs:get_original_image_Appi(),locjs:get_original_image_Eppi(),string($DoAddCropBox),string($doCrop))"/>
			<!-- new scale value and params now preset -->

			<!-- get new imageMagick params: previously stored by more_get_resize_crop_param(string($imagesMORE).... -->
			<xsl:variable name="moreimagePARAMS" select="locjs:get_more_imagePARAMS()"/>

			<!-- create new target file name -->
			<xsl:variable name="nameexpand" select="locjs:get_more_imageScaleOriginalExtension()"/>
			<xsl:variable name="newtargetName" select="locjs:getFileNamePart(string($target),string($nameexpand))"/>
			<xsl:variable name="newtargetPath" select="locjs:getFilePathPart(string($target))"/>
			<xsl:variable name="newtarget"><xsl:value-of select="$newtargetPath"/><xsl:value-of select="$newtargetName"/></xsl:variable>

			<!-- create new parameter string -->
			<xsl:variable name="newparams" select="locjs:createParamString(string($verbose_debug),string($page_param),string($theColorProfileINPUTParm),string($useImageInputParam),string($imageFileOptions),locjs:escapeMagick(concat($theIMsourceFiletypePrefix,$source)),string($resample_param),string($more_resize_crop_param),string($IMquality),string($moreimagePARAMS),string($imageOutputFinishParam),locjs:escapeMagick(string($newtarget)))"/>
			<!--xsl:variable name="newparams" select="locjs:createParamString(string($verbose_debug),string($page_param),string($theColorProfileINPUTParm),string($useImageInputParam),string($source),                                                                         string($more_resize_crop_param),string($IMquality),string($moreimagePARAMS),string($imageOutputFinishParam),locjs:escapeMagick(string($newtarget)))"/-->

			<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
				<xsl:variable name="d" select="locjs:message('-----MORE IMAGE----')"/>
				<xsl:variable name="d" select="locjs:message(concat('       newtarget: ',string($newtarget)))"/>
				<xsl:variable name="d" select="locjs:message(concat('       imagesMORE: ',string($imagesMORE)))"/>
				<xsl:variable name="d" select="locjs:message(concat('       more_resize_crop_param: ',string($more_resize_crop_param)))"/>
				<xsl:variable name="d" select="locjs:message(concat('       moreimagePARAMS: ',string($moreimagePARAMS)))"/>
				<xsl:variable name="d" select="locjs:message(concat('       newparams: ',string($newparams)))"/>
			</xsl:if>

			<xsl:variable name="m1">&#10;      - Next image convert to: '<xsl:value-of select="$newtargetName"/>': </xsl:variable>
			<xsl:variable name="d" select="myutils:showMess(string($m1),'1')"/>
			<!-- call external Image Converter 'ImageMagick' -->
			<xsl:variable name="imageconverted"><xsl:value-of select="myutils:callExternalApp(string($ImageMagickConvert),$newparams,$ImageMagickConvertEnvir,'',$filenameConversion)"/></xsl:variable>

			<xsl:variable name="m2"><xsl:choose><xsl:when test="$imageconverted=0">OK</xsl:when><xsl:otherwise>### ERROR: <xsl:value-of select="$imageconverted"/></xsl:otherwise></xsl:choose></xsl:variable>
			<xsl:variable name="d2" select="myutils:showMess(string($m2),'1')"/>
			<xsl:if test="($DEBUG = 1) or ($DEBUGIMAGES = 1)">
				<xsl:variable name="donemess">   *** 2nd image: <xsl:value-of select="$imageconverted"/></xsl:variable>
				<xsl:variable name="d" select="locjs:message(string($donemess))"/>
			</xsl:if>

			<xsl:variable name="exists" select="locjs:fileExists(locjs:cleanMagick(string($newtarget)))"/>

			<!-- store this image info away to include in output by get_image template -->
			<xsl:if test="$exists='true'">
				<xsl:variable name="d" select="locjs:store_more_images(string($newtargetName))"/>
			</xsl:if>

	</xsl:template>


	<!-- ===============================================
		 Notes
	     =============================================== -->
	<!-- a Note's content -->
	<xsl:template match="Note" mode="articletext">
		<xsl:variable name="noteSequence"><xsl:value-of select="locjs:get_note_sequence()"/></xsl:variable>
		<xsl:variable name="noteID"><xsl:text>notes_</xsl:text><xsl:value-of select="$noteSequence"/></xsl:variable>
		<contentElem name="{name()}" render="inline"><xsl:text>&lt;?__anchored_object__ "</xsl:text><xsl:value-of select="$noteID"/><xsl:text>"?&gt;</xsl:text></contentElem>
	</xsl:template>

	<!-- prepare notes -->
	<xsl:template name="prepare_notes">
		<xsl:if test="/Documents/Document/Story/Story//Note"><!-- do only if we have footnotes -->
			<xsl:if test="$DEBUG = 1">
				<xsl:variable name="d" select="locjs:message('************** Preparing Notes **************')"/>
			</xsl:if>
			<xsl:variable name="d" select="myutils:showMess('&#10;   ++ Preparing Notes ','1')"/>
			<xsl:variable name="d" select="locjs:reset_note_sequence()"/>
			<xsl:for-each select="/Documents/Document/Story/Story//Note">
				<xsl:variable name="noteSequence"><xsl:value-of select="locjs:get_note_sequence()"/></xsl:variable>
				<xsl:variable name="noteID"><xsl:text>notes_</xsl:text><xsl:value-of select="$noteSequence"/></xsl:variable>
				<xsl:if test="locjs:store_anchored_object_anchorid(string($noteID)) = 0"><!-- store if not already stored -->
					<xsl:variable name="d06" select="locjs:init_articles()" /><!-- reset articles -->
					<xsl:variable name="notecontent">
						<anchored_object name="Note">
							<xsl:attribute name="anchorid"><xsl:value-of select="$noteID"/></xsl:attribute>
							<xsl:attribute name="idx"><xsl:value-of select="locjs:get_num_anchored_objects()" /></xsl:attribute>
							<xsl:attribute name="noteSequence"><xsl:value-of select="$noteSequence"/></xsl:attribute>
							<xsl:attribute name="type">Note</xsl:attribute>
							<xsl:attribute name="cont">Note</xsl:attribute>
							<box>
								<xsl:attribute name="type">Note</xsl:attribute>
								<xsl:attribute name="cont">Note</xsl:attribute>
								<xsl:attribute name="noteID"><xsl:value-of select="$noteID"/></xsl:attribute>
								<xsl:attribute name="noteSequence"><xsl:value-of select="$noteSequence"/></xsl:attribute>
								<content type="Note">
									<xsl:attribute name="noteSequence"><xsl:value-of select="$noteSequence"/></xsl:attribute>
									<Note>
										<xsl:attribute name="collapsed"><xsl:value-of select="@Collapsed"/></xsl:attribute>
										<xsl:attribute name="created"><xsl:value-of select="@CreationDate"/></xsl:attribute>
										<xsl:attribute name="modified"><xsl:value-of select="@ModificationDate"/></xsl:attribute>
										<xsl:attribute name="user"><xsl:value-of select="@UserName"/></xsl:attribute>
										<xsl:attribute name="appliedUser"><xsl:value-of select="@AppliedDocumentUser"/></xsl:attribute>
										<content type="Note"><xsl:apply-templates select="ParagraphStyleRange" mode="articletext"/></content>
									</Note>
								</content>
							</box></anchored_object>
					</xsl:variable>
					<xsl:variable name="notecontent_string" select="myutils:serializeDOM(xalan:nodeset($notecontent),'0','yes')"/>
					<xsl:if test="$notecontent_string != ''">
						<xsl:if test="$DEBUG = 1"><xsl:variable name="d" select="locjs:message(concat('***********STORING Note: ',$notecontent_string))"/></xsl:if>
						<xsl:variable name="aop" select="locjs:store_anchored_objects_string(string($notecontent_string))" />
						<xsl:if test="$DEBUG = 1"><xsl:variable name="d" select="locjs:message('************************STORING END')"/></xsl:if>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
		<xsl:variable name="d" select="locjs:reset_note_sequence()"/>
	</xsl:template>


	<!-- ===============================================
		 footnotes
	     =============================================== -->
	<!-- a footnote's content -->
	<xsl:template name="getFootnote">
		<xsl:param name="level"/>
		<xsl:param name="footnoteSequence"/>
		<xsl:param name="footnoteID"/>
		<anchored_object name="FNcl">
			<xsl:attribute name="anchorid"><xsl:value-of select="$footnoteID"/></xsl:attribute>
			<xsl:attribute name="idx"><xsl:value-of select="locjs:get_num_anchored_objects()" /></xsl:attribute>
			<xsl:attribute name="footnoteSequence"><xsl:value-of select="$footnoteSequence"/></xsl:attribute>
			<xsl:attribute name="type">footnote</xsl:attribute>
			<xsl:attribute name="cont">footnote</xsl:attribute>
			<box>
				<xsl:attribute name="type">footnote</xsl:attribute>
				<xsl:attribute name="cont">footnote</xsl:attribute>
				<xsl:attribute name="footnoteID"><xsl:value-of select="$footnoteID"/></xsl:attribute>
				<xsl:attribute name="footnoteSequence"><xsl:value-of select="$footnoteSequence"/></xsl:attribute>
				<xsl:attribute name="footnote_number">%_ftn_num_%</xsl:attribute>
				<content type="footnote">
					<xsl:attribute name="footnote_number">%_ftn_num_%</xsl:attribute>
					<xsl:variable name="footnotetitle">
							<xsl:for-each select="descendant::CharacterStyleRange/Content | descendant::CharacterStyleRange/TextVariableInstance | descendant::CharacterStyleRange/Br">
								<xsl:choose>
									<xsl:when test="name() = 'Br'">+</xsl:when>
									<xsl:when test="name() = 'TextVariableInstance'">
										<xsl:choose>
											<xsl:when test="@ResultText">
												<xsl:value-of select="@ResultText/."/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:variable name="textvarID" select="@AssociatedTextVariable"/>
												<xsl:value-of select="/Documents/Document/TextVariable[@Self = $textvarID]/CustomTextVariablePreference/Properties/Contents"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<!-- normal text -->
									<xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>
					</xsl:variable>
					<footnote>
						<xsl:attribute name="title"><xsl:value-of select="locjs:clean_footnotetitle(string($footnotetitle))"/></xsl:attribute>
						<xsl:apply-templates select="ParagraphStyleRange" mode="articletext"/>
					</footnote>
				</content>
			</box></anchored_object>
	</xsl:template>

	<xsl:template match="Footnote" mode="articletext">
		<xsl:param name="level"/>
		<xsl:variable name="footnoteSequence"><xsl:value-of select="locjs:get_footnote_sequence()"/></xsl:variable>
		<xsl:variable name="footnoteID"><xsl:text>ftns_</xsl:text><xsl:value-of select="$footnoteSequence"/></xsl:variable>
		<xsl:variable name="footnoteNumber"><xsl:value-of select="locjs:get_footnote_number(true())"/></xsl:variable>
		<contentElem name="{name()}" render="inline"><xsl:text>&lt;?__anchored_object__ "</xsl:text><xsl:value-of select="$footnoteID"/><xsl:text>"?&gt;</xsl:text></contentElem>
		<!-- now find the prepared footnote in anchored_objects and replace the footnote number -->
		<xsl:variable name="d" select="locjs:add_footnote_number(string($footnoteID),string($footnoteNumber))"/>
	</xsl:template>


	<!-- prepare footnotes -->
	<xsl:template name="prepare_footnotes">
		<xsl:if test="/Documents/Document/Story/Story//Footnote"><!-- do only if we have footnotes -->
			<xsl:if test="$DEBUG = 1">
				<xsl:variable name="d" select="locjs:message('************** Preparing Footnotes **************')"/>
			</xsl:if>
			<xsl:variable name="d" select="myutils:showMess('&#10;   ++ Preparing Footnotes ','1')"/>
			<xsl:variable name="d" select="locjs:allow_footnote_numbering(1)"/>
			<xsl:variable name="d" select="locjs:reset_footnote_number(1)"/>
			<xsl:for-each select="/Documents/Document/Story/Story//Footnote">
				<xsl:variable name="footnoteSequence"><xsl:value-of select="locjs:get_footnote_sequence()"/></xsl:variable>
				<xsl:variable name="footnoteID"><xsl:text>ftns_</xsl:text><xsl:value-of select="$footnoteSequence"/></xsl:variable>
				<xsl:if test="locjs:store_anchored_object_anchorid(string($footnoteID)) = 0"><!-- store if not already stored -->
					<xsl:variable name="d06" select="locjs:init_articles()" /><!-- reset articles -->
					<xsl:variable name="footnotecontent">
						<xsl:call-template name="getFootnote">
							<xsl:with-param name="level">1</xsl:with-param>
							<xsl:with-param name="footnoteSequence"><xsl:value-of select="$footnoteSequence"/></xsl:with-param>
							<xsl:with-param name="footnoteID"><xsl:value-of select="$footnoteID"/></xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:variable name="footnotecontent_string1" select="myutils:serializeDOM(xalan:nodeset($footnotecontent),'0','yes')"/>
					<xsl:if test="$footnotecontent_string1 != ''">
						<xsl:if test="$DEBUG = 1"><xsl:variable name="d" select="locjs:message(concat('***********STORING footnote: ',$footnotecontent_string1))"/></xsl:if>
						<xsl:variable name="aop" select="locjs:store_anchored_objects_string(string($footnotecontent_string1))" />
						<xsl:if test="$DEBUG = 1"><xsl:variable name="d" select="locjs:message('************************STORING END')"/></xsl:if>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
		<xsl:variable name="d" select="locjs:reset_footnote_number(1)"/>
	</xsl:template>


	<!-- prepare hyper Text and URL links -->
	<xsl:template name="prepare_hypertext_links">
		<xsl:if test="/Documents/Document/Story/Story//HyperlinkTextSource"><!-- do only if we have HyperlinkTextSource -->
			<xsl:if test="$DEBUG = 1">
				<xsl:variable name="d" select="locjs:message('************** Preparing Text and URL Links **************')"/>
			</xsl:if>
			<xsl:variable name="d" select="myutils:showMess('&#10;   ++ Preparing Text and URL Links ','1')"/>

			<xsl:for-each select="/Documents/Document/Story/Story"><!-- for each Hyper Link URL source -->
				<xsl:variable name="TOCstyle"><!-- in non empty or not 'n', this is the TOC -->
					<xsl:choose>
						<xsl:when test="@AppliedTOCStyle and (@AppliedTOCStyle != 'n')" ><xsl:value-of select="@AppliedTOCStyle" /></xsl:when>
					</xsl:choose>
				</xsl:variable>
				<xsl:for-each select="descendant::HyperlinkTextSource"><!-- for each Hyper Link URL source -->
					<xsl:variable name="HyperlinkTextSource_Self" select="@Self"/>
					<xsl:variable name="HyperlinkTextSource_Name" select="@Name"/>
					<xsl:variable name="HyperlinkTextSource_Hidden" select="@Hidden"/>
					<xsl:variable name="HyperlinkTextSource_AppliedCharacterStyle" select="@AppliedCharacterStyle"/>
					<xsl:variable name="HyperlinkDestination_UniqueKey" select="/Documents/Document/Hyperlink[@Source = $HyperlinkTextSource_Self]/@DestinationUniqueKey/."/>
					<xsl:variable name="HyperlinkDestination_Self" select="/Documents/Document/Hyperlink[@Source = $HyperlinkTextSource_Self]/Properties/Destination[@type='object']/."/>
					<xsl:variable name="HyperlinkExternalPageDestination_Self" select="/Documents/Document/HyperlinkExternalPageDestination[@Self = $HyperlinkDestination_Self]/@Self"/>
					<xsl:variable name="HyperlinkExternalPageDestination_Name" select="/Documents/Document/HyperlinkExternalPageDestination[@Self = $HyperlinkDestination_Self]/@Name"/><!-- external document name -->
					<xsl:variable name="HyperlinkExternalPageDestination_PageIndex" select="/Documents/Document/HyperlinkExternalPageDestination[@Self = $HyperlinkDestination_Self]/@DestinationPageIndex"/>
					<xsl:variable name="HyperlinkExternalPageDestination_DocPath" select="/Documents/Document/HyperlinkExternalPageDestination[@Self = $HyperlinkDestination_Self]/@DocumentPath"/>
					<xsl:variable name="HyperlinkTextDestination_StoryID" select="/Documents/Document/Story/Story[descendant::HyperlinkTextDestination/@Self = $HyperlinkDestination_Self]/@Self"/>
					<xsl:variable name="HyperlinkDestination_Document" select="/Documents/Document/Hyperlink[@Source = $HyperlinkTextSource_Self]/Properties/Destination[@type='list']/ListItem[position() = 1]/."/>
					<xsl:variable name="HyperlinkDestination_PageSelf" select="/Documents/Document/HyperlinkPageDestination[@Self = $HyperlinkDestination_Self]/@DestinationPage/."/>
					<xsl:variable name="HyperlinkDestination_PageName" select="/Documents/Document//Spread/Spread//Page[@Self = $HyperlinkDestination_PageSelf]/@Name"/>

					<xsl:variable name="anchorid">
						<xsl:choose>
							<xsl:when test="$HyperlinkDestination_Document != ''">
								<xsl:value-of select="concat($HyperlinkDestination_Document,'#linkref_',$HyperlinkDestination_UniqueKey)"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="concat('linkref_',$HyperlinkDestination_UniqueKey)"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
	
					<xsl:if test="locjs:store_anchored_object_anchorid(string($anchorid)) = 0"><!-- store if not already stored -->
						<xsl:variable name="content"><xsl:for-each select="descendant::Content"><xsl:value-of select="text()"/></xsl:for-each></xsl:variable>
	
						<xsl:variable name="d06" select="locjs:init_articles()" /><!-- reset articles -->
						<xsl:variable name="HyperlinkTextSourcecontent">
							<anchored_object name="HyperlinkTextSource">
								<xsl:attribute name="anchorid"><xsl:value-of select="$anchorid"/></xsl:attribute>
								<xsl:attribute name="idx"><xsl:value-of select="locjs:get_num_anchored_objects()" /></xsl:attribute>
								<xsl:attribute name="type">
									<xsl:choose>
										<xsl:when test="starts-with($HyperlinkDestination_Self,'HyperlinkURLDestination/')">HyperlinkURLSource</xsl:when>
										<xsl:when test="starts-with($HyperlinkDestination_Self,'HyperlinkTextDestination/')">HyperlinkTextSource</xsl:when>
										<xsl:when test="starts-with($HyperlinkDestination_Self,'HyperlinkPageDestination/')">HyperlinkPageDestination</xsl:when>
									</xsl:choose>
								</xsl:attribute>
								<xsl:attribute name="cont">
									<xsl:choose>
										<xsl:when test="starts-with($HyperlinkDestination_Self,'HyperlinkURLDestination/')">HyperlinkURLSource</xsl:when>
										<xsl:when test="starts-with($HyperlinkDestination_Self,'HyperlinkTextDestination/')">HyperlinkTextSource</xsl:when>
										<xsl:when test="starts-with($HyperlinkDestination_Self,'HyperlinkPageDestination/')">HyperlinkPageDestination</xsl:when>
									</xsl:choose>
								</xsl:attribute>

								<!--xsl:attribute name="HyperlinkDestination_Self"><xsl:value-of select="$HyperlinkDestination_Self"/></xsl:attribute--><!--DEBUG -->
								<xsl:if test="$HyperlinkTextDestination_StoryID != ''">
									<xsl:attribute name="destinationStoryID"><xsl:value-of select="$HyperlinkTextDestination_StoryID"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="$HyperlinkDestination_Document != ''">
									<xsl:attribute name="destinationDoc"><xsl:value-of select="$HyperlinkDestination_Document"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="$TOCstyle != ''">
									<xsl:attribute name="TOCstyle"><xsl:value-of select="$TOCstyle"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="$HyperlinkDestination_PageSelf != ''">
									<xsl:attribute name="destinationPageName"><xsl:value-of select="$HyperlinkDestination_PageName"/></xsl:attribute>
								</xsl:if>
				
								<xsl:variable name="destination">
									<xsl:choose>
										<xsl:when test="$HyperlinkDestination_Document != ''"><!-- a text anchor into other document -->
											<xsl:value-of select="$anchorid"/>
										</xsl:when>
										<xsl:when test="starts-with($HyperlinkDestination_Self,'HyperlinkTextDestination/')"><!-- a text anchor in same document -->
											<xsl:text>#</xsl:text><xsl:value-of select="$anchorid"/>
										</xsl:when>
										<xsl:when test="starts-with($HyperlinkDestination_Self,'HyperlinkURLDestination/')"><!-- an URL -->
											<xsl:value-of select="/Documents/Document/HyperlinkURLDestination[@DestinationUniqueKey = $HyperlinkDestination_UniqueKey]/@DestinationURL/."/>
										</xsl:when>
									</xsl:choose>
								</xsl:variable>
								<a>
									<xsl:choose>
										<xsl:when test="$TOCstyle != ''">
											<xsl:attribute name="class">TOCstyle</xsl:attribute>
											<xsl:attribute name="srcID"><xsl:value-of select="$HyperlinkTextSource_Self"/></xsl:attribute>
											<xsl:attribute name="destPageID"><xsl:value-of select="$HyperlinkDestination_PageSelf"/></xsl:attribute>
											<xsl:if test="$HyperlinkExternalPageDestination_Self != ''">
												<xsl:attribute name="ext_destPageID"><xsl:value-of select="$HyperlinkExternalPageDestination_Self"/></xsl:attribute>
												<xsl:attribute name="ext_destPageName"><xsl:value-of select="$HyperlinkExternalPageDestination_Name"/></xsl:attribute>
												<xsl:attribute name="ext_destPageIdx"><xsl:value-of select="$HyperlinkExternalPageDestination_PageIndex"/></xsl:attribute>
												<xsl:attribute name="ext_destDocPath"><xsl:value-of select="$HyperlinkExternalPageDestination_DocPath"/></xsl:attribute>
											</xsl:if>
										</xsl:when>
									</xsl:choose>
									<xsl:attribute name="targetPageName"><xsl:value-of select="$HyperlinkDestination_PageName"/></xsl:attribute>
									<xsl:attribute name="href"><xsl:value-of select="$destination"/></xsl:attribute>
									<xsl:attribute name="title"><xsl:value-of select="$content"/></xsl:attribute>
									<xsl:if test="$HyperlinkTextDestination_StoryID != ''">
										<xsl:attribute name="data-destinationStoryID"><xsl:value-of select="$HyperlinkTextDestination_StoryID"/></xsl:attribute>
									</xsl:if>
									<xsl:value-of select="$content"/>
								</a></anchored_object>
						</xsl:variable>
						<xsl:variable name="HyperlinkTextSourcecontent_string1" select="myutils:serializeDOM(xalan:nodeset($HyperlinkTextSourcecontent),'0','yes')"/>
						<xsl:if test="$HyperlinkTextSourcecontent_string1 != ''">
							<xsl:if test="$DEBUG = 1"><xsl:variable name="d" select="locjs:message(concat('***********STORING HyperlinkTextSource: ',$HyperlinkTextSourcecontent_string1))"/></xsl:if>
							<xsl:variable name="aop" select="locjs:store_anchored_objects_string(string($HyperlinkTextSourcecontent_string1))" />
							<xsl:if test="$DEBUG = 1"><xsl:variable name="d" select="locjs:message('************************STORING END')"/></xsl:if>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>






	<!-- ===============================================
		 the Story content
	     =============================================== -->
	<xsl:template match="Story">
		<xsl:param name="groupid"/>
		<xsl:param name="themode"/>
		<xsl:param name="caller_txtf"/>
		<xsl:param name="coords"/>
		<xsl:param name="textflow_id"/>
		<xsl:param name="label"/>
		<xsl:if test="@Self = $textflow_id">
			<xsl:variable name="d" select="locjs:reset_articleruns()"/>
			<xsl:if test="$themode = 1"><!-- get formatted text -->
				<!--===Story mode: <xsl:value-of select="$themode"/>, Self: <xsl:value-of select="@Self"/>, textflow_id: <xsl:value-of select="$textflow_id"/>===-->
				<xsl:variable name="XMLElementSelf"><!-- has contained Story a custom XMLElement as direct child? Then, the stoy box is marked-->
					<xsl:choose>
						<xsl:when test="locjs:get_includeXMLtags() = '0'"></xsl:when>
						<xsl:when test="XMLElement">
							<xsl:value-of select="XMLElement/@Self/."/>
						</xsl:when>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="XMLElementMarkupTag">
					<xsl:if test="$XMLElementSelf != ''">
						<xsl:value-of select="substring-after(XMLElement/@MarkupTag/.,'/')"/>
					</xsl:if>
				</xsl:variable>
				<xsl:variable name="XMLElementXMLContent">
					<xsl:if test="$XMLElementSelf != ''">
						<xsl:value-of select="XMLElement/@XMLContent/."/>
					</xsl:if>
				</xsl:variable>
				<xsl:variable name="XMLElementAttributes">
					<xsl:if test="$XMLElementSelf != ''">
						<xsl:call-template name="getXMLElementAttributes"><xsl:with-param name="elem" select="XMLElement"/></xsl:call-template>
					</xsl:if>
				</xsl:variable>
				<content type="text">
					<xsl:attribute name="Self"><xsl:value-of select="@Self"/></xsl:attribute>
					<xsl:attribute name="id"><xsl:value-of select="$textflow_id"/></xsl:attribute>
					<xsl:attribute name="groupid"><xsl:value-of select="$groupid"/></xsl:attribute>
					<xsl:variable name="TOCStyle">
						<xsl:if test="@AppliedTOCStyle and (@AppliedTOCStyle != 'n') and (@AppliedTOCStyle != '')"><!-- this is the TOC story -->
							<xsl:value-of select="@AppliedTOCStyle"/>
						</xsl:if>
					</xsl:variable>
					<xsl:if test="$TOCStyle != ''"><!-- this is the TOC story -->
						<xsl:attribute name="toc"><xsl:value-of select="$TOCStyle"/></xsl:attribute>
					</xsl:if>
					<xsl:attribute name="label"><xsl:value-of select="$label"/></xsl:attribute>
					<xsl:if test="(locjs:get_includeXMLtags() != '0' ) and ($XMLElementSelf != '')">
						<xsl:attribute name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:attribute>
						<xsl:attribute name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:attribute>
						<xsl:if test="$XMLElementXMLContent != ''"><xsl:attribute name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:attribute></xsl:if>
						<xsl:if test="$XMLElementAttributes != ''"><xsl:attribute name="XMLElementAttributes"><xsl:value-of select="$XMLElementAttributes"/></xsl:attribute></xsl:if>
					</xsl:if>
					<!-- a story can contain any elements like text or anchored objects: ParagraphStyleRange,XMLElement,XMLInstruction,Rectangle,Textframe -->
					<!--xsl:apply-templates select="ParagraphStyleRange | Change[@ChangeType!='DeletedText'] | XMLElement | XMLInstruction | HyperlinkTextSource" mode="articletext"-->
					<xsl:apply-templates select="Change[@ChangeType!='DeletedText'] | *" mode="articletext">
						<xsl:with-param name="TOCStyle"><xsl:value-of select="$TOCStyle" /></xsl:with-param>
					</xsl:apply-templates>

					<!-- we have read all paras: output -->
					<xsl:if test="locjs:get_anchoredobjects_mode() = 0">
						<xsl:if test="$DEBUG = 1">
							<xsl:variable name="d" select="locjs:print_articleruns()"/>
							<xsl:variable name="d" select="locjs:message(concat('** num_articleruns: ',locjs:get_num_articleruns()))"/>
						</xsl:if>
						<xsl:value-of select="locjs:call_output_articleruns()" disable-output-escaping="yes"/>
						<xsl:variable name="d" select="locjs:reset_articleruns()"/>
					</xsl:if>
				</content>
			</xsl:if>

			<xsl:if test="($themode = 2) and (number($textshortcutLength) > 0)"><!-- get plain text for floater -->
					<xsl:for-each select="descendant::ParagraphStyleRange">
						<xsl:variable name="textshortcut">
							<xsl:for-each select="descendant::Content | CharacterStyleRange/TextVariableInstance | CharacterStyleRange/Br">
								<xsl:choose>
									<xsl:when test="ancestor::HiddenText"></xsl:when>
									<xsl:when test="ancestor::Change/@ChangeType = 'DeletedText'"></xsl:when><!-- WoodWing parent element 'Change' ? -->
									<xsl:when test="name() = 'Br'">+</xsl:when>
									<xsl:when test="name() = 'TextVariableInstance'">
										<xsl:choose>
											<xsl:when test="@ResultText">
												<xsl:value-of select="@ResultText/."/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:variable name="textvarID" select="@AssociatedTextVariable"/>
												<xsl:value-of select="/Documents/Document/TextVariable[@Self = $textvarID]/CustomTextVariablePreference/Properties/Contents"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<!-- normal text from Content element -->
									<xsl:otherwise>
										<xsl:value-of select="."/>
										<xsl:choose>
											<xsl:when test="name(../../..) = 'Cell'">
												<xsl:text>&#09;</xsl:text>
											</xsl:when>
											<xsl:otherwise>
												<xsl:if test="locjs:endsWith(.,' ') = false()"><xsl:text> </xsl:text></xsl:if>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>
						</xsl:variable>
						<xsl:variable name="d"><xsl:value-of select="locjs:store_textshortcut(string($textshortcut))"/></xsl:variable>
					</xsl:for-each>
				<!--xsl:variable name="d"><xsl:value-of select="locjs:store_textshortcut(string($textshortcut))"/></xsl:variable-->
				<textshortcut><xsl:value-of select="locjs:get_textshortcut()"/></textshortcut>
			</xsl:if>
		</xsl:if>
	</xsl:template>



	<!-- ===============================================
		 the XMElement
		 =============================================== -->
	<xsl:template match="XMLElement" mode="articletext">
		<xsl:param name="anchorID"/>
		<xsl:choose>
			<xsl:when test="locjs:get_includeXMLtags() = '0'">
				<xsl:apply-templates mode="articletext">
					<xsl:with-param name="anchorid"><xsl:value-of select="$anchorID" /></xsl:with-param>
					<xsl:with-param name="XMLElementSelf"/>
					<xsl:with-param name="XMLElementMarkupTag"/>
					<xsl:with-param name="XMLElementXMLContent"/>
					<xsl:with-param name="XMLElementAttributes"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:when test="name(..) = 'Story'">
				<!--
				<xmlElement>
					<xsl:if test="$DEBUG = 1">
						<xsl:attribute name="parentName"><xsl:value-of select="locjs:safe_attr(locjs:cleanSeparator(string(name(..))))"/></xsl:attribute>
						<xsl:attribute name="parentSelf"><xsl:value-of select="locjs:safe_attr(locjs:cleanSeparator(string(../@Self)))"/></xsl:attribute>
					</xsl:if>
					<xsl:for-each select="@*">
						<xsl:attribute name="{locjs:stripNameSpaceColon(name())}"><xsl:value-of select="locjs:safe_attr(locjs:cleanSeparator(string(.)))"/></xsl:attribute>
					</xsl:for-each>
					<xsl:for-each select="XMLAttribute">
						<xsl:attribute name="{locjs:stripNameSpaceColon(string(@Name))}"><xsl:value-of select="locjs:safe_attr(locjs:cleanSeparator(string(@Value)))"/></xsl:attribute>
					</xsl:for-each>
				-->
					<xsl:apply-templates mode="articletext">
						<xsl:with-param name="anchorid"><xsl:value-of select="$anchorID" /></xsl:with-param>
						<xsl:with-param name="XMLElementSelf"><xsl:value-of select="@Self"/></xsl:with-param>
						<xsl:with-param name="XMLElementMarkupTag"><xsl:value-of select="@MarkupTag"/></xsl:with-param>
						<xsl:with-param name="XMLElementXMLContent"><xsl:value-of select="@XMLContent"/></xsl:with-param>
						<xsl:with-param name="XMLElementAttributes"><xsl:call-template name="getXMLElementAttributes"><xsl:with-param name="elem" select="."/></xsl:call-template></xsl:with-param>
					</xsl:apply-templates>
				<!--
				</xmlElement>
				-->
			</xsl:when>
			<xsl:when test="locjs:now_processing_tablecell() > 0"><!-- when in a table cell -->
				<xsl:choose>
					<xsl:when test="name(..) = 'Cell'"><!-- when in a table cell, we process the direct XMLElement child only -->
						<!--
						<xsl:text>&lt;__xmlElement__</xsl:text>
							<xsl:if test="$DEBUG = 1">
								<xsl:text> parentName="</xsl:text><xsl:value-of disable-output-escaping="yes" select="locjs:safe_attr(locjs:cleanSeparator(string(name(..))))"/><xsl:text>"</xsl:text>
								<xsl:text> parentSelf="</xsl:text><xsl:value-of disable-output-escaping="yes" select="locjs:safe_attr(locjs:cleanSeparator(string(../@Self)))"/><xsl:text>"</xsl:text>
							</xsl:if>
							<xsl:for-each select="@*">
									<xsl:text> </xsl:text><xsl:value-of disable-output-escaping="yes" select="locjs:stripNameSpaceColon(name())"/><xsl:text>="</xsl:text><xsl:value-of select="locjs:safe_attr(locjs:cleanSeparator(string(.)))"/><xsl:text>"</xsl:text>
							</xsl:for-each>
							<xsl:for-each select="XMLAttribute">
								<xsl:text> </xsl:text><xsl:value-of disable-output-escaping="yes" select="locjs:stripNameSpaceColon(string(@Name))"/><xsl:text>="</xsl:text><xsl:value-of select="locjs:safe_attr(locjs:cleanSeparator(string(@Value)))"/><xsl:text>"</xsl:text>
							</xsl:for-each>
						<xsl:text>/__xmlElementEND__&gt;</xsl:text>
						-->
							<xsl:apply-templates mode="articletext">
								<xsl:with-param name="anchorid"><xsl:value-of select="$anchorID" /></xsl:with-param>
								<xsl:with-param name="XMLElementSelf"><xsl:value-of select="@Self"/></xsl:with-param>
								<xsl:with-param name="XMLElementMarkupTag"><xsl:value-of select="@MarkupTag"/></xsl:with-param>
								<xsl:with-param name="XMLElementXMLContent"><xsl:value-of select="@XMLContent"/></xsl:with-param>
								<xsl:with-param name="XMLElementAttributes"><xsl:call-template name="getXMLElementAttributes"><xsl:with-param name="elem" select="."/></xsl:call-template></xsl:with-param>
							</xsl:apply-templates>
						<!--
						<xsl:text>&lt;/__xmlElement__&gt;</xsl:text>
						-->
					</xsl:when>
					<xsl:otherwise>
						<!-- ???really??? currently suppress XMLElements within table cells because this produces non well formed XML -->
						<xsl:apply-templates mode="articletext">
							<xsl:with-param name="anchorid"><xsl:value-of select="$anchorID" /></xsl:with-param>
							<xsl:with-param name="XMLElementSelf"><xsl:value-of select="@Self"/></xsl:with-param>
							<xsl:with-param name="XMLElementMarkupTag"><xsl:value-of select="@MarkupTag"/></xsl:with-param>
							<xsl:with-param name="XMLElementXMLContent"><xsl:value-of select="@XMLContent"/></xsl:with-param>
							<xsl:with-param name="XMLElementAttributes"><xsl:call-template name="getXMLElementAttributes"><xsl:with-param name="elem" select="."/></xsl:call-template></xsl:with-param>
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
			<!--
				<contentElem name="{name()}" render="inline"><xsl:text>&lt;__xmlElement__</xsl:text>
					<xsl:if test="$DEBUG = 1">
						<xsl:text> parentName="</xsl:text><xsl:value-of disable-output-escaping="yes" select="locjs:safe_attr(locjs:cleanSeparator(string(name(..))))"/><xsl:text>"</xsl:text>
						<xsl:text> parentSelf="</xsl:text><xsl:value-of disable-output-escaping="yes" select="locjs:safe_attr(locjs:cleanSeparator(string(../@Self)))"/><xsl:text>"</xsl:text>
					</xsl:if>
					<xsl:for-each select="@*">
							<xsl:text> </xsl:text><xsl:value-of disable-output-escaping="yes" select="locjs:stripNameSpaceColon(name())"/><xsl:text>="</xsl:text><xsl:value-of select="locjs:safe_attr(locjs:cleanSeparator(string(.)))"/><xsl:text>"</xsl:text>
					</xsl:for-each>
					<xsl:for-each select="XMLAttribute">
						<xsl:text> </xsl:text><xsl:value-of disable-output-escaping="yes" select="locjs:stripNameSpaceColon(string(@Name))"/><xsl:text>="</xsl:text><xsl:value-of select="locjs:safe_attr(locjs:cleanSeparator(string(@Value)))"/><xsl:text>"</xsl:text>
					</xsl:for-each>
				<xsl:text>/__xmlElementEND__&gt;</xsl:text></contentElem>
				-->
					<xsl:apply-templates mode="articletext">
						<xsl:with-param name="anchorid"><xsl:value-of select="$anchorID" /></xsl:with-param>
						<xsl:with-param name="XMLElementSelf"><xsl:value-of select="@Self"/></xsl:with-param>
						<xsl:with-param name="XMLElementMarkupTag"><xsl:value-of select="@MarkupTag"/></xsl:with-param>
						<xsl:with-param name="XMLElementXMLContent"><xsl:value-of select="@XMLContent"/></xsl:with-param>
						<xsl:with-param name="XMLElementAttributes"><xsl:call-template name="getXMLElementAttributes"><xsl:with-param name="elem" select="."/></xsl:call-template></xsl:with-param>
					</xsl:apply-templates>
				<!--
				<contentElem name="{name()}" render="inline"><xsl:text>&lt;/__xmlElement__&gt;</xsl:text></contentElem>
				-->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- ===============================================
		 the XMElement attributes string (serialized attributes)
		 =============================================== -->
	<xsl:template name="getXMLElementAttributes">
		<xsl:param name="elem"/>
		<xsl:if test="name($elem) = 'XMLElement'">
			<xsl:for-each select="$elem/@*">
				<xsl:if test="(name() != 'Self') and (name() != 'MarkupTag') and (name() != 'XMLContent')"><!-- these have their own attrib nodes -->
					<xsl:value-of disable-output-escaping="yes" select="locjs:stripNameSpaceColon(name())"/><xsl:text disable-output-escaping="yes">=</xsl:text><xsl:value-of select="locjs:safe_attr(locjs:cleanSeparator(string(.)))"/><xsl:text disable-output-escaping="yes">/\\/</xsl:text>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="$elem/XMLAttribute">
				<xsl:value-of disable-output-escaping="yes" select="locjs:stripNameSpaceColon(string(@Name))"/><xsl:text disable-output-escaping="yes">=</xsl:text><xsl:value-of select="locjs:safe_attr(locjs:cleanSeparator(string(@Value)))"/><xsl:text disable-output-escaping="yes">/\\/</xsl:text>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>


	<!-- ===============================================
		 the XMLInstruction
	     =============================================== -->
	<xsl:template match="XMLInstruction" mode="articletext">
		<xsl:if test="locjs:get_includeXMLtags() != '0'">
			<contentElem name="{name()}" render="inline"><xsl:text>&lt;__xmlInstruction__</xsl:text>
				<xsl:for-each select="@*">
					<xsl:if test="name() != 'Self'">
						<xsl:text> </xsl:text><xsl:value-of select="name()"/><xsl:text>="</xsl:text><xsl:value-of disable-output-escaping="yes" select="locjs:safe_attr(locjs:cleanSeparator(string(.)))"/><xsl:text>"</xsl:text>
					</xsl:if>
				</xsl:for-each>
			<xsl:text>/__xmlInstructionEND__&gt;</xsl:text></contentElem>
		</xsl:if>
	</xsl:template>


	<!-- ===============================================
		 conditional hidden text
	     =============================================== -->
	<xsl:template match="HiddenText" mode="articletext">
		<xsl:param name="XMLElementSelf"/>
		<xsl:param name="XMLElementMarkupTag"/>
		<xsl:param name="XMLElementXMLContent"/>
		<xsl:param name="XMLElementAttributes"/>
		<xsl:param name="containerElement"/>

		<contentElem name="{name()}" render="inline">
			<xsl:copy-of select="."/>
		</contentElem>

	</xsl:template>



	<!-- ===============================================
		 get the article's paragraphs
	     =============================================== -->
	<xsl:template match="ParagraphStyleRange" mode="articletext">
		<xsl:param name="XMLElementSelf"/>
		<xsl:param name="XMLElementMarkupTag"/>
		<xsl:param name="XMLElementXMLContent"/>
		<xsl:param name="XMLElementAttributes"/>
		<xsl:param name="containerElement"/>
		<!--xsl:apply-templates select="CharacterStyleRange | Change[@ChangeType!='DeletedText'] | XMLElement | XMLInstruction | HyperlinkTextSource | CrossReferenceSource" mode="articletext"-->
		<xsl:apply-templates mode="articletext">
			<xsl:with-param name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:with-param>
			<xsl:with-param name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:with-param>
			<xsl:with-param name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:with-param>
			<xsl:with-param name="XMLElementAttributes"><xsl:value-of select="$XMLElementAttributes"/></xsl:with-param>
			<xsl:with-param name="containerElement"><xsl:value-of select="name()"/></xsl:with-param>
		</xsl:apply-templates>

		<xsl:if test="locjs:get_anchoredobjects_mode() = 1">
			<xsl:if test="$DEBUG = 1">
				<xsl:variable name="d" select="locjs:print_articleruns()"/>
				<xsl:variable name="d" select="locjs:message(concat('** num_articleruns: ',locjs:get_num_articleruns()))"/>
			</xsl:if>
			<xsl:value-of select="locjs:call_output_articleruns()" disable-output-escaping="yes"/>
			<xsl:variable name="d" select="locjs:reset_articleruns()"/>
		</xsl:if>
	</xsl:template>


	<!-- a CrossReferenceSource can have as parent element: Story, ParagraphStyleRange, CharacterStyleRange -->
	<xsl:template match="CrossReferenceSource" mode="articletext">
		<xsl:param name="XMLElementSelf"/>
		<xsl:param name="XMLElementMarkupTag"/>
		<xsl:param name="XMLElementXMLContent"/>
		<xsl:param name="XMLElementAttributes"/>
		<xsl:param name="containerElement"/>
		<xsl:apply-templates select="*" mode="articletext">
			<xsl:with-param name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:with-param>
			<xsl:with-param name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:with-param>
			<xsl:with-param name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:with-param>
			<xsl:with-param name="XMLElementAttributes"><xsl:value-of select="$XMLElementAttributes"/></xsl:with-param>
			<xsl:with-param name="containerElement"><xsl:value-of select="name()"/></xsl:with-param>
		</xsl:apply-templates>
	</xsl:template>


	<!-- a HyperlinkTextSource can have as parent element: Story, ParagraphStyleRange, CharacterStyleRange -->
	<xsl:template match="HyperlinkTextSource" mode="articletext">
		<xsl:param name="XMLElementSelf"/>
		<xsl:param name="XMLElementMarkupTag"/>
		<xsl:param name="XMLElementXMLContent"/>
		<xsl:param name="XMLElementAttributes"/>
		<xsl:param name="containerElement"/>

		<xsl:variable name="id">
			<xsl:variable name="HyperlinkTextSource_Self" select="@Self"/>
			<xsl:variable name="HyperlinkDestination_UniqueKey" select="/Documents/Document/Hyperlink[@Source = $HyperlinkTextSource_Self]/@DestinationUniqueKey/."/>
			<xsl:variable name="HyperlinkDestination_Document">
				<xsl:if test="/Documents/Document/Hyperlink[@Source = $HyperlinkTextSource_Self]/Properties/Destination[@type='list']/ListItem[position() = 1]">
					<xsl:value-of select="/Documents/Document/Hyperlink[@Source = $HyperlinkTextSource_Self]/Properties/Destination[@type='list']/ListItem[position() = 1]/."/>
				</xsl:if>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="$HyperlinkDestination_Document != ''">
					<xsl:value-of select="concat($HyperlinkDestination_Document,'#linkref_',$HyperlinkDestination_UniqueKey)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat('linkref_',$HyperlinkDestination_UniqueKey)"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="appliedParagraphStyle">
			<xsl:choose>
				<xsl:when test="../@AppliedParagraphStyle"><xsl:value-of select="../@AppliedParagraphStyle"/></xsl:when>
				<xsl:when test="../../@AppliedParagraphStyle"><xsl:value-of select="../../@AppliedParagraphStyle"/></xsl:when>
				<xsl:when test="../../../@AppliedParagraphStyle"><xsl:value-of select="../../../@AppliedParagraphStyle"/></xsl:when>
				<xsl:when test="../../../../@AppliedParagraphStyle"><xsl:value-of select="../../../../@AppliedParagraphStyle"/></xsl:when>
				<xsl:when test="../../../../../@AppliedParagraphStyle"><xsl:value-of select="../../../../../@AppliedParagraphStyle"/></xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$DEBUG = 1">
			<xsl:variable name="d0a" select="locjs:message(concat('****** anchored object id: ',$id))"/>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="name(..) = 'CharacterStyleRange'">
				<!--xsl:variable name="d" select="locjs:message(concat('****** RETURNING HyperlinkTextSource: ',$id))"/-->
					<contentElem name="{name()}" render="inline">
						<xsl:if test="(locjs:get_includeXMLtags() != '0' ) and ($XMLElementSelf != '')">
							<xsl:attribute name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:attribute>
							<xsl:attribute name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:attribute>
							<xsl:attribute name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:attribute>
							<xsl:attribute name="XMLElementAttributes"><xsl:value-of select="$XMLElementAttributes"/></xsl:attribute>
						</xsl:if>
						<xsl:text>&lt;?__anchored_object__ "</xsl:text><xsl:value-of select="$id"/><xsl:text>"?&gt;</xsl:text>
					</contentElem>
			</xsl:when>
			<xsl:when test="(name(..) != 'Story')">
				<!--xsl:variable name="d" select="locjs:message(concat('****** FORWARDING HyperlinkTextSource: ',$id))"/-->
				<xsl:variable name="callerContent">
					<contentElem name="{name()}" render="inline">
						<xsl:if test="(locjs:get_includeXMLtags() != '0' ) and ($XMLElementSelf != '')">
							<xsl:attribute name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:attribute>
							<xsl:attribute name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:attribute>
							<xsl:attribute name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:attribute>
							<xsl:attribute name="XMLElementAttributes"><xsl:value-of select="$XMLElementAttributes"/></xsl:attribute>
						</xsl:if>
						<xsl:text>&lt;?__anchored_object__ "</xsl:text><xsl:value-of select="$id"/><xsl:text>"?&gt;</xsl:text>
					</contentElem>
				</xsl:variable>
				<xsl:call-template name="simulateCharacterStyleRange">
					<xsl:with-param name="containerElement"></xsl:with-param><!-- take from contentElem/@name -->
					<xsl:with-param name="callerContent"><xsl:copy-of select="$callerContent"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!--xsl:variable name="d" select="locjs:message(concat('****** STORED HyperlinkTextSource: ',$id))"/-->
				<xsl:variable name="content"><xsl:text>&amp;lt;?__anchored_object__ "</xsl:text><xsl:value-of select="$id"/><xsl:text>"?&amp;gt;</xsl:text></xsl:variable>
				<xsl:call-template name="simple_store_textrun">
					<xsl:with-param name="appliedParagraphStyle"><xsl:value-of select="$appliedParagraphStyle"/></xsl:with-param>
					<xsl:with-param name="content"><xsl:value-of disable-output-escaping="yes" select="$content"/></xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


	<!-- this contains text and evtl. processing-instructions for anchored boxes -->
	<xsl:template match="CharacterStyleRange" name="simulateCharacterStyleRange" mode="articletext">
		<xsl:param name="XMLElementSelf"/>
		<xsl:param name="XMLElementMarkupTag"/>
		<xsl:param name="XMLElementXMLContent"/>
		<xsl:param name="XMLElementAttributes"/>
		<xsl:param name="containerElement"/>
		<xsl:param name="callerContent"/><!-- NOT EMPTY, when called from other element like 'HyperlinkTextSource' to store a text run -->
		<xsl:variable name="d" select="locjs:store_pageNumberType(string(@PageNumberType))"/>
		<xsl:variable name="position">
			<xsl:choose>
				<xsl:when test="name(..) != 'ParagraphStyleRange'"></xsl:when><!-- unsure position() -->
				<xsl:otherwise><xsl:value-of select="position()"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="last" select="last()"/>
		<xsl:variable name="runtype">
			<xsl:choose>
				<xsl:when test="name(..) = 'ParagraphStyleRange'">
					<xsl:choose>
						<xsl:when test="(position() = 1) and (position() = last())">3</xsl:when><!-- paragraph start and end -->
						<xsl:when test="(position() = last())">2</xsl:when><!-- paragraph end -->
						<xsl:when test="(position() = 1)">1</xsl:when><!-- paragraph start -->
						<xsl:otherwise>0</xsl:otherwise><!-- inline text run -->
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>0</xsl:otherwise><!-- inline text run -->
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="conditionalTextSelf"><xsl:value-of select="@AppliedConditions"/></xsl:variable>
		<xsl:variable name="content_raw">
			<xsl:choose>
				<xsl:when test="$callerContent != ''">
					<xsl:copy-of select="$callerContent"/>
				</xsl:when>
				<xsl:otherwise>
					<!--xsl:apply-templates select="Content | Change[@ChangeType!='DeletedText'] | Group | Br | TextFrame | Rectangle | Oval | Polygon | Table 
										| HyperlinkTextSource | HyperlinkTextDestination | Footnote | Note 
										| TextVariableInstance | XMLElement | XMLInstruction" mode="articletext"--><!-- all these elements might appear in CharacterStyleRange as anchored objects -->
																	<!-- Change is hystory element when using WoodWing like: CharacterStyleRange/Change/Content -->
					<xsl:apply-templates mode="articletext">
						<xsl:with-param name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:with-param>
						<xsl:with-param name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:with-param>
						<xsl:with-param name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:with-param>
						<xsl:with-param name="XMLElementAttributes"><xsl:value-of select="$XMLElementAttributes"/></xsl:with-param>
						<xsl:with-param name="position"><xsl:value-of select="position()"/></xsl:with-param>
						<xsl:with-param name="last"><xsl:value-of select="last()"/></xsl:with-param>
					</xsl:apply-templates>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$DEBUG = 1"><xsl:variable name="d0a" select="locjs:message(concat('****** content_raw: ',$content_raw))"/></xsl:if>

		<xsl:variable name="containerElementName">
			<xsl:choose>
				<xsl:when test="$containerElement != ''"><xsl:value-of select="$containerElement"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="xalan:nodeset($content_raw)/contentElem/@name"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!--xsl:if test="$callerContent != ''"><xsl:variable name="d" select="locjs:message(concat('****** IS FORWARDED by ',$containerElementName,': ',myutils:serializeDOMls(xalan:nodeset($content_raw),'0','yes')))"/></xsl:if-->
		<xsl:variable name="render"><xsl:value-of select="xalan:nodeset($content_raw)/contentElem/@render"/></xsl:variable>
		<!-- given as parameters
		<xsl:variable name="XMLElementSelf"><xsl:value-of select="xalan:nodeset($content_raw)/contentElem/@XMLElementSelf"/></xsl:variable>
		<xsl:variable name="XMLElementMarkupTag"><xsl:value-of select="xalan:nodeset($content_raw)/contentElem/@XMLElementMarkupTag"/></xsl:variable>
		<xsl:variable name="XMLElementXMLContent"><xsl:value-of select="xalan:nodeset($content_raw)/contentElem/@XMLElementXMLContent"/></xsl:variable>
		<xsl:variable name="XMLElementAttributes"><xsl:value-of select="xalan:nodeset($content_raw)/contentElem/@XMLElementAttributes"/></xsl:variable>
		-->
		<xsl:variable name="containerElementContent">
			<xsl:for-each select="xalan:nodeset($content_raw)/*"><!-- containes <containerElem> -->
				<xsl:apply-templates select="* | @* | comment() | processing-instruction() | text()" mode="copy_object"/>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="content">
			<xsl:choose>
				<xsl:when test="($preconvertTextFlags != '') and ($preconvertTextFlags != '0')">
					<xsl:value-of select="pubjs:strconv_pre(myutils:serializeDOMls(xalan:nodeset($containerElementContent),'0','yes'))"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="myutils:serializeDOMls(xalan:nodeset($containerElementContent),'0','yes')"/>
					<!--xsl:value-of select="$containerElementContent"/-->
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$DEBUG = 1"><xsl:variable name="d0a" select="locjs:message(concat('****** content: ',$content))"/></xsl:if>


		<!-- test if we have a 'wwwLink' class in this textrun from a defined style sheet name -->
		<xsl:variable name="wwwlink">
			<xsl:if test="locjs:is_wwwLink_style(string(@AppliedCharacterStyle))">
				<xsl:for-each select="Content/text()"><xsl:value-of select="."/></xsl:for-each>
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="urllink">
		</xsl:variable>

		<!-- get current font from element CharacterStyleRange attributes AppliedFont and FontStyle, if not available then get from style -->
		<xsl:variable name="font_change" select="Properties/AppliedFont/."/>
		<xsl:variable name="main_font_style" select="@FontStyle"/>
		<xsl:variable name="fontName">
			<xsl:choose>
				<xsl:when test="$font_change != ''">
					<xsl:choose>
						<xsl:when test="/Documents/Document/Fonts/FontFamily[@Name = $font_change]">
							<xsl:choose>
								<xsl:when test="$main_font_style != ''">
									<xsl:value-of select="/Documents/Document/Fonts/FontFamily[@Name = $font_change]/Font[@FontStyleName = $main_font_style]/@Name"/>
								</xsl:when>
								<xsl:otherwise><xsl:value-of select="/Documents/Document/Fonts/FontFamily[@Name = $font_change]/Font/@Name"/></xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise><xsl:value-of select="$font_change"/></xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="name" select="locjs:get_style_fontName(string(@AppliedCharacterStyle))"/>
					<xsl:choose>
						<xsl:when test="$name != ''"><xsl:value-of select="$name"/></xsl:when><!-- get from char style -->
						<xsl:otherwise><xsl:value-of select="locjs:get_style_fontName(string(../../@AppliedParagraphStyle))"/></xsl:otherwise><!-- get from para style -->
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="fontNamePS">
			<xsl:choose>
				<xsl:when test="$font_change != ''">
					<xsl:choose>
						<xsl:when test="/Documents/Document/Fonts/FontFamily[@Name = $font_change]">
							<xsl:choose>
								<xsl:when test="$main_font_style != ''">
									<xsl:value-of select="locjs:plain_Name(string(/Documents/Document/Fonts/FontFamily[@Name = $font_change]/Font[@FontStyleName = $main_font_style]/@PostScriptName))"/>
								</xsl:when>
								<xsl:otherwise><xsl:value-of select="/Documents/Document/Fonts/FontFamily[@Name = $font_change]/Font/@Name"/></xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise><xsl:value-of select="$font_change"/></xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="name" select="locjs:get_style_fontNamePS(string(@AppliedCharacterStyle))"/>
					<xsl:choose>
						<xsl:when test="$name != ''"><xsl:value-of select="$name"/></xsl:when><!-- get from char style -->
						<xsl:otherwise><xsl:value-of select="locjs:get_style_fontNamePS(string(../@AppliedParagraphStyle))"/></xsl:otherwise><!-- get from para style -->
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="fontFamily">
			<xsl:choose>
				<xsl:when test="$font_change != ''"><xsl:value-of select="$font_change"/></xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="locjs:get_style_fontfamily(string(@AppliedCharacterStyle))"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
<!--
font_change:<xsl:value-of select="$font_change"/><br/>
main_font_style:<xsl:value-of select="$main_font_style"/><br/>
prst:<xsl:value-of select="../@AppliedParagraphStyle"/><br/>
crst:<xsl:value-of select="@AppliedCharacterStyle"/><br/>
fontName:<xsl:value-of select="$fontName"/><br/>
fontNamePS:<xsl:value-of select="$fontNamePS"/><br/>
fontFamily:<xsl:value-of select="$fontFamily"/><br/>
text:<xsl:value-of select="$content"/><br/>
-->

		<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
			<xsl:variable name="parasets">
				<xsl:value-of select="locjs:store_parasets( string(../@AppliedParagraphStyle), string(../@Justification), 
															string(../@LeftIndent), string(../@RightIndent), string(../@FirstLineIndent), string(../@LastLineIndent), 
															string(../@SpaceBefore), string(../@SpaceAfter), string(../@StartParagraph), 
															string(../@KeepWithNext), string(../@KeepLinesTogether), string(../@KeepWithPrevious), 
															string(../@DropCapCharacters), string(../@DropCapLines), string(../@DropcapDetail), 
															string(../@GridAlignment), string(../@Hyphenation))"/>
			</xsl:variable>

			<xsl:variable name="paratabs">
				<xsl:for-each select="../Properties/TabList/ListItem">
					<xsl:value-of select="Alignment"/>_<xsl:value-of select="AlignmentCharacter"/>_<xsl:value-of select="Leader"/>_<xsl:value-of select="Position"/>
					<xsl:if test="position() != last()"><xsl:text>/tab/</xsl:text></xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="name" select="locjs:store_paratabs(string($paratabs))"/>

			<xsl:variable name="paralist">
				<xsl:value-of select="locjs:store_paralist( string(../@BulletsAndNumberingListType), 
															string(../Properties/AppliedNumberingList), 
															string(../@NumberingLevel), 
															string(../Properties/NumberingFormat), 
															string(../@NumberingExpression), 
															string(../Properties/BulletsCharacterStyle), 
															string(../Properties/NumberingCharacterStyle), 
															string(../@NumberingStartAt), 
															string(../@NumberingContinue), 
															string(../@NumberingAlignment), 
															string(../@BulletsAlignment), 
															string(../Properties/BulletChar/@BulletCharacterValue),
															string(../@BulletsTextAfter)
															)"/>
			</xsl:variable>

			<xsl:variable name="pararules">
					<xsl:value-of select="locjs:store_pararules(string(../@RuleAbove),string(../Properties/RuleAboveType),string(../@RuleAboveLineWeight),string(../@RuleAboveWidth),string(../@RuleAboveOffset),string(../@RuleAboveLeftIndent),string(../@RuleAboveRightIndent),string(../@KeepRuleAboveInFrame),string(../Properties/RuleAboveColor),string(../@RuleAboveTint),string(../@RuleAboveOverprint),string(../Properties/RuleAboveGapColor),string(../@RuleAboveGapTint),string(../@RuleAboveGapOverprint),
																string(../@RuleBelow),string(../Properties/RuleBelowType),string(../@RuleBelowLineWeight),string(../@RuleBelowWidth),string(../@RuleBelowOffset),string(../@RuleBelowLeftIndent),string(../@RuleBelowRightIndent),string(../@KeepRuleBelowInFrame),string(../Properties/RuleBelowColor),string(../@RuleBelowTint),string(../@RuleBelowOverprint),string(../Properties/RuleBelowGapColor),string(../@RuleBelowGapTint),string(../@RuleBelowGapOverprint))"/>
			</xsl:variable>
		</xsl:if>

		<xsl:variable name="appliedParagraphStyle">
			<xsl:choose>
				<xsl:when test="../@AppliedParagraphStyle"><xsl:value-of select="../@AppliedParagraphStyle"/></xsl:when>
				<xsl:when test="../../@AppliedParagraphStyle"><xsl:value-of select="../../@AppliedParagraphStyle"/></xsl:when>
				<xsl:when test="../../../@AppliedParagraphStyle"><xsl:value-of select="../../../@AppliedParagraphStyle"/></xsl:when>
				<xsl:when test="../../../../@AppliedParagraphStyle"><xsl:value-of select="../../../../@AppliedParagraphStyle"/></xsl:when>
				<xsl:when test="../../../../../@AppliedParagraphStyle"><xsl:value-of select="../../../../../@AppliedParagraphStyle"/></xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="paragraphend" select="locjs:store_textrun(
																	string($containerElementName),
																	string($render),
																	string($position),
																	string($last),
																	string($runtype),
																	string($appliedParagraphStyle),
																	string(@AppliedCharacterStyle),
																	string(../@Justification),
																	string(../@SpaceBefore),
																	string(../@SpaceAfter),
																	string(../@LeftIndent),
																	string(../@RightIndent),
																	string(../@FirstLineIndent),
																	string($font_change),
																	string($fontFamily),
																	string($fontName),
																	string($fontNamePS),
																	string(@PointSize),
																	string(@FillColor),
																	string(@FillTint),
																	string(@FontStyle),
																	string(@Skew),
																	string(@Underline),
																	string(@Capitalization),
																	string(@Position),
																	string(@StrikeThru),
																	string($content),
																	locjs:clean(string($wwwlink)),
																	locjs:clean(string($urllink)),
																	string(@BaselineShift),
																	string(@HorizontalScale),
																	string(@VerticalScale),
																	string(Properties/Leading),
																	string(@KerningValue),
																	string(@NoBreak),
																	string(@Ligatures),
																	string(@Tracking),
																	string(@AppliedLanguage),
																	string($conditionalTextSelf),
																	string($XMLElementSelf),
																	string($XMLElementMarkupTag),
																	string($XMLElementXMLContent),
																	string($XMLElementAttributes)
																	)"/>

		<xsl:variable name="d" select="locjs:store_pageNumberType('')"/>
	</xsl:template>

	<xsl:template name="simple_store_textrun">
		<xsl:param name="appliedParagraphStyle"/>
		<xsl:param name="content"/>
		<xsl:variable name="paragraphend" select="locjs:store_textrun(
																	'',
																	'',
																	'',
																	'',
																	'',
																	string($appliedParagraphStyle),
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	string($content),
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	'',
																	''
																	)"/>

	</xsl:template>



	<!-- ===============================================
		 paragraph marker
	     =============================================== -->
	<xsl:template match="Br" mode="articletext"><contentElem name="{name()}" render="block">&#x2029;</contentElem></xsl:template>

	<xsl:template match="HyperlinkTextDestination" mode="articletext">
		<xsl:param name="XMLElementSelf"/>
		<xsl:param name="XMLElementMarkupTag"/>
		<xsl:param name="XMLElementXMLContent"/>
		<xsl:param name="XMLElementAttributes"/>
		<xsl:variable name="id">
			<xsl:choose>
				<xsl:when test="contains(@Self,'HyperlinkTextDestination/Bookmark')"><!-- this is a bookmark -->
					<xsl:value-of select="concat('bookmarkref_',@DestinationUniqueKey)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat('linkref_',@DestinationUniqueKey)"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="bookmarkname">
			<xsl:variable name="bmdest"><xsl:value-of select="@Self"/></xsl:variable>
			<xsl:if test="/Documents/Document/Bookmark[@Destination = $bmdest]"><!-- get bookmark -->
				<xsl:value-of select="/Documents/Document/Bookmark[@Destination = $bmdest]/@Name"/>
			</xsl:if>
		</xsl:variable>
		<contentElem name="{name()}" render="inline">
			<xsl:if test="(locjs:get_includeXMLtags() != '0' ) and ($XMLElementSelf != '')">
				<xsl:attribute name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:attribute>
				<xsl:attribute name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:attribute>
				<xsl:attribute name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:attribute>
				<xsl:attribute name="XMLElementAttributes"><xsl:value-of select="$XMLElementAttributes"/></xsl:attribute>
			</xsl:if>
			<a>
				<xsl:if test="$bookmarkname != ''">
					<xsl:attribute name="type">bookmark</xsl:attribute>
					<xsl:attribute name="title"><xsl:value-of select="$bookmarkname"/></xsl:attribute>
				</xsl:if>
				<xsl:attribute name="name"><xsl:value-of select="$id"/></xsl:attribute>
			</a>
		</contentElem>
	</xsl:template>

	<!-- This is to get anchored objects -->
	<xsl:template match="TextFrame | Rectangle | Group | Oval | Polygon | Button | Table" mode="articletext">
		<xsl:param name="XMLElementSelf"/>
		<xsl:param name="XMLElementMarkupTag"/>
		<xsl:param name="XMLElementXMLContent"/>
		<xsl:param name="XMLElementAttributes"/>
		<xsl:if test="$DEBUG = 1"><xsl:variable name="d0a" select="locjs:message(concat('****** anchored object name: ',name()))"/></xsl:if>
		<xsl:variable name="id">
			<xsl:value-of select="@Self"/>
		</xsl:variable>
		<xsl:if test="$DEBUG = 1">
			<xsl:variable name="d0a" select="locjs:message(concat('****** anchored object id: ',$id))"/>
		</xsl:if>
		<contentElem name="{name()}" render="inline">
			<xsl:if test="(locjs:get_includeXMLtags() != '0' ) and ($XMLElementSelf != '')">
				<xsl:attribute name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:attribute>
				<xsl:attribute name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:attribute>
				<xsl:attribute name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:attribute>
				<xsl:attribute name="XMLElementAttributes"><xsl:value-of select="$XMLElementAttributes"/></xsl:attribute>
			</xsl:if>
			<xsl:text>&lt;?__anchored_object__ "</xsl:text><xsl:value-of select="$id"/><xsl:text>"?&gt;</xsl:text>
		</contentElem>
	</xsl:template>




	<!-- 'Change' is element when using WoodWing like: CharacterStyleRange/Change/Content -->
	<xsl:template match="Change" mode="articletext">
		<xsl:param name="XMLElementSelf"/>
		<xsl:param name="XMLElementMarkupTag"/>
		<xsl:param name="XMLElementXMLContent"/>
		<xsl:param name="XMLElementAttributes"/>
		<xsl:param name="position"/>
		<xsl:param name="last"/>
		<!-- possible ChangeType: 'InsertedText', 'MovedText', 'DeletedText' -->
		<xsl:if test="@ChangeType!='DeletedText'">
			<xsl:apply-templates mode="articletext">
				<xsl:with-param name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:with-param>
				<xsl:with-param name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:with-param>
				<xsl:with-param name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:with-param>
				<xsl:with-param name="XMLElementAttributes"><xsl:value-of select="$XMLElementAttributes"/></xsl:with-param>
				<xsl:with-param name="position"><xsl:value-of select="$position"/></xsl:with-param>
				<xsl:with-param name="last"><xsl:value-of select="$last"/></xsl:with-param>
			</xsl:apply-templates>
		</xsl:if>
	</xsl:template>


	<xsl:template match="Content" mode="articletext">
		<xsl:param name="XMLElementSelf"/>
		<xsl:param name="XMLElementMarkupTag"/>
		<xsl:param name="XMLElementXMLContent"/>
		<xsl:param name="XMLElementAttributes"/>
		<contentElem name="{name()}" render="inline">
			<xsl:choose>
				<xsl:when test="(locjs:get_includeXMLtags() != '0' ) and (name(..) = 'XMLElement')">
					<!--
					<xsl:attribute name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:attribute>
					<xsl:attribute name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:attribute>
					<xsl:attribute name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:attribute>
					<xsl:attribute name="XMLElementAttributes"><xsl:value-of select="$XMLElementAttributes"/></xsl:attribute>
					-->
					<xsl:text>&lt;__xmlElement__</xsl:text>
						<xsl:if test="$DEBUG = 1">
							<xsl:text> parentName="</xsl:text><xsl:value-of disable-output-escaping="yes" select="locjs:safe_attr(locjs:cleanSeparator(string(name(..))))"/><xsl:text>"</xsl:text>
							<xsl:text> parentSelf="</xsl:text><xsl:value-of disable-output-escaping="yes" select="locjs:safe_attr(locjs:cleanSeparator(string(../@Self)))"/><xsl:text>"</xsl:text>
						</xsl:if>
						<xsl:for-each select="../@*">
								<xsl:text> </xsl:text><xsl:value-of disable-output-escaping="yes" select="locjs:stripNameSpaceColon(name())"/><xsl:text>="</xsl:text><xsl:value-of select="locjs:safe_attr(locjs:cleanSeparator(string(.)))"/><xsl:text>"</xsl:text>
						</xsl:for-each>
						<xsl:for-each select="../XMLAttribute">
							<xsl:text> </xsl:text><xsl:value-of disable-output-escaping="yes" select="locjs:stripNameSpaceColon(string(@Name))"/><xsl:text>="</xsl:text><xsl:value-of select="locjs:safe_attr(locjs:cleanSeparator(string(@Value)))"/><xsl:text>"</xsl:text>
						</xsl:for-each>
					<xsl:text>/__xmlElementEND__&gt;</xsl:text>
					<xsl:apply-templates mode="articletext">
						<xsl:with-param name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:with-param>
						<xsl:with-param name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:with-param>
						<xsl:with-param name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:with-param>
						<xsl:with-param name="XMLElementAttributes"><xsl:value-of select="$XMLElementAttributes"/></xsl:with-param>
					</xsl:apply-templates>
					<xsl:text>&lt;/__xmlElement__&gt;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates mode="articletext">
						<xsl:with-param name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:with-param>
						<xsl:with-param name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:with-param>
						<xsl:with-param name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:with-param>
						<xsl:with-param name="XMLElementAttributes"><xsl:value-of select="$XMLElementAttributes"/></xsl:with-param>
					</xsl:apply-templates>
				</xsl:otherwise>
			</xsl:choose>
		</contentElem>
	</xsl:template>


	<xsl:template match="TextVariableInstance" mode="articletext">
		<xsl:param name="XMLElementSelf"/>
		<xsl:param name="XMLElementMarkupTag"/>
		<xsl:param name="XMLElementXMLContent"/>
		<xsl:param name="XMLElementAttributes"/>
		<xsl:variable name="textvarID" select="@AssociatedTextVariable"/>
		<contentElem name="{name()}" render="inline">
			<xsl:if test="(locjs:get_includeXMLtags() != '0' ) and ($XMLElementSelf != '')">
				<xsl:attribute name="XMLElementSelf"><xsl:value-of select="$XMLElementSelf"/></xsl:attribute>
				<xsl:attribute name="XMLElementMarkupTag"><xsl:value-of select="$XMLElementMarkupTag"/></xsl:attribute>
				<xsl:attribute name="XMLElementXMLContent"><xsl:value-of select="$XMLElementXMLContent"/></xsl:attribute>
				<xsl:attribute name="XMLElementAttributes"><xsl:value-of select="$XMLElementAttributes"/></xsl:attribute>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="@ResultText">
					<xsl:value-of select="@ResultText/."/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="textvarID" select="@AssociatedTextVariable"/>
					<xsl:value-of select="/Documents/Document/TextVariable[@Self = $textvarID]/CustomTextVariablePreference/Properties/Contents"/>
				</xsl:otherwise>
			</xsl:choose>
		</contentElem>
	</xsl:template>





	<!-- ===============================================
		 embedded image data in PDF/pcnt, imag/pcnt...
	     =============================================== -->
	<xsl:template match="text()" mode="embeddedimage">
		<xsl:value-of select="."/>
	</xsl:template>


	<!-- ===============================================
		 the plain text content in txsr/pcnt
	     =============================================== -->
	<xsl:template match="text()" mode="articletext">
		<xsl:choose>
			<xsl:when test="name(..) != 'Content'"></xsl:when><!-- other text is white space only -->
			<xsl:when test=". = '&#x0a;'"></xsl:when><!-- remove any combination of line breaks -->
			<xsl:when test=". = '&#x0d;'"></xsl:when>
			<xsl:when test=". = '&#x0d;&#x0a;'"></xsl:when>
			<xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- ===============================================
		 the processing-instruction for anchored objects like boxes and footnotes in txsr/pcnt
		 like anchored objects: <?aid Self="rc_u215cins3e2"?>
	     =============================================== -->
	<xsl:template match="processing-instruction('aid')" mode="articletext">
		<xsl:variable name="anchored_object_ID"><xsl:value-of select="substring-after(substring-before(substring-after(.,'Self=&quot;'),'&quot;'),'_')"/></xsl:variable>
		<!-- check if it is an anchored object like a box, footnote, text anchor.... -->
		<!-- #####anchored_object_ID:'<xsl:value-of select="$anchored_object_ID"/>' -->
		<xsl:choose>
			<xsl:when test="false()"></xsl:when>
			<xsl:otherwise>&lt;?__anchored_object__ "ro_<xsl:value-of select="$anchored_object_ID"/>"?&gt;</xsl:otherwise><!-- anchored box -->
		</xsl:choose>
	</xsl:template>





	<xsl:template match="*|@*|comment()|processing-instruction()|text()" mode="copy_object">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|comment()|processing-instruction()|text()" mode="copy_object"/>
		</xsl:copy>
	</xsl:template>





	<!-- ===============================================
		 the processing-instruction for special characters in txsr/pcnt (see developer kit TextChar.h)
		 like: <?ACE 19?>
	     =============================================== -->
	<xsl:template match="processing-instruction('ACE')" mode="articletext">
		<xsl:variable name="hexChar" select="."/>
		<xsl:variable name="dezCode" select="locjs:h2d(string($hexChar))"/>
		<!-- filter out codes -->
		<xsl:choose>
			<xsl:when test="$dezCode = 4"><footnote_num>%_ftn_num_%</footnote_num></xsl:when><!-- kTextChar_FootnoteMarker -->
			<!-- output ctrlchar tag with hex code -->
			<xsl:when test="$preserveControlCharacters != '0'">
				<xsl:choose>
					<xsl:when test="$hexChar = '18'"><xsl:text>&lt;?__ctrlchar__ code="</xsl:text><xsl:value-of select="$hexChar"/><xsl:text>" name="PageNumber" value="</xsl:text><xsl:value-of select="locjs:get_current_pagenumbers(2)"/><xsl:text>"__ctrlchar__?&gt;</xsl:text></xsl:when>
					<xsl:otherwise><xsl:text>&lt;?__ctrlchar__ code="</xsl:text><xsl:value-of select="$hexChar"/><xsl:text>"__ctrlchar__?&gt;</xsl:text></xsl:otherwise>
				</xsl:choose>
			</xsl:when>

			<!-- output pre-converted ctrlchar tag  -->
			<xsl:when test="$dezCode = 3"><xsl:text>&lt;?__ctrlchar__ code="</xsl:text><xsl:value-of select="$hexChar"/><xsl:text>" name="BreakRunInStyle"__ctrlchar__?&gt;</xsl:text></xsl:when><!-- kTextChar_BreakRunInStyle -->
			<xsl:when test="$dezCode = 4"><xsl:text>&lt;?__ctrlchar__ code="</xsl:text><xsl:value-of select="$hexChar"/><xsl:text>" name="FootNoteMarker"__ctrlchar__?&gt;</xsl:text></xsl:when><!-- kTextChar_FootnoteMarker -->
			<xsl:when test="$dezCode = 7"><xsl:text>&lt;?__ctrlchar__ code="</xsl:text><xsl:value-of select="$hexChar"/><xsl:text>" name="IndentToHere"__ctrlchar__?&gt;</xsl:text></xsl:when><!-- kTextChar_IndentToHere -->
			<xsl:when test="$dezCode = 8"><xsl:text>&lt;?__ctrlchar__ code="</xsl:text><xsl:value-of select="$hexChar"/><xsl:text>" name="RightAlignedTab"__ctrlchar__?&gt;</xsl:text></xsl:when><!-- kTextChar_RightAlignedTab -->
			<xsl:when test="$dezCode = 9"><xsl:text>&lt;?__ctrlchar__ code="</xsl:text><xsl:value-of select="$hexChar"/><xsl:text>" name="Tab"__ctrlchar__?&gt;</xsl:text></xsl:when><!-- kTextChar_Tab -->
			<xsl:when test="($hexChar = '18') and (locjs:get_pageNumberType() = 'PreviousPageNumber')"><xsl:text>&lt;?__ctrlchar__ code="</xsl:text><xsl:value-of select="$hexChar"/><xsl:text>" name="PreviousPageNumber" value="</xsl:text><xsl:value-of select="locjs:get_current_pagenumbers(14)"/><xsl:text>"__ctrlchar__?&gt;</xsl:text></xsl:when>
			<xsl:when test="($hexChar = '18') and (locjs:get_pageNumberType() = 'NextPageNumber')"><xsl:text>&lt;?__ctrlchar__ code="</xsl:text><xsl:value-of select="$hexChar"/><xsl:text>" name="NextPageNumber" value="</xsl:text><xsl:value-of select="locjs:get_current_pagenumbers(15)"/><xsl:text>"__ctrlchar__?&gt;</xsl:text></xsl:when>
			<xsl:when test="$hexChar = '18'"><xsl:text>&lt;?__ctrlchar__ code="</xsl:text><xsl:value-of select="$hexChar"/><xsl:text>" name="PageNumber" value="</xsl:text><xsl:value-of select="locjs:get_current_pagenumbers(2)"/><xsl:text>"__ctrlchar__?&gt;</xsl:text></xsl:when>
			<xsl:when test="$hexChar = '19'"><xsl:text>&lt;?__ctrlchar__ code="</xsl:text><xsl:value-of select="$hexChar"/><xsl:text>" name="EndOfMedium"__ctrlchar__?&gt;</xsl:text></xsl:when><!-- kTextChar_Tab -->
			<xsl:when test="$hexChar = '1a'"><xsl:text>&lt;?__ctrlchar__ code="</xsl:text><xsl:value-of select="$hexChar"/><xsl:text>" name="Substitute"__ctrlchar__?&gt;</xsl:text></xsl:when><!-- kTextChar_NonRomanSpecialGlyph -->
			<xsl:otherwise><xsl:text>&lt;?__ctrlchar__ code="</xsl:text><xsl:value-of select="$hexChar"/><xsl:text>"__ctrlchar__?&gt;</xsl:text></xsl:otherwise>
		</xsl:choose>
	</xsl:template>




	<!-- ===============================================
		 tables boxes contained always in CharacterStyleRange
	     =============================================== -->
	<xsl:template match="Table">
		<xsl:variable name="anchorlevel" select="locjs:incr_anchor_level()"/>
		<xsl:if test="$DEBUG = 1">
			<xsl:variable name="d" select="locjs:message(concat('**** Table, anchor level: ',$anchorlevel))"/>
		</xsl:if>
		<xsl:variable name="d" select="locjs:reset_table_row_colors()"/>
		<xsl:variable name="d" select="locjs:processing_table()"/>
		<content type="table">
			<xsl:attribute name="Self"><xsl:value-of select="@Self"/></xsl:attribute>
			<xsl:attribute name="anchorlevel"><xsl:value-of select="$anchorlevel"/></xsl:attribute>
			<xsl:attribute name="direction"><xsl:value-of select="@TableDirection"/></xsl:attribute>
			<xsl:variable name="borderLeftStyleID" select="@LeftBorderStrokeType"/><!-- also can be 'n' for none -->
			<xsl:variable name="borderLeftStyle">
				<xsl:choose>
					<xsl:when test="$borderLeftStyleID = 'n'">n</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="/Documents/Document/Graphic/StrokeStyle[@Self = $borderLeftStyleID]/@Name"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="borderTopStyleID" select="@TopBorderStrokeType"/>
			<xsl:variable name="borderTopStyle">
				<xsl:choose>
					<xsl:when test="$borderTopStyleID = 'n'">n</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="/Documents/Document/Graphic/StrokeStyle[@Self = $borderTopStyleID]/@Name"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="borderRightStyleID" select="@RightBorderStrokeType"/>
			<xsl:variable name="borderRightStyle">
				<xsl:choose>
					<xsl:when test="$borderRightStyleID = 'n'">n</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="/Documents/Document/Graphic/StrokeStyle[@Self = $borderRightStyleID]/@Name"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="borderBottomStyleID" select="@BottomBorderStrokeType"/>
			<xsl:variable name="borderBottomStyle">
				<xsl:choose>
					<xsl:when test="$borderBottomStyleID = 'n'">n</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="/Documents/Document/Graphic/StrokeStyle[@Self = $borderBottomStyleID]/@Name"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<xsl:variable name="borderLeftColor" select="locjs:get_rgb_color(string(@LeftBorderStrokeColor),string(@LeftBorderStrokeTint))"/>
			<xsl:variable name="borderTopColor" select="locjs:get_rgb_color(string(@TopBorderStrokeColor),string(@TopBorderStrokeTint))"/>
			<xsl:variable name="borderRightColor" select="locjs:get_rgb_color(string(@RightBorderStrokeColor),string(@RightBorderStrokeTint))"/>
			<xsl:variable name="borderBottomColor" select="locjs:get_rgb_color(string(@BottomBorderStrokeColor),string(@BottomBorderStrokeTint))"/>

			<xsl:variable name="borderCollaps">
				<xsl:choose>
						<!-- this is written into the table class CSS: <xsl:when test="$TABLE_BORDER_COLLAPSE = '1'">border-collapse:collapse;</xsl:when -->
					<xsl:when test="$TABLE_BORDER_COLLAPSE = '2'">border-collapse:separate; border-spacing:0px;</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="tablestyle" select="locjs:css_tablestyle_create(
																		string($borderCollaps),
																		string($borderLeftStyle),
																		string(@LeftBorderStrokeWeight),
																		string(@LeftBorderStrokeColor),
																		string(@LeftBorderStrokeTint),
																		string($borderRightStyle),
																		string(@RightBorderStrokeWeight),
																		string(@RightBorderStrokeColor),
																		string(@RightBorderStrokeTint),
																		string($borderTopStyle),
																		string(@TopBorderStrokeWeight),
																		string(@TopBorderStrokeColor),
																		string(@TopBorderStrokeTint),
																		string($borderBottomStyle),
																		string(@BottomBorderStrokeWeight),
																		string(@BottomBorderStrokeColor),
																		string(@BottomBorderStrokeTint)
																		)"/>
			<table>
				<xsl:variable name="appliedtablestyle" select="@AppliedTableStyle"/>
				<xsl:variable name="tableclassname">
					<xsl:choose>
						<xsl:when test="@AppliedTableStyle"><xsl:value-of select="locjs:get_tablestyle_classname_from_styleID(string(@AppliedTableStyle))"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="locjs:get_tablestyle_classname_from_styleName('[Basic Table]')"/></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:if test="$tableclassname != ''"><xsl:attribute name="class"><xsl:value-of select="$tableclassname"/></xsl:attribute></xsl:if>
				<xsl:if test="$tablestyle != ''"><xsl:attribute name="style"><xsl:value-of select="$tablestyle"/></xsl:attribute></xsl:if>

				<xsl:variable name="tableheadcells_styleid">
					<xsl:value-of select="/Documents/Document/Styles/RootTableStyleGroup//TableStyle[@Self = $appliedtablestyle]/@HeaderRegionCellStyle/."/>
					<xsl:if test="@HeaderRegionCellStyle"><xsl:value-of select="@HeaderRegionCellStyle/."/></xsl:if>
				</xsl:variable>

				<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
					<xsl:attribute name="Self"><xsl:value-of select="@Self"/></xsl:attribute>
					<xsl:attribute name="tablestyleID"><xsl:value-of select="@AppliedTableStyle"/></xsl:attribute>
					<xsl:attribute name="rows"><xsl:value-of select="@BodyRowCount"/></xsl:attribute>
					<xsl:attribute name="cols"><xsl:value-of select="@ColumnCount"/></xsl:attribute>
					<xsl:attribute name="headerrows"><xsl:value-of select="@HeaderRowCount"/></xsl:attribute>
					<xsl:attribute name="footerrows"><xsl:value-of select="@FooterRowCount"/></xsl:attribute>
					<!-- row fill colors -->
					<xsl:if test="@StartRowFillColor"><xsl:attribute name="rowfillFirstcolorID"><xsl:value-of select="@StartRowFillColor"/></xsl:attribute></xsl:if><!-- Row Fill first color ID -->
					<xsl:if test="@StartRowFillTint"><xsl:attribute name="rowfillFirstcolorTint"><xsl:value-of select="@StartRowFillTint"/></xsl:attribute></xsl:if><!-- Row Fill first color tint -->
					<xsl:if test="@StartRowFillCount"><xsl:attribute name="rowfillFirstcolorCount"><xsl:value-of select="@StartRowFillCount"/></xsl:attribute></xsl:if><!-- Row Fill first count -->
					<xsl:if test="@SkipFirstAlternatingFillRows"><xsl:attribute name="rowfillStartcolorSkip"><xsl:value-of select="@SkipFirstAlternatingFillRows"/></xsl:attribute></xsl:if><!-- how many rows to skip at top until color fill -->

					<xsl:if test="@EndRowFillColor"><xsl:attribute name="rowfillFirstcolorID"><xsl:value-of select="@EndRowFillColor"/></xsl:attribute></xsl:if><!-- Row Fill first color ID -->
					<xsl:if test="@EndRowFillTint"><xsl:attribute name="rowfillFirstcolorTint"><xsl:value-of select="@EndRowFillTint"/></xsl:attribute></xsl:if><!-- Row Fill first color tint -->
					<xsl:if test="@EndRowFillCount"><xsl:attribute name="rowfillFirstcolorCount"><xsl:value-of select="@EndRowFillCount"/></xsl:attribute></xsl:if><!-- Row Fill first count -->
					<xsl:if test="@SkipLastAlternatingFillRows"><xsl:attribute name="rowfillStartcolorSkip"><xsl:value-of select="@SkipLastAlternatingFillRows"/></xsl:attribute></xsl:if><!-- how many rows to skip at top until color fill -->

					<!-- borders -->
					<xsl:if test="$borderLeftStyle != ''"><xsl:attribute name="borderLeftStyle"><xsl:value-of select="$borderLeftStyle"/></xsl:attribute></xsl:if>
					<xsl:if test="$borderLeftStyleID != ''"><xsl:attribute name="borderLeftStyleID"><xsl:value-of select="$borderLeftStyleID"/></xsl:attribute></xsl:if>
					<xsl:if test="@LeftEdgeStrokeWeight"><xsl:attribute name="borderLeftWidth"><xsl:value-of select="@LeftEdgeStrokeWeight"/></xsl:attribute></xsl:if>
					<xsl:if test="@LeftEdgeStrokeColor"><xsl:attribute name="borderLeftColorID"><xsl:value-of select="@LeftEdgeStrokeColor"/></xsl:attribute></xsl:if>
					<xsl:if test="@LeftEdgeStrokeTint"><xsl:attribute name="borderLeftColorTint"><xsl:value-of select="@LeftEdgeStrokeTint"/></xsl:attribute></xsl:if>
					<xsl:if test="@LeftEdgeStrokeGapColor"><xsl:attribute name="borderLeftGapColorID"><xsl:value-of select="@LeftEdgeStrokeGapColor"/></xsl:attribute></xsl:if>
					<xsl:if test="@LeftEdgeStrokeGapTint"><xsl:attribute name="borderLeftGapColorTint"><xsl:value-of select="@LeftEdgeStrokeGapTint"/></xsl:attribute></xsl:if>
					<xsl:if test="$borderLeftColor != ''"><xsl:attribute name="borderLeftColor"><xsl:value-of select="$borderLeftColor"/></xsl:attribute></xsl:if>

					<xsl:if test="$borderTopStyle != ''"><xsl:attribute name="borderTopStyle"><xsl:value-of select="$borderTopStyle"/></xsl:attribute></xsl:if>
					<xsl:if test="$borderTopStyleID != ''"><xsl:attribute name="borderTopStyleID"><xsl:value-of select="$borderTopStyleID"/></xsl:attribute></xsl:if>
					<xsl:if test="@TopEdgeStrokeWeight"><xsl:attribute name="borderTopWidth"><xsl:value-of select="@TopEdgeStrokeWeight"/></xsl:attribute></xsl:if>
					<xsl:if test="@TopEdgeStrokeColor"><xsl:attribute name="borderTopColorID"><xsl:value-of select="@TopEdgeStrokeColor"/></xsl:attribute></xsl:if>
					<xsl:if test="@TopEdgeStrokeTint"><xsl:attribute name="borderTopColorTint"><xsl:value-of select="@TopEdgeStrokeTint"/></xsl:attribute></xsl:if>
					<xsl:if test="@TopEdgeStrokeGapColor"><xsl:attribute name="borderTopGapColorID"><xsl:value-of select="@TopEdgeStrokeGapColor"/></xsl:attribute></xsl:if>
					<xsl:if test="@TopEdgeStrokeGapTint"><xsl:attribute name="borderTopGapColorTint"><xsl:value-of select="@TopEdgeStrokeGapTint"/></xsl:attribute></xsl:if>
					<xsl:if test="$borderTopColor != ''"><xsl:attribute name="borderTopColor"><xsl:value-of select="$borderTopColor"/></xsl:attribute></xsl:if>

					<xsl:if test="$borderRightStyle"><xsl:attribute name="borderRightStyle"><xsl:value-of select="$borderRightStyle"/></xsl:attribute></xsl:if>
					<xsl:if test="$borderRightStyleID != ''"><xsl:attribute name="borderRightStyleID"><xsl:value-of select="$borderRightStyleID"/></xsl:attribute></xsl:if>
					<xsl:if test="@RightEdgeStrokeWeight"><xsl:attribute name="borderRightWidth"><xsl:value-of select="@RightEdgeStrokeWeight"/></xsl:attribute></xsl:if>
					<xsl:if test="@RightEdgeStrokeColor"><xsl:attribute name="borderRightColorID"><xsl:value-of select="@RightEdgeStrokeColor"/></xsl:attribute></xsl:if>
					<xsl:if test="@RightEdgeStrokeTint"><xsl:attribute name="borderRightColorTint"><xsl:value-of select="@RightEdgeStrokeTint"/></xsl:attribute></xsl:if>
					<xsl:if test="@RightEdgeStrokeGapColor"><xsl:attribute name="borderRightGapColorID"><xsl:value-of select="@RightEdgeStrokeGapColor"/></xsl:attribute></xsl:if>
					<xsl:if test="@RightEdgeStrokeGapTint"><xsl:attribute name="borderRightGapColorTint"><xsl:value-of select="@RightEdgeStrokeGapTint"/></xsl:attribute></xsl:if>
					<xsl:if test="$borderRightColor != ''"><xsl:attribute name="borderRightColor"><xsl:value-of select="$borderRightColor"/></xsl:attribute></xsl:if>

					<xsl:if test="$borderBottomStyle"><xsl:attribute name="borderBottomStyle"><xsl:value-of select="$borderBottomStyle"/></xsl:attribute></xsl:if>
					<xsl:if test="$borderBottomStyleID != ''"><xsl:attribute name="borderBottomStyleID"><xsl:value-of select="$borderBottomStyleID"/></xsl:attribute></xsl:if>
					<xsl:if test="@BottomEdgeStrokeWeight"><xsl:attribute name="borderBottomWidth"><xsl:value-of select="@BottomEdgeStrokeWeight"/></xsl:attribute></xsl:if>
					<xsl:if test="@BottomEdgeStrokeColor"><xsl:attribute name="borderBottomColorID"><xsl:value-of select="@BottomEdgeStrokeColor"/></xsl:attribute></xsl:if>
					<xsl:if test="@BottomEdgeStrokeTint"><xsl:attribute name="borderBottomColorTint"><xsl:value-of select="@BottomEdgeStrokeTint"/></xsl:attribute></xsl:if>
					<xsl:if test="@BottomEdgeStrokeGapColor"><xsl:attribute name="borderBottomGapColorID"><xsl:value-of select="@BottomEdgeStrokeGapColor"/></xsl:attribute></xsl:if>
					<xsl:if test="@BottomEdgeStrokeGapTint"><xsl:attribute name="borderBottomGapColorTint"><xsl:value-of select="@BottomEdgeStrokeGapTint"/></xsl:attribute></xsl:if>
					<xsl:if test="$borderBottomColor != ''"><xsl:attribute name="borderBottomColor"><xsl:value-of select="$borderBottomColor"/></xsl:attribute></xsl:if>

					<!-- add rows and columns dimensions element -->
					<tablesettings>
					<rowheights>
						<xsl:variable name="sumclear" select="locjs:clear_sum()"/>
						<xsl:for-each select="Row">
							<row>
								<xsl:attribute name="rownum"><xsl:value-of select="@Name"/></xsl:attribute>
								<xsl:attribute name="minheight"><xsl:value-of select="@MinimumHeight"/></xsl:attribute>
								<xsl:variable name="sumadd" select="locjs:sum(string(@MinimumHeight))"/>
							</row>
						</xsl:for-each>
						<total>
								<xsl:attribute name="height"><xsl:value-of select="locjs:get_sum()"/></xsl:attribute>
						</total>
					</rowheights>
					<colwidths>
						<xsl:variable name="sumclear" select="locjs:clear_sum()"/>
						<xsl:for-each select="Column">
							<col>
								<xsl:attribute name="colnum"><xsl:value-of select="@Name"/></xsl:attribute>
								<xsl:attribute name="width"><xsl:value-of select="@SingleColumnWidth"/></xsl:attribute>
								<xsl:variable name="sumadd" select="locjs:sum(string(@SingleColumnWidth))"/>
							</col>
						<total>
								<xsl:attribute name="width"><xsl:value-of select="locjs:get_sum()"/></xsl:attribute>
						</total>
						</xsl:for-each>
					</colwidths>
					</tablesettings>
				</xsl:if>

				<!-- add rows and columns -->
				<xsl:apply-templates select="Row">
					<xsl:with-param name="numtableheadrows" select="@HeaderRowCount"/>
					<xsl:with-param name="tableheadcells_styleid" select="$tableheadcells_styleid"/>
				</xsl:apply-templates>
			</table>
		</content>
		<xsl:variable name="d" select="locjs:end_processing_table()"/>
		<xsl:variable name="anchorlevelexit" select="locjs:decr_anchor_level()"/>
	</xsl:template>

	<xsl:template match="Row">
		<xsl:param name="numtableheadrows"/>
		<xsl:param name="tableheadcells_styleid"/>
		<!-- get alternating row colors -->
		<xsl:variable name="have_first_rowcolor"><!-- 0 for no alternating row color, else > 0 -->
			<xsl:choose>
				<xsl:when test="../@StartRowFillCount"><!-- try to get from Table element -->
					<xsl:value-of select="../@StartRowFillCount"/>
				</xsl:when>
				<xsl:when test="../@StartRowFillColor"><!-- we may have a ../@StartRowFillColor but no ../@StartRowFillCount -->
					<xsl:value-of select="1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="tsty" select="@AppliedTableStyle"/>
					<xsl:value-of select="/Documents/Document/Styles/RootTableStyleGroup//TableStyle[@Self = $tsty]/@StartRowFillCount"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="have_secnd_rowcolor"><!-- not present if no alternating row color, else > 0 -->
			<xsl:choose>
				<xsl:when test="../@EndRowFillCount"><!-- try to get from ctbl element -->
					<xsl:value-of select="../@EndRowFillCount"/>
				</xsl:when>
				<xsl:when test="../@EndRowFillColor"><!--we may have a ../@EndRowFillColor but no ../@EndRowFillCount -->
					<xsl:value-of select="1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="tsty" select="@AppliedTableStyle"/>
					<xsl:value-of select="/Documents/Document/Styles/RootTableStyleGroup//TableStyle[@Self = $tsty]/@EndRowFillCount"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
<!--
have_first_rowcolor:'<xsl:value-of select="$have_first_rowcolor"/>', have_secnd_rowcolor:'<xsl:value-of select="$have_secnd_rowcolor"/>'<br/>
Name:'<xsl:value-of select="number(@Name)"/>'<br/>
BodyRowCount:'<xsl:value-of select="number(../@BodyRowCount)"/>'<br/>
HeaderRowCount:'<xsl:value-of select="number(../@HeaderRowCount)"/>'<br/>
FooterRowCount:'<xsl:value-of select="number(../@FooterRowCount)"/>'<br/>
StartRowFillColor:'<xsl:value-of select="string(../@StartRowFillColor)"/>'<br/>
StartRowFillTint:'<xsl:value-of select="string(../@StartRowFillTint)"/>'<br/>
EndRowFillColor:'<xsl:value-of select="string(../@EndRowFillColor)"/>'<br/>
EndRowFillTint:'<xsl:value-of select="string(../@EndRowFillTint)"/>'<br/>
SkipFirstAlternatingFillRows:'<xsl:value-of select="string(../@SkipFirstAlternatingFillRows)"/>'<br/>
SkipLastAlternatingFillRows:'<xsl:value-of select="string(../@SkipLastAlternatingFillRows)"/>'<br/>
StartRowFillCount:'<xsl:value-of select="string(../@StartRowFillCount)"/>'<br/>
EndRowFillCount:'<xsl:value-of select="string(../@EndRowFillCount)"/>'<br/>
AppliedTableStyle:'<xsl:value-of select="string(../@AppliedTableStyle)"/>'<br/>
-->
		<xsl:variable name="rowcolor">
			<xsl:choose>
				<xsl:when test="($have_first_rowcolor = '0') or ($have_first_rowcolor = '')"></xsl:when><!-- no row color -->
				<xsl:when test="($have_first_rowcolor &gt;= 1) and ($have_secnd_rowcolor &gt;= 1)"><!-- alternating every second row (zebra papier) -->
					<xsl:value-of select="locjs:get_table_row_color( number(@Name),
																	number(../@BodyRowCount),
																	number(../@HeaderRowCount),
																	number(../@FooterRowCount),
																	string(../@StartRowFillColor),
																	string(../@StartRowFillTint),
																	string(../@EndRowFillColor),
																	string(../@EndRowFillTint),
																	string(../@SkipFirstAlternatingFillRows),
																	string(../@SkipLastAlternatingFillRows),
																	string(../@StartRowFillCount),
																	string(../@EndRowFillCount),
																	string(../@AppliedTableStyle)
																	)"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
<!--
rowcolor:'<xsl:value-of select="$rowcolor"/>'<br/>
-->
		<xsl:variable name="styleattribute">
			<xsl:value-of select="concat('height:',round(string(@SingleRowHeight)),'px;')"/>
			<xsl:if test="$rowcolor != ''">
				<xsl:value-of select="concat(' background-color:',$rowcolor,';')"/>
			</xsl:if>
		</xsl:variable>

		<tr>
			<!-- xsl:variable name="d" select="locjs:message(concat('**** Row Name: ',@Name,' - numtableheadrows: ',$numtableheadrows,' - tableheadcells_styleid: ',$tableheadcells_styleid))"/ -->
			<xsl:if test="($tableheadcells_styleid != '') and ((number(@Name)+1) &lt;= number($numtableheadrows))"><!-- header cells have an applied header cell style -->
				<xsl:attribute name="class"><xsl:value-of select="locjs:get_cellstyle_classname_from_styleID(string($tableheadcells_styleid))"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$styleattribute != ''">
				<xsl:attribute name="style"><xsl:value-of select="$styleattribute"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
				<xsl:attribute name="height"><xsl:value-of select="@SingleRowHeight"/></xsl:attribute>
				<xsl:attribute name="backgroundColor"><xsl:value-of select="$rowcolor"/></xsl:attribute>
			</xsl:if>

			<xsl:apply-templates select="../Column">
				<xsl:with-param name="row"><xsl:value-of select="string(@Name)"/></xsl:with-param>
			</xsl:apply-templates></tr>
	</xsl:template>

	<xsl:template match="Column">
		<xsl:param name="row"/>
		<xsl:variable name="colnum" select="@Name"/>
		<xsl:variable name="row_col" select="concat($colnum,':',$row)"/>
		<xsl:apply-templates select="../Cell[@Name = $row_col]"><!-- ccel @pnam="rk_col:row -->
			<xsl:with-param name="row"><xsl:value-of select="$row"/></xsl:with-param>
			<xsl:with-param name="col"><xsl:value-of select="@Name"/></xsl:with-param>
			<xsl:with-param name="colwidth"><xsl:value-of select="@SingleColumnWidth"/></xsl:with-param>
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template match="Cell"><!-- ccel @pnam="rk_col:row -->
		<xsl:param name="row"/>
		<xsl:param name="col"/>
		<xsl:param name="colwidth"/>

		<xsl:variable name="d" select="locjs:processing_tablecell()"/>
		<xsl:variable name="col_row"><xsl:value-of select="$col"/>:<xsl:value-of select="$row"/></xsl:variable>
		<xsl:if test="@Name = $col_row">
			<xsl:variable name="backgroundColor">
				<xsl:choose>
					<xsl:when test="@FillColor and @FillTint"><!-- if we have a cell fill color AND a tint -->
						<xsl:value-of select="locjs:get_rgb_color(string(@FillColor),string(@FillTint))"/>
					</xsl:when>
					<xsl:when test="@FillColor"><!-- if we have a cell fill color but NO tint: get tint from alternating row fill -->
						<xsl:variable name="current_row_colorTint"><xsl:value-of select="locjs:get_current_row_colorTint()"/></xsl:variable><!-- we might need the row's tint set from table definition -->
						<xsl:value-of select="locjs:get_rgb_color(string(@FillColor),string($current_row_colorTint))"/><!-- if we have a fill tint but no cell color we take the row color with fill tint -->
					</xsl:when>
					<xsl:when test="@FillTint">
						<xsl:variable name="current_row_colorID"><xsl:value-of select="locjs:get_current_row_colorID()"/></xsl:variable><!-- we might need the row's color set from table definition -->
						<xsl:value-of select="locjs:get_rgb_color(string($current_row_colorID),string(@FillTint))"/><!-- if we have a fill tint but no cell color we take the row color with fill tint -->
					</xsl:when>
				</xsl:choose>
			</xsl:variable>

			<xsl:variable name="borderLeftWidth">
				<xsl:choose>
					<xsl:when test="@LeftEdgeStrokeWeight"><xsl:value-of select="@LeftEdgeStrokeWeight"/></xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="borderTopWidth">
				<xsl:choose>
					<xsl:when test="@TopEdgeStrokeWeight"><xsl:value-of select="@TopEdgeStrokeWeight"/></xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="borderRightWidth">
				<xsl:choose>
					<xsl:when test="@RightEdgeStrokeWeight"><xsl:value-of select="@RightEdgeStrokeWeight"/></xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="borderBottomWidth">
				<xsl:choose>
					<xsl:when test="@BottomEdgeStrokeWeight"><xsl:value-of select="@BottomEdgeStrokeWeight"/></xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<xsl:variable name="borderLeftStyleID" select="@LeftEdgeStrokeType"/>
			<xsl:variable name="borderLeftStyle">
				<xsl:choose>
					<xsl:when test="$borderLeftStyleID = 'n'">n</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="/Documents/Document/Graphic/StrokeStyle[@Self = $borderLeftStyleID]/@Name"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="borderTopStyleID" select="@TopEdgeStrokeType"/>
			<xsl:variable name="borderTopStyle">
				<xsl:choose>
					<xsl:when test="$borderTopStyleID = 'n'">n</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="/Documents/Document/Graphic/StrokeStyle[@Self = $borderTopStyleID]/@Name"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="borderRightStyleID" select="@RightEdgeStrokeType"/>
			<xsl:variable name="borderRightStyle">
				<xsl:choose>
					<xsl:when test="$borderRightStyleID = 'n'">n</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="/Documents/Document/Graphic/StrokeStyle[@Self = $borderRightStyleID]/@Name"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="borderBottomStyleID" select="@BottomEdgeStrokeType"/>
			<xsl:variable name="borderBottomStyle">
				<xsl:choose>
					<xsl:when test="$borderBottomStyleID = 'n'">n</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="/Documents/Document/Graphic/StrokeStyle[@Self = $borderBottomStyleID]/@Name"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<xsl:variable name="borderLeftColor">
				<xsl:choose>
					<xsl:when test="@LeftEdgeStrokeColor and @LeftEdgeStrokeTint">
						<xsl:value-of select="locjs:get_rgb_color(string(@LeftEdgeStrokeColor),string(@LeftEdgeStrokeTint))"/>
					</xsl:when>
					<xsl:when test="@LeftEdgeStrokeColor">
						<xsl:value-of select="locjs:get_rgb_color(string(@LeftEdgeStrokeColor),'100')"/>
					</xsl:when>
					<xsl:when test="@LeftEdgeStrokeTint">
						<xsl:variable name="blackID" select="locjs:get_rgb_color_id('black')"/>
						<xsl:value-of select="locjs:get_rgb_color(string($blackID),string(@LeftEdgeStrokeTint))"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="borderTopColor">
				<xsl:choose>
					<xsl:when test="@TopEdgeStrokeColor and @TopEdgeStrokeTint">
						<xsl:value-of select="locjs:get_rgb_color(string(@TopEdgeStrokeColor),string(@TopEdgeStrokeTint))"/>
					</xsl:when>
					<xsl:when test="@TopEdgeStrokeColor">
						<xsl:value-of select="locjs:get_rgb_color(string(@TopEdgeStrokeColor),'100')"/>
					</xsl:when>
					<xsl:when test="@TopEdgeStrokeTint">
						<xsl:variable name="blackID" select="locjs:get_rgb_color_id('black')"/>
						<xsl:value-of select="locjs:get_rgb_color(string($blackID),string(@TopEdgeStrokeTint))"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="borderRightColor">
				<xsl:choose>
					<xsl:when test="@RightEdgeStrokeColor and @RightEdgeStrokeTint">
						<xsl:value-of select="locjs:get_rgb_color(string(@RightEdgeStrokeColor),string(@RightEdgeStrokeTint))"/>
					</xsl:when>
					<xsl:when test="@RightEdgeStrokeColor">
						<xsl:value-of select="locjs:get_rgb_color(string(@RightEdgeStrokeColor),'100')"/>
					</xsl:when>
					<xsl:when test="@RightEdgeStrokeTint">
						<xsl:variable name="blackID" select="locjs:get_rgb_color_id('black')"/>
						<xsl:value-of select="locjs:get_rgb_color(string($blackID),string(@RightEdgeStrokeTint))"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="borderBottomColor">
				<xsl:choose>
					<xsl:when test="@BottomEdgeStrokeColor and @BottomEdgeStrokeTint">
						<xsl:value-of select="locjs:get_rgb_color(string(@BottomEdgeStrokeColor),string(@BottomEdgeStrokeTint))"/>
					</xsl:when>
					<xsl:when test="@BottomEdgeStrokeColor">
						<xsl:value-of select="locjs:get_rgb_color(string(@BottomEdgeStrokeColor),'100')"/>
					</xsl:when>
					<xsl:when test="@BottomEdgeStrokeTint">
						<xsl:variable name="blackID" select="locjs:get_rgb_color_id('black')"/>
						<xsl:value-of select="locjs:get_rgb_color(string($blackID),string(@BottomEdgeStrokeTint))"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>

			<xsl:variable name="fontColor">
				<xsl:if test="@AppliedCellStyle"><!-- get paragraph cell style if available -->
					<xsl:variable name="cellstyleID"><xsl:value-of select="@AppliedCellStyle"/></xsl:variable>
					<xsl:variable name="parastyleID"><xsl:value-of select="/Documents/Document/Styles/RootCellStyleGroup//CellStyle[@Self=$cellstyleID]/@AppliedParagraphStyle"/></xsl:variable><!-- para style which sets the font color -->
					<xsl:variable name="fillcolor"><xsl:value-of select="/Documents/Document/Styles/RootParagraphStyleGroup//ParagraphStyle[@Self=$parastyleID]/@FillColor"/></xsl:variable>
					<xsl:variable name="filltint"><xsl:value-of select="/Documents/Document/Styles/RootParagraphStyleGroup//ParagraphStyle[@Self=$parastyleID]/@FillTint"/></xsl:variable>
					<xsl:value-of select="locjs:get_rgb_color(string($fillcolor),string($filltint))"/>
				</xsl:if>
			</xsl:variable>
			<xsl:variable name="cellstyle" select="locjs:create_cell_style(	locjs:get_valign(string(@VerticalJustification)),
																			string($backgroundColor),
																			string($borderLeftWidth),string($borderTopWidth),string($borderRightWidth),string($borderBottomWidth),
																			string($borderLeftStyle),string($borderTopStyle),string($borderRightStyle),string($borderBottomStyle),
																			string($borderLeftColor),string($borderTopColor),string($borderRightColor),string($borderBottomColor),
																			string(@AppliedCellStyle),
																			string($fontColor),
																			string(@LeftInset),string(@TopInset),string(@RightInset),string(@BottomInset)
																			)"/>
			<td>
				<xsl:variable name="have_bodyregioncellstyleid">
					<xsl:if test="contains(@AppliedCellStyle,'[None]')"><!-- get @BodyRegionCellStyle from table style -->
							<xsl:variable name="tablestyleid" select="../@AppliedTableStyle"/>
							<xsl:variable name="bodyregioncellstyleid" select="/Documents/Document/Styles/RootTableStyleGroup//TableStyle[@Self = $tablestyleid]/@BodyRegionCellStyle"/>
							<xsl:if test="$bodyregioncellstyleid != ''"><xsl:value-of select="locjs:get_cellstyle_classname_from_styleID(string($bodyregioncellstyleid))"/></xsl:if>
					</xsl:if>
				</xsl:variable>
				<xsl:variable name="cellclassname">
					<xsl:choose>
						<xsl:when test="$have_bodyregioncellstyleid != ''"><xsl:value-of select="locjs:get_cellstyle_classname_from_styleID(string($have_bodyregioncellstyleid))"/></xsl:when>
						<xsl:when test="@AppliedCellStyle"><xsl:value-of select="locjs:get_cellstyle_classname_from_styleID(string(@AppliedCellStyle))"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="locjs:get_tablestyle_classname_from_styleName('[None]')"/></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:if test="$cellclassname != ''"><xsl:attribute name="class"><xsl:value-of select="$cellclassname"/></xsl:attribute></xsl:if>
				<xsl:if test="$cellstyle != ''"><xsl:attribute name="style"><xsl:value-of select="$cellstyle"/></xsl:attribute></xsl:if>
				<xsl:attribute name="colwidth"><xsl:value-of select="$colwidth"/></xsl:attribute>
				<xsl:attribute name="colspan"><xsl:value-of select="@ColumnSpan"/></xsl:attribute>
				<xsl:attribute name="rowspan"><xsl:value-of select="@RowSpan"/></xsl:attribute>
				<!-- xsl:attribute name="valign"><xsl:value-of select="locjs:get_valign(string(@VerticalJustification))"/></xsl:attribute -->
				<xsl:attribute name="style"><xsl:value-of select="$cellstyle"/></xsl:attribute>
				<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
					<xsl:if test="@FillColor"><xsl:attribute name="backgroundColorID"><xsl:value-of select="@FillColor"/></xsl:attribute></xsl:if>
					<xsl:if test="@FillTint"><xsl:attribute name="backgroundColorFilt"><xsl:value-of select="@FillTint"/></xsl:attribute></xsl:if>

					<!-- text insets -->
					<xsl:if test="@LeftInset"><xsl:attribute name="textInsetLeft"><xsl:value-of select="@LeftInset"/></xsl:attribute></xsl:if>
					<xsl:if test="@TopInset"><xsl:attribute name="textInsetTop"><xsl:value-of select="@TopInset"/></xsl:attribute></xsl:if>
					<xsl:if test="@RightInset"><xsl:attribute name="textInsetRight"><xsl:value-of select="@RightInset"/></xsl:attribute></xsl:if>
					<xsl:if test="@BottomInset"><xsl:attribute name="textInsetBottom"><xsl:value-of select="@BottomInset"/></xsl:attribute></xsl:if>

					<!-- borders -->
					<xsl:if test="@LeftEdgeStrokeWeight">
						<xsl:attribute name="borderLeftWidthX"><xsl:value-of select="@LeftEdgeStrokeWeight"/></xsl:attribute>
						<xsl:attribute name="borderLeftWidth"><xsl:value-of select="ceiling(string(@LeftEdgeStrokeWeight))"/></xsl:attribute>
						<xsl:attribute name="borderLeftColorID"><xsl:value-of select="@LeftEdgeStrokeColor"/></xsl:attribute>
						<xsl:attribute name="borderLeftStyleID"><xsl:value-of select="@LeftEdgeStrokeType"/></xsl:attribute>
						<xsl:attribute name="borderLeftGapColor"><xsl:value-of select="locjs:get_rgb_color(string(@LeftEdgeStrokeGapColor),string(@LeftEdgeStrokeGapTint))"/></xsl:attribute>
						<xsl:attribute name="borderLeftGapColorID"><xsl:value-of select="@LeftEdgeStrokeGapColor"/></xsl:attribute>
						<xsl:attribute name="borderLeftGapColorTint"><xsl:value-of select="@LeftEdgeStrokeGapTint"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="@TopEdgeStrokeWeight">
						<xsl:attribute name="borderTopWidthX"><xsl:value-of select="@TopEdgeStrokeWeight"/></xsl:attribute>
						<xsl:attribute name="borderTopWidth"><xsl:value-of select="ceiling(string(@TopEdgeStrokeWeight))"/></xsl:attribute>
						<xsl:attribute name="borderTopColorID"><xsl:value-of select="@TopEdgeStrokeColor"/></xsl:attribute>
						<xsl:attribute name="borderTopStyleID"><xsl:value-of select="@TopEdgeStrokeType"/></xsl:attribute>
						<xsl:attribute name="borderTopGapColor"><xsl:value-of select="locjs:get_rgb_color(string(@TopEdgeStrokeGapColor),string(@TopEdgeStrokeGapTint))"/></xsl:attribute>
						<xsl:attribute name="borderTopGapColorID"><xsl:value-of select="@TopEdgeStrokeGapColor"/></xsl:attribute>
						<xsl:attribute name="borderTopGapColorTint"><xsl:value-of select="@TopEdgeStrokeGapTint"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="@RightEdgeStrokeWeight">
						<xsl:attribute name="borderRightWidthX"><xsl:value-of select="@RightEdgeStrokeWeight"/></xsl:attribute>
						<xsl:attribute name="borderRightWidth"><xsl:value-of select="ceiling(string(@RightEdgeStrokeWeight))"/></xsl:attribute>
						<xsl:attribute name="borderRightColorID"><xsl:value-of select="@RightEdgeStrokeColor"/></xsl:attribute>
						<xsl:attribute name="borderRightStyleID"><xsl:value-of select="@RightEdgeStrokeType"/></xsl:attribute>
						<xsl:attribute name="borderRightGapColor"><xsl:value-of select="locjs:get_rgb_color(string(@RightEdgeStrokeGapColor),string(@RightEdgeStrokeGapTint))"/></xsl:attribute>
						<xsl:attribute name="borderRightGapColorID"><xsl:value-of select="@RightEdgeStrokeGapColor"/></xsl:attribute>
						<xsl:attribute name="borderRightGapColorTint"><xsl:value-of select="@RightEdgeStrokeGapTint"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="@BottomWEdgeStrokeWeight">
						<xsl:attribute name="borderBottomWidthX"><xsl:value-of select="@BottomEdgeStrokeWeight"/></xsl:attribute>
						<xsl:attribute name="borderBottomWidth"><xsl:value-of select="ceiling(string(@BottomEdgeStrokeWeight))"/></xsl:attribute>
						<xsl:attribute name="borderBottomColorID"><xsl:value-of select="@BottomEdgeStrokeColor"/></xsl:attribute>
						<xsl:attribute name="borderBottomStyleID"><xsl:value-of select="@BottomEdgeStrokeType"/></xsl:attribute>
						<xsl:attribute name="borderBottomGapColor"><xsl:value-of select="locjs:get_rgb_color(string(@BottomEdgeStrokeGapColor),string(@BottomEdgeStrokeGapTint))"/></xsl:attribute>
						<xsl:attribute name="borderBottomGapColorID"><xsl:value-of select="@BottomEdgeStrokeGapColor"/></xsl:attribute>
						<xsl:attribute name="borderBottomGapColorTint"><xsl:value-of select="@BottomEdgeStrokeGapTint"/></xsl:attribute>
					</xsl:if>
				</xsl:if>
				<xsl:apply-templates mode="articletext" /></td>
		</xsl:if>
		<xsl:variable name="d" select="locjs:end_processing_tablecell()"/>
	</xsl:template>









	<!-- ===============================================
		 elements to suppress: all but directly mentioned 
	     =============================================== -->
	<xsl:template match="Page"></xsl:template><!-- pages are handled elsewhere. suppress them -->
	<xsl:template match="Properties"></xsl:template><!-- Story/Properties -->
	<xsl:template match="StoryPreference"></xsl:template><!-- Story/StoryPreference -->
	<xsl:template match="InCopyExportOption"></xsl:template><!-- Story/InCopyExportOption -->
	<xsl:template match="*"></xsl:template><!-- suppress all other elements not addressed directly -->
		<!-- debug mode -->
		<!--xsl:template match="*">
				<xsl:text disable-output-escaping="yes">&lt;span name="</xsl:text><xsl:value-of select="name()"/><xsl:text disable-output-escaping="yes">" style="border:solid 3px black;background-color:#FF0000"></xsl:text>######Box:'<xsl:value-of select="name()"/>'<xsl:text disable-output-escaping="yes">&lt;/span></xsl:text>
		</xsl:template-->











	<!-- ===============================================
		 get image data from embedded preview
	     =============================================== -->
	<xsl:template name="get_preview_image">
		<xsl:variable name="imagecMepDataBase64"><xsl:value-of disable-output-escaping="yes" select="descendant::MetadataPacketPreference/Properties/Contents/."/></xsl:variable>
		<xsl:variable name="imagecMepDom" select="myutils:parseStringToDom(string($imagecMepDataBase64))"/>
		<xsl:variable name="d1" select="locjs:message(concat('##### get_preview_image - imagecMepDom: ',$imagecMepDom))"/>

		<xsl:choose>
			<xsl:when test="imagecMepDom">
				<xsl:variable name="imageWidth" select="xalan:nodeset($imagecMepDom)//descendant::xmpGImg:width/."/>
				<xsl:variable name="imageHeight" select="xalan:nodeset($imagecMepDom)//descendant::xmpGImg:height/."/>
				<xsl:variable name="imageFormat" select="xalan:nodeset($imagecMepDom)//descendant::xmpGImg:format/."/>
				<xsl:variable name="d1" select="locjs:store_ImagePreviewFormats(string($imageWidth),string($imageHeight),string($imageFormat))"/>
				<!-- return image data -->
				<xsl:variable name="imageData"><xsl:value-of select="xalan:nodeset($imagecMepDom)//descendant::xmpGImg:image/." /></xsl:variable>
				
				<xsl:value-of select="$imageData" /><!-- return the image data -->
				<!--xsl:value-of select="locjs:re_replace(string($imageData),'&#xA;','\r','gi')" /-->
			</xsl:when>
			<xsl:otherwise></xsl:otherwise><!-- nothing to return -->
		</xsl:choose>

	</xsl:template>




	<!-- ===============================================
		 get defined colors
	     =============================================== -->
	<xsl:template name="get_colors">
		<xsl:if test="$DEBUG &gt;= 1">
			<xsl:variable name="d" select="locjs:message('************** Document Colors from Graphic/Color **************')"/>
		</xsl:if>
		<xsl:variable name="d" select="myutils:showMess('&#10;   ++ Retrieving colors ','1')"/>
		<xsl:for-each select="Graphic/Color">
			<xsl:variable name="d" select="locjs:store_color2rgb('0',string(@Self),string(@Name),string(@Space),string(@ColorValue))" />
		</xsl:for-each>
		<xsl:for-each select="Graphic/Tint"><!-- do this AFTER all other colors, it is just a tint. get from colorbase clbs and tint value tntv -->
			<xsl:variable name="d" select="locjs:store_color2rgb('2',string(@Self),string(@Name),string(@Space),string(@ColorValue),string(@BaseColor),string(@TintValue))" />
		</xsl:for-each>
		<xsl:for-each select="Graphic/Swatch">
			<xsl:variable name="d" select="locjs:store_color2rgb('1',string(@Self),string(@Name),string(@Space),string(@ColorValue))" />
		</xsl:for-each>
		<xsl:for-each select="Graphic/Gradient"><!-- ###V5 incomplete not tested -->
			<xsl:variable name="grad_type"><xsl:value-of select="@Type"/></xsl:variable>
			<xsl:variable name="color_id"><xsl:value-of select="@Self"/></xsl:variable>
			<xsl:variable name="first_stopcolor"><xsl:value-of select="GradientStop[position() = 1]/@StopColor"/></xsl:variable>
			<xsl:variable name="first_stoplocation"><xsl:value-of select="GradientStop[position() = 1]/@Location"/></xsl:variable>
			<xsl:variable name="second_stopcolor"><xsl:value-of select="GradientStop[position() = 2]/@StopColor"/></xsl:variable>
			<xsl:variable name="second_stoplocation"><xsl:value-of select="GradientStop[position() = 2]/@Location"/></xsl:variable>
			<xsl:variable name="midpoint"><xsl:value-of select="GradientStop[position() = 2]/@Midpoint"/></xsl:variable>

			<xsl:variable name="d" select="locjs:store_color2rgb('3',string(@Self),string(@Name),'','','',string($grad_type),string($first_stopcolor),string($first_stoplocation),string($second_stopcolor),string($second_stoplocation),string($midpoint))" />
		</xsl:for-each>

		<xsl:if test="$DEBUG &gt;= 1">
			<xsl:variable name="d" select="locjs:message('************** /Document Colors **************')"/>
		</xsl:if>
	</xsl:template>





	<!-- ===============================================
		 store all extracted boxes in memory
	     =============================================== -->
	<xsl:template name="store_all_boxes">
		<xsl:param name="XMLdoc"/>
		<!-- store all individual boxes -->
		<xsl:for-each select="xalan:nodeset($XMLdoc)//indd_document/sprd/page/descendant::box[(@type != 'chained_text')]">
			<xsl:variable name="d" select="locjs:store_box(string(@page_sequence),string(@type),string(@cont),string(@Self),string(@textflowid),string(@coords),string(@chainidx),string(@groupid),string(@matrix),string(@matrix_orig),string(@label),string(@firstflowid),string(@lastflowid),string(@previousflowid),string(@nextflowid),string(@angle),string(@shape_orig),string(@bbox),string(@pageJPEGScale),string(@allgroupid))"/>
			<!-- and chained boxes -->
			<xsl:for-each select="box">
				<xsl:variable name="d" select="locjs:store_box(string(@page_sequence),string(@type),string(@cont),string(@Self),string(@textflowid),string(@coords),string(@chainidx),string(@groupid),string(@matrix),string(@matrix_orig),string(@label),string(@firstflowid),string(@lastflowid),string(@previousflowid),string(@nextflowid),string(@angle),string(@shape_orig),string(@bbox),string(@pageJPEGScale),string(@allgroupid))"/>
			</xsl:for-each>
		</xsl:for-each>
		<xsl:if test="$DEBUG = 1"><xsl:variable name="d" select="locjs:print_boxes()"/></xsl:if>
	</xsl:template>



	<!-- ===============================================
		 sort boxes
	     =============================================== -->
	<xsl:template name="get_sorted_box_areas">
		<xsl:variable name="d" select="myutils:showMess('&#10;   ++ sorting boxes by area size','1')"/>
		<xsl:variable name="d" select="locjs:sort_box_areas()"/>
		<xsl:if test="$DEBUG = 1"><xsl:variable name="d" select="locjs:print_boxes('******* boxes sorted by area width *******')"/></xsl:if>

		<xsl:variable name="num_boxes"><xsl:value-of select="locjs:get_num_boxes()"/></xsl:variable>
		<xsl:if test="$num_boxes &gt; 0">
			<boxes sortorder="areawidth">
				<xsl:attribute name="num_boxes"><xsl:value-of select="$num_boxes"/></xsl:attribute>
				<xsl:variable name="d" select="locjs:reset_boxes_arr()"/>

				<xsl:variable name="d" select="myutils:showMess(concat('&#10;      ++ collecting ',$num_boxes,' boxes '),'1')"/>
				<xsl:call-template name="get_boxes_elements"/>
				<xsl:variable name="d" select="myutils:showMess('&#10;      -- collecting boxes complete','1')"/>
			</boxes>
		</xsl:if>
	</xsl:template>


	<xsl:template name="get_boxes_elements">
		<!-- xsl:variable name="d" select="myutils:showMess(concat('&#10;        + collecting box elements on page #',locjs:get_box_page(),'; processing box ',locjs:get_boxes_arr_ptr(),' of ',locjs:get_num_boxes_idx()),'1')"/ -->
		<box>
			<xsl:attribute name="pagesequence"><xsl:value-of select="locjs:get_box_page()"/></xsl:attribute>
			<xsl:attribute name="type"><xsl:value-of select="locjs:get_box_type()"/></xsl:attribute>
			<xsl:attribute name="cont"><xsl:value-of select="locjs:get_box_cont()"/></xsl:attribute>
			<xsl:attribute name="self"><xsl:value-of select="locjs:get_box_self()"/></xsl:attribute>
			<xsl:attribute name="textflowid"><xsl:value-of select="locjs:get_box_textflowid()"/></xsl:attribute>
			<xsl:attribute name="coords"><xsl:value-of select="locjs:get_box_coords()"/></xsl:attribute>
			<xsl:attribute name="chainidx"><xsl:value-of select="locjs:get_box_chainidx()"/></xsl:attribute>
			<xsl:attribute name="groupid"><xsl:value-of select="locjs:get_box_groupid()"/></xsl:attribute>
			<xsl:attribute name="allgroupid"><xsl:value-of select="locjs:get_box_allgroupids()"/></xsl:attribute>
			<xsl:attribute name="width"><xsl:value-of select="locjs:get_box_width()"/></xsl:attribute>
			<xsl:attribute name="height"><xsl:value-of select="locjs:get_box_height()"/></xsl:attribute>
			<xsl:attribute name="label"><xsl:value-of select="locjs:get_box_label()"/></xsl:attribute>
			<xsl:if test="locjs:get_outputFeatures() = '2'"><!--  PRO attributes -->
				<xsl:attribute name="matrix"><xsl:value-of select="locjs:get_box_matrix()"/></xsl:attribute>
				<xsl:attribute name="matrix_orig"><xsl:value-of select="locjs:get_box_matrix_orig()"/></xsl:attribute>
			</xsl:if>
		</box>

		<xsl:if test="locjs:next_box() >= 0">
			<xsl:call-template name="get_boxes_elements"/><!-- recall us -->
		</xsl:if>
	</xsl:template>



	<!-- ===============================================
		 group boxes to articles stuff
	     =============================================== -->
	<xsl:template name="create_article_groups">
		<xsl:param name="XMLdoc"/>

		<!-- create article groups from intersecting, grouped or chained boxes -->
		<xsl:variable name="d" select="locjs:group_articles()"/>

		<articlegroups>
			<xsl:attribute name="num_articles"><xsl:value-of select="locjs:get_num_articles()"/></xsl:attribute>
			<xsl:if test="locjs:get_num_articles() > 0">
				<xsl:variable name="d" select="locjs:reset_articles_arr()"/>
				<xsl:call-template name="get_document_articles">
					<xsl:with-param name="XMLdoc" select="$XMLdoc"/>
				</xsl:call-template>
			</xsl:if>
		</articlegroups>
	</xsl:template>


	<xsl:template name="get_document_articles">
		<xsl:param name="XMLdoc"/>
		<xsl:variable name="current_page" select="locjs:get_article_page()"/>
		<xsl:variable name="pageJPEG"><xsl:value-of select="$XMLdoc//descendant::page[@page_sequence=$current_page]/pageJPEG/."/></xsl:variable>
		<xsl:variable name="pageJPEGscale"><xsl:value-of select="$XMLdoc//descendant::page[@page_sequence=$current_page]/pageJPEG/@sizefactor"/></xsl:variable>
		<page>
			<xsl:attribute name="page_sequence"><xsl:value-of select="$current_page"/></xsl:attribute>
			<xsl:if test="$pageJPEG != ''">
				<xsl:attribute name="pageJPEG"><xsl:value-of select="$pageJPEG"/></xsl:attribute>
				<xsl:attribute name="pageJPEGscale"><xsl:value-of select="$pageJPEGscale"/></xsl:attribute>
			</xsl:if>
			<xsl:variable name="d" select="myutils:showMess(concat('&#10;      ++ grouping boxes to articles on page #',$current_page),'1')"/>
			<xsl:call-template name="get_all_page_articles">
				<xsl:with-param name="page"><xsl:value-of select="$current_page"/></xsl:with-param>
				<xsl:with-param name="pageJPEGscale"><xsl:value-of select="$pageJPEGscale"/></xsl:with-param>
				<xsl:with-param name="XMLdoc" select="$XMLdoc"/>
			</xsl:call-template>
		</page>
		<xsl:if test="locjs:have_articles() > 0">
			<xsl:call-template name="get_document_articles"><!-- recall us -->
				<xsl:with-param name="XMLdoc" select="$XMLdoc"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>


	<xsl:template name="get_all_page_articles">
		<xsl:param name="page"/>
		<xsl:param name="pageJPEGscale"/>
		<xsl:param name="XMLdoc"/>
		<article>
			<xsl:attribute name="idx"><xsl:value-of select="locjs:get_article_idx()"/></xsl:attribute>
			<xsl:attribute name="num_boxes"><xsl:value-of select="locjs:get_num_article_boxes()"/></xsl:attribute>
			<xsl:attribute name="page"><xsl:value-of select="$page"/></xsl:attribute>
			<xsl:attribute name="pageJPEGscale"><xsl:value-of select="$pageJPEGscale"/></xsl:attribute>
			<xsl:attribute name="coords"><xsl:value-of select="locjs:get_article_coords()"/></xsl:attribute>
			<xsl:attribute name="x1"><xsl:value-of select="locjs:get_article_x1()"/></xsl:attribute>
			<xsl:attribute name="y1"><xsl:value-of select="locjs:get_article_y1()"/></xsl:attribute>
			<xsl:attribute name="x2"><xsl:value-of select="locjs:get_article_x2()"/></xsl:attribute>
			<xsl:attribute name="y2"><xsl:value-of select="locjs:get_article_y2()"/></xsl:attribute>
			<xsl:variable name="self" select="locjs:get_article_boxid()"/>
			<xsl:attribute name="label"><xsl:value-of select="$XMLdoc//descendant::box[@Self=$self]/@label/."/></xsl:attribute>
			<xsl:variable name="d" select="locjs:reset_textshortcut()"/>

			<!-- get all article boxes -->
			<xsl:variable name="articleboxes">
				<xsl:call-template name="get_article_boxes">
					<xsl:with-param name="XMLdoc" select="$XMLdoc"/>
				</xsl:call-template>
			</xsl:variable>
			<!-- evtl. sort by Y and X position -->
			<xsl:choose>
				<xsl:when test="$sortBoxesByYposition != 0">
					<xsl:for-each select="xalan:nodeset($articleboxes)/*">
						<xsl:sort data-type="number" select="@y1"/>
						<xsl:sort data-type="number" select="@x1"/>
						<xsl:copy-of select="."/>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="$articleboxes"/>
				</xsl:otherwise>
			</xsl:choose>
			<textshortcut><xsl:value-of select="locjs:get_textshortcut()"/></textshortcut>
		</article>
		<xsl:if test="locjs:next_article() >= 0">
			<xsl:variable name="current_page" select="locjs:get_article_page()"/>
			<xsl:if test="$current_page = $page">
				<xsl:call-template name="get_all_page_articles" ><!-- recall us -->
					<xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
					<xsl:with-param name="pageJPEGscale"><xsl:value-of select="$pageJPEGscale"/></xsl:with-param>
					<xsl:with-param name="XMLdoc" select="$XMLdoc"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
	</xsl:template>


	<xsl:template name="get_article_boxes">
		<xsl:param name="XMLdoc"/>
		<xsl:variable name="self" select="locjs:get_article_boxid()"/>
		<box>
			<xsl:attribute name="self"><xsl:value-of select="$self"/></xsl:attribute>
			<xsl:attribute name="type"><xsl:value-of select="locjs:get_article_boxtype()"/></xsl:attribute>
			<xsl:attribute name="firstid"><xsl:value-of select="locjs:get_article_firstbox_chainid()"/></xsl:attribute>
			<xsl:attribute name="previousid"><xsl:value-of select="locjs:get_article_previousbox_id()"/></xsl:attribute>
			<xsl:attribute name="nextid"><xsl:value-of select="locjs:get_article_nextbox_id()"/></xsl:attribute>
			<xsl:attribute name="chainidx"><xsl:value-of select="locjs:get_article_box_chainidx()"/></xsl:attribute>
			<xsl:attribute name="label"><xsl:value-of select="$XMLdoc//descendant::box[@Self=$self]/@label/."/></xsl:attribute>
			<xsl:attribute name="coords"><xsl:value-of select="$XMLdoc//descendant::box[@Self=$self]/@coords/."/></xsl:attribute>
			<xsl:attribute name="page_sequence"><xsl:value-of select="$XMLdoc//descendant::box[@Self=$self]/@page_sequence/."/></xsl:attribute>
			<xsl:attribute name="page_name"><xsl:value-of select="$XMLdoc//descendant::box[@Self=$self]/@page_name/."/></xsl:attribute>
			<xsl:attribute name="groupid"><xsl:value-of select="locjs:get_article_box_groupid()"/></xsl:attribute>
			<xsl:attribute name="allgroupid"><xsl:value-of select="locjs:get_article_box_allgroupid()"/></xsl:attribute>
			<xsl:attribute name="x1"><xsl:value-of select="locjs:get_article_box_x1()"/></xsl:attribute>
			<xsl:attribute name="y1"><xsl:value-of select="locjs:get_article_box_y1()"/></xsl:attribute>
			<xsl:attribute name="x2"><xsl:value-of select="locjs:get_article_box_x2()"/></xsl:attribute>
			<xsl:attribute name="y2"><xsl:value-of select="locjs:get_article_box_y2()"/></xsl:attribute>
		</box>
		<xsl:variable name="txtsc"><xsl:value-of select="$XMLdoc//descendant::box[@Self=$self]/textshortcut/."/></xsl:variable>
		<xsl:if test="$txtsc != ''">
			<xsl:variable name="d" select="locjs:store_textshortcut(string($txtsc))"/>
		</xsl:if>
		<!-- xsl:variable name="m">&#10;___ OK</xsl:variable -->
		<xsl:if test="locjs:next_article_box() >= 0">
			<xsl:call-template name="get_article_boxes"><!-- recall us -->
				<xsl:with-param name="XMLdoc" select="$XMLdoc"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>



	<!-- add (most) given XSL parameters -->
	<xsl:template name="output_XSL_params">
		<call_parameters>
			<par name="XMLSRC_VERSION"><xsl:value-of select="$XMLSRC_VERSION"/></par>
			<par name="XMLSRC_ENCODING"><xsl:value-of select="$XMLSRC_ENCODING"/></par>
			<par name="XMLSRC_DOCTYPE_DECLARATION"><xsl:value-of select="$XMLSRC_DOCTYPE_DECLARATION"/></par>
			<par name="SYSTEM_OS_NAME"><xsl:value-of select="$SYSTEM_OS_NAME"/></par>
			<par name="SYSTEM_VM_VERSION"><xsl:value-of select="$SYSTEM_VM_VERSION"/></par>
			<par name="SYSTEM_DEFAULT_CHARSET"><xsl:value-of select="$SYSTEM_DEFAULT_CHARSET"/></par>
			<par name="TRANSFORM_ENGINE"><xsl:value-of select="$TRANSFORM_ENGINE"/></par>
			<par name="INPUT_PATH"><xsl:value-of select="$INPUT_PATH"/></par>
			<par name="INPUT_SUB_PATH"><xsl:value-of select="$INPUT_SUB_PATH"/></par>
			<par name="INPUT_NAME"><xsl:value-of select="$INPUT_NAME"/></par>
			<par name="OUTPUT_PATH"><xsl:value-of select="$OUTPUT_PATH"/></par>
			<par name="OUTPUT_NAME"><xsl:value-of select="$OUTPUT_NAME"/></par>
			<par name="STYLESHEET_PATH"><xsl:value-of select="$STYLESHEET_PATH"/></par>
			<par name="STYLESHEET_NAME"><xsl:value-of select="$STYLESHEET_NAME"/></par>
			<par name="LOGFILE_WRITE"><xsl:value-of select="$LOGFILE_WRITE"/></par>
			<par name="LOGFILE_PATH"><xsl:value-of select="$LOGFILE_PATH"/></par>
			<par name="LOGFILE_NAME"><xsl:value-of select="$LOGFILE_NAME"/></par>
			<par name="APP_DIR"><xsl:value-of select="$APP_DIR"/></par>
			<par name="USER_NAME"><xsl:value-of select="$USER_NAME"/></par>
			<par name="USER_HOME"><xsl:value-of select="$USER_HOME"/></par>
			<par name="USER_DIR"><xsl:value-of select="$USER_DIR"/></par>
			<par name="LOCAL_MACHINE_NAME"><xsl:value-of select="$LOCAL_MACHINE_NAME"/></par>
			<par name="GS_VERSION"><xsl:value-of select="$GS_VERSION"/></par>
			<par name="GS_VERSION_NUM"><xsl:value-of select="$GS_VERSION_NUM"/></par>
			<par name="GS_PGM_PATH"><xsl:value-of select="$GS_PGM_PATH"/></par>
			<par name="GS_ENVIR"><xsl:value-of select="$GS_ENVIR"/></par>
			<par name="IM_VERSION"><xsl:value-of select="$IM_VERSION"/></par>
			<par name="IM_VERSION_NUM"><xsl:value-of select="$IM_VERSION_NUM"/></par>
			<par name="IM_PGM_PATH"><xsl:value-of select="$IM_PGM_PATH"/></par>
			<par name="IM_PGM_CONVERT"><xsl:value-of select="$IM_PGM_CONVERT"/></par>
			<par name="IM_PGM_IDENTIFY"><xsl:value-of select="$IM_PGM_IDENTIFY"/></par>
			<par name="IM_ENVIR"><xsl:value-of select="$IM_ENVIR"/></par>
			<par name="DEBUG"><xsl:value-of select="$DEBUG"/></par>
			<par name="DEBUGIMAGES"><xsl:value-of select="$DEBUGIMAGES"/></par>
			<par name="DEBUG_cssfile"><xsl:value-of select="$DEBUG_cssfile"/></par>
			<par name="metaViewportContent"><xsl:value-of select="$metaViewportContent"/></par>

			<par name="documentPDFname"><xsl:value-of select="$documentPDFname"/></par>
			<par name="documentPDFnameSearch"><xsl:value-of select="$documentPDFnameSearch"/></par>
			<par name="outputMode"><xsl:value-of select="$outputMode"/></par>

			<par name="outputModeCustomXSL"><xsl:value-of select="$outputModeCustomXSL"/></par>
			<par name="outputXMLComplexity"><xsl:value-of select="$outputXMLComplexity"/></par>
			<par name="pageJPEGScale"><xsl:value-of select="$pageJPEGScale"/></par>
			<par name="pageJPEGQuality"><xsl:value-of select="$pageJPEGQuality"/></par>
			<par name="pageJPEGdpi"><xsl:value-of select="$pageJPEGdpi"/></par>
			<par name="pageJPEGParams"><xsl:value-of select="$pageJPEGParams"/></par>
			<par name="imageInputParam"><xsl:value-of select="$imageInputParam"/></par>

			<par name="imageAddTargetPrefix"><xsl:value-of select="$imageAddTargetPrefix"/></par>
			<par name="imageOverwriteTargetIfExists"><xsl:value-of select="$imageOverwriteTargetIfExists"/></par>
			<par name="imageTYPE"><xsl:value-of select="$imageTYPE"/></par>
			<par name="imageQUALITY"><xsl:value-of select="$imageQUALITY"/></par>
			<par name="imageDPI"><xsl:value-of select="$imageDPI"/></par>
			<par name="imageSCALE"><xsl:value-of select="$imageSCALE"/></par>
			<par name="imageDoROTATE"><xsl:value-of select="$imageDoROTATE"/></par>
			<par name="imageCUT2imagebox"><xsl:value-of select="$imageCUT2imagebox"/></par>
			<par name="imageOutputFinishParam"><xsl:value-of select="$imageOutputFinishParam"/></par>
			<par name="imageNoDensityParam"><xsl:value-of select="$imageNoDensityParam"/></par>
			<par name="imagePARAMS"><xsl:value-of select="$imagePARAMS"/></par>
			<par name="imageCopyToOutput"><xsl:value-of select="$imageCopyToOutput"/></par>
			<par name="imageEXCLUDE"><xsl:value-of select="$imageEXCLUDE"/></par>
			<par name="imageCROP"><xsl:value-of select="$imageCROP"/></par>
			<par name="imagesMORE"><xsl:value-of select="$imagesMORE"/></par>
			<par name="imageNOCONVERT"><xsl:value-of select="$imageNOCONVERT"/></par>
			<par name="imagePreviewUseOriginals"><xsl:value-of select="$imagePreviewUseOriginals"/></par>
			<par name="imageMissingCreateFromPagePreview"><xsl:value-of select="$imageMissingCreateFromPagePreview"/></par>
			<par name="imagesTotalSources"><xsl:value-of select="$imagesTotalSources"/></par>
			<par name="imagesTotalSourcesMissing"><xsl:value-of select="$imagesTotalSourcesMissing"/></par>
			<par name="XSLCSSPath"><xsl:value-of select="$XSLCSSPath"/></par>
			<par name="CSSpath"><xsl:value-of select="$CSSpath"/></par>
			<par name="CSSname"><xsl:value-of select="$CSSname"/></par>
			<par name="CSSnameFinal"><xsl:value-of select="$thecssname"/></par>
			<par name="overwriteCSSfiles"><xsl:value-of select="$overwriteCSSfiles"/></par>
			<par name="CSSexpanded"><xsl:value-of select="$CSSexpanded"/></par>
			<par name="CSSclassNamesNoUnderscore"><xsl:value-of select="$CSSclassNamesNoUnderscore"/></par>
			<par name="CSSclassNamesASCII"><xsl:value-of select="$CSSclassNamesASCII"/></par>
			<par name="CSSfontFamilyString"><xsl:value-of select="$CSSfontFamilyString"/></par>
			<par name="catchRadius"><xsl:value-of select="$catchRadius"/></par>
			<par name="allBoxesNoCatch"><xsl:value-of select="$allBoxesNoCatch"/></par>
			<par name="unassignedBoxesNoCatch"><xsl:value-of select="$unassignedBoxesNoCatch"/></par>
			<par name="emptyBoxesNoCatch"><xsl:value-of select="$emptyBoxesNoCatch"/></par>
			<par name="textBoxesNoCatch"><xsl:value-of select="$textBoxesNoCatch"/></par>
			<par name="chainedBoxesNoCatch"><xsl:value-of select="$chainedBoxesNoCatch"/></par>
			<par name="chainedFirstBoxesNoCatch"><xsl:value-of select="$chainedFirstBoxesNoCatch"/></par>
			<par name="chainedFollowingBoxesNoCatch"><xsl:value-of select="$chainedFollowingBoxesNoCatch"/></par>
			<par name="imageBoxesNoCatch"><xsl:value-of select="$imageBoxesNoCatch"/></par>
			<par name="pageframingBoxesNoCatch"><xsl:value-of select="$pageframingBoxesNoCatch"/></par>
			<par name="pageframingBoxSizeThreshold"><xsl:value-of select="$pageframingBoxSizeThreshold"/></par>
			<par name="pageframingBoxNoExport"><xsl:value-of select="$pageframingBoxNoExport"/></par>

			<par name="suppressAllEmptyBox"><xsl:value-of select="$suppressAllEmptyBox"/></par>
			<par name="suppressEmptyTextBox"><xsl:value-of select="$suppressEmptyTextBox"/></par>
			<par name="suppressEmptyImageBox"><xsl:value-of select="$suppressEmptyImageBox"/></par>
			<par name="suppressUnassignedBox"><xsl:value-of select="$suppressUnassignedBox"/></par>
			<par name="suppressLineBox"><xsl:value-of select="$suppressLineBox"/></par>
			<par name="suppressNonPrintingBox"><xsl:value-of select="$suppressNonPrintingBox"/></par>

			<par name="replaceFont"><xsl:value-of select="$replaceFont"/></par>
			<par name="fontsizeFactor"><xsl:value-of select="$fontsizeFactor"/></par>
			<par name="fontsizeMinimum"><xsl:value-of select="$fontsizeMinimum"/></par>
			<par name="fontsizeUnits"><xsl:value-of select="$fontsizeUnits"/></par>
			<par name="fontsizeBase"><xsl:value-of select="$fontsizeBase"/></par>
			<par name="wwwLinkStyles"><xsl:value-of select="$wwwLinkStyles"/></par>
			<par name="continuedArticleStyles"><xsl:value-of select="$continuedArticleStyles"/></par>
			<par name="includeDescription"><xsl:value-of select="$includeDescription"/></par>
			<par name="CROPBOXmode"><xsl:value-of select="$CROPBOXmode"/></par>
			<par name="PDFhasCropBox"><xsl:value-of select="$PDFhasCropBox"/></par>
			<par name="PDFhasTrimBox"><xsl:value-of select="$PDFhasTrimBox"/></par>
			<par name="PDFnoBoxCropping"><xsl:value-of select="$PDFnoBoxCropping"/></par>
			
			<par name="INTERMEDIARY_XML_only"><xsl:value-of select="$INTERMEDIARY_XML_only"/></par>
			<par name="INTERMEDIARY_XML_preserve"><xsl:value-of select="$INTERMEDIARY_XML_preserve"/></par>
			<par name="XPLATFORM_NAMES"><xsl:value-of select="$XPLATFORM_NAMES"/></par>
			<par name="CONVERTFILENAMES"><xsl:value-of select="$CONVERTFILENAMES"/></par>
			<par name="MAX_IMAGENAME_LENGTH"><xsl:value-of select="$MAX_IMAGENAME_LENGTH"/></par>
			<par name="OUTPUT_FEATURES"><xsl:value-of select="$OUTPUT_FEATURES"/></par>
			<par name="FOLDERINDEXNAME"><xsl:value-of select="$FOLDERINDEXNAME"/></par>
			<par name="INDEXPHPNAME"><xsl:value-of select="$INDEXPHPNAME"/></par>
			<par name="COLORPROFILE_ignore"><xsl:value-of select="$COLORPROFILE_ignore"/></par>
			<par name="COLORPROFILE"><xsl:value-of select="$COLORPROFILE"/></par>
			<par name="COLORPROFILES_path"><xsl:value-of select="$COLORPROFILES_path"/></par>
			<par name="INTERNET_AWARE_FONTNAMES"><xsl:value-of select="$INTERNET_AWARE_FONTNAMES"/></par>
			<par name="TABLE_CELLS_WIDTH_PRESERVE"><xsl:value-of select="$TABLE_CELLS_WIDTH_PRESERVE"/></par>
			<par name="TABLE_BORDER_COLLAPSE"><xsl:value-of select="$TABLE_BORDER_COLLAPSE"/></par>
			<par name="TABLE_AS_BLOCK"><xsl:value-of select="$TABLE_AS_BLOCK"/></par>
			<par name="ALLOW_PARACLASS_OVERRIDES"><xsl:value-of select="$ALLOW_PARACLASS_OVERRIDES"/></par>
			<par name="magnifyingGlass"><xsl:value-of select="$magnifyingGlass"/></par>
			<par name="excludeHiddenLayers"><xsl:value-of select="$excludeHiddenLayers"/></par>
			<par name="excludeLayers"><xsl:value-of select="$excludeLayers"/></par>
			<par name="includeLayers"><xsl:value-of select="$includeLayers"/></par>
			<par name="includeXMLtags"><xsl:value-of select="$includeXMLtags"/></par>
			<par name="includeMetaData"><xsl:value-of select="$includeMetaData"/></par>
			<par name="excludeNotes"><xsl:value-of select="$excludeNotes"/></par>
			<par name="includeAnchoredObjectsBlock"><xsl:value-of select="$includeAnchoredObjectsBlock"/></par>
			<par name="useExternalStorage"><xsl:value-of select="$useExternalStorage"/></par>
			<par name="memoryUsageMode"><xsl:value-of select="$memoryUsageMode"/></par>
			<par name="suppressSiteElements"><xsl:value-of select="$suppressSiteElements"/></par>
			<par name="suppressExportMouseOvers"><xsl:value-of select="$suppressExportMouseOvers"/></par>
			<par name="showArticleInNewWindow"><xsl:value-of select="$showArticleInNewWindow"/></par>
			<par name="websiteParams"><xsl:value-of select="$websiteParams"/></par>
			<par name="groupBoxesToArticles"><xsl:value-of select="$groupBoxesToArticles"/></par>
			<par name="sortBoxesByAreaSize"><xsl:value-of select="$sortBoxesByAreaSize"/></par>
			<par name="sortBoxesByYposition"><xsl:value-of select="$sortBoxesByYposition"/></par>
			<par name="sortBoxYtolerance"><xsl:value-of select="$sortBoxYtolerance"/></par>
			<par name="addMissingPages"><xsl:value-of select="$addMissingPages"/></par>
			<par name="preserveControlCharacters"><xsl:value-of select="$preserveControlCharacters"/></par>
			<par name="preconvertTextFlags"><xsl:value-of select="$preconvertTextFlags"/></par>
			<par name="characterAttribsSuppress"><xsl:value-of select="$characterAttribsSuppress"/></par>
			<par name="paragraphAttribsSuppress"><xsl:value-of select="$paragraphAttribsSuppress"/></par>
			<par name="textshortcutLength"><xsl:value-of select="$textshortcutLength"/></par>

			<par name="pub_companyName"><xsl:value-of select="$pub_companyName"/></par>
			<par name="pub_objectName"><xsl:value-of select="$pub_objectName"/></par>
			<par name="pub_objectShortcut"><xsl:value-of select="$pub_objectShortcut"/></par>
			<par name="pub_issueYear"><xsl:value-of select="$pub_issueYear"/></par>
			<par name="pub_issueDate"><xsl:value-of select="$pub_issueDate"/></par>

			<par name="addVirtualKeyboard"><xsl:value-of select="$addVirtualKeyboard"/></par>

			<par name="extractImageMetaData"><xsl:value-of select="$extractImageMetaData"/></par>
			<par name="fullImageMetaData"><xsl:value-of select="$fullImageMetaData"/></par>
			<par name="typeImageMetaData"><xsl:value-of select="$typeImageMetaData"/></par>

			<par name="pageTurnMode"><xsl:value-of select="$pageTurnMode"/></par>

			<par name="mainExportFolderIn"><xsl:value-of select="$mainExportFolderIn"/></par>
			<par name="mainExportFolderOut"><xsl:value-of select="$mainExportFolderOut"/></par>

			<par name="userVar1"><xsl:value-of select="$userVar1"/></par>
			<par name="userVar2"><xsl:value-of select="$userVar2"/></par>
			<par name="userVar3"><xsl:value-of select="$userVar3"/></par>
			<par name="userVar4"><xsl:value-of select="$userVar4"/></par>
			<par name="userVar5"><xsl:value-of select="$userVar5"/></par>
			<par name="userVar6"><xsl:value-of select="$userVar6"/></par>
			<par name="userVar7"><xsl:value-of select="$userVar7"/></par>
			<par name="userVar8"><xsl:value-of select="$userVar8"/></par>
			<par name="userVar9"><xsl:value-of select="$userVar9"/></par>
		</call_parameters>
	</xsl:template>


	<xsl:template name="get_metadata">
		<metadata>
			<meta name="document_cMep"><xsl:copy-of select="$cMepData"/></meta>
		</metadata>
	</xsl:template>


	<xsl:template name="get_layers">
		<layers>
			<xsl:for-each select="/Documents/Document/Layer">
				<layer>
					<xsl:for-each select="@*">
						<xsl:attribute name="{name()}"><xsl:value-of select="locjs:cleanSeparator(string(.))"/></xsl:attribute>
					</xsl:for-each>
					<xsl:attribute name="LayerColor"><xsl:value-of select="Properties/LayerColor/."/></xsl:attribute>
				</layer>
			</xsl:for-each>
		</layers>
	</xsl:template>

	<!-- ===============================================
		 get expanded styles (PRO version)
	     =============================================== -->
	<xsl:template name="get_styles_expanded">
		<xsl:comment> ***** extended info (PRO version only) ***** </xsl:comment>
		<extended_infos>
		<xsl:comment> ***** colors ***** </xsl:comment>
		<colors>
			<xsl:for-each select="/Documents/Document/Graphic/Color">
				<color>
					<xsl:attribute name="type"><xsl:value-of select="name()"/></xsl:attribute>
					<xsl:for-each select="@*">
						<xsl:attribute name="{name()}"><xsl:value-of select="locjs:cleanSeparator(string(.))"/></xsl:attribute>
					</xsl:for-each>
				</color>
			</xsl:for-each>
			<xsl:for-each select="/Documents/Document/Graphic/Ink">
				<color>
					<xsl:attribute name="type"><xsl:value-of select="name()"/></xsl:attribute>
					<xsl:for-each select="@*">
						<xsl:attribute name="{name()}"><xsl:value-of select="locjs:cleanSeparator(string(.))"/></xsl:attribute>
					</xsl:for-each>
				</color>
			</xsl:for-each>
			<xsl:for-each select="/Documents/Document/Graphic/Tint">
				<color>
					<xsl:attribute name="type"><xsl:value-of select="name()"/></xsl:attribute>
					<xsl:for-each select="@*">
						<xsl:attribute name="{name()}"><xsl:value-of select="locjs:cleanSeparator(string(.))"/></xsl:attribute>
					</xsl:for-each>
				</color>
			</xsl:for-each>
			<xsl:for-each select="/Documents/Document/Graphic/Swatch">
				<color>
					<xsl:attribute name="type"><xsl:value-of select="name()"/></xsl:attribute>
					<xsl:for-each select="@*">
						<xsl:attribute name="{name()}"><xsl:value-of select="locjs:cleanSeparator(string(.))"/></xsl:attribute>
					</xsl:for-each>
				</color>
			</xsl:for-each>
			<xsl:for-each select="/Documents/Document/Graphic/Gradient">
				<color>
					<xsl:attribute name="type"><xsl:value-of select="name()"/></xsl:attribute>
					<xsl:for-each select="@*">
						<xsl:attribute name="{name()}"><xsl:value-of select="locjs:cleanSeparator(string(.))"/></xsl:attribute>
					</xsl:for-each>
					<xsl:for-each select="GradientStop">
						<gstp>
							<xsl:for-each select="@*">
								<xsl:attribute name="{name()}"><xsl:value-of select="locjs:cleanSeparator(string(.))"/></xsl:attribute>
							</xsl:for-each>
						</gstp>
					</xsl:for-each>
				</color>
			</xsl:for-each>
		</colors>

		<xsl:comment> ***** fonts ***** </xsl:comment>
		<fonts>
			<xsl:for-each select="/Documents/Document/Fonts/FontFamily">
				<font_family>
					<xsl:for-each select="@*">
						<xsl:attribute name="{name()}"><xsl:value-of select="locjs:cleanSeparator(string(.))"/></xsl:attribute>
					</xsl:for-each>
					<xsl:for-each select="Font">
						<font>
							<xsl:for-each select="@*">
								<xsl:attribute name="{name()}"><xsl:value-of select="locjs:cleanSeparator(string(.))"/></xsl:attribute>
							</xsl:for-each>
						</font>
					</xsl:for-each>
				</font_family>
			</xsl:for-each>
		</fonts>

		<xsl:comment> ***** style sheets ***** </xsl:comment>
		<stylesheets>
			<paragraphs>
				<xsl:for-each select="/Documents/Document/Styles/RootParagraphStyleGroup//ParagraphStyle">
					<style>
						<xsl:attribute name="class"><xsl:value-of select="locjs:get_style_class_name_from_stylename(string(@Name),'ParagraphStyle')"/></xsl:attribute>
						<xsl:for-each select="@*">
							<xsl:attribute name="{name()}"><xsl:value-of select="locjs:cleanSeparator(string(.))"/></xsl:attribute>
						</xsl:for-each>
						<xsl:variable name="parasets" select="locjs:store_parasets( string(@AppliedParagraphStyle), string(@Justification), 
															string(@LeftIndent), string(@RightIndent), string(@FirstLineIndent), string(@LastLineIndent), 
															string(@SpaceBefore), string(@SpaceAfter), string(@StartParagraph), 
															string(@KeepWithNext), string(@KeepLinesTogether), string(@KeepWithPrevious), 
															string(@DropCapCharacters), string(@DropCapLines), string(@DropcapDetail), 
															string(@GridAlignment), string(@Hyphenation))"/>

						<xsl:variable name="paratabs">
							<xsl:for-each select="Properties/TabList/ListItem">
								<xsl:value-of select="Alignment"/>_<xsl:value-of select="AlignmentCharacter"/>_<xsl:value-of select="Leader"/>_<xsl:value-of select="Position"/>
								<xsl:if test="position() != last()"><xsl:text>/tab/</xsl:text></xsl:if>
							</xsl:for-each>
						</xsl:variable>
						<xsl:variable name="name" select="locjs:store_paratabs(string($paratabs))"/>

						<xsl:variable name="pararules" select="locjs:store_pararules(string(@RuleAbove),string(Properties/RuleAboveType),string(@RuleAboveLineWeight),string(@RuleAboveWidth),string(@RuleAboveOffset),string(@RuleAboveLeftIndent),string(@RuleAboveRightIndent),string(@KeepRuleAboveInFrame),string(Properties/RuleAboveColor),string(@RuleAboveTint),string(@RuleAboveOverprint),string(Properties/RuleAboveGapColor),string(@RuleAboveGapTint),string(@RuleAboveGapOverprint),
																string(@RuleBelow),string(Properties/RuleBelowType),string(@RuleBelowLineWeight),string(@RuleBelowWidth),string(@RuleBelowOffset),string(@RuleBelowLeftIndent),string(@RuleBelowRightIndent),string(@KeepRuleBelowInFrame),string(Properties/RuleBelowColor),string(@RuleBelowTint),string(@RuleBelowOverprint),string(Properties/RuleBelowGapColor),string(@RuleBelowGapTint),string(@RuleBelowGapOverprint))"/>
						<xsl:variable name="paralist" select="locjs:store_paralist( string(@BulletsAndNumberingListType), 
															string(Properties/AppliedNumberingList), 
															string(@NumberingLevel), 
															string(Properties/NumberingFormat), 
															string(@NumberingExpression), 
															string(Properties/BulletsCharacterStyle), 
															string(Properties/NumberingCharacterStyle), 
															string(@NumberingStartAt), 
															string(@NumberingContinue), 
															string(@NumberingAlignment), 
															string(@BulletsAlignment), 
															string(Properties/BulletChar/@BulletCharacterValue),
															string(@BulletsTextAfter)
															)"/>
						<xsl:value-of disable-output-escaping="yes" select="locjs:get_parasetsXMLtag()"/>
						<xsl:value-of disable-output-escaping="yes" select="locjs:get_pararulesXMLtag()"/>
						<xsl:value-of disable-output-escaping="yes" select="locjs:get_paratabsXMLtag()"/>
						<xsl:value-of disable-output-escaping="yes" select="locjs:get_paralistXMLtag()"/>
					</style>
				</xsl:for-each>
			</paragraphs>

			<characters>
				<xsl:for-each select="/Documents/Document/Styles/RootCharacterStyleGroup//CharacterStyle">
					<style>
						<xsl:attribute name="class"><xsl:value-of select="locjs:get_style_class_name_from_stylename(string(@Name),'CharacterStyle')"/></xsl:attribute>
						<xsl:for-each select="@*">
							<xsl:attribute name="{name()}"><xsl:value-of select="locjs:cleanSeparator(string(.))"/></xsl:attribute>
						</xsl:for-each>
					</style>
				</xsl:for-each>
			</characters>

			<tables>
				<xsl:for-each select="/Documents/Document/Styles/RootTableStyleGroup//TableStyle">
					<style>
						<xsl:attribute name="class"><xsl:value-of select="locjs:get_style_class_name_from_stylename(string(@Name),'TableStyle')"/></xsl:attribute>
						<xsl:for-each select="@*">
							<xsl:attribute name="{name()}"><xsl:value-of select="locjs:cleanSeparator(string(.))"/></xsl:attribute>
						</xsl:for-each>
					</style>
				</xsl:for-each>
			</tables>

			<cells>
				<xsl:for-each select="/Documents/Document/Styles/RootCellStyleGroup//CellStyle">
					<style>
						<xsl:attribute name="class"><xsl:value-of select="locjs:get_style_class_name_from_stylename(string(@Name),'CellStyle')"/></xsl:attribute>
						<xsl:for-each select="@*">
							<xsl:attribute name="{name()}"><xsl:value-of select="locjs:cleanSeparator(string(.))"/></xsl:attribute>
						</xsl:for-each>
					</style>
				</xsl:for-each>
			</cells>

			<objects>
				<xsl:for-each select="/Documents/Document/Styles/RootObjectStyleGroup//ObjectStyle">
					<style>
						<xsl:attribute name="class"><xsl:value-of select="locjs:get_style_class_name_from_stylename(string(@Name),'ObjectStyle')"/></xsl:attribute>
						<xsl:for-each select="@*">
							<xsl:attribute name="{name()}"><xsl:value-of select="locjs:cleanSeparator(string(.))"/></xsl:attribute>
						</xsl:for-each>
					</style>
				</xsl:for-each>
			</objects>

			<strokes>
				<xsl:for-each select="/Documents/Document/Graphic/StrokeStyle">
					<stroke>
						<xsl:attribute name="class"><xsl:value-of select="locjs:get_style_class_name_from_stylename(string(@Name),'StrokeStyle')"/></xsl:attribute>
						<xsl:for-each select="@*">
							<xsl:attribute name="{name()}"><xsl:value-of select="locjs:cleanSeparator(string(.))"/></xsl:attribute>
						</xsl:for-each>
					</stroke>
				</xsl:for-each>
			</strokes>
		</stylesheets>

		<xsl:comment> ***** conditional text ***** </xsl:comment>
		<textconditions>
			<xsl:for-each select="/Documents/Document/Condition">
				<condition>
					<xsl:for-each select="@*">
						<xsl:attribute name="{name()}"><xsl:value-of select="locjs:cleanSeparator(string(.))"/></xsl:attribute>
					</xsl:for-each>
				</condition>
			</xsl:for-each>
		</textconditions>

		</extended_infos>
	</xsl:template>


	<!-- ############################################################################# -->
	<!-- =========================
		 the output creator
		 ========================= -->
	<!-- ========= what output xsl to include or none to create intermediary XML file only -->

	<xsl:include href="IMXepaper_includes.xsl"/><!-- create special output like other XML, HTML ... -->



	<!-- ############################################################################# -->
	<!-- =========================
		 our external JAVA Script functions: IMPORTED FROM EXTERNAL FILE
		 ========================= -->
	<lxslt:component prefix="pubjs">
	<lxslt:script lang="javascript" src="public.js"></lxslt:script>
	</lxslt:component>


	<!-- ############################################################################# -->
	<!-- =========================
		 our local JAVA Script functions: IMPORTED FROM EXTERNAL FILE
		 ========================= -->
	<lxslt:component prefix="locjs">
	<lxslt:script lang="javascript" src="IMXepaper.js"></lxslt:script>
	</lxslt:component>

	<!-- =========================
		 our local JAVA Script functions: MERGED
		 ========================= -->
<!--
	<lxslt:component prefix="locjs">
	<lxslt:script lang="javascript">
	//<![CDATA[
// place content of file 'INXepaper.js' here
// and remove above
//	<lxslt:component prefix="locjs">
//	....
//	</lxslt:component>
	//]]>
	</lxslt:script>
	</lxslt:component>
-->



</xsl:stylesheet>
