<?xml version="1.0" encoding="UTF-8"?>
<!-- 
 ======================================================================
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.

THE PRODUCER:
Andreas Imhof
ai@aiedv.ch

Version: 46
Version date: 20200219
======================================================================
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
				xmlns:lxslt="http://xml.apache.org/xslt"
				xmlns:xalan="http://xml.apache.org/xalan" 
				exclude-result-prefixes="xalan lxslt"
				version="1.0">

	<!-- =========================
		 what xsl to include to create the target output or none to create intermediary XML file only
		 ========================= -->

	<xsl:include href="IMX2xmlEpaperArticles.xsl"/><!-- create XML output with boxes grouped to articles from intermediary file -->
	<xsl:include href="IMXstylesWriter.xsl"/><!-- create XML output with boxes grouped to articles from intermediary file -->

	<!-- add Font transforms to include at runtime -->
	<xsl:include href="FontTransform.xsl"/><!-- Font/Style conversions -->

	<!-- add any other external file to include at runtime -->



	<!-- =============================== -->
	<!-- declare which named templates to run as pre-processors -->
	<xsl:variable name="xsl-preprocessors">
		<xsl-preprocessors>
			<xsl-stylesheets>
				<call-template>get_styles</call-template><!-- DO NOT REMOVE! defined in IMXstylesWriter.xsl. Retrieve styles and write the CSS file -->
				<call-template>custom_css_writer</call-template><!-- DO NOT REMOVE! defined in IMXstylesWriter.xsl. Retrieve styles and write the custom CSS file -->

				<!-- ad your own dedicated template names -->
				<!-- call-template>my_custom_template_name</call-template-->
			</xsl-stylesheets>
		</xsl-preprocessors>
	</xsl:variable>

	<!-- Predefinition of named pre-processing template dummies
		remove or comment below template(s) if they are used in an other loaded dedicated stylesheet file -->
	<xsl:template name="xsl-preprocessor1">
	</xsl:template>
	<xsl:template name="xsl-preprocessor2">
	</xsl:template>
	<xsl:template name="xsl-preprocessor3">
	</xsl:template>



	<!-- =============================== -->
	<!-- declare which named templates to run as post-processors -->
	<xsl:variable name="xsl-postprocessors">
		<xsl-postprocessors>
			<xsl-stylesheets>
				<call-template>makeXMLdefaultExport</call-template><!-- DO NOT REMOVE! defined in IMX2xmlEpaperArticles.xsl. create output XML file from internal intermediary XML file -->

				<!-- ad your own dedicated template names -->
				<!-- call-template>my_custom_template_name</call-template-->
			</xsl-stylesheets>
		</xsl-postprocessors>
	</xsl:variable>

	<!-- Predefinition of named post-processing template dummies
		remove or comment below template(s) if they are used in an other loaded dedicated stylesheet file -->
	<xsl:template name="xsl-postprocessor1">
	</xsl:template>
	<xsl:template name="xsl-postprocessor2">
	</xsl:template>
	<xsl:template name="xsl-postprocessor3">
	</xsl:template>
</xsl:stylesheet>
