<?xml version="1.0" encoding="UTF-8"?>
<!-- 
 ======================================================================
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.

THE PRODUCER:
Andreas Imhof
ai@aiedv.ch

Version: 46
Version date: 20200219
======================================================================
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
				xmlns:lxslt="http://xml.apache.org/xslt"
				xmlns:xalan="http://xml.apache.org/xalan" 
				xmlns:myutils="com.epaperarchives.batchxslt.utils"
				xmlns:locjs="loc_funcs"
				xmlns:pubjs="pub_funcs"

				extension-element-prefixes="locjs pubjs"
				exclude-result-prefixes="locjs pubjs"
				version="1.0">

	<xsl:output method="xml" />
	<xsl:output media-type="text/xml"/>
	<xsl:output omit-xml-declaration="no"/>

	<xsl:output indent="no"/>
	<xsl:output encoding="UTF-8"/>




<!-- ================ HERE WE GO ================ -->
	<!-- ===============================================
		 get defined paragraph, character and table styles and write external css
	     =============================================== -->
	<xsl:template name="get_styles">

		<xsl:if test="$DEBUG = 1">
			<xsl:variable name="mess1">************** creating CSS: <xsl:value-of select="$csspathname" /></xsl:variable>
			<xsl:variable name="d1" select="locjs:message(string($mess1))"/>
		</xsl:if>

		<xsl:variable name="d1" select="myutils:showMess('&#10;   ++ Retrieving stylesheets ','1')"/>

		<!-- ==================== -->
		<!-- the object styles -->
		<xsl:for-each select="/Documents/Document/Styles/RootObjectStyleGroup//ObjectStyle">
			<xsl:variable name="d1" select="locjs:init_styles()"/>
			<xsl:variable name="d2" select="locjs:store_styleType(name())"/>
			<xsl:variable name="d3" select="locjs:store_styleID(string(@Self))"/><!-- @Self="ParagraphStyle/$ID/[None]]" -->
			<xsl:variable name="d4" select="locjs:store_styleName(locjs:plain_Name(string(@Name)))"/><!-- @Name="$ID/[None]" -->
			<xsl:variable name="d5" select="locjs:store_styleBasedOn(string(Properties/BasedOn/.))"/>

			<xsl:if test="$CSSexpanded = '1'"><!-- enhance with all style attribs -->
				<xsl:for-each select="@*"><!-- here you could adapt or suppress unwanted attributes -->
					<xsl:variable name="d" select="locjs:store_fullAttribute(string(name()),string(.))"/>
				</xsl:for-each>
			</xsl:if>

			<xsl:variable name="d" select="locjs:css_styles_arr_add_style()"/>
		</xsl:for-each>
		<xsl:variable name="d" select="locjs:css_styles_merge_basedon('ObjectStyle')"/>


		<!-- ==================== -->
		<!-- the paragraph styles -->
		<xsl:for-each select="/Documents/Document/Styles/RootParagraphStyleGroup//ParagraphStyle">
			<xsl:variable name="d1" select="locjs:init_styles()"/>
			<xsl:variable name="d2" select="locjs:store_styleType(name())"/>
			<xsl:variable name="d3" select="locjs:store_styleID(string(@Self))"/><!-- @Self="ParagraphStyle/$ID/[No paragraph style]" -->
			<xsl:variable name="d4" select="locjs:store_styleName(locjs:plain_Name(string(@Name)))"/><!-- @Name="$ID/[No paragraph style]" -->
			<xsl:variable name="d5" select="locjs:store_styleBasedOn(string(Properties/BasedOn/.))"/>
			
			<xsl:if test="@BulletsAndNumberingListType = 'BulletList'">
				<xsl:variable name="d5" select="locjs:store_bulletChar(string(Properties/BulletChar/@BulletCharacterValue/.))"/>
			</xsl:if>

			<xsl:variable name="self" select="@Self/."/>
			<!--xsl:variable name="d" select="locjs:message(concat('#*#*#*#*#*#*#*#*#*#*#*#*#*#* para style Self: ',$self))"/-->
			<xsl:if test="not(contains(@Name,'[No '))">
				<xsl:apply-templates select="/Documents/Document/Styles/RootParagraphStyleGroup//ParagraphStyle[@Self = $self]" mode="get_styles"/>
			</xsl:if>

			<xsl:if test="$CSSexpanded = '1'"><!-- enhance with all style attribs -->
				<xsl:for-each select="@*"><!-- here you could adapt or suppress unwanted attributes -->
					<xsl:variable name="d" select="locjs:store_fullAttribute(string(name()),string(.))"/>
				</xsl:for-each>
			</xsl:if>

			<xsl:variable name="d" select="locjs:css_styles_arr_add_style()"/>
		</xsl:for-each>
		<xsl:variable name="d" select="locjs:css_styles_merge_basedon('ParagraphStyle')"/>


		<!-- ==================== -->
		<!-- the character styles -->
		<xsl:for-each select="/Documents/Document/Styles/RootCharacterStyleGroup//CharacterStyle">
			<xsl:variable name="d1" select="locjs:init_styles()"/>
			<xsl:variable name="d2" select="locjs:store_styleType(name())"/>
			<xsl:variable name="d3" select="locjs:store_styleID(string(@Self))"/><!-- @Self="CharacterStyle/$ID/[No character style]" -->
			<xsl:variable name="d4" select="locjs:store_styleName(locjs:plain_Name(string(@Name)))"/><!-- @Name="$ID/[No paragraph style]" -->
			<xsl:variable name="d5" select="locjs:store_styleBasedOn(string(Properties/BasedOn/.))"/>

			<xsl:variable name="self" select="@Self/."/>
			<!--xsl:variable name="d" select="locjs:message(concat('#*#*#*#*#*#*#*#*#*#*#*#*#*#* para style Self: ',$self))"/-->
			<xsl:apply-templates select="/Documents/Document/Styles/RootCharacterStyleGroup//CharacterStyle[@Self = $self]" mode="get_styles"/>


			<xsl:if test="$CSSexpanded = '1'"><!-- enhance with all style attribs -->
				<xsl:for-each select="@*">
					<xsl:variable name="d" select="locjs:store_fullAttribute(string(name()),string(.))"/>
				</xsl:for-each>
			</xsl:if>

			<xsl:variable name="d" select="locjs:css_styles_arr_add_style()"/>
		</xsl:for-each>
		<xsl:variable name="d" select="locjs:css_styles_merge_basedon('CharacterStyle')"/>


		<!-- ==================== -->
		<!-- character helper styles -->
		<xsl:variable name="d" select="locjs:init_styles()"/>
		<xsl:variable name="d" select="locjs:store_styleType('csty')"/>
		<xsl:variable name="d" select="locjs:store_styleID('ccc1')"/>
		<xsl:variable name="d" select="locjs:store_styleName('.C_Notes__')"/>
		<xsl:variable name="d" select="locjs:store_styleAttributesString('display:inline-block; background-color:#ffffc6; color:#000000; font-weight:normal; font-style:normal; text-transform:none; text-align:left; text-indent:0px; margin:0px; padding:0px;')"/>
		<xsl:variable name="d" select="locjs:css_styles_arr_add_style()"/>


		<!-- ==================== -->
		<!-- the table styles -->
		<xsl:for-each select="/Documents/Document/Styles/RootTableStyleGroup//TableStyle">
			<xsl:variable name="TopBorderStrokeType" select="@TopBorderStrokeType"/>
			<xsl:variable name="LeftBorderStrokeType" select="@LeftBorderStrokeType"/>
			<xsl:variable name="BottomBorderStrokeType" select="@BottomBorderStrokeType"/>
			<xsl:variable name="RightBorderStrokeType" select="@RightBorderStrokeType"/>
			<xsl:variable name="TBframestylename" select="substring-after(/Documents/Document/Graphic/StrokeStyle[@Self = $TopBorderStrokeType]/@Name,'$ID/')"/>
			<xsl:variable name="LBframestylename" select="substring-after(/Documents/Document/Graphic/StrokeStyle[@Self = $LeftBorderStrokeType]/@Name,'$ID/')"/>
			<xsl:variable name="BBframestylename" select="substring-after(/Documents/Document/Graphic/StrokeStyle[@Self = $BottomBorderStrokeType]/@Name,'$ID/')"/>
			<xsl:variable name="RBframestylename" select="substring-after(/Documents/Document/Graphic/StrokeStyle[@Self = $RightBorderStrokeType]/@Name,'$ID/')"/>
			<xsl:variable name="TBframestylenameLC" select="locjs:to_lower_case(string($TBframestylename))"/>
			<xsl:variable name="LBframestylenameLC" select="locjs:to_lower_case(string($LBframestylename))"/>
			<xsl:variable name="BBframestylenameLC" select="locjs:to_lower_case(string($BBframestylename))"/>
			<xsl:variable name="RBframestylenameLC" select="locjs:to_lower_case(string($RBframestylename))"/>
			<xsl:variable name="TBframestylehtml">
				<xsl:choose>
					<xsl:when test="contains($TBframestylenameLC,'solid')">solid</xsl:when>
					<xsl:when test="contains($TBframestylenameLC,'thin')">double</xsl:when>
					<xsl:when test="contains($TBframestylenameLC,'thick')">double</xsl:when>
					<xsl:when test="contains($TBframestylenameLC,'dot')">dotted</xsl:when>
					<xsl:when test="contains($TBframestylenameLC,'dash')">dashed</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="LBframestylehtml">
				<xsl:choose>
					<xsl:when test="contains($LBframestylenameLC,'solid')">solid</xsl:when>
					<xsl:when test="contains($LBframestylenameLC,'thin')">double</xsl:when>
					<xsl:when test="contains($LBframestylenameLC,'thick')">double</xsl:when>
					<xsl:when test="contains($LBframestylenameLC,'dot')">dotted</xsl:when>
					<xsl:when test="contains($LBframestylenameLC,'dash')">dashed</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="BBframestylehtml">
				<xsl:choose>
					<xsl:when test="contains($BBframestylenameLC,'solid')">solid</xsl:when>
					<xsl:when test="contains($BBframestylenameLC,'thin')">double</xsl:when>
					<xsl:when test="contains($BBframestylenameLC,'thick')">double</xsl:when>
					<xsl:when test="contains($BBframestylenameLC,'dot')">dotted</xsl:when>
					<xsl:when test="contains($BBframestylenameLC,'dash')">dashed</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="RBframestylehtml">
				<xsl:choose>
					<xsl:when test="contains($RBframestylenameLC,'solid')">solid</xsl:when>
					<xsl:when test="contains($RBframestylenameLC,'thin')">double</xsl:when>
					<xsl:when test="contains($RBframestylenameLC,'thick')">double</xsl:when>
					<xsl:when test="contains($RBframestylenameLC,'dot')">dotted</xsl:when>
					<xsl:when test="contains($RBframestylenameLC,'dash')">dashed</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="d" select="locjs:css_tablestyles_arr_add(
																		string(@Self),
																		string(locjs:plain_Name(string(@Name))),
																		string(Properties/BasedOn/.),
																		string(@BodyRowCount),
																		string(@ColumnCount),
																		string(@LeftBorderStrokeWeight),
																		string(@LeftBorderStrokeColor),
																		string(@RightBorderStrokeWeight),
																		string(@RightBorderStrokeColor),
																		string(@TopBorderStrokeWeight),
																		string(@TopBorderStrokeColor),
																		string(@BottomBorderStrokeWeight),
																		string(@BottomBorderStrokeColor),
																		string(@LeftBorderStrokeTint),
																		string(@RightBorderStrokeTint),
																		string(@TopBorderStrokeTint),
																		string(@BottomBorderStrokeTint),
																		string($TBframestylename),
																		string($TBframestylehtml),
																		string($LBframestylename),
																		string($LBframestylehtml),
																		string($BBframestylename),
																		string($BBframestylehtml),
																		string($RBframestylename),
																		string($RBframestylehtml),
																		string(@StartRowFillColor),
																		string(@StartRowFillTint),
																		string(@EndRowFillColor),
																		string(@EndRowFillTint),
																		string(@SkipFirstAlternatingFillRows),
																		string(@SkipLastAlternatingFillRows),
																		string(@HeaderRowCount),
																		string(@FooterRowCount),
																		string(@StartRowFillCount),
																		string(@EndRowFillCount),
																		locjs:get_rgb_color(string(@FillColor),string(@FillTint))
																		)"/>
		</xsl:for-each>
		<xsl:variable name="d" select="locjs:css_tablestyles_merge_basedon()"/>


		<!-- ==================== -->
		<!-- the cell styles -->
		<xsl:for-each select="/Documents/Document/Styles/RootCellStyleGroup//CellStyle">
			<xsl:variable name="TopEdgeStrokeType" select="@TopEdgeStrokeType"/>
			<xsl:variable name="LeftEdgeStrokeType" select="@LeftEdgeStrokeType"/>
			<xsl:variable name="BottomEdgeStrokeType" select="@BottomEdgeStrokeType"/>
			<xsl:variable name="RightEdgeStrokeType" select="@RightEdgeStrokeType"/>
			<xsl:variable name="TBframestylename" select="substring-after(/Documents/Document/Graphic/StrokeStyle[@Self = $TopEdgeStrokeType]/@Name,'$ID/')"/>
			<xsl:variable name="LBframestylename" select="substring-after(/Documents/Document/Graphic/StrokeStyle[@Self = $LeftEdgeStrokeType]/@Name,'$ID/')"/>
			<xsl:variable name="BBframestylename" select="substring-after(/Documents/Document/Graphic/StrokeStyle[@Self = $BottomEdgeStrokeType]/@Name,'$ID/')"/>
			<xsl:variable name="RBframestylename" select="substring-after(/Documents/Document/Graphic/StrokeStyle[@Self = $RightEdgeStrokeType]/@Name,'$ID/')"/>
			<xsl:variable name="TBframestylenameLC" select="locjs:to_lower_case(string($TBframestylename))"/>
			<xsl:variable name="LBframestylenameLC" select="locjs:to_lower_case(string($LBframestylename))"/>
			<xsl:variable name="BBframestylenameLC" select="locjs:to_lower_case(string($BBframestylename))"/>
			<xsl:variable name="RBframestylenameLC" select="locjs:to_lower_case(string($RBframestylename))"/>
			<xsl:variable name="TBframestylehtml">
				<xsl:choose>
					<xsl:when test="contains($TBframestylenameLC,'solid')">solid</xsl:when>
					<xsl:when test="contains($TBframestylenameLC,'thin')">double</xsl:when>
					<xsl:when test="contains($TBframestylenameLC,'thick')">double</xsl:when>
					<xsl:when test="contains($TBframestylenameLC,'dot')">dotted</xsl:when>
					<xsl:when test="contains($TBframestylenameLC,'dash')">dashed</xsl:when>
					<xsl:otherwise>solid</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="LBframestylehtml">
				<xsl:choose>
					<xsl:when test="contains($LBframestylenameLC,'solid')">solid</xsl:when>
					<xsl:when test="contains($LBframestylenameLC,'thin')">double</xsl:when>
					<xsl:when test="contains($LBframestylenameLC,'thick')">double</xsl:when>
					<xsl:when test="contains($LBframestylenameLC,'dot')">dotted</xsl:when>
					<xsl:when test="contains($LBframestylenameLC,'dash')">dashed</xsl:when>
					<xsl:otherwise>solid</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="BBframestylehtml">
				<xsl:choose>
					<xsl:when test="contains($BBframestylenameLC,'solid')">solid</xsl:when>
					<xsl:when test="contains($BBframestylenameLC,'thin')">double</xsl:when>
					<xsl:when test="contains($BBframestylenameLC,'thick')">double</xsl:when>
					<xsl:when test="contains($BBframestylenameLC,'dot')">dotted</xsl:when>
					<xsl:when test="contains($BBframestylenameLC,'dash')">dashed</xsl:when>
					<xsl:otherwise>solid</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="RBframestylehtml">
				<xsl:choose>
					<xsl:when test="contains($RBframestylenameLC,'solid')">solid</xsl:when>
					<xsl:when test="contains($RBframestylenameLC,'thin')">double</xsl:when>
					<xsl:when test="contains($RBframestylenameLC,'thick')">double</xsl:when>
					<xsl:when test="contains($RBframestylenameLC,'dot')">dotted</xsl:when>
					<xsl:when test="contains($RBframestylenameLC,'dash')">dashed</xsl:when>
					<xsl:otherwise>solid</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="d" select="locjs:css_cellstyles_arr_add(
																		string(@Self),
																		string(locjs:plain_Name(string(@Name))),
																		string(Properties/BasedOn/.),
																		string(@AppliedParagraphStyle),
																		string(@TopInset),
																		string(@LeftInset),
																		string(@BottomInset),
																		string(@RightInset),
																		string(@VerticalJustification),
																		string(@ParagraphSpacingLimit),
																		string(@ClipContentToCell),
																		string(@FirstBaselineOffset),
																		string(@MinimumFirstBaselineOffset),
																		string(@RotationAngle),
																		string(@FillColor),
																		string(@FillTint),
																		locjs:get_rgb_color(string(@FillColor),string(@FillTint)),

																		string(@LeftEdgeStrokeWeight),
																		string(@LeftEdgeStrokeType),
																		string(@LeftEdgeStrokeColor),
																		string(@LeftEdgeStrokeTint),
																		string(@LeftEdgeStrokeGapColor),
																		string(@LeftEdgeStrokeGapTint),
																		locjs:get_rgb_color(string(@LeftEdgeStrokeColor),string(@LeftEdgeStrokeTint)),
																		locjs:get_rgb_color(string(@LeftEdgeStrokeGapColor),string(@LeftEdgeStrokeGapColor)),

																		string(@TopEdgeStrokeWeight),
																		string(@TopEdgeStrokeType),
																		string(@TopEdgeStrokeColor),
																		string(@TopEdgeStrokeTint),
																		string(@TopEdgeStrokeGapColor),
																		string(@TopEdgeStrokeGapTint),
																		locjs:get_rgb_color(string(@TopEdgeStrokeColor),string(@TopEdgeStrokeTint)),
																		locjs:get_rgb_color(string(@TopEdgeStrokeGapColor),string(@TopEdgeStrokeGapColor)),

																		string(@RightEdgeStrokeWeight),
																		string(@RightEdgeStrokeType),
																		string(@RightEdgeStrokeColor),
																		string(@RightEdgeStrokeTint),
																		string(@RightEdgeStrokeGapColor),
																		string(@RightEdgeStrokeGapTint),
																		locjs:get_rgb_color(string(@RightEdgeStrokeColor),string(@RightEdgeStrokeTint)),
																		locjs:get_rgb_color(string(@RightEdgeStrokeGapColor),string(@RightEdgeStrokeGapColor)),

																		string(@BottomEdgeStrokeWeight),
																		string(@BottomEdgeStrokeType),
																		string(@BottomEdgeStrokeColor),
																		string(@BottomEdgeStrokeTint),
																		string(@BottomEdgeStrokeGapColor),
																		string(@BottomEdgeStrokeGapTint),
																		locjs:get_rgb_color(string(@BottomEdgeStrokeColor),string(@BottomEdgeStrokeTint)),
																		locjs:get_rgb_color(string(@BottomEdgeStrokeGapColor),string(@BottomEdgeStrokeGapColor)),

																		string($LBframestylename),
																		string($LBframestylehtml),
																		string($TBframestylename),
																		string($TBframestylehtml),
																		string($RBframestylename),
																		string($RBframestylehtml),
																		string($BBframestylename),
																		string($BBframestylehtml)
																		)"/>
		</xsl:for-each>
		<xsl:variable name="d" select="locjs:css_cellstyles_merge_basedon()"/>



		<!-- ==================== -->
		<!-- other helper styles -->
		<!-- anchored objects -->
		<xsl:variable name="d" select="locjs:init_styles()"/>
		<xsl:variable name="d" select="locjs:store_styleComment('Anchored Objects Styles')"/>
		<xsl:variable name="d" select="locjs:css_styles_arr_add_style()"/>

		<xsl:variable name="d" select="locjs:init_styles()"/>
		<xsl:variable name="d" select="locjs:store_styleType('hsty')"/>
		<xsl:variable name="d" select="locjs:store_styleID('hlp1')"/>
		<xsl:variable name="d" select="locjs:store_styleName('.A_anchored_object__')"/>
		<xsl:variable name="d" select="locjs:store_styleAttributesString('display:inline-block; color:#000000; font-weight:normal; font-style:normal; text-transform:none; text-align:left; text-indent:0px; margin:0px; padding:0px;')"/>
		<xsl:variable name="d" select="locjs:css_styles_arr_add_style()"/>

		<xsl:variable name="d" select="locjs:init_styles()"/>
		<xsl:variable name="d" select="locjs:store_styleType('hsty')"/>
		<xsl:variable name="d" select="locjs:store_styleID('hlp2')"/>
		<xsl:variable name="d" select="locjs:store_styleName('.C_anchored_object__')"/>
		<xsl:variable name="d" select="locjs:store_styleAttributesString('display:inline-block;')"/>
		<xsl:variable name="d" select="locjs:css_styles_arr_add_style()"/>

		<xsl:variable name="d" select="locjs:init_styles()"/>
		<xsl:variable name="d" select="locjs:store_styleType('hsty')"/>
		<xsl:variable name="d" select="locjs:store_styleID('hlp3')"/>
		<xsl:variable name="d" select="locjs:store_styleName('.A_anchored_footnote__')"/>
		<xsl:variable name="d" select="locjs:store_styleAttributesString('cursor:pointer; display:inline-block; vertical-align:super; font-size:75%; color:#000000; font-weight:normal; font-style:normal; text-transform:none; text-align:left; text-indent:0px; margin:0px; padding:0px;')"/>
		<xsl:variable name="d" select="locjs:css_styles_arr_add_style()"/>

		<xsl:variable name="d" select="locjs:init_styles()"/>
		<xsl:variable name="d" select="locjs:store_styleType('hsty')"/>
		<xsl:variable name="d" select="locjs:store_styleID('hlp4')"/>
		<xsl:variable name="d" select="locjs:store_styleName('.A_footnotetext__')"/>
		<xsl:variable name="d" select="locjs:store_styleAttributesString('display:none; color:#000000; font-weight:normal; font-style:normal; text-transform:none; text-align:left; text-indent:0px; margin:0px; padding:0px;')"/>
		<xsl:variable name="d" select="locjs:css_styles_arr_add_style()"/>

		<!-- TOC -->
		<xsl:variable name="d" select="locjs:init_styles()"/>
		<xsl:variable name="d" select="locjs:store_styleType('hsty')"/>
		<xsl:variable name="d" select="locjs:store_styleID('hlp4')"/>
		<xsl:variable name="d" select="locjs:store_styleName('.A_TOCstyleDiv__')"/>
		<xsl:variable name="d" select="locjs:store_styleAttributesString('')"/>
		<xsl:variable name="d" select="locjs:css_styles_arr_add_style()"/>
		<xsl:variable name="d" select="locjs:init_styles()"/>
		<xsl:variable name="d" select="locjs:store_styleType('hsty')"/>
		<xsl:variable name="d" select="locjs:store_styleID('hlp5')"/>
		<xsl:variable name="d" select="locjs:store_styleName('.A_TOCstyle__')"/>
		<xsl:variable name="d" select="locjs:store_styleAttributesString('color:#000000;text-decoration:none;')"/>
		<xsl:variable name="d" select="locjs:css_styles_arr_add_style()"/>
		<xsl:variable name="d" select="locjs:init_styles()"/>
		<xsl:variable name="d" select="locjs:store_styleType('hsty')"/>
		<xsl:variable name="d" select="locjs:store_styleID('hlp6')"/>
		<xsl:variable name="d" select="locjs:store_styleName('.A_TOCstyle__:hover')"/>
		<xsl:variable name="d" select="locjs:store_styleAttributesString('text-decoration:underline;')"/>
		<xsl:variable name="d" select="locjs:css_styles_arr_add_style()"/>

		<!-- defaults -->
		<xsl:variable name="d" select="locjs:store_styleType('hsty')"/>
		<xsl:variable name="d" select="locjs:store_styleID('hlp7')"/>
		<xsl:variable name="d" select="locjs:store_styleName('button')"/>
		<xsl:variable name="d" select="locjs:store_styleAttributesString('-webkit-appearance: none;')"/>
		<xsl:variable name="d" select="locjs:css_styles_arr_add_style()"/>

		<!-- write the css files -->
		<xsl:if test="$cssInstallPathname != ''">
			<xsl:variable name="csswritten" select="locjs:writeCSSfile(string($cssInstallPathname),locjs:get_overwrite_CSS_files())"/>
			<xsl:if test="$csswritten = 'true'">
				<xsl:variable name="m">- '<xsl:value-of select="$thecssname"/>' created.</xsl:variable>
				<xsl:variable name="d" select="myutils:showMess(string($m),'1')"/>
			</xsl:if>
		</xsl:if>

	</xsl:template>



	<xsl:template match="ParagraphStyle" mode="get_styles">
		<!-- xsl:variable name="d" select="locjs:message(concat('          ************** para style Self: ',@Self))"/-->
		<xsl:if test="Properties/BasedOn"><!-- check 'based on' style -->
			<xsl:variable name="basedon">
				<xsl:if test="starts-with(Properties/BasedOn/.,'ParagraphStyle/') = false"><xsl:text>ParagraphStyle/</xsl:text></xsl:if>
				<xsl:value-of select="Properties/BasedOn/."/>
			</xsl:variable>
			<!-- xsl:variable name="d" select="locjs:message(concat('          ############ BasedOn para style Self: ',$basedon))"/-->
			<xsl:apply-templates select="/Documents/Document/Styles/RootParagraphStyleGroup//ParagraphStyle[@Self = $basedon]" mode="get_styles"/>
		</xsl:if>

		<xsl:variable name="d" select="locjs:store_indentLeft(string(@LeftIndent))"/>
		<xsl:variable name="d" select="locjs:store_indentRight(string(@RightIndent))"/>
		<xsl:variable name="d" select="locjs:store_indentFirstLine(string(@FirstLineIndent))"/>
		<xsl:variable name="d" select="locjs:store_spaceBefore(string(@SpaceBefore))"/>
		<xsl:variable name="d" select="locjs:store_spaceAfter(string(@SpaceAfter))"/>
		<xsl:if test="Properties/Leading[@type='unit']"><xsl:variable name="d" select="locjs:store_lineLeading(string(Properties/Leading[@type='unit']/.))"/></xsl:if>
		<xsl:if test="@Justification"><xsl:variable name="d" select="locjs:store_textAlign(string(@Justification))"/></xsl:if>
		<xsl:if test="Properties/AppliedFont">
			<xsl:variable name="main_font_family" select="Properties/AppliedFont/."/>
			<xsl:variable name="d" select="locjs:store_fontFamily(string($main_font_family))"/><!-- like: Times points to /FontFamily/@Name-->
			<xsl:variable name="main_font_style" select="@FontStyle"/><!-- Regular -->
			<xsl:choose>
				<xsl:when test="$main_font_style != ''">
					<xsl:variable name="d" select="locjs:store_fontName(string(/Documents/Document/Fonts/FontFamily[@Name = $main_font_family]/Font[@FontStyleName = $main_font_style]/@Name))"/>
					<xsl:variable name="d" select="locjs:store_fontNamePS(string(/Documents/Document/Fonts/FontFamily[@Name = $main_font_family]/Font[@FontStyleName = $main_font_style]/@PostScriptName))"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="d" select="locjs:store_fontName(string($main_font_family))"/>
					<xsl:variable name="d" select="locjs:store_fontNamePS(string($main_font_family))"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="@PointSize"><xsl:variable name="d" select="locjs:store_fontSize(string(@PointSize))"/></xsl:if>
		<xsl:if test="@FillColor or @FillTint"><xsl:variable name="d" select="locjs:store_fontColor(string(@FillColor),string(@FillTint))"/></xsl:if>
		<xsl:if test="@Capitalization"><xsl:variable name="d" select="locjs:store_textTransform(string(@Capitalization))"/></xsl:if>
		<xsl:if test="@AppliedLanguage"><xsl:variable name="d" select="locjs:store_textLanguage(substring-after(@AppliedLanguage,'$ID/'))"/></xsl:if>
		<xsl:variable name="d" select="locjs:store_characterAttributes(string(@Underline),string(@Position),string(@StrikeThru))"/>
		<xsl:variable name="font_family" select="locjs:to_lower_case(string(Properties/AppliedFont/.))"/>
		<xsl:variable name="weight_style" select="locjs:to_lower_case(string(@FontStyle))"/>
		<xsl:variable name="font_skew" select="string(@Skew)"/>
		<xsl:choose>
			<xsl:when test="locjs:isNumeric(string($weight_style)) = 'true'"><xsl:variable name="d" select="locjs:store_fontWeight(string($weight_style))"/></xsl:when>
			<xsl:when test="contains($weight_style, 'demi')"><xsl:variable name="d" select="locjs:store_fontWeight('bold')"/></xsl:when>
			<xsl:when test="contains($weight_style, 'bold')"><xsl:variable name="d" select="locjs:store_fontWeight('bold')"/></xsl:when>
			<xsl:when test="contains($weight_style, 'black')"><xsl:variable name="d" select="locjs:store_fontWeight('bold')"/></xsl:when>
			<xsl:when test="contains($weight_style, 'roman')"><xsl:variable name="d" select="locjs:store_fontWeight('normal')"/></xsl:when>
			<xsl:when test="contains($weight_style, 'regular')"><xsl:variable name="d" select="locjs:store_fontWeight('normal')"/></xsl:when>
			<xsl:when test="contains($font_family, 'bold')"><xsl:variable name="d" select="locjs:store_fontWeight('bold')"/></xsl:when>
			<xsl:when test="contains($font_family, 'black')"><xsl:variable name="d" select="locjs:store_fontWeight('bold')"/></xsl:when>
			<xsl:when test="contains($font_family, ' demi')"><xsl:variable name="d" select="locjs:store_fontWeight('bold')"/></xsl:when>
			<!--xsl:otherwise><xsl:variable name="d" select="locjs:store_fontWeight('normal')"/></xsl:otherwise-->
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="locjs:isNumeric(string($weight_style)) = 'true'"><xsl:variable name="d" select="locjs:store_fontStyle(string($weight_style))"/></xsl:when>
			<xsl:when test="contains($weight_style, 'italic')"><xsl:variable name="d" select="locjs:store_fontStyle('italic')"/></xsl:when>
			<xsl:when test="contains($weight_style, 'oblique')"><xsl:variable name="d" select="locjs:store_fontStyle('italic')"/></xsl:when>
			<xsl:when test="contains($font_family, 'italic')"><xsl:variable name="d" select="locjs:store_fontStyle('italic')"/></xsl:when>
			<xsl:when test="contains($font_family, 'oblique')"><xsl:variable name="d" select="locjs:store_fontStyle('italic')"/></xsl:when>
			<xsl:when test="($font_skew != '') and ($font_skew != '0')"><xsl:variable name="d" select="locjs:store_fontStyle('italic')"/></xsl:when>
			<!--xsl:otherwise><xsl:variable name="d" select="locjs:store_fontStyle('normal')"/></xsl:otherwise-->
		</xsl:choose>
	</xsl:template>


	<xsl:template match="CharacterStyle" mode="get_styles">
		<xsl:if test="Properties/BasedOn"><!-- check 'based on' style -->
			<xsl:variable name="basedon">
				<xsl:if test="starts-with(Properties/BasedOn/.,'CharacterStyle/') = false"><xsl:text>CharacterStyle/</xsl:text></xsl:if>
				<xsl:value-of select="Properties/BasedOn/."/>
			</xsl:variable>
			<!-- xsl:variable name="d" select="locjs:message(concat('          ############ BasedOn char style Self: ',$basedon))"/-->
			<xsl:apply-templates select="/Documents/Document/Styles/RootCharacterStyleGroup//CharacterStyle[@Name = $basedon]" mode="get_styles"/>
		</xsl:if>

		<xsl:if test="Properties/AppliedFont">
			<xsl:variable name="d" select="locjs:store_fontFamily(string(Properties/AppliedFont/.))"/>
			<xsl:variable name="main_font_family" select="Properties/AppliedFont/."/>
			<xsl:variable name="main_font_style" select="@FontStyle"/>
			<xsl:choose>
				<xsl:when test="$main_font_style != ''">
					<xsl:variable name="d" select="locjs:store_fontName(string(/Documents/Document/Fonts/FontFamily[@Name = $main_font_family]/Font[@FontStyleName = $main_font_style]/@Name))"/>
					<xsl:variable name="d" select="locjs:store_fontNamePS(string(/Documents/Document/Fonts/FontFamily[@Name = $main_font_family]/Font[@FontStyleName = $main_font_style]/@PostScriptName))"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="d" select="locjs:store_fontName(string($main_font_family))"/>
					<xsl:variable name="d" select="locjs:store_fontNamePS(string($main_font_family))"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>

		<xsl:if test="Properties/Leading[@type='unit']"><xsl:variable name="d" select="locjs:store_lineLeading(string(Properties/Leading[@type='unit']/.))"/></xsl:if>
		<xsl:if test="@PointSize"><xsl:variable name="d" select="locjs:store_fontSize(string(@PointSize))"/></xsl:if>
		<xsl:if test="@FillColor or @FillTint"><xsl:variable name="d" select="locjs:store_fontColor(string(@FillColor),string(@FillTint))"/></xsl:if>
		<xsl:if test="@Capitalization"><xsl:variable name="d" select="locjs:store_textTransform(string(@Capitalization))"/></xsl:if>
		<xsl:variable name="d" select="locjs:store_characterAttributes(string(@Underline),string(@Position),string(@StrikeThru))"/>
		<xsl:variable name="font_family" select="locjs:to_lower_case(string(Properties/AppliedFont/.))"/>
		<xsl:variable name="weight_style" select="locjs:to_lower_case(string(@FontStyle))"/>
		<xsl:variable name="font_skew" select="string(@Skew)"/>
		<xsl:choose>
			<xsl:when test="locjs:isNumeric(string($weight_style)) = 'true'"><xsl:variable name="d" select="locjs:store_fontWeight(string($weight_style))"/></xsl:when>
			<xsl:when test="contains($weight_style, 'demi')"><xsl:variable name="d" select="locjs:store_fontWeight('bold')"/></xsl:when>
			<xsl:when test="contains($weight_style, 'bold')"><xsl:variable name="d" select="locjs:store_fontWeight('bold')"/></xsl:when>
			<xsl:when test="contains($weight_style, 'black')"><xsl:variable name="d" select="locjs:store_fontWeight('bold')"/></xsl:when>
			<xsl:when test="contains($font_family, 'bold')"><xsl:variable name="d" select="locjs:store_fontWeight('bold')"/></xsl:when>
			<xsl:when test="contains($font_family, 'black')"><xsl:variable name="d" select="locjs:store_fontWeight('bold')"/></xsl:when>
			<xsl:when test="contains($font_family, ' demi')"><xsl:variable name="d" select="locjs:store_fontWeight('bold')"/></xsl:when>
			<!--xsl:otherwise><xsl:variable name="d" select="locjs:store_fontWeight('normal')"/></xsl:otherwise-->
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="locjs:isNumeric(string($weight_style)) = 'true'"><xsl:variable name="d" select="locjs:store_fontStyle(string($weight_style))"/></xsl:when>
			<xsl:when test="contains($weight_style, 'italic')"><xsl:variable name="d" select="locjs:store_fontStyle('italic')"/></xsl:when>
			<xsl:when test="contains($weight_style, 'oblique')"><xsl:variable name="d" select="locjs:store_fontStyle('italic')"/></xsl:when>
			<xsl:when test="contains($font_family, 'italic')"><xsl:variable name="d" select="locjs:store_fontStyle('italic')"/></xsl:when>
			<xsl:when test="contains($font_family, 'oblique')"><xsl:variable name="d" select="locjs:store_fontStyle('italic')"/></xsl:when>
			<xsl:when test="($font_skew != '') and ($font_skew != '0')"><xsl:variable name="d" select="locjs:store_fontStyle('italic')"/></xsl:when>
			<!--xsl:otherwise><xsl:variable name="d" select="locjs:store_fontStyle('normal')"/></xsl:otherwise-->
		</xsl:choose>
	</xsl:template>



	<!-- fill this template to write a dedicated css writer. or leave it empty ***but do not delete this template -->
	<xsl:template name="custom_css_writer">
	</xsl:template>



</xsl:stylesheet>
