<?xml version="1.0" encoding="UTF-8"?>
<!-- 
 ======================================================================
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.

THE PRODUCER:
Andreas Imhof
ai@aiedv.ch

Version: 46
Version date: 20200219
======================================================================
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
				xmlns:lxslt="http://xml.apache.org/xslt"
				xmlns:xalan="http://xml.apache.org/xalan" 
				xmlns:myutils="com.epaperarchives.batchxslt.utils"
				xmlns:locjs="loc_funcs"

				exclude-result-prefixes="xalan lxslt myutils locjs"
				version="1.0">

	<xsl:param name="delete_individual_bookpagesXML" select="1"/><!--  default = 1, delete all indivial pages XML files of a book after having merged them, 0 = don't delete -->
	<xsl:param name="delete_individual_bookpagesHTM" select="1"/><!--  default = 1, delete all indivial pages HTM files of a book after merge, 0 = don't delete -->

	<xsl:output method="xml" />
	<xsl:output media-type="text/xml"/>
	<xsl:output omit-xml-declaration="no"/>

<!--xsl:output xalan:indent-amount="0"/-->
	<xsl:output indent="yes"/>
	<xsl:output encoding="UTF-8"/>


	<!-- *********** general used variables ********** -->
	<xsl:variable name="outpath" select="indbbookindex/exportpath_out/."/>

	<!-- *********** templates for the 'bookxxxxx.indb.xmi' ********** -->
	<xsl:template match="/">
		<xsl:variable name="d1" select="myutils:showMess(concat('&#10;   - Merging page XML files at path: ',$outpath,'&#10;'),'1')"/>

		<xsl:variable name="bookindex_filename" select="indbbookindex/filename/."/>
		<xsl:variable name="merged_book_filename" select="locjs:create_new_nameextension(string($bookindex_filename), '.xml')"/>
		<xsl:variable name="book_filename" select="indbbookindex/book/name/."/>

		<xsl:text disable-output-escaping="yes">&#10;</xsl:text>
		<xsl:comment>
Book output path:<xsl:value-of select="$outpath"/>
Book name:<xsl:value-of select="$bookindex_filename"/>
		</xsl:comment>
		<xsl:text disable-output-escaping="yes">&#10;</xsl:text>
		
		<!-- get head of first xml document -->
		<xsl:variable name="firstxmlpathname" select="concat($outpath,'/',indbbookindex/bookdocs/doc/docbookxml/.)"/>
		<xsl:variable name="firstxmldocument" select="document($firstxmlpathname)" />
		<xsl:processing-instruction name="xml-stylesheet">
			<xsl:value-of select="xalan:nodeset($firstxmldocument)/processing-instruction('xml-stylesheet')/."/>
		</xsl:processing-instruction>
		<xsl:text disable-output-escaping="yes">&#10;</xsl:text>

		<xsl:variable name="d" select="locjs:init_offsets()"/><!-- init */page_sequence attr counter -->

		<indd_document>
			<xsl:for-each select="xalan:nodeset($firstxmldocument)/indd_document/@*">
				<xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>
			</xsl:for-each>
			<!-- copy call_parameters -->
			<call_parameters>
				<xsl:for-each select="xalan:nodeset($firstxmldocument)/indd_document/call_parameters/par">
					<xsl:variable name="cont" select="."/>
					<xsl:element name="{name()}">
						<xsl:for-each select="@*">
							<xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>
						</xsl:for-each>
						<xsl:value-of select="$cont" />
					</xsl:element>
				</xsl:for-each>
			</call_parameters>

			<xsl:copy-of select="xalan:nodeset($firstxmldocument)/indd_document/doctypeinfos"/>

			<!-- copy header -->
			<header>
				<xsl:for-each select="xalan:nodeset($firstxmldocument)/indd_document/header/@*">
					<xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>
				</xsl:for-each>
				<xsl:for-each select="xalan:nodeset($firstxmldocument)/indd_document/header/headerfield">
					<xsl:variable name="cont" select="."/>
					<xsl:element name="{name()}">
						<xsl:for-each select="@*">
							<xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>
						</xsl:for-each>
						<xsl:choose>
							<xsl:when test="@name = 'filename'">
								<xsl:value-of select="$merged_book_filename" /><!-- is our resulting merged book xml file -->
							</xsl:when>
							<xsl:when test="@name = 'indesignDocname'">
								<xsl:value-of select="$book_filename" /><!-- is our book file -->
							</xsl:when>
							<xsl:when test="@name = 'sourceINXfileName'">
								<xsl:value-of select="$bookindex_filename" /><!-- is our book index file -->
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$cont" />
							</xsl:otherwise>
						</xsl:choose>
					</xsl:element>
				</xsl:for-each>
			</header>

			<!-- add all merged files -->
			<bookfiles>
				<xsl:for-each select="indbbookindex/bookdocs/doc">
					<!-- xsl:sort data-type="number" select="page/."/ --><!-- sort by page number -->
					<xsl:sort data-type="number" select="@idx"/><!-- sort by doc idx -->
					<file><name><xsl:value-of select="docbookxml/."/></name><page><xsl:value-of select="page/."/></page></file>
				</xsl:for-each>
			</bookfiles>

			<!-- get all pages of all xml documents -->
			<xsl:for-each select="indbbookindex/bookdocs/doc">
				<!-- xsl:sort data-type="number" select="locjs:parse_int(string(page/.))"/--><!-- sort by page number -->
				<xsl:sort data-type="number" select="@idx"/><!-- sort by doc idx -->
				<xsl:call-template name="get_pages"/>
				<!-- update page_sequence offsets and article idx offsets for next docment -->
				<xsl:variable name="d" select="locjs:update_offsets()"/>
			</xsl:for-each>

			<xsl:copy-of select="xalan:nodeset($firstxmldocument)/indd_document/layers"/>
		</indd_document>
	</xsl:template>



	<xsl:template name="get_pages">
		<!-- file paths must be url decoded to check if it exists
			but must be opened url encoded -->
		<xsl:variable name="xmlpathnameDecoded" select="locjs:decode_URI(concat($outpath,'/',docbookxml/.))"/>
		<xsl:variable name="xmlpathname" select="concat($outpath,'/',docbookxml/.)"/>
		<xsl:variable name="exists" select="myutils:existsFile(string($xmlpathnameDecoded))"/>
		<xsl:variable name="d1" select="myutils:showMess(concat('      - Merging file: ',$xmlpathnameDecoded,'&#10;'),'1')"/>
		<xsl:choose>
			<xsl:when test="($exists = true())">
				<xsl:variable name="xmldocument" select="document($xmlpathname)" />
				<xsl:text disable-output-escaping="yes">&#10;</xsl:text><xsl:comment>*******************************************</xsl:comment><xsl:text disable-output-escaping="yes">&#10;</xsl:text>
				<xsl:comment>*** Include document XML file <xsl:value-of select="position()"/>: <xsl:value-of select="$xmlpathname"/></xsl:comment><xsl:text disable-output-escaping="yes">&#10;</xsl:text>
				<xsl:for-each select="xalan:nodeset($xmldocument)/indd_document/page">
					<xsl:variable name="page_sequence" select="locjs:get_new_page_sequence(string(@page_sequence))"/>
					<xsl:comment>*** page sequence offset: <xsl:value-of select="locjs:get_page_sequence_offset()"/> - new page sequence: <xsl:value-of select="$page_sequence"/> -  articles offset: <xsl:value-of select="locjs:get_article_idx_offset()"/></xsl:comment>

					<page>
						<xsl:for-each select="@*">
							<!-- store aside original attributes -->
							<xsl:choose>
								<xsl:when test="name() = 'Self'">
									<xsl:attribute name="Self_orig">
										<xsl:value-of select="."/>
									</xsl:attribute>
								</xsl:when>
								<xsl:when test="name() = 'page_sequence'">
									<xsl:attribute name="page_sequence_orig">
										<xsl:value-of select="."/>
									</xsl:attribute>
								</xsl:when>
								<xsl:when test="name() = 'page_name'">
									<xsl:attribute name="page_name_orig">
										<xsl:value-of select="."/>
									</xsl:attribute>
								</xsl:when>
							</xsl:choose>
							<!-- now make new modified  attributes -->
							<xsl:attribute name="{name()}">
								<xsl:choose>
									<xsl:when test="name() = 'Self'">
										<xsl:value-of select="."/>_<xsl:value-of select="$page_sequence"/>
									</xsl:when>
									<xsl:when test="name() = 'page_sequence'">
										<xsl:value-of select="$page_sequence"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="."/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
						</xsl:for-each>
						<xsl:apply-templates mode="copyelement">
							<xsl:with-param name="page_sequence"><xsl:value-of select="$page_sequence"/></xsl:with-param>
						</xsl:apply-templates>
					</page>

				</xsl:for-each>
				<!-- evtl. delete merged individual book document files -->
				<xsl:if test="$delete_individual_bookpagesXML != '0'">
					<xsl:variable name="d" select="myutils:deleteFile(string($xmlpathnameDecoded))"/>
				</xsl:if>
				<xsl:if test="$delete_individual_bookpagesHTM != '0'">
					<xsl:variable name="htmfile" select="locjs:create_new_nameextension($xmlpathnameDecoded, '.htm')"/>
					<xsl:variable name="d" select="myutils:deleteFile(string($htmfile))"/>
				</xsl:if>

			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="d1" select="myutils:showMess(concat('#### FATAL ERROR. Missing path/file: ',$xmlpathname,'&#10;'),'1')"/>
				<ErrorDocument>
					<ErrorText>#### FATAL ERROR. Missing path/file</ErrorText>
					<ErrorPathFile><xsl:value-of select="$xmlpathname"/>"</ErrorPathFile>
				</ErrorDocument>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template match="* | @* | processing-instruction() | text() | comment()" mode="copyelement">
		<xsl:param name="page_sequence"/>
		<xsl:choose>
			<xsl:when test="name() ='page_sequence'"><!-- update page sequences -->
				<xsl:attribute name="{name()}"><xsl:value-of select="locjs:get_new_page_sequence(string(.))"/></xsl:attribute>
				<xsl:attribute name="page_sequence_orig"><!-- store original page_sequence -->
					<xsl:value-of select="."/>
				</xsl:attribute>
			</xsl:when>
			<xsl:when test="(name() = 'continuedpage') or (name() = 'previouspage')">
				<xsl:attribute name="{name()}"><xsl:value-of select="locjs:get_new_page_sequence_reference(string(.))"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="name() ='idx'"><!-- update article idx -->
				<xsl:attribute name="{name()}"><xsl:value-of select="locjs:get_new_article_idx(string(.))"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="(name() ='continuedid') or (name() ='previousid')">
				<xsl:attribute name="{name()}"><xsl:value-of select="locjs:get_new_article_idx_reference(string(.))"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="(name() ='parent_storyid') or (name() ='continuedframe') or (name() ='previousframe') or (name() ='label')"><!-- update story, previous and next frame pointers --> 
				<xsl:attribute name="{name()}"><xsl:value-of select="locjs:update_story_pointers(string(.))"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="* | @* | processing-instruction() | text() | comment()" mode="copyelement">
						<xsl:with-param name="page_sequence"><xsl:value-of select="$page_sequence"/></xsl:with-param>
					</xsl:apply-templates>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>



	<!-- =========================
		 our local JAVA Script functions
		 ========================= -->
	<lxslt:component prefix="locjs">
	<lxslt:script lang="javascript">
	//<![CDATA[
var page_sequence_offset = 0;
var page_count_document = 0;
var article_idx_offset = 0;
var article_count_document = 0;
function init_offsets() {
	page_sequence_offset = 0;
	page_count_document = 0;
	article_idx_offset = 0;
	article_idx_document = 0;
}
function update_offsets() {
	page_sequence_offset += page_count_document;
	page_count_document = 0;
	article_idx_offset += article_idx_document + 1;
	article_idx_document = 0;
}
function get_page_sequence_offset() {
	return(page_sequence_offset);
}
function get_new_page_sequence(orig_page_sequence) {
	if ((orig_page_sequence == null) || (orig_page_sequence == "")) return "";
	var cur_page_sequence = parseInt(orig_page_sequence);
	page_count_document = cur_page_sequence;
	return(page_sequence_offset + page_count_document);
}
function get_new_page_sequence_reference(orig_page_sequence) {
	if ((orig_page_sequence == null) || (orig_page_sequence == "")) return "";
	var the_page_sequence = parseInt(orig_page_sequence);
	return(page_sequence_offset + the_page_sequence);
}

function get_new_article_idx(orig_article_idx) {
	if ((orig_article_idx == null) || (orig_article_idx == "")) return "";
	var cur_article_idx = parseInt(orig_article_idx);
	article_idx_document = cur_article_idx;
	return(article_idx_offset + article_idx_document);
}
function get_new_article_idx_reference(orig_article_idx) {
	if ((orig_article_idx == null) || (orig_article_idx == "")) return "";
	var the_article_idx = parseInt(orig_article_idx);
	return(article_idx_offset + the_article_idx);
}
function get_article_idx_offset() {
	return(article_idx_offset);
}

function update_story_pointers(str) {
	if ((str == null) || (str == "")) return "";
	var re = null,
		newstr = str;

	// search "prnt54826:" and add the page_sequence offset: "prnt54826_21:"
	re = /(prnt\d\d\d*?):/g;
	newstr = newstr.replace(re,"$1" + "_" + page_sequence_offset + ":");

	// search "tf54826:" | "pf54826:" | "nf54826:" and add the page_sequence offset: "tf54826_21:" | "pf54826_21:" | "nf54826_21:"
	re = /([tpn]f\d\d\d*?):/g;
	newstr = newstr.replace(re,"$1" + "_" + page_sequence_offset + ":");

	return(newstr);
}


function parse_int(str) {
	if ((str == null) || (str == "")) return(str);
	var val;
	try {
		val = parseInt(str);
	}
	catch(e) { return(str); }
	return(val);
}

function create_new_nameextension(filename, newext) {
	if ((newext == null) || (newext == "")) return(filename);
	var pos = filename.lastIndexOf(".");	// cut filename extension
	var name = filename.substr(0,pos);
	return (name + newext);
}

function decode_URI(name) {
	return(decodeURI(name));
}
	//]]>
	</lxslt:script>
	</lxslt:component>


</xsl:stylesheet>
